# -*- coding: utf-8 -*-
"""
/***************************************************************************
 VerificarSobreposicao
                                 A QGIS plugin
 Verifica sobreposição de feição
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-08-05
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Annacezio de Brito
        email                : cesardb54@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .Verificar_Sobreposicao_dialog import VerificarSobreposicaoDialog
import os.path

from qgis.utils import iface
from qgis.core import (
    QgsProject,
    QgsVectorLayer,
    QgsFeature,
    QgsGeometry,
    QgsField,
    QgsFeatureRequest,
    QgsVectorFileWriter
)
from PyQt5.QtCore import QVariant


class VerificarSobreposicao:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'VerificarSobreposicao_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Verificar_Sobreposicao')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('VerificarSobreposicao', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/Verificar_Sobreposicao/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Verificar_Sobreposicao'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Verificar_Sobreposicao'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/Verificar_Sobreposicao/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Verificar_Sobreposicao'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Verificar_Sobreposicao'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        # Pegar a camada ativa
        layer = iface.activeLayer()
        if not layer or not layer.isValid():
            print("Nenhuma camada ativa válida encontrada!")
        else:
            print("Camada ativa carregada com sucesso!")

            # Criar uma nova camada para as sobreposições
            crs = layer.crs().toWkt()
            overlay_layer = QgsVectorLayer(f"Polygon?crs={crs}", "sobreposicao", "memory")
            overlay_provider = overlay_layer.dataProvider()

            # Adicionar campos à nova camada
            overlay_provider.addAttributes([QgsField("ID_1", QVariant.Int), QgsField("ID_2", QVariant.Int)])
            overlay_layer.updateFields()

            # Identificar sobreposições
            features = list(layer.getFeatures())
            for i, feat1 in enumerate(features):
                for feat2 in features[i + 1:]:
                    geom1 = feat1.geometry()
                    geom2 = feat2.geometry()
                    if geom1.intersects(geom2):
                        intersection = geom1.intersection(geom2)
                        if not intersection.isEmpty():
                            new_feat = QgsFeature()
                            new_feat.setGeometry(intersection)
                            new_feat.setAttributes([feat1.id(), feat2.id()])
                            overlay_provider.addFeatures([new_feat])

            # Adicionar a nova camada ao projeto
            QgsProject.instance().addMapLayer(overlay_layer)

            # Exportar a nova camada como shapefile
        #    output_path = "caminho/para/salvar/sobreposicoes.shp"  # Atualize o caminho para salvar
        #    QgsVectorFileWriter.writeAsVectorFormat(overlay_layer, output_path, "UTF-8", overlay_layer.crs(), "ESRI Shapefile")
            print(f"Sobreposições exportadas")