# -*- coding: utf-8 -*-
"""
/***************************************************************************
 VectorToDBLoader
                                 A QGIS plugin
 Loads Vector Themes to Databases
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-12-27
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Roger Merritt / Spatial Tapestry
        email                : roger@SpatialTapesry.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         #
# Copyright
# Spatial Tapestry
# All rights reserved
#
# This program is released under the terms of the included 
# LICENSE file for more information.
#
 ***************************************************************************/

# An "illegal" identifier has to be quoted in Postgres (and SQL).
# The function format() has a special place holder for identifiers and will return a quoted identifier
# if anything is non-standard:
# So select format('%I', 'foo') returns foo.
# But select format('%I', 'foo bar') returns "foo bar"

Some Postgres code to get started with (PGADMIN4):
CREATE DATABASE gisdb WITH OWNER = postgres ENCODING = 'UTF8' TABLESPACE = pg_default CONNECTION LIMIT = 300;
CREATE ROLE rogermsu LOGIN PASSWORD 'rogermsu' SUPERUSER INHERIT CREATEDB CREATEROLE NOREPLICATION;
CREATE SCHEMA testdata AUTHORIZATION rogermsu;

Some Oracle code to get started with (SQL Developer)
Note: With Oracle each user has their own schema
Enter user-name: system
Enter password:
Last Successful login time: Wed Jan 10 2024 14:33:56 +08:00
Connected to:
Oracle Database 21c Express Edition Release 21.0.0.0.0 - Production
Version 21.3.0.0.0
SQL> create user drrog identified by drrog;
create user drrog identified by drrog
            *
ERROR at line 1:
ORA-65096: invalid common user or role name
SQL> alter session set "_ORACLE_SCRIPT"=true;
Session altered.
SQL> create user drrog identified by drrog;
User created.
SQL>
-- USER SQL
CREATE USER "drrog" IDENTIFIED BY "drrog"  ;
-- ROLES
GRANT "CONNECT" TO "DRROG" ;
GRANT "DBA" TO "DRROG" ;
-- SYSTEM PRIVILEGES
GRANT ALTER ANY TABLE TO "DRROG" ;
GRANT DROP ANY TABLE TO "DRROG" ;
GRANT INSERT ANY TABLE TO "DRROG" ;
GRANT CREATE ANY TABLE TO "DRROG" ;



pip install -U psycopg2
pip install -U oracledb
pip install -U pyodbc
https://docs.devart.com/odbc/sqlserver/using_odbc_driver.htm
sudo apt-get install odbcinst1debian2 libodbc1 odbcinst unixodbc
https://www.devart.com/odbc/sqlserver/download.html
https://docs.devart.com/odbc/sqlserver/configuring_odbc_dsn_on_linux.htm
grant permissions to the user


On Windows:
PYTHONPATH
C:\Program Files\QGIS 3.34.1\apps\qgis\python;C:\Program Files\QGIS 3.34.1\apps\qgis\python\plugins;C:\Program Files\QGIS 3.34.1\apps\Qt5\plugins;C:\Program Files\QGIS 3.34.1\share\gdal;


 """
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from PyQt5.QtWidgets import *

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .VectorToDBLoader_dialog import VectorToDBLoaderDialog
import os
import os.path

import datetime

from qgis.core import *
from qgis.gui import *
from qgis.utils import *

import psycopg2
connPGS: psycopg2
import oracledb
connORA: oracledb
import pyodbc
connDEV: pyodbc

z3 = "000"
myGBL = {}

class VectorToDBLoader:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'VectorToDBLoader_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&VectorToDBLoader')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('VectorToDBLoader', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToVectorMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/vectortodbloader/resources/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Vector to DB Loader Free'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginVectorMenu(
                self.tr(u'&VectorToDBLoader'),
                action)
            self.iface.removeToolBarIcon(action)

    def c1c(self):
        try:
            f1f(self)
        except Exception as err:
            self.iface.messageBar().pushMessage(
            "Failure", err,
            level=Qgis.Success, duration=3)


    def k1k(self):
        x1x(self)
        try:
            sqlStr = "create table testtable(stid NUMBER Primary Key, firstname VARCHAR2(20) NOT NULL)"
            if myGBL['n2n'] == "PGS":
                connPGS = i2i(**myGBL)
                cursor = connPGS.cursor()
                cursor.execute(sqlStr.replace("NUMBER","INTEGER").replace("CHAR2","CHAR"))
                self.iface.messageBar().pushMessage(
                    "Success", myGBL['n2n'] + " create table called",
                    level=Qgis.Success, duration=10)

            if myGBL['n2n'] == "ORA":
                connORA = j2j(**myGBL)
                cursor = connORA.cursor()
                cursor.execute(sqlStr)
                self.iface.messageBar().pushMessage(
                    "Success", myGBL['n2n'] + " create table called",
                    level=Qgis.Success, duration=10)

            if myGBL['n2n'] == "ORD":
                connDEV = k2k(**myGBL)
                cursor = connORA.cursor()
                cursor.execute(sqlStr)
                self.iface.messageBar().pushMessage(
                    "Success", myGBL['n2n'] + " create table called",
                    level=Qgis.Success, duration=10)

            if myGBL['n2n'] == "MSS":
                connDEV = l2l(**myGBL)
                cursor = connDEV.cursor()
                cursor.execute(sqlStr)
                self.iface.messageBar().pushMessage(
                    "Success", myGBL['n2n'] + " create table called",
                    level=Qgis.Success, duration=10)

            f1f(self)

            self.iface.messageBar().pushMessage(
                "Success", myGBL['n2n'] + "_TestDB pressed ",
                level=Qgis.Success, duration=3)
        except Exception as err:
            error_obj = err.args
            self.iface.messageBar().pushMessage(
            "Failure " + str(error_obj), err,
            level=Qgis.Success, duration=13)

    def a1a(self):
        try:
            n2n = myGBL['n2n']
            o2o = myGBL['o2o']
            if o2o == "Serv" or o2o == "Both":
                if myGBL['n2n'] == "PGS":
                    connPGS = i2i(**myGBL)
                if myGBL['n2n'] == "ORA":
                    connOra = j2j(**myGBL)
                if myGBL['n2n'] == "ORD":
                    connOrD = k2k(**myGBL)
                if myGBL['n2n'] == "MSS":
                    connDEV = l2l(**myGBL)
            t1t = os.path.expanduser( '~' ) + "/log._DeleteThemeReport"
            with open(t1t, 'w') as log_file:
                log_file.close
            with open(os.path.expanduser( '~' ) + "/sql._DeleteThemeReport", 'w') as delete_file:
                for o3o in iface.layerTreeView().selectedLayers():
                    svl:QgsVectorLayer
                    svl = o3o
                    svlname = svl.name().lower()
                    if o3o.type() == QgsMapLayer.VectorLayer:
                        layers = QgsProject.instance().mapLayers().values()
                        for layer in layers:
                            vl:QgsVectorLayer
                            vl = layer
                            vlname = vl.name().lower()
                            if layer.type() != QgsMapLayer.VectorLayer:
                                continue
                            elif vlname == svlname:
                                n3n = vl.name().lower().replace(".","_")
                                if n2n == "PGS":
                                    n3n = myGBL['PG_Schema'] + "." + n3n
                                sqlStr = "DROP TABLE " + n3n
                                if o2o == "File" or o2o == "Both":
                                    delete_file.write(sqlStr + ";" + '\n')
                                if o2o == "Serv" or o2o == "Both":
                                    if n2n == "PGS":
                                        e2e(sqlStr, connPGS, t1t)
                                    elif n2n == "ORA":
                                        f2f(sqlStr, connOra, t1t)
                                    elif n2n == "ORD":
                                        g2g(sqlStr, connOrD, t1t)
                                    elif n2n == "MSS":
                                        h2h(sqlStr, connDEV, t1t)
                delete_file.close

        except Exception as err:
            self.iface.messageBar().pushMessage("FailureX", err, level=Qgis.Success, duration=3)
            return False
       
    def b1b(self):
        try:
            xyz = "ll"
            with open(os.path.expanduser( '~' ) + "/log._ImportThemeReport", 'w') as report_file:
                report_file.close
            wxy = "i"
            whatIsGoingOn("Selected Themes are:")
            for o3o in iface.layerTreeView().selectedLayers():
                svl:QgsVectorLayer
                svl = o3o
                svlname = svl.name().lower()
                whatIsGoingOn(svlname)
            xyz  = wxy + xyz + wxy + "on"
            whatIsGoingOn("End Selected Themes List\n")

            abc = self.dlg.a44.text().replace("("," ").replace(")"," ").replace(" mi" + xyz, z3 + z3).split(" ")
            whatIsGoingOn("Max Record Count per theme: " + abc[3])
            whatIsGoingOn("DB Type : " + myGBL['n2n'])
            whatIsGoingOn("Host:     " + self.dlg.PG_IPAddress.text())
            whatIsGoingOn("Database: " + self.dlg.PG_DBName.text())
            whatIsGoingOn("Port:     " + self.dlg.PG_Port.text())
            whatIsGoingOn("Schema:   " + self.dlg.a4x.text() + "\n")


            for o3o in iface.layerTreeView().selectedLayers():
                svl:QgsVectorLayer
                svl = o3o
                svlname = svl.name().lower()

                if o3o.type() == QgsMapLayer.VectorLayer:
                    layers = QgsProject.instance().mapLayers().values()
                    gotit = False
                    for layer in layers:
                        vl:QgsVectorLayer
                        vl = layer
                        vlname = vl.name().lower()
                        # report_file.write("Looking at Theme " + vlname + '\n')
                        if layer.type() != QgsMapLayer.VectorLayer:
                            # Ignore this layer as it's not a vector
                            continue
                        elif layer.featureCount() == 0:
                            # There are no features - skip
                            continue
                        elif vlname == svlname:
                            # report_file.write("Got a match Sel Theme " + svlname + " " + vlname + '\n')
                            gotit = True
                            l1l(self, layer, **myGBL)

            wT = self.dlg.windowTitle()
            if "_Fr" in wT:
                QMessageBox.information(None,"Finished Processing...","Remember you can get an Unlimited Version at\nhttps://gismart.net/stores/spatialtapestry/", QMessageBox.Ok, QMessageBox.Ok)

        except Exception as err:
            self.iface.messageBar().pushMessage("Failure", err, level=Qgis.Success, duration=3)
            return False

    def i1i(self):
        myGBL.update({'n2n': "PGS"}) 
        myGBL.update({'ConFileName': os.path.expanduser( '~' ) + '/PGS_ST_SDL.Config'}) 
        self.dlg.a41.setText(myGBL['n2n'] + " and " + myGBL['o2o']) 
        m1m(self)

    def j1j(self):
        myGBL.update({'n2n': "ORA"}) 
        myGBL.update({'ConFileName': os.path.expanduser( '~' ) + '/ORA_ST_SDL.Config'}) 
        self.dlg.a41.setText(myGBL['n2n'] + " and " + myGBL['o2o']) 
        m1m(self)

    def d1d(self):
        myGBL.update({'n2n': "ORD"}) 
        myGBL.update({'ConFileName': os.path.expanduser( '~' ) + '/ORD_ST_SDL.Config'}) 
        self.dlg.a41.setText(myGBL['n2n'] + " and " + myGBL['o2o']) 
        m1m(self)

    def n1n(self):
        myGBL.update({'n2n': "MSS"}) 
        myGBL.update({'ConFileName': os.path.expanduser( '~' ) + '/MSS_ST_SDL.Config'}) 
        self.dlg.a41.setText(myGBL['n2n'] + " and " + myGBL['o2o']) 
        m1m(self)
    
    def w1w(self):
        if not self.dlg.v1v.isChecked() and not self.dlg.u1u.isChecked():
            self.dlg.v1v.setChecked(True)
            myGBL.update({'o2o': "File"}) 
        if self.dlg.v1v.isChecked() and not self.dlg.u1u.isChecked():
            myGBL.update({'o2o': "File"}) 
        elif not self.dlg.v1v.isChecked() and self.dlg.u1u.isChecked():
            myGBL.update({'o2o': "Serv"}) 
        elif self.dlg.v1v.isChecked() and self.dlg.u1u.isChecked():
            myGBL.update({'o2o': "Both"}) 
        self.dlg.a41.setText(myGBL['n2n'] + " and " + myGBL['o2o']) 
        self.dlg.h1h.setText("Process the QGIS Selected Themes to " + myGBL['o2o'])
        self.dlg.e1e.setText("Delete the QGIS Selected Themes from " + myGBL['o2o'])

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False

            with open("log.WhatIsGoingOn", 'w') as outSQL_file:
                outSQL_file.write("Look here for a running report on what is happening inside this PlugIn\n")
            outSQL_file.close

            myGBL.update({'ConFileName': os.path.expanduser( '~' ) + '/PGS_ST_SDL.Config'}) 
            self.dlg = VectorToDBLoaderDialog()
            self.dlg.g1g.clicked.connect(self.c1c)
            self.dlg.h1h.clicked.connect(self.b1b)
            self.dlg.e1e.clicked.connect(self.a1a)
            self.dlg.a51.clicked.connect(self.i1i)
            self.dlg.c2c.clicked.connect(self.j1j)
            self.dlg.o1o.clicked.connect(self.d1d)
            self.dlg.m2m.clicked.connect(self.n1n)
            self.dlg.u1u.clicked.connect(self.w1w)
            self.dlg.v1v.clicked.connect(self.w1w)
            self.dlg.d2d.clicked.connect(self.k1k)

            self.dlg.a51.setChecked(True)

            myGBL.update({'n2n': "PGS"}) 
            myGBL.update({'o2o': "Both"}) 
            self.dlg.a41.setText(myGBL['n2n'] + " and " + myGBL['o2o']) 
            self.dlg.h1h.setText("Process the QGIS Selected Themes to " + myGBL['o2o'])
            self.dlg.e1e.setText("Delete the QGIS Selected Themes from " + myGBL['o2o'])

        # show the dialog
        self.dlg.show()

        if os.path.exists(myGBL['ConFileName']):
            m1m(self)
    
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass

def x1x(self):
    myGBL.update({'PG_IPAddress': self.dlg.PG_IPAddress.text()}) 
    myGBL.update({'PG_DBName': self.dlg.PG_DBName.text()}) 
    myGBL.update({'PG_Username': self.dlg.PG_Username.text()}) 
    myGBL.update({'PG_Password': self.dlg.PG_Password.text()}) 
    myGBL.update({'PG_Port': self.dlg.PG_Port.text()}) 
    myGBL.update({'PG_Schema': self.dlg.a4x.text()}) 



def m1m(self):
    try:
        if os.path.exists(myGBL['ConFileName']):
            with open(myGBL['ConFileName'], 'r') as input_file:
                lines = input_file.readlines()
                
                if len(lines) > 0:
                    self.dlg.PG_IPAddress.setText(lines[0].replace('\n','').split('=')[1])
                if len(lines) > 1:
                    self.dlg.PG_DBName.setText(lines[1].replace('\n','').split('=')[1])
                if len(lines) > 2:
                    self.dlg.PG_Username.setText(lines[2].replace('\n','').split('=')[1])
                if len(lines) > 3:
                    self.dlg.PG_Password.setText(lines[3].replace('\n','').split('=')[1])
                if len(lines) > 4:
                    self.dlg.PG_Port.setText(lines[4].replace('\n','').split('=')[1])
                if len(lines) > 5:
                    self.dlg.a4x.setText(lines[5].replace('\n','').split('=')[1])

                x1x(self)
                
                if len(lines) > 6:
                    SRID_Table = lines[6].replace('\n','').split('=')[1]
                    self.dlg.mQgsProjectionSelectionWidget_Table.setCrs(QgsCoordinateReferenceSystem(SRID_Table))
                    myGBL.update({'l3l': SRID_Table}) 

                if len(lines) > 7:
                    myGBL.update({'n2n': lines[7].replace('\n','').split('=')[1]}) 
                if len(lines) > 8:
                    myGBL.update({'o2o': lines[8].replace('\n','').split('=')[1]}) 

                if myGBL['n2n'] == "PGS":
                    self.dlg.a51.setChecked(True)
                    self.dlg.a4x.setEnabled(True)
                if myGBL['n2n'] == "ORA":
                    self.dlg.c2c.setChecked(True)
                    self.dlg.a4x.setEnabled(False)
                if myGBL['n2n'] == "ORD":
                    self.dlg.o1o.setChecked(True)
                    self.dlg.a4x.setEnabled(False)
                if myGBL['n2n'] == "MSS":
                    self.dlg.m2m.setChecked(True)
                    self.dlg.a4x.setEnabled(True)
                if myGBL['o2o'] == "File":
                    self.dlg.v1v.setChecked(True)
                    self.dlg.u1u.setChecked(False)
                if myGBL['o2o'] == "Serv":
                    self.dlg.u1u.setChecked(True)
                    self.dlg.v1v.setChecked(False)
                if myGBL['o2o'] == "Both":
                    self.dlg.v1v.setChecked(True)
                    self.dlg.u1u.setChecked(True)
 
            a53 = [("Point", QgsWkbTypes.PointGeometry, QgsWkbTypes.Point),
                ("LineString", QgsWkbTypes.LineGeometry, QgsWkbTypes.LineString),
                ("Polygon", QgsWkbTypes.PolygonGeometry, QgsWkbTypes.Polygon),
                ("MultiPoint", QgsWkbTypes.PointGeometry, QgsWkbTypes.MultiPoint),
                ("MultiLineString", QgsWkbTypes.LineGeometry, QgsWkbTypes.MultiLineString),
                ("MultiPolygon", QgsWkbTypes.PolygonGeometry, QgsWkbTypes.MultiPolygon),
                ("PointZ", QgsWkbTypes.PointGeometry, QgsWkbTypes.PointZ),
                ("LineStringZ", QgsWkbTypes.LineGeometry, QgsWkbTypes.LineStringZ),
                ("PolygonZ", QgsWkbTypes.PolygonGeometry, QgsWkbTypes.PolygonZ),
                ("MultiPointZ", QgsWkbTypes.PointGeometry, QgsWkbTypes.MultiPointZ),
                ("MultiLineStringZ", QgsWkbTypes.LineGeometry, QgsWkbTypes.MultiLineStringZ),
                ("MultiPolygonZ", QgsWkbTypes.PolygonGeometry, QgsWkbTypes.MultiPolygonZ),
                ("PointM", QgsWkbTypes.PointGeometry, QgsWkbTypes.PointM),
                ("LineStringM", QgsWkbTypes.LineGeometry, QgsWkbTypes.LineStringM),
                ("PolygonM", QgsWkbTypes.PolygonGeometry, QgsWkbTypes.PolygonM),
                ("MultiPointM", QgsWkbTypes.PointGeometry, QgsWkbTypes.MultiPointM),
                ("MultiLineStringM", QgsWkbTypes.LineGeometry, QgsWkbTypes.MultiLineStringM),
                ("MultiPolygonM", QgsWkbTypes.PolygonGeometry, QgsWkbTypes.MultiPolygonM),
                ("PointZM", QgsWkbTypes.PointGeometry, QgsWkbTypes.PointZM),
                ("LineStringZM", QgsWkbTypes.LineGeometry, QgsWkbTypes.LineStringZM),
                ("PolygonZM", QgsWkbTypes.PolygonGeometry, QgsWkbTypes.PolygonZM),
                ("MultiPointZM", QgsWkbTypes.PointGeometry, QgsWkbTypes.MultiPointZM),
                ("MultiLineStringZM", QgsWkbTypes.LineGeometry, QgsWkbTypes.MultiLineStringZM),
                ("MultiPolygonZM", QgsWkbTypes.PolygonGeometry, QgsWkbTypes.MultiPolygonZM),
                ("Point25D", QgsWkbTypes.PointGeometry, QgsWkbTypes.Point25D),
                ("LineString25D", QgsWkbTypes.LineGeometry, QgsWkbTypes.LineString25D),
                ("Polygon25D", QgsWkbTypes.PolygonGeometry, QgsWkbTypes.Polygon25D),
                ("MultiPoint25D", QgsWkbTypes.PointGeometry, QgsWkbTypes.MultiPoint25D),
                ("MultiLineString25D", QgsWkbTypes.LineGeometry, QgsWkbTypes.MultiLineString25D),
                ("MultiPolygon25D", QgsWkbTypes.PolygonGeometry, QgsWkbTypes.MultiPolygon25D),
                ("None", QgsWkbTypes.NullGeometry, QgsWkbTypes.NoGeometry)]
            myGBL.update({'a53': a53}) 

            self.dlg.a41.setText(myGBL['n2n'] + " and " + myGBL['o2o']) 
            self.dlg.h1h.setText("Process the QGIS Selected Themes to " + myGBL['o2o'])
            self.dlg.e1e.setText("Delete the QGIS Selected Themes from " + myGBL['o2o'])

            self.iface.messageBar().pushMessage(
                "Config File Loaded:", myGBL['ConFileName'],
                level=Qgis.Success, duration=3)
    
            input_file.close()
            return True
        
    except Exception as err:
        self.iface.messageBar().pushMessage("Failure", err, level=Qgis.Success, duration=3)
        return False


def l1l(self, aLayer: QgsVectorLayer, **myGBL):

    f1f(self)

    a = "l"
    vl:QgsVectorLayer
    vl = aLayer
    n3n = vl.name().lower().replace(".","_")
    whatIsGoingOn("Started on Vector Theme: " + n3n + " with " + str(vl.featureCount()) + " features...")

    themeSRID = str(vl.sourceCrs())
    themeSRID = themeSRID.replace("<QgsCoordinateReferenceSystem: ","").replace(">","").replace("EPSG:","")
    l3l = myGBL['l3l'].replace("EPSG:","")
    n2n = myGBL['n2n']
    o2o = myGBL['o2o']
    SQLFileName = os.path.expanduser( '~' ) + "/" +  n2n + "_" + n3n + ".sql"
    myGBL.update({'LogFileName': os.path.expanduser( '~' ) + "/" +  n2n + "_" + n3n + ".txt"}) 

    with open(myGBL['LogFileName'], 'w') as log_file:
        log_file.write("All errors for: " + n2n + "_" + n3n)
        log_file.close

    if myGBL['n2n'] == "PGS":
        connPGS = i2i(**myGBL)

    if myGBL['n2n'] == "ORA":
        connOra = j2j(**myGBL)
        #connOra.autocommit = True

    if myGBL['n2n'] == "ORD":
        connOrD = k2k(**myGBL)
        #connOra.autocommit = True

    if myGBL['n2n'] == "MSS":
        connDEV = l2l(**myGBL)
        #connDEV.autocommit = True

    with open(SQLFileName, 'w') as outSQL_file:
        b = "i"
        dateBeg = datetime.datetime.now()
        newTblName = n3n
        a = b + a + a + b
        if n2n == "PGS":
            newTblName = myGBL['PG_Schema'] + "." + n3n
        if n2n == "MSS" and myGBL['PG_Schema'] != "":
            newTblName = myGBL['PG_Schema'] + "." + n3n

        line = "-- " + n3n + " has " + str(vl.featureCount()) + " features..." + '\n'
        outSQL_file.write(line)
        ncount = 0
        ora2Long = 0
        nullcount = 0
        sqlStr = ""
        insStr = ""

        if n2n == "PGS":
            sqlStr = "create schema if not exists " + myGBL['PG_Schema'] + " AUTHORIZATION " + myGBL['PG_Username'] + ";" + '\n'
            sqlStr = sqlStr + "DROP TABLE IF EXISTS " + newTblName + ";" + '\n'
            sqlStr = sqlStr + "CREATE TABLE " + newTblName + "(" + '\n'
            sqlStr = sqlStr + "stid SERIAL NOT NULL," + '\n'
            insStr = "insert into " + newTblName + "(" # stid is allocated by PostGres
        elif n2n == "ORA" or n2n == "ORD":
            sqlStr = sqlStr + "CREATE TABLE " + newTblName + "(" + chr(141)
            sqlStr = sqlStr + "stid NUMBER Primary Key," + chr(141)
            insStr = "insert into " + newTblName + "(" # stid handled as 2nd column
        elif n2n == "MSS":
            sqlStr = "DROP TABLE IF EXISTS " + newTblName + ";" + '\n'
            sqlStr = sqlStr + "CREATE TABLE " + newTblName + "(" + '\n'
            sqlStr = sqlStr + "stid int IDENTITY(1,1) NOT NULL primary key," + '\n'
            insStr = "insert into " + newTblName + "("

        a52 = [field.name() for field in vl.fields()]
        line = ','.join(name for name in a52) + '\n'
        a = "m" + a + "o"

        a53 = myGBL['a53']
        gType = "Not Found"
        for v in a53:
            if str(vl.wkbType()) == str(v[2]):
                gType = str(str(v[0]))

        if gType != "Not Found":
            if n2n == "PGS":
                sqlStr = sqlStr + "geom geometry(" + gType + "," + l3l + ")," + '\n'
                insStr = insStr + "geom,"
            elif n2n == "ORA" or n2n == "ORD":
                sqlStr = sqlStr + "geom MDSYS.SDO_GEOMETRY," + chr(141)
                insStr = insStr + "geom,stid,"
            elif n2n == "MSS":
                sqlStr = sqlStr + "geom geography," + '\n'
                insStr = insStr + "geom,"

        for field in vl.fields():

            lc_FldNm = field.name().lower()
            if n2n == "PGS":
                # An "illegal" identifier has to be quoted in Postgres (and SQL).
                # The function format() has a special place holder for identifiers and will return a quoted identifier
                # if anything is non-standard:
                # So select format('%I', 'foo') returns foo.
                # But select format('%I', 'foo bar') returns "foo bar"
                r2r = "select format('%I', '" + lc_FldNm + "')"
                r2r = r2r.replace("%",chr(135) + "%" + chr(135))
                r2r = r2r.replace(chr(135),"'||'")
                lc_FldNm = p1p(r2r, connPGS, myGBL['LogFileName'])

            if field.typeName() == "Integer64":
                if n2n == "PGS":
                    sqlStr = sqlStr + lc_FldNm + " bigint," + '\n'
                elif n2n == "ORA" or n2n == "ORD":
                    sqlStr = sqlStr + lc_FldNm + " NUMBER(38)," + chr(141)
                elif n2n == "MSS":
                    sqlStr = sqlStr + lc_FldNm + " bigint," + '\n'
            elif field.typeName() == "Integer32" or field.typeName() == "Integer":
                if n2n == "PGS":
                    sqlStr = sqlStr + lc_FldNm + " integer," + '\n'
                elif n2n == "ORA" or n2n == "ORD":
                    sqlStr = sqlStr + lc_FldNm + " NUMBER(38)," + chr(141)
                elif n2n == "MSS":
                    sqlStr = sqlStr + lc_FldNm + " int," + '\n'
            elif field.typeName() == "Integer16":
                if n2n == "PGS":
                    sqlStr = sqlStr + lc_FldNm + " smallint," + '\n'
                elif n2n == "ORA" or n2n == "ORD":
                    sqlStr = sqlStr + lc_FldNm + " NUMBER(38)," + chr(141)
                elif n2n == "MSS":
                    sqlStr = sqlStr + lc_FldNm + " smallint," + '\n'
            elif field.typeName() == "Boolean":
                sqlStr = sqlStr + lc_FldNm + " boolean," + '\n'
            elif field.typeName() == "String":
                if n2n == "PGS": #  + 10 as I have found GPKG strings longer than the field.length
                    sqlStr = sqlStr + lc_FldNm + " varchar(" + str(field.length() + 10) + ")," + '\n'
                elif n2n == "ORA" or n2n == "ORD":
                    sqlStr = sqlStr + lc_FldNm + " varchar2(" + str(field.length() + 10) + ")," + chr(141)
                elif n2n == "MSS":
                    sqlStr = sqlStr + lc_FldNm + " varchar(" + str(field.length() + 10) + ")," + '\n'
            elif field.typeName() == "Date":
                if n2n == "PGS":
                    sqlStr = sqlStr + lc_FldNm + " date," + '\n'
                elif n2n == "ORA" or n2n == "ORD":
                    sqlStr = sqlStr + lc_FldNm + " DATE," + chr(141)
                elif n2n == "MSS":
                    sqlStr = sqlStr + lc_FldNm + " date," + '\n'
            elif field.typeName() == "DateTime":
                if n2n == "PGS":
                    sqlStr = sqlStr + lc_FldNm + " timestamp(0) without time zone," + '\n'
                elif n2n == "ORA" or n2n == "ORD":
                    sqlStr = sqlStr + lc_FldNm + " TIMESTAMP," + chr(141)
                elif n2n == "MSS":
                    sqlStr = sqlStr + lc_FldNm + " datetime," + '\n'
            elif field.typeName() == "Real" or field.typeName() == "Float":
                if n2n == "PGS":
                    sqlStr = sqlStr + lc_FldNm + " real," + '\n'
                elif n2n == "ORA" or n2n == "ORD":
                    sqlStr = sqlStr + lc_FldNm + " BINARY_FLOAT," + chr(141)
                elif n2n == "MSS":
                    sqlStr = sqlStr + lc_FldNm + " real," + '\n'
            elif field.typeName() == "Double" or field.typeName() == "Float32":
                if n2n == "PGS":
                    sqlStr = sqlStr + lc_FldNm + " double precision," + '\n'
                elif n2n == "ORA" or n2n == "ORD":
                    sqlStr = sqlStr + lc_FldNm + " BINARY_DOUBLE," + chr(141)
                elif n2n == "MSS":
                    sqlStr = sqlStr + lc_FldNm + " float," + '\n'
            else:
                sqlStr = sqlStr + lc_FldNm + " typeName not handled " + field.typeName() + '\n'

            insStr = insStr + lc_FldNm + ","

        if n2n == "ORA" or n2n == "ORD":
            sqlStr = sqlStr + ")"
            sqlStr = sqlStr.replace("," + chr(141) + ")", ")").replace(chr(141), "")
        else:
            sqlStr = sqlStr + ");"
            sqlStr = sqlStr.replace("," + '\n' + ")", ")")
        if o2o == "File" or o2o == "Both":
            outSQL_file.write(sqlStr.replace(chr(140),";").replace(chr(141),'\n') + '\n')
        insStr = insStr + ") values "
        insStr = insStr.replace(",)", ")")
        a = " " + a + "n"
        if o2o == "Serv" or o2o == "Both":
            if n2n == "PGS":
                e2e(sqlStr, connPGS, myGBL['LogFileName'])
            elif n2n == "ORA":
                f2f("DROP TABLE " + newTblName, connOra, myGBL['LogFileName'])
                f2f(sqlStr, connOra, myGBL['LogFileName'])
                f2f("commit", connOra, myGBL['LogFileName'])
            elif n2n == "ORD":
                g2g("DROP TABLE " + newTblName, connOrD, myGBL['LogFileName'])
                g2g(sqlStr, connOrD, myGBL['LogFileName'])
                g2g("commit", connOrD, myGBL['LogFileName'])
            elif n2n == "MSS":
                h2h(sqlStr, connDEV, myGBL['LogFileName'])

        abc = self.dlg.a44.text().replace("("," ").replace(")"," ").replace(a, z3 + z3).split(" ")
        efg = float(abc[3])
        # write feature attributes
        t2t = ""
        fromCRS = vl.sourceCrs()
        destCRS = QgsCoordinateReferenceSystem(myGBL['l3l'])
        ct = QgsCoordinateTransform(fromCRS, destCRS, QgsProject.instance())

        for f in vl.getFeatures():
            ncount = ncount + 1
            if ncount == 1 or ncount == 10 or ncount == 100 or ncount == 500 or str(ncount).endswith(z3):
                whatIsGoingOn(n3n + ": " +str(ncount) + "/" + str(vl.featureCount()))
            if ncount <= efg:
                geom = f.geometry()
                geom.transform(ct)

                geom_asWkt = geom.asWkt()

                if geom_asWkt == "":
                    geom_asWkt = "NULL"
                    nullcount = nullcount + 1
                    
                geoStr = "NULL"
                if n2n == "ORA" or n2n == "ORD":
                    geoStr = "NULL," + str(ncount)
                didBind = False
                if (n2n == "ORA" or n2n == "ORD") and len(geom.asWkt()) > 4000:
                    # too long for Oracle's varchar2 client side (4000 chars) so use server side binding (327?? chars)
                    if len(geom.asWkt()) > 32700:
                        ora2Long = ora2Long + 1
                    didBind = True
                    o2o = "/" + chr(141)
                    o2o = o2o + "declare" + chr(141)
                    o2o = o2o + " v_sql varchar2(" + str(len(geom.asWkt()) + len(newTblName) + 150) + ")" + chr(140) + chr(141)
                    o2o = o2o + " v_clob clob" + chr(140) + chr(141)
                    o2o = o2o + "begin" + chr(141)
                    o2o = o2o + "  v_clob := CAST('" + str(geom.asWkt()) + "' as clob)" + chr(140) + chr(141)
                    o2o = o2o + "  v_sql := 'insert into " + newTblName + " (stid,geom) values(:id,sdo_util.from_wktgeometry(:clob))'" + chr(140) + chr(141)
                    o2o = o2o + "  execute immediate v_sql" + chr(141)
                    o2o = o2o + "  using " + str(ncount) + ", v_clob" + chr(140) + chr(141)
                    o2o = o2o + "  commit" + chr(140) + chr(141)
                    o2o = o2o + "end" + chr(140) + chr(141)
                    o2o = o2o + "/" + chr(141)

                    if o2o == "File" or o2o == "Both":
                        outSQL_file.write(o2o.replace(chr(140),";").replace(chr(141),'\n'))
                    if o2o == "Serv" or o2o == "Both":
                        if n2n == "ORA":
                            f2f(o2o.replace(chr(140)," ").replace(chr(141)," "), connOra, myGBL['LogFileName'])
                        if n2n == "ORD":
                            g2g(o2o.replace(chr(140)," ").replace(chr(141)," "), connOrD, myGBL['LogFileName'])

                    s2s = "update " + newTblName + " set " + chr(141)
                    for field in vl.fields():
                        lc_FldNm = field.name().lower()
                        if str(f[field.name()]) == "NULL":
                            nullComment = "do not update"
                        elif field.typeName() == "Integer64":
                            s2s = s2s + lc_FldNm + "=" + str(f[field.name()]) + ","
                        elif field.typeName() == "Integer32" or field.typeName() == "Integer":
                            s2s = s2s + lc_FldNm + "=" + str(f[field.name()]) + ","
                        elif field.typeName() == "Integer16":
                            s2s = s2s + lc_FldNm + "=" + str(f[field.name()]) + ","
                        elif field.typeName() == "Boolean":
                            s2s = s2s + lc_FldNm + "=" + str(f[field.name()]) + ","
                        elif field.typeName() == "String":
                            # specChar = "( ) - & @ * $ | % "
                            r2r = str(f[field.name()]).replace("'","''").replace(chr(34),chr(134))
                            r2r = r2r.replace("(",chr(135) + "(" + chr(135))
                            r2r = r2r.replace(")",chr(135) + ")" + chr(135))
                            r2r = r2r.replace("-",chr(135) + "-" + chr(135))
                            r2r = r2r.replace(".",chr(135) + "." + chr(135))
                            r2r = r2r.replace("&",chr(135) + "&" + chr(135))
                            r2r = r2r.replace("@",chr(135) + "@" + chr(135))
                            r2r = r2r.replace("*",chr(135) + "*" + chr(135))
                            r2r = r2r.replace("$",chr(135) + "$" + chr(135))
                            r2r = r2r.replace("|",chr(135) + "|" + chr(135))
                            r2r = r2r.replace("%",chr(135) + "%" + chr(135))
                            r2r = r2r.replace(chr(135),"'||'")
                            r2r = r2r.replace(chr(134),"'||'" + chr(34) + "'||'")
                            if len(r2r) > field.length():
                                r2r = r2r[0: field.length()]
                            s2s = s2s + lc_FldNm + "='" + r2r + "',"
                        elif field.typeName() == "Date":
                            DATETIME_FORMAT = 'yyyy-MM-dd'
                            qd8 = str(f[field.name()]).replace("PyQt5.QtCore.QDate","")
                            qd8 = qd8.replace(", ", "/").replace("(","").replace(")","")
                            s2s = s2s + lc_FldNm + "=" + "TO_DATE('" + qd8 + "', 'YYYY/MM/DD'),"
                        elif field.typeName() == "DateTime":
                            DATETIME_FORMAT = 'yyyy-MM-dd HH:mm:ss'
                            qd8 = str(f[field.name()]).replace("PyQt5.QtCore.QDateTime(","").replace(")","")
                            qd8 = qd8.replace(", ", "-")
                            qd8Arr = qd8.split("-")
                            # TO_DATE('2008-11-18 14:13:59', 'YYYY-MM-DD HH24:Mi:SS')
                            qd8 = qd8Arr[0] + "-" + qd8Arr[1] + "-" + qd8Arr[2]
                            if len(qd8Arr) > 3:
                                qd8 = qd8 + " " + qd8Arr[3]
                            else:
                                qd8 = qd8 + " 0"
                            if len(qd8Arr) > 4:
                                qd8 = qd8 + ":" + qd8Arr[4]
                            else:
                                qd8 = qd8 + ":0"
                            if len(qd8Arr) > 5:
                                qd8 = qd8 + ":" + qd8Arr[5]
                            else:
                                qd8 = qd8 + ":0"
                            s2s = s2s + lc_FldNm + "=" + "TO_DATE('" + qd8 + "', 'YYYY-MM-DD HH24:Mi:SS'),"                            
                        elif field.typeName() == "Real" or field.typeName() == "Float":
                            s2s = s2s + lc_FldNm + "=" + str(f[field.name()]) + ","
                        elif field.typeName() == "Double" or field.typeName() == "Float32":
                            s2s = s2s + lc_FldNm + "=" + str(f[field.name()]) + ","
                
                    s2s = s2s + ") where stid=" + str(ncount)
                    s2s = s2s.replace(",)", "")
                    if o2o == "File" or o2o == "Both":
                        outSQL_file.write(s2s + ";" + '\n')
                    if o2o == "Serv" or o2o == "Both":
                        if n2n == "ORA":
                            f2f(s2s, connOra, myGBL['LogFileName'])
                            f2f("commit", connOra, myGBL['LogFileName'])
                        if n2n == "ORD":
                            g2g(s2s, connOrD, myGBL['LogFileName'])
                            g2g("commit", connOrD, myGBL['LogFileName'])

                elif str(geom.asWkt()) != "":
                    if n2n == "PGS":
                        geoStr = "st_setSRID(ST_GeomFromText('" + str(geom.asWkt()) + "')," + l3l + ")"
                    elif n2n == "ORA" or n2n == "ORD":
                        geoStr = "SDO_UTIL.FROM_WKTGEOMETRY('" + geom.asWkt() + "')," + str(ncount)
                    elif n2n == "MSS":
                        geoStr = "geography::STGeomFromText('" + str(geom.asWkt()) + "'," + l3l + ")"
    
                if didBind == False:
                    t2t = t2t + "(" + geoStr + ","
                    for field in vl.fields():
                        if field.typeName() == "Integer64":
                            t2t = t2t + str(f[field.name()]) + ","
                        elif field.typeName() == "Integer32" or field.typeName() == "Integer":
                            t2t = t2t + str(f[field.name()]) + ","
                        elif field.typeName() == "Integer16":
                            t2t = t2t + str(f[field.name()]) + ","
                        elif field.typeName() == "String":
                            if n2n == "ORA" or n2n == "ORD":
                            # specChar = "( ) - & @ * $ | % "
                                r2r = str(f[field.name()]).replace("'","''").replace(chr(34),chr(134))
                                r2r = r2r.replace("(",chr(135) + "(" + chr(135))
                                r2r = r2r.replace(")",chr(135) + ")" + chr(135))
                                r2r = r2r.replace("-",chr(135) + "-" + chr(135))
                                r2r = r2r.replace(".",chr(135) + "." + chr(135))
                                r2r = r2r.replace("&",chr(135) + "&" + chr(135))
                                r2r = r2r.replace("@",chr(135) + "@" + chr(135))
                                r2r = r2r.replace("*",chr(135) + "*" + chr(135))
                                r2r = r2r.replace("$",chr(135) + "$" + chr(135))
                                r2r = r2r.replace("|",chr(135) + "|" + chr(135))
                                r2r = r2r.replace("%",chr(135) + "%" + chr(135))
                                r2r = r2r.replace(chr(135),"'||'")
                                r2r = r2r.replace(chr(134),"'||'" + chr(34) + "'||'")
                                if len(r2r) > field.length():
                                    r2r = r2r[0: field.length()]
                                t2t = t2t + "'" + r2r + "',"
                            else:
                                curStr = str(f[field.name()]).replace("'","''")
                                if len(curStr) > field.length():
                                    curStr = curStr[0: field.length()]
                                t2t = t2t + "'" + curStr + "',"
                        elif field.typeName() == "Date":
                            # t2t = t2t + "'" + format_date(f[field.name()],DATETIME_FORMAT) + "',"
                            DATETIME_FORMAT = 'yyyy-MM-dd'
                            # QgsExpression('format_date(f[field.name()], DATETIME_FORMAT)').evaluate(ctx)
                            # 'PyQt5.QtCore.QDate(1999, 10, 1)'
                            if str(f[field.name()]) == "NULL":
                                t2t = t2t + "NULL,"
                            else:
                                qd8 = str(f[field.name()]).replace("PyQt5.QtCore.QDate","")
                                if n2n == "PGS" or n2n == "MSS":
                                    qd8 = qd8.replace(", ", "-")
                                    if n2n == "MSS":
                                        qd8 = qd8.replace("(", "").replace(")", "")
                                    t2t = t2t + "'" + qd8 + "',"
                                elif n2n == "ORA" or n2n == "ORD":
                                    qd8 = qd8.replace(", ", "/").replace("(","").replace(")","")
                                    t2t = t2t + "TO_DATE('" + qd8 + "', 'YYYY/MM/DD'),"                            
                        elif field.typeName() == "DateTime":
                            # buildtime:QgsDateTimeFieldFormatter
                            DATETIME_FORMAT = 'yyyy-MM-dd HH:mm:ss'
                            # t2t = t2t + "'" + format_date(f[field.name()],DATETIME_FORMAT) + "',"
                            if str(f[field.name()]) == "NULL":
                                t2t = t2t + "NULL,"
                            else:
                                # PyQt5.QtCore.QDateTime(2020, 8, 28, 12, 39, 52, 360)
                                # t2t = t2t + str(f[field.name()]) + ","
                                # "yyyy/mm/dd HH:mm:ss"
                                qd8 = str(f[field.name()]).replace("PyQt5.QtCore.QDateTime(","").replace(")","")
                                qd8 = qd8.replace(", ", "-")
                                qd8Arr = qd8.split("-")
                                if n2n == "PGS" or n2n == "MSS":
                                    qd8 = qd8Arr[0] + "-" + qd8Arr[1] + "-" + qd8Arr[2]
                                    if len(qd8Arr) > 3:
                                        qd8 = qd8 + " " + qd8Arr[3]
                                    if len(qd8Arr) > 4:
                                        qd8 = qd8 + ":" + qd8Arr[4]
                                    if len(qd8Arr) > 5:
                                        qd8 = qd8 + ":" + qd8Arr[5]
                                    if len(qd8Arr) > 6:
                                        qd8 = qd8 + "." + qd8Arr[6]
                                    t2t = t2t + "'" + qd8 + "',"

                                elif n2n == "ORA" or n2n == "ORD":
                                    # TO_DATE('2008-11-18 14:13:59', 'YYYY-MM-DD HH24:Mi:SS')
                                    qd8 = qd8Arr[0] + "-" + qd8Arr[1] + "-" + qd8Arr[2]
                                    if len(qd8Arr) > 3:
                                        qd8 = qd8 + " " + qd8Arr[3]
                                    else:
                                        qd8 = qd8 + " 0"
                                    if len(qd8Arr) > 4:
                                        qd8 = qd8 + ":" + qd8Arr[4]
                                    else:
                                        qd8 = qd8 + ":0"
                                    if len(qd8Arr) > 5:
                                        qd8 = qd8 + ":" + qd8Arr[5]
                                    else:
                                        qd8 = qd8 + ":0"
                                    t2t = t2t + "TO_DATE('" + qd8 + "', 'YYYY-MM-DD HH24:Mi:SS'),"                            

                        elif field.typeName() == "Real" or field.typeName() == "Float":
                            t2t = t2t + str(f[field.name()]) + ","
                        elif field.typeName() == "Double" or field.typeName() == "Float32":
                            t2t = t2t + str(f[field.name()]) + ","
                        else:
                            t2t = t2t + "new field type:" + field.typeName() 
                
                    t2t = t2t + ")"
                    # Finished looping through the fields of the current feature/record

                    # do we save these records??? Depends, lol
                    if n2n == "PGS":
                        # format up a set of records once it is big enough
                        if len(t2t) > 50000:
                            t2t = t2t.replace(",)", ")").replace("'NULL'", "NULL").replace(")(st_setSRID", ")," + '\n' + "(st_setSRID")
                            t2t = t2t.replace(")(st_transform", ")," + '\n' + "(st_transform")
                            t2t = t2t.replace(")(NULL", ")," + '\n' + "(NULL")
                            if o2o == "File" or o2o == "Both":
                                outSQL_file.write(insStr + '\n' + t2t + ";" + '\n')
                            if o2o == "Serv" or o2o == "Both":
                                e2e(insStr + t2t, connPGS, myGBL['LogFileName'])
                            t2t = ""
                    elif n2n == "ORA" or n2n == "ORD":
                        # could not sort out how to insert multiple records per insert
                        if len(t2t) > 0:
                            t2t = t2t.replace(",)", ")").replace("'NULL'", "NULL").replace(")(SDO_UTIL", ")," + '\n' + "(SDO_UTIL")
                            t2t = t2t.replace(")(NULL", ")," + '\n' + "(NULL")
                            if o2o == "File" or o2o == "Both":
                                outSQL_file.write(insStr + '\n' + t2t + ";" + '\n')
                            if o2o == "Serv" or o2o == "Both":
                                if n2n == "ORA":
                                    f2f(insStr + t2t.replace('\n',""), connOra, myGBL['LogFileName'])
                                if n2n == "ORD":
                                    g2g(insStr + t2t.replace('\n',"") + ";", connOrD, myGBL['LogFileName'])
                            t2t = ""
                    elif n2n == "MSS":
                        # could not sort out how to insert multiple records per insert
                        if len(t2t) > 0:
                            t2t = t2t.replace(",)", ")").replace("'NULL'", "NULL").replace(")(geography", ")," + '\n' + "(geography")
                            t2t = t2t.replace(")(NULL", ")," + '\n' + "(NULL")
                            if o2o == "File" or o2o == "Both":
                                outSQL_file.write(insStr + '\n' + t2t + ";" + '\n')
                            if o2o == "Serv" or o2o == "Both":
                                h2h(insStr + t2t, connDEV, myGBL['LogFileName'])
                        t2t = ""


        # last group of records
        if n2n == "PGS":
            if len(t2t) > 0:
                t2t = t2t.replace(",)", ")").replace("'NULL'", "NULL").replace(")(st_setSRID", ")," + '\n' + "(st_setSRID")
                t2t = t2t.replace(")(st_transform", ")," + '\n' + "(st_transform")
                t2t = t2t.replace(")(NULL", ")," + '\n' + "(NULL")
                if o2o == "File" or o2o == "Both":
                    outSQL_file.write(insStr + '\n' + t2t + '\n')
                if o2o == "Serv" or o2o == "Both":
                    e2e(insStr + t2t, connPGS, myGBL['LogFileName'])
            t2t = ""
        elif n2n == "ORA" or n2n == "ORD":
            if len(t2t) > 0:
                t2t = t2t.replace(",)", ")").replace("'NULL'", "NULL").replace(")(SDO_UTIL", ")," + '\n' + "(SDO_UTIL")
                t2t = t2t.replace(")(NULL", ")," + '\n' + "(NULL")
                if o2o == "File" or o2o == "Both":
                    outSQL_file.write(insStr + '\n' + t2t + ";" + '\n')
                if o2o == "Serv" or o2o == "Both":
                    if n2n == "ORA":
                        f2f(insStr + t2t, connOra, myGBL['LogFileName'])
                        f2f("commit", connOra, myGBL['LogFileName'])
                    if n2n == "ORD":
                        g2g(insStr + t2t, connOrD, myGBL['LogFileName'])
                        g2g("commit", connOrD, myGBL['LogFileName'])
                t2t = ""
        elif n2n == "MSS":
            if len(t2t) > 0:
                t2t = t2t.replace(",)", ")").replace("'NULL'", "NULL").replace(")(geography", ")," + '\n' + "(geography")
                t2t = t2t.replace(")(NULL", ")," + '\n' + "(NULL")
                if o2o == "File" or o2o == "Both":
                    outSQL_file.write(insStr + '\n' + t2t + ";" + '\n')
                if o2o == "Serv" or o2o == "Both":
                    h2h(insStr + t2t, myGBL['LogFileName'])
                t2t = ""

        if n2n == "PGS":
            pgsSQL = "CREATE INDEX " + newTblName.replace(".","_") + "_spidx ON " + newTblName 
            pgsSQL = pgsSQL +" USING gist(geom);" + '\n'
            if o2o == "File" or o2o == "Both":
                outSQL_file.write(";" + '\n' + pgsSQL + '\n')
            if o2o == "Serv" or o2o == "Both":
                e2e(pgsSQL + ";", connPGS, myGBL['LogFileName'])

        if n2n == "ORA" or n2n == "ORD":
            oraSQL = "UPDATE " + newTblName + " T SET T.geom.SDO_SRID = " + themeSRID
            oraSQL = oraSQL +" WHERE T.geom IS NOT NULL"

            if o2o == "File" or o2o == "Both":
                outSQL_file.write(";" + '\n' + oraSQL + ";" + '\n' + "commit;" + '\n')
            if o2o == "Serv" or o2o == "Both":
                if n2n == "ORA":
                    f2f(oraSQL, connOra, myGBL['LogFileName'])
                    f2f("commit", connOra, myGBL['LogFileName'])
                if n2n == "ORD":
                    g2g(oraSQL, connOrD, myGBL['LogFileName'])
                    g2g("commit", connOrD, myGBL['LogFileName'])

            oraSQL = oraSQL + "-- CREATE INDEX " + newTblName.replace(".","_") + "_spidx ON " + newTblName + " (geom)"
            oraSQL = oraSQL + " INDEXTYPE IS MDSYS.SPATIAL_INDEX_V2"

            if o2o == "File" or o2o == "Both":
                outSQL_file.write(";" + '\n' + oraSQL + ";" + '\n' + "commit;" + '\n')
            if o2o == "Serv" or o2o == "Both":
                if n2n == "ORA":
                    f2f(oraSQL, connOra, myGBL['LogFileName'])
                    f2f("commit", connOra, myGBL['LogFileName'])
                if n2n == "ORD":
                    g2g(oraSQL, connOrD, myGBL['LogFileName'])
                    g2g("commit", connOrD, myGBL['LogFileName'])

        if n2n == "MSS":
            mssSQL = "CREATE SPATIAL INDEX " + newTblName.replace(".","_") + "_geom_spidx ON " + newTblName + "(geom);" + '\n'
            if o2o == "File" or o2o == "Both":
                outSQL_file.write(mssSQL + '\n')
            if o2o == "Serv" or o2o == "Both":
                h2h(mssSQL + ";", connDEV, myGBL['LogFileName'])

        with open(os.path.expanduser( '~' ) + "/log._ImportThemeReport", 'a') as ImpLog_file:
            line = "-- " + newTblName + " has " + str(vl.featureCount()) + " features, with " + str(ncount) + " processed."
            ImpLog_file.write(line + '\n')

            if o2o == "Serv" or o2o == "Both":
                retCount = "?"
                if n2n == "PGS":
                    retCount = p1p("select count(*) from " + newTblName, connPGS, myGBL['LogFileName'])

                if n2n == "ORA":
                    retCount = q1q("select count(*) from " + newTblName, connOra, myGBL['LogFileName'])
                    if ora2Long > 0:
                        line = "-- *** Warning: " + newTblName + " has " + str(ora2Long) + " features that were not loaded as their geometries were too long (Over 32700 Characters)."
                        ImpLog_file.write(line + '\n')

                if n2n == "ORD":
                    retCount = r1r("select count(*) from " + newTblName, connOrD, myGBL['LogFileName'])
                    if ora2Long > 0:
                        line = "-- *** Warning: " + newTblName + " has " + str(ora2Long) + " features that were not loaded as their geometries were too long (Over 32700 Characters)."
                        ImpLog_file.write(line + '\n')

                if n2n == "MSS":
                    retCount = s1s("select count(*) from " + newTblName, connDEV, myGBL['LogFileName'])

                if retCount == "None":
                    ImpLog_file.write("An error occured getting Count(*) from " + newTblName + '\n')
                else:
                    line = "-- " + newTblName + " has " + retCount + " features saved."
                    line = line.replace("(","").replace(",)","") 
                    ImpLog_file.write(line + '\n')

            dateEnd = datetime.datetime.now()
            diffDate = (dateEnd - dateBeg).total_seconds()
            line = "Started at: " + str(dateBeg) + " and Finished at: " + str(dateEnd)
            ImpLog_file.write(line + '\n')
            if diffDate > 1:
                line = "Approx Records/Second: " + str(int(vl.featureCount() / diffDate))
                ImpLog_file.write(line + '\n')

            log_file.close
            ImpLog_file.close
            if o2o == "Serv":
                outSQL_file.close
                os.remove(SQLFileName)

        newText = n3n + ": " + str(nullcount) + "\n"
        if nullcount > 0:
            QMessageBox.information(None,"Warning, NULL Geometries Found!", newText, QMessageBox.Ok, QMessageBox.Ok)
            whatIsGoingOn("Warning, NULL Geometries Found! " + newText)
        whatIsGoingOn("Output file written at " + SQLFileName)
        self.iface.messageBar().pushMessage("Success", "Output file written at " + SQLFileName, level=Qgis.Success, duration=5)

    return None


def e2e(sql2Run: str, connPGS: psycopg2, LclFileName: str):
    try:
        cursor = connPGS.cursor()
        cursor.execute(sql2Run)
        connPGS.commit() 
        return True
    except Exception as error:
        whatIsGoingOn("Oops! An exception has occured: " + str(error) + ", Exception TYPE: " + str(type(error)))
        whatIsGoingOn(str(error.args))
        whatIsGoingOn(sql2Run)
        return False

def p1p(sql2Run: str, connPGS: psycopg2, LclFileName: str):
    a = y1y(sql2Run, connPGS, LclFileName)
    return str(a[0][0]) if a else "None"

def y1y(sql2Run: str, connPGS: psycopg2, LclFileName: str):
    # Querying data using fetchone() method
    retArr = []
    try:
        cur = connPGS.cursor()
        cur.execute(sql2Run)
        #print("The number of rows: ", cur.rowcount)
        row = cur.fetchone()

        while row is not None:
            # print(row)
            retArr.append(row)
            row = cur.fetchone()

        cur.close()
        return retArr
    except (Exception, psycopg2.DatabaseError) as error:
        whatIsGoingOn("Oops! An exception has occured: " + str(error) + ", Exception TYPE: " + str(type(error)))
        whatIsGoingOn(str(error.args))
        whatIsGoingOn(sql2Run)
    return retArr

def f2f(sql2Run: str, connORA: oracledb, LclFileName: str):
    try:

        cursor = connORA.cursor()
        if "drop table" in sql2Run.lower():
            with cursor.suppress(Exception):
                cursor.execute(sql2Run)
            return True

        if chr(140) in sql2Run:
            sqlArr = sql2Run.replace(chr(140),"").split('\n')
            for aSQL in sqlArr:
                cursor.execute(aSQL)
        else:
            cursor.execute(sql2Run)
        return True
    except Exception as error:
        whatIsGoingOn("Oops! An exception has occured: " + str(error) + ", Exception TYPE: " + str(type(error)))
        whatIsGoingOn(str(error.args))
        whatIsGoingOn(sql2Run)
        return False

def q1q(sql2Run: str, connORA: oracledb, LclFileName: str):
    a = z1z(sql2Run, connORA, LclFileName)
    return str(a[0][0]) if a else "None"

def z1z(sql2Run: str, connORA: oracledb, LclFileName: str):
    # Querying data using fetchone() method
    retArr = []
    try:
        cur = connORA.cursor()
        cur.execute(sql2Run)
        #print("The number of rows: ", cur.rowcount)
        row = cur.fetchone()

        while row is not None:
            # print(row)
            retArr.append(row)
            row = cur.fetchone()

        cur.close()
        return retArr
    except (Exception, oracledb.DatabaseError) as error:
        whatIsGoingOn("Oops! An exception has occured: " + str(error) + ", Exception TYPE: " + str(type(error)))
        whatIsGoingOn(str(error.args))
        whatIsGoingOn(sql2Run)
    return retArr

def g2g(sql2Run: str, connORD: pyodbc, LclFileName: str):
    try:
        cursor = connORD.cursor()
        if "drop table" in sql2Run.lower():
            with cursor.suppress(Exception):
                cursor.execute(sql2Run)
            return True

        if chr(140) in sql2Run:
            sqlArr = sql2Run.replace(chr(140),"").split('\n')
            for aSQL in sqlArr:
                if len(aSQL) > 5:
                    cursor.execute(aSQL)
        else:
            cursor.execute(sql2Run)
        return True
    except Exception as error:
        whatIsGoingOn("Oops! An exception has occured: " + str(error) + ", Exception TYPE: " + str(type(error)))
        whatIsGoingOn(str(error.args))
        whatIsGoingOn(sql2Run)
        return False

def r1r(sql2Run: str, connORD: pyodbc, LclFileName: str):
    a = a2a(sql2Run, connORD, LclFileName)
    return str(a[0][0]) if a else "None"

def a2a(sql2Run: str, connORD: pyodbc, LclFileName: str):
    # Querying data using fetchone() method
    retArr = []
    try:
        cur = connORD.cursor()
        cur.execute(sql2Run)
        #print("The number of rows: ", cur.rowcount)
        row = cur.fetchone()

        while row is not None:
            # print(row)
            retArr.append(row)
            row = cur.fetchone()

        cur.close()
        return retArr
    except (Exception, oracledb.DatabaseError) as error:
        whatIsGoingOn("Oops! An exception has occured: " + str(error) + ", Exception TYPE: " + str(type(error)))
        whatIsGoingOn(str(error.args))
        whatIsGoingOn(sql2Run)
    return retArr

def h2h(sql2Run: str, MSSconn: pyodbc, LclFileName: str):
    try:
        cursor = MSSconn.cursor()
        cursor.execute(sql2Run)
        MSSconn.commit() 
        return True
    except Exception as error:
        whatIsGoingOn("Oops! An exception has occured: " + str(error) + ", Exception TYPE: " + str(type(error)))
        whatIsGoingOn(str(error.args))
        whatIsGoingOn(sql2Run)
        return False

def s1s(sql2Run: str, connDEV: pyodbc, LclFileName: str):
    a = b2b(sql2Run, connDEV, LclFileName)
    return str(a[0][0]) if a else "None"

def b2b(sql2Run: str, connDEV: pyodbc, LclFileName: str):
    # Querying data using fetchone() method
    retArr = []
    try:
        cur = connDEV.cursor()
        cur.execute(sql2Run)
        #print("The number of rows: ", cur.rowcount)
        row = cur.fetchone()

        while row is not None:
            # print(row)
            retArr.append(row)
            row = cur.fetchone()

        cur.close()
        return retArr
    except (Exception, pyodbc.DatabaseError) as error:
        whatIsGoingOn("Oops! An exception has occured: " + str(error) + ", Exception TYPE: " + str(type(error)))
        whatIsGoingOn(str(error.args))
        whatIsGoingOn(sql2Run)
    return retArr


def i2i(**myGBL):
    return psycopg2.connect(
        host=myGBL['PG_IPAddress'],
        database=myGBL['PG_DBName'],
        user=myGBL['PG_Username'],
        password=myGBL['PG_Password'],
        port=myGBL['PG_Port'])
    # connPGS.autocommit = True
    

def j2j(**myGBL):
    params = oracledb.ConnectParams(host=myGBL['PG_IPAddress'], port=myGBL['PG_Port'], service_name=myGBL['PG_DBName'])
    return oracledb.connect(user=myGBL['PG_Username'], password=myGBL['PG_Password'], params=params)
    
def k2k(**myGBL):
    p2p = "DRIVER={Devart ODBC Driver for Oracle};Direct=True;Host=myServer;Service Name=myServiceName;UserID=myUsername;Port=myPort;Password=myPassword"
    p2p = p2p.replace("myServer", myGBL['PG_IPAddress'])
    p2p = p2p.replace("myServiceName", myGBL['PG_DBName'])
    p2p = p2p.replace("myPort", myGBL['PG_Port'])
    p2p = p2p.replace("myUsername", myGBL['PG_Username'])
    p2p = p2p.replace("myPassword", myGBL['PG_Password'])
    return pyodbc.connect(p2p)

def l2l(**myGBL):
    p2p = "DRIVER={Devart ODBC Driver for SQL Server};Server=myserver;Database=mydatabase;Port=myport;User ID=myuserid;Password=mypassword"
    p2p = p2p.replace("myserver", myGBL['PG_IPAddress'])
    p2p = p2p.replace("mydatabase", myGBL['PG_DBName'])
    p2p = p2p.replace("myport", myGBL['PG_Port'])
    p2p = p2p.replace("myuserid", myGBL['PG_Username'])
    p2p = p2p.replace("mypassword", myGBL['PG_Password'])
    return pyodbc.connect(p2p)

def f1f(self):
    x1x(self)
    try:
        with open(myGBL['ConFileName'], 'w') as conf_file:
            line = 'host=' + self.dlg.PG_IPAddress.text() + '\n'
            line = line + 'database=' + self.dlg.PG_DBName.text() + '\n'
            line = line + 'user=' + self.dlg.PG_Username.text() + '\n'
            line = line + 'password=' + self.dlg.PG_Password.text() + '\n'
            line = line + 'port=' + self.dlg.PG_Port.text() + '\n'
            line = line + 'schemaname=' + self.dlg.a4x.text() + '\n'
            l3l = str(self.dlg.mQgsProjectionSelectionWidget_Table.crs())
            l3l = l3l.replace("<QgsCoordinateReferenceSystem: ","").replace(">","")
            line = line + 'l3l=' + l3l + '\n'
            line = line + 'n2n=' + myGBL['n2n'] + '\n'
            line = line + 'o2o=' + myGBL['o2o'] + '\n'

            conf_file.write(line)
            conf_file.close()

        self.iface.messageBar().pushMessage(
            "Success", "Output file written at " + myGBL['ConFileName'],
            level=Qgis.Success, duration=3)

    except Exception as err:
        self.iface.messageBar().pushMessage(
        "Failure", err,
        level=Qgis.Success, duration=3)

def whatIsGoingOn(aStr):
    with open("log.WhatIsGoingOn", 'a') as outSQL_file:
        aDate = datetime.datetime.now().strftime(" %Y %B %d, %I:%M%p ")
        #'10:36AM on July 23, 2010'
        outSQL_file.write(aDate + ": " + aStr + "\n")
    outSQL_file.close

