# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Variable Panel
                                 A QGIS plugin
 The VariablePanel plugin displays project variables in a dedicated QGIS panel, allowing for easy access
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-11-16
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Alexandre Parente Lima
        email                : alexandre.parente@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QTimer, QSettings, QTranslator, QLocale ,QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from .variable_panel_dockwidget import VariablePanelDockWidget
from .resources import *

import os.path

class VariablePanel:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # Gets the locale configured in the system.
        self.settings = QSettings()
        locale = self.settings.value("locale/userLocale", QLocale.system().name())

        # Initialize locale
        locale_path = os.path.join(self.plugin_dir, 'i18n', 'VariablePanel_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr('&Variables Panel')
        self.toolbar = self.iface.addToolBar(self.tr("Variables ToolBar"))
        self.toolbar.setObjectName('VariablePanel')

        self.variable_dock = None

        self.sideDockWidgetArea = Qt.RightDockWidgetArea

    def tr(self,string):
        return QCoreApplication.translate('VariablePanel', string)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None,
        checkable=True):

        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(self.menu, action)
        self.actions.append(action)

        # Makes the button checkable
        action.setCheckable(checkable)

        return action

    # Initializes the GUI elements, including menu entries and toolbar icons, within the QGIS interface.
    def initGui(self):
        icon_path = ':/plugins/variable_panel/mIconExpression.svg'
        # Adds an action to QGIS with an icon, text label, and callback function.
        self.add_action(
            icon_path,
            text=self.tr('Variables Panel'),
            callback=self.toggleDockWidgetVisibility,
            parent=self.iface.mainWindow())

        # Initializes the dock widget in the specified side dock area.
        self.createDockWidget(self.sideDockWidgetArea)
        # Hides the dock widget initially.
        self.variable_dock.hide()

    # Toggles the visibility of the dock widget when the toolbar button is clicked.
    def toggleDockWidgetVisibility(self):
        if self.variable_dock is None:
            # Initializes the dock widget after it is closed
            self.createDockWidget(self.sideDockWidgetArea)
            # Makes the dock widget visible and brings it to the front.
            self.variable_dock.show()
            # Ensures that the dock is shown on top
            self.variable_dock.setUserVisible(True)
        else:
            # Used to show the dock when the plugin is restored on QGIS startup
            if self.variable_dock.isVisible():
                self.variable_dock.show()
            else:
                # Closes the dock widget if it is currently visible.
                self.variable_dock.close()

    # create the dock widget and its properties.
    def createDockWidget(self, sideDockWidgetArea):
        # Creates a new instance of the dock widget.
        self.variable_dock = VariablePanelDockWidget()

        # Allows the dock widget to be positioned on the left or right side of the interface.
        self.variable_dock.setAllowedAreas(Qt.LeftDockWidgetArea | Qt.RightDockWidgetArea)

        # Prevents the dock widget from being set as floating.
        self.variable_dock.setFloating(False)

        # Adds the dock widget to the QGIS interface in the specified area.
        self.iface.addDockWidget(self.sideDockWidgetArea, self.variable_dock)

        # Tabifies the dock widget, but no other dock widgets are targeted.
        self.iface.addTabifiedDockWidget(self.sideDockWidgetArea, self.variable_dock, [], True)

        # Links the dock widget's visibility toggle action with the toolbar button.
        self.variable_dock.setToggleVisibilityAction(self.actions[0])

        # Connects the signal to handle the closing of the dock widget.
        self.variable_dock.closed.connect(self.onDockWidgetClosed)

        # Connects the signal to track changes in the dock widget's location.
        self.variable_dock.dockLocationChanged.connect(self.onDockLocationChanged)

    # Handles actions to perform when the dock widget is closed.
    def onDockWidgetClosed(self):
        # Disconnects the signal to avoid redundant calls.
        self.variable_dock.closed.disconnect(self.onDockWidgetClosed)
        # Delays resetting the dock widget reference to avoid conflicts with Qt event handling.
        QTimer.singleShot(0, lambda: setattr(self, 'variable_dock', None))

    # Updates the stored dock widget location when its position changes.
    def onDockLocationChanged(self, area):
        self.sideDockWidgetArea = area

    # Unloads the plugin by removing its GUI elements from QGIS.
    def unload(self):
        # Removes each action from the QGIS menu and toolbar.
        for action in self.actions:
            self.iface.removePluginMenu(self.tr('&Variables Panel'), action)
            self.iface.removeToolBarIcon(action)
        # Deletes the toolbar reference to clean up resources.
        del self.toolbar
