# -*- coding: utf-8 -*-
"""
/***************************************************************************
 VariablePanel
                                 A QGIS plugin
 The VariablePanel plugin displays project variables in a dedicated QGIS panel, allowing for easy access
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-11-16
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Alexandre Parente Lima
        email                : alexandre.parente@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.PyQt import QtWidgets
from qgis.gui import QgsDockWidget, QgsVariableEditorWidget
from qgis.core import QgsExpressionContextUtils, QgsExpressionContext, QgsProject
from qgis.utils import iface
from qgis.PyQt.QtCore import QCoreApplication
from qgis.PyQt.QtWidgets import QVBoxLayout, QPushButton

def tr(string):
    return QCoreApplication.translate('@default', string)

class VariablePanelDockWidget(QgsDockWidget):

    def __init__(self, parent=None):
        """Constructor."""
        super(VariablePanelDockWidget, self).__init__(parent)

        # Set the panel title
        self.setWindowTitle(self.tr(f"Variables Panel"))
        self.setObjectName("VariablePanelDockWidget")

        # Create and configure the variable editor widget
        mapCanvas = iface.mapCanvas()  # Get the map canvas
        self.variable_editor_widget = QgsVariableEditorWidget()  # Create the variable editor widget

        #Create and configure Context
        self.createContext()

        # Configure the main layout
        layout = QVBoxLayout()  # Create a vertical layout
        layout.addWidget(self.variable_editor_widget)  # Add the variable editor to the layout

        # Create buttons
        self.apply_button = QtWidgets.QPushButton(self.tr("Apply"))
        self.cancel_button = QtWidgets.QPushButton(self.tr("Cancel"))
        self.ok_button = QtWidgets.QPushButton(self.tr("OK"))

        # Add the buttons to the layout
        button_layout = QtWidgets.QHBoxLayout()
        button_layout.addWidget(self.apply_button)
        button_layout.addWidget(self.cancel_button)
        button_layout.addWidget(self.ok_button)

        # Add the button layout to the main layout
        layout.addLayout(button_layout)

        # Create the container for the widget
        container = QtWidgets.QWidget()
        container.setLayout(layout)  # Set the layout in the container
        self.setWidget(container)  # Set the widget of the panel

        # Connect the Cancel button to the close function
        self.apply_button.clicked.connect(self.applyChanges)
        self.cancel_button.clicked.connect(self.closeDockWidget)
        self.ok_button.clicked.connect(self.applyAndClose)

        # Listen for changes in custom variables and metadata
        project = QgsProject.instance()  # Get the current QgsProject instance
        project.customVariablesChanged.connect(self.createContext)
        project.metadataChanged.connect(self.createContext)

    def closeDockWidget(self):
        """Closes and removes the DockWidget."""
        self.close()

    def applyChanges(self):
        """Applies the changes made to the variables."""
        expressionContext = QgsExpressionContext()
        expressionContext.appendScope(
            QgsExpressionContextUtils.projectScope(QgsProject.instance()))
        self.updateProjectVariables(expressionContext)

    def applyAndClose(self):
        """Applies the changes and closes the DockWidget."""
        expressionContext = QgsExpressionContext()
        expressionContext.appendScope(
            QgsExpressionContextUtils.projectScope(QgsProject.instance()))
        self.updateProjectVariables(expressionContext)
        self.close()

    def updateProjectVariables(self, expressionContext):
        """Reads the variables from the active scope and updates all project variables."""

        # Get the variables from the active scope
        current_variables = self.variable_editor_widget.variablesInActiveScope()

        # Convert the variables to a dictionary for setProjectVariables
        variablesDict = {}
        # Iterate over the variables in the active scope
        for var_name, var_value in current_variables.items():
            # Add each variable and its value to the dictionary
            variablesDict[var_name] = var_value

        # Update all the project variables at once
        QgsExpressionContextUtils.setProjectVariables(QgsProject.instance(), variablesDict)

        # Reload the context in the variable editor to reflect the updates
        self.variable_editor_widget.reloadContext()


    def createContext(self):
        """Called when custom variables or metadata are changed."""

        # Create a context for expressions
        expressionContext = QgsExpressionContext()

        # Add scopes to the context
        expressionContext.appendScope(
            QgsExpressionContextUtils.projectScope(QgsProject.instance()))  # Add the project scope

        # Configure the variable editor for the expression context
        self.variable_editor_widget.setContext(expressionContext)  # Set the context in the variable editor
        self.variable_editor_widget.reloadContext()  # Reload the context in the variable editor
        self.variable_editor_widget.setEditableScopeIndex(0)  # Set the first scope as editable