# -*- coding: utf-8 -*-
"""
/***************************************************************************
A QGIS plugin
 Vallaris
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
        begin                : 2021
        copyright            : i-bitz 2021
        email                : sales@i-bitz.co.th
***************************************************************************/
"""
import requests,time,json
import tempfile
# from SaraphiGetConnect.utils.utils import *
import pandas as pd
from vallaris.utils.utils import *
class VallarisAPI:

    def __init__(self,url='https://v2k.vallarismaps.com"',vallaris_version="1.2"):

        self.token = ''
        self.vallaris_version = vallaris_version
        self.url = url
        self.temp_path = tempfile.gettempdir()

    def logins(self,email,password):
        
        url = f"{self.url}/core/api/managements/1.0/login"
        payload = f'grant_type=password&accountType=email&username={email}&password={password}'
        headers = {
        'Content-Type': 'application/x-www-form-urlencoded'
        }
        response = requests.request("POST", url, headers=headers, data=payload)


        if response.status_code == 200:
            response = response.json()            
            token = response["accessToken"]
            self.token = token    
            apikey = self.get_apikey()
            return token,apikey
        else:
            return "error","error"     

    def logout(self):

        url =  f"{self.url}/core/api/managements/1.0/logout"
        payload={}
        headers = {
        'Authorization': 'Bearer ' + self.token            
        }

        response = requests.request("POST", url, headers=headers, data=payload)  
        self.apikey = ''
        self.token = ''
        return response.status_code

    def get_collections(self,type):
    
        url = f"{self.url}/core/api/features/1.0/collections?itemType={type}&sort=createdAt:desc"
        payload = {}
        headers = {
        'Content-Type': 'application/json',
        # 'Authorization': 'Bearer ' + self.token,
        "API-Key" : self.apikey
        }
        response = requests.get( url, headers=headers, data = payload)
        if response.status_code == 200:    
            try:
                response = response.json()["collections"]
                if len(response) > 0:
                    for n,d in enumerate(response):
                        if n == 0:
                            id=[]
                            title = []
                            itemType = []
                            description = []
                            id.append(d["id"])
                            title.append(d["title"])
                            itemType.append(d["itemType"])
                            if "description" in d :
                                description.append(d["description"])
                            else:
                                description.append("")
                        else:
                            id.append(d["id"])
                            title.append(d["title"])
                            itemType.append(d["itemType"])
                            if "description" in d :
                                description.append(d["description"])
                            else:
                                description.append("")
                    df = pd.DataFrame({"id": id,"title": title,"itemType":itemType,"description":description})
                    return df
                else:
                    return False
            except:
                return False

        else:
            return False             

    def create_collection(self,collection_json):

        url = f"{self.url}/core/api/features/1.0-beta/collections"
        collection_json = str(collection_json)
        collection_json = collection_json.replace("integer", "int")
        collection_json = collection_json.replace("'", '"')
        payload= collection_json 

        headers = {
        'Content-Type': 'application/json',
        # 'Authorization': 'Bearer '+self.token
        "API-Key" : self.apikey        
        }

        response = requests.post( url, headers=headers, data=payload.encode('utf-8'))

        if response.status_code == 201:
            response = response.json()
            collection_id = response['id']
            return collection_id  
        else:
            return False

    def get_collection(self,collection_id):

        url = f"{self.url}/core/api/features/1.0/collections/{collection_id}"

        payload = {}
        headers = {
        'Content-Type': 'application/json',
        # 'Authorization': 'Bearer ' + self.token
        "API-Key" : self.apikey        
        }
        response = requests.get( url, headers=headers, data = payload)

        if response.status_code == 200:    
            return response.json()        
        else:
            return False             
      
    def update_collection(self,collection_json,collection_id):
        
        url = f"{self.url}/core/api/features/1.0-beta/collections/{collection_id}"
        payload= str(collection_json).replace("'", '"') 

        headers = {
        'Content-Type': 'application/json',
        # 'Authorization': 'Bearer '+self.token
        "API-Key" : self.apikey        
        }

        response = requests.put( url, headers=headers, data=payload.encode('utf-8'))

        if response.status_code == 201:
            response = response.json()
            collection_id = response['id']
            return collection_id  
        else:
            return False            

    def collection_items_stream(self,collection_id,bbox = None,datetime=None,field=None):
        
        vallaris_path = self.temp_path+"/Vallaris"
        collection_vector_path =  create_floder(vallaris_path+"/"+collection_id+"/vector")
        collection_vector_file_path = collection_vector_path + "/"+collection_id+".geojson"                    
        page = 1
        self.break_ = True
        json_write = {}
        features_type_list = []

        url = f"{self.url}/core/api/features/1.0-beta/collections/{collection_id}/items/streaming?api_key={self.apikey}"
        if  bbox != None:
            if bbox != "0.0,0.0,0.0,0.0" :
                url = url+"&bbox="+bbox         
        if datetime != None :
            url = url+"&datetime="+datetime    
        if field != None :
            url = url+"&"+field               
        with requests.get(url, stream=True) as r:
            try: 
                r.raise_for_status()
                with open(collection_vector_file_path, 'wb') as f:
                    for chunk in r.iter_content(chunk_size=1024*1): 
                        f.write(chunk)   
                return collection_vector_file_path
            except requests.exceptions.HTTPError as e: 
                return False  

    def count_items(self,collection_id=None,bbox=None,datetime=None,field = None):

        url = f"{self.url}/core/api/features/1.0/collections/{collection_id}/items?limit=1&api_key={self.apikey}"
        if  bbox != None:
            if bbox != "0.0,0.0,0.0,0.0" :
                url = url+"&bbox="+bbox         
        if datetime != None :
            url = url+"&datetime="+datetime    
        if field != None :
            url = url+"&"+field     
        response = requests.get(url)  

        if response.status_code == 200: 
            return response.json()
        else:
            return False
            
    def delete_collection(self,collection_id):

        url = f"{self.url}/core/api/features/1.0-beta/collections/{collection_id}"

        payload={}
        headers = {
        'Content-Type': 'application/json',
        # 'Authorization': 'Bearer '+self.token 
        "API-Key" : self.apikey               
        }

        response = requests.delete( url, headers=headers, data=payload)
                   
    def create_items(self,collection_id,items):

        url = f"{self.url}/core/api/features/1.0-beta/collections/{collection_id}/items"
        payload= str(items).replace("'fid'", "'fid_'").replace("'", '"').replace("'", '"').replace("None", "null").replace("\\xa0"," ").replace("\\x1e","").replace("\\x9c","").replace("\\x92","").replace("\\","").replace("1212312121","'")
        headers = {
        'Content-Type': 'application/json',            
            # 'Authorization': 'Bearer '+self.token  
        "API-Key" : self.apikey              
        }

        for i in range(5):
            try:
                response = requests.post(url, headers=headers, data=payload.encode('utf-8'))
                if response.status_code == 201 : 
                    break     
                else:
                    break

                                    
            except:
                time.sleep(3)
        if response.status_code == 201 : 
            return True
        else:                
            return False

    def update_items(self,collection_id,items_id,items):
        
        url = f"{self.url}/core/api/features/1.0-beta/collections/{collection_id}/items/{items_id}"
        items = str(items)        
        items = items.replace("None", "''")
        items = str(items).replace("'", '"')
        payload= items

        headers = {
            'Content-Type': 'application/json',
            # 'Authorization': 'Bearer '+self.token
            "API-Key" : self.apikey            
        }
        response = requests.put(url, headers=headers, data=payload.encode('utf-8'))


    def delete_items(self,collection_id,items_id=None,forever=None):

        if items_id != None:
            url = f"{self.url}/core/api/features/1.0-beta/collections/{collection_id}/items/{items_id}"
        if forever == True:
            url = f"{self.url}/core/api/features/1.0-beta/collections/{collection_id}/items?forever=true"
    
        payload={}
        headers = {
        'Content-Type': 'application/json',
        # 'Authorization': 'Bearer '+self.token 
        "API-Key" : self.apikey              
        }
        response = requests.delete( url, headers=headers, data=payload)

    
    def vectortile_style(self):
        url = "https://maps.osgeo.in.th/styles/thailand_basemap_1.0/style.json"

        payload = {}
        headers = {}
        response = requests.get( url, headers=headers, data = payload)
        response = response.json()

        return response  

    def get_tiles(self,collection_id):

        url = f"{self.url}/core/api/tiles/1.0-beta/tiles/{collection_id}?api_key={self.apikey}"

        payload={}
        headers = {
        'Content-Type': 'application/json'
        # 'Authorization': 'Bearer '+self.token     
        }

        response = requests.get( url, headers=headers, data=payload)
        
        if response.status_code == 200 :
            response = response.json()
            return response 
        else:
            return False

    def get_apikey(self):

        url = f"{self.url}/core/api/managements/1.0/apikeys?default=true"
        payload={}
        headers = {
        'Content-Type': 'application/json',
        'Authorization': 'Bearer '+self.token               
        }
        response = requests.get( url, headers=headers, data=payload)
        apikey = False
        if response.status_code == 200:
     
            apikeyList =response.json()['apiKeys']
            apikey = apikeyList[0]["apiKey"]
            self.apikey =  apikey 
            return apikey
        else:
            return False

    def get_apikey_permission(self):

        url = self.url + "/api/utilities/1.0/apikeys"

        payload={}
        headers = {
        'Content-Type': 'application/json',
        'Authorization': 'Bearer '+self.token               
        }

        response = requests.get( url, headers=headers, data=payload)
        apikey = False
        if response.status_code == 200:
            apikeyList =response.json()['apikeys']
            for k in apikeyList:
                if k["enabled"] == False:
                    continue
                if k["config"]["advance"]["style"]["permissionRole"] == "disable":
                    continue
                apikey = k["apikey"]
                if apikey != False:
                    return  apikey 
            return  apikey 
        else:
            return apikey 


    def gen_single_tile(self,json_format,collection_id):
        
        url = self.url + "/core/api/processes/vallaris/214bffaba098493005c5/"+collection_id
        payload=str(json_format).replace("'", '"')
        headers = {
        'Content-Type': 'application/json', 
        'API-Key' :    self.apikey   
        }        

        response = requests.post(url, headers=headers, data=payload.encode('utf-8'))
        if response.status_code == 200 :
            return True
        else:
            return False       

    def gen_multi_tile(self,json_format):

        url = self.url + "/core/api/processes/vallaris/21461faee1167f0c6532"
        payload=str(json_format).replace("'", '"')
        headers = {
        'Content-Type': 'application/json', 
        'API-Key' :   self.apikey   
        }        
        response = requests.post(url, headers=headers, data=payload.encode('utf-8'))

        if response.status_code == 200 :
            return True
        else:
            return False       

    def get_styles(self):

        url =  f"{self.url}/core/api/styles/1.0-beta/styles?sort=createdAt:desc"
        headers = {
            # 'Authorization': 'Bearer '+self.token  
        "API-Key" : self.apikey            
        }
        response = requests.get( url, headers=headers)     

        if response.status_code == 200 :
            response = response.json()
            if len(response["styles"])> 0:
                title = []
                styleID = []
                description = []
                for item in response["styles"]:
                    try:
                        title.append(item["title"])
                    except:
                        title.append(" ")
                    if "description" in item :
                        description.append(item["description"])
                    else:
                        description.append("")
                    styleID.append(item["id"])
                style = pd.DataFrame({"styleID":styleID,"title": title,"description":description})                  
                return style
            else:
                return False
        else:
            print(response.status_code,response.text)

    def get_style(self,styleID,apikey):

        url = f'{self.url}/core/api/styles/1.0-beta/styles/{styleID}?api_key={apikey}'
        response = requests.get( url)
        if response.status_code == 200 :
            return url,response.json()
        else:
            return url,False  

    def delete_style(self,styleID,apikey) :
        url = self.url + "/api/1.0-beta/styles/"+styleID+"?api_key="+apikey
        if self.vallaris_version == "1.3":
            url = self.url + "/api/styles/1.0-beta/styles/"+styleID+"?api_key="+apikey
        response = requests.delete(url)
        if response.status_code == 200 :
            return True
        else:
            return False        
                 
