# -*- coding: utf-8 -*-
"""
/***************************************************************************
A QGIS plugin
 Vallaris
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
        begin                : 2021
        copyright            : i-bitz 2021
        email                : sales@i-bitz.co.th
***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .Vallaris_dialog import *
import os.path,tempfile,json,datetime
from vallaris.vallaris_module.vallaris_core import *
from qgis.core import *
from qgis.utils import iface,Qgis

class CustomCombo(QtWidgets.QComboBox):
    
    enter_pressed = QtCore.pyqtSignal()

    def __init__(self, parent=None):
        super().__init__(parent)

    def keyPressEvent(self, event):
        if event.key() == QtCore.Qt.Key_Return:
            self.enter_pressed.emit()
        else:
            QtWidgets.QComboBox.keyPressEvent(self, event)  
            # if the key is not return, handle normally

class VallarisDesktop:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'VallarisDesktop_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Vallaris Desktop')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('VallarisDesktop', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToDatabaseMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/Vallaris/img/logo.svg'
        self.add_action(
            icon_path,
            text=self.tr(u'Vallaris Desktop'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginDatabaseMenu(
                self.tr(u'&Vallaris'),
                action)
            self.iface.removeToolBarIcon(action)

    def keyPressEvent(self, event):
        if event.key() == QtCore.Qt.Key_Return:
            self.btnAction()
    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg_logins = VallarisDesktopDialog1()
            self.dlg_main = VallarisDesktopDialog2()
            self.dlg_features = VallarisDesktopDialog3()
            self.dlg_new_collection = VallarisDesktopDialog4()
            self.dlg_new_tile = VallarisDesktopDialog5()
            self.dlg_manage_user = VallarisDesktopDialog6()
            self.dlg_style = VallarisDesktopDialog7()
            dlg =[self.dlg_logins,self.dlg_main,self.dlg_features,self.dlg_new_collection,self.dlg_new_tile,self.dlg_manage_user,self.dlg_style]
            self.dlg = dlg
            # url = "https://v2k-dev.vallarismaps.com/core"


            self.VallarisCore = VallarisCore(dlg,self.iface)
            self.VallarisCore.get_server_from_db()
            self.VallarisCore.get_user_from_db()
            self.vallaris_dialig = ManagerDialog(dlg,iface)
            self.dlg_logins.server.currentIndexChanged.connect(self.VallarisCore.get_user_from_db) 
            # self.dlg_logins.server.editTextChanged.connect(self.VallarisCore.get_user_from_db)  
            self.dlg_logins.email.currentTextChanged.connect(self.VallarisCore.get_pass_from_db) 
            self.dlg_logins.email.currentIndexChanged.connect(self.VallarisCore.manage_user)
            self.dlg_manage_user.back.clicked.connect(self.VallarisCore.back_from_manage_user) 
            self.dlg_manage_user.remove.clicked.connect(self.VallarisCore.remove_user) 
            self.dlg_main.search.textChanged.connect(self.VallarisCore.search_)
            self.dlg_logins.password.returnPressed.connect(self.VallarisCore.logins)      
            self.dlg_logins.login.clicked.connect(self.VallarisCore.logins)
            self.dlg_main.logout.clicked.connect(self.VallarisCore.logout)  
            self.dlg_main.refresh.clicked.connect(self.VallarisCore.refresh_collection)          
            self.dlg_main.edit.clicked.connect(self.VallarisCore.edit)
            self.dlg_main.tile.clicked.connect(self.VallarisCore.tile)
            self.dlg_main.features.clicked.connect(self.VallarisCore.features)
            self.dlg_main.style.clicked.connect(self.VallarisCore.style)
            self.dlg_style.back_from_style.clicked.connect(self.VallarisCore.back_from_style)
            self.dlg_style.deleteStyle.clicked.connect(self.VallarisCore.delete_style)
            self.dlg_style.loadMapsService.clicked.connect(self.VallarisCore.get_maps_service)
            self.dlg_main.new_.clicked.connect(self.VallarisCore.newFeaturesCollection)
            # self.dlg_main.new_.clicked.connect(self.VallarisCore.edit_tile)
            self.dlg_new_tile.deleteTile.clicked.connect(self.VallarisCore.delete_tile)
            self.dlg_main.newTile.clicked.connect(self.VallarisCore.newTileollection)
            self.dlg_main.collectionList.itemActivated.connect(self.VallarisCore.edit)  
            # self.dlg_main.collectionList.itemActivated.connect(self.VallarisCore.edit)  
            self.dlg_features.load_features.clicked.connect(self.VallarisCore.get_items)
            self.dlg_features.update_features.clicked.connect(self.VallarisCore.update_collection_items)
            self.dlg_features.delete_features.clicked.connect(self.VallarisCore.delete_collection)
            self.dlg_new_collection.refresh.clicked.connect(self.VallarisCore.add_layer_to_layerList)
            self.dlg_new_tile.back.clicked.connect(self.VallarisCore.back_from_tile)
            self.dlg_features.back.clicked.connect(self.VallarisCore.back_from_features)
            self.dlg_new_collection.back.clicked.connect(self.VallarisCore.back_from_new_collection)
            self.dlg_new_collection.createNewFeatures.clicked.connect(self.VallarisCore.create_new_collection) 
            self.dlg_new_collection.old_collection.toggled.connect(self.VallarisCore.import_selection)
            self.dlg_new_collection.new_collection.toggled.connect(self.VallarisCore.import_selection)
            # self.iface.layerTreeView().currentLayerChanged.connect(self.VallarisCore.add_layer_to_layerList)
            self.dlg_features.extent.collapsedStateChanged.connect(self.VallarisCore.dlg_extent_manage)
            self.dlg_features.properties.collapsedStateChanged.connect(self.VallarisCore.dlg_properties_manage) 
            self.dlg_features.datetime.collapsedStateChanged.connect(self.VallarisCore.dlg_datetime_manage)        
            self.dlg_new_tile.add_tile.clicked.connect(self.VallarisCore.add_tile_tolist) 
            self.dlg_new_tile.removeTile.clicked.connect(self.VallarisCore.remove_tile_in_list) 
            self.dlg_new_tile.genTile.clicked.connect(self.VallarisCore.gen_tile)        
            

            #set current date and time to the object
            self.dlg_features.st_date.setDateTime(datetime.datetime.now().replace(hour=0, minute=0))
            self.dlg_features.end_date.setDateTime(datetime.datetime.now())


            self.vallaris_dialig.manager_dialog()
            # self.dlg.show()
            # self.manager_dialog()
        else:
            self.temp_path = tempfile.gettempdir() 
            # self.Vallaris_temp_path = self.temp_path+"/vallaris" 
            self.nowDialog_path = self.temp_path+"/nowDialog.json"  

            try:    
                with open(self.nowDialog_path, encoding='utf-8') as fh:
                    data = json.load(fh)    
                if data["nowDialog"] == "dlg_main":     
                    if data["apikey"] != None:
                        self.vallaris_dialig = ManagerDialog(self.dlg,iface,data["apikey"])
                        self.vallaris_dialig.manager_dialog(self.dlg_main)
                    else:
                        self.vallaris_dialig.manager_dialog()
                elif data["nowDialog"] == "dlg_collection":     
                    if data["apikey"] != None:
                        self.vallaris_dialig = ManagerDialog(self.dlg,iface,data["apikey"])
                        self.vallaris_dialig.manager_dialog(self.dlg_features)
                    else:
                        self.vallaris_dialig.manager_dialog()
                elif data["nowDialog"] == "dlg_new_collection":     
                    if data["apikey"] != None:
                        self.vallaris_dialig = ManagerDialog(self.dlg,iface,data["apikey"])
                        self.vallaris_dialig.manager_dialog(self.dlg_new_collection)
                    else:
                        self.vallaris_dialig.manager_dialog()

                elif data["nowDialog"] == "dlg_new_tile":     
                    if data["apikey"] != None:
                        self.vallaris_dialig = ManagerDialog(self.dlg,iface,data["apikey"])
                        self.vallaris_dialig.manager_dialog(self.dlg_new_tile)
                    else:
                        self.vallaris_dialig.manager_dialog()

                elif data["nowDialog"] == "dlg_style":     
                    if data["apikey"] != None:
                        self.vallaris_dialig = ManagerDialog(self.dlg,iface,data["apikey"])
                        self.vallaris_dialig.manager_dialog(self.dlg_style)
                    else:
                        self.vallaris_dialig.manager_dialog()

                else:
                    self.vallaris_dialig.manager_dialog()

            except:
                self.vallaris_dialig.manager_dialog()


        # # show the dialog
        # self.dlg.show()
        # Run the dialog event loop
        # result = self.dlg.exec_()
        # # See if OK was pressed
        # if result:
        #     # Do something useful here - delete the line containing pass and
        #     # substitute with your code.
        #     pass


