# -*- coding: utf-8 -*-
"""
/***************************************************************************
A QGIS plugin
 Vallaris
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
        begin                : 2021
        copyright            : i-bitz 2021
        email                : sales@i-bitz.co.th
***************************************************************************/
"""
import os.path
from re import T
import tempfile
import base64
import shutil
import json
import time
import hashlib
import webbrowser
import datetime
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QUrl, Qt
from qgis.PyQt.QtGui import QIcon, QColor, QCursor
from qgis.PyQt.QtWidgets import *
from qgis.PyQt.QtWebKit import QWebSettings
from qgis.PyQt.QtWebKitWidgets import QWebView, QWebInspector, QWebPage
from PyQt5 import QtCore
from qgis.core import *
from qgis.utils import iface, Qgis
import pandas as pd
from vallaris.vallaris_module import range_slider
from vallaris.utils.utils import *
from vallaris.vallaris_module.vallaris_api import *
from vallaris.vallaris_module.manager_dialog import *
from vallaris.DB.db import *


class VallarisCore:
    def __init__(self, dlg, iface):
        self.iface = iface
        self.preview = QWebView()

        # all dialog
        self.dlg = dlg
        self.dlg_logins = dlg[0]
        self.dlg_main = dlg[1]
        self.dlg_features = dlg[2]
        self.dlg_new_collection = dlg[3]
        self.dlg_new_tile = dlg[4]
        self.dlg_manage_user = dlg[5]
        self.dlg_style = dlg[6]

        self.tile_collection = None
        self.features_collection = None

        # tile list
        self.tileList = pd.DataFrame(
            columns=['name', 'id', 'cluster', 'minzoom', 'maxzoom'])

        # API url and API
        self.get_url()

        # Vallaris API
        self.dlg_logins.server.currentIndexChanged.connect(self.get_url)
        self.dlg_logins.server.editTextChanged.connect(self.get_url)
        self.dlg_features.condition.currentIndexChanged.connect(self.like_)
        # self.vallaris_api = VallarisAPI(self.url)
        self.vallaris_dialig = ManagerDialog(dlg, iface)

        # set collection type
        self.collectionType = "Feature"

        # Temp path
        self.temp_path = tempfile.gettempdir()
        self.Vallaris_temp_path = self.temp_path+"/vallaris"

        # create temp floder
        create_floder(self.Vallaris_temp_path)

        # vector type list
        self.type_list = ["Polygon", "LineString", "Point"]

        ## import QMessageBox
        self.message_box = QMessageBox()
        self.dlg_new_tile.deleteTile.hide()

        ## import slider
        self.slider = range_slider.RangeSlider(QtCore.Qt.Horizontal)
        grid = QGridLayout()
        grid.addWidget(self.slider, 0, 0)
        self.dlg_new_tile.view.setLayout(grid)
        # slider = range_slider.RangeSlider(self.dlg_new_tile.horizontalSlider)
        self.slider.setMinimumHeight(25)
        self.slider.setMinimum(0)
        self.slider.setMaximum(24)
        self.slider.setLow(0)
        self.slider.setHigh(14)
        self.slider.sliderMoved.connect(self.echo)
        self.slider.setTickPosition(QtWidgets.QSlider.TicksBelow)
        self.dlg_new_tile.min.setText("Min: 0")
        self.dlg_new_tile.max.setText("Max: 14")
        self.dlg_new_tile.view.setMinimumSize(310, 25)
        self.dlg_new_tile.view.setMaximumSize(310, 25)
        # widget
        self.slider.show()
        # self.slider.raise_()
        # app.exec_()
        self.dlg_new_tile.tile_name.setReadOnly(False)
        self.dlg_new_tile.tile_description.setReadOnly(False)
        # create db user file for
        os.chdir(os.path.dirname(__file__))
        self.folder_path = os.getcwd().split("vallaris_module")[0]
        self.temp_path = tempfile.gettempdir()
        self.user_db = DB(self.folder_path+"DB", "VallarisManage")
        tb_name = "User"
        try:
            colum_list = ["id integer PRIMARY KEY AUTOINCREMENT",
                          "server text", "email text", "password text"]
            self.user_db.create_db(tb_name, colum_list)
        except:
            pass

    def get_url(self):
        vallaris_version = "1.3"
        if self.dlg_logins.server.currentText() == "Vallaris Cloud":
            self.url = "https://cloud.vallarismaps.com/core"
        elif self.dlg_logins.server.currentText() == "Vallaris EDU":
            self.url = "https://edu.vallarismaps.com/core"
        else:
            self.url = self.dlg_logins.server.currentText()+"/core"
            vallaris_version = "1.3"
        self.vallaris_api = VallarisAPI(self.url, vallaris_version)

    def get_server_from_db(self):

        server = self.dlg_logins.server.currentText()
        server_list = self.user_db.select("select * from User")
        server_data = []
        for i in server_list:
            server_data.append(i)

        if len(server_data) != 0:
            server_list = []
            self.dlg_logins.server.clear()
            self.dlg_logins.server.addItem("Vallaris Cloud")
            self.dlg_logins.server.addItem("Vallaris EDU")

            for i in server_data:
                if i[1] != "Vallaris Cloud" and i[1] != "Vallaris EDU":
                    server_list.append(i[1])
            self.dlg_logins.server.addItems(set(server_list))
            self.dlg_logins.password.setText("")
        else:
            self.dlg_logins.server.clear()
            self.dlg_logins.server.addItem("Vallaris Cloud")
            self.dlg_logins.server.addItem("Vallaris EDU")
            self.dlg_logins.password.setText("")

    def get_user_from_db(self):

        self.get_url()
        server = self.dlg_logins.server.currentText()
        email_list = []
        if self.dlg_logins.server.currentText() != "Vallaris Cloud" and self.dlg_logins.server.currentText() != "Vallaris EDU":
            self.serverLinke = self.dlg_logins.server.currentText()
        elif self.dlg_logins.server.currentText() == "Vallaris EDU":
            self.serverLinke = "https://edu.vallarismaps.com"
        elif self.dlg_logins.server.currentText() == "Vallaris Cloud":
            self.serverLinke = "https://cloud.vallarismaps.com"

        user_list = self.user_db.select(
            "select * from User where server = '"+server+"'")

        urlLink = '''<html><head/><body><p align="center"><span style=" color:#385f6b;">Forgot password? </span><a href="'''+self.serverLinke+'''/management/forgot-password"><span style=" text-decoration: underline; color:#b2c756;">Recover</span></a></p><p align="center"><span style=" color:#385f6b;">Don't have an account? </span><a href="''' + \
            self.serverLinke+'''/management/signup"><span style=" text-decoration: underline; color:#b2c756;">Sign Up</span></a></p></body></html>'''

        self.dlg_logins.forgot_password_sign_up.setText(urlLink)
        self.dlg_logins.email.clear()
        self.dlg_logins.email.addItem("")
        data = []
        for i in user_list:
            data.append(i)
        if len(data) != 0:
            server_list = []
            # email_list =[]
            self.dlg_logins.email.clear()
            self.dlg_logins.email.addItem("")
            for i in data:
                email_list.append(i[2])
            self.dlg_logins.email.addItems(email_list)
            self.dlg_logins.email.addItem("Manage users 🔑")
            self.dlg_logins.password.setText("")
            self.dlg_logins.email.setFocus()
        else:
            self.dlg_logins.email.clear()
            self.dlg_logins.password.setText("")
            self.dlg_logins.email.setFocus()

    def get_pass_from_db(self):

        self.get_url()
        current_server = self.dlg_logins.server.currentText()
        # if current_server == "Vallaris Cloud":
        #     current_server = "Vallaris Cloud"
        email = self.dlg_logins.email.currentText()
        sql_cmd = "SELECT * FROM User WHERE server ="+"'" + \
            str(current_server)+"' AND email = "+"'"+email+"'"
        user_list = self.user_db.select(sql_cmd)
        user = ()
        for i in user_list:
            user = i
        try:
            pass_hex = user[3].split("'")[1]
            password = base64.b64decode(
                bytes(pass_hex, 'utf-8')).decode("utf-8")
            self.dlg_logins.password.setText(password)
            # self.dlg_logins.password.setFocus()
        except:
            self.dlg_logins.password.setText("")
            pass
            # self.dlg.password.setText("")

    def logins(self):

        if checkNetConnection() == True:
            email = self.dlg_logins.email.currentText().strip()
            password = self.dlg_logins.password.text().strip()
            server = self.dlg_logins.server.currentText().strip()
            password_hex = base64.b64encode(password.encode("utf-8"))

            self.token, self.apikey = self.vallaris_api.logins(email, password)
            if self.token != "error":
                if self.dlg_logins.remember.isChecked():
                    table_name = "User"
                    sql_cmd = 'SELECT * FROM User WHERE server = '+"'"+server+"' AND"
                    sql_cmd = sql_cmd + " email = '"+email + "'"
                    data = self.user_db.select(sql_cmd)
                    user_list = []
                    for d in data:
                        user_list.append(d)

                    if len(user_list) != 0:
                        data = [["server", str(server)], ["email", str(email)], [
                            "password", str(password_hex)]]
                        self.user_db.update(table_name, data, user_list[0][0])
                    else:
                        data = [["server", str(server)], ["email", str(email)], [
                            "password", str(password_hex)]]
                        self.user_db.insert(table_name, data)

                self.get_collection_list()
                self.collectionType = "Feature"
                self.ItemsCollection()
                create_floder(self.Vallaris_temp_path)
                self.vallaris_dialig = ManagerDialog(
                    self.dlg, iface, self.apikey)
                self.vallaris_dialig.manager_dialog(self.dlg_main)

            else:
                message = "Incorrect email or password."
                self.message_box.warning(
                    self.iface.mainWindow(), 'Warning', message)
                self.vallaris_dialig.manager_dialog(self.dlg_logins)

        else:
            message = "No internet connection."
            self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)

    def logout(self):

        self.vallaris_dialig.manager_dialog(self.dlg_logins)
        self.dlg_logins.email.setFocus()
        self.get_server_from_db()
        self.dlg_logins.email.setCurrentIndex(0)
        self.dlg_logins.remember.setChecked(False)
        self.token = ""
        self.apikey = ""
        self.dlg_main.search.setText((""))
        try:
            shutil.rmtree(self.Vallaris_temp_path, ignore_errors=True)
        except:
            pass

    def edit(self):
        if checkNetConnection() == True:
            if self.dlg_main.collectionList.currentRow() != -1:
                self.get_colectionID()
                if self.nowCollectionType == "Feature":
                    
                    self.dlg_features.st_date.setDateTime(datetime.datetime.now().replace(hour=0, minute=0))
                    self.dlg_features.end_date.setDateTime(datetime.datetime.now())
                    QgsProject.instance().setCrs(QgsCoordinateReferenceSystem(4326))
                    res = self.vallaris_api.count_items(
                        collection_id=self.collectionID)
                    if res != False:
                        list_key = list(res["features"][0]["properties"].keys())
                        vallaris_key = ['_collectionId', '_createdAt',
                                        '_createdBy', '_id', '_updatedAt', '_updatedBy']
                        self.dlg_features.field.clear()
                        for key_ in list_key:
                            if key_ not in vallaris_key:
                                self.dlg_features.field.addItem(key_)
                    self.vallaris_dialig.manager_dialog(self.dlg_features)
                    self.dlg_features.collection_name.setText(
                        " Features Name : "+self.collection_title)
                    self.dlg_features.collection_des.setText(
                        " Description : "+self.collection_description)
                elif self.nowCollectionType == "Tile":
                    self.get_tile_collection()
                elif self.nowCollectionType == "Style":
                    # self.getStyle()
                    self.go_to_style()
            else:
                # if self.dlg_main.new_.text() != "Import":
                message = "Select collection."
                self.iface.messageBar().pushMessage("infomation  ", message, level=0, duration=3)
        else:
            message="No internet connection."
            self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)

    def go_to_style(self):
        QGIS_version = Qgis.QGIS_VERSION_INT
        self.dlg_style.mapsService.setCurrentIndex(0)

        if checkNetConnection() == True:
            if QGIS_version >= 31400:
                self.api_key_permission = self.vallaris_api.get_apikey_permission()
                if self.api_key_permission == False:
                    message = f"Must have at least an API key with view permissions. <a href='{self.serverLinke}/management/account/apikeys'>{self.serverLinke}/management/account/apikeys</a>"
                    self.message_box.warning(
                    self.iface.mainWindow(), 'Warning', message)
                else:
                    styleUrl, res_style = self.vallaris_api.get_style(
                        self.collectionID,self.api_key_permission)
                    if res_style != False:
                        styleList = []
                        for sources in res_style["sources"]:
                            styleList.append(
                                [sources, res_style["sources"][sources]["url"]])

                    bounds = [97.3758964376, 5.69138418215,
                            105.589038527, 20.4178496363]
                    xMin = []
                    yMin = []
                    xMax = []
                    yMax = []
                    tilecount = 0
                    for b in styleList:
                        if len(b[0]) != 24:

                            continue
                        else:
                            try:
                                tID = str(b[1]).split("tiles/")[-1].split("?")[0]
                                res = self.vallaris_api.get_tiles(tID)
                                xMin.append(res["bounds"][0])
                                yMin.append(res["bounds"][1])
                                xMax.append(res["bounds"][2])
                                yMax.append(res["bounds"][3])
                                tilecount += 1
                            except:
                                pass
                    if tilecount != 0:
                        bounds = [min(xMin), min(yMin), max(xMax), max(yMax)]
                    html_file = write_js_file(styleUrl, bounds)

                    self.vallaris_dialig.manager_dialog(self.dlg_style)

                    self.dlg_style.style_name.setText(
                        " Style Name : "+self.collection_title)
                    self.dlg_style.style_des.setText(
                        " Description : "+self.collection_description)
                    self.preview.settings().clearMemoryCaches()
                    lay = QVBoxLayout(self.dlg_style.preview)
                    nowpath = str(os.getcwd()).replace("vallaris_module", "")
                    # html_file = f'{nowpath}/preview/index.html'
                    self.preview.setUrl(QUrl.fromLocalFile(html_file))
                    lay.removeWidget(self.preview)
                    lay.addWidget(self.preview)
            else:
                message = "QGIS version does not support vector tiles. QGIS Minimum Version 3.14"
                self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)
        else:
            message = "No internet connection."
            self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)

    def get_maps_service(self):
        if checkNetConnection() == True:
            if self.dlg_style.mapsService.currentText() == "Style":
                self.getStyle()

            elif self.dlg_style.mapsService.currentText() == "WMS":
                self.get_wms()

            elif self.dlg_style.mapsService.currentText() == "WMTS":
                self.get_wmts()
            elif self.dlg_style.mapsService.currentText() == "TMS":
                self.get_tms()

        else:
            message = "No internet connection."
            self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)

    def back_from_style(self):
        styleUrl =""
        bounds = []
        html_file = write_js_file(styleUrl, bounds)
        self.vallaris_dialig.manager_dialog(self.dlg_main)

    def back_from_features(self):
        self.vallaris_dialig.manager_dialog(self.dlg_main)
        self.dlg_features.extent.setOutputExtentFromOriginal()
        self.dlg_features.value_query.setText("")
        self.dlg_features.condition.setCurrentIndex(0)

    def manage_user(self):
        self.dlg_logins.email.currentText().strip()
        if self.dlg_logins.email.currentText().strip() == "Manage users 🔑":
            self.vallaris_dialig.manager_dialog(self.dlg_manage_user)
            server = self.dlg_logins.server.currentText()
            self.user_list = self.user_db.select(
                "select * from User where server = '"+server+"'").fetchall()

            for i in reversed(range(self.dlg_manage_user.user.rowCount())):
                self.dlg_manage_user.user.removeRow(i)

            for user in self.user_list:
                row = self.dlg_manage_user.user.rowCount()
                self.dlg_manage_user.user.setRowCount(row+1)
                col = 0
                for i in list(user)[1:]:
                    cell = QTableWidgetItem(str(i))
                    self.dlg_manage_user.user.setItem(row, col, cell)
                    col += 1
        else:
            self.dlg_logins.password.setFocus()

    def remove_user(self):

        if self.dlg_manage_user.user.currentRow() != -1:
            server = list(
                self.user_list[self.dlg_manage_user.user.currentRow()])[1]
            email = list(
                self.user_list[self.dlg_manage_user.user.currentRow()])[2]
            sql = "delete from User where server = '"+server+"' and email = '"+email + "'"

            message = "Are you sure you want to delete this user?"
            self.message_box.setIcon(QMessageBox.Warning)
            self.message_box.setText(message)
            self.message_box.setWindowTitle("Delete User")
            self.message_box.setStandardButtons(
                QMessageBox.Cancel | QMessageBox.Ok)
            returnValue = self.message_box.exec()

            if returnValue == QMessageBox.Ok:
                self.user_db.execute(sql)
                self.manage_user()
                self.get_server_from_db()

    def back_from_manage_user(self):

        self.vallaris_dialig.manager_dialog(self.dlg_logins)
        self.dlg_logins.email.setCurrentIndex(0)

    def tile(self):

        # self.vallaris_dialig.manager_dialog(self.dlg_new_tile)
        # self.slider.setLow(0)
        # self.slider.setHigh(14)
        self.dlg_main.new_.show()
        # self.get_collection_list()
        self.dlg_main.search.setText((""))
        self.collectionType = "Tile"
        self.dlg_main.new_.setStyleSheet(
            '''
            QPushButton {
            color:white;
            background-color:#B2C756;
            border: 1px solid #B2C756;
            border-radius: 10px;
            border: 4px solid #black;
            padding: 4px;
            font-size: 12px;
            height:18px;
            width:60px;
            }
            QPushButton:hover
            {
            background-color:#798B46;
            border-color: #798B46;
            color:white

            }            
            '''
        )
        self.tileCollection()

    def features(self):

        self.dlg_main.search.setText((""))
        self.dlg_main.new_.setStyleSheet(
            '''
            QPushButton {
            color:white;
            background-color:#B2C756;
            border: 1px solid #B2C756;
            border-radius: 10px;
            border: 4px solid #black;
            padding: 4px;
            font-size: 12px;
            height:18px;
            width:60px;
            }
            QPushButton:hover
            {
            background-color:#798B46;
            border-color: #798B46;
            color:white

            }            
            '''
        )
        self.collectionType = "Feature"
        self.dlg_main.new_.show()
        # self.get_collection_list()
        self.ItemsCollection()

    def style(self):

        self.dlg_main.search.setText((""))
        self.dlg_main.new_.setStyleSheet(
            '''QPushButton {
            color:white;
            background-color:#F88078;
            border: 1px solid #F88078;
            border-radius: 10px;
            border: 4px solid #black;
            padding: 4px;
            font-size: 12px;
            height:18px;
            width:60px;
            }
            QPushButton:hover
            {
            background-color:#F44336;
            border-color: #F44336;
            color:white

            }'''
        )
        self.collectionType = "Style"
        self.dlg_main.newTile.hide()
        # self.dlg_main.new_.hide()
        # self.dlg_main.new_.setText("Delete")
        self.dlg_main.new_.hide()
        self.dlg_main.edit.setText("Preview")
        # self.get_collection_list()
        self.styleCollection()

    def delete_style(self):
        if self.nowCollectionType == "Style":
            if self.dlg_main.collectionList.currentRow() != -1:
                if checkNetConnection() == True:
                    message = "Are you are sure you want to delete this style collection?"
                    self.message_box.setIcon(QMessageBox.Warning)
                    self.message_box.setText(message)
                    self.message_box.setWindowTitle("delete style")
                    self.message_box.setStandardButtons(
                        QMessageBox.Cancel | QMessageBox.Ok)
                    returnValue = self.message_box.exec()

                    if returnValue == QMessageBox.Ok:
                        self.vallaris_api.delete_style(self.collectionID)
                        self.style = self.vallaris_api.get_styles()
                        self.styleCollection()
                        self.back_from_style()

                else:
                    message = "No internet connection."
                    self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)

    def back_from_tile(self):
        self.dlg_new_tile.tile_name.setReadOnly(False)
        self.dlg_new_tile.tile_description.setReadOnly(False)
        self.vallaris_dialig.manager_dialog(self.dlg_main)
        self.tileList = pd.DataFrame(
            columns=['name', 'id', 'cluster', 'minzoom', 'maxzoom'])
        self.dlg_new_tile.genTileList.clear()
        self.slider.setLow(0)
        self.slider.setHigh(14)
        self.dlg_new_tile.deleteTile.hide()
        self.dlg_new_tile.genTile.setText("Gen Tile")

    def back_from_new_collection(self):
        self.dlg_new_collection.selected_features.setChecked(False)
        self.dlg_new_collection.collection_name.setText("")
        self.dlg_new_collection.collection_description.setText("")
        self.dlg_new_collection.new_collection.setChecked(True)
        self.vallaris_dialig.manager_dialog(self.dlg_main)

    def refresh_collection(self):
        self.get_collection_list()
        if self.collectionType == "Feature":
            self.ItemsCollection()
        elif self.collectionType == "Tile":
            self.tileCollection()
        elif self.collectionType == "Style":
            self.styleCollection()
        self.dlg_main.search.setText((""))

    def search_(self):
        if self.collectionType == "Feature":
            self.ItemsCollection()
        elif self.collectionType == "Tile":
            self.tileCollection()
        elif self.collectionType == "Style":
            self.styleCollection()

    def get_collection_list(self):
        self.features_collection = self.vallaris_api.get_collections("Feature")
        self.tile_collection = self.vallaris_api.get_collections("Tile")
        self.style = self.vallaris_api.get_styles()

    def ItemsCollection(self):

        self.dlg_main.setWindowTitle("Features Collection")
        if type(self.features_collection) == pd.core.frame.DataFrame:
            if self.collectionType == "Feature":
                self.dlg_new_collection.collection_list2.clear()
                self.dlg_main.newTile.hide()
                self.dlg_main.edit.setText("Edit")
                self.dlg_main.new_.setText("Import")
                self.nowCollectionType = "Feature"

                if self.dlg_main.search.text() == "":
                    querystr = 'itemType == "Feature"'
                    self.collection_data = self.features_collection.query(
                        querystr)
                else:
                    self.collection_data = self.features_collection.query(
                        'title.str.contains("'+self.dlg_main.search.text()+'")')
                for index, item in self.features_collection.iterrows():
                    self.dlg_new_collection.collection_list2.addItem(
                        str(item[1]))

                self.dlg_main.collectionList.clear()
                self.allCollection_data = self.collection_data.query(
                    'itemType == "Feature"')
                for index, item in self.allCollection_data.iterrows():
                    self.dlg_main.collectionList.addItem(str(item[1]))

        else:
            self.dlg_new_collection.collection_list2.clear()
            self.dlg_main.newTile.hide()
            self.dlg_main.edit.setText("Edit")
            self.dlg_main.new_.setText("Import")
            self.nowCollectionType = "Feature"

            self.collection_data = None
            self.dlg_main.collectionList.clear()

            self.dlg_main.collectionList.addItems([])

    def tileCollection(self):
        self.dlg_main.setWindowTitle("Tile Collection")
        if type(self.tile_collection) == pd.core.frame.DataFrame:
            if len(self.tile_collection) > 0:
                if self.collectionType == "Tile":
                    self.nowCollectionType = "Tile"
                    self.dlg_main.newTile.show()
                    self.dlg_main.edit.setText("Load")
                    self.dlg_main.new_.setText("Edit")
                    if self.dlg_main.search.text() == "":
                        querystr = 'itemType == "Tile"'
                        self.collection_data = self.tile_collection.query(
                            querystr)
                    else:
                        self.collection_data = self.tile_collection.query(
                            'title.str.contains("'+self.dlg_main.search.text()+'")')
                self.dlg_main.collectionList.clear()
                for index, item in self.collection_data.iterrows():
                    self.dlg_main.collectionList.addItem(str(item[1]))

        else:
            self.tile_collection = []
            self.dlg_main.collectionList.clear()
            self.dlg_main.collectionList.addItems([])
            if self.collectionType == "Tile":
                self.nowCollectionType = "Tile"
                self.dlg_main.collectionList.clear()
                self.dlg_main.newTile.show()
                self.dlg_main.edit.setText("Load")
                self.dlg_main.new_.setText("Edit")

    def styleCollection(self):
        self.dlg_main.setWindowTitle("Style Collection")
        self.dlg_main.collectionList.clear()
        if type(self.style) == pd.core.frame.DataFrame:
            if self.collectionType == "Style":
                self.nowCollectionType = "Style"
                if self.dlg_main.search.text() == "":
                    self.collection_data = self.style
                else:
                    self.collection_data = self.style.query(
                        'title.str.contains("'+self.dlg_main.search.text()+'")')
            for index, item in self.collection_data.iterrows():
                self.dlg_main.collectionList.addItem(str(item[1]))
        else:
            self.dlg_main.collectionList.clear()

            self.dlg_main.collectionList.addItems([])

    def newFeaturesCollection(self):
        if checkNetConnection() == True:
            if self.nowCollectionType == "Feature":
                self.get_colectionID()
                self.add_layer_to_layerList()
                self.dlg_new_collection.new_collection.setChecked(True)
                self.vallaris_dialig.manager_dialog(self.dlg_new_collection)
            if self.nowCollectionType == "Tile":
                self.edit_tile()
        else:
            message="No internet connection."
            self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)

    def newTileollection(self):
        if checkNetConnection() == True:
            self.dlg_new_tile.setWindowTitle("New Tile")
            if self.nowCollectionType == "Tile":
                self.dlg_new_tile.genTile.setText("Gen Tile")
                self.dlg_new_tile.tile_name.setText("")
                self.dlg_new_tile.tile_description.setText("")
                self.tileList = pd.DataFrame(
                    columns=['name', 'id', 'cluster', 'minzoom', 'maxzoom'])
                self.regenTile_id = None
                self.dlg_new_tile.tileList.clear()

                if type(self.features_collection) == pd.core.frame.DataFrame:
                    for index, item in self.features_collection.iterrows():
                        self.dlg_new_tile.tileList.addItem(str(item[1]))

                    self.vallaris_dialig.manager_dialog(self.dlg_new_tile)
                    self.slider.setLow(0)
                    self.slider.setHigh(14)
                else:
                    message = "Don't have features collection."
                    self.iface.messageBar().pushMessage("infomation  ", message, level=0, duration=3)
        else:
            message="No internet connection."
            self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)

    def get_colectionID(self):
        if checkNetConnection() == True:
            if self.dlg_main.collectionList.currentRow() != -1:
                self.nowCollection = self.collection_data.values.tolist(
                )[self.dlg_main.collectionList.currentRow()]
                self.collection_title = self.nowCollection[1]
                if self.nowCollectionType == "Feature":
                    self.collection_description = self.nowCollection[3]
                if self.nowCollectionType == "Style":
                    self.collection_description = self.nowCollection[2]            
                self.collectionID = self.nowCollection[0]
        else:
            message="No internet connection."
            self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)

        # else:
        #     if self.nowCollectionType  == "Feature":
        #         message="Select features collection."
        #         self.iface.messageBar().pushMessage("infomation  ", message, level=0, duration=3)

    def get_items(self):
        start_time = time.time()

        if checkNetConnection() == True:
            sql_file_path = create_floder(
                self.Vallaris_temp_path + "/"+self.collectionID)
            self.vallaris_data_db = DB(sql_file_path, "vallaris_data")

            features_list = []

            self.init_progressBar()
            self.progress_changed(1)

            # create getdata mode tale
            try:
                colum_list = ["mode text"]
                self.vallaris_data_db.create_db("mode", colum_list)
            except:
                pass
            self.vallaris_data_db.delete_from_table("mode")
            bbox = None
            datetime_ = None
            field_ = None
            field_text_list = []
            if self.dlg_features.extent.isChecked():
                extent = self.dlg_features.extent.outputExtent()
                xmin = extent.xMinimum()
                xmax = extent.xMaximum()
                ymin = extent.yMinimum()
                ymax = extent.yMaximum()
                bbox = replace_number(
                    str(xmin)+","+str(ymin)+","+str(xmax)+","+str(ymax))
                if bbox != "0.0,0.0,0.0,0.0":
                    # delete value in table
                    field_text_list = []
                    field_text_list.append(["mode", "selected"])

            if self.dlg_features.properties.isChecked():
                field_text_list = []
                field_text_list.append(["mode", "selected"])
                if str(self.dlg_features.field.currentText()) != "":
                    if self.dlg_features.condition.currentIndex() == 0:
                        condition = self.dlg_features.value_query.text()
                    if self.dlg_features.condition.currentIndex() == 1:
                        condition = self.dlg_features.value_query.text()
                    field_ = str(
                        self.dlg_features.field.currentText())+"="+condition

            if self.dlg_features.datetime.isChecked():
                field_text_list = []
                field_text_list.append(["mode", "selected"])

                st_date = datetime.datetime.strptime(self.dlg_features.st_date.text().strip(' \t\r\n'), '%d/%m/%Y  %H:%M')
                end_date = datetime.datetime.strptime(self.dlg_features.end_date.text().strip(' \t\r\n'), '%d/%m/%Y  %H:%M')
                
                
                symbol = time.strftime("%z")[0]
                hours_ = int(time.strftime("%z")[1:3])
                minutes_ = int(time.strftime("%z")[3:])
                if symbol == "+":
                    st_date_ = (st_date-(datetime.timedelta(hours=hours_,minutes=minutes_))).strftime("%Y-%m-%dT%H:%M:%S.%f")
                    end_date_ = (end_date-(datetime.timedelta(hours=hours_,minutes=minutes_))).strftime("%Y-%m-%dT%H:%M:%S.%f")
                if symbol == "-":
                    st_date_ = (st_date+(datetime.timedelta(hours=hours_,minutes=minutes_))).strftime("%Y-%m-%dT%H:%M:%S.%f")
                    end_date_ = (end_date+(datetime.timedelta(hours=hours_,minutes=minutes_))).strftime("%Y-%m-%dT%H:%M:%S.%f")

                datetime_ = replace_number(
                    str(st_date_)[:-3]+"Z" + "/"+str(end_date_)[:-3]+"Z")

            if len(field_text_list) > 0:
                self.vallaris_data_db.insert("mode", field_text_list)
            else:
                field_text_list = []
                field_text_list.append(["mode", "all"])
                self.vallaris_data_db.insert("mode", field_text_list)

            # check layer
            layerPanelList = [
                layer.name() for layer in QgsProject.instance().instance().mapLayers().values()]
            now_ly = None
            now_ly_source = None
            now_ly_id = []
            for type_ in self.type_list:
                if self.collection_title + "_" + type_ in layerPanelList:
                    now_ly = QgsProject.instance().mapLayersByName(
                        self.collection_title+"_" + type_)[0]
                    # self.iface.setActiveLayer(vl)
                    now_ly_source = now_ly.source().split("|")[0]
                    now_ly_id.append(now_ly.id())

            if now_ly != None:

                message = "Do you want to remove collection layer in Layer Panel?"
                self.message_box.setIcon(QMessageBox.Warning)
                self.message_box.setText(message)
                self.message_box.setWindowTitle(
                    "This collection layer exists in Layer Panel")
                self.message_box.setStandardButtons(
                    QMessageBox.Cancel | QMessageBox.Ok)
                returnValue = self.message_box.exec()
                if returnValue == QMessageBox.Ok:
                    for now_id in now_ly_id:
                        QgsProject.instance().removeMapLayers([now_id])
                    self.init_progressBar()
                    self.progress_changed(100)
                    self.get_items()
                else:
                    self.init_progressBar()
                    self.progress_changed(100)

            else:

                if self.vallaris_api.count_items(self.collectionID, bbox, datetime_, field_) != False:

                    self.progress_changed(5)
                    ly_path = self.vallaris_api.collection_items_stream(
                        self.collectionID, bbox, datetime_, field_)

                    self.progress_changed(30)
                    if ly_path != False:
                        geom_list = self.check_geom(ly_path)

                        ly_output_path = ly_path.split(
                            ly_path.split("/")[-1])[0]
                        # create group
                        root = QgsProject.instance().layerTreeRoot()
                        if root.findGroup(self.collection_title) == None:
                            shapeGroup = root.addGroup(self.collection_title)
                            # cloned group
                            cloned_group1 = shapeGroup.clone()
                            # move the node (along with sub-groups and layers) to the top
                            root.insertChildNode(0, cloned_group1)
                            # remove the original node
                            root.removeChildNode(shapeGroup)

                        shapeGroup = root.findGroup(self.collection_title)
                        # if shapeGroup.findGroup("Vector") == None:
                        #     myGroupA = shapeGroup.addGroup("Vector")

                        GpName = self.Vallaris_temp_path+'/'+self.collectionID + \
                            '/vector/'+self.collectionID+'.gpkg'
                        num = 0
                        for i, type in enumerate(self.type_list):

                            if type in geom_list:
                                ly = QgsVectorLayer(
                                    ly_path + '|geometrytype='+type, type, "ogr")
                                # if len(list(ly.getFeatures())) > 0:
                                # fieldsList = ["_collectionId","id","_createdAt","_createdBy","_updatedAt","_updatedBy"]
                                fieldsList = ["id"]
                                field_name = []
                                field_index = []
                                # field_index = [index for index,field in enumerate( ly.dataProvider().fields()) if field.name() not in fieldsList and ]
                                for index, field in enumerate(ly.dataProvider().fields()):
                                    if field.name() not in fieldsList:
                                        if field.name().lower() not in field_name:
                                            field_name.append(
                                                field.name().lower())
                                            field_index.append(index)
                                if num == 0:
                                    firstt = True
                                    options = QgsVectorFileWriter.SaveVectorOptions()
                                    if firstt:
                                        firstt = False
                                    else:
                                        options.actionOnExistingFile = QgsVectorFileWriter.CreateOrOverwriteLayer
                                        options.EditionCapability = QgsVectorFileWriter.CanAddNewLayer
                                    options.layerName = self.collection_title + "_" + type
                                    options.attributes = field_index
                                    _writer = QgsVectorFileWriter.writeAsVectorFormat(
                                        ly, GpName, options)
                                    num += 1
                                else:
                                    options = QgsVectorFileWriter.SaveVectorOptions()
                                    options.actionOnExistingFile = QgsVectorFileWriter.CreateOrOverwriteLayer
                                    options.layerName = self.collection_title + "_" + type
                                    options.attributes = field_index
                                    _writer = QgsVectorFileWriter.writeAsVectorFormat(
                                        ly, GpName, options)

                                gpkg_countries_layer = GpName + "|layername="+self.collection_title + "_" + type
                                vlayer = QgsVectorLayer(
                                    gpkg_countries_layer, self.collection_title+"_" + type, "ogr")

                                if not vlayer.isValid():
                                    print("Layer failed to load!")
                                else:
                                    QgsProject.instance().addMapLayer(vlayer)

                                    myLayer = root.findLayer(vlayer.id())
                                    myClone = myLayer.clone()
                                    parent = myLayer.parent()

                                    myGroup = root.findGroup(
                                        self.collection_title)
                                    # Insert in first position
                                    myGroup.insertChildNode(0, myClone)
                                    parent.removeChildNode(myLayer)

                                    vl = QgsProject.instance().mapLayersByName(
                                        self.collection_title+"_" + type)[0]
                                    self.iface.setActiveLayer(vl)

                                    layer = self.iface.activeLayer()
                                    field_str = ""
                                    for index, field in enumerate(layer.dataProvider().fields()):
                                        if str(field.name()) != "fid":
                                            field_str = field_str + \
                                                str(field.name())

                                    # create column tale

                                    try:
                                        colum_list = ["column text"]
                                        self.vallaris_data_db.create_db(
                                            "_"+self.collectionID, colum_list)
                                    except:
                                        pass

                                    # delete value in table
                                    self.vallaris_data_db.delete_from_table(
                                        "_"+self.collectionID)
                                    field_text_list = []
                                    field_text_list.append(
                                        ["column", field_str])
                                    self.vallaris_data_db.insert(
                                        "_"+self.collectionID, field_text_list)
                                    features = layer.getFeatures()
                                    prov = layer.dataProvider()
                                    field_names = [field.name()
                                                   for field in prov.fields()]

                                    for feat in features:
                                        features_data = str(
                                            feat.attributes()) + str(feat.geometry())
                                        hash_object = hashlib.md5(
                                            features_data.encode('utf-8'))
                                        features_list.append(
                                            [str(feat['_id']), str(hash_object.hexdigest())])
                                self.progress_changed(
                                    self.progress.value()+45//(len(geom_list)))
                            else:
                                pass

                            # print("--- %s seconds write data gpkg---" % (time.time() - start_time),"t",i)
                            # self.iface.zoomToActiveLayer()
                        extent = QgsRectangle()
                        extent.setMinimal()
                        myGroup = root.findGroup(self.collection_title)
                        for child in myGroup.children():
                            if isinstance(child, QgsLayerTreeLayer):
                                extent.combineExtentWith(
                                    child.layer().extent())

                        iface.mapCanvas().setExtent(extent)
                        iface.mapCanvas().refresh()
                        # create DataOld tale
                        tb_name = "DataOld"
                        try:
                            colum_list = ["id text", "features text"]
                            self.vallaris_data_db.create_db(
                                tb_name, colum_list)
                        except:
                            pass

                        # delete value in table
                        self.vallaris_data_db.delete_from_table(tb_name)
                        self.vallaris_data_db.insert_multi(
                            tb_name, features_list)
                        self.progress_changed(95)
                        # print( os.stat(ly_path).st_size / (1024 * 1024) ,"mb")
                        # print("--- %s seconds start DB---" % (time.time() - start_time))
                        self.progress_changed(100)
                    else:
                        if ly_path == False:
                            self.progress_changed(100)
                            message = "The area you are trying to download does not have a items."
                            self.message_box.warning(
                                self.iface.mainWindow(), 'Warning', message)
                            self.vallaris_dialig.manager_dialog()

                else:
                    self.progress_changed(100)
                    message = "Does not have a items."
                    self.message_box.warning(
                        self.iface.mainWindow(), 'Warning', message)
                    self.vallaris_dialig.manager_dialog()

        else:
            message = "No internet connection."
            self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)

    def check_geom(self, file_path):

        # with open(file_path) as f:
        with open(file_path, 'r', encoding='UTF-8', errors='replace') as f:
            data = f.readlines()
        # features_type_list = list(set([json.loads(i)['geometry']['type'] for i in data]))
        features_type_list = []
        for i in data:
            type = json.loads(i)['geometry']['type']
            val = type
            if type == "MultiPoint":
                val = "Point"
            if type == "MultiLineString":
                val = "LineString"
            if type == "MultiPolygon":
                val = "Polygon"

            if val not in features_type_list:
                features_type_list.append(val)

        return features_type_list

    def get_tile_collection(self):

        if checkNetConnection() == True:
            QGIS_version = Qgis.QGIS_VERSION_INT
            if QGIS_version >= 31400:

                res = self.vallaris_api.get_tiles(self.collectionID)

                if res != False:
                    url = res["tiles"][0]
                    root = QgsProject.instance().layerTreeRoot()
                    if root.findGroup(self.collection_title) == None:
                        shapeGroup = root.addGroup(self.collection_title)

                        cloned_group1 = shapeGroup.clone()
                        # move the node (along with sub-groups and layers) to the top
                        root.insertChildNode(0, cloned_group1)
                        # remove the original node
                        root.removeChildNode(shapeGroup)
                    ds = QgsDataSourceUri()
                    ds.setParam("type", "xyz")
                    ds.setParam("zmin", "0")
                    ds.setParam("zmax", "24")
                    ds.setParam("url", url)
                    uri = bytes(ds.encodedUri()).decode('utf-8')

                    vtlayer = QgsVectorTileLayer(uri, self.collection_title)
                    QgsProject.instance().addMapLayer(vtlayer)
                    layer = QgsProject.instance().mapLayersByName(
                        self.collection_title)[0]
                    root = QgsProject.instance().layerTreeRoot()

                    myLayer = root.findLayer(vtlayer.id())
                    myClone = myLayer.clone()
                    parent = myLayer.parent()

                    myGroup = root.findGroup(self.collection_title)
                    # Insert in first position
                    myGroup.insertChildNode(0, myClone)
                    parent.removeChildNode(myLayer)
                else:
                    message = "Generating Tile collection."
                    self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)
            else:
                message = "QGIS version does not support vector tiles. QGIS Minimum Version 3.14"
                self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)
        else:
            message = "No internet connection."
            self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)

    def update_collection_items(self):

        collection_id = str(self.collectionID)
        start_time = time.time()

        if checkNetConnection() == True:

            edit_status = False
            collection_id = self.collectionID
            collection_name = self.collection_title

            sql_file_path = self.Vallaris_temp_path + "/"+collection_id+"/vallaris.sqlite"
            features_list = []
            edit_field_sql_status = True
            mode = None

            items_count = 0
            _i = 0
            edit_column = 0

            self.init_progressBar()
            self.progress_changed(1)

            # loop for check collection layer in layer panel and create DataNew table
            for layer_type in self.type_list:
                self.progress.setValue(self.progress.value()+5)

                vl = QgsProject.instance().mapLayersByName(collection_name+"_" + layer_type)
                if len(vl) == 0:
                    continue
                else:
                    self.iface.setActiveLayer(vl[0])

                    layer = self.iface.activeLayer()
                    field_str = ""
                    for index, field in enumerate(layer.dataProvider().fields()):
                        if str(field.name()) != "fid":
                            field_str = field_str+str(field.name())
                    try:
                        edit_field_sql = self.vallaris_data_db.select(
                            "SELECT * FROM " + "_"+self.collectionID)
                    except:
                        edit_field_sql_status = False

                        break
                    edit_field = [i[0] for i in edit_field_sql]

                    rs = self.vallaris_data_db.select(
                        "SELECT * FROM sqlite_master WHERE type = 'table'")
                    count_tb = sum(1 for _ in rs)
                    rs = self.vallaris_data_db.select("SELECT * FROM mode")
                    mode = [m for m in rs][0][0]
                    if field_str != edit_field[0]:
                        if mode == "all":
                            if count_tb == 3:
                                self.vallaris_api.delete_items(
                                    collection_id, None, True)
                                edit_column += 1
                            if count_tb > 3:
                                features = layer.getFeatures()
                                for feat in features:
                                    if str(feat['_id']) != "NULL":
                                        if len(feat['_id']) == 24:
                                            self.vallaris_api.delete_items(
                                                collection_id, str(feat['_id']))
                                            edit_column += 1

                            vlayer = iface.activeLayer()
                            vlayer_json = self.Vallaris_temp_path+'/' + \
                                vlayer.name()+'_'+str(int(time.time()))+'.geojson'

                            exp_crs = QgsCoordinateReferenceSystem(
                                4326, QgsCoordinateReferenceSystem.EpsgCrsId)
                            fieldsList = ["fid"]
                            field_index = [index for index, field in enumerate(
                                vlayer.dataProvider().fields()) if field.name() not in fieldsList]

                            writer = QgsVectorFileWriter.writeAsVectorFormat(
                                vlayer, vlayer_json, 'UTF-8', exp_crs, driverName='GeoJson', attributes=field_index, onlySelected=False)

                            data = {}
                            # add 20%
                            # self.progress.setValue(self.progress.value()+(add_progress-((add_progress*80)/100)))

                            # if int(os.stat(vlayer_json).st_size / (1024 * 1024)) < 1000:
                            if True:
                                with open(vlayer_json, 'r', encoding='UTF-8', errors='replace') as f:

                                    data = f.readlines()[5:-2]
                                st = 0
                                end = 500
                                if (len(data) % 500) != 0:
                                    round_ = (len(data)//500)+1
                                else:
                                    round_ = len(data)//500

                                # add 10%
                                # self.progress.setValue(self.progress.value()+(add_progress-((add_progress*90)/100)))

                                # add 70%
                                num_add_percent = 0
                                for r in range(round_):

                                    features_format = {
                                        "type": "FeatureCollection", "features": []}
                                    # try:
                                    if (len(data) % 500) != 0 and r == len(data)//500:
                                        end = len(data)
                                    for i in data[st:end]:

                                        if i == data[len(data)-1:len(data)][0]:
                                            features_format["features"].append(
                                                json.loads(i[:-1].replace("'", "1212312121")))
                                        else:
                                            features_format["features"].append(
                                                json.loads(i[:-2].replace("'", "1212312121")))
                                    status = self.vallaris_api.create_items(
                                        collection_id, features_format)
                                    st += 500
                                    end += 500

                                    # if status == False:
                                    #     print(False)
                            # break
                    else:

                        feature_count = layer.featureCount()
                        items_count += feature_count
                        edit_status = True
                        features = layer.getFeatures()
                        for feat in features:
                            if str(feat['_id']) == "NULL":
                                id = "new"
                            else:
                                id = str(feat['_id'])

                            features_data = str(
                                feat.attributes()) + str(feat.geometry())
                            hash_object = hashlib.md5(
                                features_data.encode('utf-8'))
                            features_list.append(
                                (id, str(hash_object.hexdigest())))

                        # create DataOld tale
                        tb_name = "DataNew"
                        try:
                            colum_list = ["id text", "features text"]
                            self.vallaris_data_db.create_db(
                                tb_name, colum_list)
                        except:
                            pass
                        if _i == 0:
                            # delete value in table
                            self.vallaris_data_db.delete_from_table(tb_name)
                        if len(features_list) != 0:

                            self.vallaris_data_db.insert_multi(
                                tb_name, features_list)
                            # layer_update = True
                            # edit_status = True
                        _i += 1

            if edit_status == True and items_count > 0:

                # select id add edit delete
                add = self.vallaris_data_db.select(
                    "SELECT DataNew.id FROM DataNew WHERE id NOT IN (SELECT id FROM DataOld )")
                edit = self.vallaris_data_db.select(
                    "SELECT A.id FROM DataOld A, DataNew B WHERE A.id = B.id AND A.features != B.features")
                delete = self.vallaris_data_db.select(
                    "SELECT DataOld.id FROM DataOld WHERE id NOT IN (SELECT id FROM DataNew )")

                add_id = [i[0] for i in add]
                edit_id = [i[0] for i in edit]
                delete_id = [i[0] for i in delete]
                item_id = [add_id, edit_id, delete_id]

                self.progress_changed(25)
                if len(item_id[0]) != 0 or len(item_id[1]) != 0 or len(item_id[2]) != 0:
                    delete_id = item_id[2]

                    for i, d in enumerate(item_id):
                        # # self.progress.setValue(self.progress.value()+5)
                        if i == 0:
                            add_str = ""
                            if "new" in d:
                                if len(set(d)) > 1:
                                    add_str = '"_id" IS NULL or '
                                if len(set(d)) == 1:
                                    add_str = '"_id" IS NULL '
                            for add_ in list(dict.fromkeys(d)):
                                if add_ != "new":
                                    add_str += '"_id"='
                                    add_str += "'"+add_+"'"
                                    if len(d) > 1 and add_ != list(dict.fromkeys(d))[-1]:
                                        add_str += " or "
                        if i == 1:
                            edit_str = ""
                            for edit_id_ in list(dict.fromkeys(d)):
                                if len(d) > 0:
                                    edit_str += '"_id"='
                                    edit_str += "'"+edit_id_+"'"
                                if len(d) > 1 and edit_id_ != list(dict.fromkeys(d))[-1]:
                                    edit_str += " or "
                    if len(delete_id) != 0:
                        for del_id in delete_id:
                            self.vallaris_api.delete_items(
                                collection_id, del_id)

                    add_items = {"type": "FeatureCollection", "features": []}
                    # check
                    for i in self.type_list:
                        self.progress.setValue(self.progress.value()+10)
                        vl = QgsProject.instance().mapLayersByName(collection_name+"_" + i)
                        if len(vl) != 0:
                            self.iface.setActiveLayer(vl[0])
                            layer = self.iface.activeLayer()

                            if add_str != "" and edit_str != "":
                                layer.selectByExpression(
                                    str(edit_str) + ' or ' + str(add_str))
                            elif edit_str == "":

                                layer.selectByExpression(str(add_str))
                            else:
                                layer.selectByExpression(str(edit_str))
                            if layer.selectedFeatureCount() > 0:

                                fields = layer.dataProvider().fields()
                                field_index = [
                                    i for i, d in enumerate(fields) if i != 0]

                                vallaris_update_items_path = self.Vallaris_temp_path + \
                                    "/"+collection_id+"/update_items"
                                create_floder(vallaris_update_items_path)
                                layer_json = vallaris_update_items_path+'/'+layer.name()+'.geojson'

                                exp_crs = QgsCoordinateReferenceSystem(
                                    4326, QgsCoordinateReferenceSystem.EpsgCrsId)
                                writer = QgsVectorFileWriter.writeAsVectorFormat(
                                    layer, layer_json, 'UTF-8', exp_crs, 'GeoJson', attributes=field_index, onlySelected=True)

                                data = {}
                                with open(layer_json, 'r', encoding='UTF-8', errors='replace') as f:

                                    data = json.load(f)

                                for d in data['features']:
                                    f_id = d['properties']['_id']

                                    if f_id != None:
                                        # print(f_id,edit_id)
                                        if f_id in edit_id:
                                            self.vallaris_api.update_items(
                                                collection_id, f_id, d)
                                    else:
                                        add_items["features"].append(d)

                    # add item list
                    data = add_items
                    st = 0
                    end = 500
                    if len(add_items['features']) > 0:
                        for i in range((len(data['features'])//500)+1):
                            features_format = {
                                "type": "FeatureCollection", "features": []}
                            try:
                                features_format["features"] = data['features'][st:end]
                                status = self.vallaris_api.create_items(
                                    collection_id, features_format)

                                st += 500
                                end += 500
                            except Exception as e:
                                break
                    self.progress_changed(75)

                    for type in self.type_list:
                        vl = QgsProject.instance().mapLayersByName(collection_name+"_" + type)
                        if len(vl) != 0:
                            self.iface.setActiveLayer(vl[0])
                            layer = self.iface.activeLayer()
                            QgsProject.instance().removeMapLayers([layer.id()])

                    message = "Get items."
                    self.iface.messageBar().pushMessage("information  ", message, level=0, duration=3)
                    self.progress_changed(100)
                    self.get_items()

                else:
                    self.progress_changed(100)
                    message = "No item editing."
                    self.message_box.information(self.iface.mainWindow(), 'Information',
                                                 message)
                    self.vallaris_dialig.manager_dialog()

            elif edit_status == True and items_count == 0:
                self.vallaris_api.delete_items(collection_id, None, True)
                self.progress_changed(100)

            elif edit_column != 0:
                for type in self.type_list:
                    vl = QgsProject.instance().mapLayersByName(collection_name+"_" + type)
                    if len(vl) != 0:
                        self.iface.setActiveLayer(vl[0])
                        layer = self.iface.activeLayer()
                        QgsProject.instance().removeMapLayers([layer.id()])

                message = "Get items."
                self.iface.messageBar().pushMessage("information  ", message, level=0, duration=3)
                self.progress_changed(100)
                self.get_items()

            elif mode != "all" and edit_field_sql_status == True:
                self.progress_changed(100)
                message = "Cannot update the column filter items."
                self.message_box.information(self.iface.mainWindow(), 'Information',
                                             message)
                self.vallaris_dialig.manager_dialog()

            else:
                if edit_field_sql_status == False:
                    self.progress_changed(100)
                    message = "Please get items again"
                    self.message_box.information(self.iface.mainWindow(), 'Information',
                                                 message)
                    self.vallaris_dialig.manager_dialog()
                else:

                    message = "No collection items in layers panel."
                    self.message_box.information(self.iface.mainWindow(), 'Information',
                                                 message)
                    self.vallaris_dialig.manager_dialog()

        else:
            self.progress_changed(100)
            message = "No internet connection."
            self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)

    def delete_collection(self):

        if checkNetConnection() == True:

            if self.dlg_main.collectionList.count() != 0:

                message = " Are you are sure you want to delete this collection?"
                self.message_box.setIcon(QMessageBox.Warning)
                self.message_box.setText(message)
                self.message_box.setWindowTitle("delete collection")
                self.message_box.setStandardButtons(
                    QMessageBox.Cancel | QMessageBox.Ok)
                returnValue = self.message_box.exec()

                collection_id = str(self.collectionID)

                if returnValue == QMessageBox.Ok:

                    self.vallaris_api.delete_collection(collection_id)
                    self.get_collection_list()
                    self.ItemsCollection()
                    self.vallaris_dialig.manager_dialog(self.dlg_main)
                    # self.back()
            else:
                message = "Don't have the collection."
                self.message_box.warning(
                    self.iface.mainWindow(), 'Warning', message)

        else:
            message = "No internet connection."
            self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)

    def create_new_collection(self):

        start_time = time.time()
        if checkNetConnection() == True:

            selected_layer_list = self.dlg_new_collection.layerList.selectedItems()
            if len(selected_layer_list) > 0:
                self.init_progressBar()
                self.progress_changed(1)

                self.featureCount = True
                for d in selected_layer_list:
                    registry = QgsProject.instance()
                    name = d.text()
                    layer = registry.mapLayersByName(name)[0]
                    iface.setActiveLayer(layer)
                    vlayer = iface.activeLayer()
                    if vlayer.featureCount() == 0:
                        self.featureCount = False
                    else:
                        continue
                collection_name = self.dlg_new_collection.collection_name.text()
                collection_description = self.dlg_new_collection.collection_description.text()

                if self.featureCount == True:
                    if self.dlg_new_collection.new_collection.isChecked():
                        if collection_name != "":
                            # if  self.dlg.old_collection.isChecked() :
                            collection_json = {
                                "title": collection_name,
                                "description": collection_description,
                                "extent": {
                                    "spatial": {
                                        "bbox": [[-180, -90, 180, 90]],
                                        "crs": "http://www.opengis.net/def/crs/OGC/1.3/CRS84"
                                    },
                                    "temporal": {
                                        "interval": [['', '']],
                                        "trs": "http://www.opengis.net/def/uom/ISO-8601/0/Gregorian"
                                    }
                                },
                                "itemType": "Feature",
                                "links": []
                            }

                            collection_id = self.vallaris_api.create_collection(
                                collection_json)

                        else:
                            if collection_name == "":
                                message = "collection name is required"
                                self.message_box.warning(self.iface.mainWindow(), 'Warning',
                                                         message)
                                collection_name = False

                    else:
                        if type(self.features_collection) == pd.core.frame.DataFrame:
                            collection_id = self.allCollection_data.values.tolist(
                            )[self.dlg_new_collection.collection_list2.currentIndex()][0]
                        else:
                            collection_id = None
                    if collection_id != None:
                        self.progress_changed(5)
                        add_progress = 90//len(selected_layer_list)
                        if collection_name != False:
                            for d in selected_layer_list:
                                registry = QgsProject.instance()
                                name = d.text()
                                layer = registry.mapLayersByName(name)[0]
                                iface.setActiveLayer(layer)
                                vlayer = iface.activeLayer()
                                vlayer_json = self.Vallaris_temp_path+'/' + \
                                    vlayer.name()+'_'+str(int(time.time()))+'.geojson'

                                exp_crs = QgsCoordinateReferenceSystem(
                                    4326, QgsCoordinateReferenceSystem.EpsgCrsId)
                                if self.dlg_new_collection.selected_features.isChecked():
                                    writer = QgsVectorFileWriter.writeAsVectorFormat(
                                        vlayer, vlayer_json, 'UTF-8', exp_crs, 'GeoJson', True)
                                else:
                                    writer = QgsVectorFileWriter.writeAsVectorFormat(
                                        vlayer, vlayer_json, 'UTF-8', exp_crs, 'GeoJson', False)
                                data = {}

                                # add 20%
                                self.progress.setValue(
                                    self.progress.value()+(add_progress-((add_progress*80)/100)))

                                # if int(os.stat(vlayer_json).st_size / (1024 * 1024)) < 1000:
                                if True:
                                    with open(vlayer_json, 'r', encoding='UTF-8', errors='replace') as f:
                                        data = f.readlines()[5:-2]
                                    st = 0
                                    end = 500
                                    if (len(data) % 500) != 0:
                                        round_ = (len(data)//500)+1
                                    else:
                                        round_ = len(data)//500

                                    # add 10%
                                    self.progress.setValue(
                                        self.progress.value()+(add_progress-((add_progress*90)/100)))

                                    # add 70%
                                    num_add_percent = 0
                                    for r in range(round_):

                                        features_format = {
                                            "type": "FeatureCollection", "features": []}
                                        # try:
                                        if (len(data) % 500) != 0 and r == len(data)//500:
                                            end = len(data)
                                        for i in data[st:end]:
                                            try:
                                                if i == data[len(data)-1:len(data)][0]:
                                                    features_format["features"].append(
                                                        json.loads(i[:-1].replace("'", "1212312121")))
                                                else:
                                                    features_format["features"].append(
                                                        json.loads(i[:-2].replace("'", "1212312121")))
                                            except:
                                                print("Fail import")
                                        status = self.vallaris_api.create_items(
                                            collection_id, features_format)
                                        st += 500
                                        end += 500
                                        if round_ > 70:
                                            num_add_percent += 1
                                            if num_add_percent == (round_ // 70):
                                                self.progress.setValue(
                                                    self.progress.value()+1)

                                        else:
                                            self.progress.setValue(
                                                self.progress.value()+(70//round_))


                                else:
                                    with open(vlayer_json, 'r', encoding='UTF-8', errors='replace') as f:
                                        data = json.load(f)
                                    st = 0
                                    end = 100
                                    for i in range((len(data['features'])//100)+1):
                                        features_format = {
                                            "type": "FeatureCollection", "features": []}
                                        try:
                                            features_format["features"] = data['features'][st:end]
                                            status = self.vallaris_api.create_items(
                                                collection_id, features_format)
                                            st += 100
                                            end += 100

                                        except Exception as e:
                                            # print("ERROR",e)
                                            break
                            self.progress_changed(100)
                            self.dlg_new_collection.selected_features.setChecked(
                                False)
                            self.get_collection_list()
                            self.dlg_new_collection.collection_name.setText("")
                            self.dlg_new_collection.collection_description.setText(
                                "")
                            self.dlg_main.search.setText((""))
                            # print("import !!!", self.collectionType)
                            # print("--- %s seconds import data!!!---" % (time.time() - start_time))
                            self.ItemsCollection()
                            self.vallaris_dialig.manager_dialog(self.dlg_main)

                            # self.back()
                        else:
                            self.vallaris_dialig.manager_dialog()
                    else:
                        self.progress_changed(100)
                        message = "No collection."
                        self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)

                else:
                    self.progress_changed(100)
                    message = "No features in selected Layer"
                    self.message_box.warning(self.iface.mainWindow(), 'Warning',
                                             message)
                    self.vallaris_dialig.manager_dialog()
            else:
                message = "Selected Layer"
                self.message_box.warning(self.iface.mainWindow(), 'Warning',
                                         message)
                self.vallaris_dialig.manager_dialog()
        else:
            message = "No internet connection."
            self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)
        # print("--- %s seconds ---" % (time.time() - start_time) )

    def add_layer_to_layerList(self):
        self.dlg_new_collection.layerList.clear()
        all_layer = QgsProject.instance().mapLayers().values()
        vlayer = []
        self.vlayer_id = []
        for i in all_layer:

            if i.type() == QgsMapLayer.VectorLayer and i.name() != "background":
                # if self.iface.activeLayer() == None:
                #     ly = QgsProject.instance().mapLayersByName(i.name())[0]
                #     self.iface.setActiveLayer(ly)
                #     # self.dlg_new_collection.layerList.clear()
                vlayer.append(i.name())
                if i.id() not in self.vlayer_id:
                    self.vlayer_id.append(i.id())

        self.dlg_new_collection.layerList.addItems(vlayer)

    def import_selection(self):
        if self.dlg_new_collection.new_collection.isChecked() == True:
            self.dlg_new_collection.old_collection.setChecked(False)
            self.dlg_new_collection.label_old.setDisabled(True)
            self.dlg_new_collection.collection_list2.setDisabled(True)
            self.dlg_new_collection.collection_name.setDisabled(False)
            self.dlg_new_collection.collection_description.setDisabled(False)
        else:
            self.dlg_new_collection.old_collection.setChecked(True)
            self.dlg_new_collection.label_old.setDisabled(False)
            self.dlg_new_collection.collection_list2.setDisabled(False)
            self.dlg_new_collection.collection_name.setDisabled(True)
            self.dlg_new_collection.collection_description.setDisabled(True)

    def dlg_extent_manage(self):
        if self.dlg_features.extent.isCollapsed() == False:
            self.dlg_features.setMinimumSize(
                self.dlg_features.width(), self.dlg_features.height()+140)
            self.dlg_features.setMaximumSize(
                self.dlg_features.width(), self.dlg_features.height()+140)
        if self.dlg_features.extent.isCollapsed() == True:
            self.dlg_features.setMinimumSize(
                self.dlg_features.width(), self.dlg_features.height()-140)
            self.dlg_features.setMaximumSize(
                self.dlg_features.width(), self.dlg_features.height()-140)

    def dlg_properties_manage(self):
        if self.dlg_features.properties.isCollapsed() == False:
            self.dlg_features.des_.hide()
            self.dlg_features.setMinimumSize(
                self.dlg_features.width(), self.dlg_features.height()+50)
            self.dlg_features.setMaximumSize(
                self.dlg_features.width(), self.dlg_features.height()+50)
        if self.dlg_features.properties.isCollapsed() == True:
            self.dlg_features.setMinimumSize(
                self.dlg_features.width(), self.dlg_features.height()-50)
            self.dlg_features.setMaximumSize(
                self.dlg_features.width(), self.dlg_features.height()-50)

    def dlg_datetime_manage(self):

        if self.dlg_features.datetime.isCollapsed() == False:
            self.dlg_features.setMinimumSize(
                self.dlg_features.width(), self.dlg_features.height()+50)
            self.dlg_features.setMaximumSize(
                self.dlg_features.width(), self.dlg_features.height()+50)
        if self.dlg_features.datetime.isCollapsed() == True:
            self.dlg_features.setMinimumSize(
                self.dlg_features.width(), self.dlg_features.height()-50)
            self.dlg_features.setMaximumSize(
                self.dlg_features.width(), self.dlg_features.height()-50)

    def setZoomLaveelText(self):
        self.dlg_new_tile.min.setText("Min: "+str(self.slider.low()))
        self.dlg_new_tile.max.setText("Max: "+str(self.slider.high()))

    def add_tile_tolist(self):
        currentTile = self.features_collection.values.tolist(
        )[self.dlg_new_tile.tileList.currentIndex()]
        if self.dlg_new_tile.checkBox_cluster.isChecked():
            cluster = self.dlg_new_tile.cluster_pixel.value()
        else:
            cluster = "Null"
        querystr = 'id == "'+currentTile[0]+'"'
        df_update = self.tileList.query(querystr)
        if df_update.empty:
            self.tileList = self.tileList.append({'name': currentTile[1], 'id': currentTile[0], 'cluster': cluster, 'minzoom': int(
                replace_number(self.slider.low())), 'maxzoom': int(replace_number(self.slider.high()))}, ignore_index=True)
            self.slider.setLow(0)
            self.slider.setHigh(14)
        else:
            index = df_update.index.tolist()
            self.tileList.at[index, 'cluster'] = cluster
            self.tileList.at[index, 'minzoom'] = int(
                replace_number(self.slider.low()))
            self.tileList.at[index, 'maxzoom'] = int(
                replace_number(self.slider.high()))
        self.dlg_new_tile.checkBox_cluster.setChecked(False)
        self.dlg_new_tile.genTileList.clear()
        for index, item in self.tileList.iterrows():
            self.dlg_new_tile.genTileList.addItem(str(item[0]))

    def remove_tile_in_list(self):

        # selected_tile = self.dlg_new_tile.genTileList.selectedIndexes()
        # print([x.row() for x in selected_tile])
        index = [x.row()
                 for x in self.dlg_new_tile.genTileList.selectedIndexes()]
        for i in reversed(index):
            self.tileList = self.tileList.drop([self.tileList.index[i]])
        self.dlg_new_tile.genTileList.clear()
        for index, item in self.tileList.iterrows():
            self.dlg_new_tile.genTileList.addItem(str(item[0]))

    def gen_tile(self):

        if checkNetConnection() == True:
            title = self.dlg_new_tile.tile_name.text()
            description = self.dlg_new_tile.tile_description.text()
            tileCollection_json = {
                "title": title,
                "description": description,
                "extent": {
                    "spatial": {
                        "bbox": [[-180, -90, 180, 90]],
                        "crs": "http://www.opengis.net/def/crs/OGC/1.3/CRS84"
                    },
                    "temporal": {
                        "interval": [['', '']],
                        "trs": "http://www.opengis.net/def/uom/ISO-8601/0/Gregorian"
                    }
                },
                "itemType": "Tile",
                "links": [],
                "crs": [
                    "http://www.opengis.net/def/crs/OGC/1.3/CRS84"
                ],
                "tileConfig": {

                }
            }

            if len(self.tileList.index) > 0:
                if self.regenTile_id == None:
                    self.collection_id = self.vallaris_api.create_collection(
                        tileCollection_json)
                else:
                    self.collection_id = self.regenTile_id

                if len(self.tileList.index) == 1:
                    data = self.tileList.values.tolist()[0]
                    json_format = {
                        "zoom": {
                            "minzoom": data[3],
                            "maxzoom": data[4]
                        },
                        "data_filter": {
                            "dataset_id": data[1],
                            "dataset_title": str(data[0]),
                            "dataset_out": self.collection_id
                        }
                    }
                    if data[2] != "Null":
                        json_format["cluster"] = {"distance": data[2]}
                    tileCollection_json["tileConfig"] = json_format
                    res = self.vallaris_api.gen_single_tile(json_format, data[1])
                    if res == True:
                        self.vallaris_api.update_collection(
                            tileCollection_json, self.collection_id)

                elif len(self.tileList.index) > 1:
                    data = self.tileList.values.tolist()
                    json_format = {
                        "base_layers": [
                        ],
                        "result": {
                            "dataset_id": self.collection_id
                        }
                    }

                    for data in data:
                        json_ = {
                            "dataset_id": str(data[1]),
                            "dataset_title": str(data[0]),
                            "minzoom": data[3],
                            "maxzoom": data[4]
                        }
                        if data[2] != "Null":
                            json_["cluster"] = {"distance": data[2]}

                        json_format["base_layers"].append(json_)
                    tileCollection_json["tileConfig"] = json_format
                    res = self.vallaris_api.gen_multi_tile(json_format)
                    if res == True:
                        self.vallaris_api.update_collection(
                            tileCollection_json, self.collection_id)

                self.tileList = pd.DataFrame(
                    columns=['name', 'id', 'cluster', 'minzoom', 'maxzoom'])
                self.dlg_new_tile.genTileList.clear()
                self.get_collection_list()
                # print("gen_tile !!!")
                self.tileCollection()
                self.vallaris_dialig.manager_dialog(self.dlg_main)
            else:
                message = "Add collection to gen tile"
                self.message_box.warning(
                    self.iface.mainWindow(), 'Warning', message)
                self.vallaris_dialig.manager_dialog()
        else:
            message="No internet connection."
            self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)


    def echo(self, low_value, high_value):
        self.dlg_new_tile.min.setText("Min: "+str(low_value))
        self.dlg_new_tile.max.setText("Max: "+str(high_value))

    def edit_tile(self):
        if checkNetConnection() == True:
            self.dlg_new_tile.setWindowTitle("Tile")
            if self.nowCollectionType == "Tile":
                if len(self.dlg_main.collectionList.selectedItems()) != 0:
                    self.dlg_new_tile.tile_description.setText("")
                    self.dlg_new_tile.tileList.clear()
                    if type(self.features_collection) == pd.core.frame.DataFrame:
                        for index, item in self.features_collection.iterrows():
                            self.dlg_new_tile.tileList.addItem(str(item[1]))
                    self.add_layer_to_layerList()
                    self.vallaris_dialig.manager_dialog(self.dlg_new_tile)
                    self.dlg_new_tile.genTile.setText("Regen Tile")
                    self.dlg_new_tile.deleteTile.show()

                    index = [x.row()
                            for x in self.dlg_main.collectionList.selectedIndexes()]
                    current_tile = self.collection_data.values.tolist()[index[0]]
                    current_description = self.collection_data.values.tolist()[
                        index[0]]
                    current_tile_id = current_tile[0]
                    self.regenTile_id = current_tile_id

                    current_tile_data = self.vallaris_api.get_collection(
                        current_tile_id)
                    self.dlg_new_tile.tile_name.setReadOnly(True)
                    self.dlg_new_tile.tile_description.setReadOnly(True)
                    self.dlg_new_tile.tile_name.setText(current_tile_data["title"])
                    if "description" in current_tile_data:
                        self.dlg_new_tile.tile_description.setText(
                            current_tile_data["description"])
                    if "tileConfig" in current_tile_data:
                        if "base_layers" in current_tile_data["tileConfig"]:
                            for t in current_tile_data["tileConfig"]["base_layers"]:
                                if 'dataset_title' in t:
                                    current_name = t["dataset_title"]
                                else:
                                    current_name = t["dataset_id"]
                                current_id = t["dataset_id"]
                                current_cluster = "Null"
                                current_maxzoom = t["maxzoom"]
                                current_minzoom = t["minzoom"]
                                if "cluster" in t:
                                    current_cluster = t["cluster"]["distance"]
                                self.tileList = self.tileList.append(
                                    {'name': current_name, 'id': current_id, 'cluster': current_cluster, 'minzoom': current_minzoom, 'maxzoom': current_maxzoom}, ignore_index=True)
                        else:
                            try:
                                current_name = current_tile_data["tileConfig"]["data_filter"]["dataset_title"]
                                current_id = current_tile_data["tileConfig"]["data_filter"]["dataset_id"]
                                current_cluster = "Null"
                                current_maxzoom = current_tile_data["tileConfig"]["zoom"]["maxzoom"]
                                current_minzoom = current_tile_data["tileConfig"]["zoom"]["minzoom"]

                                if "cluster" in current_tile_data["tileConfig"]:
                                    current_cluster = current_tile_data["tileConfig"]["cluster"]["distance"]
                                self.tileList = self.tileList.append(
                                    {'name': current_name, 'id': current_id, 'cluster': current_cluster, 'minzoom': current_minzoom, 'maxzoom': current_maxzoom}, ignore_index=True)
                            except:
                                pass
                    self.dlg_new_tile.genTileList.clear()
                    for index, item in self.tileList.iterrows():
                        self.dlg_new_tile.genTileList.addItem(str(item[0]))
                else:
                    message = "Select tile collection."
                    self.iface.messageBar().pushMessage("infomation  ", message, level=0, duration=3)
        else:
            message="No internet connection."
            self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)


    def delete_tile(self):

        if checkNetConnection() == True:
            message = "Are you are sure you want to delete this Tile collection?"
            self.message_box.setIcon(QMessageBox.Warning)
            self.message_box.setText(message)
            self.message_box.setWindowTitle("delete tile")
            self.message_box.setStandardButtons(
                QMessageBox.Cancel | QMessageBox.Ok)
            returnValue = self.message_box.exec()

            if returnValue == QMessageBox.Ok:

                self.vallaris_api.delete_collection(self.regenTile_id)
                self.dlg_new_tile.genTileList.clear()
                self.tileList = pd.DataFrame(
                    columns=['name', 'id', 'cluster', 'minzoom', 'maxzoom'])
                self.get_collection_list()
                self.tileCollection()
                self.vallaris_dialig.manager_dialog(self.dlg_main)

        else:
            message = "No internet connection."
            self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)

    def get_wms(self):
        if checkNetConnection() == True:
            groupName = self.collection_title
            layers = self.collectionID
            url = self.url+ "/api/maps/1.0-beta/maps/"+layers+"/wms?api_key="+self.api_key_permission

            urlWithParams = f"crs=EPSG:3857&format=image/png&layers={layers}&styles&url={url}"
            rlayer = QgsRasterLayer(urlWithParams, self.collection_title+"_wms", 'wms')
            if not rlayer.isValid():
                print("Layer failed to load!")
            else:
                QgsProject.instance().addMapLayer(rlayer)
                root = QgsProject.instance().layerTreeRoot()
                if root.findGroup(self.collection_title) == None:
                    shapeGroup = root.addGroup(self.collection_title)
                    # cloned group
                    cloned_group1 = shapeGroup.clone()
                    # move the node (along with sub-groups and layers) to the top
                    root.insertChildNode(0, cloned_group1)
                    # remove the original node
                    root.removeChildNode(shapeGroup)

                shapeGroup = root.findGroup(self.collection_title)
                myLayer = root.findLayer(rlayer.id())
                myClone = myLayer.clone()
                parent = myLayer.parent()

                myGroup = root.findGroup(
                    self.collection_title)
                # Insert in first position
                myGroup.insertChildNode(0, myClone)
                parent.removeChildNode(myLayer)
        else:
            message = "No internet connection."
            self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)

    def get_wmts(self):
        if checkNetConnection() == True:
            groupName = self.collection_title
            layers = self.collectionID
            url = self.url+ "/api/maps/1.0-beta/maps/"+layers+"/wmts?api_key="+self.api_key_permission
            urlWithParams = f"crs=EPSG:3857&dpiMode=7&format=image/jpeg&layers={layers}&styles=default&tileMatrixSet=vallaris_grid&url={url}"
            rlayer = QgsRasterLayer(urlWithParams, self.collection_title+"_wmts", 'wms')

            if not rlayer.isValid():
                print("Layer failed to load!")
            else:
                QgsProject.instance().addMapLayer(rlayer)
                root = QgsProject.instance().layerTreeRoot()
                if root.findGroup(self.collection_title) == None:
                    shapeGroup = root.addGroup(self.collection_title)
                    # cloned group
                    cloned_group1 = shapeGroup.clone()
                    # move the node (along with sub-groups and layers) to the top
                    root.insertChildNode(0, cloned_group1)
                    # remove the original node
                    root.removeChildNode(shapeGroup)

                shapeGroup = root.findGroup(self.collection_title)
                myLayer = root.findLayer(rlayer.id())
                myClone = myLayer.clone()
                parent = myLayer.parent()

                myGroup = root.findGroup(
                    self.collection_title)
                # Insert in first position
                myGroup.insertChildNode(0, myClone)
                parent.removeChildNode(myLayer)
        else:
            message = "No internet connection."
            self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)

    def get_tms(self):
        if checkNetConnection() == True:
            groupName = self.collection_title
            layers = self.collectionID
            url = self.url+ "/api/maps/1.0-beta/maps/"+layers+"/tms/{z}/{x}/{y}.png?api_key="+self.api_key_permission
            
            urlWithParams = f'type=xyz&url={url}&zmax=24&zmin=0&crs=EPSG3857'
            rlayer = QgsRasterLayer(urlWithParams, self.collection_title+"_tms", 'wms')

            if not rlayer.isValid():
                print("Layer failed to load!")
            else:
                QgsProject.instance().addMapLayer(rlayer)
                root = QgsProject.instance().layerTreeRoot()
                if root.findGroup(self.collection_title) == None:
                    shapeGroup = root.addGroup(self.collection_title)
                    # cloned group
                    cloned_group1 = shapeGroup.clone()
                    # move the node (along with sub-groups and layers) to the top
                    root.insertChildNode(0, cloned_group1)
                    # remove the original node
                    root.removeChildNode(shapeGroup)

                shapeGroup = root.findGroup(self.collection_title)
                myLayer = root.findLayer(rlayer.id())
                myClone = myLayer.clone()
                parent = myLayer.parent()

                myGroup = root.findGroup(
                    self.collection_title)
                # Insert in first position
                myGroup.insertChildNode(0, myClone)
                parent.removeChildNode(myLayer)
        else:
            message = "No internet connection."
            self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)

    def getStyle(self):

        if checkNetConnection() == True:
            QGIS_version = Qgis.QGIS_VERSION_INT

            if QGIS_version >= 31400:

                styleUrl, res_style = self.vallaris_api.get_style(
                    self.collectionID,self.api_key_permission)
                if res_style != False:
                    groupName = self.collection_title
                    if "openmaptiles" in res_style["sources"]:
                        url = self.url + "/tiles/public/osm/{z}/{x}/{y}"

                        name = "osm"
                        tileName = groupName + "_sources_"+name
                        self.add_tile(groupName, tileName, url, styleUrl)
                    if "osm" in res_style["sources"]:
                        url = self.url + "/tiles/public/osm/{z}/{x}/{y}"
                        name = "osm"
                        tileName = groupName + "_sources_"+name
                        self.add_tile(groupName, tileName, url, styleUrl)
                    for id in res_style["sources"]:
                        if str(id) != "openmaptiles" and str(id) != "osm":
                            res = self.vallaris_api.get_tiles(id)
                            if res != False:
                                url = res["tiles"][0]
                                name = res_style["sources"][id]["title"]
                                tileName = groupName + "_sources_"+name
                                self.add_tile(
                                    groupName, tileName, url, styleUrl)
                            else:
                                message = f"Generating Tile collection."
                                self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)
            else:
                message = "QGIS version does not support vector tiles. QGIS Minimum Version 3.14"
                self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)
        else:
            message = "No internet connection."
            self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)

    def add_tile(self, groupName, tileName, url, styleUrl=None):

        if checkNetConnection() == True:
            QGIS_version = Qgis.QGIS_VERSION_INT
            if QGIS_version >= 31400:
                root = QgsProject.instance().layerTreeRoot()
                if root.findGroup(self.collection_title) == None:
                    shapeGroup = root.addGroup(self.collection_title)
                    cloned_group1 = shapeGroup.clone()
                    # move the node (along with sub-groups and layers) to the top
                    root.insertChildNode(0, cloned_group1)
                    # remove the original node
                    root.removeChildNode(shapeGroup)
                ds = QgsDataSourceUri()
                ds.setParam("type", "xyz")
                ds.setParam("zmin", "0")
                ds.setParam("zmax", "24")
                ds.setParam("styleUrl", styleUrl)
                ds.setParam("url", url)
                uri = bytes(ds.encodedUri()).decode('utf-8')
                vtlayer = QgsVectorTileLayer(uri, tileName)
                QgsProject.instance().addMapLayer(vtlayer).loadDefaultStyle()
                layer = QgsProject.instance().mapLayersByName(tileName)[0]
                root = QgsProject.instance().layerTreeRoot()

                myLayer = root.findLayer(vtlayer.id())
                myClone = myLayer.clone()
                parent = myLayer.parent()

                myGroup = root.findGroup(groupName)
                # Insert in first position
                myGroup.insertChildNode(0, myClone)
                parent.removeChildNode(myLayer)
            else:
                message = "QGIS version does not support vector tiles. QGIS Minimum Version 3.14"
                self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)
        else:
            message = "No internet connection."
            self.iface.messageBar().pushMessage("Warning  ", message, level=1, duration=3)

    def progress_changed(self, progress_num):

        self.progress.setValue(progress_num)
        if progress_num == 100:
            self.progressMessageBar.clearWidgets()

    def init_progressBar(self, min_value=0, max_value=100):
        """
         Initializes the progress bar within with the given min and max value.

        :param min_value: (integer)
        :param max_value: (integer)
        """

        # clear the message bar
        self.iface.messageBar().clearWidgets()
        # set a new message bar
        self.progressMessageBar = self.iface.messageBar()
        self.progress = QtWidgets.QProgressBar()
        self.progress.setAlignment(QtCore.Qt.AlignCenter)
        self.progress.setStyleSheet(" QProgressBar::chunk "
                                    "{"
                                    "background: #2e7d32;"
                                    "QProgressBar { text-align: center; }"
                                    "}"
                                    "QProgressBar"
                                    "{"
                                    "color: rgb(255, 255, 255);"
                                    "background-color : lightblue;"
                                    "border : 1px"
                                    "}"
                                    )

        # Maximum is set to 100, making it easy to work with percentage of completion
        # If minimum and maximum both are set to 0, the bar shows a busy indicator instead of a percentage of steps.
        self.progress.setMinimum(min_value)
        self.progress.setMaximum(max_value)

        # pass the progress bar to the message Bar
        self.progressMessageBar.pushWidget(self.progress, duration=5)

    def like_(self):

        if self.dlg_features.condition.currentIndex() == 0:
            self.dlg_features.des_.hide()
            self.dlg_features.setMinimumSize(
                self.dlg_features.width(), self.dlg_features.height()-10)
            self.dlg_features.setMaximumSize(
                self.dlg_features.width(), self.dlg_features.height()-10)
        else:
            self.dlg_features.des_.show()
            self.dlg_features.setMinimumSize(
                self.dlg_features.width(), self.dlg_features.height()+10)
            self.dlg_features.setMaximumSize(
                self.dlg_features.width(), self.dlg_features.height()+10)
