# -*- coding: utf-8 -*-

from PyQt4.QtCore import QVariant


dir_list = ['BasiDati', 'GeoTec', 'Indagini', 'MS1', 'MS23', 'Plot', 'Vestiture', 'Documenti', 'Spettri', 'MS']


fls_list = ['Elineari.shp', 'Epuntuali.shp', 'Forme.shp', 'Geoidr.shp', 'Geotec.shp', 'Ind_ln.shp', 'Ind_pu.shp', 'Instab.shp', 'Stab.shp', 'CdI_Tabelle.sqlite']


tbl_list = ['sito_puntuale', 'sito_lineare', 'indagini_puntuali', 'indagini_lineari', 'parametri_puntuali', 'parametri_lineari', 'curve', 'metadati']


shp_validatore = ["geotec_self_inters", "stab_1_self_inters", "instab_1_self_inters", "ms1_inters_stab_instab", "stab_23_self_inters", "instab_23_self_inters", "ms23_inters_stab_instab", "stab1_gap", "stab23_gap", "instab1_gap", "instab23_gap", "geotec_gap", "forme_gap"]


dizio = {"GeoTec":[

{"table":"elineari","geomtype":2,"topologycheck":False,"fields":[
{"field":"ID_el","isuq":True,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"Tipo_el","isuq":False,"listvalues":[5011,5012,5021,5022,5031,5032,5001,5002,5111,5112,5121,5122,5131,5132,5141,5142,7011,7012,7021,7022,7031,7032,7051,7052,5041,5042,5051,5052,5060,5070,5081,5082,5301,5201,7041,7042,8001,8002],"type":["integer","integer64","Integer","Integer64"]}]},

{"table":"epuntuali","geomtype":1,"topologycheck":False,"fields":[
{"field":"ID_ep","isuq":True,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"Tipo_ep","isuq":False,"listvalues":[6010,6020],"type":["integer","integer64","Integer","Integer64"]}]},

{"table":"forme","geomtype":3,"topologycheck":False,"fields":[
{"field":"ID_f","isuq":True,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"Tipo_f","isuq":False,"listvalues":[4010,4020,4030],"type":["integer","integer64","Integer","Integer64"]}]},

{"table":"geotec","geomtype":3,"topologycheck":["gap","inters"],"fields":[
{"field":"ID_gt","isuq":True,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"Tipo_gt","isuq":False,"listvalues":['RI', 'GW', 'GP', 'GM', 'GC', 'SW', 'SP', 'SM', 'SC', 'OL', 'OH', 'MH', 'ML', 'CL', 'CH', 'PT', 'LP', 'GR', 'CO', 'AL', 'LPS', 'GRS', 'COS', 'ALS', 'SFLP', 'SFGR', 'SFCO', 'SFAL', 'SFLPS', 'SFGRS', 'SFCOS', 'SFALS'],"type":["string","text","String","Text"]},
{"field":"Stato","isuq":False,"listvalues":[11,12,13,14,21,22,23,24,25,26],"type":["integer","integer64","Integer","Integer64"]},
{"field":"Gen","isuq":False,"listvalues":['la', 'sc', 'ig', 'lh', 'fd', 'cd', 'cz', 'ec', 'es', 'dl', 'pd', 'in', 'ca', 'tf', 'va', 'lc', 'pa', 'pi', 'do', 'so', 'cy', 'cc', 'mr', 'fg', 'fl', 'ti', 'de', 'ls', 'sp', 'dc', 'cl', 'tm', 'pl', 'zz'],"type":["string","text","String","Text"]}]},

{"table":"geoidr","geomtype":3,"topologycheck":False,"fields":[
{"field":"ID_gi","isuq":True,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"Tipo_gi","isuq":False,"listvalues":['11', '21', '22', '31'],"type":["string","text","String","Text"]},
{"field":"Valore","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"Valore2","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]}]}

],

"MS1":[

{"table":"instab","geomtype":3,"topologycheck":["gap","inters"],"fields":[
{"field":"ID_i","isuq":True,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"Tipo_i","isuq":False,"listvalues":[30112001, 30112002, 30112003, 30112004, 30112005, 30112006, 30112007, 30112008, 30112009, 30112010, 30112011, 30112012, 30112013, 30112014, 30112015, 30112016, 30112017, 30112018, 30112019, 30112020, 30112021, 30112022, 30112023, 30112024, 30112025, 30112026, 30112027, 30112028, 30112029, 30112030, 30112031, 30112032, 30112033, 30112034, 30112035, 30112036, 30112037, 30112038, 30112039, 30112040, 30112041, 30112042, 30112043, 30112044, 30112045, 30112046, 30112047, 30112048, 30112049, 30112050, 30112051, 30112052, 30112053, 30112054, 30112055, 30112056, 30112057, 30112058, 30112059, 30112060, 30112061, 30112062, 30112063, 30112064, 30112065, 30112066, 30112067, 30112068, 30112069, 30112070, 30112071, 30112072, 30112073, 30112074, 30112075, 30112076, 30112077, 30112078, 30112079, 30112080, 30112081, 30112082, 30112083, 30112084, 30112085, 30112086, 30112087, 30112088, 30112089, 30112090, 30112091, 30112092, 30112093, 30112094, 30112095, 30112096, 30112097, 30112098, 30112099, 30122001, 30122002, 30122003, 30122004, 30122005, 30122006, 30122007, 30122008, 30122009, 30122010, 30122011, 30122012, 30122013, 30122014, 30122015, 30122016, 30122017, 30122018, 30122019, 30122020, 30122021, 30122022, 30122023, 30122024, 30122025, 30122026, 30122027, 30122028, 30122029, 30122030, 30122031, 30122032, 30122033, 30122034, 30122035, 30122036, 30122037, 30122038, 30122039, 30122040, 30122041, 30122042, 30122043, 30122044, 30122045, 30122046, 30122047, 30122048, 30122049, 30122050, 30122051, 30122052, 30122053, 30122054, 30122055, 30122056, 30122057, 30122058, 30122059, 30122060, 30122061, 30122062, 30122063, 30122064, 30122065, 30122066, 30122067, 30122068, 30122069, 30122070, 30122071, 30122072, 30122073, 30122074, 30122075, 30122076, 30122077, 30122078, 30122079, 30122080, 30122081, 30122082, 30122083, 30122084, 30122085, 30122086, 30122087, 30122088, 30122089, 30122090, 30122091, 30122092, 30122093, 30122094, 30122095, 30122096, 30122097, 30122098, 30122099, 30132001, 30132002, 30132003, 30132004, 30132005, 30132006, 30132007, 30132008, 30132009, 30132010, 30132011, 30132012, 30132013, 30132014, 30132015, 30132016, 30132017, 30132018, 30132019, 30132020, 30132021, 30132022, 30132023, 30132024, 30132025, 30132026, 30132027, 30132028, 30132029, 30132030, 30132031, 30132032, 30132033, 30132034, 30132035, 30132036, 30132037, 30132038, 30132039, 30132040, 30132041, 30132042, 30132043, 30132044, 30132045, 30132046, 30132047, 30132048, 30132049, 30132050, 30132051, 30132052, 30132053, 30132054, 30132055, 30132056, 30132057, 30132058, 30132059, 30132060, 30132061, 30132062, 30132063, 30132064, 30132065, 30132066, 30132067, 30132068, 30132069, 30132070, 30132071, 30132072, 30132073, 30132074, 30132075, 30132076, 30132077, 30132078, 30132079, 30132080, 30132081, 30132082, 30132083, 30132084, 30132085, 30132086, 30132087, 30132088, 30132089, 30132090, 30132091, 30132092, 30132093, 30132094, 30132095, 30132096, 30132097, 30132098, 30132099, 30142001, 30142002, 30142003, 30142004, 30142005, 30142006, 30142007, 30142008, 30142009, 30142010, 30142011, 30142012, 30142013, 30142014, 30142015, 30142016, 30142017, 30142018, 30142019, 30142020, 30142021, 30142022, 30142023, 30142024, 30142025, 30142026, 30142027, 30142028, 30142029, 30142030, 30142031, 30142032, 30142033, 30142034, 30142035, 30142036, 30142037, 30142038, 30142039, 30142040, 30142041, 30142042, 30142043, 30142044, 30142045, 30142046, 30142047, 30142048, 30142049, 30142050, 30142051, 30142052, 30142053, 30142054, 30142055, 30142056, 30142057, 30142058, 30142059, 30142060, 30142061, 30142062, 30142063, 30142064, 30142065, 30142066, 30142067, 30142068, 30142069, 30142070, 30142071, 30142072, 30142073, 30142074, 30142075, 30142076, 30142077, 30142078, 30142079, 30142080, 30142081, 30142082, 30142083, 30142084, 30142085, 30142086, 30142087, 30142088, 30142089, 30142090, 30142091, 30142092, 30142093, 30142094, 30142095, 30142096, 30142097, 30142098, 30142099, 30152001, 30152002, 30152003, 30152004, 30152005, 30152006, 30152007, 30152008, 30152009, 30152010, 30152011, 30152012, 30152013, 30152014, 30152015, 30152016, 30152017, 30152018, 30152019, 30152020, 30152021, 30152022, 30152023, 30152024, 30152025, 30152026, 30152027, 30152028, 30152029, 30152030, 30152031, 30152032, 30152033, 30152034, 30152035, 30152036, 30152037, 30152038, 30152039, 30152040, 30152041, 30152042, 30152043, 30152044, 30152045, 30152046, 30152047, 30152048, 30152049, 30152050, 30152051, 30152052, 30152053, 30152054, 30152055, 30152056, 30152057, 30152058, 30152059, 30152060, 30152061, 30152062, 30152063, 30152064, 30152065, 30152066, 30152067, 30152068, 30152069, 30152070, 30152071, 30152072, 30152073, 30152074, 30152075, 30152076, 30152077, 30152078, 30152079, 30152080, 30152081, 30152082, 30152083, 30152084, 30152085, 30152086, 30152087, 30152088, 30152089, 30152090, 30152091, 30152092, 30152093, 30152094, 30152095, 30152096, 30152097, 30152098, 30152099, 30212001, 30212002, 30212003, 30212004, 30212005, 30212006, 30212007, 30212008, 30212009, 30212010, 30212011, 30212012, 30212013, 30212014, 30212015, 30212016, 30212017, 30212018, 30212019, 30212020, 30212021, 30212022, 30212023, 30212024, 30212025, 30212026, 30212027, 30212028, 30212029, 30212030, 30212031, 30212032, 30212033, 30212034, 30212035, 30212036, 30212037, 30212038, 30212039, 30212040, 30212041, 30212042, 30212043, 30212044, 30212045, 30212046, 30212047, 30212048, 30212049, 30212050, 30212051, 30212052, 30212053, 30212054, 30212055, 30212056, 30212057, 30212058, 30212059, 30212060, 30212061, 30212062, 30212063, 30212064, 30212065, 30212066, 30212067, 30212068, 30212069, 30212070, 30212071, 30212072, 30212073, 30212074, 30212075, 30212076, 30212077, 30212078, 30212079, 30212080, 30212081, 30212082, 30212083, 30212084, 30212085, 30212086, 30212087, 30212088, 30212089, 30212090, 30212091, 30212092, 30212093, 30212094, 30212095, 30212096, 30212097, 30212098, 30212099, 30222001, 30222002, 30222003, 30222004, 30222005, 30222006, 30222007, 30222008, 30222009, 30222010, 30222011, 30222012, 30222013, 30222014, 30222015, 30222016, 30222017, 30222018, 30222019, 30222020, 30222021, 30222022, 30222023, 30222024, 30222025, 30222026, 30222027, 30222028, 30222029, 30222030, 30222031, 30222032, 30222033, 30222034, 30222035, 30222036, 30222037, 30222038, 30222039, 30222040, 30222041, 30222042, 30222043, 30222044, 30222045, 30222046, 30222047, 30222048, 30222049, 30222050, 30222051, 30222052, 30222053, 30222054, 30222055, 30222056, 30222057, 30222058, 30222059, 30222060, 30222061, 30222062, 30222063, 30222064, 30222065, 30222066, 30222067, 30222068, 30222069, 30222070, 30222071, 30222072, 30222073, 30222074, 30222075, 30222076, 30222077, 30222078, 30222079, 30222080, 30222081, 30222082, 30222083, 30222084, 30222085, 30222086, 30222087, 30222088, 30222089, 30222090, 30222091, 30222092, 30222093, 30222094, 30222095, 30222096, 30222097, 30222098, 30222099, 30232001, 30232002, 30232003, 30232004, 30232005, 30232006, 30232007, 30232008, 30232009, 30232010, 30232011, 30232012, 30232013, 30232014, 30232015, 30232016, 30232017, 30232018, 30232019, 30232020, 30232021, 30232022, 30232023, 30232024, 30232025, 30232026, 30232027, 30232028, 30232029, 30232030, 30232031, 30232032, 30232033, 30232034, 30232035, 30232036, 30232037, 30232038, 30232039, 30232040, 30232041, 30232042, 30232043, 30232044, 30232045, 30232046, 30232047, 30232048, 30232049, 30232050, 30232051, 30232052, 30232053, 30232054, 30232055, 30232056, 30232057, 30232058, 30232059, 30232060, 30232061, 30232062, 30232063, 30232064, 30232065, 30232066, 30232067, 30232068, 30232069, 30232070, 30232071, 30232072, 30232073, 30232074, 30232075, 30232076, 30232077, 30232078, 30232079, 30232080, 30232081, 30232082, 30232083, 30232084, 30232085, 30232086, 30232087, 30232088, 30232089, 30232090, 30232091, 30232092, 30232093, 30232094, 30232095, 30232096, 30232097, 30232098, 30232099, 30242001, 30242002, 30242003, 30242004, 30242005, 30242006, 30242007, 30242008, 30242009, 30242010, 30242011, 30242012, 30242013, 30242014, 30242015, 30242016, 30242017, 30242018, 30242019, 30242020, 30242021, 30242022, 30242023, 30242024, 30242025, 30242026, 30242027, 30242028, 30242029, 30242030, 30242031, 30242032, 30242033, 30242034, 30242035, 30242036, 30242037, 30242038, 30242039, 30242040, 30242041, 30242042, 30242043, 30242044, 30242045, 30242046, 30242047, 30242048, 30242049, 30242050, 30242051, 30242052, 30242053, 30242054, 30242055, 30242056, 30242057, 30242058, 30242059, 30242060, 30242061, 30242062, 30242063, 30242064, 30242065, 30242066, 30242067, 30242068, 30242069, 30242070, 30242071, 30242072, 30242073, 30242074, 30242075, 30242076, 30242077, 30242078, 30242079, 30242080, 30242081, 30242082, 30242083, 30242084, 30242085, 30242086, 30242087, 30242088, 30242089, 30242090, 30242091, 30242092, 30242093, 30242094, 30242095, 30242096, 30242097, 30242098, 30242099, 30252001, 30252002, 30252003, 30252004, 30252005, 30252006, 30252007, 30252008, 30252009, 30252010, 30252011, 30252012, 30252013, 30252014, 30252015, 30252016, 30252017, 30252018, 30252019, 30252020, 30252021, 30252022, 30252023, 30252024, 30252025, 30252026, 30252027, 30252028, 30252029, 30252030, 30252031, 30252032, 30252033, 30252034, 30252035, 30252036, 30252037, 30252038, 30252039, 30252040, 30252041, 30252042, 30252043, 30252044, 30252045, 30252046, 30252047, 30252048, 30252049, 30252050, 30252051, 30252052, 30252053, 30252054, 30252055, 30252056, 30252057, 30252058, 30252059, 30252060, 30252061, 30252062, 30252063, 30252064, 30252065, 30252066, 30252067, 30252068, 30252069, 30252070, 30252071, 30252072, 30252073, 30252074, 30252075, 30252076, 30252077, 30252078, 30252079, 30252080, 30252081, 30252082, 30252083, 30252084, 30252085, 30252086, 30252087, 30252088, 30252089, 30252090, 30252091, 30252092, 30252093, 30252094, 30252095, 30252096, 30252097, 30252098, 30252099, 30312001, 30312002, 30312003, 30312004, 30312005, 30312006, 30312007, 30312008, 30312009, 30312010, 30312011, 30312012, 30312013, 30312014, 30312015, 30312016, 30312017, 30312018, 30312019, 30312020, 30312021, 30312022, 30312023, 30312024, 30312025, 30312026, 30312027, 30312028, 30312029, 30312030, 30312031, 30312032, 30312033, 30312034, 30312035, 30312036, 30312037, 30312038, 30312039, 30312040, 30312041, 30312042, 30312043, 30312044, 30312045, 30312046, 30312047, 30312048, 30312049, 30312050, 30312051, 30312052, 30312053, 30312054, 30312055, 30312056, 30312057, 30312058, 30312059, 30312060, 30312061, 30312062, 30312063, 30312064, 30312065, 30312066, 30312067, 30312068, 30312069, 30312070, 30312071, 30312072, 30312073, 30312074, 30312075, 30312076, 30312077, 30312078, 30312079, 30312080, 30312081, 30312082, 30312083, 30312084, 30312085, 30312086, 30312087, 30312088, 30312089, 30312090, 30312091, 30312092, 30312093, 30312094, 30312095, 30312096, 30312097, 30312098, 30312099, 30322001, 30322002, 30322003, 30322004, 30322005, 30322006, 30322007, 30322008, 30322009, 30322010, 30322011, 30322012, 30322013, 30322014, 30322015, 30322016, 30322017, 30322018, 30322019, 30322020, 30322021, 30322022, 30322023, 30322024, 30322025, 30322026, 30322027, 30322028, 30322029, 30322030, 30322031, 30322032, 30322033, 30322034, 30322035, 30322036, 30322037, 30322038, 30322039, 30322040, 30322041, 30322042, 30322043, 30322044, 30322045, 30322046, 30322047, 30322048, 30322049, 30322050, 30322051, 30322052, 30322053, 30322054, 30322055, 30322056, 30322057, 30322058, 30322059, 30322060, 30322061, 30322062, 30322063, 30322064, 30322065, 30322066, 30322067, 30322068, 30322069, 30322070, 30322071, 30322072, 30322073, 30322074, 30322075, 30322076, 30322077, 30322078, 30322079, 30322080, 30322081, 30322082, 30322083, 30322084, 30322085, 30322086, 30322087, 30322088, 30322089, 30322090, 30322091, 30322092, 30322093, 30322094, 30322095, 30322096, 30322097, 30322098, 30322099, 30332001, 30332002, 30332003, 30332004, 30332005, 30332006, 30332007, 30332008, 30332009, 30332010, 30332011, 30332012, 30332013, 30332014, 30332015, 30332016, 30332017, 30332018, 30332019, 30332020, 30332021, 30332022, 30332023, 30332024, 30332025, 30332026, 30332027, 30332028, 30332029, 30332030, 30332031, 30332032, 30332033, 30332034, 30332035, 30332036, 30332037, 30332038, 30332039, 30332040, 30332041, 30332042, 30332043, 30332044, 30332045, 30332046, 30332047, 30332048, 30332049, 30332050, 30332051, 30332052, 30332053, 30332054, 30332055, 30332056, 30332057, 30332058, 30332059, 30332060, 30332061, 30332062, 30332063, 30332064, 30332065, 30332066, 30332067, 30332068, 30332069, 30332070, 30332071, 30332072, 30332073, 30332074, 30332075, 30332076, 30332077, 30332078, 30332079, 30332080, 30332081, 30332082, 30332083, 30332084, 30332085, 30332086, 30332087, 30332088, 30332089, 30332090, 30332091, 30332092, 30332093, 30332094, 30332095, 30332096, 30332097, 30332098, 30332099, 30342001, 30342002, 30342003, 30342004, 30342005, 30342006, 30342007, 30342008, 30342009, 30342010, 30342011, 30342012, 30342013, 30342014, 30342015, 30342016, 30342017, 30342018, 30342019, 30342020, 30342021, 30342022, 30342023, 30342024, 30342025, 30342026, 30342027, 30342028, 30342029, 30342030, 30342031, 30342032, 30342033, 30342034, 30342035, 30342036, 30342037, 30342038, 30342039, 30342040, 30342041, 30342042, 30342043, 30342044, 30342045, 30342046, 30342047, 30342048, 30342049, 30342050, 30342051, 30342052, 30342053, 30342054, 30342055, 30342056, 30342057, 30342058, 30342059, 30342060, 30342061, 30342062, 30342063, 30342064, 30342065, 30342066, 30342067, 30342068, 30342069, 30342070, 30342071, 30342072, 30342073, 30342074, 30342075, 30342076, 30342077, 30342078, 30342079, 30342080, 30342081, 30342082, 30342083, 30342084, 30342085, 30342086, 30342087, 30342088, 30342089, 30342090, 30342091, 30342092, 30342093, 30342094, 30342095, 30342096, 30342097, 30342098, 30342099, 30352001, 30352002, 30352003, 30352004, 30352005, 30352006, 30352007, 30352008, 30352009, 30352010, 30352011, 30352012, 30352013, 30352014, 30352015, 30352016, 30352017, 30352018, 30352019, 30352020, 30352021, 30352022, 30352023, 30352024, 30352025, 30352026, 30352027, 30352028, 30352029, 30352030, 30352031, 30352032, 30352033, 30352034, 30352035, 30352036, 30352037, 30352038, 30352039, 30352040, 30352041, 30352042, 30352043, 30352044, 30352045, 30352046, 30352047, 30352048, 30352049, 30352050, 30352051, 30352052, 30352053, 30352054, 30352055, 30352056, 30352057, 30352058, 30352059, 30352060, 30352061, 30352062, 30352063, 30352064, 30352065, 30352066, 30352067, 30352068, 30352069, 30352070, 30352071, 30352072, 30352073, 30352074, 30352075, 30352076, 30352077, 30352078, 30352079, 30352080, 30352081, 30352082, 30352083, 30352084, 30352085, 30352086, 30352087, 30352088, 30352089, 30352090, 30352091, 30352092, 30352093, 30352094, 30352095, 30352096, 30352097, 30352098, 30352099, 30412001, 30412002, 30412003, 30412004, 30412005, 30412006, 30412007, 30412008, 30412009, 30412010, 30412011, 30412012, 30412013, 30412014, 30412015, 30412016, 30412017, 30412018, 30412019, 30412020, 30412021, 30412022, 30412023, 30412024, 30412025, 30412026, 30412027, 30412028, 30412029, 30412030, 30412031, 30412032, 30412033, 30412034, 30412035, 30412036, 30412037, 30412038, 30412039, 30412040, 30412041, 30412042, 30412043, 30412044, 30412045, 30412046, 30412047, 30412048, 30412049, 30412050, 30412051, 30412052, 30412053, 30412054, 30412055, 30412056, 30412057, 30412058, 30412059, 30412060, 30412061, 30412062, 30412063, 30412064, 30412065, 30412066, 30412067, 30412068, 30412069, 30412070, 30412071, 30412072, 30412073, 30412074, 30412075, 30412076, 30412077, 30412078, 30412079, 30412080, 30412081, 30412082, 30412083, 30412084, 30412085, 30412086, 30412087, 30412088, 30412089, 30412090, 30412091, 30412092, 30412093, 30412094, 30412095, 30412096, 30412097, 30412098, 30412099, 30422001, 30422002, 30422003, 30422004, 30422005, 30422006, 30422007, 30422008, 30422009, 30422010, 30422011, 30422012, 30422013, 30422014, 30422015, 30422016, 30422017, 30422018, 30422019, 30422020, 30422021, 30422022, 30422023, 30422024, 30422025, 30422026, 30422027, 30422028, 30422029, 30422030, 30422031, 30422032, 30422033, 30422034, 30422035, 30422036, 30422037, 30422038, 30422039, 30422040, 30422041, 30422042, 30422043, 30422044, 30422045, 30422046, 30422047, 30422048, 30422049, 30422050, 30422051, 30422052, 30422053, 30422054, 30422055, 30422056, 30422057, 30422058, 30422059, 30422060, 30422061, 30422062, 30422063, 30422064, 30422065, 30422066, 30422067, 30422068, 30422069, 30422070, 30422071, 30422072, 30422073, 30422074, 30422075, 30422076, 30422077, 30422078, 30422079, 30422080, 30422081, 30422082, 30422083, 30422084, 30422085, 30422086, 30422087, 30422088, 30422089, 30422090, 30422091, 30422092, 30422093, 30422094, 30422095, 30422096, 30422097, 30422098, 30422099, 30432001, 30432002, 30432003, 30432004, 30432005, 30432006, 30432007, 30432008, 30432009, 30432010, 30432011, 30432012, 30432013, 30432014, 30432015, 30432016, 30432017, 30432018, 30432019, 30432020, 30432021, 30432022, 30432023, 30432024, 30432025, 30432026, 30432027, 30432028, 30432029, 30432030, 30432031, 30432032, 30432033, 30432034, 30432035, 30432036, 30432037, 30432038, 30432039, 30432040, 30432041, 30432042, 30432043, 30432044, 30432045, 30432046, 30432047, 30432048, 30432049, 30432050, 30432051, 30432052, 30432053, 30432054, 30432055, 30432056, 30432057, 30432058, 30432059, 30432060, 30432061, 30432062, 30432063, 30432064, 30432065, 30432066, 30432067, 30432068, 30432069, 30432070, 30432071, 30432072, 30432073, 30432074, 30432075, 30432076, 30432077, 30432078, 30432079, 30432080, 30432081, 30432082, 30432083, 30432084, 30432085, 30432086, 30432087, 30432088, 30432089, 30432090, 30432091, 30432092, 30432093, 30432094, 30432095, 30432096, 30432097, 30432098, 30432099, 30442001, 30442002, 30442003, 30442004, 30442005, 30442006, 30442007, 30442008, 30442009, 30442010, 30442011, 30442012, 30442013, 30442014, 30442015, 30442016, 30442017, 30442018, 30442019, 30442020, 30442021, 30442022, 30442023, 30442024, 30442025, 30442026, 30442027, 30442028, 30442029, 30442030, 30442031, 30442032, 30442033, 30442034, 30442035, 30442036, 30442037, 30442038, 30442039, 30442040, 30442041, 30442042, 30442043, 30442044, 30442045, 30442046, 30442047, 30442048, 30442049, 30442050, 30442051, 30442052, 30442053, 30442054, 30442055, 30442056, 30442057, 30442058, 30442059, 30442060, 30442061, 30442062, 30442063, 30442064, 30442065, 30442066, 30442067, 30442068, 30442069, 30442070, 30442071, 30442072, 30442073, 30442074, 30442075, 30442076, 30442077, 30442078, 30442079, 30442080, 30442081, 30442082, 30442083, 30442084, 30442085, 30442086, 30442087, 30442088, 30442089, 30442090, 30442091, 30442092, 30442093, 30442094, 30442095, 30442096, 30442097, 30442098, 30442099, 30452001, 30452002, 30452003, 30452004, 30452005, 30452006, 30452007, 30452008, 30452009, 30452010, 30452011, 30452012, 30452013, 30452014, 30452015, 30452016, 30452017, 30452018, 30452019, 30452020, 30452021, 30452022, 30452023, 30452024, 30452025, 30452026, 30452027, 30452028, 30452029, 30452030, 30452031, 30452032, 30452033, 30452034, 30452035, 30452036, 30452037, 30452038, 30452039, 30452040, 30452041, 30452042, 30452043, 30452044, 30452045, 30452046, 30452047, 30452048, 30452049, 30452050, 30452051, 30452052, 30452053, 30452054, 30452055, 30452056, 30452057, 30452058, 30452059, 30452060, 30452061, 30452062, 30452063, 30452064, 30452065, 30452066, 30452067, 30452068, 30452069, 30452070, 30452071, 30452072, 30452073, 30452074, 30452075, 30452076, 30452077, 30452078, 30452079, 30452080, 30452081, 30452082, 30452083, 30452084, 30452085, 30452086, 30452087, 30452088, 30452089, 30452090, 30452091, 30452092, 30452093, 30452094, 30452095, 30452096, 30452097, 30452098, 30452099, 30502001, 30502002, 30502003, 30502004, 30502005, 30502006, 30502007, 30502008, 30502009, 30502010, 30502011, 30502012, 30502013, 30502014, 30502015, 30502016, 30502017, 30502018, 30502019, 30502020, 30502021, 30502022, 30502023, 30502024, 30502025, 30502026, 30502027, 30502028, 30502029, 30502030, 30502031, 30502032, 30502033, 30502034, 30502035, 30502036, 30502037, 30502038, 30502039, 30502040, 30502041, 30502042, 30502043, 30502044, 30502045, 30502046, 30502047, 30502048, 30502049, 30502050, 30502051, 30502052, 30502053, 30502054, 30502055, 30502056, 30502057, 30502058, 30502059, 30502060, 30502061, 30502062, 30502063, 30502064, 30502065, 30502066, 30502067, 30502068, 30502069, 30502070, 30502071, 30502072, 30502073, 30502074, 30502075, 30502076, 30502077, 30502078, 30502079, 30502080, 30502081, 30502082, 30502083, 30502084, 30502085, 30502086, 30502087, 30502088, 30502089, 30502090, 30502091, 30502092, 30502093, 30502094, 30502095, 30502096, 30502097, 30502098, 30502099, 30012001, 30012002, 30012003, 30012004, 30012005, 30012006, 30012007, 30012008, 30012009, 30012010, 30012011, 30012012, 30012013, 30012014, 30012015, 30012016, 30012017, 30012018, 30012019, 30012020, 30012021, 30012022, 30012023, 30012024, 30012025, 30012026, 30012027, 30012028, 30012029, 30012030, 30012031, 30012032, 30012033, 30012034, 30012035, 30012036, 30012037, 30012038, 30012039, 30012040, 30012041, 30012042, 30012043, 30012044, 30012045, 30012046, 30012047, 30012048, 30012049, 30012050, 30012051, 30012052, 30012053, 30012054, 30012055, 30012056, 30012057, 30012058, 30012059, 30012060, 30012061, 30012062, 30012063, 30012064, 30012065, 30012066, 30012067, 30012068, 30012069, 30012070, 30012071, 30012072, 30012073, 30012074, 30012075, 30012076, 30012077, 30012078, 30012079, 30012080, 30012081, 30012082, 30012083, 30012084, 30012085, 30012086, 30012087, 30012088, 30012089, 30012090, 30012091, 30012092, 30012093, 30012094, 30012095, 30012096, 30012097, 30012098, 30012099, 30022001, 30022002, 30022003, 30022004, 30022005, 30022006, 30022007, 30022008, 30022009, 30022010, 30022011, 30022012, 30022013, 30022014, 30022015, 30022016, 30022017, 30022018, 30022019, 30022020, 30022021, 30022022, 30022023, 30022024, 30022025, 30022026, 30022027, 30022028, 30022029, 30022030, 30022031, 30022032, 30022033, 30022034, 30022035, 30022036, 30022037, 30022038, 30022039, 30022040, 30022041, 30022042, 30022043, 30022044, 30022045, 30022046, 30022047, 30022048, 30022049, 30022050, 30022051, 30022052, 30022053, 30022054, 30022055, 30022056, 30022057, 30022058, 30022059, 30022060, 30022061, 30022062, 30022063, 30022064, 30022065, 30022066, 30022067, 30022068, 30022069, 30022070, 30022071, 30022072, 30022073, 30022074, 30022075, 30022076, 30022077, 30022078, 30022079, 30022080, 30022081, 30022082, 30022083, 30022084, 30022085, 30022086, 30022087, 30022088, 30022089, 30022090, 30022091, 30022092, 30022093, 30022094, 30022095, 30022096, 30022097, 30022098, 30022099, 30522001, 30522002, 30522003, 30522004, 30522005, 30522006, 30522007, 30522008, 30522009, 30522010, 30522011, 30522012, 30522013, 30522014, 30522015, 30522016, 30522017, 30522018, 30522019, 30522020, 30522021, 30522022, 30522023, 30522024, 30522025, 30522026, 30522027, 30522028, 30522029, 30522030, 30522031, 30522032, 30522033, 30522034, 30522035, 30522036, 30522037, 30522038, 30522039, 30522040, 30522041, 30522042, 30522043, 30522044, 30522045, 30522046, 30522047, 30522048, 30522049, 30522050, 30522051, 30522052, 30522053, 30522054, 30522055, 30522056, 30522057, 30522058, 30522059, 30522060, 30522061, 30522062, 30522063, 30522064, 30522065, 30522066, 30522067, 30522068, 30522069, 30522070, 30522071, 30522072, 30522073, 30522074, 30522075, 30522076, 30522077, 30522078, 30522079, 30522080, 30522081, 30522082, 30522083, 30522084, 30522085, 30522086, 30522087, 30522088, 30522089, 30522090, 30522091, 30522092, 30522093, 30522094, 30522095, 30522096, 30522097, 30522098, 30522099, 30532001, 30532002, 30532003, 30532004, 30532005, 30532006, 30532007, 30532008, 30532009, 30532010, 30532011, 30532012, 30532013, 30532014, 30532015, 30532016, 30532017, 30532018, 30532019, 30532020, 30532021, 30532022, 30532023, 30532024, 30532025, 30532026, 30532027, 30532028, 30532029, 30532030, 30532031, 30532032, 30532033, 30532034, 30532035, 30532036, 30532037, 30532038, 30532039, 30532040, 30532041, 30532042, 30532043, 30532044, 30532045, 30532046, 30532047, 30532048, 30532049, 30532050, 30532051, 30532052, 30532053, 30532054, 30532055, 30532056, 30532057, 30532058, 30532059, 30532060, 30532061, 30532062, 30532063, 30532064, 30532065, 30532066, 30532067, 30532068, 30532069, 30532070, 30532071, 30532072, 30532073, 30532074, 30532075, 30532076, 30532077, 30532078, 30532079, 30532080, 30532081, 30532082, 30532083, 30532084, 30532085, 30532086, 30532087, 30532088, 30532089, 30532090, 30532091, 30532092, 30532093, 30532094, 30532095, 30532096, 30532097, 30532098, 30532099, 3061, 3062, 3060, 3070, 3080],"type":["integer","integer64","Integer","Integer64"]},
{"field":"FRT","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FRR","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"IL","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"AMB","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"DISL","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FA","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FV","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"Ft","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FH0105","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FH0510","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FH0515","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FPGA","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FA0105","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FA0408","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FA0711","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"SPETTRI","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"CAT","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"LIVELLO","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]}]},

{"table":"isosub","geomtype":2,"topologycheck":False,"fields":[
{"field":"ID_isosub","isuq":True,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"Quota","isuq":False,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]}]},

{"table":"stab","geomtype":3,"topologycheck":["gap","inters"],"fields":[
{"field":"ID_z","isuq":True,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"Tipo_z","isuq":False,"listvalues":[1011, 1012, 1021, 1022, 1031, 1032, 1041, 1042, 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020, 2021, 2022, 2023, 2024, 2025, 2026, 2027, 2028, 2029, 2030, 2031, 2032, 2033, 2034, 2035, 2036, 2037, 2038, 2039, 2040, 2041, 2042, 2043, 2044, 2045, 2046, 2047, 2048, 2049, 2050, 2051, 2052, 2053, 2054, 2055, 2056, 2057, 2058, 2059, 2060, 2061, 2062, 2063, 2064, 2065, 2066, 2067, 2068, 2069, 2070, 2071, 2072, 2073, 2074, 2075, 2076, 2077, 2078, 2079, 2080, 2081, 2082, 2083, 2084, 2085, 2086, 2087, 2088, 2089, 2090, 2091, 2092, 2093, 2094, 2095, 2096, 2097, 2098, 2099],"type":["integer","integer64","Integer","Integer64"]},
{"field":"FA","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FV","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"Ft","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FH0105","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FH0510","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FH0515","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FPGA","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FA0105","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FA0408","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FA0711","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"SPETTRI","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"CAT","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"LIVELLO","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]}]}

],

"MS23":[

{"table":"instab","geomtype":3,"topologycheck":["gap","inters"],"fields":[
{"field":"ID_i","isuq":True,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"Tipo_i","isuq":False,"listvalues":[30112001, 30112002, 30112003, 30112004, 30112005, 30112006, 30112007, 30112008, 30112009, 30112010, 30112011, 30112012, 30112013, 30112014, 30112015, 30112016, 30112017, 30112018, 30112019, 30112020, 30112021, 30112022, 30112023, 30112024, 30112025, 30112026, 30112027, 30112028, 30112029, 30112030, 30112031, 30112032, 30112033, 30112034, 30112035, 30112036, 30112037, 30112038, 30112039, 30112040, 30112041, 30112042, 30112043, 30112044, 30112045, 30112046, 30112047, 30112048, 30112049, 30112050, 30112051, 30112052, 30112053, 30112054, 30112055, 30112056, 30112057, 30112058, 30112059, 30112060, 30112061, 30112062, 30112063, 30112064, 30112065, 30112066, 30112067, 30112068, 30112069, 30112070, 30112071, 30112072, 30112073, 30112074, 30112075, 30112076, 30112077, 30112078, 30112079, 30112080, 30112081, 30112082, 30112083, 30112084, 30112085, 30112086, 30112087, 30112088, 30112089, 30112090, 30112091, 30112092, 30112093, 30112094, 30112095, 30112096, 30112097, 30112098, 30112099, 30122001, 30122002, 30122003, 30122004, 30122005, 30122006, 30122007, 30122008, 30122009, 30122010, 30122011, 30122012, 30122013, 30122014, 30122015, 30122016, 30122017, 30122018, 30122019, 30122020, 30122021, 30122022, 30122023, 30122024, 30122025, 30122026, 30122027, 30122028, 30122029, 30122030, 30122031, 30122032, 30122033, 30122034, 30122035, 30122036, 30122037, 30122038, 30122039, 30122040, 30122041, 30122042, 30122043, 30122044, 30122045, 30122046, 30122047, 30122048, 30122049, 30122050, 30122051, 30122052, 30122053, 30122054, 30122055, 30122056, 30122057, 30122058, 30122059, 30122060, 30122061, 30122062, 30122063, 30122064, 30122065, 30122066, 30122067, 30122068, 30122069, 30122070, 30122071, 30122072, 30122073, 30122074, 30122075, 30122076, 30122077, 30122078, 30122079, 30122080, 30122081, 30122082, 30122083, 30122084, 30122085, 30122086, 30122087, 30122088, 30122089, 30122090, 30122091, 30122092, 30122093, 30122094, 30122095, 30122096, 30122097, 30122098, 30122099, 30132001, 30132002, 30132003, 30132004, 30132005, 30132006, 30132007, 30132008, 30132009, 30132010, 30132011, 30132012, 30132013, 30132014, 30132015, 30132016, 30132017, 30132018, 30132019, 30132020, 30132021, 30132022, 30132023, 30132024, 30132025, 30132026, 30132027, 30132028, 30132029, 30132030, 30132031, 30132032, 30132033, 30132034, 30132035, 30132036, 30132037, 30132038, 30132039, 30132040, 30132041, 30132042, 30132043, 30132044, 30132045, 30132046, 30132047, 30132048, 30132049, 30132050, 30132051, 30132052, 30132053, 30132054, 30132055, 30132056, 30132057, 30132058, 30132059, 30132060, 30132061, 30132062, 30132063, 30132064, 30132065, 30132066, 30132067, 30132068, 30132069, 30132070, 30132071, 30132072, 30132073, 30132074, 30132075, 30132076, 30132077, 30132078, 30132079, 30132080, 30132081, 30132082, 30132083, 30132084, 30132085, 30132086, 30132087, 30132088, 30132089, 30132090, 30132091, 30132092, 30132093, 30132094, 30132095, 30132096, 30132097, 30132098, 30132099, 30142001, 30142002, 30142003, 30142004, 30142005, 30142006, 30142007, 30142008, 30142009, 30142010, 30142011, 30142012, 30142013, 30142014, 30142015, 30142016, 30142017, 30142018, 30142019, 30142020, 30142021, 30142022, 30142023, 30142024, 30142025, 30142026, 30142027, 30142028, 30142029, 30142030, 30142031, 30142032, 30142033, 30142034, 30142035, 30142036, 30142037, 30142038, 30142039, 30142040, 30142041, 30142042, 30142043, 30142044, 30142045, 30142046, 30142047, 30142048, 30142049, 30142050, 30142051, 30142052, 30142053, 30142054, 30142055, 30142056, 30142057, 30142058, 30142059, 30142060, 30142061, 30142062, 30142063, 30142064, 30142065, 30142066, 30142067, 30142068, 30142069, 30142070, 30142071, 30142072, 30142073, 30142074, 30142075, 30142076, 30142077, 30142078, 30142079, 30142080, 30142081, 30142082, 30142083, 30142084, 30142085, 30142086, 30142087, 30142088, 30142089, 30142090, 30142091, 30142092, 30142093, 30142094, 30142095, 30142096, 30142097, 30142098, 30142099, 30152001, 30152002, 30152003, 30152004, 30152005, 30152006, 30152007, 30152008, 30152009, 30152010, 30152011, 30152012, 30152013, 30152014, 30152015, 30152016, 30152017, 30152018, 30152019, 30152020, 30152021, 30152022, 30152023, 30152024, 30152025, 30152026, 30152027, 30152028, 30152029, 30152030, 30152031, 30152032, 30152033, 30152034, 30152035, 30152036, 30152037, 30152038, 30152039, 30152040, 30152041, 30152042, 30152043, 30152044, 30152045, 30152046, 30152047, 30152048, 30152049, 30152050, 30152051, 30152052, 30152053, 30152054, 30152055, 30152056, 30152057, 30152058, 30152059, 30152060, 30152061, 30152062, 30152063, 30152064, 30152065, 30152066, 30152067, 30152068, 30152069, 30152070, 30152071, 30152072, 30152073, 30152074, 30152075, 30152076, 30152077, 30152078, 30152079, 30152080, 30152081, 30152082, 30152083, 30152084, 30152085, 30152086, 30152087, 30152088, 30152089, 30152090, 30152091, 30152092, 30152093, 30152094, 30152095, 30152096, 30152097, 30152098, 30152099, 30212001, 30212002, 30212003, 30212004, 30212005, 30212006, 30212007, 30212008, 30212009, 30212010, 30212011, 30212012, 30212013, 30212014, 30212015, 30212016, 30212017, 30212018, 30212019, 30212020, 30212021, 30212022, 30212023, 30212024, 30212025, 30212026, 30212027, 30212028, 30212029, 30212030, 30212031, 30212032, 30212033, 30212034, 30212035, 30212036, 30212037, 30212038, 30212039, 30212040, 30212041, 30212042, 30212043, 30212044, 30212045, 30212046, 30212047, 30212048, 30212049, 30212050, 30212051, 30212052, 30212053, 30212054, 30212055, 30212056, 30212057, 30212058, 30212059, 30212060, 30212061, 30212062, 30212063, 30212064, 30212065, 30212066, 30212067, 30212068, 30212069, 30212070, 30212071, 30212072, 30212073, 30212074, 30212075, 30212076, 30212077, 30212078, 30212079, 30212080, 30212081, 30212082, 30212083, 30212084, 30212085, 30212086, 30212087, 30212088, 30212089, 30212090, 30212091, 30212092, 30212093, 30212094, 30212095, 30212096, 30212097, 30212098, 30212099, 30222001, 30222002, 30222003, 30222004, 30222005, 30222006, 30222007, 30222008, 30222009, 30222010, 30222011, 30222012, 30222013, 30222014, 30222015, 30222016, 30222017, 30222018, 30222019, 30222020, 30222021, 30222022, 30222023, 30222024, 30222025, 30222026, 30222027, 30222028, 30222029, 30222030, 30222031, 30222032, 30222033, 30222034, 30222035, 30222036, 30222037, 30222038, 30222039, 30222040, 30222041, 30222042, 30222043, 30222044, 30222045, 30222046, 30222047, 30222048, 30222049, 30222050, 30222051, 30222052, 30222053, 30222054, 30222055, 30222056, 30222057, 30222058, 30222059, 30222060, 30222061, 30222062, 30222063, 30222064, 30222065, 30222066, 30222067, 30222068, 30222069, 30222070, 30222071, 30222072, 30222073, 30222074, 30222075, 30222076, 30222077, 30222078, 30222079, 30222080, 30222081, 30222082, 30222083, 30222084, 30222085, 30222086, 30222087, 30222088, 30222089, 30222090, 30222091, 30222092, 30222093, 30222094, 30222095, 30222096, 30222097, 30222098, 30222099, 30232001, 30232002, 30232003, 30232004, 30232005, 30232006, 30232007, 30232008, 30232009, 30232010, 30232011, 30232012, 30232013, 30232014, 30232015, 30232016, 30232017, 30232018, 30232019, 30232020, 30232021, 30232022, 30232023, 30232024, 30232025, 30232026, 30232027, 30232028, 30232029, 30232030, 30232031, 30232032, 30232033, 30232034, 30232035, 30232036, 30232037, 30232038, 30232039, 30232040, 30232041, 30232042, 30232043, 30232044, 30232045, 30232046, 30232047, 30232048, 30232049, 30232050, 30232051, 30232052, 30232053, 30232054, 30232055, 30232056, 30232057, 30232058, 30232059, 30232060, 30232061, 30232062, 30232063, 30232064, 30232065, 30232066, 30232067, 30232068, 30232069, 30232070, 30232071, 30232072, 30232073, 30232074, 30232075, 30232076, 30232077, 30232078, 30232079, 30232080, 30232081, 30232082, 30232083, 30232084, 30232085, 30232086, 30232087, 30232088, 30232089, 30232090, 30232091, 30232092, 30232093, 30232094, 30232095, 30232096, 30232097, 30232098, 30232099, 30242001, 30242002, 30242003, 30242004, 30242005, 30242006, 30242007, 30242008, 30242009, 30242010, 30242011, 30242012, 30242013, 30242014, 30242015, 30242016, 30242017, 30242018, 30242019, 30242020, 30242021, 30242022, 30242023, 30242024, 30242025, 30242026, 30242027, 30242028, 30242029, 30242030, 30242031, 30242032, 30242033, 30242034, 30242035, 30242036, 30242037, 30242038, 30242039, 30242040, 30242041, 30242042, 30242043, 30242044, 30242045, 30242046, 30242047, 30242048, 30242049, 30242050, 30242051, 30242052, 30242053, 30242054, 30242055, 30242056, 30242057, 30242058, 30242059, 30242060, 30242061, 30242062, 30242063, 30242064, 30242065, 30242066, 30242067, 30242068, 30242069, 30242070, 30242071, 30242072, 30242073, 30242074, 30242075, 30242076, 30242077, 30242078, 30242079, 30242080, 30242081, 30242082, 30242083, 30242084, 30242085, 30242086, 30242087, 30242088, 30242089, 30242090, 30242091, 30242092, 30242093, 30242094, 30242095, 30242096, 30242097, 30242098, 30242099, 30252001, 30252002, 30252003, 30252004, 30252005, 30252006, 30252007, 30252008, 30252009, 30252010, 30252011, 30252012, 30252013, 30252014, 30252015, 30252016, 30252017, 30252018, 30252019, 30252020, 30252021, 30252022, 30252023, 30252024, 30252025, 30252026, 30252027, 30252028, 30252029, 30252030, 30252031, 30252032, 30252033, 30252034, 30252035, 30252036, 30252037, 30252038, 30252039, 30252040, 30252041, 30252042, 30252043, 30252044, 30252045, 30252046, 30252047, 30252048, 30252049, 30252050, 30252051, 30252052, 30252053, 30252054, 30252055, 30252056, 30252057, 30252058, 30252059, 30252060, 30252061, 30252062, 30252063, 30252064, 30252065, 30252066, 30252067, 30252068, 30252069, 30252070, 30252071, 30252072, 30252073, 30252074, 30252075, 30252076, 30252077, 30252078, 30252079, 30252080, 30252081, 30252082, 30252083, 30252084, 30252085, 30252086, 30252087, 30252088, 30252089, 30252090, 30252091, 30252092, 30252093, 30252094, 30252095, 30252096, 30252097, 30252098, 30252099, 30312001, 30312002, 30312003, 30312004, 30312005, 30312006, 30312007, 30312008, 30312009, 30312010, 30312011, 30312012, 30312013, 30312014, 30312015, 30312016, 30312017, 30312018, 30312019, 30312020, 30312021, 30312022, 30312023, 30312024, 30312025, 30312026, 30312027, 30312028, 30312029, 30312030, 30312031, 30312032, 30312033, 30312034, 30312035, 30312036, 30312037, 30312038, 30312039, 30312040, 30312041, 30312042, 30312043, 30312044, 30312045, 30312046, 30312047, 30312048, 30312049, 30312050, 30312051, 30312052, 30312053, 30312054, 30312055, 30312056, 30312057, 30312058, 30312059, 30312060, 30312061, 30312062, 30312063, 30312064, 30312065, 30312066, 30312067, 30312068, 30312069, 30312070, 30312071, 30312072, 30312073, 30312074, 30312075, 30312076, 30312077, 30312078, 30312079, 30312080, 30312081, 30312082, 30312083, 30312084, 30312085, 30312086, 30312087, 30312088, 30312089, 30312090, 30312091, 30312092, 30312093, 30312094, 30312095, 30312096, 30312097, 30312098, 30312099, 30322001, 30322002, 30322003, 30322004, 30322005, 30322006, 30322007, 30322008, 30322009, 30322010, 30322011, 30322012, 30322013, 30322014, 30322015, 30322016, 30322017, 30322018, 30322019, 30322020, 30322021, 30322022, 30322023, 30322024, 30322025, 30322026, 30322027, 30322028, 30322029, 30322030, 30322031, 30322032, 30322033, 30322034, 30322035, 30322036, 30322037, 30322038, 30322039, 30322040, 30322041, 30322042, 30322043, 30322044, 30322045, 30322046, 30322047, 30322048, 30322049, 30322050, 30322051, 30322052, 30322053, 30322054, 30322055, 30322056, 30322057, 30322058, 30322059, 30322060, 30322061, 30322062, 30322063, 30322064, 30322065, 30322066, 30322067, 30322068, 30322069, 30322070, 30322071, 30322072, 30322073, 30322074, 30322075, 30322076, 30322077, 30322078, 30322079, 30322080, 30322081, 30322082, 30322083, 30322084, 30322085, 30322086, 30322087, 30322088, 30322089, 30322090, 30322091, 30322092, 30322093, 30322094, 30322095, 30322096, 30322097, 30322098, 30322099, 30332001, 30332002, 30332003, 30332004, 30332005, 30332006, 30332007, 30332008, 30332009, 30332010, 30332011, 30332012, 30332013, 30332014, 30332015, 30332016, 30332017, 30332018, 30332019, 30332020, 30332021, 30332022, 30332023, 30332024, 30332025, 30332026, 30332027, 30332028, 30332029, 30332030, 30332031, 30332032, 30332033, 30332034, 30332035, 30332036, 30332037, 30332038, 30332039, 30332040, 30332041, 30332042, 30332043, 30332044, 30332045, 30332046, 30332047, 30332048, 30332049, 30332050, 30332051, 30332052, 30332053, 30332054, 30332055, 30332056, 30332057, 30332058, 30332059, 30332060, 30332061, 30332062, 30332063, 30332064, 30332065, 30332066, 30332067, 30332068, 30332069, 30332070, 30332071, 30332072, 30332073, 30332074, 30332075, 30332076, 30332077, 30332078, 30332079, 30332080, 30332081, 30332082, 30332083, 30332084, 30332085, 30332086, 30332087, 30332088, 30332089, 30332090, 30332091, 30332092, 30332093, 30332094, 30332095, 30332096, 30332097, 30332098, 30332099, 30342001, 30342002, 30342003, 30342004, 30342005, 30342006, 30342007, 30342008, 30342009, 30342010, 30342011, 30342012, 30342013, 30342014, 30342015, 30342016, 30342017, 30342018, 30342019, 30342020, 30342021, 30342022, 30342023, 30342024, 30342025, 30342026, 30342027, 30342028, 30342029, 30342030, 30342031, 30342032, 30342033, 30342034, 30342035, 30342036, 30342037, 30342038, 30342039, 30342040, 30342041, 30342042, 30342043, 30342044, 30342045, 30342046, 30342047, 30342048, 30342049, 30342050, 30342051, 30342052, 30342053, 30342054, 30342055, 30342056, 30342057, 30342058, 30342059, 30342060, 30342061, 30342062, 30342063, 30342064, 30342065, 30342066, 30342067, 30342068, 30342069, 30342070, 30342071, 30342072, 30342073, 30342074, 30342075, 30342076, 30342077, 30342078, 30342079, 30342080, 30342081, 30342082, 30342083, 30342084, 30342085, 30342086, 30342087, 30342088, 30342089, 30342090, 30342091, 30342092, 30342093, 30342094, 30342095, 30342096, 30342097, 30342098, 30342099, 30352001, 30352002, 30352003, 30352004, 30352005, 30352006, 30352007, 30352008, 30352009, 30352010, 30352011, 30352012, 30352013, 30352014, 30352015, 30352016, 30352017, 30352018, 30352019, 30352020, 30352021, 30352022, 30352023, 30352024, 30352025, 30352026, 30352027, 30352028, 30352029, 30352030, 30352031, 30352032, 30352033, 30352034, 30352035, 30352036, 30352037, 30352038, 30352039, 30352040, 30352041, 30352042, 30352043, 30352044, 30352045, 30352046, 30352047, 30352048, 30352049, 30352050, 30352051, 30352052, 30352053, 30352054, 30352055, 30352056, 30352057, 30352058, 30352059, 30352060, 30352061, 30352062, 30352063, 30352064, 30352065, 30352066, 30352067, 30352068, 30352069, 30352070, 30352071, 30352072, 30352073, 30352074, 30352075, 30352076, 30352077, 30352078, 30352079, 30352080, 30352081, 30352082, 30352083, 30352084, 30352085, 30352086, 30352087, 30352088, 30352089, 30352090, 30352091, 30352092, 30352093, 30352094, 30352095, 30352096, 30352097, 30352098, 30352099, 30412001, 30412002, 30412003, 30412004, 30412005, 30412006, 30412007, 30412008, 30412009, 30412010, 30412011, 30412012, 30412013, 30412014, 30412015, 30412016, 30412017, 30412018, 30412019, 30412020, 30412021, 30412022, 30412023, 30412024, 30412025, 30412026, 30412027, 30412028, 30412029, 30412030, 30412031, 30412032, 30412033, 30412034, 30412035, 30412036, 30412037, 30412038, 30412039, 30412040, 30412041, 30412042, 30412043, 30412044, 30412045, 30412046, 30412047, 30412048, 30412049, 30412050, 30412051, 30412052, 30412053, 30412054, 30412055, 30412056, 30412057, 30412058, 30412059, 30412060, 30412061, 30412062, 30412063, 30412064, 30412065, 30412066, 30412067, 30412068, 30412069, 30412070, 30412071, 30412072, 30412073, 30412074, 30412075, 30412076, 30412077, 30412078, 30412079, 30412080, 30412081, 30412082, 30412083, 30412084, 30412085, 30412086, 30412087, 30412088, 30412089, 30412090, 30412091, 30412092, 30412093, 30412094, 30412095, 30412096, 30412097, 30412098, 30412099, 30422001, 30422002, 30422003, 30422004, 30422005, 30422006, 30422007, 30422008, 30422009, 30422010, 30422011, 30422012, 30422013, 30422014, 30422015, 30422016, 30422017, 30422018, 30422019, 30422020, 30422021, 30422022, 30422023, 30422024, 30422025, 30422026, 30422027, 30422028, 30422029, 30422030, 30422031, 30422032, 30422033, 30422034, 30422035, 30422036, 30422037, 30422038, 30422039, 30422040, 30422041, 30422042, 30422043, 30422044, 30422045, 30422046, 30422047, 30422048, 30422049, 30422050, 30422051, 30422052, 30422053, 30422054, 30422055, 30422056, 30422057, 30422058, 30422059, 30422060, 30422061, 30422062, 30422063, 30422064, 30422065, 30422066, 30422067, 30422068, 30422069, 30422070, 30422071, 30422072, 30422073, 30422074, 30422075, 30422076, 30422077, 30422078, 30422079, 30422080, 30422081, 30422082, 30422083, 30422084, 30422085, 30422086, 30422087, 30422088, 30422089, 30422090, 30422091, 30422092, 30422093, 30422094, 30422095, 30422096, 30422097, 30422098, 30422099, 30432001, 30432002, 30432003, 30432004, 30432005, 30432006, 30432007, 30432008, 30432009, 30432010, 30432011, 30432012, 30432013, 30432014, 30432015, 30432016, 30432017, 30432018, 30432019, 30432020, 30432021, 30432022, 30432023, 30432024, 30432025, 30432026, 30432027, 30432028, 30432029, 30432030, 30432031, 30432032, 30432033, 30432034, 30432035, 30432036, 30432037, 30432038, 30432039, 30432040, 30432041, 30432042, 30432043, 30432044, 30432045, 30432046, 30432047, 30432048, 30432049, 30432050, 30432051, 30432052, 30432053, 30432054, 30432055, 30432056, 30432057, 30432058, 30432059, 30432060, 30432061, 30432062, 30432063, 30432064, 30432065, 30432066, 30432067, 30432068, 30432069, 30432070, 30432071, 30432072, 30432073, 30432074, 30432075, 30432076, 30432077, 30432078, 30432079, 30432080, 30432081, 30432082, 30432083, 30432084, 30432085, 30432086, 30432087, 30432088, 30432089, 30432090, 30432091, 30432092, 30432093, 30432094, 30432095, 30432096, 30432097, 30432098, 30432099, 30442001, 30442002, 30442003, 30442004, 30442005, 30442006, 30442007, 30442008, 30442009, 30442010, 30442011, 30442012, 30442013, 30442014, 30442015, 30442016, 30442017, 30442018, 30442019, 30442020, 30442021, 30442022, 30442023, 30442024, 30442025, 30442026, 30442027, 30442028, 30442029, 30442030, 30442031, 30442032, 30442033, 30442034, 30442035, 30442036, 30442037, 30442038, 30442039, 30442040, 30442041, 30442042, 30442043, 30442044, 30442045, 30442046, 30442047, 30442048, 30442049, 30442050, 30442051, 30442052, 30442053, 30442054, 30442055, 30442056, 30442057, 30442058, 30442059, 30442060, 30442061, 30442062, 30442063, 30442064, 30442065, 30442066, 30442067, 30442068, 30442069, 30442070, 30442071, 30442072, 30442073, 30442074, 30442075, 30442076, 30442077, 30442078, 30442079, 30442080, 30442081, 30442082, 30442083, 30442084, 30442085, 30442086, 30442087, 30442088, 30442089, 30442090, 30442091, 30442092, 30442093, 30442094, 30442095, 30442096, 30442097, 30442098, 30442099, 30452001, 30452002, 30452003, 30452004, 30452005, 30452006, 30452007, 30452008, 30452009, 30452010, 30452011, 30452012, 30452013, 30452014, 30452015, 30452016, 30452017, 30452018, 30452019, 30452020, 30452021, 30452022, 30452023, 30452024, 30452025, 30452026, 30452027, 30452028, 30452029, 30452030, 30452031, 30452032, 30452033, 30452034, 30452035, 30452036, 30452037, 30452038, 30452039, 30452040, 30452041, 30452042, 30452043, 30452044, 30452045, 30452046, 30452047, 30452048, 30452049, 30452050, 30452051, 30452052, 30452053, 30452054, 30452055, 30452056, 30452057, 30452058, 30452059, 30452060, 30452061, 30452062, 30452063, 30452064, 30452065, 30452066, 30452067, 30452068, 30452069, 30452070, 30452071, 30452072, 30452073, 30452074, 30452075, 30452076, 30452077, 30452078, 30452079, 30452080, 30452081, 30452082, 30452083, 30452084, 30452085, 30452086, 30452087, 30452088, 30452089, 30452090, 30452091, 30452092, 30452093, 30452094, 30452095, 30452096, 30452097, 30452098, 30452099, 30502001, 30502002, 30502003, 30502004, 30502005, 30502006, 30502007, 30502008, 30502009, 30502010, 30502011, 30502012, 30502013, 30502014, 30502015, 30502016, 30502017, 30502018, 30502019, 30502020, 30502021, 30502022, 30502023, 30502024, 30502025, 30502026, 30502027, 30502028, 30502029, 30502030, 30502031, 30502032, 30502033, 30502034, 30502035, 30502036, 30502037, 30502038, 30502039, 30502040, 30502041, 30502042, 30502043, 30502044, 30502045, 30502046, 30502047, 30502048, 30502049, 30502050, 30502051, 30502052, 30502053, 30502054, 30502055, 30502056, 30502057, 30502058, 30502059, 30502060, 30502061, 30502062, 30502063, 30502064, 30502065, 30502066, 30502067, 30502068, 30502069, 30502070, 30502071, 30502072, 30502073, 30502074, 30502075, 30502076, 30502077, 30502078, 30502079, 30502080, 30502081, 30502082, 30502083, 30502084, 30502085, 30502086, 30502087, 30502088, 30502089, 30502090, 30502091, 30502092, 30502093, 30502094, 30502095, 30502096, 30502097, 30502098, 30502099, 30012001, 30012002, 30012003, 30012004, 30012005, 30012006, 30012007, 30012008, 30012009, 30012010, 30012011, 30012012, 30012013, 30012014, 30012015, 30012016, 30012017, 30012018, 30012019, 30012020, 30012021, 30012022, 30012023, 30012024, 30012025, 30012026, 30012027, 30012028, 30012029, 30012030, 30012031, 30012032, 30012033, 30012034, 30012035, 30012036, 30012037, 30012038, 30012039, 30012040, 30012041, 30012042, 30012043, 30012044, 30012045, 30012046, 30012047, 30012048, 30012049, 30012050, 30012051, 30012052, 30012053, 30012054, 30012055, 30012056, 30012057, 30012058, 30012059, 30012060, 30012061, 30012062, 30012063, 30012064, 30012065, 30012066, 30012067, 30012068, 30012069, 30012070, 30012071, 30012072, 30012073, 30012074, 30012075, 30012076, 30012077, 30012078, 30012079, 30012080, 30012081, 30012082, 30012083, 30012084, 30012085, 30012086, 30012087, 30012088, 30012089, 30012090, 30012091, 30012092, 30012093, 30012094, 30012095, 30012096, 30012097, 30012098, 30012099, 30022001, 30022002, 30022003, 30022004, 30022005, 30022006, 30022007, 30022008, 30022009, 30022010, 30022011, 30022012, 30022013, 30022014, 30022015, 30022016, 30022017, 30022018, 30022019, 30022020, 30022021, 30022022, 30022023, 30022024, 30022025, 30022026, 30022027, 30022028, 30022029, 30022030, 30022031, 30022032, 30022033, 30022034, 30022035, 30022036, 30022037, 30022038, 30022039, 30022040, 30022041, 30022042, 30022043, 30022044, 30022045, 30022046, 30022047, 30022048, 30022049, 30022050, 30022051, 30022052, 30022053, 30022054, 30022055, 30022056, 30022057, 30022058, 30022059, 30022060, 30022061, 30022062, 30022063, 30022064, 30022065, 30022066, 30022067, 30022068, 30022069, 30022070, 30022071, 30022072, 30022073, 30022074, 30022075, 30022076, 30022077, 30022078, 30022079, 30022080, 30022081, 30022082, 30022083, 30022084, 30022085, 30022086, 30022087, 30022088, 30022089, 30022090, 30022091, 30022092, 30022093, 30022094, 30022095, 30022096, 30022097, 30022098, 30022099, 30522001, 30522002, 30522003, 30522004, 30522005, 30522006, 30522007, 30522008, 30522009, 30522010, 30522011, 30522012, 30522013, 30522014, 30522015, 30522016, 30522017, 30522018, 30522019, 30522020, 30522021, 30522022, 30522023, 30522024, 30522025, 30522026, 30522027, 30522028, 30522029, 30522030, 30522031, 30522032, 30522033, 30522034, 30522035, 30522036, 30522037, 30522038, 30522039, 30522040, 30522041, 30522042, 30522043, 30522044, 30522045, 30522046, 30522047, 30522048, 30522049, 30522050, 30522051, 30522052, 30522053, 30522054, 30522055, 30522056, 30522057, 30522058, 30522059, 30522060, 30522061, 30522062, 30522063, 30522064, 30522065, 30522066, 30522067, 30522068, 30522069, 30522070, 30522071, 30522072, 30522073, 30522074, 30522075, 30522076, 30522077, 30522078, 30522079, 30522080, 30522081, 30522082, 30522083, 30522084, 30522085, 30522086, 30522087, 30522088, 30522089, 30522090, 30522091, 30522092, 30522093, 30522094, 30522095, 30522096, 30522097, 30522098, 30522099, 30532001, 30532002, 30532003, 30532004, 30532005, 30532006, 30532007, 30532008, 30532009, 30532010, 30532011, 30532012, 30532013, 30532014, 30532015, 30532016, 30532017, 30532018, 30532019, 30532020, 30532021, 30532022, 30532023, 30532024, 30532025, 30532026, 30532027, 30532028, 30532029, 30532030, 30532031, 30532032, 30532033, 30532034, 30532035, 30532036, 30532037, 30532038, 30532039, 30532040, 30532041, 30532042, 30532043, 30532044, 30532045, 30532046, 30532047, 30532048, 30532049, 30532050, 30532051, 30532052, 30532053, 30532054, 30532055, 30532056, 30532057, 30532058, 30532059, 30532060, 30532061, 30532062, 30532063, 30532064, 30532065, 30532066, 30532067, 30532068, 30532069, 30532070, 30532071, 30532072, 30532073, 30532074, 30532075, 30532076, 30532077, 30532078, 30532079, 30532080, 30532081, 30532082, 30532083, 30532084, 30532085, 30532086, 30532087, 30532088, 30532089, 30532090, 30532091, 30532092, 30532093, 30532094, 30532095, 30532096, 30532097, 30532098, 30532099, 3061, 3062, 3060, 3070, 3080],"type":["integer","integer64","Integer","Integer64"]},
{"field":"FRT","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FRR","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"IL","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"AMB","isuq":False,"listvalues":[None, 'A1', 'B1', 'C1', 'D1', 'E1', 'F1', 'G1', 'H1', 'K1', 'L1', 'M1', 'N1', 'O1', 'P1', 'Q1', 'R1', 'S1', 'T1', 'U1', 'V1', 'Z1', 'A2', 'B2', 'C2', 'D2', 'E2', 'F2', 'G2', 'H2', 'K2', 'L2', 'M2', 'N2', 'O2', 'P2', 'Q2', 'R2', 'S2', 'T2', 'U2', 'V2', 'Z2', 'A3', 'B3', 'C3', 'D3', 'E3', 'F3', 'G3', 'H3', 'K3', 'L3', 'M3', 'N3', 'O3', 'P3', 'Q3', 'R3', 'S3', 'T3', 'U3', 'V3', 'Z3', 'A4', 'B4', 'C4', 'D4', 'E4', 'F4', 'G4', 'H4', 'K4', 'L4', 'M4', 'N4', 'O4', 'P4', 'Q4', 'R4', 'S4', 'T4', 'U4', 'V4', 'Z4'],"type":["string","text","String","Text"]},
{"field":"DISL","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FA","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FV","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"Ft","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FH0105","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FH0510","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FH0515","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FPGA","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FA0105","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FA0408","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FA0711","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"SPETTRI","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"CAT","isuq":False,"listvalues":[None,'A','B','C','D','E'],"type":["string","text","String","Text"]},
{"field":"LIVELLO","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]}]},

{"table":"isosub","geomtype":2,"topologycheck":False,"fields":[
{"field":"ID_isosub","isuq":True,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"Quota","isuq":False,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]}]},

{"table":"stab","geomtype":3,"topologycheck":["gap","inters"],"fields":[
{"field":"ID_z","isuq":True,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"Tipo_z","isuq":False,"listvalues":[1011, 1012, 1021, 1022, 1031, 1032, 1041, 1042, 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020, 2021, 2022, 2023, 2024, 2025, 2026, 2027, 2028, 2029, 2030, 2031, 2032, 2033, 2034, 2035, 2036, 2037, 2038, 2039, 2040, 2041, 2042, 2043, 2044, 2045, 2046, 2047, 2048, 2049, 2050, 2051, 2052, 2053, 2054, 2055, 2056, 2057, 2058, 2059, 2060, 2061, 2062, 2063, 2064, 2065, 2066, 2067, 2068, 2069, 2070, 2071, 2072, 2073, 2074, 2075, 2076, 2077, 2078, 2079, 2080, 2081, 2082, 2083, 2084, 2085, 2086, 2087, 2088, 2089, 2090, 2091, 2092, 2093, 2094, 2095, 2096, 2097, 2098, 2099],"type":["integer","integer64","Integer","Integer64"]},
{"field":"FA","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FV","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"Ft","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FH0105","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FH0510","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FH0515","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FPGA","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FA0105","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FA0408","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"FA0711","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"SPETTRI","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"CAT","isuq":False,"listvalues":[None,'A','B','C','D','E'],"type":["string","text","String","Text"]},
{"field":"LIVELLO","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]}]}

],

"Indagini":[

{"table":"Ind_ln","geomtype":2,"topologycheck":False,"fields":[
{"field":"ID_SLN","isuq":True,"listvalues":False,"type":["string","text","String","Text"]}]},

{"table":"Ind_pu","geomtype":1,"topologycheck":False,"fields":[
{"field":"ID_SPU","isuq":True,"listvalues":False,"type":["string","text","String","Text"]}]}

],

"CdI_Tabelle":[

{"table":"sito_lineare","geomtype":0,"topologycheck":False,"fields":[
{"field":"pkey_sln","isuq":True,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"ubicazione_prov","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"ubicazione_com","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"ID_SLN","isuq":True,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"Acoord_X","isuq":False,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"Acoord_Y","isuq":False,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"Bcoord_X","isuq":False,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"Bcoord_Y","isuq":False,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"mod_identcoord","isuq":False,"listvalues":['CTR005', 'CTR010', 'IGM025', 'IGM050', 'IGM100', 'ALTCAR', 'GPS', 'ALTRO'],"type":["string","text","String","Text"]},
{"field":"desc_modcoord","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"Aquota","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"Bquota","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"data_sito","isuq":False,"listvalues":False,"type":["string","date","text","String","Date","Text"]},
{"field":"note_sito","isuq":False,"listvalues":False,"type":["string","text","String","Text"]}]},

{"table":"sito_puntuale","geomtype":0,"topologycheck":False,"fields":[
{"field":"pkey_spu","isuq":True,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"ubicazione_prov","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"ubicazione_com","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"ID_SPU","isuq":True,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"indirizzo","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"coord_X","isuq":False,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"coord_Y","isuq":False,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"mod_identcoord","isuq":False,"listvalues":['CTR005', 'CTR010', 'IGM025', 'IGM050', 'IGM100', 'ALTCAR', 'GPS', 'ALTRO'],"type":["string","text","String","Text"]},
{"field":"desc_modcoord","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"quota_slm","isuq":False,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"modo_quota","isuq":False,"listvalues":['CTR005', 'CTR010', 'IGM025', 'IGM050', 'IGM100', 'ALTCAR', 'GPS', 'ALTIM', 'DTM', 'ALTRO'],"type":["string","text","String","Text"]},
{"field":"data_sito","isuq":False,"listvalues":False,"type":["string","date","text","String","Date","Text"]},
{"field":"note_sito","isuq":False,"listvalues":False,"type":["string","text","String","Text"]}]},

{"table":"indagini_puntuali","geomtype":0,"topologycheck":False,"fields":[
{"field":"pkey_spu","isuq":False,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"pkey_indpu","isuq":True,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"classe_ind","isuq":False,"listvalues":['GL', 'GS', 'GG', 'IG', 'GE', 'GF', 'EL'],"type":["string","text","String","Text"]},
{"field":"tipo_ind","isuq":False,"listvalues":['SM', 'ED', 'TD', 'CD', 'CU', 'UU', 'ELL', 'CR', 'BE', 'TSC', 'TTC', 'TC', 'CPT', 'CPTE', 'CPTU', 'SPT', 'DMT', 'VT', 'DS', 'DP', 'DN', 'DL', 'PP', 'PLT', 'AL', 'AIV', 'S', 'SS', 'SD', 'SDS', 'SC', 'SP', 'SI', 'PI', 'T', 'RGM', 'TP', 'GEO', 'PA', 'SP', 'LF', 'ST', 'PE', 'ERT', 'SDMT', 'SCPT', 'DH', 'CH', 'UH', 'HVSR', 'ACC', 'ESAC_SPAC', 'GM', 'AR', 'SL', 'SR', 'SMS'],"type":["string","text","String","Text"]},
{"field":"ID_INDPU","isuq":True,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"id_indpuex","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"arch_ex","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"note_ind","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"prof_top","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"prof_bot","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"spessore","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"quota_slm_top","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"quota_slm_bot","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"data_ind","isuq":False,"listvalues":False,"type":["string","date","text","String","Date","Text"]},
{"field":"doc_pag","isuq":False,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"doc_ind","isuq":False,"listvalues":False,"type":["string","text","String","Text"]}]},

{"table":"indagini_lineari","geomtype":0,"topologycheck":False,"fields":[
{"field":"pkey_sln","isuq":False,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"pkey_indln","isuq":True,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"classe_ind","isuq":False,"listvalues":['GG', 'GE', 'GF'],"type":["string","text","String","Text"]},
{"field":"tipo_ind","isuq":False,"listvalues":['STP', 'SGE', 'SEV', 'SEO', 'PR', 'ERT', 'SL', 'SR', 'RAD', 'MASW', 'SASW', 'REMI', 'FTAN'],"type":["string","text","String","Text"]},
{"field":"ID_INDLN","isuq":True,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"id_indlnex","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"arch_ex","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"note_indln","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"data_ind","isuq":False,"listvalues":False,"type":["string","date","text","String","Date","Text"]},
{"field":"doc_pag","isuq":False,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"doc_ind","isuq":False,"listvalues":False,"type":["string","text","String","Text"]}]},

{"table":"parametri_puntuali","geomtype":0,"topologycheck":False,"fields":[
{"field":"pkey_indpu","isuq":False,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"pkey_parpu","isuq":True,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"tipo_parpu","isuq":False,"listvalues":['LID', 'FP', 'FR', 'FS', 'FF', 'ACB', 'JV', 'ACO', 'FRA', 'ACS', 'FDS', 'SIG', 'CAM', 'DV', 'DR', 'RT', 'PS', 'PTM', 'PTL', 'PV', 'PT', 'PIA', 'LM', 'SPT', 'K', 'E1', 'FAG', 'C', 'E', 'G', 'IP', 'IS', 'L', 'II', 'AR', 'U', 'IL', 'W', 'CP', 'CU', 'GH', 'KC', 'F1', 'PTS', 'ACI', 'OC', 'T', 'KR', 'QC', 'VS', 'RHO', 'SA', 'VP', 'SG', 'KEQ', 'INC'],"type":["string","text","String","Text"]},
{"field":"ID_PARPU","isuq":True,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"prof_top","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"prof_bot","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"spessore","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"quota_slm_top","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"quota_slm_bot","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"valore","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"attend_mis","isuq":False,"listvalues":['1', '2', '3'],"type":["string","text","String","Text"]},
{"field":"tab_curve","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"note_par","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"data_par","isuq":False,"listvalues":False,"type":["string","date","text","String","Date","Text"]}]},

{"table":"parametri_lineari","geomtype":0,"topologycheck":False,"fields":[
{"field":"pkey_indln","isuq":False,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"pkey_parln","isuq":True,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"tipo_parln","isuq":False,"listvalues":['G', 'VS'],"type":["string","text","String","Text"]},
{"field":"ID_PARLN","isuq":True,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"prof_top","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"prof_bot","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"spessore","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"quota_slm_top","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"quota_slm_bot","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"valore","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"attend_mis","isuq":False,"listvalues":['1', '2', '3'],"type":["string","text","String","Text"]},
{"field":"note_par","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"data_par","isuq":False,"listvalues":False,"type":["string","date","text","String","Date","Text"]}]},

{"table":"curve","geomtype":0,"topologycheck":False,"fields":[
{"field":"pkey_curve","isuq":True,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"pkey_parpu","isuq":False,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"cond_curve","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"varx","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"vary","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]}]},

{"table":"metadati","geomtype":0,"topologycheck":False,"fields":[
{"field":"id_metadato","isuq":True,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"liv_gerarchico","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"resp_metadato_nome","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"resp_metadato_email","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"resp_metadato_sito","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"data_metadato","isuq":False,"listvalues":False,"type":["string","date","text","String","Date","Text"]},
{"field":"srs_dati","isuq":False,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"proprieta_dato_nome","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"proprieta_dato_email","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"proprieta_dato_sito","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"data_dato","isuq":False,"listvalues":False,"type":["string","date","text","String","Date","Text"]},
{"field":"desc_dato","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"formato","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"tipo_dato","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"contatto_dato_nome","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"contatto_dato_email","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"contatto_dato_sito","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"keywords","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"keywords_inspire","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"limitazione","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"vincoli_accesso","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"vincoli_fruibilita","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"vincoli_sicurezza","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"scala","isuq":False,"listvalues":False,"type":["integer","integer64","Integer","Integer64"]},
{"field":"categoria_iso","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"estensione_ovest","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"estensione_est","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"estensione_sud","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"estensione_nord","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"formato_dati","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"distributore_dato_nome","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"distributore_dato_telefono","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"distributore_dato_email","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"distributore_dato_sito","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"url_accesso_dato","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"funzione_accesso_dato","isuq":False,"listvalues":False,"type":["string","text","String","Text"]},
{"field":"precisione","isuq":False,"listvalues":False,"type":["real","double","Real","Double"]},
{"field":"genealogia","isuq":False,"listvalues":False,"type":["string","text","String","Text"]}]}

]}