# -*- coding: latin1 -*-
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import *

import sys, os, time
import resources

from uuiddialog import UuidDialog


class UuidPlugin:

    def __init__(self, iface, version):
        self.iface = iface
        self.canvas = self.iface.mapCanvas()
        self.version = version
        
        
    def initGui(self):
        self.action = QAction(QIcon(":/plugins/uuidgenerator/icons/uuid.png"), "Create a UUID", self.iface.mainWindow())
    
        QObject.connect(self.action, SIGNAL("triggered()"), self.run)
                   
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu("&UUID", self.action)


    def run(self):
        self.ctrl = UuidDialog(self.iface.mainWindow())
        self.ctrl.initGui()
        self.ctrl.show()        

        
   


    def unload(self):
        print "UUID: unload plugin."
        self.iface.removePluginMenu(self.action.tr("UUID"), self.action)
        self.iface.removeToolBarIcon(self.action)
        
