# -*- coding: utf-8 -*-
"""
/***************************************************************************
 uuidCreatorDialog
                                 A QGIS plugin
 Creator uuid - description
                             -------------------
        begin                : 2013-02-26
        copyright            : (C) 2013 by Bartłomiej Staroń
        email                : bartekstaron(@)gmail
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from uiCreater_GUI import Ui_Dialog
import uuid_utils
import locale
import uuid
from PyQt4.QtCore import QVariant
def calclateuuid(layer,field,prefiks,sufiks,UUID):
	ids = []
	caps = layer.dataProvider().capabilities()
	fieldIndex = layer.fieldNameIndex(field)
	layer.select(layer.pendingAllAttributesList())
	for feature in layer:
		ids.append(feature.id())
	for feature in ids:
                if UUID is 'UPPER':
                        NewValue = str(prefiks+str(uuid.uuid4()).upper()+sufiks)
                else:
                        NewValue = str(prefiks+str(uuid.uuid4())+sufiks)
		if caps & QgsVectorDataProvider.ChangeAttributeValues:
			attrs = {fieldIndex : QVariant(NewValue)}
			layer.dataProvider().changeAttributeValues({ feature : attrs })       
class uuidCreatorDialog(QDialog):
    def __init__(self,iface):
        QDialog.__init__(self)
        self.ui = Ui_Dialog()
        self.ui.setupUi(self)
        self.connect(self.ui.comboBoxVectorLayers, SIGNAL("currentIndexChanged(QString)"), self.update)
        self.ui.pushButtonCalculate.clicked.connect(self.accept)
        self.ui.pushButtonShow.clicked.connect(self.showUUID)

        self.iface = iface
        layers = uuid_utils.getLayerNames([QGis.Point, QGis.Line, QGis.Polygon])
        self.ui.comboBoxVectorLayers.addItems(layers)
    def update(self, inputLayer):
        self.ui.comboBoxField.clear()
        changedLayer = uuid_utils.getVectorLayerByName(inputLayer)
        changedField = uuid_utils.getFieldList(changedLayer)
        for i in changedField:
            self.ui.comboBoxField.addItem(unicode(changedField[i].name()))
	
    def accept(self):
        prefiks = str(self.ui.lineEditPrefiks.text())
        sufiks = str(self.ui.lineEditSufiks.text())
        if self.ui.checkBoxUpperLeters.isChecked():
                UUID_VALUE = 'UPPER'
        else:
                UUID_VALUE = 'NORMAL'
        if self.ui.comboBoxVectorLayers.currentText() == "":
            QMessageBox.information( self, self.tr( "UUID calculator" ), self.tr( "Empty layer..." ) )
        else:
            layer = uuid_utils.getVectorLayerByName( unicode( self.ui.comboBoxVectorLayers.currentText() ) )
            field = self.ui.comboBoxField.currentText()
            calclateuuid(layer,field,prefiks,sufiks,UUID_VALUE)
            QMessageBox.information( self, self.tr( "UUID calculator" ), self.tr("UUID calculated"))	
    def showUUID(self):
        prefiks = str(self.ui.lineEditPrefiks.text())
        sufiks = str(self.ui.lineEditSufiks.text())
        if self.ui.checkBoxUpperLeters.isChecked():
                UUID_VALUE = str(uuid.uuid4()).upper()
        else:
                UUID_VALUE = str(uuid.uuid4())
        uuidValue = str(prefiks+UUID_VALUE+sufiks)
        QMessageBox.information( self, self.tr( "UUID" ), self.tr(str(uuidValue)) )

