# Urban Sprawl Metrics Toolset

***Note:***
This plugin is an experimental extension for the existing [USM Toolset](https://gitlab.com/geometalab/usm_toolset/usm_calculator).
Changes have been made to the original code to allow for a faster calculation of the Weighted Urban Proliferation (WUP) metric, which is a measure of urban sprawl.
The si-raster calculation has been replaced with a more efficient approach that uses Python with the `Numba` library, which is faster than the original method that uses C++.

## Installation with local zip file

QGIS plugins are easily installed using the built-in plugin manager if the plugin is available from the QGIS plugins online repository. If required, you can also install a plugin from a local zip file as follows:

1. Open your QGIS application.
2. Click on the `Plugins` option in the Toolbar and from there open `Manage and install plugins...`
3. Use the option `Install from zip` and use the previously downloaded zip File.
4. The set of processing algorithms should now appear in the processing toolbox.

## Operating instructions

### Calculate Weighted Urban Proliferation

`Built-up area (Raster)`: The raster with the settlement area. For a more accurate calculation the settlement area should go beyond the area boundary.

`Reporting unit (Vector)`: The area for which the urban sprawl should be calculated.

`Identifier`: Identifier for the area.

`Inhabitants`: Amount of inhabitants in the area.

`Employees`: Amount of employees in the area.

`Share of settlement area`: Amount of habitable area.

`Output folder`: Where the results are saved to.


### Explore Weighted Urban Proliferation

`Reporting unit (Vector)`: The area for which the urban sprawl should be calculated.

`Urban dispersion (DIS)`: Value of the already calculated DIS value. The value can be calculated with the other tool.

`Settlement area`: Size of the settlement area.

`Inhabitants`: Amount of inhabitants in the area.

`Employees`: Amount of employees in the area.

`Share of settlement area`: Amount of habitable area.

`Output folder`: Where the results are saved.
