# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Urbantracer
                                 A QGIS plugin
 Urbantracer creates urbanized area polygon over a street map.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-12-12
        copyright            : (C) 2023 by Eunice Barbosa
        email                : e_kbb8@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Eunice Barbosa'
__date__ = '2023-12-12'
__copyright__ = '(C) 2023 by Eunice Barbosa'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterFeatureSink
import os
import inspect
from qgis.PyQt.QtGui import QIcon
import processing


class UrbantracerAlgorithm(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterVectorLayer('file_open', 'File Open', defaultValue=None))
        self.addParameter(QgsProcessingParameterNumber('intraurban_open_spaces_greater_than', 'Intra-urban Open Spaces Greater Than', type=QgsProcessingParameterNumber.Double, minValue=1, defaultValue=80000))
        self.addParameter(QgsProcessingParameterNumber('resolution', 'Resolution', type=QgsProcessingParameterNumber.Integer, minValue=1, defaultValue=80))
        self.addParameter(QgsProcessingParameterFeatureSink('UrbanizedArea', 'Urbanized area', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(8, model_feedback)
        results = {}
        outputs = {}

        # Rasterize (vector to raster)
        alg_params = {
            'BURN': 10,
            'DATA_TYPE': 5,  # Float32
            'EXTENT': parameters['file_open'],
            'EXTRA': '',
            'FIELD': '',
            'HEIGHT': parameters['resolution'],
            'INIT': None,
            'INPUT': parameters['file_open'],
            'INVERT': False,
            'NODATA': 0,
            'OPTIONS': '',
            'UNITS': 1,  # Georeferenced units
            'USE_Z': False,
            'WIDTH': parameters['resolution'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RasterizeVectorToRaster'] = processing.run('gdal:rasterize', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Fill NoData cells
        alg_params = {
            'BAND': 1,
            'FILL_VALUE': 1,
            'INPUT': outputs['RasterizeVectorToRaster']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FillNodataCells'] = processing.run('native:fillnodata', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # Polygonize (raster to vector)
        alg_params = {
            'BAND': 1,
            'EIGHT_CONNECTEDNESS': False,
            'EXTRA': '',
            'FIELD': 'DN',
            'INPUT': outputs['FillNodataCells']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['PolygonizeRasterToVector'] = processing.run('gdal:polygonize', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Field calculator
        alg_params = {
            'FIELD_LENGTH': 100,
            'FIELD_NAME': 'Area',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 0,  # Decimal (double)
            'FORMULA': ' $area ',
            'INPUT': outputs['PolygonizeRasterToVector']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculator'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

        # DN10
        alg_params = {
            'FIELD': 'DN',
            'INPUT': outputs['FieldCalculator']['OUTPUT'],
            'OPERATOR': 0,  # =
            'VALUE': '10',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Dn10'] = processing.run('native:extractbyattribute', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}

        # DN1
        alg_params = {
            'FIELD': 'DN',
            'INPUT': outputs['FieldCalculator']['OUTPUT'],
            'OPERATOR': 0,  # =
            'VALUE': '1',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Dn1'] = processing.run('native:extractbyattribute', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return {}

        # DN1AreaSmallerEmptyChoice
        alg_params = {
            'FIELD': 'area',
            'INPUT': outputs['Dn1']['OUTPUT'],
            'OPERATOR': 4,  # <
            'VALUE': parameters['intraurban_open_spaces_greater_than'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Dn1areasmalleremptychoice'] = processing.run('native:extractbyattribute', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(7)
        if feedback.isCanceled():
            return {}

        # Merge vector layers
        alg_params = {
            'CRS': None,
            'LAYERS': [outputs['Dn10']['OUTPUT'],outputs['Dn1areasmalleremptychoice']['OUTPUT']],
            'OUTPUT': parameters['UrbanizedArea']
        }
        outputs['MergeVectorLayers'] = processing.run('native:mergevectorlayers', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['UrbanizedArea'] = outputs['MergeVectorLayers']['OUTPUT']
        return results


        
    def icon(self):
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'icon.png')))
        return icon
        
    def name(self):
        return 'UrbantracerAlgorithm'

    def displayName(self):
        return 'UrbantracerAlgorithm'

    def group(self):
        return 'Urbantracer'

    def groupId(self):
        return 'Urbantracer'

    def createInstance(self):
        return UrbantracerAlgorithm()
