# -*- coding: utf-8 -*-
"""
/***************************************************************************
 UMap
                                 A QGIS plugin
 UMap
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-03-22
        git sha              : $Format:%H$
        copyright            : (C) 2024 by UMap
        email                : san@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtGui import QColor
from PyQt5.QtCore import Qt
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication,QTimer,QVariant,QRect
from qgis.PyQt.QtGui import QIcon,QKeyEvent,QFontMetrics
from PyQt5.QtWidgets import QMenu, QAction,QFileDialog,QMessageBox,QApplication,QToolBar, QComboBox
from qgis.core import QgsRasterPipe,QgsRasterFileWriter,QgsPoint,QgsMapLayer,QgsMapLayerType,QgsExpression,QgsApplication,QgsMessageLog, Qgis,QgsProcessingFeedback,QgsWkbTypes,Qgis,QgsVectorLayer,QgsVectorFileWriter, QgsFeatureRequest,QgsRasterLayer, QgsProject,QgsRectangle,QgsCoordinateTransform,QgsCoordinateTransformContext,QgsProcessingFeedback,QgsProcessingAlgorithm,QgsProcessingFeatureSourceDefinition,QgsFeature, QgsGeometry, QgsPointXY, QgsCoordinateReferenceSystem, QgsFields, QgsField, QgsSpatialIndex
from qgis.gui import QgsMapCanvas,QgsMapToolEmitPoint, QgsRubberBand,QgsMessageBar as QgsGuiMessageBar
from qgis.analysis import QgsNativeAlgorithms,QgsTinInterpolator,QgsInterpolator,QgsGridFileWriter,QgsRasterCalculator, QgsRasterCalculatorEntry
from qgis.gui import QgsMapTool,QgsGui

from qgis.utils import plugins, reloadPlugin, updateAvailablePlugins, unloadPlugin, loadPlugin, startPlugin
import datetime
import math
from qgis.PyQt.QtWidgets import  QTreeWidget, QTreeWidgetItem
# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .UMap_dialog import UMapDialog
import os.path
import processing
from osgeo import gdal,ogr
import numpy as np
import csv
import shutil
from pyproj import Proj, transform
import re
from osgeo import ogr
import time
import threading
import subprocess


class UMap:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'UMap_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&UMap')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('UMap', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = QgsApplication.qgisSettingsDirPath() + '/python/plugins/umap/UMap_Icon.PNG'
        self.add_action(
            icon_path,
            text=self.tr(u'UMap'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True
        

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&UMap'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""
        """# Check if the window is already opened
        if self.window_opened:
            
            # Bring the existing window to focus
            if self.dlg is not None:
                
                self.dlg.raise_()
            return"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = UMapDialog()

        self.dlg.showNormal()
        self.cancelled = False
        self.rectangle_map_tool = None
        self.ChartLimits_WGS84_path=None
        self.layer_type = None
        self.dlg.tlbtn_mapextent.clicked.connect(self.showMenu)
        self.load_layeras_submenu()
        #Popup frame
        self.dlg.frame_input.hide()
        self.dlg.btn_cancel.setVisible(False)
        self.dlg.groupBox_1.setToolTip("Please provide a vector file (polyline type) of the shoreline for the map compilation area.\nThe shoreline can be submitted as a file (Shapefile, GeoPackage, or GeoJSON), a service (WFS), or a map layer.")
        self.dlg.groupBox_2.setToolTip("Please provide a vector file (polyline type) of the topographic contours for the map compilation area.\nThe topographic contours can be submitted as a file (Shapefile, GeoPackage, or GeoJSON), a service (WFS), or a map layer.")
        self.dlg.groupBox_3.setToolTip("Please provide one or more digital bathymetric terrain model for the map compilation area.\nThe digital bathymetric terrain model can be submitted as a file (GeoTIFF, Shapefile, GeoPackage, or GeoJSON), a service (WCS), or a map layer.")
        self.dlg.groupBox_4.setToolTip("Please provide a vector file (polygon type) of the extent of the map compilation area.\nThe map extent can be submitted as the extent of the map canvas,\ndrawn directly on the canvas or calculated from a map layer.")
        self.dlg.textEdit_log.clear()
        self.dlg.lnEd_mapextent.clear()  
        self.dlg.lnEd_shoreline.clear() 
        self.dlg.lnEd_topographic.clear() 
        self.dlg.lnEd_bathy.clear()
        self.dlg.progressBar_2.setValue(0)
        self.dlg.btn_run.setVisible(True)
        self.dlg.btn_cancel.setVisible(False)
        self.dlg.btn_close.setEnabled(True)
        self.dlg.groupBox_4.mousePressEvent = self.on_map_clicked
        self.dlg.groupBox_1.mousePressEvent = self.on_shore_clicked
        self.dlg.groupBox_2.mousePressEvent = self.on_topo_clicked
        self.dlg.groupBox_3.mousePressEvent = self.on_digital_clicked

        self.dlg.lnEd_shoreline.mousePressEvent = self.on_shore_clicked
        self.dlg.lnEd_bathy.mousePressEvent = self.on_digital_clicked
        self.dlg.lnEd_topographic.mousePressEvent = self.on_topo_clicked
        self.dlg.lnEd_mapextent.mousePressEvent = self.on_mapextent_clicked

        self.dlg.tlbtn_shoreline.clicked.connect(self.on_Shorelinefile_changed)
        self.dlg.tlbtn_topographic.clicked.connect(self.on_Topographicfile_changed)
        self.dlg.tlbtn_bathymetric.clicked.connect(self.on_Bathymetricfile_changed)
        self.dlg.inputlayers_back.clicked.connect(self.back_to_mainframe)
        self.dlg.btn_AddFiles.clicked.connect(self.addBathymetricFiles)
        self.dlg.delete_selected_files.clicked.connect(self.deleteSelectedBathymetricFiles)
        self.dlg.btn_copylog.clicked.connect(self.copy_text_to_clipboard)
        self.dlg.btn_saveaslog.clicked.connect(self.saveas_logdata_to_file)
        self.dlg.btn_merOk.clicked.connect(self.bathy_checked_files)
        self.dlg.btn_close.clicked.connect(self.close_dialog)
        self.dlg.btn_run.clicked.connect(self.on_run_click)
        self.dlg.btn_cancel.clicked.connect(self.cancel_task)
        self.dlg.toolButton.clicked.connect(self.action_from_map_canvas)
        self.dlg.cmb_sounding_selection.currentIndexChanged.connect(self.on_combo_change)
        #self.dlg.cmb_sounding_selection.mousePressEvent=self.on_combo_click
        
        self.dlg.defaultHelpContent.setVisible(True)
        self.dlg.HelpMapExtent.setVisible(False)
        self.dlg.HelpShoreline.setVisible(False)
        self.dlg.HelpTopographicContours.setVisible(False)
        self.dlg.HelpDigitalBathy.setVisible(False)
        self.dlg.HelpSounding.setVisible(False)
        self.flush_old_directories()


        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
        self.dlg.tlbtn_shoreline.clicked.disconnect(self.on_Shorelinefile_changed)
        self.dlg.tlbtn_topographic.clicked.disconnect(self.on_Topographicfile_changed)
        self.dlg.tlbtn_bathymetric.clicked.disconnect(self.on_Bathymetricfile_changed)
        self.dlg.inputlayers_back.clicked.disconnect(self.back_to_mainframe)
        self.dlg.btn_AddFiles.clicked.disconnect(self.addBathymetricFiles)
        self.dlg.delete_selected_files.clicked.disconnect(self.deleteSelectedBathymetricFiles)
        self.dlg.btn_copylog.clicked.disconnect(self.copy_text_to_clipboard)
        self.dlg.btn_saveaslog.clicked.disconnect(self.saveas_logdata_to_file)
        self.dlg.btn_merOk.clicked.disconnect(self.bathy_checked_files)
        self.dlg.btn_close.clicked.disconnect(self.close_dialog)
        self.dlg.btn_run.clicked.disconnect(self.on_run_click)
        self.dlg.btn_cancel.clicked.disconnect(self.cancel_task)
        self.dlg.toolButton.clicked.disconnect(self.action_from_map_canvas)
        self.dlg.tlbtn_mapextent.clicked.disconnect(self.showMenu)
        self.dlg.cmb_sounding_selection.currentIndexChanged.disconnect(self.on_combo_change)
        # Set window_opened to True when the window is opened

    #Sounding selection Combobox selected change
    def on_combo_change(self):
        self.dlg.defaultHelpContent.setVisible(False)
        self.dlg.HelpMapExtent.setVisible(False)
        self.dlg.HelpShoreline.setVisible(False)
        self.dlg.HelpTopographicContours.setVisible(False)
        self.dlg.HelpDigitalBathy.setVisible(False)
        self.dlg.HelpSounding.setVisible(True)

    #Getting map extetns when button clicked
    def action_from_map_canvas(self):
        self.dlg.defaultHelpContent.setVisible(False)
        self.dlg.HelpMapExtent.setVisible(True)
        self.dlg.HelpShoreline.setVisible(False)
        self.dlg.HelpTopographicContours.setVisible(False)
        self.dlg.HelpDigitalBathy.setVisible(False)
        self.dlg.HelpSounding.setVisible(False)
        canvas = self.iface.mapCanvas()
        canvas_crs = canvas.mapSettings().destinationCrs()
        
         # Extract individual components of the extent
        x_min, y_min, x_max, y_max = canvas.extent().toRectF().getCoords()
        
        # Create a QgsRectangle using individual components
        layer_extent = QgsRectangle(x_min, y_min, x_max, y_max)
        self.map_extents_alert(layer_extent,canvas_crs,"")
        # Format the extent text
        extent_text = f"{layer_extent.xMinimum()},{layer_extent.xMaximum()},{layer_extent.yMinimum()},{layer_extent.yMaximum()}"

        # Set the text in the line edit
        self.dlg.tlbtn_mapextent.setText(extent_text)    

    #Run button click event
    def on_run_click(self):
            
        try:
            
            self.dlg.tabWidget.setCurrentIndex(1)           
            self.dlg.btn_cancel.setVisible(True)
            self.dlg.btn_run.setVisible(False)
            self.dlg.btn_close.setEnabled(False)
            QCoreApplication.processEvents()
            self.dlg.textEdit_log.clear()
            
            shorline_selected_file=self.dlg.lnEd_shoreline.text()            
            bathy_selected_file=self.dlg.lnEd_bathy.text()            
            extents_selected_file=self.dlg.lnEd_mapextent.text()
            
            str_timestamp_folder=None
            date_time = datetime.datetime.now()
            str_date_time = date_time.strftime("%d%m%Y%H%M%S")
            if not os.path.exists("C:\\Temp\\UMapProcessing"+str_date_time):
                
                os.makedirs("C:\\Temp\\UMapProcessing"+str_date_time)
                str_timestamp_folder="C:\\Temp\\UMapProcessing"+str_date_time
            if shorline_selected_file =="":
                self.show_alert_message("Please select  shoreline files")
                self.dlg.tabWidget.setCurrentIndex(0)
                self.dlg.btn_run.setVisible(True)
                self.dlg.btn_cancel.setVisible(False)
                self.dlg.btn_close.setEnabled(True)
                return
            else:
                if extents_selected_file !="":
                    self.append_log_message("==========Shoreline generation process initiated=========\n")
                    shoreline_with_depth=self.shoreline_with_depth(shorline_selected_file,str_timestamp_folder)
                    self.dlg.progressBar_2.setValue(2) 
                    shorline_clip=self.shoreline_clip_with_chartlimit(shoreline_with_depth,extents_selected_file,str_timestamp_folder)
                    self.dlg.progressBar_2.setValue(5) 
                    self.append_log_message("==========Shoreline generation process Completed=========\n")

                    self.append_log_message("==========Land areas generation process initiated=========\n")
                    split_chartlimit=self.split_chartlimits_with_shoreline_clip(shorline_clip,str_timestamp_folder)
                    self.dlg.progressBar_2.setValue(8)
                    merged_shorline_clip_split_chartlimit=self.merge_shorlineclip_with_splitchatlimits(shorline_clip,split_chartlimit,str_timestamp_folder)
                    self.dlg.progressBar_2.setValue(10) 
                    self.creating_land_area(merged_shorline_clip_split_chartlimit,str_timestamp_folder)
                    self.dlg.progressBar_2.setValue(15) 
                    self.append_log_message("==========Land areas generation process Completed=========\n")
                    self.remove_layer_by_name()
                    
            if bathy_selected_file:                
                
                if extents_selected_file !="":                    
                    shoreline_files=str_timestamp_folder + '\\shoreline_with_depth.shp'                    
                    self.reading_multiple_files(bathy_selected_file,extents_selected_file,shoreline_files,str_timestamp_folder) 
             
            self.load_layeras_submenu()
            text = self.dlg.textEdit_log.toPlainText()

            # Check if the text is empty
            if text.strip():  # Using strip() to remove any leading/trailing whitespace
                self.dlg.progressBar_2.setValue(100)            
                self.show_success_message("Processing completed successfully!")
                try:
                    file_path=str_timestamp_folder+"\\Log.txt"
                    # Retrieve the text from the QLineEdit widget
                    log_data = self.dlg.textEdit_log.toPlainText()
                    
                    # Write the text to the selected file
                    with open(file_path, 'w') as file:
                        file.write(log_data)
                except Exception as e:
                    print(e)
                self.delete_files_in_directory("C:\\Temp\\UMapService")
                self.canvas_zoom_to_complication(self.ChartLimits_WGS84_path)
                self.remove_layer_deptharea()
            
            else:
                self.show_alert_message("Please select file.")
                self.dlg.tabWidget.setCurrentIndex(0)
                self.dlg.btn_run.setVisible(True)
                self.dlg.btn_cancel.setVisible(False)
                self.dlg.btn_close.setEnabled(True)
                return
            
            if self.cancelled:
                print("run cancel")
                # Clean up any necessary resources
                return
            
        except Exception as e:            
            error=f"<font color='red'>Error: {e}</font>"
            self.append_log_message(error)
            return
    
    #Cancel buttion click event
    def cancel_task(self):
        """Slot for handling the cancel button click"""
        # Your existing code here
        #print("Cancel")
        self.cancelled = True
        self.dlg.progressBar_2.setValue(0)
        self.dlg.btn_run.setVisible(True)
        self.dlg.btn_cancel.setVisible(False)
        self.dlg.btn_close.setEnabled(True)
        

    def UMap_processing_two_different_bathymetricfiles(self,input_raster_files,str_timestamp_folder,input_shorline):
        lst_raster_point_files=[]
        extents=self.dlg.lnEd_mapextent.text()+"[EPSG:4326]"

        #Converting Shorline file  to point vertices
        #self.extracting_shorline_topoint(str_timestamp_folder,input_shorline)
        #self.dlg.progressBar_2.setValue(20)
        xyz_layer=None
        self.append_log_message("==========Survey areas generation process initiated=========\n")
        for file in input_raster_files:
            base_filename = os.path.splitext(os.path.basename(file.strip()))[1]
            
            if base_filename==".tif":
                lst_raster_point_files.append(self.processing_tifdata(file.strip(),str_timestamp_folder))                
                self.dlg.progressBar_2.setValue(25)
                
            if base_filename==".txt":
                #print("Testing",file)
                xyz_layer=self.processing_textdata(file.strip(),str_timestamp_folder)
                lst_raster_point_files.append(xyz_layer)
                self.dlg.progressBar_2.setValue(25)
        output_merged_layer=str_timestamp_folder+'\\survey_layer.shp'
        if lst_raster_point_files:
            
            
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:mergevectorlayers'
            parameters = {
                'LAYERS':lst_raster_point_files,
                'CRS':QgsCoordinateReferenceSystem('EPSG:4326'),
                'OUTPUT':output_merged_layer
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            
            self.append_log_message(f"Results: {result}\n\n")
            processing.run("native:createspatialindex", {'INPUT':output_merged_layer})
        
                        
        #Clipping the converted point file to chart extents 
        input_survey_layer_clip=self.survey_layer_clip(output_merged_layer,extents,str_timestamp_folder)  
        self.dlg.progressBar_2.setValue(30)   

        #Creating survey area 
        self.creating_survey_area(input_survey_layer_clip,str_timestamp_folder)
        self.dlg.progressBar_2.setValue(35)  
        self.append_log_message("==========Survey areas generation process Completed=========\n")  
        
        self.append_log_message("==========Depth areas generation process initiated=========\n")
        #Creating tin based on the input files    
        self.creating_tin(str_timestamp_folder,lst_raster_point_files,extents)
        self.dlg.progressBar_2.setValue(40)
        
        #Creating Depth areas
        self.generate_depth_areas(str_timestamp_folder,extents)
        self.dlg.progressBar_2.setValue(50)
        self.append_log_message("==========Depth areas generation process Completed=========\n")

        self.append_log_message("==========Bathymetric contours generation process initiated=========\n")
        #Creating contours  
        self.creating_contours(str_timestamp_folder,extents)
        self.dlg.progressBar_2.setValue(60)
        self.append_log_message("==========Bathymetric contours generation process Completed=========\n")

        self.append_log_message("==========No Data areas generation process initiated=========\n")
        #Generating "No Data Areas"          
        self.no_data(str_timestamp_folder)
        self.dlg.progressBar_2.setValue(70)
        self.append_log_message("==========No Data areas generation process Completed=========\n")
       
        self.append_log_message("==========Soundings generation process initiated=========\n")
        #Creating grid layer using the selected sounding value
        input_grid_layer=self.sounding_selection(str_timestamp_folder,output_merged_layer)
        self.dlg.progressBar_2.setValue(80)

        #Filtering and join the attributes for the output resultant
        input_join_attributes_sound=self.sounding_section1(input_grid_layer,output_merged_layer,str_timestamp_folder)
        self.dlg.progressBar_2.setValue(85)

        #Creating shoals and deeps files using the output resultant
        input_deeps,input_shoals=self.sounding_section2(input_join_attributes_sound,str_timestamp_folder)
        self.dlg.progressBar_2.setValue(90)

        #Megring deeps and shoal and remove land areas while creating soundings
        self.sounding_section3(input_deeps,input_shoals,str_timestamp_folder)
        self.dlg.progressBar_2.setValue(95)
        self.append_log_message("==========Soundings generation process Completed=========\n")

        #Rearrange the layers in given order to map canvas
        self.rearrange_layers_in_order()

        #Removing the unwanted layers from map canvas
        self.remove_layer_by_name()
        
    #Converting Shorline file  to point vertices
    """def extracting_shorline_topoint(self,str_timestamp_folder,input_shorline):
        shorline_selected_file=input_shorline 
        #Extract the Shoreline layer to points type layerr
        output_shoreline_vertices=str_timestamp_folder+'\\shoreline_vertices.shp'
        start_time=None
        algorithm_name=None
        parameters=None
        feedback=None
        result=None
        end_time=None
        
        start_time = datetime.datetime.now()
        self.append_log_message(f"Algorithm started at: {start_time}")
        algorithm_name = 'native:extractvertices'
        parameters = {
            'INPUT':shorline_selected_file,
            'OUTPUT':output_shoreline_vertices
        }
        self.append_log_message(f"Algorithm: {algorithm_name} starting..")
        self.append_log_message(f"Input parameters: \n {parameters}")
        feedback = QgsProcessingFeedback()
        result = processing.run(algorithm_name, parameters, feedback=feedback)

        end_time = datetime.datetime.now()
        elapsed_time = end_time - start_time
        self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

        
        self.append_log_message(f"Results: {result}\n\n")    
        processing.run("native:createspatialindex", {'INPUT':output_shoreline_vertices})"""

    def field_exists(self,layer, field_name):
        """Check if a field with the given name exists in the layer."""
        existing_field_names = [field.name() for field in layer.fields()]
        return field_name in existing_field_names

    def field_does_not_exist(self,layer, field_name):
        """Check if a field with the given name does not exist in the layer."""
        return not self.field_exists(layer, field_name)

    def updating_long_lat_to_layer(self,layer_file_path,output_file_path):

        try:

            # Define longitude field name
            
            longitude_field = 'Long (DD)'

            # Define the expression to calculate longitude using the x-coordinate of the geometry
            expression = 'x($geometry)'

            # Define algorithm parameters
            algorithm_name = 'qgis:fieldcalculator'
            parameters = {
                'INPUT':layer_file_path ,  # Replace input_layer with the actual input layer variable
                'FIELD_NAME': longitude_field,
                'FIELD_TYPE': 0,  # Decimal number (real)
                'FIELD_LENGTH': 10,
                'FIELD_PRECISION': 10,
                'FORMULA': expression,
                'NEW_FIELD': True,  # Set to True to add a new field
                'OUTPUT': 'memory:'  # Output URI for temporary layer
            }

            # Run the algorithm to add a new field with longitude values to the input layer
            result = processing.run(algorithm_name, parameters)

            # Access the resulting temporary layer
            temp_layer = result['OUTPUT']

            # Define latitude field name
            latitude_field = 'Lat (DD)'

            # Define the expression to calculate latitude using the y-coordinate of the geometry
            expression = 'y($geometry)'

            # Define algorithm parameters
            algorithm_name = 'qgis:fieldcalculator'
            parameters = {
                'INPUT': temp_layer,  # Replace temp_layer with the actual temporary layer variable
                'FIELD_NAME': latitude_field,
                'FIELD_TYPE': 0,  # Decimal number (real)
                'FIELD_LENGTH': 10,
                'FIELD_PRECISION': 10,
                'FORMULA': expression,
                'NEW_FIELD': True,  # Set to True to add a new field
                'OUTPUT': 'memory:'  # Output URI for updated temporary layer
            }

            # Run the algorithm to add a new field with latitude values to the temporary layer
            result = processing.run(algorithm_name, parameters)

            # Access the resulting temporary layer with latitude values
            updated_temp_layer = result['OUTPUT']
            
            QgsVectorFileWriter.writeAsVectorFormat(updated_temp_layer, output_file_path, "UTF-8", updated_temp_layer.crs(), "ESRI Shapefile")

            return output_file_path
        except Exception as e:
            error=f"<font color='red'>Error: {e}</font>"
            self.append_log_message(error)
            return
    
    #This function is executed when "Run" button is clicked
    def reading_multiple_files(self,multiple_file_path,extents_selected_file,input_shorline,str_timestamp_folder):
        
        if multiple_file_path:            
            lst_extenstion_raster=['.tif','.TIF','.tiff','.TIFF','.shp']            
            raster_files=multiple_file_path.split(',')    
            #Processing in case of single file input        
            if len(raster_files)<2:                
                for file_path in raster_files:
                    base_filename = os.path.splitext(os.path.basename(file_path))[1]
                    if base_filename in lst_extenstion_raster:                        
                        self.create_contours_on_raster(file_path,extents_selected_file,str_timestamp_folder,input_shorline)
                    else:
                        self.create_contours_on_textfile(file_path,extents_selected_file,str_timestamp_folder,input_shorline)
            else:                
                if all(file == raster_files[0] for file in raster_files):                    
                    print("All selected files are the same.")
                else:
                    #Processing in case of multiple file input     
                    self.UMap_processing_two_different_bathymetricfiles(raster_files,str_timestamp_folder,input_shorline)

    #Function executed in case of raster file input               
    def create_contours_on_raster(self,input_layer,extents,str_timestamp_folder,input_shorline):
        extents=self.dlg.lnEd_mapextent.text()+"[EPSG:4326]"
        lst_tif_files=[]
        self.append_log_message("==========Survey areas generation process initiated=========\n") 
        #Processing in case of .tif file input
        lst_tif_files.append(self.processing_tifdata(input_layer,str_timestamp_folder))
        self.dlg.progressBar_2.setValue(20)

        #Converting Shorline file  to point vertices
        #self.extracting_shorline_topoint(str_timestamp_folder,input_shorline)
        #self.dlg.progressBar_2.setValue(23)

               
        #Clipping the converted point file to chart extents
        input_survey_layer_clip=self.survey_layer_clip(lst_tif_files[0],extents,str_timestamp_folder)  
        self.dlg.progressBar_2.setValue(28)   

        #Creating survey area 
        self.creating_survey_area(input_survey_layer_clip,str_timestamp_folder)
        self.dlg.progressBar_2.setValue(30) 
        self.append_log_message("==========Survey areas generation process Completed=========\n")    

        self.append_log_message("==========Depth areas generation process initiated=========\n")      
        #Creating tin based on the input files 
        self.creating_tin(str_timestamp_folder,lst_tif_files,extents)
        self.dlg.progressBar_2.setValue(40)
        
        #Creating Depth areas
        self.generate_depth_areas(str_timestamp_folder,extents)
        self.dlg.progressBar_2.setValue(50)
        self.append_log_message("==========Depth areas generation process Completed=========\n")

        self.append_log_message("==========Bathymetric contours generation process initiated=========\n")
        #Creating contours  
        self.creating_contours(str_timestamp_folder,extents)
        self.dlg.progressBar_2.setValue(60)  
        self.append_log_message("==========Bathymetric contours generation process Completed=========\n")

        self.append_log_message("==========No Data areas generation process initiated=========\n")
        #Generating "No Data Areas"        
        self.no_data(str_timestamp_folder)
        self.dlg.progressBar_2.setValue(70)
        self.append_log_message("==========No Data areas generation process Completed=========\n")
      
        self.append_log_message("==========Soundings generation process initiated=========\n")
        #Creating grid layer using the selected sounding value
        input_grid_layer=self.sounding_selection(str_timestamp_folder,lst_tif_files[0])
        self.dlg.progressBar_2.setValue(75) 


        #Filtering and join the attributes for the output resultant
        input_join_attributes_sound=self.sounding_section1(input_grid_layer,lst_tif_files[0],str_timestamp_folder)
        self.dlg.progressBar_2.setValue(80) 

        #Creating shoals and deeps files using the output resultant
        input_deeps,input_shoals=self.sounding_section2(input_join_attributes_sound,str_timestamp_folder)
        self.dlg.progressBar_2.setValue(85) 

        #Megring deeps and shoal and remove land areas while creating soundings
        self.sounding_section3(input_deeps,input_shoals,str_timestamp_folder)
        self.dlg.progressBar_2.setValue(90)
        self.append_log_message("==========Soundings generation process Completed=========\n")
        
        #Rearrange the layers in given order to map canvas
        self.rearrange_layers_in_order()

        #Removing the unwanted layers from map canvas
        self.remove_layer_by_name()

    #Function executed in case of .txt file input   
    def create_contours_on_textfile(self,input_layer,extents,str_timestamp_folder,input_shorline):
        
        extents=self.dlg.lnEd_mapextent.text()+"[EPSG:4326]"
        shorline_selected_file=input_shorline
        lst_raster_point_files=[]
        """#Extract the Shoreline layer to points type layerr
        output_shoreline_vertices=str_timestamp_folder+'\\shoreline_vertices.shp'
        start_time=None
        algorithm_name=None
        parameters=None
        feedback=None
        result=None
        end_time=None
        
        start_time = datetime.datetime.now()
        self.append_log_message(f"Algorithm started at: {start_time}")
        algorithm_name = 'native:extractvertices'
        parameters = {
            'INPUT':shorline_selected_file,
            'OUTPUT':output_shoreline_vertices
        }
        self.append_log_message(f"Algorithm: {algorithm_name} starting..")
        self.append_log_message(f"Input parameters: \n {parameters}")
        feedback = QgsProcessingFeedback()
        result = processing.run(algorithm_name, parameters, feedback=feedback)

        end_time = datetime.datetime.now()
        elapsed_time = end_time - start_time
        self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

        
        self.append_log_message(f"Results: {result}\n\n")"""

        lst_raster_point_files.append(self.processing_textdata(input_layer,str_timestamp_folder))
        self.dlg.progressBar_2.setValue(20)  

        #input_survey_layer=self.merge_raster_layers(lst_raster_point_files[0],str_timestamp_folder)
        #self.dlg.progressBar_2.setValue(25) 
        self.append_log_message("==========Survey areas generation process initiated=========\n")
        #Clipping the converted point file to chart extents 
        input_survey_layer_clip=self.survey_layer_clip(lst_raster_point_files[0],extents,str_timestamp_folder)  
        self.dlg.progressBar_2.setValue(28)  

        #Creating survey area   
        self.creating_survey_area(input_survey_layer_clip,str_timestamp_folder)
        self.dlg.progressBar_2.setValue(30)   
        self.append_log_message("==========Survey areas generation process Completed=========\n")      
        
        self.append_log_message("==========Depth areas generation process initiated=========\n")
        #Creating tin based on the input files 
        self.creating_tin(str_timestamp_folder,lst_raster_point_files,extents)
        self.dlg.progressBar_2.setValue(40)
        
        #Creating Depth areas
        self.generate_depth_areas(str_timestamp_folder,extents)
        self.dlg.progressBar_2.setValue(50)
        self.append_log_message("==========Depth areas generation process Completed=========\n")

        self.append_log_message("==========Bathymetric contours generation process initiated=========\n")
        #Creating "Bathymetric contours"  
        self.creating_contours(str_timestamp_folder,extents)
        self.dlg.progressBar_2.setValue(60) 
        self.append_log_message("==========Bathymetric contours generation process Completed=========\n")

        self.append_log_message("==========No Data areas generation process initiated=========\n")
        #Generating "No Data Areas"       
        self.no_data(str_timestamp_folder)
        self.dlg.progressBar_2.setValue(70) 
        self.append_log_message("==========No Data areas generation process Completed=========\n")

        self.append_log_message("==========Soundings generation process initiated=========\n")
        sounding_input_layer_path=lst_raster_point_files[0]        
        #Creating grid layer using the selected sounding value
        input_grid_layer=self.sounding_selection(str_timestamp_folder,sounding_input_layer_path)
        self.dlg.progressBar_2.setValue(75) 

        #Filtering and join the attributes for the output resultant
        input_join_attributes_sound=self.sounding_section1(input_grid_layer,sounding_input_layer_path,str_timestamp_folder)
        self.dlg.progressBar_2.setValue(80) 

        #Creating shoals and deeps files using the output resultant
        input_deeps,input_shoals=self.sounding_section2(input_join_attributes_sound,str_timestamp_folder)
        self.dlg.progressBar_2.setValue(85) 

        #Megring deeps and shoal and remove land areas while creating soundings
        self.sounding_section3(input_deeps,input_shoals,str_timestamp_folder)
        self.dlg.progressBar_2.setValue(90)
        self.append_log_message("==========Soundings generation process Completed=========\n")
        #Rearrange the layers in given order to map canvas
        self.rearrange_layers_in_order()

        #Removing the unwanted layers from map canvas
        self.remove_layer_by_name()
                      

    #Processing in case of .tif file input
    def processing_tifdata(self,input_tif,str_timestamp_folder):
        
        try:
            
            #Inverting the "Depth (m)" data of input .tif
            tifpath = os.path.basename(input_tif)
            basename_without_ext = os.path.splitext(os.path.basename(input_tif))[0]

            output_dem=str_timestamp_folder+"\\"+basename_without_ext+"_invertor.tif"

            tin_layer = QgsRasterLayer(input_tif, 'tin_layer')
            tin_entry = QgsRasterCalculatorEntry()
            tin_entry.ref = 'tin_layer@1'  # Assuming the first band is used
            tin_entry.raster = tin_layer
            tin_entry.bandNumber = 1

            # Define the expression to compute the difference
            expression = '"tin_layer@1" * (-1)'
            print(expression)
            # Execute raster calculator
            calc = QgsRasterCalculator(expression, output_dem, 'GTiff', tin_layer.extent(), tin_layer.width(), tin_layer.height(), [tin_entry])
            calc.processCalculation()

            raster_layer = QgsRasterLayer(output_dem, "result")
            raster_crs = raster_layer.crs().authid()
            tifpath = os.path.basename(output_dem)

            #Reprojecting the .tif to WGS84
            covertedtif_4326_path=str_timestamp_folder+"\\4326_"+tifpath

            processing.run("gdal:warpreproject", {

                'INPUT':raster_layer,
                'SOURCE_CRS':QgsCoordinateReferenceSystem(raster_crs),
                'TARGET_CRS':QgsCoordinateReferenceSystem('EPSG:4326'),
                'RESAMPLING':0,
                'NODATA':None,
                'TARGET_RESOLUTION':None,
                'OPTIONS':'',
                'DATA_TYPE':0,
                'TARGET_EXTENT':None,
                'TARGET_EXTENT_CRS':None,
                'MULTITHREADING':False,
                'EXTRA':'',
                'OUTPUT':covertedtif_4326_path
                })
            
            
            #Converting tif pixels to points
            output_points_shapefile_path = str_timestamp_folder+'\\'+basename_without_ext+'_1.shp'    
            output_pixeltopoint_file=str_timestamp_folder+'\\'+basename_without_ext+'.shp'
                  

            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:pixelstopoints'
            parameters = {
                'INPUT_RASTER':covertedtif_4326_path.strip(),
                'RASTER_BAND':1,
                'FIELD_NAME':'Depth (m)',
                'OUTPUT':output_points_shapefile_path
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            
            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            # Log the algorithm results
            self.append_log_message(f"Results: {result}\n\n")
            processing.run("native:createspatialindex", {'INPUT':output_points_shapefile_path})

            #Adding Long,Lat attributes to converted point .shp file
            output_tif_pixeltopoint_file=self.updating_long_lat_to_layer(output_points_shapefile_path,output_pixeltopoint_file)
            
            
        except Exception as e:
            error=f"<font color='red'>Error: {e}</font>"
            self.append_log_message(error)
            return
        return output_tif_pixeltopoint_file
    
    #Processing in case of .txt file input
    def processing_textdata(self,input_text,str_timestamp_folder):
        try:
            base_filename = os.path.splitext(os.path.basename(input_text))[0]
            output_xyz=str_timestamp_folder+"\\"+base_filename+"_xyz.shp"
            xyz_layer = QgsVectorLayer("Point?crs=EPSG:4326", "XYZ Layer", "memory")
            provider = xyz_layer.dataProvider()
            #print(input_text)
            # Add fields (assuming x, y, and z as field names)
            fields = QgsFields()
            fields.append(QgsField("Long (DD)", QVariant.Double))
            fields.append(QgsField("Lat (DD)", QVariant.Double))
            fields.append(QgsField("Depth (m)", QVariant.Double))
            provider.addAttributes(fields)

            # Open the file and read XYZ data
            with open(input_text, 'r') as file:
                for line in file:
                    # Assuming space-separated values, you may need to adjust accordingly
                    values = line.strip().split()
                    if len(values) == 3:
                        x, y, z = map(float, values)
                        
                        # Create a feature
                        feature = QgsFeature(fields)
                        feature.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(x, y)))
                        feature.setAttribute("Long (DD)", x)
                        feature.setAttribute("Lat (DD)", y)
                        feature.setAttribute("Depth (m)", z)

                        # Add feature to the provider
                        provider.addFeature(feature)

            # Update the layer fields
            xyz_layer.updateFields()
            QgsVectorFileWriter.writeAsVectorFormat(xyz_layer, output_xyz, "UTF-8", xyz_layer.crs(), "ESRI Shapefile")
        except Exception as e:
            error=f"<font color='red'>Error: {e}</font>"
            self.append_log_message(error)
            return
        return output_xyz

    #Creating Depth areas
    def generate_depth_areas(self,str_timestamp_folder,extents):
        input_tin_invetor=str_timestamp_folder+'\\merged_ink_sdb_shor_tin.tif'
        input_datacoverage=str_timestamp_folder+'\\survey_area.shp'

        #Selected Depth contours smoothing value
        depth_contours_smoothing_type=self.dlg.cmb_contours_smooth.currentText()
        tin_resolution=None  
        depth_contours_smoothing= self.tin_resolution_value()    
        if depth_contours_smoothing_type=="Gentle":        
            tin_resolution=depth_contours_smoothing * 5
        elif depth_contours_smoothing_type=="Hard":        
            tin_resolution=depth_contours_smoothing * 10
        else:
            tin_resolution=depth_contours_smoothing
        
        if depth_contours_smoothing_type !="None":

            #Resasmpleing based on selected Depth contours smoothing value
            output_resample=str_timestamp_folder+"\\resample_merged_ink_sdb_shor_tin.tif"
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'grass7:r.resamp.bspline'
            parameters = {
                'input':input_tin_invetor,
                'mask':None,
                'method':1,
                'ew_step':tin_resolution,
                'ns_step':tin_resolution,
                'lambda':0.01,
                'memory':300,
                '-n':False,'-c':False,
                'output':output_resample,
                'grid':'TEMPORARY_OUTPUT',
                'GRASS_REGION_PARAMETER':None,
                'GRASS_REGION_CELLSIZE_PARAMETER':0,
                'GRASS_RASTER_FORMAT_OPT':'',
                'GRASS_RASTER_FORMAT_META':'',
                'GRASS_OUTPUT_TYPE_PARAMETER':0,
                'GRASS_VECTOR_DSCO':'',
                'GRASS_VECTOR_LCO':'',
                'GRASS_VECTOR_EXPORT_NOCAT':False
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")
            
            self.append_log_message(f"Results: {result}\n\n")
            

        """#Masking the resampled tin output to the datacoverage area
        output_clip_tininvertor_datacoverage=str_timestamp_folder+'\\clip_tininvertor_datacoverage.tif'
        start_time=None
        algorithm_name=None
        parameters=None
        feedback=None
        result=None
        end_time=None
        
        start_time = datetime.datetime.now()
        self.append_log_message(f"Algorithm started at: {start_time}")
        algorithm_name = 'gdal:cliprasterbymasklayer'
        parameters = {
            'INPUT':output_resample,
            'MASK':input_datacoverage,
            'SOURCE_CRS':None,
            'TARGET_CRS':None,
            'TARGET_EXTENT':None,
            'NODATA':None,
            'ALPHA_BAND':False,
            'CROP_TO_CUTLINE':True,
            'KEEP_RESOLUTION':False,
            'SET_RESOLUTION':False,
            'X_RESOLUTION':None,
            'Y_RESOLUTION':None,
            'MULTITHREADING':False,
            'OPTIONS':'',
            'DATA_TYPE':0,
            'EXTRA':'',
            'OUTPUT':output_clip_tininvertor_datacoverage
        }
        self.append_log_message(f"Algorithm: {algorithm_name} starting..")
        self.append_log_message(f"Input parameters: \n {parameters}")
        feedback = QgsProcessingFeedback()
        result = processing.run(algorithm_name, parameters, feedback=feedback)

        end_time = datetime.datetime.now()
        elapsed_time = end_time - start_time
        self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")
        
        self.append_log_message(f"Results: {result}\n\n")

        #Cliping the masked tin to the chart extents
        extents=self.dlg.lnEd_mapextent.text()+"[EPSG:4326]"
        output_clip_tininvertor_datacoverage_extent=str_timestamp_folder+'\\clip_tininvertor_datacoverage_extent.tif'
        processing.run("gdal:cliprasterbyextent", {
            'INPUT':output_clip_tininvertor_datacoverage,
            'PROJWIN':extents,
            'OVERCRS':False,
            'NODATA':None,
            'OPTIONS':'',
            'DATA_TYPE':0,
            'EXTRA':'',
            'OUTPUT':output_clip_tininvertor_datacoverage_extent})"""
        
        input_file=None
        if depth_contours_smoothing_type =="None":
            input_file=str_timestamp_folder+'\\merged_ink_sdb_shor_tin.tif'

        else:            
            input_file=str_timestamp_folder+"\\resample_merged_ink_sdb_shor_tin.tif"
        
        
        #Creating  depth areas of 1m interval on resultant tin 
        output_depth_area_1m=str_timestamp_folder+'\\depth_areas_1m.shp'
        start_time=None
        algorithm_name=None
        parameters=None
        feedback=None
        result=None
        end_time=None
        
        start_time = datetime.datetime.now()
        self.append_log_message(f"Algorithm started at: {start_time}")
        algorithm_name = 'gdal:contour_polygon'
        parameters = {
            'INPUT':input_file,
            'BAND':1,
            'INTERVAL':1,
            'CREATE_3D':False,            
            'IGNORE_NODATA':False,
            'NODATA':None,'OFFSET':0,'EXTRA':'',
            'FIELD_NAME_MIN':'min',
            'FIELD_NAME_MAX':'max',
            'OUTPUT':output_depth_area_1m
        }
        self.append_log_message(f"Algorithm: {algorithm_name} starting..")
        self.append_log_message(f"Input parameters: \n {parameters}")
        feedback = QgsProcessingFeedback()
        result = processing.run(algorithm_name, parameters, feedback=feedback)

        end_time = datetime.datetime.now()
        elapsed_time = end_time - start_time
        self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")        
        self.append_log_message(f"Results: {result}\n\n")

        #Cliping the output depth areas to the datacoverage area
        output_depth_areas_clip=str_timestamp_folder+'\\depth_areas_clip.shp'
        processing.run("native:clip", {
            'INPUT':output_depth_area_1m,
            'OVERLAY':input_datacoverage,
            'OUTPUT':output_depth_areas_clip})

        #Filtering depth areas based on the input ranges
        depth_areas_path=self.creating_depth_areas(output_depth_areas_clip,str_timestamp_folder)

        #Removing land areas from the output depth areas
        output_depth_areas=str_timestamp_folder+'\\depth_areas.shp'
        start_time=None
        algorithm_name=None
        parameters=None
        feedback=None
        result=None
        end_time=None
        
        start_time = datetime.datetime.now()
        self.append_log_message(f"Algorithm started at: {start_time}")
        algorithm_name = 'native:difference'
        parameters = {
            'INPUT':depth_areas_path,
            'OVERLAY':str_timestamp_folder+'\\shorline_clip_polygon.shp',
            'OUTPUT':output_depth_areas
        }
        self.append_log_message(f"Algorithm: {algorithm_name} starting..")
        self.append_log_message(f"Input parameters: \n {parameters}")
        feedback = QgsProcessingFeedback()
        result = processing.run(algorithm_name, parameters, feedback=feedback)

        end_time = datetime.datetime.now()
        elapsed_time = end_time - start_time
        self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")        
        self.append_log_message(f"Results: {result}\n\n")

        #Applying style to depth areas layer        
        style_file_path = QgsApplication.qgisSettingsDirPath() + "/python/plugins/umap/UMap_depth_areas_styles.qml"
        depth_area_lyrObj = QgsVectorLayer(f'{output_depth_areas}', 'Depth areas', 'ogr')   
        depth_area_lyrObj.loadNamedStyle(style_file_path)      

        #Add Depth area layer to map
        QgsProject.instance().addMapLayer(depth_area_lyrObj)
        
    #Creating contours    
    def creating_contours(self,str_timestamp_folder,extents): 
        try:
            depth_contours_smoothing_type=self.dlg.cmb_contours_smooth.currentText()
            input_file=None
            if depth_contours_smoothing_type =="None":
                input_file=str_timestamp_folder+'\\merged_ink_sdb_shor_tin.tif'

            else:            
                input_file=str_timestamp_folder+"\\resample_merged_ink_sdb_shor_tin.tif"
            #Generate 2mtr contours on the raster data
            output_mereged_2m_contour=str_timestamp_folder+'\\merged_2m_contour.shp'
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'gdal:contour'
            parameters = {
                'INPUT':input_file,
                'BAND':1,
                'INTERVAL':2,
                'FIELD_NAME':'ELEV',
                'CREATE_3D':False,
                'IGNORE_NODATA':False,
                'NODATA':None,
                'OFFSET':0,
                'EXTRA':'',
                'OUTPUT':output_mereged_2m_contour
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            
            self.append_log_message(f"Results: {result}\n\n")
            processing.run("native:createspatialindex", {'INPUT':output_mereged_2m_contour})
            
            #Generate 5mtr contours on the raster data
            output_mereged_5m_contour=str_timestamp_folder+'\\merged_5m_contour.shp'
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'gdal:contour'
            parameters = {
                'INPUT':input_file,
                'BAND':1,
                'INTERVAL':5,
                'FIELD_NAME':'ELEV',
                'CREATE_3D':False,
                'IGNORE_NODATA':False,
                'NODATA':None,
                'OFFSET':0,
                'EXTRA':'',
                'OUTPUT':output_mereged_5m_contour
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            
            self.append_log_message(f"Results: {result}\n\n")
            processing.run("native:createspatialindex", {'INPUT':output_mereged_5m_contour})
            

            #Excludes contours with intervals other than 0mtrs,2mts,10mtrs,20mtrs,30mtrs,50mtrs,100mtrs.
            output_filter_vector_layer_2m = str_timestamp_folder+'\\fcontourshp_2m.shp'
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:extractbyexpression'
            parameters = {
                'INPUT':output_mereged_2m_contour,
                'EXPRESSION':'ELEV IN(0,2,10,20,30,50,100)',
                'OUTPUT':output_filter_vector_layer_2m
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            
            self.append_log_message(f"Results: {result}\n\n")
            processing.run("native:createspatialindex", {'INPUT':output_filter_vector_layer_2m})
                
            
            #Excludes contours with intervals other than 5mtrs
            output_filter_vector_layer_5m = str_timestamp_folder+'\\fcontourshp_5m.shp'
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:extractbyexpression'
            parameters = {
                'INPUT':output_mereged_5m_contour,
                'EXPRESSION':'ELEV IN(5)',
                'OUTPUT':output_filter_vector_layer_5m
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            
            self.append_log_message(f"Results: {result}\n\n")
            processing.run("native:createspatialindex", {'INPUT':output_filter_vector_layer_5m})
                
            
            #Merged output of 2m_contour and 5m_contour
            output_filter_contour=str_timestamp_folder+'\\filter_contour.shp'
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:mergevectorlayers'
            parameters = {
                'LAYERS':[output_filter_vector_layer_2m,output_filter_vector_layer_5m],
                'CRS':QgsCoordinateReferenceSystem('EPSG:4326'),
                'OUTPUT':output_filter_contour
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            
            self.append_log_message(f"Results: {result}\n\n")
            processing.run("native:createspatialindex", {'INPUT':output_filter_contour})

            #Removing the land areas from the filter contours        
            output_diff_contour=str_timestamp_folder+'\\diff_contours.shp'
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:difference'
            parameters = {
                'INPUT':output_filter_contour,
                'OVERLAY':str_timestamp_folder+'\\shorline_clip_polygon.shp',
                'OUTPUT':output_diff_contour
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            
            self.append_log_message(f"Results: {result}\n\n")

            #Cliping resultant depth contours from the survey area
            output_survey_contours=str_timestamp_folder+'\\survey_contours.shp'
            processing.run("native:clip", {
                'INPUT':output_diff_contour,
                'OVERLAY':str_timestamp_folder+'\\survey_area.shp',
                'OUTPUT':output_survey_contours}
                )
            processing.run("native:createspatialindex", {'INPUT':output_survey_contours})

            #Applying the style to Bathymetric contours layer
            style_file_path = QgsApplication.qgisSettingsDirPath() + "/python/plugins/umap/UMap_bathymetric_contours_styles.qml"
            survey_contours_lyrObj = QgsVectorLayer(output_survey_contours, 'Bathymetric contours', 'ogr')
            survey_contours_lyrObj.loadNamedStyle(style_file_path) 

            #Adding the Bathymetric contours layer to map canvas
            QgsProject.instance().addMapLayer(survey_contours_lyrObj)
        except Exception as e:
            error=f"<font color='red'>Error: {e}</font>"
            self.append_log_message(error)
            return

    
    #Filtering depth areas based on the input ranges
    def creating_depth_areas(self,input_depth_file,str_timestamp_folder):
        
        input_layer = QgsVectorLayer(input_depth_file, 'deptharea', 'ogr')

        # Check if the layer was loaded successfully
        if not input_layer.isValid():
            print("Layer failed to load!")
            return

        # Add the layer to the QGIS project
        QgsProject.instance().addMapLayer(input_layer)
        
        # Get the source and target layers
        source_layer = QgsProject.instance().mapLayersByName('deptharea')[0]
        target_layer = QgsVectorLayer("Polygon?crs=EPSG:4326", "Contours_1m", "memory")
        provider = target_layer.dataProvider()
        fields = QgsFields()
        fields.append(QgsField('ID', QVariant.Int))
        fields.append(QgsField('min', QVariant.Int))
        fields.append(QgsField('max', QVariant.Int))
        provider.addAttributes(fields)
        target_layer.updateFields()
        expression_lst = [ "(\"min\"<=0 AND \"max\"<0) OR (\"min\"<0 AND \"max\"<=0) OR (\"min\"<0 AND \"max\"<0)","((\"min\" >= 0) AND (\"max\" <= 2 AND \"max\" > 0)) OR (\"min\"=0 AND \"max\"=0)","\"min\" >= 2 AND \"max\" <= 5","\"min\" >= 5 AND \"max\" <= 10","\"min\" >= 10 AND \"max\" <= 20","\"min\" >= 20 AND \"max\" <= 30","\"min\" >= 30 AND \"max\" <= 50","\"min\" >= 50 AND \"max\" <= 100"]
        
        # Check if both layers are valid
        if source_layer.isValid() :
            output_path = str_timestamp_folder+'\\depth_areas_filter.shp'
            i=1
            for expression in expression_lst:

                source_layer.selectByExpression(expression)
                
                # Get selected features from the source layer
                selected_features = source_layer.selectedFeatures()

                # Check if there are selected features
                if selected_features:
                    min_value,max_value=self.min_max_values(i)

                    # Create an empty list to hold the geometries of selected features
                    geometries = []

                    # Extract geometries from selected features
                    for feature in selected_features:
                        geometries.append(feature.geometry())

                    # Merge geometries into a single geometry
                    merged_geometry = QgsGeometry.unaryUnion(geometries)

                    # Create a new feature with the merged geometry
                    new_feature = QgsFeature()
                    new_feature.setGeometry(merged_geometry)
                    new_feature.setAttributes([i,min_value, max_value])  # Set attribute values for min and max

                    # Start editing the target layer
                    target_layer.startEditing()

                    # Add the new feature to the target layer
                    if target_layer.dataProvider().addFeature(new_feature):
                        # Commit changes if adding feature is successful
                        target_layer.commitChanges()
                    else:
                        # Rollback changes if adding feature fails
                        target_layer.rollBack()

                    # Refresh the target layer to reflect changes
                    target_layer.triggerRepaint()
                    
                    QgsVectorFileWriter.writeAsVectorFormat(target_layer, output_path, "UTF-8", target_layer.crs(), "ESRI Shapefile")
                    i=i+1

                else:
                    print("No selected features in the source layer.")
                    i=i+1
            return output_path    
        else:
            print("Invalid layers. Please check layer names.")

    #merging depth areas
    def min_max_values(self,i):
        
        if i==1:            
            min_val, max_val = -1, -2

        elif i==2:
            min_val, max_val = 0, 2
        elif i==3:
            min_val, max_val = 2, 5
        elif i==4:
            min_val, max_val = 5, 10
        elif i==5:
            min_val, max_val = 10, 20
        elif i==6:
            min_val, max_val = 20, 30
        elif i==7:
            min_val, max_val = 30, 50
        else:
            min_val, max_val = 50, 100

        return min_val, max_val
    
    #Generating "No Data Areas"  
    def no_data(self,str_timestamp_folder):
        try:
            
            output_merge_survey_land_areas=str_timestamp_folder+'\\merge_survey_land_areas.shp'
            #Merging of "Depth Areas" and "Land Areas"
            Output_shor_cont_poly=str_timestamp_folder+"\\merged_shor_cont_poly.shp"
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:mergevectorlayers'
            parameters = {
                'LAYERS':[str_timestamp_folder+'\\shorline_clip_polygon.shp',str_timestamp_folder+'\\depth_areas.shp'],
                'CRS':QgsCoordinateReferenceSystem('EPSG:4326'),
                'OUTPUT':output_merge_survey_land_areas
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            
            self.append_log_message(f"Results: {result}\n\n")
            processing.run("native:createspatialindex", {'INPUT':output_merge_survey_land_areas})

            #polygonizing the Chartlimits extentss
            output_chart_poly=str_timestamp_folder+'\\chart_poly.shp'
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:polygonize'
            parameters = {
                'INPUT':self.ChartLimits_WGS84_path,
                'KEEP_FIELDS':False,
                'OUTPUT':output_chart_poly
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            
            self.append_log_message(f"Results: {result}\n\n")
            processing.run("native:createspatialindex", {'INPUT':output_chart_poly})

            # Path to your .qml style file
            style_file_path = QgsApplication.qgisSettingsDirPath() + "/python/plugins/umap/UMap_chartbound_styles.qml"            
            chart_boundary_lyrObj = QgsVectorLayer(f'{output_chart_poly}', 'Chart Boundary', 'ogr')    
            chart_boundary_lyrObj.loadNamedStyle(style_file_path)     
            #QgsProject.instance().addMapLayer(chart_boundary_lyrObj)
            
            #Removing resultant merged output (Land areas and Depth areas) from chart boundary
            output_nodata_area=str_timestamp_folder+'\\nodata_area.shp'
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:difference'
            parameters = {
                'INPUT':output_chart_poly,
                'OVERLAY':output_merge_survey_land_areas,
                'OUTPUT':output_nodata_area
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            
            self.append_log_message(f"Results: {result}\n\n")
            processing.run("native:createspatialindex", {'INPUT':output_nodata_area})

            #Applying style to no data areas layer
            style_file_path = QgsApplication.qgisSettingsDirPath() + "/python/plugins/umap/UMap_nodata_styles.qml"            
            nodata_area_lyrObj = QgsVectorLayer(f'{output_nodata_area}', 'No Data areas', 'ogr')  
            nodata_area_lyrObj.loadNamedStyle(style_file_path) 

            #Adding "No Data areas" to map canvas      
            QgsProject.instance().addMapLayer(nodata_area_lyrObj)
        except Exception as e:
            error=f"<font color='red'>Error: {e}</font>"
            self.append_log_message(error)
            return

    #Deleting the 10 days old directories
    def flush_old_directories(self):
        try:
            retention_days=10
            directory="C:\\Temp"
            # Get the current timestamp
            current_time = datetime.datetime.now()

            # Iterate over directories in the given directory
            for dir_name in os.listdir(directory):
                #print(dir_name)
                if 'UMapProcessing' in dir_name:                 
                    dir_path = os.path.join(directory, dir_name)                
                    # Check if it's a directory
                    if os.path.isdir(dir_path):
                        # Get the directory's last modification time
                        mod_time =datetime.datetime.fromtimestamp(os.path.getmtime(dir_path))
                        #print("mod_time",mod_time)
                        #print("curnt_time",current_time)

                        # Calculate the age of the directory in days
                        age_days = (current_time - mod_time).days
                        #print(age_days)
                        # If the directory is older than retention_days, remove it
                        if age_days > retention_days:
                            try:
                                shutil.rmtree(dir_path)
                                print(f"Removed directory: {dir_path}")
                            except Exception as e:
                                print(f"Error removing directory: {dir_path} - {e}")
        except Exception as e:
            error=f"<font color='red'>Error: {e}</font>"
            self.append_log_message(error)
            return
    
    #Creating grid layer using the selected sounding value
    def sounding_selection(self,str_timestamp_folder,input_layer_path):
        try:

            sounding_selection=int(self.dlg.cmb_sounding_selection.currentText())
            
            file_path=self.ChartLimits_WGS84_path
            # Get the base filename without the extension
            base_filename = os.path.splitext(os.path.basename(file_path))[0]
            
            # Remove the ".shp" extension
            filename_without_extension = base_filename.replace('.shp', '')

            layer = QgsVectorLayer(file_path, filename_without_extension, "ogr")
            layer_extent = QgsRectangle(layer.extent())
            
            point_layer_path = input_layer_path
            point_layer = QgsVectorLayer(point_layer_path, 'point_layer', 'ogr')
            processing.run("native:createspatialindex", {'INPUT':point_layer_path})
            
            xmin=layer_extent.xMinimum()
            ymin=layer_extent.yMinimum()
            xmax=layer_extent.xMaximum()
            ymax =layer_extent.yMaximum()
            
            x_spacing = sounding_selection / (111.32 * 1000)
            y_spacing = sounding_selection / (111.32 * 1000)   # Spacing between grid lines

            # Create a memory layer to store the grid
            grid_layer = QgsVectorLayer("Polygon?crs=EPSG:4326", "grid", "memory")
            provider = grid_layer.dataProvider()

            # Define fields for the grid layer (optional)
            fields = QgsFields()
            fields.append(QgsField("ID", QVariant.Int))
            provider.addAttributes(fields)
            grid_layer.updateFields()

            # Create grid features
            grid_features = []

            # Iterate over the x and y coordinates to create grid lines
            x = xmin
            while x < xmax:
                y = ymin
                while y < ymax:
                    # Create a rectangular polygon representing a grid cell
                    points = [QgsPointXY(x, y),
                            QgsPointXY(x + x_spacing, y),
                            QgsPointXY(x + x_spacing, y + y_spacing),
                            QgsPointXY(x, y + y_spacing),
                            QgsPointXY(x, y)]  # Closing the polygon
                    grid_geometry = QgsGeometry.fromPolygonXY([points])
                    
                    grid_feature = QgsFeature()
                    grid_feature.setGeometry(grid_geometry)
                    grid_feature.setFields(fields)
                    grid_feature.setAttribute("ID", len(grid_features) + 1)
                    grid_features.append(grid_feature)
                    y += y_spacing
                x += x_spacing

            # Add grid features to the layer
            provider.addFeatures(grid_features)

            # Update extent
            grid_layer.updateExtents()

            # Add the grid layer to the map
            #QgsProject.instance().addMapLayer(grid_layer)


            # Define the output path
            output_path = str_timestamp_folder+"\\grid_layer.shp"

            # Write the grid layer to the specified output path
            QgsVectorFileWriter.writeAsVectorFormat(grid_layer, output_path, "UTF-8", grid_layer.crs(), "ESRI Shapefile")
            processing.run("native:createspatialindex", {'INPUT':output_path})
            return output_path
        except Exception as e:
            error=f"<font color='red'>Error: {e}</font>"
            self.append_log_message(error)
            return


    #Filtering and join the attributes for the output resultant 
    def sounding_section1(self,input_grid_layer,point_layer_path,str_timestamp_folder):

        try:
            output_filter_grid_layer=str_timestamp_folder+"\\filter_grid_layer.shp"
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:extractbylocation'
            parameters = {
                'INPUT':input_grid_layer,
                'PREDICATE':[0,6],
                'INTERSECT':point_layer_path,
                'OUTPUT':output_filter_grid_layer
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            
            self.append_log_message(f"Results: {result}\n\n")

            
            output_join_attributes_sound=str_timestamp_folder+"\\joinattri_grid_layer.shp"
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:joinattributesbylocation'
            parameters = {
                'INPUT':output_filter_grid_layer,
                'PREDICATE':[0,5],
                'JOIN':point_layer_path,
                'JOIN_FIELDS':[],
                'METHOD':0,
                'DISCARD_NONMATCHING':True,
                'PREFIX':'',
                'OUTPUT':output_join_attributes_sound
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            
            self.append_log_message(f"Results: {result}\n\n")
            return output_join_attributes_sound
        except Exception as e:
            error=f"<font color='red'>Error: {e}</font>"
            self.append_log_message(error)
            return
    
    #Creating shoals and deeps files using the output resultant
    def sounding_section2(self,input_join_attributes_sound,str_timestamp_folder):

        try:
        
            
            # Create a new memory layer to store the results
            result_layer = QgsVectorLayer("Point?crs=EPSG:4326", "Result Layer", "memory")
            result_layer.startEditing()

            # Add fields to store FID, longitude, latitude, and minimum depth
            result_layer.dataProvider().addAttributes([
                QgsField('FID', QVariant.Int),
                QgsField('Long (DD)', QVariant.Double),   # Longitude field
                QgsField('Lat (DD)', QVariant.Double),    # Latitude field
                QgsField('Depth (m)', QVariant.Double)    # Minimum Depth field
            ])
            result_layer.updateFields()

            result_layer_max = QgsVectorLayer("Point?crs=EPSG:4326", "Result Layer", "memory")
            result_layer_max.startEditing()

            # Add fields to store FID, longitude, latitude, and minimum depth
            result_layer_max.dataProvider().addAttributes([
                QgsField('FID', QVariant.Int),
                QgsField('Long (DD)', QVariant.Double),   # Longitude field
                QgsField('Lat (DD)', QVariant.Double),    # Latitude field
                QgsField('Depth (m)', QVariant.Double)    # Minimum Depth field
            ])
            result_layer_max.updateFields()

            Zonal_static_layer_path = input_join_attributes_sound
            zonal_static_layer = QgsVectorLayer(Zonal_static_layer_path, "Polygon Layer", "ogr")
            
            min_depth_info  = {}
            max_depth_info={}
            fid_min=None
            # Iterate over features to calculate min depth value for each FID
            min_depth_value = float('inf')
            long_value=float('inf')
            lat_value=float('inf')
            for feature in zonal_static_layer.getFeatures():
                fid = feature['ID']
                depth = feature['Depth (m)']
                lat = feature['Lat (DD)']
                lon = feature['Long (DD)']
                # If the fid is not in the dictionary or the current depth is less than the stored depth
                if fid not in min_depth_info or depth < min_depth_info[fid]['depth']:
                    # Update the minimum depth for the fid
                    min_depth_info[fid] = {'depth': depth, 'lat': lat, 'lon': lon}
                if fid not in max_depth_info or depth > max_depth_info[fid]['depth']:
                    # Update the minimum depth for the fid
                    max_depth_info[fid] = {'depth': depth, 'lat': lat, 'lon': lon}
            
            # Output the minimum depth values for each FID
            for fid, info in min_depth_info.items():
                
                if info['lat'] != None:

                    new_feature = QgsFeature()
                    point = QgsPointXY(float(str(info['lon'])), float(str(info['lat'])))

                    # Create a QgsGeometry object with the point
                    geometry = QgsGeometry.fromPointXY(point)
                    new_feature.setGeometry(geometry)
                    new_feature.setAttributes([fid, info['lon'], info['lat'], info['depth']])
                    result_layer.dataProvider().addFeature(new_feature)
                

            # Commit changes to the result layer
            result_layer.commitChanges()

            # Save the result layer to a file
            output_path_min = str_timestamp_folder+"\\shoals.shp"  # Change the path as needed
            QgsVectorFileWriter.writeAsVectorFormat(result_layer, output_path_min, "UTF-8", result_layer.crs(), "ESRI Shapefile")

            print("Result layer saved successfully:", output_path_min)  

            for fid, info in max_depth_info.items():
                
                #print(info)

                if info['lat'] != None:

                    

                    new_feature = QgsFeature()
                    point = QgsPointXY(float(str(info['lon'])), float(str(info['lat'])))

                    # Create a QgsGeometry object with the point
                    geometry = QgsGeometry.fromPointXY(point)
                    new_feature.setGeometry(geometry)
                    new_feature.setAttributes([fid, info['lon'], info['lat'], info['depth']])
                    
                    result_layer_max.dataProvider().addFeature(new_feature)
            # Commit changes to the result layer
            result_layer_max.commitChanges()

            # Save the result layer to a file
            output_path_max = str_timestamp_folder+"\\deeps.shp"  # Change the path as needed
            QgsVectorFileWriter.writeAsVectorFormat(result_layer_max, output_path_max, "UTF-8", result_layer_max.crs(), "ESRI Shapefile")

            return output_path_max,output_path_min
        
        except Exception as e:
            error=f"<font color='red'>Error: {e}</font>"
            self.append_log_message(error)
            return

    #Megring deeps and shoal and remove land areas while creating soundings
    def sounding_section3(self,input_deeps,input_shoals,str_timestamp_folder):

        try:
            #Merging the shoals and deeps files            
            output_soundings_with_land=str_timestamp_folder+"\\soundingswithland.shp"            
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:mergevectorlayers'
            parameters = {
                'LAYERS':[input_deeps,input_shoals],
                'CRS':QgsCoordinateReferenceSystem('EPSG:4326'),
                'OUTPUT':output_soundings_with_land
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            
            self.append_log_message(f"Results: {result}\n\n")
            
            #Removing the land areas from soundingwith land
            output_soundings_diff=str_timestamp_folder+"\\soundings_diff.shp"
            LandArea_LA = str_timestamp_folder+"\\shorline_clip_polygon.shp"
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:multidifference'
            parameters = {
                'INPUT':output_soundings_with_land,
                'OVERLAYS':[LandArea_LA],
                'OUTPUT':output_soundings_diff
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            
            self.append_log_message(f"Results: {result}\n\n")

            
            #Filter the sounding >0
            output_soundings=str_timestamp_folder+"\\soundings.shp"
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:extractbyexpression'
            parameters = {
                'INPUT':output_soundings_diff+'|subset="Depth (m)" >0',
                'EXPRESSION':'"Depth (m)">0',
                'OUTPUT':output_soundings
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            
            self.append_log_message(f"Results: {result}\n\n")
            
            #Applying style to "Sounding" layer
            style_file_path = QgsApplication.qgisSettingsDirPath() + "/python/plugins/umap/UMap_sounding_styles.qml"        
            soundings_lyrObj = QgsVectorLayer(f'{output_soundings}', 'Sounding', 'ogr')   
            soundings_lyrObj.loadNamedStyle(style_file_path) 

            #Adding "Sounding" layer to map canvas
            QgsProject.instance().addMapLayer(soundings_lyrObj)
            
            

        except Exception as e:
            error=f"<font color='red'>Error: {e}</font>"
            self.append_log_message(error)
            return

    
    #Removing the unwanted layers from map canvas
    def remove_layer_by_name(self):
        layer_names_lst=['land-1','land-2','land-3','land-3_memlyr','water-1','water-2','water-2_memlyr','input_layer','shoreline_lyr','chartlimits_polylyr']
        # Get all map layers in the project
        map_layers = QgsProject.instance().mapLayers()

        layer_name=None
        # Iterate through the map layers
        for layer_id, layer in map_layers.items():
            # Check if the layer name matches the provided name
            if layer.name() in layer_names_lst:    
                layer_name= layer.name()           
                # Remove the layer from the project
                if QgsProject.instance().removeMapLayer(layer_id):
                    print(f"Layer '{layer_name}' removed successfully!")
                    
                    return True

        # If the layer was not found
        print(f"Layer '{layer_name}' not found in the project.")
        return False 

    #Removing depth area layer from map canvas
    def remove_layer_deptharea(self):
        layer_names_lst=['deptharea']
        # Get all map layers in the project
        map_layers = QgsProject.instance().mapLayers()

        layer_name=None
        # Iterate through the map layers
        for layer_id, layer in map_layers.items():
            # Check if the layer name matches the provided name
            if layer.name() in layer_names_lst:    
                layer_name= layer.name()           
                # Remove the layer from the project
                if QgsProject.instance().removeMapLayer(layer_id):
                    print(f"Layer '{layer_name}' removed successfully!")
                    
                    return True

        # If the layer was not found
        print(f"Layer '{layer_name}' not found in the project.")
        return False 

    #Rearrange the layers in given order to map canvas
    def rearrange_layers_in_order(self):
        try:
            # Define the desired order of layer names
            desired_order = ['Chart Boundary', 'No Data areas', 'Depth areas', 'Land areas', 'Bathymetric contours', 'Shoreline', 'Sounding']

            # Get the QgsProject instance
            project = QgsProject.instance()

            # Get a list of all layer IDs in the project
            layer_ids = project.mapLayers().keys()

            # Create a dictionary to map layer names to their corresponding IDs
            layer_name_to_id = {project.mapLayer(layer_id).name(): layer_id for layer_id in layer_ids}
            
            # Get the root of the layer tree
            root = project.layerTreeRoot()
            
            # Rearrange layers according to the desired order
            for layer_name in desired_order:
                if layer_name in layer_name_to_id:
                    layer_id = layer_name_to_id[layer_name]
                    # Find the node corresponding to the layer
                    node = root.findLayer(layer_id)
                    if node:
                        # Move the layer to the top-level
                        root.insertChildNode(0, node.clone())
                        # Remove the original node
                        root.removeChildNode(node)

            # Save the project changes
            project.write()
            return False 
        except Exception as e:
            print(e)

    

    #region land areas

    #Adding "Depth (m)" with -1 to shoreline input file
    def shoreline_with_depth(self,input_layer,str_timestamp_folder):

        try:
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Adding depth -1 to Shorline: {start_time}")            
            self.append_log_message(f"fieldcalculator starting..")            
            
            output_shoreline = str_timestamp_folder + '\\shoreline_with_depth.shp'

            depth_field = 'Depth (m)'
            expression = -1.00
            input_layer = QgsVectorLayer(input_layer, 'Input Layer', 'ogr')
            # Check if the field already exists in the layer
            if depth_field not in [field.name() for field in input_layer.fields()]:
                # Define algorithm parameters
                algorithm_name = 'qgis:fieldcalculator'
                parameters = {
                    'INPUT': input_layer,
                    'FIELD_NAME': depth_field,
                    'FIELD_TYPE': 0,  # Set field type to decimal
                    'FIELD_LENGTH': 10,
                    'FIELD_PRECISION':3,  # Precision is not relevant for integer fields
                    'FORMULA': expression,
                    'NEW_FIELD': True,
                    'OUTPUT': output_shoreline
                }

                # Execute the algorithm
                result = processing.run(algorithm_name, parameters)
            else:
                # Define algorithm parameters
                algorithm_name = 'qgis:fieldcalculator'
                parameters = {
                    'INPUT': input_layer,
                    'FIELD_NAME': depth_field,
                    'FIELD_TYPE': 6,  # Set field type to integer
                    'FIELD_LENGTH': 10,
                    'FIELD_PRECISION':3,  # Precision is not relevant for integer fields
                    'FORMULA': expression,
                    'NEW_FIELD': False,  # Update existing field
                    'OUTPUT': output_shoreline
                }

                # Execute the algorithm
                result = processing.run(algorithm_name, parameters)
            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            if self.cancelled:
                return
            return output_shoreline
        except Exception as e:
            error=f"<font color='red'>Error: {e}</font>"
            self.append_log_message(error)
            return

    #Clip the shoreline to chart limit extents
    def shoreline_clip_with_chartlimit(self,input_layer,extents,str_timestamp_folder):

        try:
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            output_shoreline_clip = str_timestamp_folder+'\\shoreline_clip.shp'
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:extractbyextent'
            parameters = {
                'INPUT': input_layer,
                'EXTENT': extents,
                'CLIP': False,
                'OUTPUT': output_shoreline_clip
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            # Log the algorithm results
            self.append_log_message(f"Results: {result}\n\n")
            
            #Adding style to "Shoreline"
            style_file_path = QgsApplication.qgisSettingsDirPath() + "/python/plugins/umap/UMap_shoreline_styles.qml"
            shoreline_lyrObj = QgsVectorLayer(output_shoreline_clip, 'Shoreline', 'ogr')
            shoreline_lyrObj.loadNamedStyle(style_file_path) 

            #Adding "Shoreline" layer to map canvas
            QgsProject.instance().addMapLayer(shoreline_lyrObj)
            
            if self.cancelled:
                return
            return output_shoreline_clip
        except Exception as e:
            error=f"<font color='red'>Error: {e}</font>"
            self.append_log_message(error)
            return
    
    #Split the chartlimit to the line resultant file
    def split_chartlimits_with_shoreline_clip(self,input_layer,str_timestamp_folder):
        
        try:
            
            #split with lines
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            output_split_chartlimits = str_timestamp_folder+'\\split_chartlimits.shp'
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:splitwithlines'
            parameters = {
                'INPUT':self.ChartLimits_WGS84_path,
                'LINES':input_layer,
                'OUTPUT':output_split_chartlimits
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            # Log the algorithm results
            self.append_log_message(f"Results: {result}\n\n")
            
            if self.cancelled:
                    return
            return output_split_chartlimits
        except Exception as e:
            error=f"<font color='red'>Error: {e}</font>"
            self.append_log_message(error)
            return

    #Merge the resultant files
    def merge_shorlineclip_with_splitchatlimits(self,input_shoreline_clip,input_split_chartlimits,str_timestamp_folder):

        try:   
            #Merge vector layer tool:
            output_merged_landboundary=str_timestamp_folder+'\\merged_landboundary.shp'
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:mergevectorlayers'
            parameters = {
                'LAYERS':[input_shoreline_clip,input_split_chartlimits],
                'CRS':QgsCoordinateReferenceSystem('EPSG:4326'),
                'OUTPUT':output_merged_landboundary
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            # Log the algorithm results
            self.append_log_message(f"Results: {result}\n\n")            

            if self.cancelled:
                return
            return output_merged_landboundary
        except Exception as e:
            error=f"<font color='red'>Error: {e}</font>"
            self.append_log_message(error)
            return

    #Process for creating the land areas
    def creating_land_area(self,input_merged_landboundary,str_timestamp_folder):

        try:

            #polygonize tool:
            output_polygonolize_shp=str_timestamp_folder+"\\Polygonize.shp"
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:polygonize'
            parameters = {
                'INPUT':input_merged_landboundary,
                'KEEP_FIELDS':False,
                'OUTPUT':output_polygonolize_shp
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            # Log the algorithm results
            self.append_log_message(f"Results: {result}\n\n")

            
            if self.cancelled:
                return

            # Load the input layer
            input_layer = QgsVectorLayer(output_polygonolize_shp, 'input_layer', 'ogr')

            QgsProject.instance().addMapLayer(input_layer)

            
            max_area = 0
            max_intersection_feature_id = None

            # Iterate over features in the polygon layer
            for feature in input_layer.getFeatures():
                # Calculate the area of the current feature
                area = feature.geometry().area()
                
                # Update the maximum area and the corresponding feature ID if needed
                if area > max_area:
                    max_area = area
                    max_intersection_feature_id = feature.id()

            # Print the feature ID with the maximum area
            print("Feature ID with maximum area:", max_intersection_feature_id)

            water_1_layer_path = str_timestamp_folder+'\\water-1.shp'

            
            # Load the input layer
            water_1_layer = QgsVectorLayer(water_1_layer_path, 'water-1', 'ogr')
            
            
            #water-1            
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:extractbyexpression'
            parameters = {
                'INPUT':output_polygonolize_shp,
                'EXPRESSION':'"FID" =' + str(max_intersection_feature_id),
                'OUTPUT':water_1_layer_path
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result_layer = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            # Log the algorithm results
            self.append_log_message(f"Results: {result}\n\n")
            
            # Load the resultant layer onto the map canvas
            water_1_layer = QgsVectorLayer(result_layer['OUTPUT'],  'water-1', 'ogr')
            if not water_1_layer.isValid():
                print("Layer failed to load!")
            else:
                QgsProject.instance().addMapLayer(water_1_layer)
                print("Layer loaded successfully!")

            
            #land-1
            land_1_layerpath = str_timestamp_folder+'/land-1.shp'
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:extractbyexpression'
            parameters = {
                'INPUT':output_polygonolize_shp,
                'EXPRESSION':'"FID" IS NOT' + str(max_intersection_feature_id),
                'OUTPUT':land_1_layerpath
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result_layer = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            # Log the algorithm results
            self.append_log_message(f"Results: {result}\n\n")
        
            #water-2
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:selectbylocation'
            parameters = {
                'INPUT':output_polygonolize_shp,
                'PREDICATE':[2],
                'INTERSECT':water_1_layer_path,
                'METHOD':0
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result_layer = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            # Log the algorithm results
            self.append_log_message(f"Results: {result}\n\n")
            
            # Get selected features for the current layer 
            if input_layer.selectedFeatureCount() > 0:
                # Create a memory layer to store the selected features
                mem_layer = QgsVectorLayer("Polygon?crs=" + input_layer.crs().authid(), "water-2_memlyr", "memory")

                # Add fields to the memory layer
                mem_layer_fields = input_layer.fields() 
                mem_layer.dataProvider().addAttributes(mem_layer_fields)
                mem_layer.updateFields()

                # Start editing the memory layer
                mem_layer.startEditing()

                # Copy selected features to the memory layer
                selected_features = input_layer.selectedFeatures()
                for feature in selected_features:
                    mem_layer.addFeature(feature)

                # Commit changes and stop editing
                mem_layer.commitChanges()

                # Add the memory layer to the project
                QgsProject.instance().addMapLayer(mem_layer)
                
                # Replace 'path_to_output_layer' with the path where you want to save the output layer
                water_2_layerpath = str_timestamp_folder+'\\water-2.shp'
            
                QgsVectorFileWriter.writeAsVectorFormat(mem_layer,water_2_layerpath, "UTF-8", mem_layer.crs(), "ESRI Shapefile")
            
                
                # Load the input layer
                water_2_layer = QgsVectorLayer(water_2_layerpath, 'water-2', 'ogr')
                QgsProject.instance().addMapLayer(water_2_layer)

                #land-2:  Differene water-2 from land-1 for 
                land_2_layerpath=str_timestamp_folder+'/land-2.shp'
                processing.run("native:difference", {
                    'INPUT':land_1_layerpath,
                    'OVERLAY':water_2_layerpath,
                    'OUTPUT':land_2_layerpath
                    })

                # Load the input layer
                land_2_layer = QgsVectorLayer(land_2_layerpath, 'land-2', 'ogr')
                QgsProject.instance().addMapLayer(land_2_layer)

                
                #land-3:   land-2 disjoint water-2
                processing.run("native:selectbylocation", {
                    'INPUT':water_2_layerpath,
                    'PREDICATE':[2],
                    'INTERSECT':land_2_layerpath,
                    'METHOD':0})

                if water_2_layer.selectedFeatureCount() > 0:
                                    
                    # Get selected features for the current layer
                    selected_features_water_2 = water_2_layer.selectedFeatures()
                    # Create a memory layer to store the selected features
                    land_3_mem_layer = QgsVectorLayer("Polygon?crs=" + water_2_layer.crs().authid(), "land-3_memlyr", "memory")

                    # Add fields to the memory layer
                    mem_layer_fields_water_2 = water_2_layer.fields() 
                    land_3_mem_layer.dataProvider().addAttributes(mem_layer_fields_water_2)
                    land_3_mem_layer.updateFields()

                    # Start editing the memory layer
                    land_3_mem_layer.startEditing()

                    # Copy selected features to the memory layer
                    for feature in selected_features_water_2:
                        land_3_mem_layer.addFeature(feature)

                    # Commit changes and stop editing
                    land_3_mem_layer.commitChanges()

                    # Add the memory layer to the project
                    QgsProject.instance().addMapLayer(land_3_mem_layer)
                    
                    # Replace 'path_to_output_layer' with the path where you want to save the output layer
                    land_3_layerpath = str_timestamp_folder+'\\land-3.shp'
                
                    QgsVectorFileWriter.writeAsVectorFormat(land_3_mem_layer,land_3_layerpath, "UTF-8", land_3_mem_layer.crs(), "ESRI Shapefile")
                
                    
                    # Load the input layer
                    land_3_layer = QgsVectorLayer(land_3_layerpath, 'land-3', 'ogr')
                    QgsProject.instance().addMapLayer(land_3_layer)

                    #land-areas
                    land_areas_layerpath =str_timestamp_folder+'/shorline_clip_polygon.shp'
                    processing.run("native:mergevectorlayers", {
                        'LAYERS':[land_2_layerpath,land_3_layerpath],'CRS':QgsCoordinateReferenceSystem('EPSG:4326'),
                        'OUTPUT':land_areas_layerpath
                        })

                    # Path to your .qml style file
                    style_file_path = QgsApplication.qgisSettingsDirPath() + "/python/plugins/umap/UMap_land_area_styles.qml"

            
            
            
                    # Load the input layer
                    land_area_layer = QgsVectorLayer(land_areas_layerpath, 'Land areas', 'ogr')
                    land_area_layer.loadNamedStyle(style_file_path)
                    QgsProject.instance().addMapLayer(land_area_layer)
                    #self.canvas_zoom_to_complication(land_area_layer)
                else:
                    output_layer_path=str_timestamp_folder+'/shorline_clip_polygon.shp'
                    # Path to your .qml style file
                    style_file_path = QgsApplication.qgisSettingsDirPath() + "/python/plugins/umap/UMap_land_area_styles.qml"
                    # Load the input layer
                    land_area_layer = QgsVectorLayer(land_2_layerpath, 'Land areas', 'ogr')
                    
                    land_area_final_path=QgsVectorFileWriter.writeAsVectorFormat(land_area_layer, output_layer_path, "UTF-8", land_area_layer.crs(), "ESRI Shapefile")
                    land_area_layer_final = QgsVectorLayer(output_layer_path, 'Land areas', 'ogr')
                    land_area_layer_final.loadNamedStyle(style_file_path)
                    QgsProject.instance().addMapLayer(land_area_layer_final)
                    #self.canvas_zoom_to_complication(land_area_layer_final)
            else:
                
                output_layer_path=str_timestamp_folder+'/shorline_clip_polygon.shp'
                # Path to your .qml style file
                style_file_path = QgsApplication.qgisSettingsDirPath() + "/python/plugins/umap/UMap_land_area_styles.qml"
                # Load the input layer
                land_area_layer = QgsVectorLayer(land_1_layerpath, 'Land areas', 'ogr')
                #QgsProject.instance().addMapLayer(land_area_layer)
                land_area_final_path=QgsVectorFileWriter.writeAsVectorFormat(land_area_layer, output_layer_path, "UTF-8", land_area_layer.crs(), "ESRI Shapefile")
                land_area_layer_final = QgsVectorLayer(output_layer_path, 'Land areas', 'ogr')
                land_area_layer_final.loadNamedStyle(style_file_path)
                QgsProject.instance().addMapLayer(land_area_layer_final)
                #self.canvas_zoom_to_complication(land_area_layer_final)
        except Exception as e:
            error=f"<font color='red'>Error: {e}</font>"
            self.append_log_message(error)
            return
    
            

        self.load_layeras_submenu()
    
    #endregion

    
    #region survey area
    
    def merge_raster_layers(self,survey_layers_to_merge,str_timestamp_folder):
        try:

            #need to delete
            output_survey_layer=str_timestamp_folder+'\\survey_layer.shp'

            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:mergevectorlayers'
            parameters = {
                'LAYERS':survey_layers_to_merge,
                'CRS':QgsCoordinateReferenceSystem('EPSG:4326'),
                'OUTPUT':output_survey_layer
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            
            self.append_log_message(f"Results: {result}\n\n")
            processing.run("native:createspatialindex", {'INPUT':output_survey_layer})
            return output_survey_layer
        
        except Exception as e:
            error=f"<font color='red'>Error: {e}</font>"
            self.append_log_message(error)
            return

    #Clipping the converted point file to chart extents
    def survey_layer_clip(self,input_survey_layer,extents,str_timestamp_folder):

        try:
            
            output_survey_layer_clip=str_timestamp_folder+'\\survey_layer_clip.shp'
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:extractbyextent'
            parameters = {
                'INPUT':input_survey_layer,
                'EXTENT':extents,
                'CLIP':False,
                'OUTPUT':output_survey_layer_clip
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            
            self.append_log_message(f"Results: {result}\n\n")
            processing.run("native:createspatialindex", {'INPUT':output_survey_layer_clip})
            return output_survey_layer_clip

        except Exception as e:
            error=f"<font color='red'>Error: {e}</font>"
            self.append_log_message(error)
            return

    #Creating survey area 
    def creating_survey_area(self,input_survey_layer_clip,str_timestamp_folder):

        try:
            #Creating Buffer 
            output_survey_data_buffer=str_timestamp_folder+'\\survey_area.shp'
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'native:buffer'
            parameters = {
                'INPUT':input_survey_layer_clip,
                'DISTANCE':0.005,
                'SEGMENTS':5,
                'END_CAP_STYLE':0,
                'JOIN_STYLE':0,
                'MITER_LIMIT':2,
                'DISSOLVE':True,
                'OUTPUT':output_survey_data_buffer
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            
            self.append_log_message(f"Results: {result}\n\n")
            processing.run("native:createspatialindex", {'INPUT':output_survey_data_buffer})
            
        
     
            
        except Exception as e:
            error=f"<font color='red'>Error: {e}</font>"
            self.append_log_message(error)
            return

    #endregion
    
    #Calculating the tin resolution
    def tin_resolution_value(self):
        current_scale=self.dlg.scale.currentText()
        scaleval = current_scale.split(':')
        scaleval_int =int(scaleval[1]) 
        tin_resolution_val = scaleval_int * 4.e-9
        print(tin_resolution_val)
        tin_resolution_val_str = "{:.10f}".format(tin_resolution_val)        
        return tin_resolution_val

    #Creating tin based on the input files  
    def creating_tin(self,str_timestamp_folder,lst_tif_files,extents):
        try:
            expression="" 
            #Shoreline with "Depth (m)"
            shore_file=str_timestamp_folder+'\\shoreline_with_depth.shp'
            lst_tif_files.append(shore_file) 
            
                      
            if lst_tif_files:
                j=1
                len_files=len(lst_tif_files)
                print(len_files)
                for tif_files in lst_tif_files:
                    base_filename = os.path.splitext(os.path.basename(tif_files))[0]
                    depth_field_index=None
                    final_merge_fieldsindex = QgsVectorLayer(tif_files, 'final merge', 'ogr')        
                    fields = final_merge_fieldsindex.fields()
                    for i in range(len(fields)):
                        field = fields[i]
                        if field.name() == 'Depth (m)':
                            depth_field_index = str(i)                        
                    if j==1: 
                        if base_filename=="shoreline_with_depth":                   
                            expression+=tif_files+"::~::0::~::"+depth_field_index+"::~::2"
                        else:
                            expression+=tif_files+"::~::0::~::"+depth_field_index+"::~::0"

                    else:
                        if base_filename=="shoreline_with_depth":
                            expression+="::|::"+tif_files+"::~::0::~::"+depth_field_index+"::~::2"
                        else:
                            expression+="::|::"+tif_files+"::~::0::~::"+depth_field_index+"::~::0"

                    j=j+1
                  

            
            #Run the TinInterpolation on the input files.
            tin_resolution=self.tin_resolution_value()
            output_merged_clip_tin=str_timestamp_folder+'\\merged_ink_sdb_shor_tin.tif'
            start_time=None
            algorithm_name=None
            parameters=None
            feedback=None
            result=None
            end_time=None
            
            start_time = datetime.datetime.now()
            self.append_log_message(f"Algorithm started at: {start_time}")
            algorithm_name = 'qgis:tininterpolation'
            parameters = {
                'INTERPOLATION_DATA':expression,
                'METHOD':0,
                'EXTENT':extents,
                'PIXEL_SIZE':tin_resolution,
                'OUTPUT':output_merged_clip_tin
            }
            self.append_log_message(f"Algorithm: {algorithm_name} starting..")
            self.append_log_message(f"Input parameters: \n {parameters}")
            feedback = QgsProcessingFeedback()
            result = processing.run(algorithm_name, parameters, feedback=feedback)

            end_time = datetime.datetime.now()
            elapsed_time = end_time - start_time
            self.append_log_message(f"Execution completed in {elapsed_time.total_seconds()} seconds")

            
            self.append_log_message(f"Results: {result}\n\n")
            
            
        except Exception as e:
            error=f"<font color='red'>Error: {e}</font>"
            self.append_log_message(error)
            return
    
    #Filter the depth areas based on min and max
    def depth_areas_filter(self,input_depth_file,str_timestamp_folder): 
        try:  

            depth_area_files_path =[]   
            
            input_layer = QgsVectorLayer(input_depth_file, 'deptharea', 'ogr')

            # Check if the layer was loaded successfully
            if not input_layer.isValid():
                print("Layer failed to load!")
                return

            # Add the layer to the QGIS project
            QgsProject.instance().addMapLayer(input_layer)
            layer = QgsProject.instance().mapLayersByName('deptharea')[0]
            expression = "\"min\" <= 0 AND \"max\" <= 0"
            self.create_depth_layers(layer,expression,"lessthan0.shp",str_timestamp_folder,depth_area_files_path)
            expression = "\"min\" >= 0 AND \"max\" <= 2"
            self.create_depth_layers(layer,expression,"0-2.shp",str_timestamp_folder,depth_area_files_path)  
            expression = "\"min\" >= 2 AND \"max\" <= 5"
            self.create_depth_layers(layer,expression,"2-5.shp",str_timestamp_folder,depth_area_files_path)      
            expression = "\"min\" >= 5 AND \"max\" <= 10"
            self.create_depth_layers(layer,expression,"5-10.shp",str_timestamp_folder,depth_area_files_path)
            expression = "\"min\" >= 10 AND \"max\" <= 20"
            self.create_depth_layers(layer,expression,"10-20.shp",str_timestamp_folder,depth_area_files_path)
            expression = "\"min\" >= 20 AND \"max\" <= 30"
            self.create_depth_layers(layer,expression,"20-30.shp",str_timestamp_folder,depth_area_files_path)
            expression = "\"min\" >= 30 AND \"max\" <= 50"
            self.create_depth_layers(layer,expression,"30-50.shp",str_timestamp_folder,depth_area_files_path)
            expression = "\"min\" >= 50 AND \"max\" <= 100"
            self.create_depth_layers(layer,expression,"50-100.shp",str_timestamp_folder,depth_area_files_path)

            return depth_area_files_path
        except Exception as e:
            error=f"<font color='red'>Error: {e}</font>"
            self.append_log_message(error)
            return

    def create_depth_layers(self,layer,expression,output_layer,str_timestamp_folder,depth_area_files_path):

        try:

            if not layer.isValid():
                print("Layer failed to load!")
                return
            
            layer.selectByExpression(expression)

            # Get selected features
            selected_features = layer.selectedFeatures()
            
            if selected_features:
                output_path=str_timestamp_folder+"\\"+output_layer
                processing.run("native:dissolve", {
                    'INPUT':QgsProcessingFeatureSourceDefinition(layer.source(), 
                    selectedFeaturesOnly=True, featureLimit=-1, 
                    geometryCheck=QgsFeatureRequest.GeometryAbortOnInvalid),
                    'FIELD':[],
                    'SEPARATE_DISJOINT':False,
                    'OUTPUT':output_path})

                layer.startEditing()

                # Find and delete features that meet the expression
                request = QgsFeatureRequest().setFilterExpression(expression)
                for feature in layer.getFeatures(request):
                    layer.deleteFeature(feature.id())

                # Commit changes
                layer.commitChanges()

                # Refresh the layer to reflect changes
                layer.triggerRepaint()
                
                depth_area_files_path.append(output_path)
        except Exception as e:
            error=f"<font color='red'>Error: {e}</font>"
            self.append_log_message(error)
            return
        
    
    #Displaying help text when mapextent clicked
    def on_map_clicked(self,event):
        self.dlg.defaultHelpContent.setVisible(False)
        self.dlg.HelpMapExtent.setVisible(True)
        self.dlg.HelpShoreline.setVisible(False)
        self.dlg.HelpTopographicContours.setVisible(False)
        self.dlg.HelpDigitalBathy.setVisible(False)
        self.dlg.HelpSounding.setVisible(False)

    #Zoom map canvas to complication scale selected
    def canvas_zoom_to_complication(self,layer_path):
        layer=QgsVectorLayer(layer_path,'chart')
        canvas = self.iface.mapCanvas()
        center = None
        if(layer.crs()!=canvas.mapSettings().destinationCrs()):
            # Get the coordinate transform object
            transform = QgsCoordinateTransform(layer.crs(), canvas.mapSettings().destinationCrs(), QgsProject.instance())

            # Transform the layer extent to the extent of the map canvas
            transformed_extent = transform.transformBoundingBox(layer.extent())
            center = transformed_extent.center()
        else:
            center = layer.extent().center()
        #print("layer center",center)
        current_scale=self.dlg.scale.currentText()
        scaleval = current_scale.split(':')
        scaleval_int =int(scaleval[1])
        #print("current scale value",scaleval_int)
        canvas.setCenter(center)
        canvas.zoomScale(scaleval_int)
        canvas.refresh()

    #Displaying help text when mapextent textbox clicked
    def on_mapextent_clicked(self,event):
        self.dlg.defaultHelpContent.setVisible(False)
        self.dlg.HelpMapExtent.setVisible(True)
        self.dlg.HelpShoreline.setVisible(False)
        self.dlg.HelpTopographicContours.setVisible(False)
        self.dlg.HelpDigitalBathy.setVisible(False)
        self.dlg.HelpSounding.setVisible(False)
    
    #Displaying help text when shoreline textbox clicked
    def on_shore_clicked(self,event):
        self.dlg.defaultHelpContent.setVisible(False)
        self.dlg.HelpMapExtent.setVisible(False)
        self.dlg.HelpShoreline.setVisible(True)
        self.dlg.HelpTopographicContours.setVisible(False)
        self.dlg.HelpDigitalBathy.setVisible(False)
        self.dlg.HelpSounding.setVisible(False)
        
    #Displaying help text when topographic textbox clicked
    def on_topo_clicked(self,event):
        self.dlg.defaultHelpContent.setVisible(False)
        self.dlg.HelpMapExtent.setVisible(False)
        self.dlg.HelpShoreline.setVisible(False)
        self.dlg.HelpTopographicContours.setVisible(True)
        self.dlg.HelpDigitalBathy.setVisible(False)
        self.dlg.HelpSounding.setVisible(False)
    
    #Displaying help text when Bathymetric textbox  clicked
    def on_digital_clicked(self,event):
        self.dlg.defaultHelpContent.setVisible(False)
        self.dlg.HelpMapExtent.setVisible(False)
        self.dlg.HelpShoreline.setVisible(False)
        self.dlg.HelpTopographicContours.setVisible(False)
        self.dlg.HelpDigitalBathy.setVisible(True)
        self.dlg.HelpSounding.setVisible(False)

    #Shoreline browse button clicked
    def on_Shorelinefile_changed(self):
        
       
        try:
            
            self.dlg.defaultHelpContent.setVisible(False)
            self.dlg.HelpMapExtent.setVisible(False)
            self.dlg.HelpShoreline.setVisible(True)
            self.dlg.HelpTopographicContours.setVisible(False)
            self.dlg.HelpDigitalBathy.setVisible(False)
            self.dlg.HelpSounding.setVisible(False)
            self.dlg.HelpSounding.setVisible(False)
            self.dlg.frame.hide()   
            self.dlg.frame_input.show() 
            existing_files=self.dlg.lnEd_shoreline.text()
            self.load_map_layers("Shoreline",existing_files) 

        
        except Exception as e:
            print(e)
    
    #Topographic browse button clicked
    def on_Topographicfile_changed(self):
        try:
        
                   
            self.dlg.defaultHelpContent.setVisible(False)
            self.dlg.HelpMapExtent.setVisible(False)
            self.dlg.HelpShoreline.setVisible(False)
            self.dlg.HelpTopographicContours.setVisible(True)
            self.dlg.HelpDigitalBathy.setVisible(False)      
            self.dlg.HelpSounding.setVisible(False)      
            self.dlg.frame.hide()   
            self.dlg.frame_input.show() 
            existing_files=self.dlg.lnEd_topographic.text()
            self.load_map_layers("Topographic",existing_files) 
        
        except Exception as e:
            print(e)
    
    #Bathymetric browse button clicked
    def on_Bathymetricfile_changed(self):
        try:
           
            self.dlg.defaultHelpContent.setVisible(False)
            self.dlg.HelpMapExtent.setVisible(False)
            self.dlg.HelpShoreline.setVisible(False)
            self.dlg.HelpTopographicContours.setVisible(False)
            self.dlg.HelpDigitalBathy.setVisible(True)
            self.dlg.HelpSounding.setVisible(False)
            self.dlg.frame.hide()   
            self.dlg.frame_input.show() 
            existing_files=self.dlg.lnEd_bathy.text()
            self.load_map_layers("Bathymetric",existing_files) 
            
        
        except Exception as e:
            print(e)
    
    #when clicked on input layer button to display main window
    def back_to_mainframe(self):
        self.dlg.frame.show()   
        self.dlg.frame_input.hide()
    
    #Add files button click event
    def addBathymetricFiles(self):
        try:
            layer_types=self.layer_type
            files=self.digital_bathymetric_browse().split(',')
            
            if len(files)>1:
                # Create a QTreeWidget
                tree_widget = self.dlg.treeWidget
                
                #tree_widget.setColumnCount(1)
                #tree_widget.setHeaderLabels(["Selected Files"])

                # Add selected files to the tree widget
                for file_path in files:
                    if file_path !="":
                        
                        if layer_types=="Bathymetric":
                            
                            tree_widget.setColumnCount(2)
                            tree_widget.setHeaderLabels(["Digital Bathymetric Terrain Model(s)", "Reference model"])
                            base_filename = os.path.splitext(os.path.basename(file_path))[0]
                            item = QTreeWidgetItem(tree_widget)
                            item.setCheckState(0, Qt.Checked)  # Set checkbox checked
                            item.setText(0, base_filename)
                            width = QFontMetrics(tree_widget.font()).boundingRect(base_filename).width() + 20  # Adding extra padding
                            tree_widget.setColumnWidth(0, width)
                            # Create a QComboBox widget for the third column
                            combo_box = QComboBox()
                            combo_box.addItems(["No", "Yes"])  # Add "Yes" and "No" options to the dropdown
                            combo_box.setFixedWidth(50)  # Set the width of the combo box

                            # Set the QComboBox as the item widget for the third column
                            tree_widget.setItemWidget(item, 1, combo_box)  # Assuming third column index is 2
                            item.setText(2, file_path)
                            
                            
                            # Add the item to the tree widget
                            tree_widget.addTopLevelItem(item) 
                        elif layer_types=="Shoreline":
                            tree_widget.setColumnCount(1)
                            tree_widget.setHeaderLabels(["Shoreline"])
                            base_filename = os.path.splitext(os.path.basename(file_path))[0]
                            item = QTreeWidgetItem(tree_widget, [base_filename,file_path])
                            item.setCheckState(0, Qt.Checked) 
                        else:
                            base_filename = os.path.splitext(os.path.basename(file_path))[0]
                            item = QTreeWidgetItem(tree_widget, [base_filename,file_path])
                            item.setCheckState(0, Qt.Checked)  # Set checkbox checked



                    # Show the tree widget
                    tree_widget.show()
                
        except Exception as e:
            print(e)
 
    #Browsing the files based on layer type
    def digital_bathymetric_browse(self):
        files=""
        file_filter=None
        layer_types=self.layer_type
        
        
        if layer_types=="Shoreline":
            file_filter = "(*.gpkg *.shp *.geojson)"            
        if layer_types=="Topographic":
            file_filter = "(*.tif *.tiff *.TIF *.TIFF *.shp *.txt)"            
        if layer_types=="Bathymetric":
            file_filter = "(*.tif *.tiff *.TIF *.TIFF *.shp *.txt)"
            

        file_paths, selected_filter = QFileDialog.getOpenFileNames(
            None,
            "Select Files",
            "",
            file_filter
        )
        
        
        
        if file_paths:
            
            for file_path in file_paths: 
                             
                files += file_path+","               
                base_filename = os.path.splitext(os.path.basename(file_path))[1]


                 
        return files

    #Deleting the selected files in bathymetric selection
    def deleteSelectedBathymetricFiles(self):

        try:

            tree_widget = self.dlg.treeWidget     
               
            selected_items = tree_widget.selectedItems() 
            if selected_items:
                  
                for item in selected_items:
                    parent_item = item.parent()
                    if parent_item is not None:
                        parent_item.removeChild(item)
                    else:
                        tree_widget.invisibleRootItem().removeChild(item)
            else:
                self.show_alert_message("Select the files to delete.")
        except Exception as e:
            print(e)

    #Copy log data to clipboard
    def copy_text_to_clipboard(self):
        log_data = self.dlg.textEdit_log.toPlainText()
        QApplication.clipboard().setText(log_data)

    #SaveAs log data to file
    def saveas_logdata_to_file(self):
        try:
            # Retrieve the text from the QLineEdit widget
            log_data = self.dlg.textEdit_log.toPlainText()
            

            # Prompt the user to select a file path to save the text
            file_path, _ = QFileDialog.getSaveFileName(None, "Save File", "", "Text Files (*.txt)")

            # If the user cancels the dialog or doesn't provide a file name, return
            if not file_path:
                return

            
            # Write the text to the selected file
            with open(file_path, 'w') as file:
                file.write(log_data)
        except Exception as e:
            print(e)

    def bathy_checked_files(self):
        
        try:
            
            checked_values = []
            tree_widget=self.dlg.treeWidget
            section_types=self.layer_type
            txt_bathy_files=None
            if section_types=="Shoreline":
                
                if not os.path.exists("C:\\Temp\\UMapService"):                            
                    os.makedirs("C:\\Temp\\UMapService")
                #self.delete_files_in_directory("C:\\Temp\\UMapService")
                txt_bathy_files=self.dlg.lnEd_shoreline
            if section_types=="Topographic":
                txt_bathy_files=self.dlg.lnEd_topographic
            if section_types=="Bathymetric":
                
                if not os.path.exists("C:\\Temp\\UMapService"):                            
                    os.makedirs("C:\\Temp\\UMapService")
                #self.delete_files_in_directory("C:\\Temp\\UMapService")
                txt_bathy_files=self.dlg.lnEd_bathy
            ref_file=None
            dem_file=[]
            combo_box_item=None
            for item in tree_widget.findItems("", Qt.MatchContains):
                if item.checkState(0) == Qt.Checked:
                    if section_types=="Bathymetric":
                        
                        combo_box_item = tree_widget.itemWidget(item, 1)                    
                    if 'wcs' in item.text(2): 
                        
                        layer_path=self.exportRastertoExtentLyr(item.text(0),self.ChartLimits_WGS84_path,"C:\\Temp\\UMapService",'wcs','')                        
                        
                        if combo_box_item is not None and isinstance(combo_box_item, QComboBox):
                            # Retrieve the selected value from the QComboBox
                            selected_value = combo_box_item.currentText()
                            if selected_value=="Yes":
                                ref_file=layer_path
                            else:
                                dem_file.append(layer_path)
                        else:
                            checked_values.append(layer_path)

                    elif '.tif' in item.text(2):                      
                        
                        layer_path=self.exportRastertoExtentLyr(item.text(0),self.ChartLimits_WGS84_path,"C:\\Temp\\UMapService",'.tif',item.text(2))                        
                        
                        if combo_box_item is not None and isinstance(combo_box_item, QComboBox):
                            # Retrieve the selected value from the QComboBox
                            selected_value = combo_box_item.currentText()
                            if selected_value=="Yes":
                                ref_file=layer_path
                            else:
                                dem_file.append(layer_path)
                        else:
                            
                            checked_values.append(layer_path)

                    else:
                        if section_types=="Bathymetric":
                            checked_values.append(item.text(2))
                        else:
                            checked_values.append(item.text(1))

            if ref_file:
                if not os.path.exists("C:\\Temp\\VerticalShift"):                            
                    os.makedirs("C:\\Temp\\VerticalShift")
                self.delete_files_in_directory("C:\\Temp\\VerticalShift")
                checked_values.append(ref_file)

                if len(dem_file)>=1:
                    i=1
                    for dem_file_path in dem_file:
                        if dem_file_path:
                            vshift_file=self.fn_vertical_shift(ref_file,dem_file_path,"C:\\Temp\\VerticalShift",i)
                            if vshift_file ==None:
                                checked_values.append(dem_file_path)
                            else:
                                checked_values.append(dem_file_path)
                        i=i+1
            else:
                if len(dem_file)>=1:
                    for dem_file_path in dem_file:
                        if dem_file_path:
                            checked_values.append(dem_file_path)


                
            
            txt_bathy_files.setText(", ".join(checked_values)) 
            if section_types=="Shoreline":
                self.UMapplugin_validation(txt_bathy_files.text())
                self.remove_layer_by_name()
                self.delete_files_in_directory("C:\\Temp\\UMapService")
            self.dlg.frame.show()   
            self.dlg.frame_input.hide() 
        except Exception as e:
            print(e)

    def UMapplugin_validation(self,shoreline_path):
        print(shoreline_path)

        extent_layer = QgsVectorLayer(f'{self.ChartLimits_WGS84_path}', 'chartlimit', 'ogr')  
        shoreline_layer = QgsVectorLayer(f'{shoreline_path}', 'shoreline_lyr', 'ogr')
        QgsProject.instance().addMapLayer(shoreline_layer)

        output_chart_limit_poly = 'C:\\Temp\\UMapService\\chart_limit_poly.shp'

        processing.run("native:polygonize", {
			'INPUT':extent_layer,
			'KEEP_FIELDS':False,
			'OUTPUT':output_chart_limit_poly
			})
        
        chartlimits_polylyr = QgsVectorLayer(f'{output_chart_limit_poly}', 'chartlimits_polylyr', 'ogr')
        QgsProject.instance().addMapLayer(chartlimits_polylyr)


        processing.run("native:selectbylocation", {
            'INPUT':shoreline_layer,
            'PREDICATE':[0],
            'INTERSECT':output_chart_limit_poly,
            'METHOD':0
            })


        if shoreline_layer.selectedFeatureCount() > 0:
            print("featues are inside")
        else:
            self.show_alert_message("Please select shoreline data within Map extents.")
            self.dlg.lnEd_shoreline.clear()
            self.dlg.lnEd_mapextent.clear()
    
    #Deleting the files in the directory
    def delete_files_in_directory(self,directory):
        
        # Get a list of all files in the directory
        files = os.listdir(directory)
        
        # Iterate through the files and delete them
        for file in files:
            file_path = os.path.join(directory, file)
            try:
                if os.path.isfile(file_path):
                    os.remove(file_path)
                    print(f"Deleted file: {file_path}")
            except Exception as e:
                print(f"Failed to delete file: {file_path}. Reason: {e}")
   
    def exportRastertoExtentLyr(self,layer_name,mapextent_path,service_filesave_path,file_type,layer_path): 
        raster_layer=None
        file_name=None
        if 'wcs' in file_type:
            #Get the Nonna service layer object    
            raster_layer = QgsProject.instance().mapLayersByName(layer_name)[0]

            #Get the extents layer object to which tiff has to be clipped
            #extent_layer = QgsProject.instance().mapLayersByName('chartlimit')[0]
            extent_layer = QgsVectorLayer(f'{mapextent_path}', 'chartlimit', 'ogr')  
            extent = None
            width = None
            height = None
            
            raster_crs = raster_layer.crs()
            epsg_code = raster_crs.authid()
            print(epsg_code)
            extent_crs = extent_layer.crs()

            re_extent_layer= service_filesave_path+'/re_project_'+layer_name+'.shp'

            pixelSizeX = raster_layer.rasterUnitsPerPixelX()
            pixelSizeY = raster_layer.rasterUnitsPerPixelY()
            print("pixelSizeX",pixelSizeX)
            print("pixelSizeY",pixelSizeY)

            #Reproject the extents layer to match the tiff projection
            if(extent_crs!=raster_crs):
                processing.run("native:reprojectlayer", {
                'INPUT':mapextent_path,
                'TARGET_CRS':QgsCoordinateReferenceSystem(epsg_code),            
                'OUTPUT':re_extent_layer
                })  

                re_extentlayer_Obj = QgsVectorLayer(f'{re_extent_layer}', 're_extentlayer1', 'ogr')        
                #QgsProject.instance().addMapLayer(re_extentlayer_Obj)
                extent = re_extentlayer_Obj.extent()
                width = re_extentlayer_Obj.extent().width()/pixelSizeX
                height = re_extentlayer_Obj.extent().height()/pixelSizeY
            else:
                extent = extent_layer.extent()
                width = extent_layer.extent().width()/pixelSizeX
                height = extent_layer.extent().height()/pixelSizeY

            #set up the output raster tif
            file_name = service_filesave_path+'/'+layer_name+'.tif'
            file_writer = QgsRasterFileWriter(file_name)
            pipe = QgsRasterPipe()
            provider = raster_layer.dataProvider()

            print("---------provider crs--------------")
            print(provider.crs())

            if not pipe.set(provider.clone()):
                print ("Cannot set pipe provider") 
                return 

            #clip the raster tif to the extent
            error =file_writer.writeRaster(
                pipe,
                width,
                height,            
                extent,
                provider.crs())
            
            if error == QgsRasterFileWriter.NoError:
                print ("Raster was saved successfully!")
                #layer = QgsRasterLayer(file_name, "result")
            # QgsProject.instance().addMapLayer(layer)
            else:
                print ("Raster was not saved!") 
        else:
            raster_layer = QgsRasterLayer(layer_path, "result")
            extent_layer = QgsVectorLayer(f'{mapextent_path}', 'chartlimit', 'ogr')  
            extent = None
            width = None
            height = None
            
            raster_crs = raster_layer.crs()
            epsg_code = raster_crs.authid()
            print(epsg_code)
            extent_crs = extent_layer.crs()

            re_extent_layer= service_filesave_path+'/re_project_'+layer_name+'.shp'

            #Reproject the extents layer to match the tiff projection
            if(extent_crs!=raster_crs):
                processing.run("native:reprojectlayer", {
                'INPUT':mapextent_path,
                'TARGET_CRS':QgsCoordinateReferenceSystem(epsg_code),            
                'OUTPUT':re_extent_layer
                })
            else:
                re_extent_layer=mapextent_path
            file_name = service_filesave_path+'/'+layer_name+'.tif'
            processing.run("gdal:cliprasterbyextent", {
                'INPUT':layer_path,
                'PROJWIN':re_extent_layer,
                'OVERCRS':False,
                'NODATA':None,
                'OPTIONS':'',
                'DATA_TYPE':0,
                'EXTRA':'',
                'OUTPUT':file_name})

        
        return file_name

    #Close button clicked
    def close_dialog(self):
        reloadPlugin('UMap')
        # Close the dialog when the button is clicked
        self.dlg.accept()
        self.dlg.frame.show()   
        self.dlg.frame_input.show()
        self.dlg.textEdit_log.clear()
        
    
    def load_map_layers(self,layer_name,existing_files):
        try:
            
            self.layer_type=layer_name
            self.dlg.treeWidget.clear()
            tree_widget = self.dlg.treeWidget 
            if layer_name == "Shoreline":
                tree_widget.setColumnCount(1)
                tree_widget.setHeaderLabels(["Shoreline"])
            if layer_name == "Topographic":
                tree_widget.setColumnCount(1)
                tree_widget.setHeaderLabels(["Topographic Contours"])
            if layer_name == "Bathymetric":
                tree_widget.setColumnCount(2)
                tree_widget.setHeaderLabels(["Digital Bathymetric Terrain Model(s)", "Reference model"])
            # Get list of map layers in QgsProject
            layers = QgsProject.instance().mapLayers()
            layer_type_vector_raster=None
            if existing_files:
                file_paths=existing_files.split(',')
                for file_path in file_paths:
                    base_filename = os.path.splitext(os.path.basename(file_path))[0]
                    if layer_name == "Shoreline":
                        tree_widget.setColumnCount(1)
                        tree_widget.setHeaderLabels(["Shoreline"])
                        item = QTreeWidgetItem(tree_widget, [base_filename,file_path])
                        item.setCheckState(0, Qt.Checked)
                        # Add the item to the tree widget
                        tree_widget.addTopLevelItem(item)
                    if layer_name == "Topographic":
                        tree_widget.setColumnCount(1)
                        tree_widget.setHeaderLabels(["Shoreline"])
                        item = QTreeWidgetItem(tree_widget, [base_filename,file_path])
                        item.setCheckState(0, Qt.Checked)
                        # Add the item to the tree widget
                        tree_widget.addTopLevelItem(item)
                    if layer_name == "Bathymetric":
                        tree_widget.setColumnCount(2)
                        tree_widget.setHeaderLabels(["Digital Bathymetric Terrain Model(s)", "Reference model"])

                        # Create a new QTreeWidgetItem
                        item = QTreeWidgetItem(tree_widget)
                        item.setCheckState(0, Qt.Checked)
                        item.setText(0, base_filename)
                        width = QFontMetrics(tree_widget.font()).boundingRect(base_filename).width() + 20  # Adding extra padding
                        tree_widget.setColumnWidth(0, width)
                        
                        # Create a QComboBox widget for the third column
                        combo_box = QComboBox()
                        combo_box.addItems(["No", "Yes"])  # Add "Yes" and "No" options to the dropdown
                        combo_box.setFixedWidth(50)  # Set the width of the combo box

                        # Set the QComboBox as the item widget for the third column
                        tree_widget.setItemWidget(item, 1, combo_box)  # Assuming third column index is 2
                        item.setText(2, file_path)
                        
                        
                        # Add the item to the tree widget
                        tree_widget.addTopLevelItem(item)

            if layers:
                # Iterate through layers and add them to the tree widget
                for layer_id, layer in layers.items():
                    # Create a new tree item for the layer
                    if layer.type() == QgsMapLayerType.VectorLayer:
                        layer_type_vector_raster="Vector"
                    elif layer.type() == QgsMapLayerType.RasterLayer:
                        layer_type_vector_raster="Raster"
                    else:
                        print(f"{layer.name()} is neither a vector nor a raster layer.")
                    if layer_type_vector_raster == "Vector" and layer_name == "Shoreline":
                        tree_widget.setColumnCount(1)
                        tree_widget.setHeaderLabels(["Shoreline"])
                        item = QTreeWidgetItem(tree_widget, [layer.name(),layer.source()])
                        
                        # Set item flags to make it user-checkable
                        item.setFlags(item.flags() | Qt.ItemIsUserCheckable)
                        
                        # Set initial check state to unchecked
                        item.setCheckState(0, Qt.Unchecked)

                        # Add the item to the tree widget
                        tree_widget.addTopLevelItem(item)
                    if layer_name == "Topographic":
                        tree_widget.setColumnCount(1)
                        tree_widget.setHeaderLabels(["Topographic Contours"])
                    if layer_type_vector_raster == "Raster" and layer_name == "Bathymetric":
                        tree_widget.setColumnCount(2)
                        tree_widget.setHeaderLabels(["Digital Bathymetric Terrain Model(s)", "Reference model"])

                        # Create a new QTreeWidgetItem
                        item = QTreeWidgetItem(tree_widget)
                        

                        # Set item flags to make it user-checkable
                        item.setFlags(item.flags() | Qt.ItemIsUserCheckable)

                        # Set initial check state to unchecked
                        item.setCheckState(0, Qt.Unchecked)
                        item.setText(0, layer.name())
                        width = QFontMetrics(tree_widget.font()).boundingRect(layer.name()).width() + 20  # Adding extra padding
                        tree_widget.setColumnWidth(0, width)
                        
                        # Create a QComboBox widget for the third column
                        combo_box = QComboBox()
                        combo_box.addItems(["No", "Yes"])  # Add "Yes" and "No" options to the dropdown
                        combo_box.setFixedWidth(50)  # Set the width of the combo box

                        # Set the QComboBox as the item widget for the third column
                        tree_widget.setItemWidget(item, 1, combo_box)  # Assuming third column index is 2
                        item.setText(2, layer.source())
                        
                        
                        # Add the item to the tree widget
                        tree_widget.addTopLevelItem(item)
        except Exception as e:
            print(e)

    def fn_vertical_shift(self,ref_file_path,dem_file_path,folder_path,dem_file_length):
        final_file_path=None
        ref_file_name = os.path.splitext(os.path.basename(ref_file_path))[0]
        dem_file_name = os.path.splitext(os.path.basename(dem_file_path))[0]
        output_ref_pix_pnt=folder_path+"\\"+ref_file_name+".shp"
        output_dem_pix_pnt=folder_path+"\\"+dem_file_name+".shp"
        output_ref_buffer_dissolve=folder_path+"\\"+ref_file_name+"_buffer_dissolve.shp"
        output_dem_buffer_dissolve=folder_path+"\\"+dem_file_name+"_buffer_dissolve.shp"
        
        output_ref_dem_overlap=folder_path+"\\"+dem_file_name+"_"+ref_file_name+"_overlap.shp"
        if dem_file_length==1:
        
            processing.run("native:pixelstopoints", {
            'INPUT_RASTER':ref_file_path,
            'RASTER_BAND':1,
            'FIELD_NAME':'Depth (m)',
            'OUTPUT':output_ref_pix_pnt
            })

            processing.run("native:buffer", {
            'INPUT':output_ref_pix_pnt,
            'DISTANCE':50,
            'SEGMENTS':5,
            'END_CAP_STYLE':0,
            'JOIN_STYLE':0,
            'MITER_LIMIT':2,
            'DISSOLVE':True,
            'OUTPUT':output_ref_buffer_dissolve
            })

            

        processing.run("native:pixelstopoints", {
        'INPUT_RASTER':dem_file_path,
        'RASTER_BAND':1,
        'FIELD_NAME':'Depth (m)',
        'OUTPUT':output_dem_pix_pnt
        })


        processing.run("native:buffer", {
        'INPUT':output_dem_pix_pnt,
        'DISTANCE':50,
        'SEGMENTS':5,
        'END_CAP_STYLE':0,
        'JOIN_STYLE':0,
        'MITER_LIMIT':2,
        'DISSOLVE':True,
        'OUTPUT':output_dem_buffer_dissolve
        })

        

        processing.run("native:intersection", {
        'INPUT':output_dem_buffer_dissolve,
        'OVERLAY':output_ref_buffer_dissolve,
        'INPUT_FIELDS':[],
        'OVERLAY_FIELDS':[],
        'OVERLAY_FIELDS_PREFIX':'',
        'OUTPUT':output_ref_dem_overlap
        })

        intersection_layer = QgsVectorLayer(output_ref_dem_overlap, 'intersection', 'ogr')

        # Check if the input layer is loaded successfully
        if not intersection_layer.isValid():
            print("Error: Could not load the input layer")
            exit()

        

        # Calculate the area for each feature in the reprojected layer
        intersection_areas = None
        for feature in intersection_layer.getFeatures():
            geometry = feature.geometry()
            area = geometry.area()
            intersection_areas=area
            print("intersection",area)

        dem_area_layer = QgsVectorLayer(output_dem_buffer_dissolve, 'dem_area', 'ogr')

        # Check if the input layer is loaded successfully
        if not dem_area_layer.isValid():
            print("Error: Could not load the input layer")
            exit()

        

        # Calculate the area for each feature in the reprojected layer
        dem_area = None
        for feature in dem_area_layer.getFeatures():
            geometry = feature.geometry()
            area = geometry.area()
            dem_area=area
            print("dem",area)
        
        overlap_percentage=intersection_areas*100/dem_area
        print(overlap_percentage)
        if overlap_percentage>30:
            ref_layer = QgsRasterLayer(ref_file_path, 'ref_layer')
            dem_layer = QgsRasterLayer(dem_file_path, 'dem_layer')
            output_diff=folder_path+"\\output_diff.tif"
            # Define raster calculator entries
            ref_entry = QgsRasterCalculatorEntry()
            ref_entry.ref = 'ref_layer@1'  # Assuming the first band is used
            ref_entry.raster = ref_layer
            ref_entry.bandNumber = 1

            dem_entry = QgsRasterCalculatorEntry()
            dem_entry.ref = 'dem_layer@1'  # Assuming the first band is used
            dem_entry.raster = dem_layer
            dem_entry.bandNumber = 1

            # Define the expression to compute the difference
            expression = '"ref_layer@1" - "dem_layer@1"'

            # Execute raster calculator
            calc = QgsRasterCalculator(expression, output_diff, 'GTiff', ref_layer.extent(), ref_layer.width(), ref_layer.height(), [ref_entry, dem_entry])
            calc.processCalculation()

            mean_value=None
            # Open the raster file
            dataset = gdal.Open(output_diff)

            if dataset is None:
                print("Error: Could not open the raster file.")
            else:
                # Get raster band
                band = dataset.GetRasterBand(1)  # Assuming you're working with a single-band raster

                # Calculate raster statistics
                stats = band.GetStatistics(True, True)

                if stats is None:
                    print("Error: Could not calculate raster statistics.")
                else:
                    # Extract mean value from statistics
                    mean_value = stats[2]  # Index 2 corresponds to the mean value

                    

                # Close the dataset
                dataset = None
            print(mean_value)
            if mean_value>0.30:
                
                dem_layer = QgsRasterLayer(dem_file_path, 'dem_layer')
                
                final_file_path=folder_path+"\\"+dem_file_name+".tif"
                
                dem_entry = QgsRasterCalculatorEntry()
                dem_entry.ref = 'dem_layer@1'  # Assuming the first band is used
                dem_entry.raster = dem_layer
                dem_entry.bandNumber = 1
                
                # Define the expression to compute the difference
                expression = '"dem_layer@1" - (' + str(mean_value) + ')'
                
                # Execute raster calculator
                calc = QgsRasterCalculator(expression, final_dem, 'GTiff', dem_layer.extent(), dem_layer.width(), dem_layer.height(), [dem_entry])
                calc.processCalculation()
        return final_file_path
 
    def vertical_shift_functionality(self,ref_file_path,dem_file_path,folder_path):
        delete_file_names=[]
        final_file_path=None
        ref_file_name = os.path.splitext(os.path.basename(ref_file_path))[0]
        ref_raster_layer = QgsRasterLayer(ref_file_path, ref_file_name)
        ref_fpath = os.path.basename(ref_file_path)        
        ref_raster_crs = ref_raster_layer.crs().authid()               
        output_ref_reprojected_layer=folder_path+"\\ref_reprojected_"+ref_fpath
        processing.run("gdal:warpreproject", {

            'INPUT':ref_raster_layer,
            'SOURCE_CRS':QgsCoordinateReferenceSystem(ref_raster_crs),
            'TARGET_CRS':QgsCoordinateReferenceSystem('EPSG:4326'),
            'RESAMPLING':0,
            'NODATA':None,
            'TARGET_RESOLUTION':None,
            'OPTIONS':'',
            'DATA_TYPE':0,
            'TARGET_EXTENT':None,
            'TARGET_EXTENT_CRS':None,
            'MULTITHREADING':False,
            'EXTRA':'',
            'OUTPUT':output_ref_reprojected_layer
            })
        delete_file_names.append(output_ref_reprojected_layer)
        dem_file_name = os.path.splitext(os.path.basename(dem_file_path))[0]
        dem_raster_layer = QgsRasterLayer(dem_file_path, dem_file_name)
        dem_fpath = os.path.basename(dem_file_path)        
        dem_raster_crs = dem_raster_layer.crs().authid()               
        output_dem_reprojected_layer=folder_path+"\\dem_reprojected_"+dem_fpath
        processing.run("gdal:warpreproject", {

            'INPUT':dem_raster_layer,
            'SOURCE_CRS':QgsCoordinateReferenceSystem(dem_raster_crs),
            'TARGET_CRS':QgsCoordinateReferenceSystem('EPSG:4326'),
            'RESAMPLING':0,
            'NODATA':None,
            'TARGET_RESOLUTION':None,
            'OPTIONS':'',
            'DATA_TYPE':0,
            'TARGET_EXTENT':None,
            'TARGET_EXTENT_CRS':None,
            'MULTITHREADING':False,
            'EXTRA':'',
            'OUTPUT':output_dem_reprojected_layer
            })
        delete_file_names.append(output_dem_reprojected_layer)

        output_ref_extent_layer=folder_path+"\\ref_extent_"+ref_file_name
        processing.run("native:polygonfromlayerextent", {
            'INPUT':output_ref_reprojected_layer,
            'ROUND_TO':0,
            'OUTPUT':output_ref_extent_layer})
        delete_file_names.append(output_ref_extent_layer)
        
        output_dem_extent_layer=folder_path+"\\dem_extent_"+dem_file_name
        processing.run("native:polygonfromlayerextent", {
            'INPUT':output_dem_reprojected_layer,
            'ROUND_TO':0,
            'OUTPUT':output_dem_extent_layer})
        delete_file_names.append(output_dem_extent_layer)

        output_intersection=folder_path+"\\bounding_intersection.shp"
        input_ref_extent_file=output_ref_extent_layer+".gpkg"
        input_dem_extent_file=output_dem_extent_layer+".gpkg"
        processing.run("native:intersection", {
            'INPUT':input_ref_extent_file,
            'OVERLAY':input_dem_extent_file,
            'INPUT_FIELDS':[],
            'OVERLAY_FIELDS':[],
            'OVERLAY_FIELDS_PREFIX':'',
            'OUTPUT':output_intersection
            })
        delete_file_names.append(output_intersection)

        intersection_layer = QgsVectorLayer(output_intersection, 'intersection', 'ogr')

        # Check if the input layer is loaded successfully
        if not intersection_layer.isValid():
            print("Error: Could not load the input layer")
            exit()

        

        # Calculate the area for each feature in the reprojected layer
        intersection_areas = None
        for feature in intersection_layer.getFeatures():
            geometry = feature.geometry()
            area = geometry.area()
            intersection_areas=area

        dem_layer = QgsVectorLayer(input_dem_extent_file, 'dem layer', 'ogr')

        # Check if the input layer is loaded successfully
        if not dem_layer.isValid():
            print("Error: Could not load the input layer")
            exit()

        

        # Calculate the area for each feature in the reprojected layer
        dem_areas = None
        for feature in dem_layer.getFeatures():
            geometry = feature.geometry()
            area = geometry.area()
            dem_areas=area

        Overlapping=intersection_areas/dem_areas
        out_clip_ref_to_intersection=folder_path+"\\clip_ref_to_intersection.tif"
        out_clip_dem_to_intersection=folder_path+"\\clip_dem_to_intersection.tif"
        if Overlapping>0.3:
            processing.run("gdal:cliprasterbyextent", {
                'INPUT':ref_file_path,
                'PROJWIN':intersection_layer,
                'OVERCRS':False,
                'NODATA':None,
                'OPTIONS':'',
                'DATA_TYPE':0,
                'EXTRA':'',
                'OUTPUT':out_clip_ref_to_intersection
                })
            delete_file_names.append(out_clip_ref_to_intersection)
            
            processing.run("gdal:cliprasterbyextent", {
                'INPUT':dem_file_path,
                'PROJWIN':intersection_layer,
                'OVERCRS':False,
                'NODATA':None,
                'OPTIONS':'',
                'DATA_TYPE':0,
                'EXTRA':'',
                'OUTPUT':out_clip_dem_to_intersection
                })
            
            delete_file_names.append(out_clip_dem_to_intersection)
            clip_ref_to_intersection = QgsRasterLayer(out_clip_ref_to_intersection, 'clip_ref_to_intersection')
            clip_dem_to_intersection = QgsRasterLayer(out_clip_dem_to_intersection, 'clip_dem_to_intersection')
            output_dem=folder_path+"\\output_dem.tif"
            # Define raster calculator entries
            ref_entry = QgsRasterCalculatorEntry()
            ref_entry.ref = 'clip_ref_to_intersection@1'  # Assuming the first band is used
            ref_entry.raster = clip_ref_to_intersection
            ref_entry.bandNumber = 1

            dem_entry = QgsRasterCalculatorEntry()
            dem_entry.ref = 'clip_dem_to_intersection@1'  # Assuming the first band is used
            dem_entry.raster = clip_dem_to_intersection
            dem_entry.bandNumber = 1

            # Define the expression to compute the difference
            expression = '"clip_ref_to_intersection@1" - "clip_dem_to_intersection@1"'

            # Execute raster calculator
            calc = QgsRasterCalculator(expression, output_dem, 'GTiff', clip_ref_to_intersection.extent(), clip_ref_to_intersection.width(), clip_ref_to_intersection.height(), [ref_entry, dem_entry])
            calc.processCalculation()
            delete_file_names.append(output_dem)
            mean_value=None
            # Open the raster file
            dataset = gdal.Open(output_dem)

            if dataset is None:
                print("Error: Could not open the raster file.")
            else:
                # Get raster band
                band = dataset.GetRasterBand(1)  # Assuming you're working with a single-band raster

                # Calculate raster statistics
                stats = band.GetStatistics(True, True)

                if stats is None:
                    print("Error: Could not calculate raster statistics.")
                else:
                    # Extract mean value from statistics
                    mean_value = stats[2]  # Index 2 corresponds to the mean value

                    

                # Close the dataset
                dataset = None
            print(mean_value)
            if mean_value>0.3:
                print(mean_value)
                dem_layer = QgsRasterLayer(dem_file_path, 'dem_layer')
                
                final_file_path=folder_path+"\\"+dem_file_name+".tif"
                
                dem_entry = QgsRasterCalculatorEntry()
                dem_entry.ref = 'dem_layer@1'  # Assuming the first band is used
                dem_entry.raster = dem_layer
                dem_entry.bandNumber = 1
                
                # Define the expression to compute the difference
                expression = '"dem_layer@1" - (' + str(mean_value) + ')'
                
                # Execute raster calculator
                calc = QgsRasterCalculator(expression, final_dem, 'GTiff', dem_layer.extent(), dem_layer.width(), dem_layer.height(), [dem_entry])
                calc.processCalculation()
        
        if delete_file_names:  # Check if the list is not empty
            for file_name in delete_file_names:
                try:
                    os.remove(file_name)  # Delete the file
                    print(f"File '{file_name}' deleted successfully.")
                except Exception as e:
                    print(f"Error deleting file '{file_name}': {e}")
        else:
            print("The list of file names to delete is empty.")

        return final_file_path

    def check_layer_type(self):
        # Get reference to QgsProject
        project = QgsProject.instance()

        # Get all map layers in QgsProject
        layers = project.mapLayers()

        # Iterate over layers and check their types
        for layer_id, layer in layers.items():
            if layer.type() == QgsMapLayer.VectorLayer:                
                if layer.geometryType() == QgsWkbTypes.LineGeometry:
                    print("Line")
    
    #Showing the map extent menu when button clicked
    def showMenu(self):
        self.dlg.defaultHelpContent.setVisible(False)
        self.dlg.HelpMapExtent.setVisible(True)
        self.dlg.HelpShoreline.setVisible(False)
        self.dlg.HelpTopographicContours.setVisible(False)
        self.dlg.HelpDigitalBathy.setVisible(False)
        self.dlg.HelpSounding.setVisible(False)
        # Show the menu at the position of the button
        self.main_menu.exec_(self.dlg.tlbtn_mapextent.mapToGlobal(self.dlg.tlbtn_mapextent.rect().bottomLeft()))

    #Map extent menu
    def load_layeras_submenu(self):
        
        # Create the main menu and submenu
        self.main_menu = QMenu()
        self.main_menu.addAction("Draw on Canvas ",self.start_rectangle_drawing)
        self.main_menu.addAction("Calculate from File",self.action_from_external_files)
        
        layers = QgsProject.instance().mapLayers()  # Get all layers
        self.layers_submenu = QMenu('Calculate from Layer')
        
        
        
        if layers:
            i=1
            for layer_id, layer in layers.items(): 
                if layer.type() == QgsMapLayer.VectorLayer:                
                    if layer.geometryType() == QgsWkbTypes.LineGeometry:
                
                        if i==1:
                                        
                            self.layer_action1 = QAction(layer.name())
                            self.layer_action1.triggered.connect(lambda checked, layer=layer: self.onLayerSelected(layer))
                            self.layers_submenu.addAction(self.layer_action1)
                        elif i==2:
                            
                            self.layer_action2 = QAction(layer.name())
                            self.layer_action2.triggered.connect(lambda checked, layer=layer: self.onLayerSelected(layer))
                            self.layers_submenu.addAction(self.layer_action2)

                        elif i==3:
                            self.layer_action3 = QAction(layer.name())
                            self.layer_action3.triggered.connect(lambda checked, layer=layer: self.onLayerSelected(layer))
                            self.layers_submenu.addAction(self.layer_action3)
                        elif i==4:
                            self.layer_action4 = QAction(layer.name())
                            self.layer_action4.triggered.connect(lambda checked, layer=layer: self.onLayerSelected(layer))
                            self.layers_submenu.addAction(self.layer_action4)
                        elif i==5:
                            self.layer_action5 = QAction(layer.name())
                            self.layer_action5.triggered.connect(lambda checked, layer=layer: self.onLayerSelected(layer))
                            self.layers_submenu.addAction(self.layer_action5)
                        elif i==6:
                            self.layer_action6 = QAction(layer.name())
                            self.layer_action6.triggered.connect(lambda checked, layer=layer: self.onLayerSelected(layer))
                            self.layers_submenu.addAction(self.layer_action6)
                        elif i==7:
                            self.layer_action7 = QAction(layer.name())
                            self.layer_action7.triggered.connect(lambda checked, layer=layer: self.onLayerSelected(layer))
                            self.layers_submenu.addAction(self.layer_action7)
                        elif i==8:
                            self.layer_action8 = QAction(layer.name())
                            self.layer_action8.triggered.connect(lambda checked, layer=layer: self.onLayerSelected(layer))
                            self.layers_submenu.addAction(self.layer_action8)
                        elif i==9:
                            self.layer_action9 = QAction(layer.name())
                            self.layer_action9.triggered.connect(lambda checked, layer=layer: self.onLayerSelected(layer))
                            self.layers_submenu.addAction(self.layer_action9)
                        else:
                            self.layer_action10 = QAction(layer.name())
                            self.layer_action10.triggered.connect(lambda checked, layer=layer: self.onLayerSelected(layer))
                            self.layers_submenu.addAction(self.layer_action10)
                        i=i+1
        
        # Add the submenu to the main menu
        self.main_menu.addMenu(self.layers_submenu)
    
    #Draw on canvas rectangle drawing
    def start_rectangle_drawing(self):        
        
        self.dlg.showMinimized()
        # Create or reset the map tool
        if self.rectangle_map_tool:            
            # If the existing rectangle_map_tool exists, deactivate it
            self.iface.mapCanvas().unsetMapTool(self.rectangle_map_tool)
            self.rectangle_map_tool = None  # Reset the reference to None

        # Create a new instance of RectangleMapTool
        self.rectangle_map_tool = RectangleMapTool(self.iface.mapCanvas(), self.dlg.lnEd_mapextent, self.dlg, self.ChartLimits_WGS84_path,self.dlg.scale,self.dlg.textEdit_log)
        # Set the new rectangle_map_tool as the active map tool
        self.iface.mapCanvas().setMapTool(self.rectangle_map_tool)
        
        file_path='C:/Temp/UMapProcessing/chartlimit.gpkg'
             
        self.ChartLimits_WGS84_path=file_path
    
    #Browsing the files from map extent menu "Calculate from File"
    def action_from_external_files(self):


        files=""
        file_filter = "(*.shp *.gpkg)"
        file_paths, selected_filter = QFileDialog.getOpenFileNames(
            None,
            "Select Files",
            "",
            file_filter
        )
        
        
        
        for file_path in file_paths:
            # Check if a file was selected
            if file_path:
                layer = QgsVectorLayer(file_path, "temporary_layer", "ogr")
        
                # Check if the layer was loaded successfully
                if layer.isValid():
                    # Check the geometry type of the layer
                    geometry_type = layer.geometryType()
                    # Check if the geometry type is line
                    if geometry_type == QgsWkbTypes.LineGeometry:
                        self.ChartLimits_WGS84_path=file_path
                        self.add_shapefile_to_map(file_path)
                    else:
                        self.show_alert_message("Please select the polyline type file.")
                    self.canvas_zoom_to_complication(self.ChartLimits_WGS84_path)
                    
            
            
        self.load_layeras_submenu()

    #Calculate map extents from layer 
    def onLayerSelected(self, layer):
        # Handle layer selection here
        layer_extent = QgsRectangle(layer.extent())
        extent_text = f"{layer_extent.xMinimum()},{layer_extent.xMaximum()},{layer_extent.yMinimum()},{layer_extent.yMaximum()}"
        layer_project=layer.crs()
        self.dlg.lnEd_mapextent.setText(extent_text)
        self.map_extents_alert(layer_extent,layer_project,layer.name())
        self.ChartLimits_WGS84_path=layer.source() 
        self.canvas_zoom_to_complication(self.ChartLimits_WGS84_path)  

    #validating the map extent whether max or min and raise the alert message
    def map_extents_alert(self,layer_extent,layer_projec,filename):
        
        current_area=""
        if "EPSG:4326" in layer_projec.authid():
            lat2=layer_extent.yMaximum()
            lat1=layer_extent.yMinimum()
            lon2=layer_extent.xMaximum()
            lon1=layer_extent.xMinimum()

            delta_lat = abs(lat2 - lat1)

            delta_lon = abs(lon2 - lon1)

            avg_lat = (lat1 + lat2) / 2

    

            area_lat = delta_lat * 111319.9  # 1 degree of latitude is approximately 111,319.9 meters

            area_lon = delta_lon * 111319.9 * math.cos(math.radians(avg_lat))

            current_area = area_lat * area_lon
        else:
            lat2=layer_extent.yMaximum()
            lat1=layer_extent.yMinimum()
            lon2=layer_extent.xMaximum()
            lon1=layer_extent.xMinimum()

            delta_lat = abs(lat2 - lat1)

            delta_lon = abs(lon2 - lon1)

            current_area=delta_lat* delta_lon
        

        log_text=f"Map Extent calculated from file {filename}; Area = {current_area}m2"
        self.dlg.textEdit_log.setText(log_text)
        max_allowed_area = 1.225E+11
        
        if current_area > max_allowed_area:
            # Show a warning message if the extent exceeds the maximum area
            
            message=f"The current Map Extent is too large.\nPlease reduce it to less than {max_allowed_area} square meters"                
            
            self.show_alert_message(message)
        else:
            extent_text = f"{layer_extent.xMinimum()},{layer_extent.xMaximum()},{layer_extent.yMinimum()},{layer_extent.yMaximum()}"            
            self.dlg.lnEd_mapextent.setText(extent_text)
            self.complicationscale_change_by_mapextents(current_area)
 
    #Selecting the compilaction scale based on map extents area
    def complicationscale_change_by_mapextents(self,mapextents_area):
        mapextents_area_round=round(mapextents_area)

        if mapextents_area==64000000:
            self.dlg.scale.setCurrentText("1:8000")
        elif mapextents_area_round > 64000000 and mapextents_area_round <= 144000000:
            self.dlg.scale.setCurrentText("1:12000")
        elif mapextents_area_round > 144000000 and mapextents_area_round <= 484000000:
            self.dlg.scale.setCurrentText("1:22000")
        elif mapextents_area_round > 484000000 and mapextents_area_round <= 2025000000:
            self.dlg.scale.setCurrentText("1:45000")
        elif mapextents_area_round > 2025000000 and mapextents_area_round <= 8100000000:
            self.dlg.scale.setCurrentText("1:90000")
        elif mapextents_area_round > 8100000000 and mapextents_area_round <= 32400000000:
            self.dlg.scale.setCurrentText("1:180000")
        elif mapextents_area_round > 32400000000 and mapextents_area_round <= 122500000000:
            self.dlg.scale.setCurrentText("1:350000")
        else:
            message=f"The current Map Extent is less than 64000000 square meters"
            self.show_alert_message(message)   

    #Function for alert messages
    def show_alert_message(self,message):
        # Create a QMessageBox
        alert = QMessageBox()
        
        # Set the message text and other properties
        alert.setText(message)
        alert.setWindowTitle("Alert")
        alert.setIcon(QMessageBox.Warning)  # Set the icon type (could be Information, Warning, Critical, etc.)
        
        # Add buttons (optional)
        alert.addButton(QMessageBox.Ok)
        # You can add more buttons if needed using addButton()
        # alert.addButton(QMessageBox.Cancel)
        
        # Show the alert message
        alert.exec_()

    #Reading the extents from selected file
    def add_shapefile_to_map(self, file_path):
        
        # Get the base filename without the extension
        base_filename = os.path.splitext(os.path.basename(file_path))[0]
        
        # Remove the ".shp" extension
        filename_without_extension = base_filename.replace('.shp', '')

        layer = QgsVectorLayer(file_path, filename_without_extension, "ogr")
        layer_extent = QgsRectangle(layer.extent())
        
        layer_project=layer.crs()
        self.map_extents_alert(layer_extent,layer_project,base_filename)
        if not layer.isValid():
            iface.messageBar().pushMessage("Error", "Invalid layer!", level=Qgis.Critical)
            return
        
        canvas = self.iface.mapCanvas()

        # Get the coordinate transform context
        transform_context = QgsCoordinateTransformContext()

        # Create a coordinate transform from the layer's CRS to the map canvas CRS
        transform = QgsCoordinateTransform(layer.crs(), canvas.mapSettings().destinationCrs(), transform_context)

        # Convert the layer extent to the map canvas extent
        converted_extent = transform.transformBoundingBox(layer_extent)

        #canvas = self.iface.mapCanvas()

        # Set the extent for the map canvas
        canvas.setExtent(layer_extent)

        # Refresh the canvas
        canvas.refresh()
        
        #QgsProject.instance().addMapLayer(layer)

    #Appending log data
    def append_log_message(self, message, level=Qgis.Info):
        # Append log messages to QTextEdit
        self.dlg.textEdit_log.append(message)
        self.dlg.textEdit_log.verticalScrollBar().setValue(self.dlg.textEdit_log.verticalScrollBar().maximum())

    #Showing success message
    def show_success_message(self, message):
        
        QMessageBox.information(None, "Success", message) 
        self.dlg.lnEd_mapextent.clear()  
        self.dlg.lnEd_shoreline.clear() 
        self.dlg.lnEd_topographic.clear() 
        self.dlg.lnEd_bathy.clear()
        self.dlg.progressBar_2.setValue(0)
        self.dlg.btn_run.setVisible(True)
        self.dlg.btn_cancel.setVisible(False)
        self.dlg.btn_close.setEnabled(True)

#Draw on canvas
class RectangleMapTool(QgsMapToolEmitPoint):

    def __init__(self, canvas,lineEdit_5,custom_dialog,chartlimit_path,scale,textEdit_log):
        self.canvas = canvas
        self.coordinates_textbox = lineEdit_5
        self.cc=custom_dialog
        self.ChartLimits_WGS84_path=chartlimit_path
        self.scale = scale
        self.textEdit_log= textEdit_log

        QgsMapToolEmitPoint.__init__(self, self.canvas)
        self.rubberBand = QgsRubberBand(self.canvas, QgsWkbTypes.PolygonGeometry)
        self.rubberBand.setColor(QColor(0, 0, 255, 30))
        self.rubberBand.setWidth(1)
        self.reset()
        self.isEmittingPoint = False
        self.startPoint_create = None

    def reset(self):
        self.startPoint = self.endPoint = None
        self.isEmittingPoint = False
        self.rubberBand.reset(QgsWkbTypes.PolygonGeometry)

    def canvasPressEvent(self, e):
        self.startPoint = self.toMapCoordinates(e.pos())
        self.startPoint_create=self.toMapCoordinates(e.pos())
        self.endPoint = self.startPoint
        self.isEmittingPoint = True
        self.showRect(self.startPoint, self.endPoint)
        

    def canvasReleaseEvent(self, e):
        self.isEmittingPoint = False
        r = self.rectangle()
        if r is not None:
            extent=f"{r.xMinimum()},{r.xMaximum()}, {r.yMinimum()}, {r.yMaximum()}"
            if self.startPoint_create is not None:
                endPoint_create = self.toMapCoordinates(e.pos())
                # Calculate rectangle coordinates
                x_min = min(self.startPoint_create.x(), endPoint_create.x())
                x_max = max(self.startPoint_create.x(), endPoint_create.x())
                y_min = min(self.startPoint_create.y(), endPoint_create.y())
                y_max = max(self.startPoint_create.y(), endPoint_create.y())

                # Create a QgsRectangle object
                rectangle = QgsRectangle(x_min, y_min, x_max, y_max)
                
                # Create a QgsVectorLayer with the rectangle geometry
                rect_layer = QgsVectorLayer("Polygon?crs={}".format(self.canvas.mapSettings().destinationCrs().authid()), "rectangle", "memory")
                feature = QgsFeature()
                feature.setGeometry(QgsGeometry.fromRect(rectangle))
                rect_layer.startEditing()
                rect_layer.dataProvider().addFeatures([feature])
                rect_layer.commitChanges()
                directory="C:/Temp/UMapProcessing"
                if not os.path.exists(directory):                
                    os.makedirs(directory)
                else:
                    self.delete_files_in_directory('C:/Temp/UMapProcessing')
                    # If it exists, delete the contents of the directory
                    for filename in os.listdir(directory):
                        file_path = os.path.join(directory, filename)
                        try:
                            if os.path.isfile(file_path) or os.path.islink(file_path):
                                os.unlink(file_path)
                            elif os.path.isdir(file_path):
                                shutil.rmtree(file_path)
                        except Exception as e:
                            print('Failed to delete %s. Reason: %s' % (file_path, e))

                # Write the layer to a GeoPackage file
                file_path = directory+'/file.gpkg'  # Specify the file path

                target_crs_4326 = QgsCoordinateReferenceSystem('EPSG:4326')
               
                error = QgsVectorFileWriter.writeAsVectorFormat(rect_layer, file_path, "UTF-8", target_crs_4326, "GPKG")
                
                #error = QgsVectorFileWriter.writeAsVectorFormat(rect_layer, file_path, "UTF-8", rect_layer.crs(), "GPKG")
                output_chartlimit=directory+'/chartlimit.gpkg'
                try:
                    # Run the processing algorithm
                    processing.run("native:polygonstolines", {'INPUT': file_path, 'OUTPUT': output_chartlimit})
                    
                    # Get extent of the output layer
                    extent_output = self.get_extent(output_chartlimit)
                    #self.map_extents_alert2(extent_output.exten)
                    print("extent_output",extent_output)   
                      
                     
                    if extent_output is not None:
                        # Convert the tuple to a string representation
                        extent_str = ", ".join(str(coord) for coord in extent_output)
                        print("Extent of the output layer:", extent_str)
                        # Set the text of the textbox
                        self.coordinates_textbox.setText(extent_str) 
                    else:
                        print("Error occurred while getting the extent of the output layer.")
                
                except Exception as e:
                    print("Error occurred during processing:", str(e))

                

                self.startPoint_create = None
            #self.coordinates_textbox.setText(extent)
        self.reset()
        self.cc.showNormal()
        self.deactivate()
        
    def delete_files_in_directory(self,directory):
        """
        Delete all files in the specified directory.
        """
        # Get a list of all files in the directory
        files = os.listdir(directory)
        
        # Iterate through the files and delete them
        for file in files:
            file_path = os.path.join(directory, file)
            try:
                if os.path.isfile(file_path):
                    os.remove(file_path)
                    print(f"Deleted file: {file_path}")
            except Exception as e:
                print(f"Failed to delete file: {file_path}. Reason: {e}")

    def show_alert_message(self,message):
        # Create a QMessageBox
        alert = QMessageBox()
        
        # Set the message text and other properties
        alert.setText(message)
        alert.setWindowTitle("Alert")
        alert.setIcon(QMessageBox.Warning)  # Set the icon type (could be Information, Warning, Critical, etc.)
        
        # Add buttons (optional)
        alert.addButton(QMessageBox.Ok)
        # You can add more buttons if needed using addButton()
        # alert.addButton(QMessageBox.Cancel)
        
        # Show the alert message
        alert.exec_()

    def get_extent(self,layer_path):
        # Load the layer
        layer = QgsVectorLayer(layer_path, '', 'ogr')
        
        # Check if the layer loaded successfully
        if not layer.isValid():
            print("Error: Layer not loaded")
            return None

        # Get the extent of the layer
        extent = layer.extent()
        print("source layer extent",extent)
        # Get the layer's current coordinate reference system (CRS)
        source_crs = layer.crs()
        source_crs_id=source_crs.authid() 

        #UMap.map_extents_alert(self.extent,source_crs,layer.name())
        #self.map_extents_alert2(extent,source_crs,layer.name())

        print("source crs id", source_crs_id)
        if source_crs_id !='EPSG:4326':

            # Define the target CRS (EPSG:4326)
            target_crs = QgsCoordinateReferenceSystem('EPSG:4326')

            # Create a coordinate transform object
            coord_transform = QgsCoordinateTransform(source_crs, target_crs, QgsProject.instance()) 
            
            # Transform the extent to EPSG:4326
            transformed_extent = coord_transform.transformBoundingBox(extent)

            # Print the transformed extent
            print("transformed_extent",transformed_extent)      
            self.map_extents_alert2(transformed_extent,target_crs,layer.name())
      
            return transformed_extent.xMinimum(), transformed_extent.xMaximum(), transformed_extent.yMinimum(), transformed_extent.yMaximum()
        else:
            self.map_extents_alert2(extent,source_crs,layer.name())
        # Return the extent as a tuple (xmin, ymin, xmax, ymax)
            return extent.xMinimum(), extent.xMaximum(), extent.yMinimum(), extent.yMaximum()
        #return transformed_extent.xMinimum(), transformed_extent.xMaximum(), transformed_extent.yMinimum(), transformed_extent.yMaximum()

    def map_extents_alert2(self,layer_extent,layer_projec,filename):

        print("new layer_extent",layer_extent)
        
        current_area=""
        if "EPSG:4326" in layer_projec.authid():
            lat2=layer_extent.yMaximum()
            lat1=layer_extent.yMinimum()
            lon2=layer_extent.xMaximum()
            lon1=layer_extent.xMinimum()

            delta_lat = abs(lat2 - lat1)

            delta_lon = abs(lon2 - lon1)

            avg_lat = (lat1 + lat2) / 2

    

            area_lat = delta_lat * 111319.9  # 1 degree of latitude is approximately 111,319.9 meters

            area_lon = delta_lon * 111319.9 * math.cos(math.radians(avg_lat))

            current_area = area_lat * area_lon
        else:
            lat2=layer_extent.yMaximum()
            lat1=layer_extent.yMinimum()
            lon2=layer_extent.xMaximum()
            lon1=layer_extent.xMinimum()

            delta_lat = abs(lat2 - lat1)

            delta_lon = abs(lon2 - lon1)

            current_area=delta_lat* delta_lon
        

        log_text=f"Map Extent calculated from file {filename}; Area = {current_area}m2"
        self.textEdit_log.setText(log_text)
        max_allowed_area = 1.225E+11
        
        if current_area > max_allowed_area:
            # Show a warning message if the extent exceeds the maximum area
            
            message=f"The current Map Extent is too large.\nPlease reduce it to less than {max_allowed_area} square meters"                
            
            self.show_alert_message(message)
        else:
            extent_text = f"{layer_extent.xMinimum()},{layer_extent.xMaximum()},{layer_extent.yMinimum()},{layer_extent.yMaximum()}"            
            self.coordinates_textbox.setText(extent_text)
            self.complicationscale_change_by_mapextents2(current_area)

    
    
    def complicationscale_change_by_mapextents2(self,mapextents_area):
        mapextents_area_round=round(mapextents_area)

        if mapextents_area==64000000:
            self.scale.setCurrentText("1:8000")
        elif mapextents_area_round > 64000000 and mapextents_area_round <= 144000000:
            self.scale.setCurrentText("1:12000")
        elif mapextents_area_round > 144000000 and mapextents_area_round <= 484000000:
            self.scale.setCurrentText("1:22000")
        elif mapextents_area_round > 484000000 and mapextents_area_round <= 2025000000:
            self.scale.setCurrentText("1:45000")
        elif mapextents_area_round > 2025000000 and mapextents_area_round <= 8100000000:
            self.scale.setCurrentText("1:90000")
        elif mapextents_area_round > 8100000000 and mapextents_area_round <= 32400000000:
            self.scale.setCurrentText("1:180000")
        elif mapextents_area_round > 32400000000 and mapextents_area_round <= 122500000000:
            self.scale.setCurrentText("1:350000")
        else:
            message=f"The current Map Extent is less than 64000000 square meters"
            self.show_alert_message(message)

    def canvasMoveEvent(self, e):
        if not self.isEmittingPoint:
            return

        self.endPoint = self.toMapCoordinates(e.pos())
        self.showRect(self.startPoint, self.endPoint)

    def showRect(self, startPoint, endPoint):
        self.rubberBand.reset(QgsWkbTypes.PolygonGeometry)
        if startPoint.x() == endPoint.x() or startPoint.y() == endPoint.y():
            return

        point1 = QgsPointXY(startPoint.x(), startPoint.y())
        point2 = QgsPointXY(startPoint.x(), endPoint.y())
        point3 = QgsPointXY(endPoint.x(), endPoint.y())
        point4 = QgsPointXY(endPoint.x(), startPoint.y())

        self.rubberBand.addPoint(point1, False)
        self.rubberBand.addPoint(point2, False)
        self.rubberBand.addPoint(point3, False)
        self.rubberBand.addPoint(point4, True)    # true to update canvas
        self.rubberBand.show()

    def rectangle(self):
        if self.startPoint is None or self.endPoint is None:
            return None
        elif (self.startPoint.x() == self.endPoint.x() or \
            self.startPoint.y() == self.endPoint.y()):
            return None

        return QgsRectangle(self.startPoint, self.endPoint)

    def deactivate(self):
        self.canvas.unsetMapTool(self)
