import os
import re
from qgis.core import QgsProject, QgsMapLayer

output_folder = r""
os.makedirs(output_folder, exist_ok=True)

def sanitize_filename(name):
    return re.sub(r'[^\w\d_-]', '_', name)

def get_export_name(layer):
    uri = layer.dataProvider().dataSourceUri()

    # GeoPackage (layername=...)
    if ".gpkg" in uri.lower():
        match = re.search(r'layername=([\w\d_]+)', uri)
        if match:
            return match.group(1)

    # PostGIS та інші БД (table=...)
    if "table=" in uri.lower():
        match = re.search(r'table\s*=\s*[\'"]?(?:[\w\d_]+\.)?([\w\d_]+)', uri)
        if match:
            return match.group(1)

    # Звичайні файли — беремо назву файлу
    path = layer.source()
    return os.path.splitext(os.path.basename(path))[0]

# Експортуємо стилі
for layer in QgsProject.instance().mapLayers().values():
    if not layer.source():
        continue

    base_name = sanitize_filename(get_export_name(layer))
    qml_path = os.path.join(output_folder, f"{base_name}.qml")

    try:
        layer.saveNamedStyle(qml_path, QgsMapLayer.StyleCategory.Symbology | QgsMapLayer.StyleCategory.Labeling)
        print(f"✅ Збережено стиль: {qml_path}")
    except Exception as e:
        print(f"❌ Помилка для шару {layer.source()}: {e}")
 
