import sys
from helpers.control_file import convert_control_file
from helpers.settings import ConvertSettings, FatalConvertException


__VERSION__ = 0.2


def main():
    """
    Tool to convert model to a specified TUFLOW supported vector and raster format.

    required inputs:
        -tcf <file path to tcf>

    optional inputs:
        -o <path to output folder>
        -op [{SEPARATE} | CF | TCF] - output profile, groups GPKG separately, by control file, or by TCF (all in one)
        -gis [{GPKG} | SHP | MIF] - output vector format the model will be converted into
        -grid [GPKG | {TIF} | ASC | FLT] - output raster format the model will be converted into
        -rf <path to root folder> - optional argument to specify the root folder (conventionally named 'TUFLOW')
    """

    print(f'Version: {__VERSION__}')
    settings = ConvertSettings(*sys.argv)
    try:
        settings.read_tcf()  # initial pass reading TCF to pull out some info
    except FatalConvertException as e:
        print(f'Error reading TCF: {e}')
        exit(1)

    try:
        convert_control_file(settings.tcf, settings)  # primary routine
    except FatalConvertException as e:
        print(f'Error converting model: {e}')
        exit(1)

    if settings.errors:
        print(f'\nFinished but some errors did occur - search output for "Error": {settings.model_name}')
    else:
        print(f'\nSuccessfully converted model: {settings.model_name}')


if __name__ == '__main__':
    main()
