# Convert TUFLOW Model GIS Format

Python script that will convert a given TUFLOW model's vector and raster GIS files 
into another, or same, supported TUFLOW format. The script is similar to the package model
functionality that exists in TUFLOW and will try and package files from all
scenarios/events. The difference between the package model functionality and this script
is that this script will perform additional format conversion steps and update relevant control files.

The tool also gives additional options when converting to GPKG vector and raster formats. The
GPKG format is a database and allows multiple layers within one file (including a mixture of vector and raster)
and the tool gives the option to convert into:

- each layer into separate GPKG databases
- group layers into GPKGs that corresponds to each control file
- output all layers into a single GPKG database

## Supported formats

### Vector formats

- MIF
- SHP
- GPKG

### Raster formats

- ASC
- FLT
- GeoTIFF
- GPKG

## Dependencies

- Python 3.8+
- GDAL
- Numpy

## Quickstart

`python convert_tuflow_gis_format.py -tcf <filepath_to_tcf>`

Selecting an output vector format:

`python convert_tuflow_gis_format.py -tcf <filepath_to_tcf> -gis <vector_format>`

Selecting an output raster format:

`python convert_tuflow_gis_format.py -tcf <filepath_to_tcf> -grid <raster_format>`

Selecting an output profile with GPKG:

`python convert_tuflow_gis_format.py -tcf <filepath_to_tcf> -gis GPKG -op <output_profile>`

Choosing an output folder:

`python convert_tuflow_gis_format.py -tcf <filepath_to_tcf> -o <path_to_output_folder>`

## Options

required inputs:

- `-tcf [file path to tcf]`

optional inputs:

- `-o [path to output folder]`
- `-op [{SEPARATE} | CF | TCF]` - output profile, groups GPKG separately, by control file, or by TCF (all in one)
- `-gis [{GPKG} | SHP | MIF]` - output vector format the model will be converted into
- `-grid [GPKG | {TIF} | ASC | FLT]` - output raster format the model will be converted into
- `-rf [path to root folder]` - optional argument to specify the root folder (conventionally named 'TUFLOW')

## Windows Installation

The easiest way to install GDAL Python bindings is to use [Gohlke Grabber](https://pypi.org/project/gohlkegrabber/)

1. Install Gohlke Grabber via pip<Br>
`pip install gohlkegrabber`
2. Use Gohlke Grabber to download the appropriate pre-compiled GDAL Python wheel<br>
`ggrab c:\temp gdal`
4. The location of the download should be printed in the console after step 2 and can now be installed via pip<Br>
`pip install c:\temp\<gdal download.whl>`

You can then optionally delete the downloaded wheel

- `rm c:\temp\<gdal download.whl>`

You can also uninstall Gohlke Grabber if you like

- `pip uninstall gohlkegrabber`

Install Numpy

- `pip install numpy`

## Support

For any issues please get into contact with [support@tuflow.com](mailto:support@tuflow.com).

## License
This project is licensed under GNU GENERAL PUBLIC LICENSE Version 3.

## Changelog

- 0.1
  - First version