import unittest
from pathlib import Path
from .test_function import TestFunction


TEMPLATE_FOLDER = Path(__file__).parent / r'./nonstnd_dir/templates'


class TestNonStdDir(unittest.TestCase):

    def test_nonstd_dir_1(self):
        tcf = Path(__file__).parent / r'./nonstnd_dir/TUFLOW/runs/design/model.tcf'

        test_folder_name = 'nonstnd_dir_1'
        out_folder = tcf.parent / test_folder_name
        template_dir = TEMPLATE_FOLDER / test_folder_name

        gis = 'gpkg'
        grid = 'tif'
        op = 'tcf'


        args = ['-tcf', str(tcf), '-o', str(out_folder), '-gis', gis, '-grid', grid, '-op', op, '-verbose', 'off',
                '-always-use-root-dir']
        test = TestFunction()
        test.conversion_test(args, template_dir, exclude='projection')
