import unittest
from pathlib import Path
from .test_function import TestFunction


TEMPLATE_FOLDER = Path(__file__).parent / r'./mif_with_1d_ref/templates'


class TestMif1DRef(unittest.TestCase):

    def test_mif_1d_ref(self):
        tcf = Path(__file__).parent / r'./mif_with_1d_ref/TUFLOW/runs/model.tcf'

        test_folder_name = 'mif_with_1d_ref_1'
        out_folder = tcf.parent / test_folder_name
        template_dir = TEMPLATE_FOLDER / test_folder_name

        gis = 'gpkg'
        grid = 'tif'
        op = 'tcf'

        args = ['-tcf', str(tcf), '-o', str(out_folder), '-gis', gis, '-grid', grid, '-op', op, '-verbose', 'off',
                '-always-use-root-dir']
        test = TestFunction()
        test.conversion_test(args, template_dir, exclude='projection')
