# -*- coding: utf-8 -*-
"""
/***************************************************************************
 TSManager
                                 A QGIS plugin
 The LTG Api plugin for QGIS is a powerful tool that enables users to seamlessly interact with online Live Tech Geo API. With this plugin, users can upload static GIS files, including MBTiles and other static files, for later use. Additionally, it allows for the conversion of vector files into various formats such as shapefile, geojson, kml, and mbtiles, which can then be published to a new table in PostGIS, making them accessible as XYZ tiles. Furthermore, users can upload custom styles to enhance their data visualization. The plugin also provides a convenient way to browse static GIS files hosted on the server and explore pg_featureserv endpoints, making it a comprehensive solution for working with online LTG API in QGIS.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-07-11
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Tech Maven Geospatial
        email                : jordan@techmaven.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon,QPixmap
from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt import QtWidgets

from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QApplication

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .TS_Manager_dialog import TSManagerDialog
import os.path
from .Dialogs.LoginDialog import LoginDialog

class TSManager:
    """QGIS Plugin Implementation."""
    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        QApplication.setAttribute(Qt.AA_ShareOpenGLContexts, True)

        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'TSManager_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Tile Server Manager')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('TSManager', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        pixmap = QPixmap(os.path.join(os.path.dirname(__file__), 'icon.png'))

        icon = QIcon(pixmap)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/TS_Manager/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Tile Server Manager'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Tile Server Manager'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dialog = LoginDialog()
            self.dlg = TSManagerDialog(self.iface,self.dialog)

            # if not self.dialog.verify_login_online():
            #     if self.dialog.exec_() == QtWidgets.QDialog.Accepted:
            #         # show the dialog
            #         self.runTSManager()
            # else:
            #     QtWidgets.QMessageBox.information(None, "Login Successful", "Your login token is successfully verified!")
            #     self.runTSManager()
            # return
        #
        # self.runTSManager()
        if self.dialog.verify_login():
            self.runTSManager()
        else:
            if self.dialog.exec_() == QtWidgets.QDialog.Accepted:
                # show the dialog
                self.runTSManager()

        # self.runTSManager()

    def runTSManager(self):
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
