# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BCTROAPI
                                 A QGIS plugin
 Links to Buchanan Computing TRO API
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-09-29
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Buchanan Computing
        email                : patryk.janicki@buchanancomputing.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QMessageBox
from qgis.gui import QgsMapToolEmitPoint
from qgis.core import Qgis
#from qgis.core import QgsProject
import requests
import sys
import time
from qgis.PyQt.QtWidgets import QProgressBar
from qgis.PyQt.QtCore import *
import webbrowser
import xml.etree.cElementTree as ET
#from PyQt5.QtWidgets import QAction, QMessageBox
from qgis.core import QgsCoordinateReferenceSystem, QgsCoordinateTransform, QgsProject, QgsRectangle, QgsPointXY, QgsGeometry,  QgsVectorLayer, QgsFeature
from qgis.core import QgsVectorLayer
from qgis.gui import QgsMapTool
from qgis.utils import iface
# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .TRO_API_dialog import BCTROAPIDialog
import os.path
import json
from PyQt5.QtCore import *
from PyQt5.QtGui import *
from PyQt5.QtWidgets import *
from qgis.gui import QgsMapToolEmitPoint
from qgis.core import QgsApplication
class BCTROAPI:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        self.temp_dir = QStandardPaths.standardLocations(QStandardPaths.DataLocation)[0]
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'BCTROAPI_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&BC TRO API')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

        self.currentformat = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('BCTROAPI', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)

        action.triggered.connect(callback)
        #action.triggered.connect(testrun)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)
            #self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/TRO_API/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'BC TRO API'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True
        #canvas = iface.mapCanvas()
        #self.canvas = canvas

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&BC TRO API'),
                action)
            self.iface.removeToolBarIcon(action)
            self.iface.removeToolBarIcon(action)

    def canvasPressEvent(self,e):
        if e.button() == Qt.RightButton:
            menu = QMenu()
            quitAction = menu.addAction("AnyAction")
            action = menu.exec_(self.canvas.mapToGlobal(QPoint(e.pos().x()+5, e.pos().y())))

    @staticmethod
    def getcoords(self):
        print ("Getting Coordinates")
        """QMessageBox.information(None, "BC TRO API", "Click a point on the map.")"""
        tool = PointTool(self.iface.mapCanvas(),parent=self)
        iface.mapCanvas().setMapTool(tool)
        self.dlg.GetCoordsButton.clicked.disconnect()
        return

    @staticmethod
    def geojsontojson(jsondata,format):
        print ("Item Count {}".format(len(jsondata)))
        datalist = []
        featureCollection = {}

        print (str(format))
        if str(format) == "BCNATIVE":
            for x in range(len(jsondata)):
                d = json.dumps(jsondata[x])
                j = json.loads(d)
                """print d.["ID"]"""
                geojsondata ={}
                geometry={}
                properties={}

                geometry['type'] = j['Geometry']['type']
                geometry['coordinates'] = j['Geometry']['coordinates']

                properties['id'] = j['ID']
                properties['order_ref'] = j['LegalOrder']['Order_Reference']
                properties['date_from']= j['LegalOrder']['OrderValidity']['OrderStartDate']
                properties['date_to']= j['LegalOrder']['OrderValidity']['OrderEndDate']
                properties['bcnative']=j['Restriction']['APIGroupEnum']
                properties['order_type']=j['Restriction']['OrderType']
                properties['schd_nos']=j['Restriction']['Schedule']['ID']
                properties['schd_desc']=j['Restriction']['Schedule']['Description']
                properties['location_obj'] =j['LocationDescription']
                properties['validity_obj']=j['Restriction']['Validity']

                geojsondata['type'] = 'Feature'
                geojsondata['geometry'] = geometry
                geojsondata['properties'] = properties
                """print(json.dumps(geojsondata))"""
                datalist.append(geojsondata)
        elif str(format) == "APDS":
            for x in range(len(jsondata)):
                d = json.dumps(jsondata[x])
                j = json.loads(d)
                for i in range(len(j['children'])):
                    geojsondata ={}
                    geometry={}
                    properties={}

                    properties['id'] = j['children'][i]['id']
                    properties['parentid'] = j['id']
                    properties['type'] = j['children'][i]['type']
                    properties['rightid'] = j['children'][i]['rightSpecifications'][0]['id']

                    properties['areaType']= j['children'][i]['areaType']
                    properties['operatingRestriction']= j['children'][i]['operatingRestrictions'][0]['operatingRestrictionContext']['en']
                    properties['operatingRestrictionContext']= j['children'][i]['operatingRestrictions'][0]['operatingRestriction']
                    properties['location'] = j['description']['en']
                    properties['occupancy_obj']= j['children'][i]['occupancy']

                    geometry['type'] = j['children'][i]['boundedZone']['type']
                    geometry['coordinates'] =j['children'][i]['boundedZone']['coordinates']

                    geojsondata['type'] = 'Feature'
                    geojsondata['geometry'] = geometry
                    geojsondata['properties'] = properties
                    datalist.append(geojsondata)
        elif str(format) == "TRO-D":
            #TRO-D
            for x in range(len(jsondata)):
                d = json.dumps(jsondata[x])
                j = json.loads(d)
                for i in range(len(j['regulationFeature'])):
                    geojsondata ={}
                    geometry={}
                    properties={}

                    geometry['type'] = j['regulationFeature'][i]['locationReference']['geojson_geometry']['type']
                    geometry['coordinates'] = j['regulationFeature'][i]['locationReference']['geojson_geometry']['coordinates']

                    properties['id'] = j['regulationFeature'][i]['id']
                    properties['order_ref'] = j['id']
                    properties['type'] = j['type']
                    properties['date_from']= j['implementationDate']
                    properties['date_to']= j['revocationDate']
                    try:
                        properties['RegulationFeatureType'] = j['regulationFeature'][i]['type']['RegulationFeatureType']
                    except:
                        properties['RegulationFeatureType'] = j['regulationFeature'][i]['type']

                    try:
                        properties['RoadFeatureType'] = j['regulationFeature'][i]['type']['RoadFeatureType']
                    except:
                        properties['RoadFeatureType'] = j['regulationFeature'][i]['type']

                    properties['Time_Condition']=j['regulationFeature'][i]['Condition']['TimeCondition']
                    properties['Vehicle_Condition']=j['regulationFeature'][i]['Condition']['VehicleCondition']

                    geojsondata['type'] = 'Feature'
                    geojsondata['geometry'] = geometry
                    geojsondata['properties'] = properties
                    datalist.append(geojsondata)
        else:
            return jsondata

        featureCollection['type']= 'FeatureCollection'
        featureCollection['features'] = datalist
        json_format = json.dumps(featureCollection)

        return json_format

    @staticmethod
    def opendocumentation(self):
        webbrowser.open('https://www.trafficorders.uk/api.html', new=2)
        return
    @staticmethod
    def loadsettings(self):
             #XMLsettingsFile = os.path.join(self.plugin_dir,"API_Settings.xml")
            XMLsettingsFile = os.path.join(self.temp_dir,"API_Settings.xml")
            if os.path.isfile(XMLsettingsFile):
                #Load Dialog Settings
                print ("Load dialog settings...")
                root = ET.parse(XMLsettingsFile).getroot()
                try:
                    self.dlg.APIKeyTextBox.setText(root.find("api_token").text)
                except:
                    print ("Unable to load dialog settings...")
                    pass
    @staticmethod
    def checkdialog(self):
        lcheck = True
        listMissing = []
        if not str(self.dlg.APIKeyTextBox.text()):
            lcheck = False
            listMissing.append('\u2022 API Token value missing')

        """Optional
        if not str(self.dlg.AreaTextBox.Text()):
            lcheck = False
            listMissing.append('Area')"""

        if not str(self.dlg.Formatcombobox.currentText()):
            lcheck = False
            listMissing.append('\u2022 Format not specified')

        if not str(self.dlg.Projectioncombobox.currentText()):
            lcheck = False
            listMissing.append('\u2022 Projection not specified')

        if not self.dlg.Xtextbox.text():
            lcheck = False
            listMissing.append('\u2022 X Coordinate value missing')

        if not self.dlg.Ytextbox.text():
            lcheck = False
            listMissing.append('\u2022 Y Coordinate value missing')

        if not int(self.dlg.RadiusSlider.value()) > 0:
            lcheck = False
            listMissing.append('\u2022 Invalid Radius')

        return listMissing

    @staticmethod
    def savesettings(self):
            XMLsettingsFile = os.path.join(self.temp_dir,"API_Settings.xml")
            #Save Dialog Settings
            print ("Save dialog settings...")
            root = ET.Element("root")
            ET.SubElement(root, "area", name="area").text = str(self.dlg.AreaTextBox.text())
            ET.SubElement(root, "epsg", name="epsg").text = str(self.dlg.Projectioncombobox.currentText())
            ET.SubElement(root, "format", name="format").text = str(self.dlg.Formatcombobox.currentText())
            ET.SubElement(root, "x", name="x").text = self.dlg.Xtextbox.text()
            ET.SubElement(root, "y", name="y").text = self.dlg.Ytextbox.text()
            ET.SubElement(root, "radius", name="radius").text = "{}".format(self.dlg.RadiusSlider.value())
            ET.SubElement(root, "api_token", name="api_token").text = str(self.dlg.APIKeyTextBox.text())
            tree = ET.ElementTree(root)
            tree.write(XMLsettingsFile)

    def processRequest(self):
        #iface.messageBar().pushMessage("BC TRO API", "Processing Request", level=0)

        progressMessageBar = iface.messageBar().createMessage("Processing Request...")
        progress = QProgressBar()
        progress.setMaximum(100)
        progress.setAlignment(Qt.AlignLeft|Qt.AlignVCenter)
        progressMessageBar.layout().addWidget(progress)
        iface.messageBar().pushWidget(progressMessageBar, Qgis.Info)

        #API Code here
        apilayer = 'bctroapi'
        maplayerName = "BC TRO"
        layers_names = []
        lopen = False
        for layer in QgsProject.instance().mapLayers().values():
            if layer.name() == maplayerName:
                lopen = True
            layers_names.append(layer.name())
        progress.setValue(10)
        #Params from dialog
        troformat = str(self.dlg.Formatcombobox.currentText())
        area = self.dlg.AreaTextBox.text()
        radius = "{}".format(self.dlg.RadiusSlider.value())
        x = self.dlg.Xtextbox.text()
        y = self.dlg.Ytextbox.text()
        epsg = str(self.dlg.Projectioncombobox.currentText()) #self.iface.mapCanvas().mapSettings().destinationCrs().authid()
        api_token = self.dlg.APIKeyTextBox.text()
        progress.setValue(20)
        time.sleep(0.5)
        #Set EPSG value as expected by TRO API
        if "27700" in epsg:
            epsg = "27700"
        elif "4326" in epsg:
            epsg = "4326"
        elif "3857" in epsg:
            epsg = "3857"
        else:
            return;
        progress.setValue(25)
        #Construct request parameters
        payload = {'api_token':api_token,'epsg': epsg, 'x': x, 'y': y, 'radius': radius}
        print ("API Payload: {}".format(payload))

        #Set Endpoint from troformat
        if troformat == "TRO-D":
            url = 'https://dev.trafficorders.uk/tro/v1/trod'
        else:
            url = 'https://dev.trafficorders.uk/tro/v1/{}'.format(troformat.lower())

        progress.setValue(30)
        # Send Request
        print ("Sending Request...")
        try:
            response = requests.get(url,params=payload)
            print ("Normal Request Success")
        except:
            print ("Normal Request Failed")
            """try:
                response = requests.get(url,params=payload, verify ='IONOS_trafficorders.uk.pem')
                print ("PEM File Request Success")
            except:
                print ("PEM File Request Failed")"""
            try:
                response = requests.get(url,params=payload, verify = False)
                print ("Verify Request Success")
            except:
                print ("Verify Request Failed")
                QMessageBox.critical(self.iface.mainWindow(),
                        "BC TRO API error",
                            "The request processed unsuccesfully!\n\n"
                                "Error Code:\n"
                                "Unable to send GET request")
                iface.messageBar().clearWidgets()
                return

        progress.setValue(50)
        print(response.url)
        print("Status: {}".format(response.status_code))

        #Check request status for error
        if response.status_code != 200:
            QMessageBox.critical(self.iface.mainWindow(),
                "BC TRO API error",
                    "The request processed unsuccesfully!\n\n"
                        "Error Code:\n"
                        "{}".format(response.status_code))
            iface.messageBar().clearWidgets()
            return
        progress.setValue(60)
        #Convert JSON to Geojson
        r_json = self.geojsontojson(response.json(),troformat)
        progress.setValue(70)

        #Save Converted Geojson to file
        path_to_tro_layer = os.path.join(self.temp_dir,"bcnativedata.geojson")

        print ("Write Geojson...")
        with open(path_to_tro_layer, "w") as outfile:
            outfile.write(r_json)
        progress.setValue(80)
        ExitMessage = ''
        #Map geojson file
        #print("{}".format(self.currentformat))
        #print(troformat)
        if not lopen:
            #Open file
            print ("Open Geojson...")
            if not self.addTROlayers(path_to_tro_layer,epsg,maplayerName,troformat):
                ExitMessage = 'Layer Failed'
            else:
                self.currentformat = troformat
                ExitMessage = 'Layer added to map'

        elif self.currentformat != troformat:
            print ("Rebuild table format...")

            #Remove Layer
            vlayers = QgsProject.instance().mapLayersByName(maplayerName)
            for vlayer in vlayers:
                QgsProject.instance().removeMapLayer(vlayer.id())

            #Add - Rebuilding Table structure
            if not self.addTROlayers(path_to_tro_layer,epsg,maplayerName,troformat):
                ExitMessage = 'Layer Failed'
            else:
                self.currentformat = troformat
                ExitMessage = 'Layer added to map - Format change'
        else:
            print ("Reload Geojson...")

            #Refresh Layer
            vlayers = QgsProject.instance().mapLayersByName(maplayerName)
            for vlayer in vlayers:
                vlayer.dataProvider().reloadData()
                vlayer.triggerRepaint()

            ExitMessage = 'Layer refreshed'
        progress.setValue(100)
        #Show Exit message
        iface.messageBar().clearWidgets()
        iface.messageBar().pushMessage("BC TRO API", ExitMessage, level=3)

    def addTROlayers(self,jsonfile,epsg,layername,troformat):
        lcheck = True
        path_to_tro_layer = jsonfile
        maplayerName = layername

        uriLine = path_to_tro_layer + "|geometrytype=LineString"
        uriPoint = path_to_tro_layer + "|geometrytype=Point"
        uriPolygon = path_to_tro_layer + "|geometrytype=Polygon"

        vlayer = QgsVectorLayer(path_to_tro_layer , maplayerName, "ogr")
        vlayerPoint = QgsVectorLayer(uriPoint , maplayerName, "ogr")
        vlayerLine = QgsVectorLayer(uriLine, maplayerName, "ogr")
        vlayerPolygon = QgsVectorLayer(uriPolygon, maplayerName, "ogr")

        point_style_file = os.path.join(self.plugin_dir,"style","{}_POINT.qml".format(troformat))
        line_style_file = os.path.join(self.plugin_dir,"style","{}_LINESTRING.qml".format(troformat))
        polygon_style_file = os.path.join(self.plugin_dir,"style","{}_POLYGON.qml".format(troformat))
        vlayerPoint.loadNamedStyle(point_style_file)
        vlayerLine.loadNamedStyle(line_style_file)
        vlayerPolygon.loadNamedStyle(polygon_style_file)

        if not vlayer.isValid():
            print("Layer failed to load!")
            lcheck = False
        else:
            #Add Layers to map
            QgsProject.instance().addMapLayer(vlayerPoint)
            QgsProject.instance().addMapLayer(vlayerLine)
            QgsProject.instance().addMapLayer(vlayerPolygon)

            crs = vlayer.crs()
            crs.createFromId(int(epsg))
            #Set projection of file from dialog
            vlayerPoint.setCrs(crs)
            vlayerLine.setCrs(crs)
            vlayerPolygon.setCrs(crs)
        return lcheck

    def projection_combobox_changed(self, value):
        if self.dlg.Ytextbox.text() or self.dlg.Xtextbox.text():
            iface.messageBar().pushMessage("BC TRO API", "Projection changed. Please reselect X and Y coordinates.", level=0)
            # Reset X and Y
            self.dlg.Xtextbox.setText("")
            self.dlg.Ytextbox.setText("")
            self.dlg.GetCoordsButton.clicked.connect(lambda: self.getcoords(self))

    def run(self):
        if self.first_start == True:
            self.first_start = False
            self.dlg = BCTROAPIDialog()
            #Load Dialog Settings
            self.loadsettings(self)

            self.dlg.HelpButton.clicked.connect(lambda: self.opendocumentation(self))
            self.dlg.Projectioncombobox.currentTextChanged.connect(self.projection_combobox_changed)
            print("Working directory: {}".format(self.temp_dir))
            print("Plugin directory: {}".format(self.plugin_dir))
        #Link GetPoint Event to Button - needs relinking as unlinked at the end
        self.dlg.GetCoordsButton.clicked.connect(lambda: self.getcoords(self))
        self.dlg.show()

        # Run the dialog event loop
        result = self.dlg.exec_()
        if  result:
            #Check Dialog
            listCheck = self.checkdialog(self)
            if len(listCheck) > 0:
                QMessageBox.critical(self.iface.mainWindow(),
                    "BC TRO API",
                        "Please correct the following before proceeding:\n\n"
                            "{}".format("\n".join(listCheck[0:])))
                self.run()
            #Save Dialog Settings
            self.savesettings(self)
            #Process User Request
            self.processRequest()

class PointTool(QgsMapTool):
    def __init__(self, canvas,parent=None):
        QgsMapTool.__init__(self, canvas)
        self.canvas = canvas
        cursor = QCursor()
        cursor.setShape(Qt.CrossCursor)
        # Run the dialog event loop
        self.parent = parent
        QApplication.setOverrideCursor(cursor)

    def canvasPressEvent(self, event):
        pass

    def canvasMoveEvent(self, event):
        x = event.pos().x()
        y = event.pos().y()

        point = self.canvas.getCoordinateTransform().toMapCoordinates(x, y)

    def canvasReleaseEvent(self, event):
        #Get the click
        x = event.pos().x()
        y = event.pos().y()

        point = self.canvas.getCoordinateTransform().toMapCoordinates(x, y)
        #print ("Click at {}".format(point))
        sourceProjection = self.canvas.mapSettings().destinationCrs() # QgsCoordinateReferenceSystem("EPSG:27700")
        #print (str(self.parent.dlg.Projectioncombobox.currentText()))
        destinationProjection = QgsCoordinateReferenceSystem(str(self.parent.dlg.Projectioncombobox.currentText()))

        transform = QgsCoordinateTransform(
                        sourceProjection, destinationProjection, QgsProject.instance())

        point = transform.transform(point)

        #Update Dialog X and Y values
        self.parent.dlg.Xtextbox.setText(str(point[0]))
        self.parent.dlg.Ytextbox.setText(str(point[1]))

        #Bring Dialog to top
        self.parent.dlg.activateWindow()

        #Change Mouse Cursor
        #QApplication.setOverrideCursor(Qt.ArrowCursor)
        QApplication.restoreOverrideCursor()
        #Deactive Pointer Tool
        self.deactivate()

    def activate(self):
        pass

    def deactivate(self):
        pass

    def isZoomTool(self):
        return False

    def isTransient(self):
        return False

    def isEditTool(self):
        return True
