"""
/***************************************************************************
 PublicTransitAnalysis
                                 A QGIS plugin
 Using OpenTripPlanner to calculate public transport reachability from a
    starting point to all stops in a GTFS feed.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-05-14
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Julek Weck
        email                : j.weck@tu-braunschweig.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from datetime import time, datetime
from .referencePoint import ReferencePoint
class Route:
    """
    Every object contains all departure times of one line at one stop in the given search window.
    This is comparable with the timetable of a line at a bus stop.

    This can be used to calculate the frequency of one line.
    For future developements this can be used for the Austrian 'public transport quality classes'.
    """
    def __init__(self, gtfsId, shortName, stopId):
        self.gtfs_id = gtfsId
        self.short_name = shortName
        self.related_stop_gtfs_id = stopId
        self.__frequency = None
        self.__departure_times = [] #only the departures inside the search window

    @property
    def frequency(self):
        return self.__frequency

    @frequency.setter
    def frequency(self, new_frequency):
        self.__frequency = new_frequency

    def add_departure_time(self, departure:time):
        if type(departure) == time:
            self.__departure_times.append(departure)

    def get_departure_times(self):
        return self.__departure_times

    def calculate_frequency(self, analysis_parameters:ReferencePoint):
        time_range = analysis_parameters.search_window/60 #seconds in minutes
        departure_amount = len(self.get_departure_times())
        frequency = time_range/departure_amount # frequency: every ... minute
        return frequency



