"""
/***************************************************************************
 PublicTransitAnalysis
                                 A QGIS plugin
 Using OpenTripPlanner to calculate public transport reachability from a
    starting point to all stops in a GTFS feed.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-05-14
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Julek Weck
        email                : j.weck@tu-braunschweig.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

class Itinerary:

    def __init__(self, startTime, firstStop, lastStop, duration, numberOfTransfers, walkDistance, distanceToFirstStop, distanceFromLastStop, modes, routeNumbers, legs, frequency):
        self.start_time = startTime
        self.first_stop = firstStop
        self.last_stop = lastStop
        self.duration = duration
        self.number_of_transfers = numberOfTransfers
        self.walk_distance = walkDistance
        self.meters_first_stop = distanceToFirstStop
        self.meters_end_stop = distanceFromLastStop
        self.modes = modes.copy()
        self.route_numbers = routeNumbers.copy()
        self.frequency = frequency
        self.legs = legs

    def calculate_frequency(self, route_collection):
        # duration: 18min
        all_frequencies = []
        for trip in self.legs:
            if trip["mode"] != "WALK": #either walk or a transit mode with frequency
                for route in route_collection:
                    if trip["from"]["stop"]["gtfsId"] == route.related_stop_gtfs_id:
                        if trip["route"]["gtfsId"] == route.gtfs_id:
                            all_frequencies.append(route.frequency)
            else:
                all_frequencies.append(0.5) # you can start to walk every half minute
                # the unit of all_frequencies is minutes.
        worst_frequency = all_frequencies[0]
        for frequency in all_frequencies:
            if worst_frequency < frequency:  # frequency: every...minute
                worst_frequency = frequency
        return worst_frequency
