# -*- coding: utf-8 -*-/
"""
/***************************************************************************
TnT_MapCanvas
                                 A QGIS plugin
Labelisation de données segmentées.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2021-01-25
        git sha              : $Format:%H$
        copyright            : (C) 2021 by IGN
        authors              : Yann Le Borgne
        email                : yann.le-borgne@ign.fr
        version              : 1.3.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import inspect

from qgis.gui import( QgsMapCanvas, QgsVertexMarker, QgsMapTool )

from PyQt5.QtCore    import( Qt, QEvent )
from PyQt5.QtGui     import( QColor, QFont, QMouseEvent, QEnterEvent )

from qgis.core import QgsGeometry, QgsPoint, QgsTextBufferSettings, QgsTextFormat, QgsPalLayerSettings, QgsVectorLayerSimpleLabeling, QgsVectorLayer
from PyQt5.QtWidgets import QLabel

import numpy as np
import math
from .TnT_Features import TnTFeaturesManager

def lineno():
    """Returns the current line number in Python source code"""
    return inspect.currentframe().f_back.f_lineno

class mapCanvas(QgsMapCanvas):
    """
    Canvas handling class.
    """

    def __init__(self, parent=None, objectName="mapCanvas"):
        super().__init__(parent)

        self.setObjectName(objectName)
        self.setAccessibleName(objectName)

        self.marker = None
        self.synchroMode = True
        self.displayMode = False
        self.label_settings = None
        self.showBigZoomLabels = False
        self.ongoing_capture = False
        self.setMapTool(QgsMapTool(self),False)

        self.setUpUi()


    def setUpUi(self):
        """
            returns none:
        """
        # print(f"line:{lineno()},{self.__class__.__name__}->"+
        #       f"{inspect.currentframe().f_code.co_name}()")

        self.setCanvasColor(Qt.black)
        self.setDefaultMarker()
        self.setSynchroZoom()
        self.setLabelsSettings()

    def getMasterWindow(self):
        # print(f"line:{lineno()},{self.__class__.__name__}->"+
        #       f"{inspect.currentframe().f_code.co_name}()")

        parent = self.parent()
        while parent.objectName()!="TraiNminaTor2Dialog_Master" :
            parent = parent.parent()
        return parent

    def setDefaultMarker(self):
        """
            returns none:
        """
        # print(f"line:{lineno()},{self.__class__.__name__}->"+
        #       f"{inspect.currentframe().f_code.co_name}()")

        self.marker = QgsVertexMarker( self )
        self.marker.setColor( QColor( 255,255,255 ) )
        self.marker.setIconSize( 25 )
        self.marker.setIconType( QgsVertexMarker.ICON_CROSS )
        self.marker.setPenWidth( 1 )

    def setLabelsSettings(self):
        buffer_settings = QgsTextBufferSettings()
        buffer_settings.setEnabled(True)
        buffer_settings.setSize(1)
        buffer_settings.setColor(QColor("white"))

        text_format = QgsTextFormat()
        text_format.setFont(QFont("Arial", 12))
        text_format.setSize(12)
        text_format.setBuffer(buffer_settings)

        label_settings = QgsPalLayerSettings()
        label_settings.setFormat(text_format) 
        label_settings.placement = QgsPalLayerSettings.AroundPoint #2
        label_settings.enabled = True
        self.label_settings = label_settings        

    def setDisplayMode(self):
        if self.displayMode == True:
            self.displayMode = False
        else:
            self.displayMode = True

    def zoomAllToFullExtent(self):
        """Zoom to the full extent of all layers currently visible in
            the canvas. Executed when user press Fit All button.
            Applied to all open canvases if Synchro mode is enabled"""
        # print(f"line:{lineno()},{self.__class__.__name__}->"+
        #       f"{inspect.currentframe().f_code.co_name}()")
        self.zoomToFullExtent()
        if self.getSynchroMode() :
            canvas_list = self.getAllCanvas()
            for canvas in canvas_list :
                canvas.zoomToFullExtent()
                

    def manageSynchroConnections(self, state=False):
        # print(f"line:{lineno()},{self.__class__.__name__}->"+
        #       f"{inspect.currentframe().f_code.co_name}()")
        
        self.setSynchroMode(state)
        if state :
            self.setSynchroZoom()
        else :
            self.unsetSynchroZoom()

    def setSynchroZoom(self):
        # print(f"line:{lineno()},{self.__class__.__name__}->"+
        #       f"{inspect.currentframe().f_code.co_name}()")
        
        self.extentsChanged.connect(self.synchroExtents)
        

    def unsetSynchroZoom(self):
        # print(f"line:{lineno()},{self.__class__.__name__}->"+
        #       f"{inspect.currentframe().f_code.co_name}()")
        
        try :
            self.extentsChanged.disconnect()
        except TypeError:
            pass
        

    def synchroExtents(self):
        """
        Synchronization of the zoom/pan between the main and additional view.
            returns none:
        # """
        # print(f"line:{lineno()},{self.__class__.__name__}->"+
        #       f"{inspect.currentframe().f_code.co_name}()")

        canvas_list = self.getAllCanvas()
        for canvas in canvas_list :
            if canvas.isVisible() :
                canvas.unsetSynchroZoom()
                canvas.setExtent(self.extent())
                canvas.refresh()
                canvas.setSynchroZoom()
                

    def setSynchroMode(self, state=False):
        """
        This method return state of synchronization mode.
            returns none:
        """
        # print(f"line:{lineno()},{self.__class__.__name__}->"+
        #       f"{inspect.currentframe().f_code.co_name}()")

        self.synchroMode = state
        

    def getSynchroMode(self):
        """
        This method return state of synchronization mode.
            returns none:
        """
        # print(f"line:{lineno()},{self.__class__.__name__}->"+
        #       f"{inspect.currentframe().f_code.co_name}()")

        return self.synchroMode

    def getMainWindow(self):
        # print(f"line:{lineno()},{self.__class__.__name__}->"+
        #       f"{inspect.currentframe().f_code.co_name}()")

        parent = self.parent()
        while not parent.objectName() != "TraiNminaTor2Dialog_Master":
            parent = parent.parent()
        return parent


    def getAllCanvas(self):
        # print(f"line:{lineno()},{self.__class__.__name__}->"+
        #       f"{inspect.currentframe().f_code.co_name}()")

        masterWindow = self.getMasterWindow()
        canvas_list = masterWindow.findChildren(mapCanvas, "mapCanvas")
        canvas_list.remove(self)
        return canvas_list
    

    def showClassesMoreSegmentedLayer(self):
        masterWindow = self.getMasterWindow()
        master_canvas = masterWindow.findChild(mapCanvas, "mapCanvas")
        associatedWindow = masterWindow.associatedWindow
        associated_canvas = associatedWindow.findChild(mapCanvas, "mapCanvas")

        #Labels settings
        master_label_settings = self.label_settings
        master_label_settings.fieldName = 'code_' + str(masterWindow.getVintage())
        master_label_settings = QgsVectorLayerSimpleLabeling(master_label_settings)
    
        associated_label_settings = self.label_settings
        associated_label_settings.fieldName = 'code_' + str(associatedWindow.getVintage())
        associated_label_settings = QgsVectorLayerSimpleLabeling(associated_label_settings)

        #Get the more segmented layers
        if len(master_canvas.layers()) == 3:
            master_moreSegmentedLayer = 1
        else:
            master_moreSegmentedLayer = 2
        master_layer = master_canvas.layers()[master_moreSegmentedLayer]
        master_layer.setLabeling(master_label_settings)

        if len(associated_canvas.layers()) == 3:
            associated_moreSegmentedLayer = 1
        else:
            associated_moreSegmentedLayer = 2
        associated_layer = associated_canvas.layers()[associated_moreSegmentedLayer]
        associated_layer.setLabeling(associated_label_settings)

        return master_layer, associated_layer

    
    def showMousePointerMarker(self, p):
        """
        This method display the mouse pointer (marker) at <p> position
        in canvas of slave view.
            param p: mouse pointer position  QgsPointXY.
            returns none:
        """
        # print(f"line:{lineno()},{self.__class__.__name__}->"+
        #       f"{inspect.currentframe().f_code.co_name}()")

        self.marker.setCenter(p)
        self.marker.show()

    def mouseMoveEvent(self, event:QMouseEvent):
        """
            returns none:
        """
        if self.getSynchroMode() :
            qgspointXY =self.mapTool().toMapCoordinates(event.pos())
            canvas_list= self.getAllCanvas()
            for canvas in canvas_list :
                canvas.showMousePointerMarker(qgspointXY)
            
        if self.displayMode:
            qgspointXY = self.mapTool().toMapCoordinates(event.pos())
            geo_pt =  QgsGeometry.fromPointXY(qgspointXY)
            self.showDisplayLabels(geo_pt)       
            
        return QgsMapCanvas.mouseMoveEvent(self, event)

    def showDisplayLabels(self, geo_pt):
        layer = self.currentLayer()
        feats = [feat for feat in layer.getFeatures()]
        id = -1
        for feat in feats:
            if geo_pt.within(feat.geometry()):
                id = feat.id()
                break            
                    
        masterWindow = self.getMasterWindow()
        labels_year0 = masterWindow.findChildren(QLabel, "label_year0_class")

        year0 = masterWindow.getVintage()
        if year0 is not None:
            att0 = "class_" + str(year0)
        else:
            att0 = "class"

        if masterWindow.projectManager.isDifferential:
            labels_year1 = masterWindow.findChildren(QLabel, "label_year1_class")
            year1 = masterWindow.associatedWindow.getVintage()
            att1 = "class_" + str(year1)

        
        if id != -1:
            for label in labels_year0:
                label.setText(f"Classe {year0} : {feats[id].attribute(att0)}")

            if masterWindow.projectManager.isDifferential:
                for label in labels_year1:
                    label.setText(f"Classe {year1} : {feats[id].attribute(att1)}")


    def leaveEvent(self, event:QEvent):
        # print(f"line:{lineno()},{self.__class__.__name__}->"+
        #       f"{inspect.currentframe().f_code.co_name}()")

        if self.getSynchroMode() :
            canvas_list= self.getAllCanvas()
            for canvas in canvas_list :
                canvas.marker.hide()
        
        if self.displayMode:
            pass
        
        return QgsMapCanvas.leaveEvent(self, event)


    def enterEvent(self, event:QEnterEvent):
        # print(f"line:{lineno()},{self.__class__.__name__}->"+
        #       f"{inspect.currentframe().f_code.co_name}()")
      
        return QgsMapCanvas.enterEvent(self, event)


    def event(self, event: QEvent):
        evt_Type=event.type()
        if (evt_Type==QEvent.KeyPress or evt_Type==QEvent.KeyRelease) and event.key()==Qt.Key_W:
            masterWindow = self.getMasterWindow()

            showContext = evt_Type==QEvent.KeyPress
            vintage = masterWindow.getVintage()
            if vintage:
                keepGroup = f"CONTEXT_{vintage}"
            else:
                keepGroup = "CONTEXT"
            masterWindow.showContext(showContext=showContext, keepGroup=keepGroup)

            associatedWindow = masterWindow.associatedWindow
            vintage = associatedWindow.getVintage()
            if vintage:
                keepGroup = f"CONTEXT_{vintage}"
            else:
                keepGroup = "CONTEXT"
            associatedWindow.showContext(showContext=showContext, keepGroup=keepGroup)
            return True
    
        return QgsMapCanvas.event(self, event)
    
    def wheelEvent(self, event: QEvent.Wheel):
        masterWindow = self.getMasterWindow()
        master_canvas = masterWindow.findChild(mapCanvas, "mapCanvas")
        associatedWindow = masterWindow.associatedWindow
        associated_canvas = associatedWindow.findChild(mapCanvas, "mapCanvas")
    
        start_stop_group = masterWindow.get_start_stop_group()
        on_start_mode: bool = start_stop_group.on_start_mode

        if on_start_mode:
            #Zoom computation
            maxScalePerPixel = 156543.04
            inchesPerMeter = 39.37

            master_dpi = masterWindow.physicalDpiX()
            master_zoomLevel = int(round(math.log( ((master_dpi * inchesPerMeter * maxScalePerPixel) / master_canvas.scale()), 2), 0))

            associated_dpi = associatedWindow.physicalDpiX()
            associated_zoomLevel = int(round(math.log( ((associated_dpi * 39.37 *  156543.04) / associated_canvas.scale()), 2), 0))


            master_layer, associated_layer = self.showClassesMoreSegmentedLayer()
            #Define the zoom level for displaying labels
            if self.showBigZoomLabels == True:
                if master_zoomLevel > 22 or associated_zoomLevel > 8:
                    master_layer.setLabelsEnabled(True)
                    master_layer.triggerRepaint()

                    associated_layer.setLabelsEnabled(True)
                    associated_layer.triggerRepaint()

                elif master_zoomLevel <= 22 or associated_zoomLevel <= 8:
                    master_layer.setLabelsEnabled(False)
                    associated_layer.setLabelsEnabled(False)
            else:
                master_layer.setLabelsEnabled(False)
                associated_layer.setLabelsEnabled(False)
               
        return QgsMapCanvas.wheelEvent(self, event)