# -*- coding: utf-8 -*-

"""
/***************************************************************************
 TrailElevationStats
                                 A QGIS plugin
 Calculate information such as cumulative elevation gain from a DEM and a line layer.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-07-16
        copyright            : (C) 2019 by Gustave Coste
        email                : gustavecoste@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Gustave Coste'
__date__ = '2019-07-16'
__copyright__ = '(C) 2019 by Gustave Coste'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect

from qgis.core import QgsProcessingAlgorithm, QgsApplication
from .trail_elevation_stats_provider import TrailElevationInfoProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class TrailElevationStatsPlugin(object):

    def __init__(self):
        self.provider = "Trail Elevation Stats"

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = TrailElevationInfoProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
