# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Topography
                                 A QGI plugin
 The plugin is available in this first version with the functionality to calculate closed polygons using the projections method.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-06-10
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Keyla Sa T R Alves/Sandro H de Faria/ Kaike Sa T R Alves
        email                : keyla.alves@arquitetura.ufjf.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog, QMessageBox
from qgis.core import *

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .topography_dialog import TopographyDialog
import os.path
##############################################################################
#My libraries
import math
import pandas as pd
import statistics as st
from PyQt5.QtWidgets import QTableWidget,QTableWidgetItem,QComboBox


## Libraries to open a new window
##from SecondWindow import *
       
###############################################################################
class Topography:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Topography_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Topography')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        
        # Initializing global variables
        self.list_Alt = []
        self.list_Sta = []
        self.list_Sta_Combo = []
        self.list_Sta_Correto = []
        self.cont = 0
        self.Total_rows = 0
        self.current_station = ""
        self.current_Alt = ""
        self.Caderneta_Topografica = pd.DataFrame(columns = ['Estacao','Altura','Tipo','Nome','Descricao','AHD','AVD','FS','FM','FI'])
        self.Tipo = ["","Re", "Vante", "Irradiado"]
        self.ComBoxIncluded = 0
        
    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Topography', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)
        
        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        
        icon_path = ':/plugins/topography/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Topography'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Topography'),
                action)
            self.iface.removeToolBarIcon(action)
    ##############################MÉTODOS############################        
    def select_file(self): #verificar
    
        # Obtaining the path of the file
        filename = QFileDialog.getOpenFileName(self.dlg, "Select file ","",'*.csv')
        filename_str = str(filename[0])
        self.dlg.label_name_input_file.setText(filename_str)
        
        # Defining the head of the table
        Header = [{'Estacao':0,'Altura':0,'Tipo':0,'Nome':0,'Descricao':0,'AHD':0,'AVD':0,'FS':0,'FM':0,'FI':0}]
        
        self.list_Sta_Combo.append("")
        
        # Opening the selected file
        arquivo = open(filename_str,'r')
        
        # Reading the file and storing the data in the dictionary
        for line in arquivo:
            x = line
            y = x.split(';')   
            if y[0] in ['EST','Re','Vante','Irradiado']:
                if y[0]=='EST':
                    Estacao = y[1]
                    Altura = float(y[2])
                    if y[1] not in self.list_Sta:
                        self.list_Sta.append(y[1])
                        self.list_Sta_Combo.append(y[1])
                        self.list_Alt.append(Altura)
                    x = arquivo.readline()
                    y = x.split(';')
                    Tipo = y[0]
                    Nome = y[1]
                    Descricao = y[2]
                    deg = float(y[3].replace(',','.'))
                    g, m, s = self.formato_graus_tabela(deg)
                    #g, m, s = self.formato_graus(deg)
                    AHD = g+'°'+m+'\''+s+'\"'
                    #AHD = y[3]
                    deg = float(y[4].replace(',','.'))
                    g, m, s = self.formato_graus_tabela(deg)
                    #g, m, s = self.formato_graus(deg)
                    AVD = g+'°'+m+'\''+s+'\"'
                    #AVD = y[4]
                    FS = float(y[5])
                    FM = float(y[6])
                    FI = float(y[7])
                else:
                    Tipo = y[0]
                    Nome = y[1]
                    if y[2]=='Â ':
                        y[2]=''
                    Descricao = y[2]
                    deg = float(y[3].replace(',','.'))
                    g, m, s = self.formato_graus_tabela(deg)
                    #g, m, s = self.formato_graus(deg)
                    AHD = g+'°'+m+'\''+s+'\"'
                    #AHD = y[3]
                    deg = float(y[4].replace(',','.'))
                    g, m, s = self.formato_graus_tabela(deg)
                    #g, m, s = self.formato_graus(deg)
                    AVD = g+'°'+m+'\''+s+'\"'
                    #AVD = y[4]
                    FS = float(y[5])
                    FM = float(y[6])
                    FI = float(y[7])
                self.Caderneta_Topografica = self.Caderneta_Topografica.append({'Estacao':Estacao,'Altura':Altura,'Tipo':Tipo,'Nome':Nome,'Descricao':Descricao,'AHD':AHD,'AVD':AVD,'FS':"{:.3f}".format(FS),'FM':"{:.3f}".format(FM),'FI':"{:.3f}".format(FI)},ignore_index=True)
                self.Total_rows = self.Total_rows + 1
        
        # Closing the file
        arquivo.close()
        
        # Filling the comboBox and the label
        self.dlg.comboBox.clear()
        self.dlg.comboBox.addItems(self.list_Sta)
        self.dlg.comboBox_2.clear()
        self.dlg.comboBox_2.addItems(self.list_Sta_Combo)
        self.dlg.comboBox_3.clear()
        self.dlg.comboBox_3.addItems(self.list_Sta_Combo)
        self.dlg.comboBox_4.clear()
        self.dlg.comboBox_4.addItems(self.list_Sta_Combo)
        self.dlg.comboBox_5.clear()
        self.dlg.comboBox_5.addItems(self.list_Sta_Combo)
        #self.dlg.label_3.setText(str(self.Caderneta_Topografica['Altura'][0]))
        self.dlg.comboBox_6.clear()
        self.dlg.comboBox_6.addItems(self.Tipo)
        self.dlg.comboBox_2.setDisabled(True)
        self.dlg.comboBox_3.setDisabled(True)
        self.dlg.comboBox_4.setDisabled(True)
        self.dlg.comboBox_5.setDisabled(True)
        
        self.dlg.lineEdit_10.setEnabled(False)
        self.dlg.lineEdit_11.setEnabled(False)
        self.dlg.lineEdit_12.setEnabled(False)
        self.dlg.lineEdit_7.setEnabled(False)
        self.dlg.lineEdit_8.setEnabled(False)
        self.dlg.lineEdit_9.setEnabled(False)
        self.dlg.lineEdit_14.setEnabled(False)
        self.dlg.lineEdit_15.setEnabled(False)
        self.dlg.lineEdit_16.setEnabled(False)
        self.dlg.lineEdit_17.setEnabled(False)
        self.dlg.lineEdit_34.setEnabled(False)
        self.dlg.lineEdit_33.setEnabled(False)
        
        
        # Current station
        self.current_station = self.list_Sta[0]
        self.current_Alt = self.list_Alt[0]
        # Filling the table
        n = len(self.Caderneta_Topografica)
        self.cont = 0
        for num_row in range(n):
            if self.list_Sta[0] == str(self.Caderneta_Topografica['Estacao'][num_row]):
                self.cont = self.cont + 1
                
        self.dlg.tableWidget.setColumnCount(8)
        labels = ['Tipo','Nome','Descricao','AHD','AVD','FS','FM','FI']
        self.dlg.tableWidget.setHorizontalHeaderLabels(labels)
        
        self.dlg.tableWidget.setRowCount(self.cont)
        linha = 0
        for num_row in range(n):
            if self.list_Sta[0] == str(self.Caderneta_Topografica['Estacao'][num_row]):
                for num_col,col in zip(range(10),self.Caderneta_Topografica):
                    if num_col > 1:
                        self.dlg.tableWidget.setItem(linha,num_col - 2,QTableWidgetItem(str(self.Caderneta_Topografica[col][num_row])))
                linha = linha + 1
        
        # ComboBox inside a table
        stations = [""]
        for i in self.list_Sta:
            stations.append(i)
        self.dlg.tableWidget_2.setRowCount(len(stations))
        for r in range(len(stations)):
            combo = QComboBox()
            combo.addItems(stations)
            self.dlg.tableWidget_2.setCellWidget(r, 0, combo)
            self.ComBoxIncluded = 1
        
    def selectionchange(self):
    
        # Getting the size of the dictionary
        n = len(self.Caderneta_Topografica)
        # Getting the selected station
        text_comboBox = str(self.dlg.comboBox.currentText())
        # Finding the index of the current station
        ind = self.list_Sta.index(text_comboBox)
        self.dlg.label_3.setText(str(self.list_Alt[ind]))
        
        self.cont = 0
        for num_row in range(n):
            if text_comboBox == str(self.Caderneta_Topografica['Estacao'][num_row]):
                self.cont = self.cont + 1
        
        self.dlg.tableWidget.setRowCount(0)
        self.dlg.tableWidget.setRowCount(self.cont)
        linha = 0
        for num_row in range(n):
            if text_comboBox == str(self.Caderneta_Topografica['Estacao'][num_row]):
                for num_col,col in zip(range(10),self.Caderneta_Topografica):
                    if num_col > 1:
                        self.dlg.tableWidget.setItem(linha,num_col - 2,QTableWidgetItem(str(self.Caderneta_Topografica[col][num_row])))
                linha = linha + 1
        
        self.current_station = text_comboBox
        self.current_Alt = self.list_Alt[ind]
        
    def mudar_estacao(self):
        n_rows = self.dlg.tableWidget_2.rowCount()
        self.dlg.comboBox_2.setCurrentText(self.dlg.tableWidget_2.cellWidget(0,0).currentText())
        self.dlg.comboBox_3.setCurrentText(self.dlg.tableWidget_2.cellWidget(n_rows-2,0).currentText())
        self.dlg.comboBox_4.setCurrentText(self.dlg.tableWidget_2.cellWidget(0,0).currentText())
        
    def alerta(self):
        n_rows = self.dlg.tableWidget_2.rowCount()
        text = "Informe o azimute de "+str(self.dlg.tableWidget_2.cellWidget(n_rows-2,0).currentText()) + " para " + str(self.dlg.tableWidget_2.cellWidget(0,0).currentText())
        msg = QMessageBox()
        msg.setIcon(QMessageBox.Critical)
        msg.setText(text)
        #msg.setInformativeText(text)
        msg.setWindowTitle("Atenção")
        msg.exec_()
        
        
    def save_changes(self):
        
        # Finding the first index of the current station
        for i in self.Caderneta_Topografica.index:
            if self.Caderneta_Topografica.at[i, 'Estacao'] == self.current_station:
                l = i
                break
                
        # Finding all indexes of the current station to remove from the dataframe
        remove = []
        for i in self.Caderneta_Topografica.index:
            if self.Caderneta_Topografica.at[i, 'Estacao'] == self.current_station:
                remove.append(i)
                
        self.Caderneta_Topografica = self.Caderneta_Topografica.drop(remove)
        self.Caderneta_Topografica = self.Caderneta_Topografica.reset_index(drop=True)
                
        Prov = pd.DataFrame(columns = ['Estacao','Altura','Tipo','Nome','Descricao','AHD','AVD','FS','FM','FI'])
        
        for row in range(l):
            Prov = Prov.append({'Estacao':self.Caderneta_Topografica.loc[row, 'Estacao'], 'Altura': float(self.Caderneta_Topografica.loc[row, 'Altura']), 'Tipo':self.Caderneta_Topografica.loc[row, 'Tipo'], 'Nome':self.Caderneta_Topografica.loc[row, 'Nome'], 'Descricao':self.Caderneta_Topografica.loc[row, 'Descricao'], 'AHD':self.Caderneta_Topografica.loc[row, 'AHD'], 'AVD':self.Caderneta_Topografica.loc[row, 'AVD'], 'FS': float(self.Caderneta_Topografica.loc[row, 'FS']), 'FM': float(self.Caderneta_Topografica.loc[row, 'FM']), 'FI': float(self.Caderneta_Topografica.loc[row, 'FI'])}, ignore_index = True)

        for num_row in range(self.dlg.tableWidget.rowCount()):
            blank = 0
            lis = [self.current_station, self.current_Alt]
            for num_col in range(8):
                if self.dlg.tableWidget.item(num_row,num_col) == None:
                    if num_col != 2:
                        blank = 1
                    lis.append("")
                else:
                    lis.append(self.dlg.tableWidget.item(num_row,num_col).text())
            # Verifying if the line is filled
            if blank == 0:
                Prov = Prov.append({'Estacao':lis[0],'Altura': float(lis[1]),'Tipo':lis[2],'Nome':lis[3],'Descricao':lis[4],'AHD':lis[5],'AVD':lis[6],'FS': float(lis[7]),'FM': float(lis[8]),'FI': float(lis[9])},ignore_index=True)
        
        for row in range(l, len(self.Caderneta_Topografica)):
            Prov = Prov.append({'Estacao':self.Caderneta_Topografica.loc[row, 'Estacao'], 'Altura': float(self.Caderneta_Topografica.loc[row, 'Altura']), 'Tipo':self.Caderneta_Topografica.loc[row, 'Tipo'], 'Nome':self.Caderneta_Topografica.loc[row, 'Nome'], 'Descricao':self.Caderneta_Topografica.loc[row, 'Descricao'], 'AHD':self.Caderneta_Topografica.loc[row, 'AHD'], 'AVD':self.Caderneta_Topografica.loc[row, 'AVD'], 'FS': float(self.Caderneta_Topografica.loc[row, 'FS']), 'FM': float(self.Caderneta_Topografica.loc[row, 'FM']), 'FI': float(self.Caderneta_Topografica.loc[row, 'FI'])}, ignore_index = True)
        
        self.Caderneta_Topografica = Prov
        
    def nova_linha(self):
        #row = self.dlg.tableWidget.currentRow()
        #self.dlg.tableWidget.insertRow(row)
        blank = 0
        
        Estacao = str(self.dlg.comboBox.currentText())
        if Estacao == "":
            msg = QMessageBox()
            msg.setIcon(QMessageBox.Critical)
            msg.setText("Nenhuma estação selecionada")
            msg.setInformativeText('Por favor, verifique se uma base de dados foi importada')
            msg.setWindowTitle("Erro")
            msg.exec_()
            blank = 1
            
        Altura = float(self.dlg.label_3.text())
        if blank == 0 and Altura == "":
            msg = QMessageBox()
            msg.setIcon(QMessageBox.Critical)
            msg.setText("O campo altura está vazio")
            msg.setInformativeText('Por favor, verifique se uma base de dados foi importada')
            msg.setWindowTitle("Erro")
            msg.exec_()
            blank = 1 
        
        Tipo = str(self.dlg.comboBox_6.currentText())
        if blank == 0 and Tipo == "":
            msg = QMessageBox()
            msg.setIcon(QMessageBox.Critical)
            msg.setText("O tipo da observação não foi selecionado")
            msg.setInformativeText('Por favor, indique o tipo da observação')
            msg.setWindowTitle("Erro")
            msg.exec_()
            blank = 1
            
        Nome = str(self.dlg.lineEdit_18.text())
        if blank == 0 and Nome == "":
            msg = QMessageBox()
            msg.setIcon(QMessageBox.Critical)
            msg.setText("O nome da observação não foi inserido")
            msg.setInformativeText('Por favor, insira o nome da observação')
            msg.setWindowTitle("Erro")
            msg.exec_()
            blank = 1 
            
        Descricao = str(self.dlg.lineEdit_19.text())
        
        FS = float(self.dlg.lineEdit_20.text())
        if blank == 0 and FS == "":
            msg = QMessageBox()
            msg.setIcon(QMessageBox.Critical)
            msg.setText("O campo FS está vazio")
            msg.setInformativeText('Por favor, insira um valor')
            msg.setWindowTitle("Erro")
            msg.exec_()
            blank = 1 
            
        FM = float(self.dlg.lineEdit_21.text())
        if blank == 0 and FM == "":
            msg = QMessageBox()
            msg.setIcon(QMessageBox.Critical)
            msg.setText("O campo FM está vazio")
            msg.setInformativeText('Por favor, insira um valor')
            msg.setWindowTitle("Erro")
            msg.exec_()
            blank = 1
            
        FI = float(self.dlg.lineEdit_22.text())
        if blank == 0 and FI == "":
            msg = QMessageBox()
            msg.setIcon(QMessageBox.Critical)
            msg.setText("O campo FI está vazio")
            msg.setInformativeText('Por favor, insira um valor')
            msg.setWindowTitle("Erro")
            msg.exec_()
            blank = 1
        
        if self.dlg.lineEdit_23.text() == "" or self.dlg.lineEdit_24.text() == "" or self.dlg.lineEdit_25.text() == "":
            msg = QMessageBox()
            msg.setIcon(QMessageBox.Critical)
            msg.setText("O campo AHD não está preenchido corretamente")
            msg.setInformativeText('Por favor, corrija os campos faltantes')
            msg.setWindowTitle("Erro")
            msg.exec_()
            blank = 1
        else:
            if len(str(self.dlg.lineEdit_23.text())) == 1:
                g = '0'+str(self.dlg.lineEdit_23.text())
            else:
                g = str(self.dlg.lineEdit_23.text())
            if len(str(self.dlg.lineEdit_24.text())) == 1:
                m = '0'+str(self.dlg.lineEdit_24.text())
            else:
                m = str(self.dlg.lineEdit_24.text())
            if len(str(self.dlg.lineEdit_25.text())) == 1:
                s = '0'+str(self.dlg.lineEdit_25.text())
            else:
                s = str(self.dlg.lineEdit_25.text())
            AHD = g+'°'+m+'\''+s+'\"'
            
        if self.dlg.lineEdit_26.text() == "" or self.dlg.lineEdit_27.text() == "" or self.dlg.lineEdit_28.text() == "":
            msg = QMessageBox()
            msg.setIcon(QMessageBox.Critical)
            msg.setText("O campo AVD não está preenchido corretamente")
            msg.setInformativeText('Por favor, corrija os campos faltantes')
            msg.setWindowTitle("Erro")
            msg.exec_()
            blank = 1
        else:
            if len(str(self.dlg.lineEdit_26.text())) == 1:
                g = '0'+str(self.dlg.lineEdit_26.text())
            else:
                g = str(self.dlg.lineEdit_26.text())
            if len(str(self.dlg.lineEdit_27.text())) == 1:
                m = '0'+str(self.dlg.lineEdit_27.text())
            else:
                m = str(self.dlg.lineEdit_27.text())
            if len(str(self.dlg.lineEdit_28.text())) == 1:
                s = '0'+str(self.dlg.lineEdit_28.text())
            else:
                s = str(self.dlg.lineEdit_28.text())
            AVD = g+'°'+m+'\''+s+'\"'
            
        if blank == 0:
            num_rows = self.dlg.tableWidget.rowCount()
            if num_rows == 0:
                self.dlg.tableWidget.setRowCount(1)
                self.dlg.tableWidget.setItem(0,0,QTableWidgetItem(str(Tipo)))
                self.dlg.tableWidget.setItem(0,1,QTableWidgetItem(str(Nome)))
                self.dlg.tableWidget.setItem(0,2,QTableWidgetItem(str(Descricao)))
                self.dlg.tableWidget.setItem(0,3,QTableWidgetItem(str(AHD)))
                self.dlg.tableWidget.setItem(0,4,QTableWidgetItem(str(AVD)))
                self.dlg.tableWidget.setItem(0,5,QTableWidgetItem(str(FS)))
                self.dlg.tableWidget.setItem(0,6,QTableWidgetItem(str(FM)))
                self.dlg.tableWidget.setItem(0,7,QTableWidgetItem(str(FI)))
                
            else:
                row = 0
                findIrradiado = 0
                firstIrradiado = 0
                for r in range(self.dlg.tableWidget.rowCount()):
                    if self.dlg.tableWidget.item(r,0).text() == "Irradiado":
                        findIrradiado = 1
                        firstIrradiado = r
                        break
                
                if findIrradiado == 0:
                    self.dlg.tableWidget.setRowCount(num_rows+1)
                    self.dlg.tableWidget.setItem(num_rows,0,QTableWidgetItem(str(Tipo)))
                    self.dlg.tableWidget.setItem(num_rows,1,QTableWidgetItem(str(Nome)))
                    self.dlg.tableWidget.setItem(num_rows,2,QTableWidgetItem(str(Descricao)))
                    self.dlg.tableWidget.setItem(num_rows,3,QTableWidgetItem(str(AHD)))
                    self.dlg.tableWidget.setItem(num_rows,4,QTableWidgetItem(str(AVD)))
                    self.dlg.tableWidget.setItem(num_rows,5,QTableWidgetItem(str(FS)))
                    self.dlg.tableWidget.setItem(num_rows,6,QTableWidgetItem(str(FM)))
                    self.dlg.tableWidget.setItem(num_rows,7,QTableWidgetItem(str(FI)))
                    
                elif Tipo == "Re" or Tipo == "Vante":
                    self.dlg.tableWidget.insertRow(firstIrradiado)
                    self.dlg.tableWidget.setRowCount(num_rows+1)
                    self.dlg.tableWidget.setItem(firstIrradiado,0,QTableWidgetItem(str(Tipo)))
                    self.dlg.tableWidget.setItem(firstIrradiado,1,QTableWidgetItem(str(Nome)))
                    self.dlg.tableWidget.setItem(firstIrradiado,2,QTableWidgetItem(str(Descricao)))
                    self.dlg.tableWidget.setItem(firstIrradiado,3,QTableWidgetItem(str(AHD)))
                    self.dlg.tableWidget.setItem(firstIrradiado,4,QTableWidgetItem(str(AVD)))
                    self.dlg.tableWidget.setItem(firstIrradiado,5,QTableWidgetItem(str(FS)))
                    self.dlg.tableWidget.setItem(firstIrradiado,6,QTableWidgetItem(str(FM)))
                    self.dlg.tableWidget.setItem(firstIrradiado,7,QTableWidgetItem(str(FI)))
                    
                else:
                    self.dlg.tableWidget.setRowCount(num_rows+1)
                    self.dlg.tableWidget.setItem(num_rows,0,QTableWidgetItem(str(Tipo)))
                    self.dlg.tableWidget.setItem(num_rows,1,QTableWidgetItem(str(Nome)))
                    self.dlg.tableWidget.setItem(num_rows,2,QTableWidgetItem(str(Descricao)))
                    self.dlg.tableWidget.setItem(num_rows,3,QTableWidgetItem(str(AHD)))
                    self.dlg.tableWidget.setItem(num_rows,4,QTableWidgetItem(str(AVD)))
                    self.dlg.tableWidget.setItem(num_rows,5,QTableWidgetItem(str(FS)))
                    self.dlg.tableWidget.setItem(num_rows,6,QTableWidgetItem(str(FM)))
                    self.dlg.tableWidget.setItem(num_rows,7,QTableWidgetItem(str(FI)))
            
            self.dlg.comboBox_6.setCurrentText(self.Tipo[0])
            self.dlg.lineEdit_18.setText("")
            self.dlg.lineEdit_19.setText("")
            self.dlg.lineEdit_20.setText("")
            self.dlg.lineEdit_21.setText("")
            self.dlg.lineEdit_22.setText("")
            self.dlg.lineEdit_23.setText("")
            self.dlg.lineEdit_24.setText("")
            self.dlg.lineEdit_25.setText("")
            self.dlg.lineEdit_26.setText("")
            self.dlg.lineEdit_27.setText("")
            self.dlg.lineEdit_28.setText("")
            self.save_changes()
        
    def remove_row(self):
        row = self.dlg.tableWidget.currentRow()
        if row == -1:
            msg = QMessageBox()
            msg.setIcon(QMessageBox.Critical)
            msg.setText("Nenhuma linha foi selecionada ou todas as observações já foram exluidas")
            msg.setInformativeText('Por favor, selecione a linha que deseja excluir ou adicione observações')
            msg.setWindowTitle("Erro")
            msg.exec_()
        else:
            self.dlg.tableWidget.removeRow(row)
            num_rows = self.dlg.tableWidget.rowCount()
            if num_rows == 0:
                msg = QMessageBox()
                msg.setIcon(QMessageBox.Critical)
                msg.setText("Você apagou todas as observações da estação")
                msg.setInformativeText('Por favor, adiciona as respectivas observações')
                msg.setWindowTitle("Alerta")
                msg.exec_()
        
        self.save_changes()
        
    def formato_graus_tabela(self, deg):
        """
        Este tipo de conversão serve para colocar na tabela os dados digitados pelo usuário
        O usuário digita o angulo no formato graus, minutos e segundo, porém não usa a notação adequada.
        Esta função coloca o dado informato na notação adequada e insere o valor na tabela
        """
        grau = int(deg)
        if deg < 0:
            grau = '-'+str(grau)
        else:
            grau = str(grau)
        deg = abs(deg)
        deg = round(deg%1,4)
        deg = deg*100
        min = int(deg)
        min = str(min)
        if len(min) == 1:
            min = '0' + min
        deg = deg%1
        deg = deg*100
        seg = round(deg)
        seg = str(seg)
        if len(seg) == 1:
            seg = '0' + seg
        return grau, min, seg
        
    def formato_graus(self, deg):
        grau = int(deg)
        if deg < 0:
            grau = '-'+str(grau)
        else:
            grau = str(grau)
        deg = abs(deg)
        deg = deg%1
        deg = deg*60
        min = int(deg)
        min = str(min)
        if len(min) == 1:
            min = '0' + min
        deg = deg%1
        deg = deg*60
        seg = round(deg)
        seg = str(seg)
        if len(seg) == 1:
            seg = '0' + seg
        return grau, min, seg
    
    # Converter do formato graus, minutos e segundos para graus decimais
    def converter_graus_decimais(self, d):
            d = d.replace('.','')
            d = d.replace('\"','')
            d = d.replace('\'','')
            d = d.replace('°','.')
            if d[0] == '-':
                d = d[1:]
                d = float(d)
                d_conv = int(d) + int(round(d - int(d),4)*100)/60 + ((((round(d - int(d),4)*100)%1)*100)/3600)
            else:
                d = float(d)
                d_conv = int(d) + int(round(d - int(d),4)*100)/60 + ((((round(d - int(d),4)*100)%1)*100)/3600)
            return d_conv

    def degrees_radians(self, deg):
        deg = deg*math.pi/180
        return deg
        
    def radians_degrees(self, rad):
        deg = rad*180/math.pi
        return deg
          
    
    def verificar(self):
        # Verificar se os dados estão corretos
        Cont = []
        NameSta = []
        Name = []
        NameRe = []
        NameVante = []
        sair = 0
        for row1 in range(len(self.list_Sta)):
            Cont.extend([0,0])
            stopName = 0
            for row in self.Caderneta_Topografica.index:
                if self.Caderneta_Topografica['Estacao'][row] == self.list_Sta[row1]:
                    if self.Caderneta_Topografica['Tipo'][row] == "Re":
                        Cont[-2] += 1
                        if Cont[-2] < Cont[-1]:
                            msg = QMessageBox()
                            msg.setIcon(QMessageBox.Critical)
                            msg.setText("A Re está sendo colocada depois da Vante")
                            msg.setInformativeText('Por favor, coloque a Re primeiro')
                            msg.setWindowTitle("Erro")
                            msg.exec_()
                            sair = 1
                        if self.Caderneta_Topografica['Nome'][row] not in NameRe:
                            NameSta.append(self.list_Sta[row1])
                            NameRe.append(self.Caderneta_Topografica['Nome'][row])
                    elif self.Caderneta_Topografica['Tipo'][row] == "Vante":
                        Cont[-1] += 1
                        if self.Caderneta_Topografica['Nome'][row] not in NameVante:
                            NameSta.append(self.list_Sta[row1])
                            NameVante.append(self.Caderneta_Topografica['Nome'][row])
                            if stopName == 0:
                                Name.append(NameRe[-1])
                                Name.append(NameVante[-1])
                                stopName = 1
                if sair == 1:
                    break
            if sair == 1:
                break
                
        for i in Cont:
            if i == 0:
                sair = 1
                msg = QMessageBox()
                msg.setIcon(QMessageBox.Critical)
                msg.setText("É necessário informar ao menos uma Ré e uma Vante para cada estação")
                msg.setInformativeText('Por favor, verifique quais dados estão faltando')
                msg.setWindowTitle("Erro")
                msg.exec_()
                break
                
        for i in range(0,len(Cont),2):
            if Cont[i] != Cont[i+1]:
                sair = 1
                msg = QMessageBox()
                msg.setIcon(QMessageBox.Critical)
                msg.setText("Alguma estação está com número desbalanceado de Ré e Vante")
                msg.setInformativeText('Por favor, coloque o mesmo número de Ré e Vante para cada estação')
                msg.setWindowTitle("Erro")
                msg.exec_()
                break
        
        if sair != 1:
            # Reseting the number of rows for the distance table
            self.dlg.tableWidget_3.setRowCount(sum(Cont))
            
            Filled = []
            r = 0
            l_Mean = []
            Pears_Table = []
            Simple_Pears_Table = []
            for sta in range(len(NameSta)):
                if NameSta[sta]+Name[sta] not in Filled:
                    #for l in range(2*Cont[sta]):
                        #row = self.dlg.tableWidget_3.rowCount()
                        #self.dlg.tableWidget_3.insertRow(row)
                    Filled.append(NameSta[sta]+Name[sta])
                    Filled.append(Name[sta]+NameSta[sta])
                    l_Mean.append(2*Cont[sta])
                    
                    Pears_Table.append(Cont[sta])
                    
                    for row in range(Cont[sta]):
                        self.dlg.tableWidget_3.setItem(r, 0, QTableWidgetItem(str(NameSta[sta])))
                        self.dlg.tableWidget_3.setItem(r, 1, QTableWidgetItem(str(Name[sta])))
                        r += 1
                        
                    for l in range(len(NameSta)):
                        if Name[sta] == NameSta[l] and NameSta[sta] == Name[l]:
                            Num_Cont = l
                            Pears_Table.append(Cont[Num_Cont])
                        
                    for row in range(Cont[Num_Cont]):
                        self.dlg.tableWidget_3.setItem(r, 0, QTableWidgetItem(str(Name[sta])))
                        self.dlg.tableWidget_3.setItem(r, 1, QTableWidgetItem(str(NameSta[sta])))
                        r += 1
                        
                    Simple_Pears_Table.append(Cont[sta] + Cont[Num_Cont])

            l = []
            for row in self.Caderneta_Topografica.index:
                found = 0
                for row1 in range(self.dlg.tableWidget_3.rowCount()):
                    if self.Caderneta_Topografica['Estacao'][row] == self.dlg.tableWidget_3.item(row1,0).text() and self.Caderneta_Topografica['Nome'][row] == self.dlg.tableWidget_3.item(row1,1).text() and found == 0:
                        if self.dlg.tableWidget_3.item(row1,2) == None:
                            found = 1
                            alpha = (self.converter_graus_decimais(self.Caderneta_Topografica['AVD'][row]))
                            if alpha <= 180:
                                alpha = self.degrees_radians(90 - alpha)
                            else: 
                                alpha = self.degrees_radians(alpha - 270)
                            DH_prov = 100*(float(self.Caderneta_Topografica['FS'][row]) - float(self.Caderneta_Topografica['FI'][row]))*(math.cos(alpha))**2
                            self.dlg.tableWidget_3.setItem(row1, 2, QTableWidgetItem(str("{:.3f}".format(round(DH_prov, 3)))))
                            Desnivel = 50*(float(self.Caderneta_Topografica['FS'][row]) - float(self.Caderneta_Topografica['FI'][row]))*math.sin(2*alpha) + float(self.Caderneta_Topografica['Altura'][row]) - float(self.Caderneta_Topografica['FM'][row])
                            if Desnivel > 0:
                                self.dlg.tableWidget_3.setItem(row1, 5, QTableWidgetItem("+"+str("{:.3f}".format(round(Desnivel, 3)))))
                            else:
                                self.dlg.tableWidget_3.setItem(row1, 5, QTableWidgetItem(str("{:.3f}".format(round(Desnivel, 3)))))
        
        DH = []
        Desnivel = []
        DesnivelABS = []
        for row in range(self.dlg.tableWidget_3.rowCount()):
            DH.append(float(self.dlg.tableWidget_3.item(row,2).text()))
            Desnivel.append(float(self.dlg.tableWidget_3.item(row,5).text()))
            DesnivelABS.append(abs(float(self.dlg.tableWidget_3.item(row,5).text())))

        for l in range(len(Simple_Pears_Table)):
            if l == 0:
                Mean1 = "{:.3f}".format(round(st.mean(DH[0:Simple_Pears_Table[l]]), 3))
                Mean2 = "{:.3f}".format(round(st.mean(DesnivelABS[0:Simple_Pears_Table[l]]), 3))
                for m in range(0,Simple_Pears_Table[l]):
                    self.dlg.tableWidget_3.setItem(m, 3, QTableWidgetItem(str(Mean1)))
                    if Desnivel[m] > 0:
                        self.dlg.tableWidget_3.setItem(m, 6, QTableWidgetItem("+"+str(Mean2)))
                    elif Desnivel[m] < 0:
                        self.dlg.tableWidget_3.setItem(m, 6, QTableWidgetItem("-"+str(Mean2)))
                    else:
                        self.dlg.tableWidget_3.setItem(m, 6, QTableWidgetItem(str(Mean2)))
                    Dif = float(self.dlg.tableWidget_3.item(m,5).text()) - float(self.dlg.tableWidget_3.item(m,6).text())
                    if Dif > 0:
                        self.dlg.tableWidget_3.setItem(m, 7, QTableWidgetItem("+"+str("{:.3f}".format(round(Dif, 3)))))
                    else:
                        self.dlg.tableWidget_3.setItem(m, 7, QTableWidgetItem(str("{:.3f}".format(round(Dif, 3)))))

            else:
                Mean1 = round(st.mean(DH[sum(Simple_Pears_Table[0:l]):sum(Simple_Pears_Table[0:l+1])]), 3)
                Mean2 = round(st.mean(DesnivelABS[sum(Simple_Pears_Table[0:l]):sum(Simple_Pears_Table[0:l+1])]), 3)
                for m in range(sum(Simple_Pears_Table[0:l]),sum(Simple_Pears_Table[0:l+1])):
                    self.dlg.tableWidget_3.setItem(m, 3, QTableWidgetItem(str(Mean1)))
                    if Desnivel[m] > 0:
                        self.dlg.tableWidget_3.setItem(m, 6, QTableWidgetItem("+"+str(Mean2)))
                    elif Desnivel[m] < 0:
                        self.dlg.tableWidget_3.setItem(m, 6, QTableWidgetItem("-"+str(Mean2)))
                    else:
                        self.dlg.tableWidget_3.setItem(m, 6, QTableWidgetItem(str(Mean2)))
                    Dif = float(self.dlg.tableWidget_3.item(m,5).text()) - float(self.dlg.tableWidget_3.item(m,6).text())
                    if Dif > 0:
                        self.dlg.tableWidget_3.setItem(m, 7, QTableWidgetItem("+"+str("{:.3f}".format(round(Dif, 3)))))
                    else:
                        self.dlg.tableWidget_3.setItem(m, 7, QTableWidgetItem(str("{:.3f}".format(round(Dif, 3)))))
                
        for row in range(self.dlg.tableWidget_3.rowCount()):
            v1 = float(self.dlg.tableWidget_3.item(row,2).text())
            v2 = float(self.dlg.tableWidget_3.item(row,3).text())
            dif = v1 - v2
            dif = round(dif, 3)
            if dif > 0:
                self.dlg.tableWidget_3.setItem(row, 4, QTableWidgetItem("+"+str(dif)))
            elif dif < 0:
                self.dlg.tableWidget_3.setItem(row, 4, QTableWidgetItem(str(dif)))
            else:
                self.dlg.tableWidget_3.setItem(row, 4, QTableWidgetItem(str("{:.3f}".format(round(dif, 3)))))
                    
        #-------------------------------------------------------------------------------
        #-------------------------------------------------------------------------------
            
            # Defining the number of rows for the angles table
            TableNumberRows = 0
            for i in range(0,len(Cont),2):
                TableNumberRows += Cont[i]
                self.dlg.tableWidget_7.setRowCount(TableNumberRows)
            r = 0
            First = 0
            Last = 0
            
            for row1 in range(len(self.list_Sta)):
                ListAHC = []
                for row in self.Caderneta_Topografica.index:
                    if self.Caderneta_Topografica['Estacao'][row] == self.list_Sta[row1]:
                        if self.Caderneta_Topografica['Tipo'][row] == "Re":
                            self.dlg.tableWidget_7.setItem(r, 0, QTableWidgetItem(str(self.Caderneta_Topografica['Nome'][row])))
                            self.dlg.tableWidget_7.setItem(r, 1, QTableWidgetItem(str(self.Caderneta_Topografica['Estacao'][row])))
                            self.dlg.tableWidget_7.setItem(r, 2, QTableWidgetItem(str(self.Caderneta_Topografica['Nome'][row+1])))
                            d1 = self.converter_graus_decimais(self.Caderneta_Topografica['AHD'][row+1])
                            d2 = self.converter_graus_decimais(self.Caderneta_Topografica['AHD'][row])
                            if d1 - d2 < 0:
                                deg = d1 - d2 + 360
                                ListAHC.append(deg)
                                g, m, s = self.formato_graus(deg)
                                d = g+'°'+m+'\''+s+'\"'
                                self.dlg.tableWidget_7.setItem(r, 3, QTableWidgetItem(str(d)))
                            else:
                                deg = d1 - d2
                                ListAHC.append(deg)
                                g, m, s = self.formato_graus(deg)
                                d = g+'°'+m+'\''+s+'\"'
                                self.dlg.tableWidget_7.setItem(r, 3, QTableWidgetItem(str(d)))
                            r += 1
                            Last += 1
                meanAHC = st.mean(ListAHC)
                g, m, s = self.formato_graus(meanAHC)
                d = g+'°'+m+'\''+s+'\"'
                for i, j in zip(range(First,Last), range(len(ListAHC))):
                    self.dlg.tableWidget_7.setItem(i, 4, QTableWidgetItem(str(d)))
                    Dif = ListAHC[j] - meanAHC
                    g, m, s = self.formato_graus(Dif)
                    if g[0] == '-':
                        d2 = g+'°'+m+'\''+s+'\"'
                    else:
                        d2 = '+'+g+'°'+m+'\''+s+'\"'
                    self.dlg.tableWidget_7.setItem(i, 5, QTableWidgetItem(str(d2)))
                First = Last
                
    def Filtragem(self, degree):
        if degree < 180:
           degree = degree + 180
        elif degree >= 180 and degree <= 540:
            degree = degree - 180
        elif degree > 540:
            degree = degree - 540
        return degree
        
    def Compensar(self, Az, DX, DY):
        if DX > 0 and DY > 0:
            # 1 Quadrante
            Az = Az
        elif DX > 0 and DY < 0:
            # 2 Quadrante
            Az = Az +180
        elif DX < 0 and DY < 0:
            # 3 Quadrante
            Az = Az + 180
        else:
            # 4 Quadrante
            Az = Az + 360
        if Az > 360:
            Az = Az - 360
        return Az
    
    def calcular(self):
        # Change tab to Resultados
        self.dlg.tabWidget.setCurrentIndex(4)
        
        self.dlg.comboBox_2.setCurrentText(self.list_Sta_Correto[0])
        self.dlg.comboBox_3.setCurrentText(self.list_Sta_Correto[-2])
        self.dlg.comboBox_4.setCurrentText(self.list_Sta_Correto[0])
        
        # Número de linhas tabela 6, 8 e 9
        self.dlg.tableWidget_6.setRowCount(len(self.list_Sta_Correto)*2)
        self.dlg.tableWidget_8.setRowCount(len(self.list_Sta_Correto)-1)
        self.dlg.tableWidget_9.setRowCount(len(self.list_Sta_Correto)-1)
        
        # Preenchendo o erro angular na tabela 2 dos dados de fechamento da poligonal
        InternalAngles = (len(self.list_Sta) - 2) * 180
        ExternalAngles = (len(self.list_Sta) + 2) * 180
        SumAngles = 0
        for i in range(len(self.list_Sta_Correto) - 1):
            for j in range(self.dlg.tableWidget_7.rowCount()):
                if self.list_Sta_Correto[i] == self.dlg.tableWidget_7.item(j,1).text():
                    deg = self.converter_graus_decimais(self.dlg.tableWidget_7.item(j, 4).text())
                    SumAngles += deg
                    break
        Error1 = SumAngles - InternalAngles
        Error2 = SumAngles - ExternalAngles
        if abs(Error1) < abs(Error2):
            Angle = InternalAngles
            Error = Error1
        else:
            Angle = ExternalAngles
            Error = Error2
        g, m, s = self.formato_graus(Error)
        AngleError = g + '°' + m + '\'' + s + '\"'
        self.dlg.tableWidget_5.setItem(0, 0, QTableWidgetItem(str(AngleError)))
        
        # Preenchendo a coluna estações na tabela Poligonal Calculada
        for row in range(len(self.list_Sta_Correto)):
            self.dlg.tableWidget_6.setItem(row*2, 0, QTableWidgetItem(str(self.list_Sta_Correto[row])))
        #self.dlg.tableWidget_6.setItem(len(self.list_Sta)*2, 0, QTableWidgetItem(str(self.list_Sta[0])))
        
        # Preenchendo a coluna AH na tabela poligonal calculada
        SecondAngleError = (Error * 3600)
        EachSecondAngleError = round(SecondAngleError/(len(self.list_Sta_Correto)-1))
        LastSecondAngleError = SecondAngleError - (len(self.list_Sta_Correto) - 2) * EachSecondAngleError
        for i in range(len(self.list_Sta_Correto) - 2):
            for j in range(self.dlg.tableWidget_7.rowCount()):
                if self.list_Sta_Correto[i] == self.dlg.tableWidget_7.item(j,1).text(): #and (self.list_Sta_Correto[i+1] == self.dlg.tableWidget_7.item(j,0).text() or self.list_Sta_Correto[i+1] == self.dlg.tableWidget_7.item(j,2).text()):
                    AHM_seconds = (self.converter_graus_decimais(self.dlg.tableWidget_7.item(j,4).text()) *3600)
                    AH_seconds = AHM_seconds - EachSecondAngleError
                    AH_g, AH_m, AH_s = self.formato_graus(AH_seconds / 3600)
                    AH = AH_g + '°' + AH_m + '\'' + AH_s + '\"'
                    self.dlg.tableWidget_6.setItem(i*2, 1, QTableWidgetItem(str(AH)))
                    break
        Last = len(self.list_Sta_Correto) - 2
        for j in range(self.dlg.tableWidget_7.rowCount()):
            if self.list_Sta_Correto[-2] == self.dlg.tableWidget_7.item(j,1).text(): #and (self.list_Sta_Correto[-1] == self.dlg.tableWidget_7.item(j,0).text() or self.list_Sta_Correto[-1] == self.dlg.tableWidget_7.item(j,2).text()):
                Last_AHM_seconds = (self.converter_graus_decimais(self.dlg.tableWidget_7.item(j,4).text()) *3600)
                Last_AH_seconds = Last_AHM_seconds - LastSecondAngleError
                Last_AH_g, Last_AH_m, Last_AH_s = self.formato_graus(Last_AH_seconds / 3600)
                Last_AH = Last_AH_g + '°' + Last_AH_m + '\'' + Last_AH_s + '\"'
                self.dlg.tableWidget_6.setItem(Last*2, 1, QTableWidgetItem(str(Last_AH)))
                break

        # Preencher o campo Azimute na tabela configurações se não tiver sido preenchido
        if self.dlg.lineEdit_13.text() == "":
            self.dlg.lineEdit_13.setText("0")
        if self.dlg.lineEdit_32.text() == "":
            self.dlg.lineEdit_32.setText("00")
        if self.dlg.lineEdit_31.text() == "":
            self.dlg.lineEdit_31.setText("00")
            
        g = str(self.dlg.lineEdit_13.text())
        if len(str(self.dlg.lineEdit_32.text())) == 1:
            m = '0'+str(self.dlg.lineEdit_32.text())
        else:
            m = str(self.dlg.lineEdit_32.text())
        if len(str(self.dlg.lineEdit_31.text())) == 1:
            s = '0'+str(self.dlg.lineEdit_31.text())
        else:
            s = str(self.dlg.lineEdit_31.text())
        Azimute_Inicial = g+'°'+m+'\''+s+'\"'
            
        # Preencher o campo Azimute na tabela 2 da guia cálculos
        Azimute = self.converter_graus_decimais(Azimute_Inicial) + self.converter_graus_decimais(self.dlg.tableWidget_6.item(0,1).text())
        Azimute = self.Filtragem(Azimute)
        g, m, s = self.formato_graus(Azimute)
        self.dlg.tableWidget_9.setItem(0, 1, QTableWidgetItem(str(g + '°' + m + '\'' + s + '\"')))
        for row in range(1, len(self.list_Sta_Correto)-1):
            Azimute = Azimute + self.converter_graus_decimais(self.dlg.tableWidget_6.item(row*2,1).text())
            Azimute = self.Filtragem(Azimute)
            g, m, s = self.formato_graus(Azimute)
            self.dlg.tableWidget_9.setItem(row, 1, QTableWidgetItem(str(g + '°' + m + '\'' + s + '\"')))
           
        # Calculo do DH médio
        PerimetroDescompensado = 0
        for i in range(len(self.list_Sta_Correto)-1):
            Est1 = self.list_Sta_Correto[i]
            Est2 = self.list_Sta_Correto[i+1]
            for num_row in range(self.dlg.tableWidget_3.rowCount()):
                if self.dlg.tableWidget_3.item(num_row,0).text() == Est1 and self.dlg.tableWidget_3.item(num_row,1).text() == Est2:
                    self.dlg.tableWidget_8.setItem(i, 1, QTableWidgetItem(str(self.dlg.tableWidget_3.item(num_row,3).text())))
                    PerimetroDescompensado += float(self.dlg.tableWidget_3.item(num_row,3).text())
                    break
        
        
        Altimetria = 0
        for i in range(len(self.list_Sta_Correto)-1):
            Est1 = self.list_Sta_Correto[i]
            Est2 = self.list_Sta_Correto[i+1]
            for num_row in range(self.dlg.tableWidget_3.rowCount()):
                if self.dlg.tableWidget_3.item(num_row,0).text() == Est1 and self.dlg.tableWidget_3.item(num_row,1).text() == Est2:
                    Altimetria = Altimetria + float(self.dlg.tableWidget_3.item(num_row,6).text())
                    break        
        self.dlg.tableWidget_5.setItem(5, 0, QTableWidgetItem(str("{:.3f}".format(round(Altimetria, 3)))+"m"))
        
        # Preencher o Delta h medio da aba cálculos e o desnível na tabela poligonal calculada na aba resultado
        EachAltimetria = round(-Altimetria/(len(self.list_Sta)),3)
        LastAltimetria = - Altimetria - (len(self.list_Sta_Correto) - 2) * EachAltimetria
        for i in range(len(self.list_Sta_Correto)-2):
            Est1 = self.list_Sta_Correto[i]
            Est2 = self.list_Sta_Correto[i+1]
            for num_row in range(self.dlg.tableWidget_3.rowCount()):
                if self.dlg.tableWidget_3.item(num_row,0).text() == Est1 and self.dlg.tableWidget_3.item(num_row,1).text() == Est2:
                    self.dlg.tableWidget_6.setItem(i*2+1, 3, QTableWidgetItem(str("{:.3f}".format(round(float(self.dlg.tableWidget_3.item(num_row,6).text())+EachAltimetria, 3)))))
                    self.dlg.tableWidget_9.setItem(i, 2, QTableWidgetItem(str("{:.3f}".format(round(float(self.dlg.tableWidget_3.item(num_row,6).text()), 3)))))
                    break
                    
        Est1 = self.list_Sta_Correto[-2]
        Est2 = self.list_Sta_Correto[-1]
        for num_row in range(self.dlg.tableWidget_3.rowCount()):
            if self.dlg.tableWidget_3.item(num_row,0).text() == Est1 and self.dlg.tableWidget_3.item(num_row,1).text() == Est2:
                self.dlg.tableWidget_6.setItem((len(self.list_Sta_Correto)-2)*2+1, 3, QTableWidgetItem(str("{:.3f}".format(round(float(self.dlg.tableWidget_3.item(num_row,6).text())+LastAltimetria, 3)))))
                self.dlg.tableWidget_9.setItem((len(self.list_Sta_Correto)-2), 2, QTableWidgetItem(str("{:.3f}".format(round(float(self.dlg.tableWidget_3.item(num_row,6).text()), 3)))))
        # Preencher os campos estação de chegada na aba configurações
        self.dlg.lineEdit_7.setText(str(self.dlg.lineEdit_4.text()))
        self.dlg.lineEdit_8.setText(str(self.dlg.lineEdit_5.text()))
        self.dlg.lineEdit_9.setText(str(self.dlg.lineEdit_6.text()))
        
        # Preencher parte do x, y e z na tabela poligonal calculada na aba resultados
        self.dlg.tableWidget_6.setItem(0, 5, QTableWidgetItem("{:.3f}".format(round(float(self.dlg.lineEdit_4.text()), 3))))
        self.dlg.tableWidget_6.setItem(0, 6, QTableWidgetItem("{:.3f}".format(round(float(self.dlg.lineEdit_5.text()), 3))))
        self.dlg.tableWidget_6.setItem(0, 7, QTableWidgetItem("{:.3f}".format(round(float(self.dlg.lineEdit_6.text()), 3))))
    
        # Calculo do Erro do Eixo x e y
        DeltaX = 0
        DeltaY = 0
        for row in range(len(self.list_Sta_Correto)-1):
            angulo = math.radians(self.converter_graus_decimais(self.dlg.tableWidget_9.item(row, 1).text()))
            self.dlg.tableWidget_8.setItem(row, 2, QTableWidgetItem(str(("{:.3f}".format(round(float(self.dlg.tableWidget_8.item(row, 1).text()) * math.sin(angulo), 3))))))
            DeltaX = DeltaX + (float(self.dlg.tableWidget_8.item(row, 1).text()) * math.sin(angulo))
            self.dlg.tableWidget_8.setItem(row, 3, QTableWidgetItem(str("{:.3f}".format(round(float(self.dlg.tableWidget_8.item(row, 1).text()) * math.cos(angulo), 3)))))
            DeltaY = DeltaY + (float(self.dlg.tableWidget_8.item(row, 1).text()) * math.cos(angulo))
        self.dlg.tableWidget_5.setItem(3, 0, QTableWidgetItem(str("{:.3f}".format(round(DeltaX, 3)))+'m'))
        self.dlg.tableWidget_5.setItem(4, 0, QTableWidgetItem(str("{:.3f}".format(round(DeltaY, 3)))+'m'))
        
        # Cálculo do kx e ky
        kx = - DeltaX / PerimetroDescompensado
        ky = - DeltaY / PerimetroDescompensado
        
        # Cálculo do Cx e Cy
        for num_row in range(self.dlg.tableWidget_8.rowCount()):
            Cx = float(self.dlg.tableWidget_8.item(num_row, 1).text()) * kx
            DeltaXCorrigido = float(self.dlg.tableWidget_8.item(num_row, 2).text()) + Cx
            Cy = float(self.dlg.tableWidget_8.item(num_row, 1).text()) * ky
            DeltaYCorrigido = float(self.dlg.tableWidget_8.item(num_row, 3).text()) + Cy
            self.dlg.tableWidget_8.setItem(num_row, 4, QTableWidgetItem(str("{:.3f}".format(round(Cx, 3)))))
            self.dlg.tableWidget_8.setItem(num_row, 6, QTableWidgetItem(str("{:.3f}".format(round(DeltaXCorrigido, 3)))))
            self.dlg.tableWidget_8.setItem(num_row, 5, QTableWidgetItem(str("{:.3f}".format(round(Cy, 3)))))
            self.dlg.tableWidget_8.setItem(num_row, 7, QTableWidgetItem(str("{:.3f}".format(round(DeltaYCorrigido, 3)))))
        
        # Preencher o erro linear na tabela 2 de dados de fechamento da poligonal na aba resultado
        ErroLinear = math.sqrt(DeltaX**2 + DeltaY**2)
        self.dlg.tableWidget_5.setItem(2, 0, QTableWidgetItem(str("{:.3f}".format(round(ErroLinear, 3)))+'m'))
        
        # Preencher o campo alinhamento nas duas tabelas da aba cálculos
        for i in range(len(self.list_Sta_Correto)-1):
            self.dlg.tableWidget_8.setItem(i, 0, QTableWidgetItem(str(self.list_Sta_Correto[i]+"-"+self.list_Sta_Correto[i+1])))
            self.dlg.tableWidget_9.setItem(i, 0, QTableWidgetItem(str(self.list_Sta_Correto[i]+"-"+self.list_Sta_Correto[i+1])))
             
        # Cálculo do X, Y, Z, DH compensado e Perimetro compensado
        X = float(self.dlg.lineEdit_4.text())
        Y = float(self.dlg.lineEdit_5.text())
        Z = float(self.dlg.lineEdit_6.text())
        PerimetroCompensado = 0
        for row in range(1, len(self.list_Sta_Correto)):
            X_prev = X
            X += float(self.dlg.tableWidget_8.item(row-1, 6).text())
            self.dlg.tableWidget_6.setItem(row*2, 5, QTableWidgetItem("{:.3f}".format(round(X, 3))))
            Y_prev = Y
            Y += float(self.dlg.tableWidget_8.item(row-1, 7).text())
            self.dlg.tableWidget_6.setItem(row*2, 6, QTableWidgetItem("{:.3f}".format(round(Y, 3))))
            DH = math.sqrt((X - X_prev)**2 + (Y - Y_prev)**2)
            PerimetroCompensado += DH
            self.dlg.tableWidget_6.setItem(row*2-1, 2, QTableWidgetItem("{:.3f}".format(round(DH, 3))))
            Z += float(self.dlg.tableWidget_6.item(row*2-1, 3).text())
            self.dlg.tableWidget_6.setItem(row*2, 7, QTableWidgetItem("{:.3f}".format(round(Z, 3))))
        self.dlg.tableWidget_4.setItem(0, 0, QTableWidgetItem("{:.3f}".format(round(PerimetroCompensado, 3))+"m"))
        
        self.dlg.tableWidget_6.setItem((len(self.list_Sta_Correto)-1)*2, 5, QTableWidgetItem("{:.3f}".format(round(float(self.dlg.lineEdit_4.text()), 3))))
        self.dlg.tableWidget_6.setItem((len(self.list_Sta_Correto)-1)*2, 6, QTableWidgetItem("{:.3f}".format(round(float(self.dlg.lineEdit_5.text()), 3))))
        self.dlg.tableWidget_6.setItem((len(self.list_Sta_Correto)-1)*2, 7, QTableWidgetItem("{:.3f}".format(round(float(self.dlg.lineEdit_6.text()), 3))))

        g = str(self.dlg.lineEdit.text())
        if len(str(self.dlg.lineEdit_30.text())) == 1:
            m = '0'+str(self.dlg.lineEdit_30.text())
            self.dlg.lineEdit_30.setText(m)
        else:
            m = str(self.dlg.lineEdit_30.text())
        if len(str(self.dlg.lineEdit_29.text())) == 1:
            s = '0'+str(self.dlg.lineEdit_29.text())
            self.dlg.lineEdit_29.setText(s)
        else:
            s = str(self.dlg.lineEdit_29.text())
        AngleError = g+'°'+m+'\''+s+'\"'
        
        AngleErrorCalculated = self.converter_graus_decimais(AngleError) * math.sqrt(len(self.list_Sta))
        g, m, s = self.formato_graus(AngleErrorCalculated)
        
        TolAngleError = str(g)+'°'+str(m)+'\''+str(s)+'\"'
        
        self.dlg.tableWidget_5.setItem(0, 1, QTableWidgetItem(TolAngleError))
        self.dlg.tableWidget_5.setItem(1, 1, QTableWidgetItem("1:"+str(self.dlg.lineEdit_3.text())))
        TolAlt = (float(self.dlg.lineEdit_2.text())/1000) * math.sqrt(PerimetroCompensado/1000)
        self.dlg.tableWidget_5.setItem(5, 1, QTableWidgetItem("{:.3f}".format(round(TolAlt, 3))+"m ("+str(self.dlg.lineEdit_2.text())+"mm x K^(1/2))"))

        # Cálculo do Azimute na tabela da poligonal calculada na aba resultado
        for row in range(len(self.list_Sta_Correto)-1):
            DeltaXCorrigido = float(self.dlg.tableWidget_8.item(row, 6).text())
            DeltaYCorrigido = float(self.dlg.tableWidget_8.item(row, 7).text())
            Theta = math.degrees(math.atan(DeltaXCorrigido/DeltaYCorrigido))
            AzimuteCompensado = self.Compensar(Theta, DeltaXCorrigido, DeltaYCorrigido)
            AZ_g, AZ_m, AZ_s = self.formato_graus(AzimuteCompensado)
            AzimuteCompensadoGMS = AZ_g + '°' + AZ_m + '\'' + AZ_s + '\"'
            self.dlg.tableWidget_6.setItem(row*2+1, 4, QTableWidgetItem(str(AzimuteCompensadoGMS)))
        
        # Erro relativo na tabela 2 de dados de fechamento da poligonal
        self.dlg.tableWidget_5.setItem(1, 0, QTableWidgetItem("1:"+"{:.0f}".format(round(PerimetroCompensado/ErroLinear, 0))))

        if PerimetroCompensado/ErroLinear < float(self.dlg.lineEdit_3.text()):
            msg = QMessageBox()
            msg.setIcon(QMessageBox.Critical)
            msg.setText("Erro relativo fora da tolerância")
            msg.setInformativeText('Verifique a tolerância relativa linear')
            msg.setWindowTitle("Alerta")
            msg.exec_()
        
        if Altimetria > TolAlt:
            msg = QMessageBox()
            msg.setIcon(QMessageBox.Critical)
            msg.setText("Erro altimétrico fora da tolerância")
            msg.setInformativeText('Verifique a tolerância altimétrica')
            msg.setWindowTitle("Alerta")
            msg.exec_()
               
        # Cálculo da Área
        Area = 0
        for row in range(len(self.list_Sta_Correto)-1):
            Area += float(self.dlg.tableWidget_6.item(row*2, 5).text()) * float(self.dlg.tableWidget_6.item((row+1)*2, 6).text()) - float(self.dlg.tableWidget_6.item(row*2, 6).text()) * float(self.dlg.tableWidget_6.item((row+1)*2, 5).text())
        self.dlg.tableWidget_4.setItem(1, 0, QTableWidgetItem("{:.3f}".format(round(abs(Area)/2, 3))+"m²"))
        
    def verificar_campos_vazios(self):

        linhas = self.dlg.tableWidget_2.rowCount()
        self.list_Sta_Correto = []

        for row in range(linhas):
            if self.dlg.tableWidget_2.cellWidget(row,0).currentText() != "":
                self.list_Sta_Correto.append(self.dlg.tableWidget_2.cellWidget(row,0).currentText())
        erro1 = 0
        erro2 = 0
        erro3 = 0
        erro4 = 0
        
        for i in range(len(self.list_Sta)):
            if self.list_Sta[i] not in self.list_Sta_Correto:
                erro1 = 1
                break
        if len(self.list_Sta)+1 != len(self.list_Sta_Correto):
            erro2 = 1

        if len(self.list_Sta_Correto) != 0:
            if self.list_Sta_Correto[0] != self.list_Sta_Correto[-1]:
                erro3 = 1
            
        if self.dlg.lineEdit_4.text() == "" or self.dlg.lineEdit_5.text() == "" or self.dlg.lineEdit_6.text() == "":
                erro4 = 1
        
        if str(self.dlg.lineEdit.text()) == "" or str(self.dlg.lineEdit_30.text()) == "" or str(self.dlg.lineEdit_29.text()) == "" or str(self.dlg.lineEdit_2.text()) == "" or str(self.dlg.lineEdit_3.text()) == "":
            msg = QMessageBox()
            msg.setIcon(QMessageBox.Critical)
            msg.setText("Erro no campo das tolerâncias")
            msg.setInformativeText('Por favor, preencha todos os campos da tolerância')
            msg.setWindowTitle("Erro")
            msg.exec_()
        elif erro1 == 1 or erro2 == 1:
            msg = QMessageBox()
            msg.setIcon(QMessageBox.Critical)
            msg.setText("Erro no campo das estações")
            msg.setInformativeText('Por favor, preencha todos os campos das estações')
            msg.setWindowTitle("Erro")
            msg.exec_()
        elif erro3 == 1:
            msg = QMessageBox()
            msg.setIcon(QMessageBox.Critical)
            msg.setText("Erro no campo das estações")
            msg.setInformativeText('A estação de partida deve ser a mesma estação de chegada, pois esta versão calcula apenas poligonais fechadas')
            msg.setWindowTitle("Erro")
            msg.exec_()
        elif erro4 == 1:
            msg = QMessageBox()
            msg.setIcon(QMessageBox.Critical)
            msg.setText("Erro no campo Estação de Partida")
            msg.setInformativeText('Os campos X, Y e Z em estação de partida devem ser preenchidos')
            msg.setWindowTitle("Erro")
            msg.exec_()
        else:
            self.calcular()
            
    def cria_camada_xyz(self):
        #Criando Vetores com as Coordenadas TOTAIS X Y Z
        row = self.dlg.tableWidget_6.rowCount()
        Xcoord = []
        Ycoord = []
        Zcoord = []
        for i in range(0,row-2,2):
            Xc = float(self.dlg.tableWidget_6.item(i,5).text())
            Yc = float(self.dlg.tableWidget_6.item(i,6).text())
            Zc = float(self.dlg.tableWidget_6.item(i,7).text())
            Xcoord.append(Xc)
            Ycoord.append(Yc)
            Zcoord.append(Zc)

        # Cria camada temporária de pontos XY - EPSG desconhecido
        layer =  QgsVectorLayer('Point?crs=epsg:0', 'MyPoint' , "memory")
        pr = layer.dataProvider()
        pt = QgsFeature()
        for i in range(len(Xcoord)):
            pontosxy = QgsPointXY(Xcoord[i],Ycoord[i])
            pt.setGeometry(QgsGeometry.fromPointXY(pontosxy))
            pr.addFeatures([pt])
            layer.updateExtents()
            QgsProject.instance().addMapLayers([layer])

    def run(self):
        """Run method that performs all the real work"""
        
        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = TopographyDialog()
            
        self.dlg.pushButton_select_file.clicked.connect(self.select_file)        
        
        # Fill the head of the table
        self.dlg.tableWidget.setColumnCount(8)
        labels = ['Tipo','Nome','Descricao','AHD','AVD','FS (m)','FM (m)','FI (m)']
        self.dlg.tableWidget.setHorizontalHeaderLabels(labels)
        self.dlg.tableWidget.setRowCount(15)
        self.dlg.tableWidget.setAlternatingRowColors(True)
        self.dlg.tableWidget_2.setAlternatingRowColors(True)
        self.dlg.tableWidget_3.setAlternatingRowColors(True)
        self.dlg.tableWidget_4.setAlternatingRowColors(True)
        self.dlg.tableWidget_5.setAlternatingRowColors(True)
        self.dlg.tableWidget_6.setAlternatingRowColors(True)
        self.dlg.tableWidget_7.setAlternatingRowColors(True)
        self.dlg.tableWidget_8.setAlternatingRowColors(True)
        self.dlg.tableWidget_9.setAlternatingRowColors(True)
                       
        self.dlg.comboBox.currentIndexChanged.connect(self.selectionchange)
        
        # Modificar o conteúdo do comboBox 2, 3 e 4
        self.dlg.tableWidget_2.itemSelectionChanged.connect(self.mudar_estacao)
       
        #Call the function nova_linha        
        self.dlg.pushButton_config_2.clicked.connect(self.nova_linha)
        
        #Call the function remove_row        
        self.dlg.pushButton_config_3.clicked.connect(self.remove_row)
        
        #Call the function verificar 
        self.dlg.pushButton.clicked.connect(self.verificar)
        
        # Alerta de ordem da estação no azimute
        self.dlg.lineEdit_6.editingFinished.connect(self.alerta)
        #self.dlg.lineEdit_13.textEdited.connect(self.alerta)
        
        #Call the function calcular 
        self.dlg.pushButton_2.clicked.connect(self.verificar)
        self.dlg.pushButton_2.clicked.connect(self.verificar_campos_vazios)
        
        #create layer with the X Y Z point calculate
        self.dlg.pushButton_3.clicked.connect(self.cria_camada_xyz)

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
