# -*- coding: utf-8 -*-
"""
/***************************************************************************
 TopoTijdreis
                                 A QGIS plugin
 This plugin loads all historic maps from 1815-2024 from topotijdreis.nl into QGIS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-08-09
        git sha              : $Format:%H$
        copyright            : (C) 2022 by A.G.J. Hullegie
        email                : ahullegie@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

# ----------------------------------------------------------------------
# Imports – QGIS re‑exports the correct PyQt version (Qt 6 on recent QGIS)
# ----------------------------------------------------------------------
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.core import QgsProject, QgsRasterLayer
from qgis.utils import iface
from qgis.core import QgsProject

# Import the UI resources (the cleaned‑up resources.py you now have)
from .resources import qInitResources, qCleanupResources

# Import the dock widget implementation (your own UI file)
from .topo_tijdreis_dockwidget import TopoTijdreisDockWidget
import os.path


class TopoTijdreis:
    """Main plugin class – QGIS expects the methods below."""

    def __init__(self, iface):
        """Store the QGIS interface and initialise internal state."""
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)

        # Initialise localisation (optional but kept from original)
        locale = str(QSettings().value('locale/userLocale'))[:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            f'TopoTijdreis_{locale}.qm'
        )
        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # UI bookkeeping
        self.actions = []
        self.menu = self.tr('&TopoTijdreis')
        self.toolbar = self.iface.addToolBar('TopoTijdreis')
        self.toolbar.setObjectName('TopoTijdreis')
        self.pluginIsActive = False
        self.dockwidget = None

        # Register the compiled Qt resources (icons, etc.)
        qInitResources()

    # ------------------------------------------------------------------
    # Helper for translations (kept unchanged)
    # ------------------------------------------------------------------
    def tr(self, message):
        """Translate a string using Qt's translation system."""
        return QCoreApplication.translate('TopoTijdreis', message)

    # ------------------------------------------------------------------
    # Boilerplate to add actions (menu / toolbar entries)
    # ------------------------------------------------------------------
    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None,
    ):
        """Create a QAction and optionally add it to the toolbar/menu."""
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)
        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)
        if add_to_menu:
            self.iface.addPluginToWebMenu(self.menu, action)

        self.actions.append(action)
        return action

    # ------------------------------------------------------------------
    # **Required QGIS life‑cycle methods**
    # ------------------------------------------------------------------

    def initGui(self):
        """Called when the plugin is enabled – add menu/toolbar items."""
        icon_path = ':/plugins/topo_tijdreis/icon.png'   # adjust if you use a different path
        self.add_action(
            icon_path,
            text=self.tr('TopoTijdreis'),
            callback=self.run,
            parent=self.iface.mainWindow()
        )

    def unload(self):
        """Called when the plugin is disabled – clean up UI elements."""
        for action in self.actions:
            self.iface.removePluginWebMenu(self.tr('&TopoTijdreis'), action)
            self.iface.removeToolBarIcon(action)
        # Remove the toolbar we created
        del self.toolbar
        # Unregister Qt resources (good practice)
        qCleanupResources()

    # ------------------------------------------------------------------
    # Your custom “run” method – opens the dock widget and loads layers
    # ------------------------------------------------------------------
    def run(self):
        """Launch the plugin UI (dock widget) and populate map layers."""
        if not self.pluginIsActive:
            self.pluginIsActive = True

            # Create the dock widget only once
            if self.dockwidget is None:
                self.dockwidget = TopoTijdreisDockWidget()

                # Create a mutually exclusive layer group (only one year visible)
                layer_group = (
                    QgsProject.instance()
                    .layerTreeRoot()
                    .insertGroup(0, 'TopoTijdReis')
                )
                layer_group.setIsMutuallyExclusive(True)
                layer_group.setExpanded(False)

                # List of years – keep exactly as you had before
                years = [
                    '1815', '1820', '1821', '1823_1829', '1836_1849', '1850',
                    '1857', '1858', '1861', '1862', '1865', '1866', '1868',
                    '1870', '1871', '1872', '1880', '1883', '1886', '1888',
                    '1889', '1893', '1899', '1900', '1901', '1902', '1904',
                    '1908', '1909', '1910', '1912', '1915', '1918', '1919',
                    '1920', '1922', '1925', '1929', '1931', '1935', '1937',
                    '1940', '1942', '1943', '1947', '1948', '1949', '1950',
                    '1951', '1952', '1953', '1955', '1962', '1963', '1965',
                    '1970', '1971', '1973', '1975', '1976', '1978', '1980',
                    '1984', '1988', '1990', '1994', '1995', '1996', '1997',
                    '1999', '2006', '2010', '2011', '2014', '2015', '2016',
                    '2017', '2018', '2019', '2020', '2020', '2021', '2022',
                    '2023', '2024'
                ]

                for year in years:
                    wms_url = (
                        "tileMatrixSet=default028mm&crs=EPSG:28992&layers="
                        f"Historische_tijdreis_{year}&styles=default&"
                        "format=image/jpgpng&url="
                        "https://tiles.arcgis.com/tiles/nSZVuSZjHpEZZbRo/"
                        "arcgis/rest/services/Historische_tijdreis_{0}"
                        "/MapServer/WMTS/".format(year)
                    )
                    layer = QgsRasterLayer(
                        wms_url,
                        f"TopoTijdReis {year}",
                        "wms"
                    )
                    QgsProject.instance().addMapLayer(layer, False)
                    layer_group.insertLayer(0, layer)

            # Connect the dock widget's close signal to our cleanup method
            self.dockwidget.closingPlugin.connect(self.onClosePlugin)

            # Show the dock widget on the left side of QGIS
            self.iface.addDockWidget(
                Qt.DockWidgetArea.LeftDockWidgetArea,
                self.dockwidget
            )
            self.dockwidget.show()

    # ------------------------------------------------------------------
    # Optional: clean up when the dock widget is closed
    # ------------------------------------------------------------------
    def onClosePlugin(self):
        """Called when the user closes the dock widget."""
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)
        self.pluginIsActive = False