# -*- coding: utf-8 -*-

"""
/***************************************************************************
 TopoDrainPlugin
                                 A QGIS plugin
 A QGIS plugin for planning surface drainage water management. It automates the extraction of main valleys and ridges, and supports various other water retention planning methods, such as Keyline Design (keypoints, keylines), pond siting and various other sponge-scape measures. The algorithms are mainly based on WhiteboxTools. The plugin will be developed further on a regular basis.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-08-06
        copyright            : (C) 2025 by Timo Wicki
        email                : wickitimo@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Timo Wicki'
__date__ = '2025-08-06'
__copyright__ = '(C) 2025 by Timo Wicki'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
from qgis.PyQt.QtGui import QIcon
from qgis.core import QgsProcessingProvider
from .create_valleys_algorithm import CreateValleysAlgorithm
from .create_ridges_algorithm import CreateRidgesAlgorithm
from .create_constant_slope_lines_algorithm import CreateConstantSlopeLinesAlgorithm
from .create_keylines_algorithm import CreateKeylinesAlgorithm
from .extract_main_valleys_algorithm import ExtractMainValleysAlgorithm
from .extract_main_ridges_algorithm import ExtractMainRidgesAlgorithm
from .get_keypoints_algorithm import GetKeypointsAlgorithm
from .adjust_constant_slope_after_algorithm import AdjustConstantSlopeAfterAlgorithm

pluginPath = os.path.dirname(__file__)

class TopoDrainProvider(QgsProcessingProvider):
    def __init__(self, core=None, plugin=None):
        """
        Default constructor. Accepts a TopoDrainCore instance and plugin reference.
        """
        super().__init__()
        self.core = core
        self.plugin = plugin

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        # Use the shared core instance and pass plugin reference for WhiteboxTools config
        create_valleys_alg = CreateValleysAlgorithm(core=self.core)
        create_valleys_alg.plugin = self.plugin
        self.addAlgorithm(create_valleys_alg)
        
        create_ridges_alg = CreateRidgesAlgorithm(core=self.core)
        create_ridges_alg.plugin = self.plugin
        self.addAlgorithm(create_ridges_alg)
        
        create_constant_slope_lines_alg = CreateConstantSlopeLinesAlgorithm(core=self.core)
        create_constant_slope_lines_alg.plugin = self.plugin
        self.addAlgorithm(create_constant_slope_lines_alg)
        
        create_keylines_alg = CreateKeylinesAlgorithm(core=self.core)
        create_keylines_alg.plugin = self.plugin
        self.addAlgorithm(create_keylines_alg)
        
        extract_main_valleys_alg = ExtractMainValleysAlgorithm(core=self.core)
        extract_main_valleys_alg.plugin = self.plugin
        self.addAlgorithm(extract_main_valleys_alg)
        
        extract_main_ridges_alg = ExtractMainRidgesAlgorithm(core=self.core)
        extract_main_ridges_alg.plugin = self.plugin
        self.addAlgorithm(extract_main_ridges_alg)
        
        get_keypoints_alg = GetKeypointsAlgorithm(core=self.core)
        get_keypoints_alg.plugin = self.plugin
        self.addAlgorithm(get_keypoints_alg)
        
        adjust_constant_slope_after_alg = AdjustConstantSlopeAfterAlgorithm(core=self.core)
        adjust_constant_slope_after_alg.plugin = self.plugin
        self.addAlgorithm(adjust_constant_slope_after_alg)
        
        # add additional algorithms here
        # self.addAlgorithm(MyOtherAlgorithm())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'Topo Drain'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('Topo Drain')

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        return QIcon(os.path.join(pluginPath, 'icons', 'topo_drain.svg'))


    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
