# filename: formats/csv.py
# Copyright 2022 Jean-Marie Arsac <jmarsac@azimut.fr>

# This file is part of Total Open Station.

# Total Open Station is free software: you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.

# Total Open Station is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty
# of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with Total Open Station.  If not, see
# <http://www.gnu.org/licenses/>.

import csv

from . import UNKNOWN_POINT, Feature, Parser, Point

# Exemple de contenu traité :
# matricule,x,y,z,ph,pv,cs,md,ca
# S.50570,1352312.6096,7222488.3463,26.105,PH=7,PV=7,CS=1,MD=P_STATION,CA=TOPSTA
# S.50571,1352270.3770,7222495.1687,-999.,PH=7,CS=1,MD=P_STATION,CA=TOPSTA
# S.25687,1352339.5100,7222586.0400,26.16400,PH=7,PV=7,MD=P_STATION,CA=TOPSTA
# S.16836,1352368.5072,7222455.6587,26.20650,PH=7,PV=7,CS=1,MD=P_STATION,CA=TOPSTA


class CsvConst:
    MATRICULE = "matricule"
    NORTH = "x"
    EAST = "y"
    ALTITUDE = "z"
    PRECISION_PLANI = "ph"
    PRECISION_ALTI = "pv"
    CODE = "cs"
    MARKER = "md"
    CATEGORIE = "ca"


class FormatParser(Parser):
    def __init__(self, data, **options):
        self._use_all = False
        if "use_all" in options:
            self._use_all = options["use_all"]

    def is_point(self, row):
        is_point = False
        if CsvConst.MATRICULE in row or CsvConst.STATION in row:
            if CsvConst.EAST in row and CsvConst.NORTH in row:
                is_point = True
        return is_point

    def extract_point(self, row):
        p = UNKNOWN_POINT
        point_type = None
        point_name = None
        return p

    def get_point(self, row):
        f = None
        return f

    @property
    def raw_line(self):
        """Extract all csv data"""
        return None
