from .ptopo import PtopoConst


class TopoSight:
    __slots = (
        "id",
        "hi",
        "x",
        "y",
        "z",
        "id_target",
        "x_target",
        "y_target",
        "hp",
        "ah",
        "av",
        "di",
    )

    def __init__(
        self,
        id: str = None,
        hi: float = None,
        x: float = PtopoConst.NO_X,
        y: float = PtopoConst.NO_Y,
        z: float = PtopoConst.NO_Z,
        id_target: str = None,
        x_target: float = PtopoConst.NO_X,
        y_target: float = PtopoConst.NO_Y,
        z_target: float = PtopoConst.NO_Z,
        hp: float = None,
        ah: float = None,
        av: float = None,
        di: float = None,
    ):
        self.id = id
        self.hi = hi
        self.x = x
        self.y = y
        self.z = y
        self.id_target = id_target
        self.x_target = x_target
        self.y_target = y_target
        self.z_target = z_target
        self.hp = hp
        self.ah = ah
        self.av = av
        self.di = di

    def __repr__(self):
        return repr(
            (
                self.id,
                self.hi,
                self.x,
                self.y,
                self.z,
                self.id_target,
                self.x_target,
                self.y_target,
                self.z_target,
                self.hp,
                self.ah,
                self.av,
                self.di,
            )
        )
