from .ptopo import PtopoConst


class TopoMeasure:
    __slots = (
        "id",
        "x",
        "y",
        "z",
        "id_target",
        "x_target",
        "y_target",
        "type",
        "value",
        "hi",
        "hp",
    )

    def __init__(
        self,
        id: str = None,
        x: float = PtopoConst.NO_X,
        y: float = PtopoConst.NO_Y,
        z: float = PtopoConst.NO_Z,
        hi: float = None,
        id_target: str = None,
        x_target: float = PtopoConst.NO_X,
        y_target: float = PtopoConst.NO_Y,
        z_target: float = PtopoConst.NO_Z,
        type: str = None,
        hp: float = None,
        value: float = None,
    ):
        self.id = id
        self.x = x
        self.y = y
        self.z = y
        self.hi = hi
        self.id_target = id_target
        self.x_target = x_target
        self.y_target = y_target
        self.z_target = z_target
        self.type = type
        self.hp = hp
        self.value = value

    def __repr__(self):
        return repr(
            (
                self.id,
                self.x,
                self.y,
                self.z,
                self.hi,
                self.id_target,
                self.x_target,
                self.y_target,
                self.z_target,
                self.type,
                self.value,
                self.hp,
            )
        )
