from qgis.core import QgsProject

from .topaze_global import TopazeConst


class TopazeLayers:
    @staticmethod
    def ptopo_layer():
        """
        ptopo_layer get layer object named PTOPO_LAYER_NAME

        :rtype: QgsVectorLayer
        """
        return TopazeLayers.layer_by_name(TopazeConst.PTOPO_LAYER_NAME)

    @staticmethod
    def field_layer():
        """
        field_layer get layer object named FIELD_LAYER_NAME

        :return: layer object
        :rtype: QgsVectorLayer
        """
        return TopazeLayers.layer_by_name(TopazeConst.FIELD_LAYER_NAME)

    @staticmethod
    def layer_by_name(layer_name):
        """
        layer_by_name get layer object by its name

        :param layer_name: layer name
        :type layer_name: str
        :return: layer object
        :rtype: QgsVectorLayer
        """
        layers = QgsProject.instance().mapLayersByName(layer_name)
        try:
            if layers:
                return layers[0]
        except Exception as e:
            print(str(e))
            return None
