"""
/***************************************************************************
 TopazeConfig
                                 A QGIS plugin
 Configuration Topaze
                              -------------------
        begin                : 2023-07-12
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Jean-Marie Arsac
        email                : jmarsac@azimut.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import yaml
from yaml.loader import SafeLoader


class TopazeConfig:
    """QGIS Plugin Implementation."""

    CONFIG_DICT = {}

    def __init__(self, config_path: str = None):
        """Constructor."""
        if config_path:
            TopazeConfig.load_config(config_path)
            pass

    @classmethod
    def unknown(cls):
        return cls.UNKNOWN_USAGE

    @classmethod
    def config_dict(cls):
        return cls.CONFIG_DICT

    @classmethod
    def load_config(cls, config_path):
        try:
            with open(config_path) as f:
                cls.CONFIG_DICT = yaml.load(f, Loader=SafeLoader)["topaze"]
        except Exception as e:
            print(f"err: {str(e)}")
        else:
            return cls.CONFIG_DICT


if __name__ == "__main__":
    c = TopazeConfig()
    c.load_config("c:/src/azimut/qgis/Topaze/topaze/resources/settings/topaze.yml")
    d = c.config_dict()
    print(d)
