"""
/***************************************************************************
 i18n
                                 A QGIS plugin
 Topaze
                             -------------------
        begin                : 2025-08-25
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Jean-Marie ARSAC
        email                : jmarsac@arsac.wf
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from pathlib import Path

from qgis.PyQt.QtCore import QCoreApplication

from .translator import PlgTranslator

__all__ = ["init_i18n", "tr"]

_plg = None
_installed = False


def init_i18n(qm_root: Path | None = None) -> None:
    """
    Installe le QTranslator UNE seule fois pour tout le plugin.
    Appelle-la au démarrage du plugin (initGui / __init__).
    """
    global _plg, _installed
    if _installed:
        return

    # PlgTranslator sait déjà chercher depuis DIR_PLUGIN_ROOT par défaut
    _plg = PlgTranslator(qm_root) if qm_root else PlgTranslator()
    trans = _plg.get_translator()
    if trans:
        QCoreApplication.installTranslator(trans)
    _installed = True


def tr(text: str, context: str | None = None) -> str:
    """
    Traduction réutilisable partout.
    Le PlgTranslator fait déjà le fallback de contexte via introspection.
    """
    # global _plg
    try:
        if _plg is None:
            init_i18n()
    except NameError:
        init_i18n()
    return _plg.tr(text, context=context)
