# topaze/report_helpers.py
from typing import Optional


def fmt(val: Optional[float], spec: str = "{:.5f}", dash: str = "—") -> str:
    """Safe number formatter for reports (returns dash on None/NaN)."""
    try:
        if val is None:
            return dash
        # NaN-safe
        if isinstance(val, float) and val != val:
            return dash
        return spec.format(val)  # NaN
    except Exception:
        return dash
