"""
/***************************************************************************
 NewSurveyDialog
                                 A QGIS plugin
 Topaze
                             -------------------
        begin                : 2022-10-27
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Jean-Mari ARSAC
        email                : jmarsac@arsac.wf
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from PyQt5 import QtCore, QtWidgets, uic
from qgis.core import QgsProject

FORM_CLASS, _ = uic.loadUiType(
    os.path.join(os.path.dirname(__file__), "new_survey_dialog.ui")
)


class NewSurveyDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(NewSurveyDialog, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        self.toolButton.clicked.connect(self.showDialog)
        self.lineEdit.setText(str(os.path.dirname(QgsProject.instance().homePath())))

    def showDialog(self):
        if self.lineEdit.text():
            dirname = QtWidgets.QFileDialog.getExistingDirectory(
                self, "", self.lineEdit.text()
            )
        else:
            self.lineEdit.setText(
                str(os.path.dirname(QgsProject.instance().homePath()))
            )
            dirname = QtWidgets.QFileDialog.getExistingDirectory(
                self, "", self.lineEdit.text()
            )
        if dirname:
            self.lineEdit.setText(dirname)

    def set_initial_dir(self, initial_dir):
        self.lineEdit.setText(initial_dir)

    def get_survey_dir(self):
        return self.lineEdit.text()
