import os
import tempfile


class FileUtils:
    @staticmethod
    def create_temp_file(filename, content):
        # Créer un fichier temporaire
        temp_dir = tempfile.gettempdir()
        temp_file_path = os.path.join(temp_dir, filename)
        with open(temp_file_path, "w") as temp_file:
            temp_file.write(content)
        return temp_file_path

    @staticmethod
    def save_temp_file(filename, content, temp_dir: str = None):
        # Créer un fichier temporaire
        if not temp_dir:
            temp_dir = tempfile.gettempdir()
        temp_file_path = os.path.join(temp_dir, filename)
        with open(temp_file_path, "w") as temp_file:
            temp_file.write(content)
        return temp_file_path

    @staticmethod
    def load_temp_file(filename):
        content = ""
        try:
            temp_dir = tempfile.gettempdir()
            temp_file_path = os.path.join(temp_dir, filename)
            with open(temp_file_path, "r") as temp_file:
                content = temp_file.read()
        except Exception as e:
            print(str(e))
        return content

    @staticmethod
    def remove_temp_file(filename, temp_dir: str = None):
        if not temp_dir:
            temp_dir = tempfile.gettempdir()
        temp_file_path = os.path.join(temp_dir, filename)
        try:
            os.remove(temp_file_path)
        except Exception as e:
            print(e)


"""
 Exemple d'utilisation
content = "Ceci est un contenu temporaire."
temp_file_path = FileUtilscreate_temp_file("fichier.txt", content)
s = FileUtils.load("fichier.txt")
"""
