# -*- coding: utf-8 -*-
"""
Dock chạy tổng hợp 12 biểu (Tỉnh / Xã) và gộp thành 1 Excel.
Xây dựng UI HOÀN TOÀN BẰNG CODE (không dùng Qt Designer).
Dùng được từ QGIS 3.16+ (PyQt5).
"""

import os, json, tempfile, shutil, math
from copy import copy
import openpyxl
import sys
import shutil
from copy import copy
import openpyxl
from qgis.PyQt.QtCore import (
    Qt, pyqtSignal, QDate, QDateTime, QRegularExpression, QVariant, QByteArray
)
from qgis.PyQt.QtGui import QRegularExpressionValidator
from qgis.PyQt.QtWidgets import (
    QDockWidget, QWidget, QVBoxLayout, QGridLayout, QHBoxLayout,
    QLabel, QPushButton, QComboBox, QProgressBar, QLineEdit,
    QGroupBox, QRadioButton, QFileDialog, QMessageBox, QProgressDialog, QApplication,
    QDateEdit, QCheckBox
)
from qgis.core import QgsMapLayerProxyModel, QgsMessageLog, Qgis
from qgis.gui import QgsMapLayerComboBox

import math
import glob


# =========================
# DockWidget xây dựng bằng code
# =========================
class TonghopbieuDockWidget(QDockWidget):
    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        super().__init__(parent)
        self.setWindowTitle("Tổng hợp biểu điều tra rừng - Phiên bản 3.1")
        self.setObjectName("TonghopbieuDockWidget")
        self._build_ui()

        self.duong_dan_json = None
        self._connect_signals()
            

    # ---------- UI ----------
    def _build_ui(self):
        from qgis.PyQt.QtWidgets import QSizePolicy

        cw = QWidget(self)
        root = QVBoxLayout(cw)
        root.setContentsMargins(8, 8, 8, 8)
        root.setSpacing(8)

        # =========== 1) DỮ LIỆU ĐẦU VÀO ===========
        grp_in = QGroupBox("1) Dữ liệu đầu vào", cw)
        v_in = QVBoxLayout(grp_in)
        v_in.setSpacing(6)

        # Hàng trên: nhãn + input theo 2 cột, nhãn đặt TRÊN control
        h_inputs = QHBoxLayout()
        h_inputs.setSpacing(8)

        # Cột 1: Lớp bản đồ (label trên, combo dưới)
        col_layer = QVBoxLayout()
        col_layer.setSpacing(4)
        lbl_layer = QLabel("Lớp bản đồ", grp_in)
        self.cboLayer = QgsMapLayerComboBox(grp_in)
        self.cboLayer.setFilters(QgsMapLayerProxyModel.VectorLayer)
        self.cboLayer.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Fixed)
        col_layer.addWidget(lbl_layer)
        col_layer.addWidget(self.cboLayer)

        # Cột 2: Năm dữ liệu (ComboBox) — rộng = 1/4 combo
        col_year = QVBoxLayout()
        col_year.setSpacing(4)
        lbl_year = QLabel("Năm dữ liệu", grp_in)
        self.cboNamdt = QComboBox(grp_in)
        self.cboNamdt.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Fixed)

        # danh sách năm: từ năm hiện tại về 2015
        _cur_year = QDate.currentDate().year()
        years = [str(y) for y in range(_cur_year, 2014, -1)]
        self.cboNamdt.addItems(years)

        col_year.addWidget(lbl_year)
        col_year.addWidget(self.cboNamdt)

        h_inputs.addLayout(col_layer, 4)  # tỉ lệ 4:1 -> combo rộng gấp 4 lần
        h_inputs.addLayout(col_year, 1)
        v_in.addLayout(h_inputs)

        # (TƯƠNG THÍCH CŨ) Ô txtNamdt ẨN để code cũ .text() vẫn chạy
        self.txtNamdt = QLineEdit(grp_in)
        self.txtNamdt.setVisible(False)
        self.txtNamdt.setText(self.cboNamdt.currentText())

        # Hàng dưới: 3 nút bằng nhau (Nạp / Đọc / Xóa), tự giãn theo bề rộng dock
        h_buttons = QHBoxLayout()
        h_buttons.setSpacing(8)
        self.btnCreateJson = QPushButton("Nạp dữ liệu", grp_in)
        self.btnReadJson   = QPushButton("Đọc dữ liệu", grp_in)
        self.btnDeleteJson = QPushButton("Xóa dữ liệu", grp_in)
        for b in (self.btnCreateJson, self.btnReadJson, self.btnDeleteJson):
            b.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Fixed)
            h_buttons.addWidget(b, 1)  # mỗi nút stretch=1 => bằng nhau
        v_in.addLayout(h_buttons)

        # Nhãn trạng thái ngay dưới 3 nút
        self.lblJsonInfo = QLabel("", grp_in)
        v_in.addWidget(self.lblJsonInfo)

        # (TƯƠNG THÍCH CŨ) Ô đường dẫn JSON ẩn, không đưa vào layout
        self.txtJsonPath = QLineEdit(grp_in)
        self.txtJsonPath.setReadOnly(True)
        self.txtJsonPath.setVisible(False)

        root.addWidget(grp_in)

        # =========== 2) PHẠM VI TỔNG HỢP ===========
        grp_scope = QGroupBox("2) Phạm vi tổng hợp", cw)
        v_scope = QVBoxLayout(grp_scope)
        v_scope.setSpacing(6)

        # Dòng radio cấp
        h_rad = QHBoxLayout()
        self.radTinh = QRadioButton("Cấp tỉnh", grp_scope)
        self.radXa   = QRadioButton("Cấp xã", grp_scope)
        self.radTinh.setChecked(True)
        h_rad.addWidget(self.radTinh)
        h_rad.addWidget(self.radXa)
        h_rad.addStretch(1)
        v_scope.addLayout(h_rad)

        # Dòng Tỉnh/Xã: nhãn trên, combo dưới, 2 cột căn đều
        h_admin = QHBoxLayout()
        h_admin.setSpacing(8)

        col_tinh = QVBoxLayout()
        col_tinh.setSpacing(4)
        lbl_tinh = QLabel("Tỉnh", grp_scope)
        self.cboTinh = QComboBox(grp_scope)
        self.cboTinh.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Fixed)
        col_tinh.addWidget(lbl_tinh)
        col_tinh.addWidget(self.cboTinh)

        col_xa = QVBoxLayout()
        col_xa.setSpacing(4)
        lbl_xa = QLabel("Xã", grp_scope)
        self.cboXa = QComboBox(grp_scope)
        self.cboXa.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Fixed)
        col_xa.addWidget(lbl_xa)
        col_xa.addWidget(self.cboXa)

        h_admin.addLayout(col_tinh, 1)
        h_admin.addLayout(col_xa,   1)
        v_scope.addLayout(h_admin)

        # (ẩn) cboHuyen & ckbox để tương thích code cũ
        self.cboHuyen = QComboBox(grp_scope); self.cboHuyen.addItems(["", "Tất cả"]); self.cboHuyen.hide()
        self.ckbox    = QCheckBox("Tùy chọn cũ (ckbox)", grp_scope); self.ckbox.setChecked(True); self.ckbox.hide()

        root.addWidget(grp_scope)

        # =========== 3) NGÀY KÝ ===========
        grp_date = QGroupBox("3) Ngày ký", cw)
        v_date = QVBoxLayout(grp_date)
        v_date.setSpacing(6)

        # Nhãn "Chọn ngày" TRÊN dateEdit, dateEdit giãn ngang
        lbl_choose = QLabel("Chọn ngày", grp_date)
        self.dateEdit = QDateEdit(grp_date)
        self.dateEdit.setCalendarPopup(True)
        self.dateEdit.setDate(QDate.currentDate())
        self.dateEdit.setDisplayFormat("dd/MM/yyyy")
        self.dateEdit.setMaximumDate(QDate.currentDate())
        self.dateEdit.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Fixed)
        v_date.addWidget(lbl_choose)
        v_date.addWidget(self.dateEdit)

        # 3 lựa chọn hiển thị ngày (giữ nguyên)
        self.radNgayMau1 = QRadioButton("Ngày ...... tháng ...... năm ......", grp_date)
        self.radNgayMau2 = QRadioButton("Ngày ...... tháng ...... năm {năm hiện tại}", grp_date)
        self.radNgayMau3 = QRadioButton("Ngày {ngày hiện tại} tháng {tháng hiện tại} năm {năm hiện tại}", grp_date)
        self.radNgayMau3.setChecked(True)
        self._refresh_date_labels()
        v_date.addWidget(self.radNgayMau1)
        v_date.addWidget(self.radNgayMau2)
        v_date.addWidget(self.radNgayMau3)

        root.addWidget(grp_date)

        # =========== 4) XUẤT BIỂU ===========
        grp_run = QGroupBox("4) Xuất biểu", cw)
        h_run = QHBoxLayout(grp_run)
        self.btnExport = QPushButton("Xuất biểu tổng hợp", grp_run)
        self.progressBar = QProgressBar(grp_run)
        self.progressBar.setMinimum(0)
        self.progressBar.setMaximum(12)
        self.progressBar.setValue(0)
        self.btnExport.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Fixed)
        self.progressBar.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Fixed)
        h_run.addWidget(self.btnExport, 1)
        h_run.addWidget(self.progressBar, 2)

        root.addWidget(grp_run)

        self.setWidget(cw)
        self._toggle_scope_controls()


    def _refresh_date_labels(self):
        # Lấy ngày/tháng/năm từ dateEdit (nếu thiếu, dùng ngày hiện tại)
        try:
            d = self.dateEdit.date()
        except Exception:
            from qgis.PyQt.QtCore import QDate
            d = QDate.currentDate()

        y = d.year()
        m = d.month()
        day = d.day()

        # Cập nhật text 3 lựa chọn
        if hasattr(self, "radNgayMau1"):
            self.radNgayMau1.setText("Ngày ...... tháng ...... năm ......")
        if hasattr(self, "radNgayMau2"):
            self.radNgayMau2.setText(f"Ngày ...... tháng ...... năm {y}")
        if hasattr(self, "radNgayMau3"):
            self.radNgayMau3.setText(f"Ngày {day} tháng {m} năm {y}")

    def _excel_com_available(self):
        try:
            import win32com.client  # pywin32
            return True
        except Exception:
            return False
    def _ensure_sheet_order_openpyxl(self, wb):
        # Chấp nhận cả "Bieu1" và "Bieu01"
        desired_titles = []
        existing = set(wb.sheetnames)
        for i in range(1, 13):
            candidates = [f"Bieu{i}", f"Bieu{str(i).zfill(2)}"]
            pick = next((c for c in candidates if c in existing), None)
            if pick:
                desired_titles.append(pick)

        # Đưa các sheet mong muốn lên đầu theo thứ tự 1..12, sau đó giữ nguyên các sheet còn lại (nếu có)
        ordered = [wb[t] for t in desired_titles]
        others  = [ws for ws in wb.worksheets if ws.title not in desired_titles]
        wb._sheets = ordered + others  # openpyxl dùng _sheets để xác định thứ tự hiển thị

   
    def _excel_copy_sheet_win32(self, out_xlsx, tmp_xlsx, dst_sheet_name):
        import win32com.client as win32
        excel = win32.DispatchEx("Excel.Application")
        excel.Visible = False
        excel.DisplayAlerts = False
        try:
            wb_dst = excel.Workbooks.Open(out_xlsx)
            wb_src = excel.Workbooks.Open(tmp_xlsx)

            # Nếu có sẵn sheet đích -> xóa để thay
            try:
                wb_dst.Worksheets(dst_sheet_name).Delete()
            except Exception:
                pass

            # Copy sheet đầu tiên từ tmp vào workbook đích
            wb_src.Worksheets(1).Copy(Before=wb_dst.Worksheets(1))
            # Đổi tên sheet vừa copy thành tên đích
            wb_dst.Worksheets(1).Name = dst_sheet_name

            wb_dst.Save()
            wb_src.Close(False)
            wb_dst.Close(True)
        finally:
            excel.Quit()
    def _copy_ws_rich_openpyxl(self, ws_src, ws_dst):
        # 1) Xoá merge cũ, rồi merge lại như nguồn
        try:
            for r in list(ws_dst.merged_cells.ranges):
                ws_dst.unmerge_cells(str(r))
        except Exception:
            pass
        for r in ws_src.merged_cells.ranges:
            ws_dst.merge_cells(str(r))

        # 2) Freeze panes
        ws_dst.freeze_panes = ws_src.freeze_panes

        # 3) Kích thước cột/hàng
        for key, dim in ws_src.column_dimensions.items():
            dst_dim = ws_dst.column_dimensions.get(key)
            if dst_dim is None:
                dst_dim = ws_dst.column_dimensions[key]
            dst_dim.width = dim.width
        for idx, dim in ws_src.row_dimensions.items():
            ws_dst.row_dimensions[idx].height = dim.height

        # 4) Giới hạn vùng dữ liệu (ước lượng)
        max_r = ws_src.max_row
        max_c = ws_src.max_column

        # 5) Giá trị + style từng ô
        for r in range(1, max_r + 1):
            for c in range(1, max_c + 1):
                s = ws_src.cell(row=r, column=c)
                d = ws_dst.cell(row=r, column=c)
                d.value = s.value
                if s.has_style:
                    d.font = copy(s.font)
                    d.border = copy(s.border)
                    d.fill = copy(s.fill)
                    d.number_format = s.number_format
                    d.protection = copy(s.protection)
                    d.alignment = copy(s.alignment)

        # 6) Một số thiết lập in / margins cơ bản
        try:
            ws_dst.print_title_rows = ws_src.print_title_rows
            ws_dst.print_title_cols = ws_src.print_title_cols
        except Exception:
            pass
        try:
            ws_dst.page_setup.orientation = ws_src.page_setup.orientation
            ws_dst.page_setup.fitToWidth = ws_src.page_setup.fitToWidth
            ws_dst.page_setup.fitToHeight = ws_src.page_setup.fitToHeight
            ws_dst.page_setup.paperSize = ws_src.page_setup.paperSize
            ws_dst.page_setup.scale = ws_src.page_setup.scale
        except Exception:
            pass
        try:
            ws_dst.page_margins.left   = ws_src.page_margins.left
            ws_dst.page_margins.right  = ws_src.page_margins.right
            ws_dst.page_margins.top    = ws_src.page_margins.top
            ws_dst.page_margins.bottom = ws_src.page_margins.bottom
            ws_dst.page_margins.header = ws_src.page_margins.header
            ws_dst.page_margins.footer = ws_src.page_margins.footer
        except Exception:
            pass
    def _merge_one_sheet(self, out_path, wb_group, tmp_out, dst_sheet_name):
        if self._excel_com_available():
            # Dùng Excel COM: đảm bảo file out_path đã tồn tại (copy từ template trước đó)
            self._excel_copy_sheet_win32(out_path, tmp_out, dst_sheet_name)
            return True  # đã ghi trực tiếp vào out_path
        # Fallback: openpyxl
        wb_src = openpyxl.load_workbook(tmp_out, data_only=False)
        ws_src = wb_src.active
        if dst_sheet_name not in wb_group.sheetnames:
            wb_group.create_sheet(dst_sheet_name)
        ws_dst = wb_group[dst_sheet_name]
        self._copy_ws_rich_openpyxl(ws_src, ws_dst)
        wb_src.close()
        return False  # còn cần save wb_group sau cùng

    def _silent_ui(self, owner=None):
        """
        Tắt các thông báo kiểu 'Đã lưu...' khi chạy từng biểu tạm:
          - Nuốt QMessageBox.information (trả về OK)
          - Tự động trả lời No cho QMessageBox.question (tránh pop-up)
          - Nuốt messageBar mức Info/Success
          - Nuốt QgsMessageLog mức Info
        Khôi phục nguyên trạng khi thoát.
        """
        class _Ctx:
            def __init__(self, iface):
                self.iface = getattr(iface, "iface", None) if owner else None
                self._orig_info = QMessageBox.information
                self._orig_question = QMessageBox.question
                self._orig_log = QgsMessageLog.logMessage
                self._bar = None
                self._orig_push = None

            def __enter__(self):
                # 1) QMessageBox
                QMessageBox.information = staticmethod(lambda *a, **k: QMessageBox.Ok)
                QMessageBox.question    = staticmethod(lambda *a, **k: QMessageBox.No)

                # 2) messageBar (Info/Success -> nuốt)
                try:
                    if self.iface:
                        self._bar = self.iface.messageBar()
                        if self._bar:
                            self._orig_push = self._bar.pushMessage
                            def _push_wrapper(*args, **kwargs):
                                level = kwargs.get("level", None)
                                # Các chữ ký có thể là (title, text, level, duration) hoặc (message, level, duration)
                                if level is None:
                                    if len(args) >= 3: level = args[2]
                                    elif len(args) >= 2: level = args[1]
                                try:
                                    if level in (Qgis.Info, getattr(Qgis, "Success", None), None):
                                        return None
                                except Exception:
                                    return None
                                return self._orig_push(*args, **kwargs)
                            self._bar.pushMessage = _push_wrapper
                except Exception:
                    pass

                # 3) QgsMessageLog (Info -> nuốt)
                def _log_wrapper(message, tag="", level=Qgis.Info):
                    try:
                        if level in (Qgis.Info, getattr(Qgis, "Success", None), None):
                            return
                    except Exception:
                        return
                    return self._orig_log(message, tag, level)
                QgsMessageLog.logMessage = staticmethod(_log_wrapper)

                return self

            def __exit__(self, exc_type, exc, tb):
                # khôi phục
                QMessageBox.information = self._orig_info
                QMessageBox.question    = self._orig_question
                try:
                    QgsMessageLog.logMessage = self._orig_log
                except Exception:
                    pass
                try:
                    if self._bar and self._orig_push:
                        self._bar.pushMessage = self._orig_push
                except Exception:
                    pass

        return _Ctx(owner)
    def _read_json_clicked(self):
        if getattr(self, "_busy_read_json", False):
            return
        self._busy_read_json = True
        try:
            layer = self.cboLayer.currentLayer()
            if not layer:
                QMessageBox.warning(self, "Thiếu lớp", "Bạn chưa chọn lớp bản đồ.")
                return
            json_path = os.path.join(self._json_dir(), f"{layer.name()}.json")
            if not os.path.exists(json_path):
                QMessageBox.information(
                    self, "Chưa có dữ liệu",
                    "Chưa có dữ liệu, vui lòng nạp dữ liệu trước khi đọc."
                )
                self.lblJsonInfo.setText("Chưa có dữ liệu")
                return

            # Có file -> nạp
            self.duong_dan_json = json_path
            self.txtJsonPath.setText(json_path)  # ẩn nhưng giữ để code cũ không lỗi
            self._load_tinh_xa_from_json(json_path)
            self.lblJsonInfo.setText(f"Đã đọc dữ liệu: {os.path.basename(json_path)}")
        finally:
            self._busy_read_json = False


    def _delete_json_clicked(self):
        temp_dir = self._json_dir()
        if not os.path.isdir(temp_dir):
            QMessageBox.information(self, "Không có dữ liệu", "Thư mục dữ liệu trống.")
            return
        ret = QMessageBox.question(
            self, "Xóa dữ liệu?",
            "Bạn có chắc muốn xóa toàn bộ dữ không?",
            QMessageBox.Yes | QMessageBox.No, QMessageBox.No
        )
        if ret != QMessageBox.Yes:
            return
        cnt = 0
        for fn in os.listdir(temp_dir):
            if fn.lower().endswith(".json"):
                try:
                    os.remove(os.path.join(temp_dir, fn))
                    cnt += 1
                except Exception:
                    pass
        # Reset trạng thái
        self.duong_dan_json = None
        self.txtJsonPath.clear()
        self.lblJsonInfo.setText(f"Đã xóa {cnt} dữ liệu.")
        self.cboTinh.clear(); self.cboXa.clear()
    def _connect_unique(self, signal, slot):
        """Đảm bảo 1 signal chỉ gắn 1 slot (không nhân đôi)."""
        try:
            signal.disconnect(slot)
        except Exception:
            pass
        signal.connect(slot)
    def _on_date_changed(self, *_):
        """Không cho ngày ký > hôm nay; đồng thời cập nhật label 3 mẫu ngày."""
        today = QDate.currentDate()
        d = self.dateEdit.date()
        if d > today:
            QMessageBox.warning(
                self, "Ngày không hợp lệ",
                f"Ngày ký không được sau ngày hiện tại ({today.toString('dd/MM/yyyy')})."
            )
            # Reset về hôm nay
            self.dateEdit.blockSignals(True)
            self.dateEdit.setDate(today)
            self.dateEdit.blockSignals(False)
            d = today
        # Cập nhật lại nhãn các radio theo ngày hiện tại trên dateEdit
        self._refresh_date_labels()
    def _on_year_combo_changed(self, *_):
        # đồng bộ cho code cũ (txtNamdt.text())
        val = self.cboNamdt.currentText().strip()
        self.txtNamdt.setText(val)
        # lưu biến tiện dụng (int) cho code mới
        try:
            self._nam_du_lieu = int(val)
        except Exception:
            self._nam_du_lieu = None

    def _connect_signals(self):
        self._connect_unique(self.radTinh.toggled, self._toggle_scope_controls)
        self._connect_unique(self.btnCreateJson.clicked, self._create_json_clicked)
        self._connect_unique(self.cboTinh.currentIndexChanged, self._on_tinh_changed)
        self._connect_unique(self.btnExport.clicked, self._export_group_clicked)

        # các nút dữ liệu
        self._connect_unique(self.btnReadJson.clicked, self._read_json_clicked)
        self._connect_unique(self.btnDeleteJson.clicked, self._delete_json_clicked)

        # đổi lớp -> xóa trạng thái nhãn
        try:
            self._connect_unique(self.cboLayer.layerChanged, lambda *_: self.lblJsonInfo.setText(""))
        except Exception:
            pass

        # cập nhật label mẫu ngày khi đổi date
        self._connect_unique(self.dateEdit.dateChanged, self._on_date_changed)

        # kiểm tra năm khi sửa xong
        #self._connect_unique(self.txtNamdt.editingFinished, self._on_year_edited)
        self._connect_unique(self.cboNamdt.currentIndexChanged, self._on_year_combo_changed)
    def _toggle_scope_controls(self):
        is_tinh = self.radTinh.isChecked()
        self.cboTinh.setEnabled(True)
        self.cboXa.setEnabled(not is_tinh)

    def closeEvent(self, e):
        self.closingPlugin.emit()
        e.accept()
    def _resolve_json_path(self):
        """
        Trả về đường dẫn JSON hợp lệ theo các ưu tiên:
         1) txtJsonPath (nếu người dùng đã nạp)
         2) self.duong_dan_json (đã lưu khi bấm Nạp dữ liệu)
         3) <plugin>/temp/<ten_lop_hien_tai>.json
         4) Rà soát thư mục temp xem có file nào khớp tên lớp (không phân biệt hoa/thường)
         5) Cuối cùng: bất kỳ file .json nào trong temp (fallback)
        """
        candidates = []

        # 1) đường dẫn đã nạp
        if getattr(self, "duong_dan_json", None) and os.path.exists(self.duong_dan_json):
            return self.duong_dan_json

        # 2) theo tên layer
        lyr = self.cboLayer.currentLayer()
        if lyr:
            p = os.path.join(self._json_dir(), f"{lyr.name()}.json")
            if os.path.exists(p):
                return p

        # 3) (tương thích cũ) txtJsonPath ẩn
        p = (self.txtJsonPath.text() or "").strip()
        if p and os.path.exists(p):
            return p

        return None

    def _validate_year(self, show_msg=False):
        s = self.cboNamdt.currentText().strip() if hasattr(self, "cboNamdt") else (self.txtNamdt.text() or "").strip()
        cur = QDate.currentDate().year()
        try:
            y = int(s)
        except Exception:
            if show_msg:
                QMessageBox.warning(self, "Năm không hợp lệ", "Năm phải là số 4 chữ số.")
            return False, None
        if y < 2015 or y > cur:
            if show_msg:
                QMessageBox.warning(self, "Năm không hợp lệ", f"Năm dữ liệu phải từ 2015 đến {cur}.")
            return False, None
        return True, y


    def _on_year_edited(self):
        ok, _ = self._validate_year(show_msg=False)
        # Có thể tô viền/tooltip nếu muốn; hiện tại chỉ kiểm tra im lặng


    # ---------- TIỆN ÍCH ----------
    @staticmethod
    def _plugin_dir():
        return os.path.dirname(__file__)

    @staticmethod
    def _ensure_dir(p):
        os.makedirs(p, exist_ok=True)
        return p

    def _json_dir(self):
        return self._ensure_dir(os.path.join(self._plugin_dir(), "temp"))

    def _templates_dir(self):
        return self._ensure_dir(os.path.join(self._plugin_dir(), "templates"))

    def _batch_dir(self):
        return self._ensure_dir(os.path.join(self._plugin_dir(), "Temp", "_batch"))

    # ---------- NẠP DS TỈNH/XÃ ----------
    def _load_tinh_xa_from_json(self, json_path):
        with open(json_path, "r", encoding="utf-8") as f:
            data = json.load(f)

        ds_tinh = sorted({(d.get("tinh") or "").strip() for d in data if d.get("tinh")})
        self.cboTinh.clear()
        self.cboTinh.addItems(ds_tinh)

        # lưu cả data để lọc xã theo tỉnh khi đổi chọn
        self._json_cache = data
        # kích hoạt build xã lần đầu
        self._on_tinh_changed()

    def _on_tinh_changed(self):
        if not hasattr(self, "_json_cache"):
            self.cboXa.clear()
            return
        ten_tinh = (self.cboTinh.currentText() or "").strip()
        ds_xa = sorted({
            (d.get("xa") or "").strip()
            for d in self._json_cache
            if (d.get("tinh") or "").strip() == ten_tinh and d.get("xa")
        })
        self.cboXa.clear()
        self.cboXa.addItems(ds_xa)

    # ---------- TẠO JSON TỪ LỚP ----------
    def _to_jsonable(self, v):
        # Unwrap QVariant nếu có
        if isinstance(v, QVariant):
            try:
                if v.isNull():
                    return None
            except Exception:
                pass
            try:
                v = v.value()
            except Exception:
                # Không lấy được .value() thì rơi xuống xử lý tiếp
                pass
            return self._to_jsonable(v)

        # Kiểu cơ bản
        if v is None or isinstance(v, (str, int, bool)):
            return v
        if isinstance(v, float):
            # Loại trừ NaN/Inf vì JSON không hợp lệ
            if math.isnan(v) or math.isinf(v):
                return None
            return v

        # Ngày/giờ của Qt -> ISO 8601
        if isinstance(v, QDate):
            return v.toString(Qt.ISODate)
        if isinstance(v, QDateTime):
            return v.toString(Qt.ISODate)

        # Mảng bytes của Qt
        if isinstance(v, QByteArray):
            try:
                return bytes(v).decode("utf-8", "replace")
            except Exception:
                return str(bytes(v))

        # Danh sách / tuple / dict lồng nhau
        if isinstance(v, (list, tuple)):
            return [self._to_jsonable(x) for x in v]
        if isinstance(v, dict):
            return {str(k): self._to_jsonable(val) for k, val in v.items()}

        # Cuối cùng: ép chuỗi để đảm bảo serialize được
        return str(v)

    def _create_json_clicked(self):
        layer = self.cboLayer.currentLayer()
        if not layer:
            QMessageBox.warning(self, "Thiếu lớp", "Bạn chưa chọn lớp bản đồ.")
            return

        names = [f.name() for f in layer.fields()]
        for must in ("tinh", "xa"):
            if must not in names:
                QMessageBox.warning(self, "Thiếu trường", f"Lớp thiếu trường '{must}'.")
                return

        json_path = os.path.join(self._json_dir(), f"{layer.name()}.json")
        # Lấy danh sách trường một lần cho nhanh
        fields = layer.fields()
        field_names = [f.name() for f in fields]

        data = []
        for feat in layer.getFeatures():
            rec = {}
            for name in field_names:
                val = feat[name]
                rec[name] = self._to_jsonable(val)
            data.append(rec)

        with open(json_path, "w", encoding="utf-8") as fp:
            json.dump(data, fp, ensure_ascii=False, indent=2)

        self.duong_dan_json = json_path
        self.txtJsonPath.setText(json_path)
        self._load_tinh_xa_from_json(json_path)
        self.lblJsonInfo.setText(f"Đã nạp dữ liệu: {os.path.basename(json_path)}")
        QMessageBox.information(self, "OK", "Đã nạp dữ liệu từ lớp bản đồ.")

    # ---------- SAO CHÉP DỮ LIỆU WS ----------
    def _copy_ws_values_and_styles(self, ws_src, ws_dst):
        max_r = ws_src.max_row
        max_c = ws_src.max_column
        for r in range(1, max_r + 1):
            for c in range(1, max_c + 1):
                s_cell = ws_src.cell(row=r, column=c)
                d_cell = ws_dst.cell(row=r, column=c)
                d_cell.value = s_cell.value
                if s_cell.has_style:
                    d_cell.font = copy(s_cell.font)
                    d_cell.border = copy(s_cell.border)
                    d_cell.fill = copy(s_cell.fill)
                    d_cell.number_format = copy(s_cell.number_format)
                    d_cell.protection = copy(s_cell.protection)
                    d_cell.alignment = copy(s_cell.alignment)

    # ---------- EP ĐƯỜNG DẪN LƯU CHO MỖI BIỂU ----------
    def _call_bieu_and_capture(self, call_func, temp_xlsx_path):
        original_get_save = QFileDialog.getSaveFileName

        def fake_get_save(*args, **kwargs):
            return (temp_xlsx_path, "Excel Files (*.xlsx)")

        QFileDialog.getSaveFileName = staticmethod(fake_get_save)
        try:
            call_func()
        finally:
            QFileDialog.getSaveFileName = original_get_save

    # ---------- CHẠY GỘP 12 BIỂU ----------
    def _export_group_clicked(self):
        # Nếu vì lý do nào đó owner chưa có dateEdit, tạo tạm để tránh crash
        if not hasattr(self, "dateEdit"):
            self.dateEdit = QDateEdit(self)
            self.dateEdit.setCalendarPopup(True)
            self.dateEdit.setDate(QDate.currentDate())
        
        if not self.duong_dan_json or not os.path.exists(self.duong_dan_json):
            QMessageBox.warning(self, "Thiếu dữ liệu", "Chưa có file JSON. Hãy bấm 'Nạp dữ liệu (tạo JSON)'.")
            return

        ten_tinh = (self.cboTinh.currentText() or "").strip()
        if not ten_tinh:
            QMessageBox.warning(self, "Thiếu thông tin", "Chưa chọn Tỉnh.")
            return

        is_tinh = self.radTinh.isChecked()
        ten_xa = (self.cboXa.currentText() or "").strip() if not is_tinh else None
        if not is_tinh and not ten_xa:
            QMessageBox.warning(self, "Thiếu thông tin", "Chưa chọn Xã.")
            return

        default_name = f"TONGHOP_12BIEU_{ten_tinh}.xlsx" if is_tinh else f"TONGHOP_12BIEU_{ten_xa}_{ten_tinh}.xlsx"
        out_path, _ = QFileDialog.getSaveFileName(self, "Lưu file tổng hợp (gộp 12 biểu)", default_name, "Excel Files (*.xlsx)")
        if not out_path:
            return
        # --- KIỂM TRA NĂM HỢP LỆ TRƯỚC KHI CHẠY ---
        ok, nam_val = self._validate_year(show_msg=True)
        if not ok:
            self.txtNamdt.setFocus()
            return
        # lưu lại trên self để dùng nếu cần
        self._nam_du_lieu = nam_val
        # Bảo hiểm: nếu vì lý do nào đó dateEdit > hôm nay, sửa lại và cảnh báo
        today = QDate.currentDate()
        d = self.dateEdit.date()
        if d > today:
            QMessageBox.warning(
                self, "Ngày không hợp lệ",
                f"Ngày ký không được sau ngày hiện tại ({today.toString('dd/MM/yyyy')})."
            )
            self.dateEdit.setDate(today)

        # ------- XÁC ĐỊNH FILE JSON THỰC SỰ TỒN TẠI -------
        json_path = self._resolve_json_path()
        if not json_path:
            QMessageBox.critical(self, "Lỗi", "Không tìm thấy dữ liệu.\n"
                                              "Hãy bấm 'Nạp dữ liệu' hoặc 'Đọc dữ liệu'.")
            return

        # Cập nhật lại biến/ngõ vào để code cũ đọc đúng
        self.duong_dan_json = json_path
        self.txtJsonPath.setText(json_path)
        # lấy template gộp
        templates_dir = self._templates_dir()
        tmpl_group = os.path.join(templates_dir, "TongHop_12Bieu.xlsx")
        if not os.path.exists(tmpl_group):
            wb_new = openpyxl.Workbook()
            wb_new.remove(wb_new.active)
            for i in range(1, 13):
                wb_new.create_sheet(f"Bieu{str(i).zfill(2)}")
            os.makedirs(os.path.dirname(tmpl_group), exist_ok=True)
            wb_new.save(tmpl_group)
        # copy template -> out_path để COM làm việc trực tiếp
        shutil.copyfile(tmpl_group, out_path)
        try:
            wb_group = openpyxl.load_workbook(tmpl_group)
        except Exception as e:
            QMessageBox.critical(self, "Lỗi", f"Không thể mở template gộp: {e}")
            return

        # Chuẩn bị batch temp
        batch_dir = self._batch_dir()
        self.progressBar.setValue(0)
        progress = QProgressDialog("Đang tổng hợp (gộp 12 biểu)...", None, 0, 12, self)
        progress.setCancelButton(None)
        progress.setWindowModality(Qt.ApplicationModal)
        progress.show()
        QApplication.processEvents()

        # Lấy owner (class) chứa các hàm biểu — chủ plugin sẽ gán thuộc tính này sau khi tạo Dock
        owner = getattr(self, "_owner", None)
        if owner is None:
            QMessageBox.critical(self, "Lỗi", "Không tìm thấy owner của Dock (thiếu gán self.dock._owner = self).")
            progress.close()
            return
        owner = getattr(self, "_owner", None)
        if owner is None:
            QMessageBox.critical(self, "Lỗi", "Không tìm thấy owner của Dock (thiếu gán self.dock._owner = self).")
            progress.close()
            return

        # ====== Tương thích ngược với code cũ ======
        # các hàm tonghopbieu… thường gọi self.dockwidget.XYZ
        setattr(owner, "dockwidget", self)
        # phòng khi code cũ dùng self.dock
        setattr(owner, "dock", self)
        # Bắt buộc: bắc cầu các control/biến mà code cũ hay dùng
        for name in ("cboLayer", "progressBar", "radTinh", "radXa", "cboTinh", "cboXa","cboHuyen","ckbox","txtNamdt", "cboNamdt",
                     "txtJsonPath", "dateEdit", "radNgayMau1", "radNgayMau2", "radNgayMau3"):
            setattr(owner, name, getattr(self, name))
        
        # Truyền năm dữ liệu (đảm bảo đã có giá trị)
        setattr(owner, "nam_du_lieu", getattr(self, "_nam_du_lieu", None))
        # Truyền rõ ràng đường dẫn JSON để mọi hàm cũ lấy đúng
        setattr(owner, "duong_dan_json", self.duong_dan_json)
        setattr(owner, "json_input_path", self.duong_dan_json)
        # Biến tiện dụng cho thuật toán cũ nếu muốn dùng trực tiếp
        setattr(owner, "nam_du_lieu", nam_val)
        # Ngữ cảnh phạm vi
        setattr(owner, "ten_tinh_da_chon", ten_tinh)
        setattr(owner, "ten_xa_da_chon", ten_xa)
        # Nếu trong hàm cũ truy cập trực tiếp self.cboLayer / self.progressBar...
        for name in ("cboLayer", "progressBar", "radTinh", "radXa", "cboTinh", "cboXa", "txtJsonPath"):
            setattr(owner, name, getattr(self, name))

        # Đặt biến ngữ cảnh như trước (nếu hàm cũ có dùng)
        setattr(owner, "json_input_path", self.duong_dan_json)
        setattr(owner, "ten_tinh_da_chon", ten_tinh)
        setattr(owner, "ten_xa_da_chon", ten_xa)

        # Map các callable theo cấp — GIỮ NGUYÊN TÊN HÀM CŨ
        if is_tinh:
            func_names = [
                "tonghopbieu12tinh","tonghopbieu11tinh","tonghopbieu10tinh","tonghopbieu9tinh",
                "tonghopbieu8tinh","tonghopbieu7tinh","tonghopbieu6tinh","tonghopbieu5tinh",
                "tonghopbieu4tinh","tonghopbieu3tinh","tonghopbieu2tinh","tonghopbieu1tinh"
            ]
        else:
            func_names = [
                "tonghopbieu12xa","tonghopbieu11xa","tonghopbieu10xa","tonghopbieu9xa",
                "tonghopbieu8xa","tonghopbieu7xa","tonghopbieu6xa","tonghopbieu5xa",
                "tonghopbieu4xa","tonghopbieu3xa","tonghopbieu2xa","tonghopbieu1xa"
            ]

        # Nếu cần, set context cho thuật toán của bạn (ví dụ: biến toàn cục tỉnh/xã/json)
        # Bạn có thể đang dùng sẵn trong các hàm — ở đây chỉ minh hoạ:
        setattr(owner, "json_input_path", self.duong_dan_json)
        setattr(owner, "ten_tinh_da_chon", ten_tinh)
        setattr(owner, "ten_xa_da_chon", ten_xa)
        self.cboHuyen.setCurrentIndex(0)
        # Kiểm tra năm hợp lệ
        ok, nam_val = self._validate_year(show_msg=True)
        if not ok:
            self.txtNamdt.setFocus()
            return

        # Chạy 12 biểu
        used_com = False  # cờ để quyết định có cần save wb_group sau cùng
        for i, fname in enumerate(func_names, start=1):
            func = getattr(owner, fname, None)
            if func is None:
                QMessageBox.critical(self, "Thiếu hàm", f"Không tìm thấy hàm '{fname}'")
                progress.close()
                return

            tmp_out = os.path.join(batch_dir, f"bieu{str(i).zfill(2)}_tmp.xlsx")

            with self._silent_ui(owner):
                self._call_bieu_and_capture(func, tmp_out)
            j = 13-i
            ws_dst_name = f"Bieu{str(j).zfill(2)}"

            wrote_direct = self._merge_one_sheet(out_path, wb_group, tmp_out, ws_dst_name)
            if wrote_direct:
                used_com = True  # Excel đã ghi trực tiếp
            # cập nhật tiến trình...
            self.progressBar.setValue(i)
            progress.setValue(i)
            QApplication.processEvents()

        # Lưu workbook gộp
        try:
            if not used_com:
                self._ensure_sheet_order_openpyxl(wb_group)
                wb_group.save(out_path)
            QMessageBox.information(self, "Thành công", f"Đã lưu file gộp 12 biểu:\n{out_path}")
        except Exception as e:
            QMessageBox.critical(self, "Lỗi", f"Không thể lưu file gộp: {e}")
        finally:
            progress.close()
            try:
                wb_group.close()
            except Exception:
                pass
