# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Tonghopbieu
                                 A QGIS plugin
 Tổng hợp 12 mẫu biểu điều tra rừng theo Thông tư 16
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-06-21
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Nguyễn Văn Thị
        email                : thinguyen.xmg@xuanmaijsc.vn
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import pandas as pd
import openpyxl
import json
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from PyQt5.QtWidgets import QProgressDialog, QApplication
from PyQt5.QtCore import QTimer
from qgis.PyQt.QtCore import QVariant
from .core.licenses import licenses
# Initialize Qt resources from file resources.py
from .resources import *
from PyQt5.QtWidgets import QDockWidget
# Import the code for the DockWidget
from .tong_hop_dockwidget import TonghopbieuDockWidget

import os.path
# Nạp giao diện từ file .ui
#FORM_CLASS, _ = uic.loadUiType(os.path.join(os.path.dirname(__file__), "tong_hop_dockwidget_base.ui"))
from qgis.PyQt import uic
from qgis.core import QgsMapLayerProxyModel
from PyQt5.QtWidgets import QWidget
from PyQt5.QtWidgets import QMessageBox
from copy import copy
from openpyxl.styles import Font, Alignment, PatternFill, Border, Side
from PyQt5.QtCore import QDate        
from qgis.core import (
    QgsProject,
    QgsVectorLayer,
    QgsMapLayerProxyModel,
    # thêm các thành phần khác bạn cần
)
from PyQt5.QtWidgets import (
    QDockWidget,
    QMessageBox,
    QFileDialog,
    QAction,
    QWidget,
)
FORM_CLASS, _ = uic.loadUiType(os.path.join(os.path.dirname(__file__), "tong_hop_dockwidget_base.ui"))
import time
from decimal import Decimal
class Tonghopbieu:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        self.iface = iface
        self.pluginIsActive = False
        self.dock = None

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Tonghopbieu_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Tổng hợp biểu điều tra')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'Tonghopbieu')
        self.toolbar.setObjectName(u'Tonghopbieu')

        #print "** INITIALIZING Tonghopbieu"

        self.pluginIsActive = False
        self.dockwidget = None
        self.plugin_is_ready = False

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Tonghopbieu', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action


    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = os.path.join(os.path.dirname(__file__), 'icon.png')
        self.add_action(
            icon_path,
            text=self.tr(u'Tổng hợp số liệu điều tra rừng'),
            callback=self.run,
            parent=self.iface.mainWindow())
      
            
    def xoa_temp(self):
        # Hỏi xác nhận
        reply = QMessageBox.question(
            self.dockwidget,
            "Xác nhận xóa",
            "Bạn có chắc chắn muốn xóa toàn bộ dữ liệu đã nạp vào không?",
            QMessageBox.Yes | QMessageBox.No,
            QMessageBox.No
        )

        if reply != QMessageBox.Yes:
            return  # Người dùng chọn "Không", thoát

        # Đường dẫn thư mục Temp
        temp_dir = os.path.join(os.path.dirname(__file__), "Temp")

        # Xóa file trong thư mục Temp
        if os.path.exists(temp_dir):
            count = 0
            for file in os.listdir(temp_dir):
                path = os.path.join(temp_dir, file)
                if os.path.isfile(path):
                    try:
                        os.remove(path)
                        count += 1
                    except Exception as e:
                        QMessageBox.warning(self.dockwidget, "Lỗi", f"Không thể xóa {file}: {e}")

            QMessageBox.information(self.dockwidget, "Hoàn tất", f"Đã xóa {count} file trong thư mục Temp.")
            self.dockwidget.cboTinh.clear()
            self.dockwidget.cboHuyen.clear()
            self.dockwidget.cboXa.clear()
        else:
            QMessageBox.warning(self.dockwidget, "Không tồn tại", "Thư mục Temp không tồn tại.")    
    #---------------------------------------------------------------------------------------------------------
    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""

        #print "** CLOSING Tonghopbieu"

        # disconnects
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)

        # remove this statement if dockwidget is to remain
        # for reuse if plugin is reopened
        # Commented next statement since it causes QGIS crashe
        # when closing the docked window:
        # self.dockwidget = None

        self.pluginIsActive = False


    def unload(self):
        try:
            if self.dock:
                self.iface.removeDockWidget(self.dock)
                self.dock.deleteLater()
        except Exception:
            pass

        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Tổng hợp biểu điều tra'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    def _update_elapsed_time(self, progress_dialog):
        self.elapsed_seconds += 1
        elapsed_str = time.strftime('%H:%M:%S', time.gmtime(self.elapsed_seconds))
        progress_dialog.setLableText(f"Đang tổng hợp...(Đã chạy: {elapsed_str})")
    def dvhc2cap(self):
        if self.dockwidget.ckbox.isChecked():
            self.dockwidget.cboBieuhuyen.setEnabled(False)
            self.dockwidget.cboHuyen.setEnabled(False)
        else:
            self.dockwidget.cboBieuhuyen.setEnabled(True)
            elf.dockwidget.cboHuyen.setEnabled(True)
    #--------------------------------------------------------------------------

    def run(self):
        # mở/tạo dock
        if getattr(self, "pluginIsActive", False) and getattr(self, "dock", None):
            self.dock.show()
            return

        self.pluginIsActive = True
        self.dock = TonghopbieuDockWidget(self.iface.mainWindow())
        # Cho Dock biết 'owner' chính là plugin (để gọi các hàm tonghopbieuXX…)
        self.dockwidget = self.dock
        self.dock._owner = self
        self.iface.addDockWidget(Qt.RightDockWidgetArea, self.dock)
        self.dock.show()

    def tao_chuoi_ngay(self):
        """
        Trả về chuỗi ngày theo 1 trong 3 mẫu:
          1) 'Ngày ...... tháng ...... năm ......'
          2) 'Ngày ...... tháng ...... năm {năm hiện tại}'
          3) 'Ngày {d} tháng {m} năm {y}'  (d/m/y lấy từ dateEdit)
        """
        try:
            d = self.dockwidget.dateEdit.date()
            if not isinstance(d, QDate) or not d.isValid():
                d = QDate.currentDate()
        except Exception:
            d = QDate.currentDate()

        y = d.year()
        m = d.month()
        day = d.day()

        # Lấy trạng thái radio nếu có (mặc định dùng mẫu 3)
        rad1 = getattr(self.dockwidget, "radNgayMau1", None)
        rad2 = getattr(self.dockwidget, "radNgayMau2", None)
        rad3 = getattr(self.dockwidget, "radNgayMau3", None)

        if rad1 and rad1.isChecked():
            return "Ngày ...... tháng ...... năm ......"
        if rad2 and rad2.isChecked():
            return f"Ngày ...... tháng ...... năm {y}"
        # mặc định hoặc rad3
        return f"Ngày {day} tháng {m} năm {y}"
           
    def capnhat_ngay(self):
        vidu = f"Ví dụ: {self.tao_chuoi_ngay()}"
        self.dockwidget.lblNgay.setText(vidu)
    def cap_nhat_lblNgay(self):
        chuoi = self.tao_chuoi_ngay()
        self.dockwidget.lblNgay.setText(chuoi)
        date = self.dockwidget.dateEdit.date()
        ngay_str = f"{date.day():02d}"
        nam = date.year()
        nam_hien_tai = QDate.currentDate().year()

        if nam > nam_hien_tai:
            QMessageBox.warning(
                self.dockwidget,
                "Cảnh báo",
                "Bạn không được chọn năm lớn hơn năm hiện tại!"
            )
            self.dockwidget.dateEdit.setDate(QDate.currentDate())
            return()
            
        if date.month() <3:
            thang_str = f"{date.month():02d}"        
        else:
            thang_str = f"{date.month()}"
        nam_str = str(date.year())
        if self.dockwidget.rad_Thieutoanbo.isChecked():
            self.dockwidget.lblNgay.setText(
                f"Ví dụ: Ngày ......... tháng ......... năm 20...."
            )
        if self.dockwidget.rad_Thieungaythang.isChecked():
            self.dockwidget.lblNgay.setText(
                f"Ngày ......... tháng ......... năm {date.year()}"
            )
        else:
            self.dockwidget.lblNgay.setText(
                f"Ví dụ: Ngày {ngay_str} tháng {thang_str} năm {nam_str}"
            )        
#--------------------------------------------------------------------------
    def chon_bieu_tinh(self, ten_bieu):
    
        if not getattr(self, "plugin_is_ready", False):
            return    
        if ten_bieu == "Biểu 01. Các chỉ tiêu bình quân về trữ lượng rừng":
            self.tonghopbieu1tinh()
            return
        elif ten_bieu == "Biểu 02. Diện tích các loại rừng phân theo mục đích sử dụnng":
            self.tonghopbieu2tinh()
        elif ten_bieu == "Biểu 03. Trữ lượng các loại rừng phân theo mục đích sử dụng":
            self.tonghopbieu3tinh()
        elif ten_bieu == "Biểu 04. Trữ lượng các-bon rừng phân theo mục đích sử dụng":
            self.tonghopbieu4tinh()
        elif ten_bieu == "Biểu 05. Tổng hợp kết quả điều tra tre nứa":
            self.tonghopbieu5tinh()
        elif ten_bieu == "Biểu 06. Tổng hợp tỷ lệ che phủ rừng":
            self.tonghopbieu6tinh()
        if ten_bieu == "Biểu 07. Diện tích rừng trồng phân theo loài cây và cấp tuổi":
            self.tonghopbieu7tinh()
        elif ten_bieu == "Biểu 08. Trữ lượng rừng trồng phân theo loài cây và cấp tuổi":
            self.tonghopbieu8tinh()
        elif ten_bieu == "Biểu 09. Trữ lượng các-bon rừng phân theo loài cây và cấp tuổi":
            self.tonghopbieu9tinh()
        elif ten_bieu == "Biểu 10. Tổng hợp diện tích các loại rừng theo mục đích sử dụng":
            self.tonghopbieu10tinh()
        elif ten_bieu == "Biểu 11. Tổng hộp trữ lượng các loại rừng theo mục đích sử dụng":
            self.tonghopbieu11tinh()
        elif ten_bieu == "Biểu 12. Tổng hợp các-bon các loại rừng theo mục đích sử dụng":
            self.tonghopbieu12tinh()
    def chon_bieu_huyen(self, ten_bieu):
        if not getattr(self, "plugin_is_ready", False):
            return
        if ten_bieu == "Biểu 01. Các chỉ tiêu bình quân về trữ lượng rừng":
            self.tonghopbieu1huyen()
        elif ten_bieu == "Biểu 02. Diện tích các loại rừng phân theo mục đích sử dụnng":
            self.tonghopbieu2huyen()
        elif ten_bieu == "Biểu 03. Trữ lượng các loại rừng phân theo mục đích sử dụng":
            self.tonghopbieu3huyen()
        elif ten_bieu == "Biểu 04. Trữ lượng các-bon rừng phân theo mục đích sử dụng":
            self.tonghopbieu4huyen()
        elif ten_bieu == "Biểu 05. Tổng hợp kết quả điều tra tre nứa":
            self.tonghopbieu5huyen()
        elif ten_bieu == "Biểu 06. Tổng hợp tỷ lệ che phủ rừng":
            self.tonghopbieu6huyen()
        if ten_bieu == "Biểu 07. Diện tích rừng trồng phân theo loài cây và cấp tuổi":
            self.tonghopbieu7huyen()
        elif ten_bieu == "Biểu 08. Trữ lượng rừng trồng phân theo loài cây và cấp tuổi":
            self.tonghopbieu8huyen()
        elif ten_bieu == "Biểu 09. Trữ lượng các-bon rừng phân theo loài cây và cấp tuổi":
            self.tonghopbieu9huyen()
        elif ten_bieu == "Biểu 10. Tổng hợp diện tích các loại rừng theo mục đích sử dụng":
            self.tonghopbieu10huyen()
        elif ten_bieu == "Biểu 11. Tổng hộp trữ lượng các loại rừng theo mục đích sử dụng":
            self.tonghopbieu11huyen()
        elif ten_bieu == "Biểu 12. Tổng hợp các-bon các loại rừng theo mục đích sử dụng":
            self.tonghopbieu12huyen()
    def chon_bieu_xa(self, ten_bieu):
        if not getattr(self, "plugin_is_ready", False):
            return
        if ten_bieu == "Biểu 01. Các chỉ tiêu bình quân về trữ lượng rừng":
            self.tonghopbieu1xa()
        elif ten_bieu == "Biểu 02. Diện tích các loại rừng phân theo mục đích sử dụnng":
            self.tonghopbieu2xa()
        elif ten_bieu == "Biểu 03. Trữ lượng các loại rừng phân theo mục đích sử dụng":
            self.tonghopbieu3xa()
        elif ten_bieu == "Biểu 04. Trữ lượng các-bon rừng phân theo mục đích sử dụng":
            self.tonghopbieu4xa()
        elif ten_bieu == "Biểu 05. Tổng hợp kết quả điều tra tre nứa":
            self.tonghopbieu5xa()
        elif ten_bieu == "Biểu 06. Tổng hợp tỷ lệ che phủ rừng":
            self.tonghopbieu6xa()
        if ten_bieu == "Biểu 07. Diện tích rừng trồng phân theo loài cây và cấp tuổi":
            self.tonghopbieu7xa()
        elif ten_bieu == "Biểu 08. Trữ lượng rừng trồng phân theo loài cây và cấp tuổi":
            self.tonghopbieu8xa()
        elif ten_bieu == "Biểu 09. Trữ lượng các-bon rừng phân theo loài cây và cấp tuổi":
            self.tonghopbieu9xa()
        elif ten_bieu == "Biểu 10. Tổng hợp diện tích các loại rừng theo mục đích sử dụng":
            self.tonghopbieu10xa()
        elif ten_bieu == "Biểu 11. Tổng hộp trữ lượng các loại rừng theo mục đích sử dụng":
            self.tonghopbieu11xa()
        elif ten_bieu == "Biểu 12. Tổng hợp các-bon các loại rừng theo mục đích sử dụng":
            self.tonghopbieu12xa()             
    def on_layer_selected(self, layer):

        if not layer:
            QMessageBox.warning(self.dockwidget, "Thiếu lớp", "Bạn chưa chọn lớp bản đồ.")
            return

        # Kiểm tra trường 'tinh'
        field_names = [f.name() for f in layer.fields()]
        if 'tinh' not in field_names:
            QMessageBox.warning(self.dockwidget, "Thiếu trường", "Lớp không có trường 'tinh'")
            return

        # Đường dẫn file JSON
        ten_lop = layer.name()
        tenjson = f"{ten_lop}.json"
        duong_dan_json = os.path.join(os.path.dirname(__file__), "temp", tenjson)
        os.makedirs(os.path.dirname(duong_dan_json), exist_ok=True)
        self.duong_dan_json = duong_dan_json

        # Kiểm tra nếu file JSON đã tồn tại
        if os.path.exists(duong_dan_json):
            lua_chon = QMessageBox.question(
                self.dockwidget,
                "Tệp đã tồn tại",
                f"File JSON '{tenjson}' đã tồn tại.\nBạn có muốn thay thế không?",
                QMessageBox.Yes | QMessageBox.No,
                QMessageBox.No
            )

            if lua_chon == QMessageBox.No:
                # Đọc dữ liệu từ JSON cũ
                with open(duong_dan_json, "r", encoding="utf-8") as f:
                    data = json.load(f)
            else:
                data = self.tao_file_json_tu_layer(layer, duong_dan_json)
        else:
            data = self.tao_file_json_tu_layer(layer, duong_dan_json)

        # Lọc tỉnh duy nhất và nạp vào combobox
        ds_tinh = sorted({row["tinh"].strip() for row in data if row.get("tinh")})
        
        self.dockwidget.cboTinh.clear()
        self.dockwidget.cboTinh.addItems(ds_tinh)

    # Hàm phụ: tạo file JSON mới từ layer
    def tao_file_json_tu_layer(self, layer, path_json):
    # Hiển thị hộp tiến trình đơn giản
        progress = QProgressDialog("Đang nạp dữ liệu từ lớp bản đồ...", None, 0, 0, self.dockwidget)
        progress.setWindowTitle("Đang nạp dữ liệu")
        progress.setWindowModality(Qt.ApplicationModal)
        progress.setCancelButton(None)
        progress.setMinimumDuration(0)
        progress.show()
        QApplication.processEvents()


        field_names = [f.name() for f in layer.fields()]
        data = []
        for feat in layer.getFeatures():
            attr = feat.attributes()
            attr_dict = {
                field.name(): attr[idx] if not hasattr(attr[idx], 'toPyObject') else attr[idx].toPyObject()
                for idx, field in enumerate(layer.fields())
            }
            data.append({k: str(v) if isinstance(v, QVariant) else v for k, v in attr_dict.items()})

        with open(path_json, "w", encoding="utf-8") as f:
            json.dump(data, f, ensure_ascii=False, indent=2)

        progress.close()  # ✅ Hộp sẽ tự đóng đúng cách

        QMessageBox.information(self.dockwidget, "Hoàn tất", "Đã nạp dữ liệu thành công.")
        return data
#---------------------------------------------------------------------------------------
    def on_tinh_selected(self, index):
        ten_tinh = self.dockwidget.cboTinh.currentText()
        if not ten_tinh:
            return()
        if ten_tinh not in licenses():
            QMessageBox.warning(self.dockwidget, "Cảnh báo", f"'{ten_tinh}' chưa được cấp phép sử dụng. Vui lòng liên hệ với tác giả!")
            return()
        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)
        ds_huyen = sorted({d["huyen"].strip() for d in data if d.get("tinh") == ten_tinh and d.get("huyen")})
        
        self.dockwidget.cboHuyen.clear()
        self.dockwidget.cboHuyen.addItems(ds_huyen)
#---------------------------------------------------------------------------------------
    def on_huyen_selected(self, index):
        ten_tinh = self.dockwidget.cboTinh.currentText()
        if self.dockwidget.ckbox.isChecked():
            ten_huyen = self.dockwidget.cboHuyen.currentText()
            if not ten_tinh:
                return()
            with open(self.duong_dan_json, "r", encoding="utf-8") as f:
                data = json.load(f)

            ds_xa = sorted({
                d["xa"].strip()
                for d in data
                if d.get("tinh") == ten_tinh and d.get("xa")
            })

            self.dockwidget.cboXa.clear()
            self.dockwidget.cboXa.addItems(ds_xa)
        else:
            ten_huyen = self.dockwidget.cboHuyen.currentText()
            if not ten_tinh:
                return()
            with open(self.duong_dan_json, "r", encoding="utf-8") as f:
                data = json.load(f)

            ds_xa = sorted({
                d["xa"].strip()
                for d in data
                if d.get("tinh") == ten_tinh and d.get("huyen") == ten_huyen and d.get("xa")
            })

            self.dockwidget.cboXa.clear()
            self.dockwidget.cboXa.addItems(ds_xa)
# Quản lý các điều khiển
    def on_layer_changed(self):
        ten_lop = self.dockwidget.cboLayer.currentText()

        co_lop = bool(ten_lop.strip())  # True nếu có tên lớp

        # Enable/Disable các combo khác dựa vào trạng thái của cboLayer
        self.dockwidget.txtNamdt.setEnabled(co_lop)
        self.dockwidget.cboTinh.setEnabled(co_lop)
        self.dockwidget.cboHuyen.setEnabled(co_lop)
        self.dockwidget.cboXa.setEnabled(co_lop)
        self.dockwidget.dateEdit.setEnabled(co_lop)
        self.dockwidget.rad_Dungaythangnam.setEnabled(co_lop)
        self.dockwidget.rad_Thieungaythang.setEnabled(co_lop)
        self.dockwidget.rad_Thieutoanbo.setEnabled(co_lop)
        self.dockwidget.cboBieutinh.setEnabled(co_lop)
        self.dockwidget.cboBieuhuyen.setEnabled(co_lop)
        self.dockwidget.cboBieuxa.setEnabled(co_lop)
        
####### CẤP TỈNH ########        
# ------------ BIỂU 01 TỈNH ---------------------------------------------------------------------------        
    def tonghopbieu1tinh(self):
        
        ten_lop = self.dockwidget.cboLayer.currentText()
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_xa = self.dockwidget.cboXa.currentText()
        ket_qua ="Biểu 01. " + ten_tinh + ".xlsx"
        if not ten_lop:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn lớp bản đồ.")
            return

        layer = next((l for l in QgsProject.instance().mapLayers().values() if l.name() == ten_lop), None)
        if not layer:
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy lớp: {ten_lop}")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu01.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return
        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        # Đọc dữ liệu từ file JSON đã tạo từ lớp bản đồ
        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file JSON dữ liệu.")
            return

        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)
        # Các trường bắt buộc cần có
        required_fields = {"tinh", "ldlr", "mgo", "mtn", "nggocr"}

        # Kiểm tra xem bản ghi đầu tiên có đủ trường không
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(
                self.dockwidget,
                "Thiếu trường dữ liệu",
                f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}"
            )
            return
        # Bảng thông báo
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
        #progress.show()
        #QApplication.processEvents()        
        # Lọc dữ liệu theo tỉnh và điều kiện
        filtered = [
            row for row in data
            if row.get("tinh") == ten_tinh
            and isinstance(row.get("nggocr"), (int, float))
            and 0 < row["nggocr"] < 3
            and row.get("ldlr")  # Trạng thái rừng không rỗng
        ]

        if not filtered:
            QMessageBox.warning(self.dockwidget, "Không có dữ liệu", "Không có dữ liệu phù hợp với điều kiện lọc.")
            progress.close()
            return

        df = pd.DataFrame(filtered)

        # Chỉ lấy các cột cần thiết nếu chưa có
        df = df[["ldlr", "mgo", "mtn"]]
        # Nhân cột mtn với 1000 trước khi tính trung bình (Tính số cây)
        df["mtn"] = df["mtn"] * 1000
        # Tính toán giá trị trung bình mgo, mtn
        
        summary = df.groupby("ldlr")[["mgo","mtn"]].mean().reset_index()
        summary.columns = ["Trạng thái","Trữ lượng gỗ","Trữ lượng tre nứa"]
        ntrangthai = df["ldlr"].nunique()
        ndongchen = ntrangthai - 2
        print(summary)
        # Mở tệp mẫu    
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active
        
        # Chèn thêm dòng
        start_row = 5
        ws.insert_rows(idx=6, amount = ndongchen)
       
        # Ghi dữ liệu vào từng dòng
        
        for idx, row in summary.iterrows():
            ws[f"A{start_row + idx}"] = idx + 1
            ws[f"B{start_row + idx}"] = row["Trạng thái"]
            ws[f"C{start_row + idx}"] = round(row["Trữ lượng gỗ"], 2)
            ws[f"D{start_row + idx}"] = round(row["Trữ lượng tre nứa"], 2)
        
        # Bước 2: Sao chép định dạng từ dòng mẫu (dòng gốc trước khi chèn, ở đây là dòng 4 + so_dong_chen)
        mau_row = start_row + ndongchen  # dòng gốc đã bị đẩy xuống
        for row_offset in range(ndongchen):
            for col in range(1, 6):  # copy theo số cột đang có
                new_cell = ws.cell(row=start_row + row_offset + 1, column=col)
                template_cell = ws.cell(row=5, column=col)

                # Sao chép giá trị format
                if template_cell.has_style:
                    new_cell.font = copy(template_cell.font)
                    new_cell.border = copy(template_cell.border)
                    new_cell.fill = copy(template_cell.fill)
                    new_cell.number_format = copy(template_cell.number_format)
                    new_cell.protection = copy(template_cell.protection)
                    new_cell.alignment = copy(template_cell.alignment)
        
        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_tinh}"
        ws.merge_cells("A2:E2")
        row_ngay = start_row + ndongchen + 3
        row_ky  = start_row + ndongchen + 4
        ngayky = self.tao_chuoi_ngay()
        ws[f"D{row_ngay}"] = ngayky
        ws.merge_cells(f"D{row_ngay}:E{row_ngay}")
        ws.merge_cells(f"A{row_ky}:B{row_ky}")
        ws.merge_cells(f"D{row_ky}:E{row_ky}")
        
        from openpyxl.styles import Alignment
        from openpyxl.styles import Font
        
        ws["A2"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"D{row_ngay}"].font = Font(name="Times New Roman", size = 12, italic = True)
        ws[f"D{row_ngay}"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"A{row_ky}"] = "Thủ trưởng đơn vị"
        ws[f"A{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"A{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"D{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"D{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        
        #progress.close()
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")

# ------------ BIỂU 2 TỈNH --------------------------------------------------------------------------        
    def tonghopbieu2tinh(self):
        
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ket_qua = f"Biểu 02. {ten_tinh}.xlsx"

        if not ten_tinh:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn tỉnh.")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu02.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return

        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file dữ liệu JSON.")
            return

        # Mở file Excel
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active

        # Đọc dữ liệu từ file JSON
        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)

        required_fields = {"tinh", "nggocr", "maldlr", "mamdsd", "dtich", "malr3"}
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(self.dockwidget, "Thiếu trường", f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}")
            return
        # Bảng thông báo
        self.elapsed_seconds = 0
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
       # progress.show()
        #timer = QTimer()
        #timer.timeout.connect(lambda: self._update_elapsed_time(progress))
        #timer.start(1000)
        #QApplication.processEvents()
        
        # Hàm tính tổng theo điều kiện
        def tong_tinh2(nggocr_val, maldlr_val, mamdsd_val, malr3_val):
            return float(round(sum(
                Decimal(str(round(row["dtich"], 2)))
                for row in data
                if row.get("tinh") == ten_tinh
                and row.get("nggocr") == nggocr_val
                and row.get("maldlr") == maldlr_val
                and (row.get("mamdsd") in mamdsd_val and row.get("malr3") == malr3_val)
                and isinstance(row.get("dtich"), (int, float))
            ), 2))
        # ====== GHI KẾT QUẢ VÀO EXCEL ========
        # Rừng tự nhiên - Nguyên Sinh
            # Rừng nguyên sinh núi đất
        n_row = 11
        ws[f"E{n_row}"] = tong_tinh2(1, 1, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, 1, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, 1, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, 1, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, 1, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, 1, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, 1, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, 1, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, 1, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, 1, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, 1, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, 1, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nguyên sinh núi đá
        n_row = 12
        ws[f"E{n_row}"] = tong_tinh2(1, 2, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, 2, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, 2, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, 2, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, 2, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, 2, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, 2, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, 2, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, 2, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, 2, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, 2, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, 2, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nguyên sinh ngập nước
        n_row = 13
        ws[f"E{n_row}"] = tong_tinh2(1, 3, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, 3, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, 3, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, 3, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, 3, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, 3, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, 3, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, 3, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, 3, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, 3, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, 3, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, 3, [0, 15], 0) # Ngoài quy hoạch
# Rừng tự nhiên - Thứ sinh
# ----- Rừng lá rộng thường xanh và nửa rụng lá ------
    # Rừng giàu - TXG
        n_row = 18
        ma_ldlr = 4
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - TXB
        n_row = 19
        ma_ldlr = 5
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng nghèo - TXN
        n_row = 20
        ma_ldlr = 6
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng nghèo kiệt - TXK
        n_row = 21
        ma_ldlr = 7
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - TXP
        n_row = 22
        ma_ldlr = 8
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
# ----- Rừng lá rộng rụng lá ------
    # Rừng giàu - RLG
        n_row = 24
        ma_ldlr = 9
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - RLB
        n_row = 25
        ma_ldlr = 10
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - RLN
        n_row = 26
        ma_ldlr = 11
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - RLK
        n_row = 27
        ma_ldlr = 12
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - RLP
        n_row = 28
        ma_ldlr = 13
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng lá kim ------
    # Rừng giàu - LKG
        n_row = 30
        ma_ldlr = 14
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - LKB
        n_row = 31
        ma_ldlr = 15
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - LKN
        n_row = 32
        ma_ldlr = 16
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - LKK
        n_row = 33
        ma_ldlr = 17
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - LKP
        n_row = 34
        ma_ldlr = 18
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng hỗn giao cây lá rộng và lá kim ------
    # Rừng giàu - RKG
        n_row = 36
        ma_ldlr = 19
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - RKB
        n_row = 37
        ma_ldlr = 20
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - RKN
        n_row = 38
        ma_ldlr = 21
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - RKK
        n_row = 39
        ma_ldlr = 22
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - RKP
        n_row = 40
        ma_ldlr = 23
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng núi đá ------
    # Rừng giàu - TXDG
        n_row = 42
        ma_ldlr = 24
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - TXDB
        n_row = 43
        ma_ldlr = 25
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - TXDN
        n_row = 44
        ma_ldlr = 26
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - TXDK
        n_row = 45
        ma_ldlr = 27
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - TXDP
        n_row = 46
        ma_ldlr = 28
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng ngập nước ------
    # Rừng ngập mặn - RNM
        n_row = 48
        ma_ldlr = 29
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng ngập phèn - RNP
        n_row = 49
        ma_ldlr = 30
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng ngập ngọt - RNN
        n_row = 50
        ma_ldlr = 31
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng trên cát ------
    # Rừng trên cát - RTNC
        n_row = 51
        ma_ldlr = 32
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch 
# ----- Rừng tre nứa ------
    # Rừng tre nứa núi đất - TN
        n_row = 53
        ma_ldlr = 33
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng tre nứa núi đá - TND
        n_row = 54
        ma_ldlr = 34
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng hỗn giao gỗ và tre nứa ------
    # Rừng hỗn giao gỗ và tre nứa núi đất - HG
        n_row = 56
        ma_ldlr = 35
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng hỗn giao gỗ và tre nứa núi đá - HGD
        n_row = 57
        ma_ldlr = 36
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng cau dừa ------
    # Rừng cau dừa núi đất - CD
        n_row = 59
        ma_ldlr = 37
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa núi đá - CDD
        n_row = 60
        ma_ldlr = 38
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa ngập nước- CDN
        n_row = 61
        ma_ldlr = 39
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trên cát - CDC
        n_row = 62
        ma_ldlr = 40
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ====== RỪNG TRỒNG ===========
# Rừng gỗ (loài cây, cấp tuổi, nguồn gốc)
    # Rừng gỗ trồng núi đất - TG
        n_row = 65
        ma_ldlr = 41
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng núi đá - TGD
        n_row = 66
        ma_ldlr = 42
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập ngọt - TGNN
        n_row = 67
        ma_ldlr = 43
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập mặn - TGNM
        n_row = 68
        ma_ldlr = 44
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập phèn - TGNP
        n_row = 69
        ma_ldlr = 45
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng trên cát - TGC
        n_row = 70
        ma_ldlr = 46
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
# Rừng tre nứa
    # Rừng tre nứa trồng núi đất - TTN
        n_row = 72
        ma_ldlr = 47
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng tre nứa trồng núi đá - TTND
        n_row = 73
        ma_ldlr = 48
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# Rừng cau dừa
    # Rừng cau dừa trồng núi đất - TCD
        n_row = 75
        ma_ldlr = 49
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng núi đá - TCDD
        n_row = 76
        ma_ldlr = 50
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng ngập nước - TCDN
        n_row = 77
        ma_ldlr = 51
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng trên cát - TCDC
        n_row = 78
        ma_ldlr = 52
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ==== DIỆN TÍCH CHƯA CÓ RỪNG =====
    # Diện tích đã trồng cây rừng nhưng chưa đạt các tiêu chí thành rừng - DTR
        n_row = 80
        ma_ldlr = 53
        ws[f"E{n_row}"] = tong_tinh2(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch    
    # Diện tích có cây tái sinh - DTS
        n_row = 81
        ma_ldlr = 54
        ws[f"E{n_row}"] = tong_tinh2(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Diện tích khác - DTK
        n_row = 82
        ma_ldlr = 55
        ws[f"E{n_row}"] = tong_tinh2(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch

        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_tinh}"
        ws.merge_cells("A2:Q2")
        
        # Định dạng số liệu
        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                cell.number_format = '#,##0.00'  # 2 chữ số sau dấu phẩy + phân cách hàng nghìn
        custom_format = '#,##0.00;-#,##0.00;"-"'  # hai chữ số thập phân, 0 hiển thị là "-"

        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                if isinstance(cell.value, (int, float)):
                    cell.number_format = custom_format
                    
        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                if cell.data_type == 'f':  # là ô công thức
                    cell.number_format = '#,##0.00;-#,##0.00;"-"'
        ngayky = self.tao_chuoi_ngay()
        ws["M84"] = ngayky
        ws.merge_cells("M84:Q84")
        
        #timer.stop()
        #progress.close()
        wb.properties.calcMode = 'auto'
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")

# ------------ BIỂU 3 TỈNH --------------------------------------------------------------------------        
    def tonghopbieu3tinh(self):
        
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ket_qua = f"Biểu 03. {ten_tinh}.xlsx"

        if not ten_tinh:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn tỉnh.")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu03.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return

        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file dữ liệu JSON.")
            return

        # Mở file Excel
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active

        # Đọc dữ liệu từ file JSON
        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)

        required_fields = {"tinh", "nggocr", "maldlr", "mamdsd", "mgo", "mtn", "malr3"}
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(self.dockwidget, "Thiếu trường", f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}")
            return
        # Bảng thông báo
        self.elapsed_seconds = 0
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
        #progress.show()
        #timer = QTimer()
        #timer.timeout.connect(lambda: self._update_elapsed_time(progress))
        #timer.start(1000)
        #QApplication.processEvents()
        # Hàm tính tổng theo điều kiện
        def tong_mgo_tinh3(nggocr_val, maldlr_val, mamdsd_val, malr3_val):
            return float(round(sum(
                Decimal(str(round(row["mgolo"], 2)))
                for row in data
                if row.get("tinh") == ten_tinh
                and row.get("nggocr") == nggocr_val
                and row.get("maldlr") == maldlr_val
                and (row.get("mamdsd") in mamdsd_val and row.get("malr3") == malr3_val)
                and isinstance(row.get("mgolo"), (int, float))
            ), 2))
        def tong_mtn_tinh3(nggocr_val, maldlr_val, mamdsd_val, malr3_val):
            return float(round(sum(
                Decimal(str(round(row["mtnlo"], 2)))
                for row in data
                if row.get("tinh") == ten_tinh
                and row.get("nggocr") == nggocr_val
                and row.get("maldlr") == maldlr_val
                and (row.get("mamdsd") in mamdsd_val and row.get("malr3") == malr3_val)
                and isinstance(row.get("mtnlo"), (int, float))
            ), 2))
        # ====== GHI KẾT QUẢ VÀO EXCEL ========
        # Rừng tự nhiên - Nguyên Sinh
            # Rừng nguyên sinh núi đất
        n_row = 11
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, 1, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, 1, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, 1, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, 1, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, 1, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, 1, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, 1, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, 1, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, 1, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, 1, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, 1, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, 1, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nguyên sinh núi đá
        n_row = 12
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, 2, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, 2, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, 2, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, 2, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, 2, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, 2, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, 2, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, 2, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, 2, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, 2, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, 2, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, 2, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nguyên sinh ngập nước
        n_row = 13
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, 3, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, 3, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, 3, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, 3, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, 3, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, 3, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, 3, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, 3, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, 3, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, 3, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, 3, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, 3, [0, 15], 0) # Ngoài quy hoạch
# Rừng tự nhiên - Thứ sinh
# ----- Rừng lá rộng thường xanh và nửa rụng lá ------
    # Rừng giàu - TXG
        n_row = 18
        ma_ldlr = 4
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - TXB
        n_row = 19
        ma_ldlr = 5
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng nghèo - TXN
        n_row = 20
        ma_ldlr = 6
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng nghèo kiệt - TXK
        n_row = 21
        ma_ldlr = 7
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - TXP
        n_row = 22
        ma_ldlr = 8
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
# ----- Rừng lá rộng rụng lá ------
    # Rừng giàu - RLG
        n_row = 24
        ma_ldlr = 9
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - RLB
        n_row = 25
        ma_ldlr = 10
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - RLN
        n_row = 26
        ma_ldlr = 11
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - RLK
        n_row = 27
        ma_ldlr = 12
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - RLP
        n_row = 28
        ma_ldlr = 13
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng lá kim ------
    # Rừng giàu - LKG
        n_row = 30
        ma_ldlr = 14
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - LKB
        n_row = 31
        ma_ldlr = 15
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - LKN
        n_row = 32
        ma_ldlr = 16
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - LKK
        n_row = 33
        ma_ldlr = 17
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - LKP
        n_row = 34
        ma_ldlr = 18
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng hỗn giao cây lá rộng và lá kim ------
    # Rừng giàu - RKG
        n_row = 36
        ma_ldlr = 19
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - RKB
        n_row = 37
        ma_ldlr = 20
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - RKN
        n_row = 38
        ma_ldlr = 21
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - RKK
        n_row = 39
        ma_ldlr = 22
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - RKP
        n_row = 40
        ma_ldlr = 23
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng núi đá ------
    # Rừng giàu - TXDG
        n_row = 42
        ma_ldlr = 24
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - TXDB
        n_row = 43
        ma_ldlr = 25
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - TXDN
        n_row = 44
        ma_ldlr = 26
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - TXDK
        n_row = 45
        ma_ldlr = 27
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - TXDP
        n_row = 46
        ma_ldlr = 28
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng ngập nước ------
    # Rừng ngập mặn - RNM
        n_row = 48
        ma_ldlr = 29
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng ngập phèn - RNP
        n_row = 49
        ma_ldlr = 30
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng ngập ngọt - RNN
        n_row = 50
        ma_ldlr = 31
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng trên cát ------
    # Rừng trên cát - RTNC
        n_row = 51
        ma_ldlr = 32
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch 
# ----- Rừng tre nứa ------
    # Rừng tre nứa núi đất - TN
        n_row = 53
        ma_ldlr = 33
        ws[f"E{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng tre nứa núi đá - TND
        n_row = 54
        ma_ldlr = 34
        ws[f"E{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng hỗn giao gỗ và tre nứa ------
    # Rừng hỗn giao gỗ và tre nứa núi đất - HG
        n_row = 56
        ma_ldlr = 35
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) + tong_mtn_tinh3(1, ma_ldlr, [1], 2)# Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) + tong_mtn_tinh3(1, ma_ldlr, [2], 2)# Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) + tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) + tong_mtn_tinh3(1, ma_ldlr, [4], 2)# Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) + tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2)# Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) + tong_mtn_tinh3(1, ma_ldlr, [8], 1)# Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) + tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) + tong_mtn_tinh3(1, ma_ldlr, [10], 1)# Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) + tong_mtn_tinh3(1, ma_ldlr, [11], 1)# Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) + tong_mtn_tinh3(1, ma_ldlr, [12], 1)# Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) + tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3)# Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) + tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0)# Ngoài quy hoạch
    # Rừng hỗn giao gỗ và tre nứa núi đá - HGD
        n_row = 57
        ma_ldlr = 36
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) + tong_mtn_tinh3(1, ma_ldlr, [1], 2)# Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) + tong_mtn_tinh3(1, ma_ldlr, [2], 2)# Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) + tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) + tong_mtn_tinh3(1, ma_ldlr, [4], 2)# Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) + tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2)# Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) + tong_mtn_tinh3(1, ma_ldlr, [8], 1)# Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) + tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) + tong_mtn_tinh3(1, ma_ldlr, [10], 1)# Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) + tong_mtn_tinh3(1, ma_ldlr, [11], 1)# Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) + tong_mtn_tinh3(1, ma_ldlr, [12], 1)# Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) + tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3)# Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) + tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0)# Ngoài quy hoạch
# ----- Rừng cau dừa ------
    # Rừng cau dừa núi đất - CD
        n_row = 59
        ma_ldlr = 37
        ws[f"E{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa núi đá - CDD
        n_row = 60
        ma_ldlr = 38
        ws[f"E{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa ngập nước- CDN
        n_row = 61
        ma_ldlr = 39
        ws[f"E{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trên cát - CDC
        n_row = 62
        ma_ldlr = 40
        ws[f"E{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ====== RỪNG TRỒNG ===========
# Rừng gỗ (loài cây, cấp tuổi, nguồn gốc)
    # Rừng gỗ trồng núi đất - TG
        n_row = 65
        ma_ldlr = 41
        ws[f"E{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng núi đá - TGD
        n_row = 66
        ma_ldlr = 42
        ws[f"E{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập ngọt - TGNN
        n_row = 67
        ma_ldlr = 43
        ws[f"E{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập mặn - TGNM
        n_row = 68
        ma_ldlr = 44
        ws[f"E{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập phèn - TGNP
        n_row = 69
        ma_ldlr = 45
        ws[f"E{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng trên cát - TGC
        n_row = 70
        ma_ldlr = 46
        ws[f"E{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
# Rừng tre nứa
    # Rừng tre nứa trồng núi đất - TTN
        n_row = 72
        ma_ldlr = 47
        ws[f"E{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng tre nứa trồng núi đá - TTND
        n_row = 73
        ma_ldlr = 48
        ws[f"E{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# Rừng cau dừa
    # Rừng cau dừa trồng núi đất - TCD
        n_row = 75
        ma_ldlr = 49
        ws[f"E{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng núi đá - TCDD
        n_row = 76
        ma_ldlr = 50
        ws[f"E{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng ngập nước - TCDN
        n_row = 77
        ma_ldlr = 51
        ws[f"E{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng trên cát - TCDC
        n_row = 78
        ma_ldlr = 52
        ws[f"E{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ==== DIỆN TÍCH CHƯA CÓ RỪNG =====
    # Diện tích đã trồng cây rừng nhưng chưa đạt các tiêu chí thành rừng - DTR
        n_row = 80
        ma_ldlr = 53
        ws[f"E{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch    
    # Diện tích có cây tái sinh - DTS
        n_row = 81
        ma_ldlr = 54
        ws[f"E{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Diện tích khác - DTK
        n_row = 82
        ma_ldlr = 55
        ws[f"E{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch

        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_tinh}"
        ws.merge_cells("A2:Q2")
        ngayky = self.tao_chuoi_ngay()
        ws["M84"] = ngayky
        ws.merge_cells("M84:Q84")        
        
        # Định dạng số liệu
        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                cell.number_format = '#,##0.00'  # 2 chữ số sau dấu phẩy + phân cách hàng nghìn
        custom_format = '#,##0.00;-#,##0.00;"-"'  # hai chữ số thập phân, 0 hiển thị là "-"

        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                if isinstance(cell.value, (int, float)):
                    cell.number_format = custom_format
                    
        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                if cell.data_type == 'f':  # là ô công thức
                    cell.number_format = '#,##0.00;-#,##0.00;"-"'

        #timer.stop()
        #progress.close()
        wb.properties.calcMode = 'auto'
        
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")

# ----------- BIỂU 04 TỈNH --------------------------------------------------------------------------
    def tonghopbieu4tinh(self):
        
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ket_qua = f"Biểu 04. {ten_tinh}.xlsx"

        if not ten_tinh:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn tỉnh.")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu04.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return

        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file dữ liệu JSON.")
            return

        # Mở file Excel
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active

        # Đọc dữ liệu từ file JSON
        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)

        required_fields = {"tinh", "nggocr", "maldlr", "mamdsd", "dtich", "malr3"}
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(self.dockwidget, "Thiếu trường", f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}")
            return
        # Bảng thông báo
        self.elapsed_seconds = 0
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
        #progress.show()
        #timer = QTimer()
        #timer.timeout.connect(lambda: self._update_elapsed_time(progress))
        #timer.start(1000)
        #QApplication.processEvents()
        # Hàm tính tổng theo điều kiện
        def tong_mcolo_tinh4(nggocr_val, maldlr_val, mamdsd_val, malr3_val):
            return float(round(sum(
                Decimal(str(round(row["mcolo"], 2)))
                for row in data
                if row.get("tinh") == ten_tinh
                and row.get("nggocr") == nggocr_val
                and row.get("maldlr") == maldlr_val
                and (row.get("mamdsd") in mamdsd_val and row.get("malr3") == malr3_val)
                and isinstance(row.get("mcolo"), (int, float))
            ), 2))
        # ====== GHI KẾT QUẢ VÀO EXCEL ========
        # Rừng tự nhiên - Nguyên Sinh
            # Rừng nguyên sinh núi đất
        n_row = 11
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, 1, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, 1, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, 1, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, 1, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, 1, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, 1, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, 1, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, 1, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, 1, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, 1, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, 1, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, 1, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nguyên sinh núi đá
        n_row = 12
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, 2, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, 2, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, 2, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, 2, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, 2, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, 2, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, 2, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, 2, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, 2, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, 2, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, 2, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, 2, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nguyên sinh ngập nước
        n_row = 13
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, 3, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, 3, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, 3, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, 3, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, 3, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, 3, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, 3, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, 3, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, 3, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, 3, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, 3, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, 3, [0, 15], 0) # Ngoài quy hoạch
# Rừng tự nhiên - Thứ sinh
# ----- Rừng lá rộng thường xanh và nửa rụng lá ------
    # Rừng giàu - TXG
        n_row = 18
        ma_ldlr = 4
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - TXB
        n_row = 19
        ma_ldlr = 5
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng nghèo - TXN
        n_row = 20
        ma_ldlr = 6
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng nghèo kiệt - TXK
        n_row = 21
        ma_ldlr = 7
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - TXP
        n_row = 22
        ma_ldlr = 8
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
# ----- Rừng lá rộng rụng lá ------
    # Rừng giàu - RLG
        n_row = 24
        ma_ldlr = 9
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - RLB
        n_row = 25
        ma_ldlr = 10
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - RLN
        n_row = 26
        ma_ldlr = 11
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - RLK
        n_row = 27
        ma_ldlr = 12
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - RLP
        n_row = 28
        ma_ldlr = 13
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng lá kim ------
    # Rừng giàu - LKG
        n_row = 30
        ma_ldlr = 14
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - LKB
        n_row = 31
        ma_ldlr = 15
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - LKN
        n_row = 32
        ma_ldlr = 16
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - LKK
        n_row = 33
        ma_ldlr = 17
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - LKP
        n_row = 34
        ma_ldlr = 18
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng hỗn giao cây lá rộng và lá kim ------
    # Rừng giàu - RKG
        n_row = 36
        ma_ldlr = 19
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - RKB
        n_row = 37
        ma_ldlr = 20
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - RKN
        n_row = 38
        ma_ldlr = 21
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - RKK
        n_row = 39
        ma_ldlr = 22
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - RKP
        n_row = 40
        ma_ldlr = 23
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng núi đá ------
    # Rừng giàu - TXDG
        n_row = 42
        ma_ldlr = 24
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - TXDB
        n_row = 43
        ma_ldlr = 25
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - TXDN
        n_row = 44
        ma_ldlr = 26
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - TXDK
        n_row = 45
        ma_ldlr = 27
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - TXDP
        n_row = 46
        ma_ldlr = 28
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng ngập nước ------
    # Rừng ngập mặn - RNM
        n_row = 48
        ma_ldlr = 29
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng ngập phèn - RNP
        n_row = 49
        ma_ldlr = 30
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng ngập ngọt - RNN
        n_row = 50
        ma_ldlr = 31
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng trên cát ------
    # Rừng trên cát - RTNC
        n_row = 51
        ma_ldlr = 32
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch 
# ----- Rừng tre nứa ------
    # Rừng tre nứa núi đất - TN
        n_row = 53
        ma_ldlr = 33
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng tre nứa núi đá - TND
        n_row = 54
        ma_ldlr = 34
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng hỗn giao gỗ và tre nứa ------
    # Rừng hỗn giao gỗ và tre nứa núi đất - HG
        n_row = 56
        ma_ldlr = 35
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng hỗn giao gỗ và tre nứa núi đá - HGD
        n_row = 57
        ma_ldlr = 36
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng cau dừa ------
    # Rừng cau dừa núi đất - CD
        n_row = 59
        ma_ldlr = 37
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa núi đá - CDD
        n_row = 60
        ma_ldlr = 38
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa ngập nước- CDN
        n_row = 61
        ma_ldlr = 39
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trên cát - CDC
        n_row = 62
        ma_ldlr = 40
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ====== RỪNG TRỒNG ===========
# Rừng gỗ (loài cây, cấp tuổi, nguồn gốc)
    # Rừng gỗ trồng núi đất - TG
        n_row = 65
        ma_ldlr = 41
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng núi đá - TGD
        n_row = 66
        ma_ldlr = 42
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập ngọt - TGNN
        n_row = 67
        ma_ldlr = 43
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập mặn - TGNM
        n_row = 68
        ma_ldlr = 44
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập phèn - TGNP
        n_row = 69
        ma_ldlr = 45
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng trên cát - TGC
        n_row = 70
        ma_ldlr = 46
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
# Rừng tre nứa
    # Rừng tre nứa trồng núi đất - TTN
        n_row = 72
        ma_ldlr = 47
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng tre nứa trồng núi đá - TTND
        n_row = 73
        ma_ldlr = 48
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# Rừng cau dừa
    # Rừng cau dừa trồng núi đất - TCD
        n_row = 75
        ma_ldlr = 49
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng núi đá - TCDD
        n_row = 76
        ma_ldlr = 50
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng ngập nước - TCDN
        n_row = 77
        ma_ldlr = 51
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng trên cát - TCDC
        n_row = 78
        ma_ldlr = 52
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ==== DIỆN TÍCH CHƯA CÓ RỪNG =====
    # Diện tích đã trồng cây rừng nhưng chưa đạt các tiêu chí thành rừng - DTR
        n_row = 80
        ma_ldlr = 53
        ws[f"E{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch    
    # Diện tích có cây tái sinh - DTS
        n_row = 81
        ma_ldlr = 54
        ws[f"E{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Diện tích khác - DTK
        n_row = 82
        ma_ldlr = 55
        ws[f"E{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch

        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_tinh}"
        ws.merge_cells("A2:Q2")
        ngayky = self.tao_chuoi_ngay()
        ws["M84"] = ngayky
        ws.merge_cells("M84:Q84")        
        
        # Định dạng số liệu
        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                cell.number_format = '#,##0.00'  # 2 chữ số sau dấu phẩy + phân cách hàng nghìn
        custom_format = '#,##0.00;-#,##0.00;"-"'  # hai chữ số thập phân, 0 hiển thị là "-"

        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                if isinstance(cell.value, (int, float)):
                    cell.number_format = custom_format
                    
        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                if cell.data_type == 'f':  # là ô công thức
                    cell.number_format = '#,##0.00;-#,##0.00;"-"'
        #timer.stop()
        #progress.close()
        wb.properties.calcMode = 'auto'
        
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")
#------------ BIỂU 05 TỈNH ----------------------------------------------------------------------
    def tonghopbieu5tinh(self):
        
        ten_lop = self.dockwidget.cboLayer.currentText()
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_xa = self.dockwidget.cboXa.currentText()
        ket_qua ="Biểu 05. " + ten_tinh + ".xlsx"
        if not ten_lop:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn lớp bản đồ.")
            return

        layer = next((l for l in QgsProject.instance().mapLayers().values() if l.name() == ten_lop), None)
        if not layer:
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy lớp: {ten_lop}")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu05.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return
        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        # Đọc dữ liệu từ file JSON đã tạo từ lớp bản đồ
        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file JSON dữ liệu.")
            return

        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)
        # Các trường bắt buộc cần có
        required_fields = {"tinh", "maldlr","sldlr", "non", "vua", "gia", "hvn", "d13"}

        # Kiểm tra xem bản ghi đầu tiên có đủ trường không
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(
                self.dockwidget,
                "Thiếu trường dữ liệu",
                f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}"
            )
            return
        # Bảng thông báo
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
        #progress.show()
        #QApplication.processEvents()
        # Lọc dữ liệu theo tỉnh và điều kiện
        filtered = [
            row for row in data
            if row.get("tinh") == ten_tinh
            and isinstance(row.get("maldlr"), (int, float))
            and row.get("maldlr") in [35, 36, 47, 48]
            and row.get("sldlr")  # Trạng thái rừng không rỗng
        ]

        if not filtered:
            QMessageBox.warning(self.dockwidget, "Không có dữ liệu", "Không có dữ liệu phù hợp với điều kiện lọc.")
            progress.close()
            return

        df = pd.DataFrame(filtered)

        # Chỉ lấy các cột cần thiết nếu chưa có
        df = df[["sldlr", "non", "vua", "gia", "hvn", "d13"]]
        
        # Tính toán giá trị trung bình mgo, mtn
        # Gộp dữ liệu theo sldlr
        tong_hop = df.groupby("sldlr").agg({
            "non": "sum",
            "vua": "sum",
            "gia": "sum",
            "hvn": "mean",
            "d13": "mean"
        }).reset_index()
        tong_hop[["non", "vua", "gia"]] = tong_hop[["non", "vua", "gia"]] * 1000
        tong_hop["tongcay"] = tong_hop["non"] + tong_hop["vua"] + tong_hop["gia"]
        # Tùy chọn: Làm tròn
        tong_hop = tong_hop.round({
            "tongcay": 0,
            "non": 0,
            "vua": 0,
            "gia": 0,
            "hvn": 2,
            "d13": 2
        })
        
        print(tong_hop)
        
        # Tổng các cột cần cộng
        tong = tong_hop[["tongcay", "non", "vua", "gia"]].sum()

        # Trung bình các cột cần lấy trung bình
        trung_binh = tong_hop[["hvn", "d13"]].mean()

        # Dòng tổng cộng
        tong_cong = {
            "sldlr": "Tổng cộng",
            "tongcay": tong["tongcay"],
            "non": tong["non"],
            "vua": tong["vua"],
            "gia": tong["gia"],
            "hvn": trung_binh["hvn"],
            "d13": trung_binh["d13"]
        }
        print (tong_cong)
        ntrangthai = df["sldlr"].nunique()
        # Chỉ chèn dòng nếu có nhiều hơn 1 trạng thái
        ndongchen = 0
        if ntrangthai > 1:
            ndongchen = ntrangthai - 1
   
        # Mở tệp Excel
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active

            # Chèn dòng bắt đầu từ dòng 9
            ws.insert_rows(idx=9, amount=ndongchen)
        else:
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active
            print("Không cần chèn thêm dòng vì chỉ có 1 trạng thái.")
       
    # Ghi dữ liệu vào từng dòng
        # Ghi dòng tổng
        giatri_tongcay = tong_cong.get("tongcay", 0)
        giatri_non = tong_cong.get("non", 0)
        giatri_vua = tong_cong.get("vua", 0)
        giatri_gia = tong_cong.get("gia", 0)
        giatri_hvn = tong_cong.get("hvn", 1)
        giatri_d13 = tong_cong.get("d13", 1)
        ws["C7"] = giatri_tongcay
        ws["D7"] = giatri_non
        ws["E7"] = giatri_vua
        ws["F7"] = giatri_gia
        ws["G7"] = giatri_hvn
        ws["H7"] = giatri_d13
        start_row = 8
        for idx, row in tong_hop.iterrows():
            ws[f"A{start_row + idx}"] = idx + 1
            ws[f"B{start_row + idx}"] = row["sldlr"]
            ws[f"C{start_row + idx}"] = round(row["tongcay"], 0)
            ws[f"D{start_row + idx}"] = round(row["non"], 0)
            ws[f"E{start_row + idx}"] = round(row["vua"], 0)
            ws[f"F{start_row + idx}"] = round(row["gia"], 0)
            ws[f"G{start_row + idx}"] = round(row["hvn"], 1)
            ws[f"H{start_row + idx}"] = round(row["d13"], 1)
        
        # Sao chép định dạng từ dòng mẫu 
        mau_row = start_row + ndongchen  # dòng gốc đã bị đẩy xuống
        for row_offset in range(ndongchen):
            for col in range(1, 9):  # copy theo số cột đang có
                new_cell = ws.cell(row=start_row + row_offset + 1, column=col)
                template_cell = ws.cell(row=8, column=col)

                # Sao chép giá trị format
                if template_cell.has_style:
                    new_cell.font = copy(template_cell.font)
                    new_cell.border = copy(template_cell.border)
                    new_cell.fill = copy(template_cell.fill)
                    new_cell.number_format = copy(template_cell.number_format)
                    new_cell.protection = copy(template_cell.protection)
                    new_cell.alignment = copy(template_cell.alignment)
        
        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_tinh}"
        ws.merge_cells("A2:H2")
        row_ngay = start_row + ndongchen + 3
        row_ky  = start_row + ndongchen + 4
        ngayky = self.tao_chuoi_ngay()
        ws[f"F{row_ngay}"] = ngayky
        ws.merge_cells(f"F{row_ngay}:H{row_ngay}")
        ws.merge_cells(f"A{row_ky}:C{row_ky}")
        ws.merge_cells(f"F{row_ky}:H{row_ky}")
        
        from openpyxl.styles import Alignment
        from openpyxl.styles import Font
        
        ws["A2"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ngay}"].font = Font(name="Times New Roman", size = 12, italic = True)
        ws[f"F{row_ngay}"].alignment = Alignment(horizontal="center",vertical="center")
        #ws[f"A{row_ky}"] = "Thủ trưởng đơn vị"
        ws[f"A{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"A{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"F{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
		
        #progress.close()
		
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")       
#------------ BIỂU 06 TỈNH ----------------------------------------------------------------------
    def tonghopbieu6tinh(self):
        ten_lop = self.dockwidget.cboLayer.currentText()
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ket_qua ="Biểu 06. " + ten_tinh + ".xlsx"

        if not ten_lop:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn lớp bản đồ.")
            return

        layer = next((l for l in QgsProject.instance().mapLayers().values() if l.name() == ten_lop), None)
        if not layer:
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy lớp: {ten_lop}")
            return        

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu06.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return
        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        # Đọc dữ liệu từ file JSON đã tạo từ lớp bản đồ
        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file JSON dữ liệu.")
            return

        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            df_rung = pd.DataFrame(json.load(f))
        # Các trường bắt buộc cần có
        required_fields = {"matinh", "tinh", "mahuyen", "huyen","maxa", "xa", "maldlr", "malr3", "dtich"}

        # Kiểm tra xem bản ghi đầu tiên có đủ trường không
        if df_rung.empty or not required_fields.issubset(df_rung.columns):
            QMessageBox.critical(
                self.dockwidget,
                "Thiếu trường dữ liệu",
                f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}"
            )
            return
        self.path_to_dsxa = os.path.join(os.path.dirname(__file__), "data", "dsxa.json")

        if not os.path.exists(self.path_to_dsxa):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file JSON dữ liệu danh sách xã.")
            return
        
        with open(self.path_to_dsxa, "r", encoding="utf-8") as f:
            df_dtn = pd.DataFrame(json.load(f))
        # Bảng thông báo
        self.elapsed_seconds = 0
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
        #progress.show()

        QApplication.processEvents()
        
        # 2. Danh sách huyện trong tỉnh
        if self.dockwidget.ckbox.isChecked():
            ds_huyen = df_rung[df_rung["tinh"] == ten_tinh]["xa"].unique()
            print (ds_huyen)
        else:
            ds_huyen = df_rung[df_rung["tinh"] == ten_tinh]["huyen"].unique()
        
        matinh = df_rung.loc[df_rung["tinh"] == ten_tinh,"matinh"].mode()[0]
        #mahuyen = df_rung.loc[df_rung["huyen"] == ten_huyen, "mahuyen"].mode()[0]
        # Mở tệp mẫu    
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active       
        # Chèn thêm dòng
        ndongchen = 0
        if len(ds_huyen) > 1:
            ndongchen = len(ds_huyen) - 1
   
        # Mở tệp Excel
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active

            # Chèn dòng bắt đầu từ dòng 9
            ws.insert_rows(idx=8, amount=ndongchen)
        else:
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active
            print("Không cần chèn thêm dòng vì chỉ có 1 trạng thái.")
        
        start_row = 7

        # 3. Tổng hợp theo từng huyện

        if self.dockwidget.ckbox.isChecked():
            start_row = 7
            ket_qua = []
            idx = 0
            for xa in ds_huyen:                
                print (xa)
                maxa = df_rung.loc[(df_rung["xa"] == xa)]["maxa"].mode()[0]
                maxa = int(maxa)
                print (maxa)                
                tong_dtn = round(df_dtn[(df_dtn["matinh"] == matinh) & (df_dtn["maxa"] == maxa)]["dtich"].sum(), 2)
                ws[f"A{start_row + idx}"] = idx + 1
                d = df_rung[(df_rung["tinh"] == ten_tinh) & (df_rung["xa"] == xa)]
                ws[f"B{start_row + idx}"] = xa
                ws[f"C{start_row + idx}"] = tong_dtn
                co_rung = round(d[d["maldlr"].isin(list(range(1, 54)))]["dtich"].sum(), 2)
                ws[f"D{start_row + idx}"] = co_rung
                rung_tn = round(d[d["maldlr"].isin(list(range(1, 41)))]["dtich"].sum(), 2)
                ws[f"E{start_row + idx}"] = rung_tn
                rung_trong = round(d[d["maldlr"].isin(list(range(41, 53)))]["dtich"].sum(), 2)
                ws[f"F{start_row + idx}"] = rung_trong
                rung_moi_trong = round(d[d["maldlr"] == 53]["dtich"].sum(), 2)
                ws[f"G{start_row + idx}"] = rung_moi_trong
                trong_qh = round(d[d["maldlr"].isin(list(range(1, 54))) & d["malr3"].isin([1, 2, 3])]["dtich"].sum(), 2)
                ws[f"H{start_row + idx}"] = trong_qh
                dac_dung = round(d[d["maldlr"].isin(list(range(1, 54))) & (d["malr3"] == 2)]["dtich"].sum(), 2)
                ws[f"I{start_row + idx}"] = dac_dung
                phong_ho = round(d[d["maldlr"].isin(list(range(1, 54))) & (d["malr3"] == 1)]["dtich"].sum(), 2)
                ws[f"J{start_row + idx}"] = phong_ho
                san_xuat = round(d[d["maldlr"].isin(list(range(1, 54))) & (d["malr3"] == 3)]["dtich"].sum(), 2)
                ws[f"K{start_row + idx}"] = san_xuat
                ngoai_qh = round(d[d["maldlr"].isin(list(range(1, 54))) & (d["malr3"] == 0)]["dtich"].sum(), 2)
                ws[f"L{start_row + idx}"] = ngoai_qh
                dien_tich_co_rung = d[d["maldlr"].isin(list(range(1, 53)))]["dtich"].sum()
                do_che_phu = round(dien_tich_co_rung * 100 / tong_dtn, 2) if tong_dtn > 0 else 0
                ws[f"M{start_row + idx}"] = do_che_phu
                print (do_che_phu)
                idx += 1
        else:
            start_row = 7
            ket_qua = []
            idx = 0
            for huyen in ds_huyen:    
                mahuyen = df_rung.loc[(df_rung["huyen"] == huyen)]["mahuyen"].mode()[0]
                mahuyen = int(mahuyen)
                tong_dtn = round(df_dtn[(df_dtn["matinh"] == matinh) & (df_dtn["mahuyen"] == mahuyen)]["dtich"].sum(), 2)
                ws[f"A{start_row + idx}"] = idx + 1
                d = df_rung[(df_rung["tinh"] == ten_tinh) & (df_rung["huyen"] == huyen)]
                ws[f"B{start_row + idx}"] = huyen
                print (huyen)
                ws[f"C{start_row + idx}"] = tong_dtn
                co_rung = round(d[d["maldlr"].isin(list(range(1, 54)))]["dtich"].sum(), 2)
                ws[f"D{start_row + idx}"] = co_rung
                rung_tn = round(d[d["maldlr"].isin(list(range(1, 41)))]["dtich"].sum(), 2)
                ws[f"E{start_row + idx}"] = rung_tn
                rung_trong = round(d[d["maldlr"].isin(list(range(41, 53)))]["dtich"].sum(), 2)
                ws[f"F{start_row + idx}"] = rung_trong
                rung_moi_trong = round(d[d["maldlr"] == 53]["dtich"].sum(), 2)
                ws[f"G{start_row + idx}"] = rung_moi_trong
                trong_qh = round(d[d["maldlr"].isin(list(range(1, 54))) & d["malr3"].isin([1, 2, 3])]["dtich"].sum(), 2)
                ws[f"H{start_row + idx}"] = trong_qh
                dac_dung = round(d[d["maldlr"].isin(list(range(1, 54))) & (d["malr3"] == 2)]["dtich"].sum(), 2)
                ws[f"I{start_row + idx}"] = dac_dung
                phong_ho = round(d[d["maldlr"].isin(list(range(1, 54))) & (d["malr3"] == 1)]["dtich"].sum(), 2)
                ws[f"J{start_row + idx}"] = phong_ho
                san_xuat = round(d[d["maldlr"].isin(list(range(1, 54))) & (d["malr3"] == 3)]["dtich"].sum(), 2)
                ws[f"K{start_row + idx}"] = san_xuat
                ngoai_qh = round(d[d["maldlr"].isin(list(range(1, 54))) & (d["malr3"] == 0)]["dtich"].sum(), 2)
                ws[f"L{start_row + idx}"] = ngoai_qh
                dien_tich_co_rung = d[d["maldlr"].isin(list(range(1, 53)))]["dtich"].sum()
                do_che_phu = round(dien_tich_co_rung * 100 / tong_dtn, 2) if tong_dtn > 0 else 0
                ws[f"M{start_row + idx}"] = do_che_phu
                print (do_che_phu)
                idx += 1
                
        # Xử lý toàn tỉnh
        tong_dtn_tinh = round(df_dtn[df_dtn["matinh"] == matinh]["dtich"].sum(), 2)
        d_tinh = df_rung[df_rung["tinh"] == ten_tinh]
        print(f"Tổng diện tích tự nhiên toàn tỉnh: {tong_dtn_tinh}")
        ws[f"B{start_row + ndongchen + 1}"] = 'Tổng toàn tỉnh'
        ws[f"C{start_row + ndongchen + 1}"] = tong_dtn_tinh
        co_rung = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 54)))]['dtich'].sum(), 2)
        ws[f"D{start_row + ndongchen + 1}"] = co_rung
        rung_tn = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 41)))]['dtich'].sum(), 2)
        ws[f"E{start_row + ndongchen + 1}"] = rung_tn
        rung_trong = round(d_tinh[d_tinh["maldlr"].isin(list(range(41, 53)))]['dtich'].sum(), 2)
        ws[f"F{start_row + ndongchen + 1}"] = rung_trong
        rung_moi_trong = round(d_tinh[d_tinh["maldlr"] == 53]['dtich'].sum(), 2)
        ws[f"G{start_row + ndongchen + 1}"] = rung_moi_trong
        trong_qh = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 54))) & d_tinh["malr3"].isin([1, 2, 3])]['dtich'].sum(), 2)
        ws[f"H{start_row + ndongchen + 1}"] = trong_qh
        dac_dung = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 54))) & (d_tinh["malr3"] == 2)]['dtich'].sum(), 2)
        ws[f"I{start_row + ndongchen + 1}"] = dac_dung
        phong_ho = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 54))) & (d_tinh["malr3"] == 1)]['dtich'].sum(), 2)
        ws[f"J{start_row + ndongchen + 1}"] = phong_ho
        san_xuat = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 54))) & (d_tinh["malr3"] == 3)]['dtich'].sum(), 2)
        ws[f"K{start_row + ndongchen + 1}"] = san_xuat
        ngoai_qh = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 54))) & (d_tinh["malr3"] == 0)]['dtich'].sum(), 2)
        ws[f"L{start_row + ndongchen + 1}"] = ngoai_qh
        dien_tich_co_rung = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 53)))]['dtich'].sum(), 2)
        do_che_phu_tinh = round(dien_tich_co_rung * 100 / tong_dtn_tinh, 2) if tong_dtn_tinh > 0 else 0
        ws[f"M{start_row + ndongchen + 1}"] = do_che_phu_tinh

        # Sao chép định dạng từ dòng mẫu 
        #mau_row = start_row + ndongchen  # dòng gốc đã bị đẩy xuống
        for row_offset in range(ndongchen):
            for col in range(1, 14):  # copy theo số cột đang có
                new_cell = ws.cell(row=start_row + row_offset + 1, column=col)
                template_cell = ws.cell(row=7, column=col)

                # Sao chép giá trị format
                if template_cell.has_style:
                    new_cell.font = copy(template_cell.font)
                    new_cell.border = copy(template_cell.border)
                    new_cell.fill = copy(template_cell.fill)
                    new_cell.number_format = copy(template_cell.number_format)
                    new_cell.protection = copy(template_cell.protection)
                    new_cell.alignment = copy(template_cell.alignment)

        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_tinh}"
        ws.merge_cells("A2:M2")
        row_ngay = start_row + ndongchen + 3
        row_ky  = start_row + ndongchen + 4
        ngayky = self.tao_chuoi_ngay()
        ws[f"J{row_ngay}"] = ngayky
        ws.merge_cells(f"J{row_ngay}:L{row_ngay}")
        ws[f"B{row_ky}"] = 'Thủ trưởng đơn vị'
        ws.merge_cells(f"B{row_ky}:D{row_ky}")
        ws[f"J{row_ky}"] = 'Người tổng hợp'
        ws.merge_cells(f"J{row_ky}:L{row_ky}")
        
        from openpyxl.styles import Alignment
        from openpyxl.styles import Font
        
        ws["A2"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"J{row_ngay}"].font = Font(name="Times New Roman", size = 12, italic = True)
        ws[f"J{row_ngay}"].alignment = Alignment(horizontal="center",vertical="center")
        #ws[f"A{row_ky}"] = "Thủ trưởng đơn vị"
        ws[f"B{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"B{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"J{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"J{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        for cell in ws[f"A{start_row + ndongchen + 1}":f"M{start_row + ndongchen + 1}"][0]:
            cell.font = Font(name="Times New Roman", size = 12, bold=True)
        #progress.close()
        
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")
        
#------------ BIỂU 07 TỈNH ----------------------------------------------------------------------
    def tonghopbieu7tinh(self):
        ten_lop = self.dockwidget.cboLayer.currentText()
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        nam_str = self.dockwidget.txtNamdt.text().strip()
        ket_qua ="Biểu 07. " + ten_tinh + ".xlsx"
        
        from datetime import datetime

        nam_hien_tai = datetime.now().year
        if not nam_str.isdigit():
            QMessageBox.warning(self.dockwidget, "Lỗi nhập liệu", "Vui lòng nhập một năm là số nguyên.")
            return

        namdt = int(nam_str)
        nam_hien_tai = datetime.now().year

        # Kiểm tra giới hạn năm
        if namdt < 2015 or namdt > nam_hien_tai:
            QMessageBox.warning(
                self.dockwidget,
                "Năm không hợp lệ",
                f"Năm phải nằm trong khoảng từ 2015 đến {nam_hien_tai}."
            )
            return        
        
        if not ten_lop:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn lớp bản đồ.")
            return

        layer = next((l for l in QgsProject.instance().mapLayers().values() if l.name() == ten_lop), None)
        if not layer:
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy lớp: {ten_lop}")
            return        

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu07.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return
        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        # Đọc dữ liệu từ file JSON đã tạo từ lớp bản đồ
        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file JSON dữ liệu.")
            return

        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            df_rung = pd.DataFrame(json.load(f))
        # Các trường bắt buộc cần có
        required_fields = {"matinh", "tinh", "mahuyen", "huyen","maxa", "xa", "maldlr", "sldlr", "dtich", "captuoi", "namtr"}

        # Kiểm tra xem bản ghi đầu tiên có đủ trường không
        if df_rung.empty or not required_fields.issubset(df_rung.columns):
            QMessageBox.critical(
                self.dockwidget,
                "Thiếu trường dữ liệu",
                f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}"
            )
            return

        # Bảng thông báo
        self.elapsed_seconds = 0
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
        #progress.show()

        QApplication.processEvents()

        ds_maldlr = [41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53]

        # Lọc dữ liệu đầu vào
        df_rung = df_rung[
            df_rung["sldlr"].notna() &
            df_rung["namtr"].notna() &
            df_rung["captuoi"].notna() &
            df_rung["dtich"].notna() &
            df_rung["maldlr"].isin(ds_maldlr)& 
            (df_rung["tinh"] == ten_tinh)
        ]

        # Ép kiểu
        df_rung["namtr"] = pd.to_numeric(df_rung["namtr"], errors="coerce")
        df_rung["captuoi"] = pd.to_numeric(df_rung["captuoi"], errors="coerce")
        df_rung["dtich"] = pd.to_numeric(df_rung["dtich"], errors="coerce")

        # Tính cấp tuổi
        df_rung["so_nam"] = nam_hien_tai - df_rung["namtr"]
        df_rung["cap_tuoi"] = (df_rung["so_nam"] / df_rung["captuoi"]).apply(
            lambda x: int(x) if x <= int(x) else (int(x) + 1 if int(x) + 1 <= 5 else 5)
        )

        # Giới hạn cấp tuổi từ 1 đến 5
        df_rung = df_rung[df_rung["cap_tuoi"].between(1, 5)]

        # Tổng hợp theo loài cây và cấp tuổi
        tonghop = df_rung.groupby(["sldlr", "cap_tuoi"])["dtich"].sum().reset_index()
        tonghop["dtich"] = tonghop["dtich"].round(2)

        # Tùy chọn pivot bảng
        # Bước 1: Pivot bảng
        pivot = tonghop.pivot(index="sldlr", columns="cap_tuoi", values="dtich").fillna(0)
        # Bước 2: Đảm bảo luôn có đủ cột cấp tuổi từ 1 đến 5
        for tuoi in [1, 2, 3, 4, 5]:
            if tuoi not in pivot.columns:
                pivot[tuoi] = 0  # thêm cột thiếu và gán giá trị 0
        # Bước 3: Đưa lại thứ tự cột nếu cần
        pivot = pivot[[1, 2, 3, 4, 5]]
        # Bước 4: Đưa sldlr từ chỉ số về thành cột
        pivot.reset_index(inplace=True)
        # Bước 5: Thêm cột STT ở vị trí đầu
        pivot.insert(0, "STT", range(1, len(pivot) + 1))
        # Bước 6: Tính tổng và chèn cột "Tổng" vào sau "sldlr" (tức vị trí thứ 2)
        pivot.insert(2, "Tổng", pivot.loc[:, [1, 2, 3, 4, 5]].sum(axis=1).round(2))
        # Tính tổng từng cột (bỏ cột STT và sldlr)
        tong_cac_cot = pivot.drop(columns=["STT", "sldlr"]).sum(numeric_only=True).round(2)

        # Tạo dòng mới là một Series
        dong_tong = pd.Series(
            [None, "Tổng cộng"] + tong_cac_cot.tolist(),
            index=pivot.columns
        )

        # Thêm dòng vào cuối bảng
        pivot = pd.concat([pivot, pd.DataFrame([dong_tong])], ignore_index=True)
        so_dong = len(pivot)
        print(pivot)

        
        # Chèn thêm dòng
        ndongchen = 0
        if so_dong > 1:
            ndongchen = so_dong - 1
   
        # Mở tệp Excel
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active

            # Chèn dòng bắt đầu từ dòng 8
            ws.insert_rows(idx=8, amount=ndongchen)
        else:
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active
            print("Không cần chèn thêm dòng vì chỉ có 1 trạng thái.")
        
        # Bỏ header: chuyển pivot sang list các dòng, không bao gồm tên cột
        du_lieu = pivot.values.tolist()

        # Ghi dữ liệu bắt đầu từ dòng 7, cột A (A7)
        start_row = 7
        for i, row_data in enumerate(du_lieu):
            for j, value in enumerate(row_data):
                # openpyxl dùng chỉ số bắt đầu từ 1 → cột = j+1
                ws.cell(row=start_row + i, column=j + 1, value=value)
        # Sao chép định dạng từ dòng mẫu 
        #mau_row = start_row + ndongchen  # dòng gốc đã bị đẩy xuống
        for row_offset in range(ndongchen):
            for col in range(1, 9):  # copy theo số cột đang có
                new_cell = ws.cell(row=start_row + row_offset + 1, column=col)
                template_cell = ws.cell(row=7, column=col)

                # Sao chép giá trị format
                if template_cell.has_style:
                    new_cell.font = copy(template_cell.font)
                    new_cell.border = copy(template_cell.border)
                    new_cell.fill = copy(template_cell.fill)
                    new_cell.number_format = copy(template_cell.number_format)
                    new_cell.protection = copy(template_cell.protection)
                    new_cell.alignment = copy(template_cell.alignment)

        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_tinh}"
        ws.merge_cells("A2:H2")
        row_ngay = start_row + ndongchen + 3
        row_ky  = start_row + ndongchen + 4
        ngayky = self.tao_chuoi_ngay()
        ws[f"F{row_ngay}"] = ngayky
        ws.merge_cells(f"F{row_ngay}:H{row_ngay}")
        ws[f"A{row_ky}"] = 'Thủ trưởng đơn vị'
        ws.merge_cells(f"A{row_ky}:C{row_ky}")
        ws[f"F{row_ky}"] = 'Người tổng hợp'
        ws.merge_cells(f"F{row_ky}:H{row_ky}")
        
        from openpyxl.styles import Alignment
        from openpyxl.styles import Font
        
        ws["A2"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ngay}"].font = Font(name="Times New Roman", size = 12, italic = True)
        ws[f"F{row_ngay}"].alignment = Alignment(horizontal="center",vertical="center")
        #ws[f"A{row_ky}"] = "Thủ trưởng đơn vị"
        ws[f"A{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"A{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"F{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        for cell in ws[f"A{start_row + ndongchen}":f"H{start_row + ndongchen}"][0]:
            cell.font = Font(name="Times New Roman", size = 12, bold=True)       

        #progress.close()
        
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")        

#------------ BIỂU 08 TỈNH ----------------------------------------------------------------------
    def tonghopbieu8tinh(self):
        ten_lop = self.dockwidget.cboLayer.currentText()
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        nam_str = self.dockwidget.txtNamdt.text().strip()
        ket_qua ="Biểu 08. " + ten_tinh + ".xlsx"
        
        from datetime import datetime

        nam_hien_tai = datetime.now().year
        if not nam_str.isdigit():
            QMessageBox.warning(self.dockwidget, "Lỗi nhập liệu", "Vui lòng nhập một năm là số nguyên.")
            return

        namdt = int(nam_str)
        nam_hien_tai = datetime.now().year

        # Kiểm tra giới hạn năm
        if namdt < 2015 or namdt > nam_hien_tai:
            QMessageBox.warning(
                self.dockwidget,
                "Năm không hợp lệ",
                f"Năm phải nằm trong khoảng từ 2015 đến {nam_hien_tai}."
            )
            return        
        
        if not ten_lop:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn lớp bản đồ.")
            return

        layer = next((l for l in QgsProject.instance().mapLayers().values() if l.name() == ten_lop), None)
        if not layer:
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy lớp: {ten_lop}")
            return        

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu08.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return
        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        # Đọc dữ liệu từ file JSON đã tạo từ lớp bản đồ
        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file JSON dữ liệu.")
            return

        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            df_rung = pd.DataFrame(json.load(f))
        # Các trường bắt buộc cần có
        required_fields = {"matinh", "tinh", "mahuyen", "huyen","maxa", "xa", "maldlr", "sldlr", "mgolo", "mtnlo", "captuoi", "namtr"}

        # Kiểm tra xem bản ghi đầu tiên có đủ trường không
        if df_rung.empty or not required_fields.issubset(df_rung.columns):
            QMessageBox.critical(
                self.dockwidget,
                "Thiếu trường dữ liệu",
                f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}"
            )
            return

        # Bảng thông báo
        self.elapsed_seconds = 0
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
        #progress.show()

        #QApplication.processEvents()

        ds_maldlr = [41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53]

        # Lọc dữ liệu hợp lệ
        df_rung = df_rung[
            df_rung["sldlr"].notna() &
            df_rung["namtr"].notna() &
            df_rung["captuoi"].notna() &
            df_rung["mgolo"].notna() &
            df_rung["mtnlo"].notna() &
            df_rung["maldlr"].isin(ds_maldlr) &
            (df_rung["tinh"] == ten_tinh)
        ]

        # Ép kiểu số
        for col in ["namtr", "captuoi", "mgolo", "mtnlo"]:
            df_rung[col] = pd.to_numeric(df_rung[col], errors="coerce")

        # Tính cấp tuổi
        df_rung["so_nam"] = nam_hien_tai - df_rung["namtr"]
        df_rung["cap_tuoi"] = (df_rung["so_nam"] / df_rung["captuoi"]).apply(
            lambda x: int(x) if x <= int(x) else (int(x) + 1 if int(x) + 1 <= 5 else 5)
        )

        # Giới hạn cấp tuổi 1–5
        df_rung = df_rung[df_rung["cap_tuoi"].between(1, 5)]

        # Tính trữ lượng = mgolo + mtnlo
        df_rung["truluong"] = df_rung["mgolo"] + df_rung["mtnlo"]

        # Tổng hợp theo loài cây và cấp tuổi
        tonghop_truluong = df_rung.groupby(["sldlr", "cap_tuoi"])["truluong"].sum().reset_index()
        tonghop_truluong["truluong"] = tonghop_truluong["truluong"].round(2)

        # Pivot bảng
        pivot = tonghop_truluong.pivot(index="sldlr", columns="cap_tuoi", values="truluong").fillna(0)
        # Đảm bảo luôn có đủ cột cấp tuổi từ 1 đến 5
        for tuoi in [1, 2, 3, 4, 5]:
            if tuoi not in pivot.columns:
                pivot[tuoi] = 0  # thêm cột thiếu và gán giá trị 0
        # Đưa lại thứ tự
        pivot = pivot[[1, 2, 3, 4, 5]]
        # Thêm cột STT
        pivot.reset_index(inplace=True)
        pivot.insert(0, "STT", range(1, len(pivot) + 1))

        # Thêm cột Tổng (tổng theo dòng)
        pivot.insert(2, "Tổng", pivot.loc[:, [1, 2, 3, 4, 5]].sum(axis=1).round(2))

        # Thêm dòng Tổng cộng cuối cùng
        tong_cac_cot = pivot.drop(columns=["STT", "sldlr"]).sum(numeric_only=True).round(2)
        dong_tong = pd.Series(
            [None, "Tổng cộng"] + tong_cac_cot.tolist(),
            index=pivot.columns
        )
        pivot = pd.concat([pivot, pd.DataFrame([dong_tong])], ignore_index=True)
        so_dong = len(pivot)
        print(pivot)

        
        # Chèn thêm dòng
        ndongchen = 0
        if so_dong > 1:
            ndongchen = so_dong - 1
   
        # Mở tệp Excel
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active

            # Chèn dòng bắt đầu từ dòng 8
            ws.insert_rows(idx=8, amount=ndongchen)
        else:
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active
            print("Không cần chèn thêm dòng vì chỉ có 1 trạng thái.")
        
        # Bỏ header: chuyển pivot sang list các dòng, không bao gồm tên cột
        du_lieu = pivot.values.tolist()

        # Ghi dữ liệu bắt đầu từ dòng 7, cột A (A7)
        start_row = 7
        for i, row_data in enumerate(du_lieu):
            for j, value in enumerate(row_data):
                # openpyxl dùng chỉ số bắt đầu từ 1 → cột = j+1
                ws.cell(row=start_row + i, column=j + 1, value=value)
        # Sao chép định dạng từ dòng mẫu 
        #mau_row = start_row + ndongchen  # dòng gốc đã bị đẩy xuống
        for row_offset in range(ndongchen):
            for col in range(1, 9):  # copy theo số cột đang có
                new_cell = ws.cell(row=start_row + row_offset + 1, column=col)
                template_cell = ws.cell(row=7, column=col)

                # Sao chép giá trị format
                if template_cell.has_style:
                    new_cell.font = copy(template_cell.font)
                    new_cell.border = copy(template_cell.border)
                    new_cell.fill = copy(template_cell.fill)
                    new_cell.number_format = copy(template_cell.number_format)
                    new_cell.protection = copy(template_cell.protection)
                    new_cell.alignment = copy(template_cell.alignment)

        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_tinh}"
        ws.merge_cells("A2:H2")
        row_ngay = start_row + ndongchen + 3
        row_ky  = start_row + ndongchen + 4
        ngayky = self.tao_chuoi_ngay()
        ws[f"F{row_ngay}"] = ngayky
        ws.merge_cells(f"F{row_ngay}:H{row_ngay}")
        ws[f"A{row_ky}"] = 'Thủ trưởng đơn vị'
        ws.merge_cells(f"A{row_ky}:C{row_ky}")
        ws[f"F{row_ky}"] = 'Người tổng hợp'
        ws.merge_cells(f"F{row_ky}:H{row_ky}")
        
        from openpyxl.styles import Alignment
        from openpyxl.styles import Font
        
        ws["A2"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ngay}"].font = Font(name="Times New Roman", size = 12, italic = True)
        ws[f"F{row_ngay}"].alignment = Alignment(horizontal="center",vertical="center")
        #ws[f"A{row_ky}"] = "Thủ trưởng đơn vị"
        ws[f"A{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"A{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"F{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        for cell in ws[f"A{start_row + ndongchen}":f"H{start_row + ndongchen}"][0]:
            cell.font = Font(name="Times New Roman", size = 12, bold=True)       

        #progress.close()
        
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")        

#------------ BIỂU 09 TỈNH ----------------------------------------------------------------------
    def tonghopbieu9tinh(self):
        ten_lop = self.dockwidget.cboLayer.currentText()
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        nam_str = self.dockwidget.txtNamdt.text().strip()
        ket_qua ="Biểu 09. " + ten_tinh + ".xlsx"
        
        from datetime import datetime

        nam_hien_tai = datetime.now().year
        if not nam_str.isdigit():
            QMessageBox.warning(self.dockwidget, "Lỗi nhập liệu", "Vui lòng nhập một năm là số nguyên.")
            return

        namdt = int(nam_str)
        nam_hien_tai = datetime.now().year

        # Kiểm tra giới hạn năm
        if namdt < 2015 or namdt > nam_hien_tai:
            QMessageBox.warning(
                self.dockwidget,
                "Năm không hợp lệ",
                f"Năm phải nằm trong khoảng từ 2015 đến {nam_hien_tai}."
            )
            return        
        
        if not ten_lop:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn lớp bản đồ.")
            return

        layer = next((l for l in QgsProject.instance().mapLayers().values() if l.name() == ten_lop), None)
        if not layer:
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy lớp: {ten_lop}")
            return        

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu09.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return
        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        # Đọc dữ liệu từ file JSON đã tạo từ lớp bản đồ
        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file JSON dữ liệu.")
            return

        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            df_rung = pd.DataFrame(json.load(f))
        # Các trường bắt buộc cần có
        required_fields = {"matinh", "tinh", "mahuyen", "huyen","maxa", "xa", "maldlr", "sldlr", "mcolo", "captuoi", "namtr"}

        # Kiểm tra xem bản ghi đầu tiên có đủ trường không
        if df_rung.empty or not required_fields.issubset(df_rung.columns):
            QMessageBox.critical(
                self.dockwidget,
                "Thiếu trường dữ liệu",
                f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}"
            )
            return

        # Bảng thông báo
        self.elapsed_seconds = 0
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
        #progress.show()

        QApplication.processEvents()

        ds_maldlr = [41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53]

        # Lọc dữ liệu đầu vào
        df_rung = df_rung[
            df_rung["sldlr"].notna() &
            df_rung["namtr"].notna() &
            df_rung["captuoi"].notna() &
            df_rung["mcolo"].notna() &
            df_rung["maldlr"].isin(ds_maldlr)& 
            (df_rung["tinh"] == ten_tinh)
        ]

        # Ép kiểu
        df_rung["namtr"] = pd.to_numeric(df_rung["namtr"], errors="coerce")
        df_rung["captuoi"] = pd.to_numeric(df_rung["captuoi"], errors="coerce")
        df_rung["mcolo"] = pd.to_numeric(df_rung["mcolo"], errors="coerce")

        # Tính cấp tuổi
        df_rung["so_nam"] = nam_hien_tai - df_rung["namtr"]
        df_rung["cap_tuoi"] = (df_rung["so_nam"] / df_rung["captuoi"]).apply(
            lambda x: int(x) if x <= int(x) else (int(x) + 1 if int(x) + 1 <= 5 else 5)
        )

        # Giới hạn cấp tuổi từ 1 đến 5
        df_rung = df_rung[df_rung["cap_tuoi"].between(1, 5)]

        # Tổng hợp theo loài cây và cấp tuổi
        tonghop = df_rung.groupby(["sldlr", "cap_tuoi"])["mcolo"].sum().reset_index()
        tonghop["mcolo"] = tonghop["mcolo"].round(2)

        # Tùy chọn pivot bảng
        # Bước 1: Pivot bảng
        pivot = tonghop.pivot(index="sldlr", columns="cap_tuoi", values="mcolo").fillna(0)
        # Bước 2: Đảm bảo luôn có đủ cột cấp tuổi từ 1 đến 5
        for tuoi in [1, 2, 3, 4, 5]:
            if tuoi not in pivot.columns:
                pivot[tuoi] = 0  # thêm cột thiếu và gán giá trị 0

        # Bước 3: Đưa lại thứ tự cột nếu cần
        pivot = pivot[[1, 2, 3, 4, 5]]
        # Bước 4: Đưa sldlr từ chỉ số về thành cột
        pivot.reset_index(inplace=True)

        # Bước 5: Thêm cột STT ở vị trí đầu
        pivot.insert(0, "STT", range(1, len(pivot) + 1))

        # Bước 6: Tính tổng và chèn cột "Tổng" vào sau "sldlr" (tức vị trí thứ 2)
        
        pivot.insert(2, "Tổng", pivot.loc[:, [1, 2, 3, 4, 5]].sum(axis=1).round(2))
        # Tính tổng từng cột (bỏ cột STT và sldlr)
        tong_cac_cot = pivot.drop(columns=["STT", "sldlr"]).sum(numeric_only=True).round(2)

        # Tạo dòng mới là một Series
        dong_tong = pd.Series(
            [None, "Tổng cộng"] + tong_cac_cot.tolist(),
            index=pivot.columns
        )

        # Thêm dòng vào cuối bảng
        pivot = pd.concat([pivot, pd.DataFrame([dong_tong])], ignore_index=True)
        so_dong = len(pivot)
        print(pivot)

        
        # Chèn thêm dòng
        ndongchen = 0
        if so_dong > 1:
            ndongchen = so_dong - 1
   
        # Mở tệp Excel
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active

            # Chèn dòng bắt đầu từ dòng 8
            ws.insert_rows(idx=8, amount=ndongchen)
        else:
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active
            print("Không cần chèn thêm dòng vì chỉ có 1 trạng thái.")
        
        # Bỏ header: chuyển pivot sang list các dòng, không bao gồm tên cột
        du_lieu = pivot.values.tolist()

        # Ghi dữ liệu bắt đầu từ dòng 7, cột A (A7)
        start_row = 7
        for i, row_data in enumerate(du_lieu):
            for j, value in enumerate(row_data):
                # openpyxl dùng chỉ số bắt đầu từ 1 → cột = j+1
                ws.cell(row=start_row + i, column=j + 1, value=value)
        # Sao chép định dạng từ dòng mẫu 
        #mau_row = start_row + ndongchen  # dòng gốc đã bị đẩy xuống
        for row_offset in range(ndongchen):
            for col in range(1, 9):  # copy theo số cột đang có
                new_cell = ws.cell(row=start_row + row_offset + 1, column=col)
                template_cell = ws.cell(row=7, column=col)

                # Sao chép giá trị format
                if template_cell.has_style:
                    new_cell.font = copy(template_cell.font)
                    new_cell.border = copy(template_cell.border)
                    new_cell.fill = copy(template_cell.fill)
                    new_cell.number_format = copy(template_cell.number_format)
                    new_cell.protection = copy(template_cell.protection)
                    new_cell.alignment = copy(template_cell.alignment)

        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_tinh}"
        ws.merge_cells("A2:H2")
        row_ngay = start_row + ndongchen + 3
        row_ky  = start_row + ndongchen + 4
        ngayky = self.tao_chuoi_ngay()
        ws[f"F{row_ngay}"] = ngayky
        ws.merge_cells(f"F{row_ngay}:H{row_ngay}")
        ws[f"A{row_ky}"] = 'Thủ trưởng đơn vị'
        ws.merge_cells(f"A{row_ky}:C{row_ky}")
        ws[f"F{row_ky}"] = 'Người tổng hợp'
        ws.merge_cells(f"F{row_ky}:H{row_ky}")
        
        from openpyxl.styles import Alignment
        from openpyxl.styles import Font
        
        ws["A2"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ngay}"].font = Font(name="Times New Roman", size = 12, italic = True)
        ws[f"F{row_ngay}"].alignment = Alignment(horizontal="center",vertical="center")
        #ws[f"A{row_ky}"] = "Thủ trưởng đơn vị"
        ws[f"A{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"A{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"F{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        for cell in ws[f"A{start_row + ndongchen}":f"H{start_row + ndongchen}"][0]:
            cell.font = Font(name="Times New Roman", size = 12, bold=True)       

        #progress.close()
        
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")                
#------------ BIỂU 10 TỈNH ----------------------------------------------------------------------
    def tonghopbieu10tinh(self):
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ket_qua = f"Biểu 10. {ten_tinh}.xlsx"

        if not ten_tinh:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn tỉnh.")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu10.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return

        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file dữ liệu JSON.")
            return

        # Mở file Excel
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active

        # Đọc dữ liệu từ file JSON
        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)

        required_fields = {"tinh", "maldlr", "mgolo", "mtnlo", "mcolo", "dtich", "malr3"}
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(self.dockwidget, "Thiếu trường", f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}")
            return
        # Bảng thông báo
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
        #progress.show()
        #QApplication.processEvents()
        
        # Hàm tính tổng theo điều kiện
        def tong_tinh2(maldlr_vals, malr3_filter):
            return float(round(sum(
                Decimal(str(round(row["dtich"], 2)))
                for row in data
                if row.get("tinh") == ten_tinh
                and row.get("maldlr") in maldlr_vals
                and isinstance(row.get("dtich"), (int, float)) and (
                    (isinstance(malr3_filter, int) and row.get("malr3") == malr3_filter) or
                    (isinstance(malr3_filter, tuple) and row.get("malr3") not in malr3_filter)
                )
            ), 2))
        # ====== GHI KẾT QUẢ VÀO EXCEL ========
    # Rừng theo nguồn gốc
        # Rừng tự nhiên 
        maldlr_list = list(range(1, 41))
        n_row = 7
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng trồng 
        maldlr_list = list(range(41, 53))
        n_row = 8
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
    # Rừng theo điều kiện lập địa
        # Rừng trên núi đất
        maldlr_list = sorted(set(range(4, 24)) | {1, 33, 35, 37, 41, 47, 49})
        n_row = 10
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch           
        # Rừng trên núi đá
        maldlr_list = sorted(set(range(24, 29)) | {2, 34, 36, 38, 42, 48, 50})
        n_row = 11
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch  
        # Rừng trên đất ngập nước
        maldlr_list = [3, 29, 30, 31, 39, 43, 44, 45, 51]
        n_row = 12
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng trên cát
        maldlr_list = [32, 40, 46, 52]
        n_row = 13
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
    # Rừng tự nhiên phân theo loài cây
        # Rừng gỗ
        maldlr_list = list(range(1, 33))
        n_row = 15
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng tre nứa
        maldlr_list = [33, 34]
        n_row = 16
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng hỗn giao gỗ và tre nứa
        maldlr_list = [35, 36]
        n_row = 17
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng cau dừa
        maldlr_list = [37, 38, 39, 40]
        n_row = 18
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        
        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_tinh}"
        ws.merge_cells("A2:G2")
        ngayky = self.tao_chuoi_ngay()
        ws["E20"] = ngayky
        ws.merge_cells("E20:G20")
        #progress.close()
        
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")         
#------------ BIỂU 11 TỈNH ----------------------------------------------------------------------
    def tonghopbieu11tinh(self):
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ket_qua = f"Biểu 11. {ten_tinh}.xlsx"

        if not ten_tinh:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn tỉnh.")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu11.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return

        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file dữ liệu JSON.")
            return

        # Mở file Excel
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active

        # Đọc dữ liệu từ file JSON
        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)

        required_fields = {"tinh", "maldlr", "mgolo", "mtnlo", "mcolo", "dtich", "malr3"}
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(self.dockwidget, "Thiếu trường", f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}")
            return
        # Bảng thông báo
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
        #progress.show()
        QApplication.processEvents()
        # Hàm tính tổng theo điều kiện
        def tong_tinh2(maldlr_vals, malr3_filter):
            return float(round(sum(
                Decimal(str(round(row.get("mgolo", 0), 2) + round(row.get("mtnlo", 0), 3)))
                for row in data
                if row.get("tinh") == ten_tinh
                and row.get("maldlr") in maldlr_vals
                and isinstance(row.get("mgolo"), (int, float))
                and isinstance(row.get("mtnlo"), (int, float)) and (
                    (isinstance(malr3_filter, int) and row.get("malr3") == malr3_filter) or
                    (isinstance(malr3_filter, tuple) and row.get("malr3") not in malr3_filter)
                )
            ), 2))
        # ====== GHI KẾT QUẢ VÀO EXCEL ========
    # Rừng theo nguồn gốc
        # Rừng tự nhiên 
        maldlr_list = list(range(1, 41))
        n_row = 7
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng trồng 
        maldlr_list = list(range(41, 53))
        n_row = 8
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
    # Rừng theo điều kiện lập địa
        # Rừng trên núi đất
        maldlr_list = sorted(set(range(4, 24)) | {1, 33, 35, 37, 41, 47, 49})
        n_row = 10
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch           
        # Rừng trên núi đá
        maldlr_list = sorted(set(range(24, 29)) | {2, 34, 36, 38, 42, 48, 50})
        n_row = 11
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch  
        # Rừng trên đất ngập nước
        maldlr_list = [3, 29, 30, 31, 39, 43, 44, 45, 51]
        n_row = 12
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng trên cát
        maldlr_list = [32, 40, 46, 52]
        n_row = 13
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
    # Rừng tự nhiên phân theo loài cây
        # Rừng gỗ
        maldlr_list = list(range(1, 33))
        n_row = 15
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng tre nứa
        maldlr_list = [33, 34]
        n_row = 16
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng hỗn giao gỗ và tre nứa
        maldlr_list = [35, 36]
        n_row = 17
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng cau dừa
        maldlr_list = [37, 38, 39, 40]
        n_row = 18
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        
        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_tinh}"
        ws.merge_cells("A2:G2")        
        ngayky = self.tao_chuoi_ngay()
        ws["E20"] = ngayky
        ws.merge_cells("E20:G20")        
        #progress.close()
        
        try:
            wb.save(path_save)
           # QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")  
#------------ BIỂU 12 TỈNH ----------------------------------------------------------------------
    def tonghopbieu12tinh(self):
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ket_qua = f"Biểu 12. {ten_tinh}.xlsx"

        if not ten_tinh:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn tỉnh.")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu12.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return

        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file dữ liệu JSON.")
            return

        # Mở file Excel
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active

        # Đọc dữ liệu từ file JSON
        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)

        required_fields = {"tinh", "maldlr", "mgolo", "mtnlo", "mcolo", "dtich", "malr3"}
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(self.dockwidget, "Thiếu trường", f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}")
            return

        # Bảng thông báo
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
        #progress.show()
        #QApplication.processEvents()
        
        # Hàm tính tổng theo điều kiện
        def tong_tinh2(maldlr_vals, malr3_filter):
            return float(round(sum(
                Decimal(str(round(row["mcolo"], 2)))
                for row in data
                if row.get("tinh") == ten_tinh
                and row.get("maldlr") in maldlr_vals
                and isinstance(row.get("mcolo"), (int, float)) and (
                    (isinstance(malr3_filter, int) and row.get("malr3") == malr3_filter) or
                    (isinstance(malr3_filter, tuple) and row.get("malr3") not in malr3_filter)
                )
            ), 2))
        # ====== GHI KẾT QUẢ VÀO EXCEL ========
    # Rừng theo nguồn gốc
        # Rừng tự nhiên 
        maldlr_list = list(range(1, 41))
        n_row = 7
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng trồng 
        maldlr_list = list(range(41, 53))
        n_row = 8
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
    # Rừng theo điều kiện lập địa
        # Rừng trên núi đất
        maldlr_list = sorted(set(range(4, 24)) | {1, 33, 35, 37, 41, 47, 49})
        n_row = 10
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch           
        # Rừng trên núi đá
        maldlr_list = sorted(set(range(24, 29)) | {2, 34, 36, 38, 42, 48, 50})
        n_row = 11
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch  
        # Rừng trên đất ngập nước
        maldlr_list = [3, 29, 30, 31, 39, 43, 44, 45, 51]
        n_row = 12
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng trên cát
        maldlr_list = [32, 40, 46, 52]
        n_row = 13
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
    # Rừng tự nhiên phân theo loài cây
        # Rừng gỗ
        maldlr_list = list(range(1, 33))
        n_row = 15
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng tre nứa
        maldlr_list = [33, 34]
        n_row = 16
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng hỗn giao gỗ và tre nứa
        maldlr_list = [35, 36]
        n_row = 17
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng cau dừa
        maldlr_list = [37, 38, 39, 40]
        n_row = 18
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        
        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_tinh}"
        ws.merge_cells("A2:G2")        
        ngayky = self.tao_chuoi_ngay()
        ws["E20"] = ngayky
        ws.merge_cells("E20:G20")        
        #progress.close()
        
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")

####### CẤP HUYỆN ########
# ------------ BIỂU 01 HUYỆN ---------------------------------------------------------------------------        
    def tonghopbieu1huyen(self):
        
        ten_lop = self.dockwidget.cboLayer.currentText()
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ten_huyen_kq = f"{ten_huyen} - {ten_tinh}"
        ten_xa = self.dockwidget.cboXa.currentText()
        ket_qua ="Biểu 01. " + ten_huyen_kq + ".xlsx"
        if not ten_lop:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn lớp bản đồ.")
            return

        layer = next((l for l in QgsProject.instance().mapLayers().values() if l.name() == ten_lop), None)
        if not layer:
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy lớp: {ten_lop}")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu01.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return
        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        # Đọc dữ liệu từ file JSON đã tạo từ lớp bản đồ
        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file JSON dữ liệu.")
            return

        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)
        # Các trường bắt buộc cần có
        required_fields = {"tinh", "ldlr", "mgo", "mtn", "nggocr"}

        # Kiểm tra xem bản ghi đầu tiên có đủ trường không
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(
                self.dockwidget,
                "Thiếu trường dữ liệu",
                f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}"
            )
            return
        # Bảng thông báo
        progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        progress.setWindowTitle("Đang tổng hợp số liệu...")
        progress.setWindowModality(Qt.ApplicationModal)
        progress.setCancelButton(None)
        progress.show()
        QApplication.processEvents()        
        # Lọc dữ liệu theo tỉnh và điều kiện
        filtered = [
            row for row in data
            if row.get("tinh") == ten_tinh
            and row.get("huyen") == ten_huyen
            and isinstance(row.get("nggocr"), (int, float))
            and 0 < row["nggocr"] < 3
            and row.get("ldlr")  # Trạng thái rừng không rỗng
        ]

        if not filtered:
            QMessageBox.warning(self.dockwidget, "Không có dữ liệu", "Không có dữ liệu phù hợp với điều kiện lọc.")
            progress.close()
            return

        df = pd.DataFrame(filtered)

        # Chỉ lấy các cột cần thiết nếu chưa có
        df = df[["ldlr", "mgo", "mtn"]]
        # Nhân cột mtn với 1000 trước khi tính trung bình (Tính số cây)
        df["mtn"] = df["mtn"] * 1000
        # Tính toán giá trị trung bình mgo, mtn
        
        summary = df.groupby("ldlr")[["mgo","mtn"]].mean().reset_index()
        summary.columns = ["Trạng thái","Trữ lượng gỗ","Trữ lượng tre nứa"]
        ntrangthai = df["ldlr"].nunique()
        ndongchen = ntrangthai - 2
        print(summary)
        # Mở tệp mẫu    
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active
        
        # Chèn thêm dòng
        start_row = 5
        ws.insert_rows(idx=6, amount = ndongchen)
       
        # Ghi dữ liệu vào từng dòng
        
        for idx, row in summary.iterrows():
            ws[f"A{start_row + idx}"] = idx + 1
            ws[f"B{start_row + idx}"] = row["Trạng thái"]
            ws[f"C{start_row + idx}"] = round(row["Trữ lượng gỗ"], 2)
            ws[f"D{start_row + idx}"] = round(row["Trữ lượng tre nứa"], 2)
        
        # Bước 2: Sao chép định dạng từ dòng mẫu (dòng gốc trước khi chèn, ở đây là dòng 4 + so_dong_chen)
        mau_row = start_row + ndongchen  # dòng gốc đã bị đẩy xuống
        for row_offset in range(ndongchen):
            for col in range(1, 6):  # copy theo số cột đang có
                new_cell = ws.cell(row=start_row + row_offset + 1, column=col)
                template_cell = ws.cell(row=5, column=col)

                # Sao chép giá trị format
                if template_cell.has_style:
                    new_cell.font = copy(template_cell.font)
                    new_cell.border = copy(template_cell.border)
                    new_cell.fill = copy(template_cell.fill)
                    new_cell.number_format = copy(template_cell.number_format)
                    new_cell.protection = copy(template_cell.protection)
                    new_cell.alignment = copy(template_cell.alignment)
        
        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:E2")
        row_ngay = start_row + ndongchen + 3
        row_ky  = start_row + ndongchen + 4
        ngayky = self.tao_chuoi_ngay()
        ws[f"D{row_ngay}"] = ngayky
        ws.merge_cells(f"D{row_ngay}:E{row_ngay}")
        ws.merge_cells(f"A{row_ky}:B{row_ky}")
        ws.merge_cells(f"D{row_ky}:E{row_ky}")
        
        from openpyxl.styles import Alignment
        from openpyxl.styles import Font
        
        ws["A2"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"D{row_ngay}"].font = Font(name="Times New Roman", size = 12, italic = True)
        ws[f"D{row_ngay}"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"A{row_ky}"] = "Thủ trưởng đơn vị"
        ws[f"A{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"A{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"D{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"D{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        
        progress.close()
        try:
            wb.save(path_save)
            QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")

# ------------ BIỂU 2 HUYỆN --------------------------------------------------------------------------        
    def tonghopbieu2huyen(self):
        
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ten_huyen_kq = f"{ten_huyen} - {ten_tinh}"
        ket_qua = f"Biểu 02. {ten_huyen_kq}.xlsx"

        if not ten_tinh:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn tỉnh.")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu02.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return

        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file dữ liệu JSON.")
            return

        # Mở file Excel
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active

        # Đọc dữ liệu từ file JSON
        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)

        required_fields = {"tinh", "nggocr", "maldlr", "mamdsd", "dtich", "malr3"}
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(self.dockwidget, "Thiếu trường", f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}")
            return

        # Bảng thông báo
        self.elapsed_seconds = 0
        progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        progress.setWindowTitle("Đang tổng hợp số liệu...")
        progress.setWindowModality(Qt.ApplicationModal)
        progress.setCancelButton(None)
        progress.show()
        timer = QTimer()
        timer.timeout.connect(lambda: self._update_elapsed_time(progress))
        timer.start(1000)
        QApplication.processEvents()
        
        # Hàm tính tổng theo điều kiện
        def tong_tinh2(nggocr_val, maldlr_val, mamdsd_val, malr3_val):
            return float(round(sum(
                Decimal(str(round(row["dtich"], 2)))
                for row in data
                if row.get("tinh") == ten_tinh
                and row.get("huyen") == ten_huyen
                and row.get("nggocr") == nggocr_val
                and row.get("maldlr") == maldlr_val
                and (row.get("mamdsd") in mamdsd_val and row.get("malr3") == malr3_val)
                and isinstance(row.get("dtich"), (int, float))
            ), 2))
        # ====== GHI KẾT QUẢ VÀO EXCEL ========
        # Rừng tự nhiên - Nguyên Sinh
            # Rừng nguyên sinh núi đất
        n_row = 11
        ws[f"E{n_row}"] = tong_tinh2(1, 1, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, 1, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, 1, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, 1, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, 1, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, 1, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, 1, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, 1, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, 1, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, 1, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, 1, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, 1, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nguyên sinh núi đá
        n_row = 12
        ws[f"E{n_row}"] = tong_tinh2(1, 2, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, 2, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, 2, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, 2, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, 2, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, 2, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, 2, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, 2, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, 2, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, 2, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, 2, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, 2, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nguyên sinh ngập nước
        n_row = 13
        ws[f"E{n_row}"] = tong_tinh2(1, 3, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, 3, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, 3, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, 3, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, 3, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, 3, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, 3, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, 3, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, 3, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, 3, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, 3, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, 3, [0, 15], 0) # Ngoài quy hoạch
# Rừng tự nhiên - Thứ sinh
# ----- Rừng lá rộng thường xanh và nửa rụng lá ------
    # Rừng giàu - TXG
        n_row = 18
        ma_ldlr = 4
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - TXB
        n_row = 19
        ma_ldlr = 5
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng nghèo - TXN
        n_row = 20
        ma_ldlr = 6
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng nghèo kiệt - TXK
        n_row = 21
        ma_ldlr = 7
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - TXP
        n_row = 22
        ma_ldlr = 8
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
# ----- Rừng lá rộng rụng lá ------
    # Rừng giàu - RLG
        n_row = 24
        ma_ldlr = 9
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - RLB
        n_row = 25
        ma_ldlr = 10
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - RLN
        n_row = 26
        ma_ldlr = 11
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - RLK
        n_row = 27
        ma_ldlr = 12
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - RLP
        n_row = 28
        ma_ldlr = 13
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng lá kim ------
    # Rừng giàu - LKG
        n_row = 30
        ma_ldlr = 14
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - LKB
        n_row = 31
        ma_ldlr = 15
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - LKN
        n_row = 32
        ma_ldlr = 16
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - LKK
        n_row = 33
        ma_ldlr = 17
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - LKP
        n_row = 34
        ma_ldlr = 18
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng hỗn giao cây lá rộng và lá kim ------
    # Rừng giàu - RKG
        n_row = 36
        ma_ldlr = 19
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - RKB
        n_row = 37
        ma_ldlr = 20
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - RKN
        n_row = 38
        ma_ldlr = 21
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - RKK
        n_row = 39
        ma_ldlr = 22
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - RKP
        n_row = 40
        ma_ldlr = 23
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng núi đá ------
    # Rừng giàu - TXDG
        n_row = 42
        ma_ldlr = 24
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - TXDB
        n_row = 43
        ma_ldlr = 25
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - TXDN
        n_row = 44
        ma_ldlr = 26
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - TXDK
        n_row = 45
        ma_ldlr = 27
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - TXDP
        n_row = 46
        ma_ldlr = 28
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng ngập nước ------
    # Rừng ngập mặn - RNM
        n_row = 48
        ma_ldlr = 29
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng ngập phèn - RNP
        n_row = 49
        ma_ldlr = 30
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng ngập ngọt - RNN
        n_row = 50
        ma_ldlr = 31
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng trên cát ------
    # Rừng trên cát - RTNC
        n_row = 51
        ma_ldlr = 32
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch 
# ----- Rừng tre nứa ------
    # Rừng tre nứa núi đất - TN
        n_row = 53
        ma_ldlr = 33
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng tre nứa núi đá - TND
        n_row = 54
        ma_ldlr = 34
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng hỗn giao gỗ và tre nứa ------
    # Rừng hỗn giao gỗ và tre nứa núi đất - HG
        n_row = 56
        ma_ldlr = 35
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng hỗn giao gỗ và tre nứa núi đá - HGD
        n_row = 57
        ma_ldlr = 36
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng cau dừa ------
    # Rừng cau dừa núi đất - CD
        n_row = 59
        ma_ldlr = 37
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa núi đá - CDD
        n_row = 60
        ma_ldlr = 38
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa ngập nước- CDN
        n_row = 61
        ma_ldlr = 39
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trên cát - CDC
        n_row = 62
        ma_ldlr = 40
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ====== RỪNG TRỒNG ===========
# Rừng gỗ (loài cây, cấp tuổi, nguồn gốc)
    # Rừng gỗ trồng núi đất - TG
        n_row = 65
        ma_ldlr = 41
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng núi đá - TGD
        n_row = 66
        ma_ldlr = 42
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập ngọt - TGNN
        n_row = 67
        ma_ldlr = 43
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập mặn - TGNM
        n_row = 68
        ma_ldlr = 44
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập phèn - TGNP
        n_row = 69
        ma_ldlr = 45
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng trên cát - TGC
        n_row = 70
        ma_ldlr = 46
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
# Rừng tre nứa
    # Rừng tre nứa trồng núi đất - TTN
        n_row = 72
        ma_ldlr = 47
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng tre nứa trồng núi đá - TTND
        n_row = 73
        ma_ldlr = 48
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# Rừng cau dừa
    # Rừng cau dừa trồng núi đất - TCD
        n_row = 75
        ma_ldlr = 49
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng núi đá - TCDD
        n_row = 76
        ma_ldlr = 50
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng ngập nước - TCDN
        n_row = 77
        ma_ldlr = 51
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng trên cát - TCDC
        n_row = 78
        ma_ldlr = 52
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ==== DIỆN TÍCH CHƯA CÓ RỪNG =====
    # Diện tích đã trồng cây rừng nhưng chưa đạt các tiêu chí thành rừng - DTR
        n_row = 80
        ma_ldlr = 53
        ws[f"E{n_row}"] = tong_tinh2(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch    
    # Diện tích có cây tái sinh - DTS
        n_row = 81
        ma_ldlr = 54
        ws[f"E{n_row}"] = tong_tinh2(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Diện tích khác - DTK
        n_row = 82
        ma_ldlr = 55
        ws[f"E{n_row}"] = tong_tinh2(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch

        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:Q2")
        ngayky = self.tao_chuoi_ngay()
        ws["M84"] = ngayky
        ws.merge_cells("M84:Q84")
        # Định dạng số liệu
        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                cell.number_format = '#,##0.00'  # 2 chữ số sau dấu phẩy + phân cách hàng nghìn
        custom_format = '#,##0.00;-#,##0.00;"-"'  # hai chữ số thập phân, 0 hiển thị là "-"

        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                if isinstance(cell.value, (int, float)):
                    cell.number_format = custom_format
                    
        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                if cell.data_type == 'f':  # là ô công thức
                    cell.number_format = '#,##0.00;-#,##0.00;"-"'
        timer.stop()
        progress.close()
        wb.properties.calcMode = 'auto'
        try:
            wb.save(path_save)
            QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")

# ------------ BIỂU 3 HUYỆN --------------------------------------------------------------------------        
    def tonghopbieu3huyen(self):
        
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ten_huyen_kq = f"{ten_huyen} - {ten_tinh}"
        ket_qua = f"Biểu 03. {ten_huyen_kq}.xlsx"

        if not ten_tinh:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn tỉnh.")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu03.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return

        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file dữ liệu JSON.")
            return

        # Mở file Excel
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active



        # Đọc dữ liệu từ file JSON
        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)

        required_fields = {"tinh", "nggocr", "maldlr", "mamdsd", "mgo", "mtn", "malr3"}
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(self.dockwidget, "Thiếu trường", f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}")
            return
        # Bảng thông báo
        self.elapsed_seconds = 0
        progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        progress.setWindowTitle("Đang tổng hợp số liệu...")
        progress.setWindowModality(Qt.ApplicationModal)
        progress.setCancelButton(None)
        progress.show()
        timer = QTimer()
        timer.timeout.connect(lambda: self._update_elapsed_time(progress))
        timer.start(1000)
        QApplication.processEvents()
        # Hàm tính tổng theo điều kiện
        def tong_mgo_tinh3(nggocr_val, maldlr_val, mamdsd_val, malr3_val):
            return float(round(sum(
                Decimal(str(round(row["mgolo"], 2)))
                for row in data
                if row.get("tinh") == ten_tinh
                and row.get("huyen") == ten_huyen
                and row.get("nggocr") == nggocr_val
                and row.get("maldlr") == maldlr_val
                and (row.get("mamdsd") in mamdsd_val and row.get("malr3") == malr3_val)
                and isinstance(row.get("mgolo"), (int, float))
            ), 2))
        def tong_mtn_tinh3(nggocr_val, maldlr_val, mamdsd_val, malr3_val):
            return float(round(sum(
                Decimal(str(round(row["mtnlo"], 2)))
                for row in data
                if row.get("tinh") == ten_tinh
                and row.get("huyen") == ten_huyen
                and row.get("nggocr") == nggocr_val
                and row.get("maldlr") == maldlr_val
                and (row.get("mamdsd") in mamdsd_val and row.get("malr3") == malr3_val)
                and isinstance(row.get("mtnlo"), (int, float))
            ), 2))
        # ====== GHI KẾT QUẢ VÀO EXCEL ========
        # Rừng tự nhiên - Nguyên Sinh
            # Rừng nguyên sinh núi đất
        n_row = 11
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, 1, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, 1, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, 1, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, 1, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, 1, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, 1, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, 1, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, 1, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, 1, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, 1, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, 1, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, 1, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nguyên sinh núi đá
        n_row = 12
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, 2, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, 2, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, 2, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, 2, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, 2, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, 2, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, 2, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, 2, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, 2, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, 2, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, 2, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, 2, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nguyên sinh ngập nước
        n_row = 13
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, 3, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, 3, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, 3, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, 3, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, 3, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, 3, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, 3, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, 3, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, 3, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, 3, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, 3, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, 3, [0, 15], 0) # Ngoài quy hoạch
# Rừng tự nhiên - Thứ sinh
# ----- Rừng lá rộng thường xanh và nửa rụng lá ------
    # Rừng giàu - TXG
        n_row = 18
        ma_ldlr = 4
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - TXB
        n_row = 19
        ma_ldlr = 5
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng nghèo - TXN
        n_row = 20
        ma_ldlr = 6
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng nghèo kiệt - TXK
        n_row = 21
        ma_ldlr = 7
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - TXP
        n_row = 22
        ma_ldlr = 8
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
# ----- Rừng lá rộng rụng lá ------
    # Rừng giàu - RLG
        n_row = 24
        ma_ldlr = 9
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - RLB
        n_row = 25
        ma_ldlr = 10
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - RLN
        n_row = 26
        ma_ldlr = 11
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - RLK
        n_row = 27
        ma_ldlr = 12
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - RLP
        n_row = 28
        ma_ldlr = 13
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng lá kim ------
    # Rừng giàu - LKG
        n_row = 30
        ma_ldlr = 14
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - LKB
        n_row = 31
        ma_ldlr = 15
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - LKN
        n_row = 32
        ma_ldlr = 16
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - LKK
        n_row = 33
        ma_ldlr = 17
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - LKP
        n_row = 34
        ma_ldlr = 18
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng hỗn giao cây lá rộng và lá kim ------
    # Rừng giàu - RKG
        n_row = 36
        ma_ldlr = 19
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - RKB
        n_row = 37
        ma_ldlr = 20
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - RKN
        n_row = 38
        ma_ldlr = 21
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - RKK
        n_row = 39
        ma_ldlr = 22
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - RKP
        n_row = 40
        ma_ldlr = 23
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng núi đá ------
    # Rừng giàu - TXDG
        n_row = 42
        ma_ldlr = 24
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - TXDB
        n_row = 43
        ma_ldlr = 25
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - TXDN
        n_row = 44
        ma_ldlr = 26
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - TXDK
        n_row = 45
        ma_ldlr = 27
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - TXDP
        n_row = 46
        ma_ldlr = 28
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng ngập nước ------
    # Rừng ngập mặn - RNM
        n_row = 48
        ma_ldlr = 29
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng ngập phèn - RNP
        n_row = 49
        ma_ldlr = 30
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng ngập ngọt - RNN
        n_row = 50
        ma_ldlr = 31
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng trên cát ------
    # Rừng trên cát - RTNC
        n_row = 51
        ma_ldlr = 32
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch 
# ----- Rừng tre nứa ------
    # Rừng tre nứa núi đất - TN
        n_row = 53
        ma_ldlr = 33
        ws[f"E{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng tre nứa núi đá - TND
        n_row = 54
        ma_ldlr = 34
        ws[f"E{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng hỗn giao gỗ và tre nứa ------
    # Rừng hỗn giao gỗ và tre nứa núi đất - HG
        n_row = 56
        ma_ldlr = 35
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) + tong_mtn_tinh3(1, ma_ldlr, [1], 2)# Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) + tong_mtn_tinh3(1, ma_ldlr, [2], 2)# Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) + tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) + tong_mtn_tinh3(1, ma_ldlr, [4], 2)# Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) + tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2)# Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) + tong_mtn_tinh3(1, ma_ldlr, [8], 1)# Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) + tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) + tong_mtn_tinh3(1, ma_ldlr, [10], 1)# Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) + tong_mtn_tinh3(1, ma_ldlr, [11], 1)# Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) + tong_mtn_tinh3(1, ma_ldlr, [12], 1)# Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) + tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3)# Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) + tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0)# Ngoài quy hoạch
    # Rừng hỗn giao gỗ và tre nứa núi đá - HGD
        n_row = 57
        ma_ldlr = 36
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) + tong_mtn_tinh3(1, ma_ldlr, [1], 2)# Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) + tong_mtn_tinh3(1, ma_ldlr, [2], 2)# Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) + tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) + tong_mtn_tinh3(1, ma_ldlr, [4], 2)# Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) + tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2)# Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) + tong_mtn_tinh3(1, ma_ldlr, [8], 1)# Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) + tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) + tong_mtn_tinh3(1, ma_ldlr, [10], 1)# Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) + tong_mtn_tinh3(1, ma_ldlr, [11], 1)# Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) + tong_mtn_tinh3(1, ma_ldlr, [12], 1)# Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) + tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3)# Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) + tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0)# Ngoài quy hoạch
# ----- Rừng cau dừa ------
    # Rừng cau dừa núi đất - CD
        n_row = 59
        ma_ldlr = 37
        ws[f"E{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa núi đá - CDD
        n_row = 60
        ma_ldlr = 38
        ws[f"E{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa ngập nước- CDN
        n_row = 61
        ma_ldlr = 39
        ws[f"E{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trên cát - CDC
        n_row = 62
        ma_ldlr = 40
        ws[f"E{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ====== RỪNG TRỒNG ===========
# Rừng gỗ (loài cây, cấp tuổi, nguồn gốc)
    # Rừng gỗ trồng núi đất - TG
        n_row = 65
        ma_ldlr = 41
        ws[f"E{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng núi đá - TGD
        n_row = 66
        ma_ldlr = 42
        ws[f"E{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập ngọt - TGNN
        n_row = 67
        ma_ldlr = 43
        ws[f"E{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập mặn - TGNM
        n_row = 68
        ma_ldlr = 44
        ws[f"E{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập phèn - TGNP
        n_row = 69
        ma_ldlr = 45
        ws[f"E{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng trên cát - TGC
        n_row = 70
        ma_ldlr = 46
        ws[f"E{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
# Rừng tre nứa
    # Rừng tre nứa trồng núi đất - TTN
        n_row = 72
        ma_ldlr = 47
        ws[f"E{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng tre nứa trồng núi đá - TTND
        n_row = 73
        ma_ldlr = 48
        ws[f"E{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# Rừng cau dừa
    # Rừng cau dừa trồng núi đất - TCD
        n_row = 75
        ma_ldlr = 49
        ws[f"E{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng núi đá - TCDD
        n_row = 76
        ma_ldlr = 50
        ws[f"E{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng ngập nước - TCDN
        n_row = 77
        ma_ldlr = 51
        ws[f"E{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng trên cát - TCDC
        n_row = 78
        ma_ldlr = 52
        ws[f"E{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ==== DIỆN TÍCH CHƯA CÓ RỪNG =====
    # Diện tích đã trồng cây rừng nhưng chưa đạt các tiêu chí thành rừng - DTR
        n_row = 80
        ma_ldlr = 53
        ws[f"E{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch    
    # Diện tích có cây tái sinh - DTS
        n_row = 81
        ma_ldlr = 54
        ws[f"E{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Diện tích khác - DTK
        n_row = 82
        ma_ldlr = 55
        ws[f"E{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch

        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:Q2")
        ngayky = self.tao_chuoi_ngay()
        ws["M84"] = ngayky
        ws.merge_cells("M84:Q84")       
        
        # Định dạng số liệu
        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                cell.number_format = '#,##0.00'  # 2 chữ số sau dấu phẩy + phân cách hàng nghìn
        custom_format = '#,##0.00;-#,##0.00;"-"'  # hai chữ số thập phân, 0 hiển thị là "-"

        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                if isinstance(cell.value, (int, float)):
                    cell.number_format = custom_format
                    
        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                if cell.data_type == 'f':  # là ô công thức
                    cell.number_format = '#,##0.00;-#,##0.00;"-"'
        timer.stop()
        progress.close()
        wb.properties.calcMode = 'auto'
        
        try:
            wb.save(path_save)
            QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")

# ----------- BIỂU 04 HUYỆN --------------------------------------------------------------------------
    def tonghopbieu4huyen(self):
        
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ten_huyen_kq = f"{ten_huyen} - {ten_tinh}"
        ket_qua = f"Biểu 04. {ten_huyen_kq}.xlsx"

        if not ten_tinh:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn tỉnh.")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu04.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return

        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file dữ liệu JSON.")
            return

        # Mở file Excel
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active

        # Đọc dữ liệu từ file JSON
        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)

        required_fields = {"tinh", "nggocr", "maldlr", "mamdsd", "dtich", "malr3"}
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(self.dockwidget, "Thiếu trường", f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}")
            return
        # Bảng thông báo
        self.elapsed_seconds = 0
        progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        progress.setWindowTitle("Đang tổng hợp số liệu...")
        progress.setWindowModality(Qt.ApplicationModal)
        progress.setCancelButton(None)
        progress.show()
        timer = QTimer()
        timer.timeout.connect(lambda: self._update_elapsed_time(progress))
        timer.start(1000)
        QApplication.processEvents()
        # Hàm tính tổng theo điều kiện
        def tong_mcolo_tinh4(nggocr_val, maldlr_val, mamdsd_val, malr3_val):
            return float(round(sum(
                Decimal(str(round(row["mcolo"], 2)))
                for row in data
                if row.get("tinh") == ten_tinh
                and row.get("huyen") == ten_huyen
                and row.get("nggocr") == nggocr_val
                and row.get("maldlr") == maldlr_val
                and (row.get("mamdsd") in mamdsd_val and row.get("malr3") == malr3_val)
                and isinstance(row.get("mcolo"), (int, float))
            ), 2))
        # ====== GHI KẾT QUẢ VÀO EXCEL ========
        # Rừng tự nhiên - Nguyên Sinh
            # Rừng nguyên sinh núi đất
        n_row = 11
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, 1, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, 1, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, 1, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, 1, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, 1, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, 1, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, 1, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, 1, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, 1, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, 1, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, 1, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, 1, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nguyên sinh núi đá
        n_row = 12
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, 2, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, 2, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, 2, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, 2, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, 2, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, 2, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, 2, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, 2, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, 2, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, 2, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, 2, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, 2, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nguyên sinh ngập nước
        n_row = 13
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, 3, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, 3, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, 3, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, 3, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, 3, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, 3, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, 3, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, 3, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, 3, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, 3, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, 3, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, 3, [0, 15], 0) # Ngoài quy hoạch
# Rừng tự nhiên - Thứ sinh
# ----- Rừng lá rộng thường xanh và nửa rụng lá ------
    # Rừng giàu - TXG
        n_row = 18
        ma_ldlr = 4
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - TXB
        n_row = 19
        ma_ldlr = 5
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng nghèo - TXN
        n_row = 20
        ma_ldlr = 6
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng nghèo kiệt - TXK
        n_row = 21
        ma_ldlr = 7
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - TXP
        n_row = 22
        ma_ldlr = 8
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
# ----- Rừng lá rộng rụng lá ------
    # Rừng giàu - RLG
        n_row = 24
        ma_ldlr = 9
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - RLB
        n_row = 25
        ma_ldlr = 10
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - RLN
        n_row = 26
        ma_ldlr = 11
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - RLK
        n_row = 27
        ma_ldlr = 12
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - RLP
        n_row = 28
        ma_ldlr = 13
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng lá kim ------
    # Rừng giàu - LKG
        n_row = 30
        ma_ldlr = 14
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - LKB
        n_row = 31
        ma_ldlr = 15
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - LKN
        n_row = 32
        ma_ldlr = 16
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - LKK
        n_row = 33
        ma_ldlr = 17
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - LKP
        n_row = 34
        ma_ldlr = 18
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng hỗn giao cây lá rộng và lá kim ------
    # Rừng giàu - RKG
        n_row = 36
        ma_ldlr = 19
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - RKB
        n_row = 37
        ma_ldlr = 20
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - RKN
        n_row = 38
        ma_ldlr = 21
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - RKK
        n_row = 39
        ma_ldlr = 22
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - RKP
        n_row = 40
        ma_ldlr = 23
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng núi đá ------
    # Rừng giàu - TXDG
        n_row = 42
        ma_ldlr = 24
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - TXDB
        n_row = 43
        ma_ldlr = 25
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - TXDN
        n_row = 44
        ma_ldlr = 26
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - TXDK
        n_row = 45
        ma_ldlr = 27
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - TXDP
        n_row = 46
        ma_ldlr = 28
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng ngập nước ------
    # Rừng ngập mặn - RNM
        n_row = 48
        ma_ldlr = 29
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng ngập phèn - RNP
        n_row = 49
        ma_ldlr = 30
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng ngập ngọt - RNN
        n_row = 50
        ma_ldlr = 31
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng trên cát ------
    # Rừng trên cát - RTNC
        n_row = 51
        ma_ldlr = 32
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch 
# ----- Rừng tre nứa ------
    # Rừng tre nứa núi đất - TN
        n_row = 53
        ma_ldlr = 33
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng tre nứa núi đá - TND
        n_row = 54
        ma_ldlr = 34
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng hỗn giao gỗ và tre nứa ------
    # Rừng hỗn giao gỗ và tre nứa núi đất - HG
        n_row = 56
        ma_ldlr = 35
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng hỗn giao gỗ và tre nứa núi đá - HGD
        n_row = 57
        ma_ldlr = 36
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng cau dừa ------
    # Rừng cau dừa núi đất - CD
        n_row = 59
        ma_ldlr = 37
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa núi đá - CDD
        n_row = 60
        ma_ldlr = 38
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa ngập nước- CDN
        n_row = 61
        ma_ldlr = 39
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trên cát - CDC
        n_row = 62
        ma_ldlr = 40
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ====== RỪNG TRỒNG ===========
# Rừng gỗ (loài cây, cấp tuổi, nguồn gốc)
    # Rừng gỗ trồng núi đất - TG
        n_row = 65
        ma_ldlr = 41
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng núi đá - TGD
        n_row = 66
        ma_ldlr = 42
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập ngọt - TGNN
        n_row = 67
        ma_ldlr = 43
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập mặn - TGNM
        n_row = 68
        ma_ldlr = 44
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập phèn - TGNP
        n_row = 69
        ma_ldlr = 45
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng trên cát - TGC
        n_row = 70
        ma_ldlr = 46
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
# Rừng tre nứa
    # Rừng tre nứa trồng núi đất - TTN
        n_row = 72
        ma_ldlr = 47
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng tre nứa trồng núi đá - TTND
        n_row = 73
        ma_ldlr = 48
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# Rừng cau dừa
    # Rừng cau dừa trồng núi đất - TCD
        n_row = 75
        ma_ldlr = 49
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng núi đá - TCDD
        n_row = 76
        ma_ldlr = 50
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng ngập nước - TCDN
        n_row = 77
        ma_ldlr = 51
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng trên cát - TCDC
        n_row = 78
        ma_ldlr = 52
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ==== DIỆN TÍCH CHƯA CÓ RỪNG =====
    # Diện tích đã trồng cây rừng nhưng chưa đạt các tiêu chí thành rừng - DTR
        n_row = 80
        ma_ldlr = 53
        ws[f"E{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch    
    # Diện tích có cây tái sinh - DTS
        n_row = 81
        ma_ldlr = 54
        ws[f"E{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Diện tích khác - DTK
        n_row = 82
        ma_ldlr = 55
        ws[f"E{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch

        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:Q2")
        ngayky = self.tao_chuoi_ngay()
        ws["M84"] = ngayky
        ws.merge_cells("M84:Q84")       
        
        # Định dạng số liệu
        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                cell.number_format = '#,##0.00'  # 2 chữ số sau dấu phẩy + phân cách hàng nghìn
        custom_format = '#,##0.00;-#,##0.00;"-"'  # hai chữ số thập phân, 0 hiển thị là "-"

        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                if isinstance(cell.value, (int, float)):
                    cell.number_format = custom_format
                    
        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                if cell.data_type == 'f':  # là ô công thức
                    cell.number_format = '#,##0.00;-#,##0.00;"-"'
        timer.stop()
        progress.close()
        wb.properties.calcMode = 'auto'
        
        try:
            wb.save(path_save)
            QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")
#------------ BIỂU 05 HUYỆN ----------------------------------------------------------------------
    def tonghopbieu5huyen(self):
        
        ten_lop = self.dockwidget.cboLayer.currentText()
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ten_huyen_kq = f"{ten_huyen} - {ten_tinh}"
        ket_qua = f"Biểu 05. {ten_huyen_kq}.xlsx"
        if not ten_lop:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn lớp bản đồ.")
            return

        layer = next((l for l in QgsProject.instance().mapLayers().values() if l.name() == ten_lop), None)
        if not layer:
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy lớp: {ten_lop}")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu05.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return
        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        # Đọc dữ liệu từ file JSON đã tạo từ lớp bản đồ
        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file JSON dữ liệu.")
            return

        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)
        # Các trường bắt buộc cần có
        required_fields = {"tinh", "maldlr","sldlr", "non", "vua", "gia", "hvn", "d13"}

        # Kiểm tra xem bản ghi đầu tiên có đủ trường không
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(
                self.dockwidget,
                "Thiếu trường dữ liệu",
                f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}"
            )
            return
        # Bảng thông báo
        progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        progress.setWindowTitle("Đang tổng hợp số liệu...")
        progress.setWindowModality(Qt.ApplicationModal)
        progress.setCancelButton(None)
        progress.show()
        QApplication.processEvents()
        # Lọc dữ liệu theo tỉnh và điều kiện
        filtered = [
            row for row in data
            if row.get("tinh") == ten_tinh
            and row.get("huyen") == ten_huyen
            and isinstance(row.get("maldlr"), (int, float))
            and row.get("maldlr") in [35, 36, 47, 48]
            and row.get("sldlr")  # Trạng thái rừng không rỗng
        ]

        if not filtered:
            QMessageBox.warning(self.dockwidget, "Không có dữ liệu", "Không có dữ liệu phù hợp với điều kiện lọc.")
            progress.close()
            return

        df = pd.DataFrame(filtered)

        # Chỉ lấy các cột cần thiết nếu chưa có
        df = df[["sldlr", "non", "vua", "gia", "hvn", "d13"]]
        
        # Tính toán giá trị trung bình mgo, mtn
        # Gộp dữ liệu theo sldlr
        tong_hop = df.groupby("sldlr").agg({
            "non": "sum",
            "vua": "sum",
            "gia": "sum",
            "hvn": "mean",
            "d13": "mean"
        }).reset_index()
        tong_hop[["non", "vua", "gia"]] = tong_hop[["non", "vua", "gia"]] * 1000
        tong_hop["tongcay"] = tong_hop["non"] + tong_hop["vua"] + tong_hop["gia"]
        # Tùy chọn: Làm tròn
        tong_hop = tong_hop.round({
            "tongcay": 0,
            "non": 0,
            "vua": 0,
            "gia": 0,
            "hvn": 2,
            "d13": 2
        })
        
        print(tong_hop)
        
        # Tổng các cột cần cộng
        tong = tong_hop[["tongcay", "non", "vua", "gia"]].sum()

        # Trung bình các cột cần lấy trung bình
        trung_binh = tong_hop[["hvn", "d13"]].mean()

        # Dòng tổng cộng
        tong_cong = {
            "sldlr": "Tổng cộng",
            "tongcay": tong["tongcay"],
            "non": tong["non"],
            "vua": tong["vua"],
            "gia": tong["gia"],
            "hvn": trung_binh["hvn"],
            "d13": trung_binh["d13"]
        }
        print (tong_cong)
        ntrangthai = df["sldlr"].nunique()
        # Chỉ chèn dòng nếu có nhiều hơn 1 trạng thái
        ndongchen = 0
        if ntrangthai > 1:
            ndongchen = ntrangthai - 1
   
        # Mở tệp Excel
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active

            # Chèn dòng bắt đầu từ dòng 9
            ws.insert_rows(idx=9, amount=ndongchen)
        else:
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active
            print("Không cần chèn thêm dòng vì chỉ có 1 trạng thái.")
       
    # Ghi dữ liệu vào từng dòng
        # Ghi dòng tổng
        giatri_tongcay = tong_cong.get("tongcay", 0)
        giatri_non = tong_cong.get("non", 0)
        giatri_vua = tong_cong.get("vua", 0)
        giatri_gia = tong_cong.get("gia", 0)
        giatri_hvn = tong_cong.get("hvn", 0)
        giatri_d13 = tong_cong.get("d13", 0)
        ws["C7"] = giatri_tongcay
        ws["D7"] = giatri_non
        ws["E7"] = giatri_vua
        ws["F7"] = giatri_gia
        ws["G7"] = giatri_hvn
        ws["H7"] = giatri_d13
        start_row = 8
        for idx, row in tong_hop.iterrows():
            ws[f"A{start_row + idx}"] = idx + 1
            ws[f"B{start_row + idx}"] = row["sldlr"]
            ws[f"C{start_row + idx}"] = round(row["tongcay"], 0)
            ws[f"D{start_row + idx}"] = round(row["non"], 0)
            ws[f"E{start_row + idx}"] = round(row["vua"], 0)
            ws[f"F{start_row + idx}"] = round(row["gia"], 0)
            ws[f"G{start_row + idx}"] = round(row["hvn"], 0)
            ws[f"H{start_row + idx}"] = round(row["d13"], 0)
        
        # Sao chép định dạng từ dòng mẫu 
        mau_row = start_row + ndongchen  # dòng gốc đã bị đẩy xuống
        for row_offset in range(ndongchen):
            for col in range(1, 9):  # copy theo số cột đang có
                new_cell = ws.cell(row=start_row + row_offset + 1, column=col)
                template_cell = ws.cell(row=8, column=col)

                # Sao chép giá trị format
                if template_cell.has_style:
                    new_cell.font = copy(template_cell.font)
                    new_cell.border = copy(template_cell.border)
                    new_cell.fill = copy(template_cell.fill)
                    new_cell.number_format = copy(template_cell.number_format)
                    new_cell.protection = copy(template_cell.protection)
                    new_cell.alignment = copy(template_cell.alignment)
        
        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:H2")
        row_ngay = start_row + ndongchen + 3
        row_ky  = start_row + ndongchen + 4
        ngayky = self.tao_chuoi_ngay()
        ws[f"F{row_ngay}"] = ngayky
        ws.merge_cells(f"F{row_ngay}:H{row_ngay}")
        ws.merge_cells(f"A{row_ky}:C{row_ky}")
        ws.merge_cells(f"F{row_ky}:H{row_ky}")
        
        from openpyxl.styles import Alignment
        from openpyxl.styles import Font
        
        ws["A2"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ngay}"].font = Font(name="Times New Roman", size = 12, italic = True)
        ws[f"F{row_ngay}"].alignment = Alignment(horizontal="center",vertical="center")
        #ws[f"A{row_ky}"] = "Thủ trưởng đơn vị"
        ws[f"A{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"A{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"F{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
		
        progress.close()
		
        try:
            wb.save(path_save)
            QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")       
#------------ BIỂU 06 HUYỆN ----------------------------------------------------------------------
    def tonghopbieu6huyen(self):
        ten_lop = self.dockwidget.cboLayer.currentText()
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ten_huyen_kq = f"{ten_huyen} - {ten_tinh}"
        ket_qua = f"Biểu 06. {ten_huyen_kq}.xlsx"

        if not ten_lop:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn lớp bản đồ.")
            return

        layer = next((l for l in QgsProject.instance().mapLayers().values() if l.name() == ten_lop), None)
        if not layer:
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy lớp: {ten_lop}")
            return        

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu06.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return
        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        # Đọc dữ liệu từ file JSON đã tạo từ lớp bản đồ
        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file JSON dữ liệu.")
            return

        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            df_rung = pd.DataFrame(json.load(f))
        # Các trường bắt buộc cần có
        required_fields = {"matinh", "tinh", "mahuyen", "huyen","maxa", "xa", "maldlr", "malr3", "dtich"}

        # Kiểm tra xem bản ghi đầu tiên có đủ trường không
        if df_rung.empty or not required_fields.issubset(df_rung.columns):
            QMessageBox.critical(
                self.dockwidget,
                "Thiếu trường dữ liệu",
                f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}"
            )
            return
        self.path_to_dsxa = os.path.join(os.path.dirname(__file__), "data", "dsxa.json")

        if not os.path.exists(self.path_to_dsxa):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file JSON dữ liệu danh sách xã.")
            return
        
        with open(self.path_to_dsxa, "r", encoding="utf-8") as f:
            df_dtn = pd.DataFrame(json.load(f))
        
        # Bảng thông báo
        self.elapsed_seconds = 0
        progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        progress.setWindowTitle("Đang tổng hợp số liệu...")
        progress.setWindowModality(Qt.ApplicationModal)
        progress.setCancelButton(None)
        progress.show()

        QApplication.processEvents()
        
        # 2. Danh sách xã trong huyện
        ds_xa = sorted(
            df_rung[
                (df_rung["tinh"] == ten_tinh) &
                (df_rung["huyen"] == ten_huyen)
            ]["xa"].dropna().unique()
        )
        print (f"Danh sách xã: {ds_xa}")
        # Mã huyện trung bình (nếu trùng nhau thì ra đúng mã)
        #mahuyen = df_rung[df_rung["huyen"] == ten_huyen]["mahuyen"].mean()
        mahuyen = df_rung.loc[df_rung["huyen"] == ten_huyen,"mahuyen"].mode()[0]
        mahuyen = int(mahuyen)
        # Mã xã trung bình (nếu cần)
        maxa = df_rung.loc[
            (df_rung["tinh"] == ten_tinh) &
            (df_rung["huyen"] == ten_huyen)
        ]["maxa"].mode()[0]
        maxa=int(maxa)
        # Mở tệp mẫu    
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active       
        # Chèn thêm dòng
        ndongchen = 0
        if len(ds_xa) > 1:
            ndongchen = len(ds_xa) - 1
   
        # Mở tệp Excel
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active

            # Chèn dòng bắt đầu từ dòng 9
            ws.insert_rows(idx=8, amount=ndongchen)
        else:
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active
            print("Không cần chèn thêm dòng vì chỉ có 1 trạng thái.")
        
        start_row = 7

        # 3. Tổng hợp theo từng huyện
        ket_qua = []

        for idx, xa in enumerate(ds_xa):
            maxa = df_rung.loc[(df_rung["xa"] == xa)]["maxa"].mode()[0]         
            tong_dtn = round(df_dtn[(df_dtn["mahuyen"] == mahuyen) & (df_dtn["maxa"] == maxa)]["dtich"].sum(), 2)
            row = start_row + idx
            ws[f"A{row}"] = idx + 1
            d = df_rung[(df_rung["tinh"] == ten_tinh) & (df_rung["huyen"] == ten_huyen) & (df_rung["xa"] == xa)]
            ws[f"B{row}"] = xa
            ws[f"C{row}"] = tong_dtn
            co_rung = round(d[d["maldlr"].isin(list(range(1, 54)))]["dtich"].sum(), 2)
            ws[f"D{row}"] = co_rung
            rung_tn = round(d[d["maldlr"].isin(list(range(1, 41)))]["dtich"].sum(), 2)
            ws[f"E{row}"] = rung_tn
            rung_trong = round(d[d["maldlr"].isin(list(range(41, 53)))]["dtich"].sum(), 2)
            ws[f"F{row}"] = rung_trong
            rung_moi_trong = round(d[d["maldlr"] == 53]["dtich"].sum(), 2)
            ws[f"G{row}"] = rung_moi_trong
            trong_qh = round(d[d["maldlr"].isin(list(range(1, 54))) & d["malr3"].isin([1, 2, 3])]["dtich"].sum(), 2)
            ws[f"H{row}"] = trong_qh
            dac_dung = round(d[d["maldlr"].isin(list(range(1, 54))) & (d["malr3"] == 2)]["dtich"].sum(), 2)
            ws[f"I{row}"] = dac_dung
            phong_ho = round(d[d["maldlr"].isin(list(range(1, 54))) & (d["malr3"] == 1)]["dtich"].sum(), 2)
            ws[f"J{row}"] = phong_ho
            san_xuat = round(d[d["maldlr"].isin(list(range(1, 54))) & (d["malr3"] == 3)]["dtich"].sum(), 2)
            ws[f"K{row}"] = san_xuat
            ngoai_qh = round(d[d["maldlr"].isin(list(range(1, 54))) & (d["malr3"] == 0)]["dtich"].sum(), 2)
            ws[f"L{row}"] = ngoai_qh
            dien_tich_co_rung = d[d["maldlr"].isin(list(range(1, 53)))]["dtich"].sum()
            do_che_phu = round(dien_tich_co_rung * 100 / tong_dtn, 2) if tong_dtn > 0 else 0
            ws[f"M{row}"] = do_che_phu

        
        # Xử lý toàn huyện
        tong_dtn_huyen = round(df_dtn[df_dtn["mahuyen"] == mahuyen]["dtich"].sum(), 2)
        d_tinh = df_rung[df_rung["huyen"] == ten_huyen]
        ws[f"B{start_row + ndongchen + 1}"] = 'Tổng toàn huyện'
        ws[f"C{start_row + ndongchen + 1}"] = tong_dtn_huyen
        co_rung = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 54)))]['dtich'].sum(), 2)
        ws[f"D{start_row + ndongchen + 1}"] = co_rung
        rung_tn = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 41)))]['dtich'].sum(), 2)
        ws[f"E{start_row + ndongchen + 1}"] = rung_tn
        rung_trong = round(d_tinh[d_tinh["maldlr"].isin(list(range(41, 53)))]['dtich'].sum(), 2)
        ws[f"F{start_row + ndongchen + 1}"] = rung_trong
        rung_moi_trong = round(d_tinh[d_tinh["maldlr"] == 53]['dtich'].sum(), 2)
        ws[f"G{start_row + ndongchen + 1}"] = rung_moi_trong
        trong_qh = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 54))) & d_tinh["malr3"].isin([1, 2, 3])]['dtich'].sum(), 2)
        ws[f"H{start_row + ndongchen + 1}"] = trong_qh
        dac_dung = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 54))) & (d_tinh["malr3"] == 2)]['dtich'].sum(), 2)
        ws[f"I{start_row + ndongchen + 1}"] = dac_dung
        phong_ho = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 54))) & (d_tinh["malr3"] == 1)]['dtich'].sum(), 2)
        ws[f"J{start_row + ndongchen + 1}"] = phong_ho
        san_xuat = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 54))) & (d_tinh["malr3"] == 3)]['dtich'].sum(), 2)
        ws[f"K{start_row + ndongchen + 1}"] = san_xuat
        ngoai_qh = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 54))) & (d_tinh["malr3"] == 0)]['dtich'].sum(), 2)
        ws[f"L{start_row + ndongchen + 1}"] = ngoai_qh
        dien_tich_co_rung = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 53)))]['dtich'].sum(), 2)
        do_che_phu_tinh = round(dien_tich_co_rung * 100 / tong_dtn_huyen, 2) if tong_dtn_huyen > 0 else 0
        ws[f"M{start_row + ndongchen + 1}"] = do_che_phu_tinh

        # Sao chép định dạng từ dòng mẫu 
        #mau_row = start_row + ndongchen  # dòng gốc đã bị đẩy xuống
        for row_offset in range(ndongchen):
            for col in range(1, 14):  # copy theo số cột đang có
                new_cell = ws.cell(row=start_row + row_offset + 1, column=col)
                template_cell = ws.cell(row=7, column=col)

                # Sao chép giá trị format
                if template_cell.has_style:
                    new_cell.font = copy(template_cell.font)
                    new_cell.border = copy(template_cell.border)
                    new_cell.fill = copy(template_cell.fill)
                    new_cell.number_format = copy(template_cell.number_format)
                    new_cell.protection = copy(template_cell.protection)
                    new_cell.alignment = copy(template_cell.alignment)

        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:M2")
        row_ngay = start_row + ndongchen + 3
        row_ky  = start_row + ndongchen + 4
        ngayky = self.tao_chuoi_ngay()
        ws[f"J{row_ngay}"] = ngayky
        ws.merge_cells(f"J{row_ngay}:L{row_ngay}")
        ws[f"B{row_ky}"] = 'Thủ trưởng đơn vị'
        ws.merge_cells(f"B{row_ky}:D{row_ky}")
        ws[f"J{row_ky}"] = 'Người tổng hợp'
        ws.merge_cells(f"J{row_ky}:L{row_ky}")
        
        from openpyxl.styles import Alignment
        from openpyxl.styles import Font
        
        ws["A2"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"J{row_ngay}"].font = Font(name="Times New Roman", size = 12, italic = True)
        ws[f"J{row_ngay}"].alignment = Alignment(horizontal="center",vertical="center")
        #ws[f"A{row_ky}"] = "Thủ trưởng đơn vị"
        ws[f"B{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"B{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"J{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"J{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        for cell in ws[f"A{start_row + ndongchen + 1}":f"M{start_row + ndongchen + 1}"][0]:
            cell.font = Font(name="Times New Roman", size = 12, bold=True)
        progress.close()
        
        try:
            wb.save(path_save)
            QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")
        
#------------ BIỂU 07 HUYỆN ----------------------------------------------------------------------
    def tonghopbieu7huyen(self):
        ten_lop = self.dockwidget.cboLayer.currentText()
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        nam_str = self.dockwidget.txtNamdt.text().strip()
        ten_huyen_kq = f"{ten_huyen} - {ten_tinh}"
        ket_qua ="Biểu 07. " + ten_huyen_kq + ".xlsx"
        
        from datetime import datetime

        nam_hien_tai = datetime.now().year
        if not nam_str.isdigit():
            QMessageBox.warning(self.dockwidget, "Lỗi nhập liệu", "Vui lòng nhập một năm là số nguyên.")
            return

        namdt = int(nam_str)
        nam_hien_tai = datetime.now().year

        # Kiểm tra giới hạn năm
        if namdt < 2015 or namdt > nam_hien_tai:
            QMessageBox.warning(
                self.dockwidget,
                "Năm không hợp lệ",
                f"Năm phải nằm trong khoảng từ 2015 đến {nam_hien_tai}."
            )
            return        
        
        if not ten_lop:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn lớp bản đồ.")
            return

        layer = next((l for l in QgsProject.instance().mapLayers().values() if l.name() == ten_lop), None)
        if not layer:
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy lớp: {ten_lop}")
            return        

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu07.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return
        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        # Đọc dữ liệu từ file JSON đã tạo từ lớp bản đồ
        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file JSON dữ liệu.")
            return

        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            df_rung = pd.DataFrame(json.load(f))
        # Các trường bắt buộc cần có
        required_fields = {"matinh", "tinh", "mahuyen", "huyen","maxa", "xa", "maldlr", "sldlr", "dtich", "captuoi", "namtr"}

        # Kiểm tra xem bản ghi đầu tiên có đủ trường không
        if df_rung.empty or not required_fields.issubset(df_rung.columns):
            QMessageBox.critical(
                self.dockwidget,
                "Thiếu trường dữ liệu",
                f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}"
            )
            return

        # Bảng thông báo
        self.elapsed_seconds = 0
        progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        progress.setWindowTitle("Đang tổng hợp số liệu...")
        progress.setWindowModality(Qt.ApplicationModal)
        progress.setCancelButton(None)
        progress.show()

        QApplication.processEvents()

        ds_maldlr = [41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53]

        # Lọc dữ liệu đầu vào
        df_rung = df_rung[
            (df_rung["sldlr"].notna()) &
            (df_rung["namtr"].notna()) &
            (df_rung["captuoi"].notna()) &
            (df_rung["dtich"].notna()) &
            (df_rung["maldlr"].isin(ds_maldlr)) &
            (df_rung["tinh"] == ten_tinh) &
            (df_rung["huyen"] == ten_huyen)
        ]

        # Ép kiểu
        df_rung["namtr"] = pd.to_numeric(df_rung["namtr"], errors="coerce")
        df_rung["captuoi"] = pd.to_numeric(df_rung["captuoi"], errors="coerce")
        df_rung["dtich"] = pd.to_numeric(df_rung["dtich"], errors="coerce")

        # Tính cấp tuổi
        df_rung["so_nam"] = nam_hien_tai - df_rung["namtr"]
        df_rung["cap_tuoi"] = (df_rung["so_nam"] / df_rung["captuoi"]).apply(
            lambda x: int(x) if x <= int(x) else (int(x) + 1 if int(x) + 1 <= 5 else 5)
        )

        # Giới hạn cấp tuổi từ 1 đến 5
        df_rung = df_rung[df_rung["cap_tuoi"].between(1, 5)]

        # Tổng hợp theo loài cây và cấp tuổi
        tonghop = df_rung.groupby(["sldlr", "cap_tuoi"])["dtich"].sum().reset_index()
        tonghop["dtich"] = tonghop["dtich"].round(2)

        # Tùy chọn pivot bảng
        # Bước 1: Pivot bảng
        pivot = tonghop.pivot(index="sldlr", columns="cap_tuoi", values="dtich").fillna(0)
        # Bước 2: Đảm bảo luôn có đủ cột cấp tuổi từ 1 đến 5
        for tuoi in [1, 2, 3, 4, 5]:
            if tuoi not in pivot.columns:
                pivot[tuoi] = 0  # thêm cột thiếu và gán giá trị 0

        # Bước 3: Đưa lại thứ tự cột nếu cần
        pivot = pivot[[1, 2, 3, 4, 5]]
        # Bước 4: Đưa sldlr từ chỉ số về thành cột
        pivot.reset_index(inplace=True)

        # Bước 5: Thêm cột STT ở vị trí đầu
        pivot.insert(0, "STT", range(1, len(pivot) + 1))

        # Bước 6: Tính tổng và chèn cột "Tổng" vào sau "sldlr" (tức vị trí thứ 2)
        # Giả định các cột cấp tuổi là số nguyên 1–5
        pivot.insert(2, "Tổng", pivot.loc[:, [1, 2, 3, 4, 5]].sum(axis=1).round(2))
        # Tính tổng từng cột (bỏ cột STT và sldlr)
        tong_cac_cot = pivot.drop(columns=["STT", "sldlr"]).sum(numeric_only=True).round(2)

        # Tạo dòng mới là một Series
        dong_tong = pd.Series(
            [None, "Tổng cộng"] + tong_cac_cot.tolist(),
            index=pivot.columns
        )

        # Thêm dòng vào cuối bảng
        pivot = pd.concat([pivot, pd.DataFrame([dong_tong])], ignore_index=True)
        so_dong = len(pivot)
        print(pivot)

        
        # Chèn thêm dòng
        ndongchen = 0
        if so_dong > 1:
            ndongchen = so_dong - 1
   
        # Mở tệp Excel
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active

            # Chèn dòng bắt đầu từ dòng 8
            ws.insert_rows(idx=8, amount=ndongchen)
        else:
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active
            print("Không cần chèn thêm dòng vì chỉ có 1 trạng thái.")
        
        # Bỏ header: chuyển pivot sang list các dòng, không bao gồm tên cột
        du_lieu = pivot.values.tolist()

        # Ghi dữ liệu bắt đầu từ dòng 7, cột A (A7)
        start_row = 7
        for i, row_data in enumerate(du_lieu):
            for j, value in enumerate(row_data):
                # openpyxl dùng chỉ số bắt đầu từ 1 → cột = j+1
                ws.cell(row=start_row + i, column=j + 1, value=value)
        # Sao chép định dạng từ dòng mẫu 
        #mau_row = start_row + ndongchen  # dòng gốc đã bị đẩy xuống
        for row_offset in range(ndongchen):
            for col in range(1, 9):  # copy theo số cột đang có
                new_cell = ws.cell(row=start_row + row_offset + 1, column=col)
                template_cell = ws.cell(row=7, column=col)

                # Sao chép giá trị format
                if template_cell.has_style:
                    new_cell.font = copy(template_cell.font)
                    new_cell.border = copy(template_cell.border)
                    new_cell.fill = copy(template_cell.fill)
                    new_cell.number_format = copy(template_cell.number_format)
                    new_cell.protection = copy(template_cell.protection)
                    new_cell.alignment = copy(template_cell.alignment)

        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:H2")
        row_ngay = start_row + ndongchen + 3
        row_ky  = start_row + ndongchen + 4
        ngayky = self.tao_chuoi_ngay()
        ws[f"F{row_ngay}"] = ngayky
        ws.merge_cells(f"F{row_ngay}:H{row_ngay}")
        ws[f"A{row_ky}"] = 'Thủ trưởng đơn vị'
        ws.merge_cells(f"A{row_ky}:C{row_ky}")
        ws[f"F{row_ky}"] = 'Người tổng hợp'
        ws.merge_cells(f"F{row_ky}:H{row_ky}")
        
        from openpyxl.styles import Alignment
        from openpyxl.styles import Font
        
        ws["A2"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ngay}"].font = Font(name="Times New Roman", size = 12, italic = True)
        ws[f"F{row_ngay}"].alignment = Alignment(horizontal="center",vertical="center")
        #ws[f"A{row_ky}"] = "Thủ trưởng đơn vị"
        ws[f"A{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"A{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"F{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        for cell in ws[f"A{start_row + ndongchen}":f"H{start_row + ndongchen}"][0]:
            cell.font = Font(name="Times New Roman", size = 12, bold=True)       

        progress.close()
        
        try:
            wb.save(path_save)
            QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")        

#------------ BIỂU 08 HUYỆN ----------------------------------------------------------------------
    def tonghopbieu8huyen(self):
        ten_lop = self.dockwidget.cboLayer.currentText()
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ten_huyen_kq = f"{ten_huyen} - {ten_tinh}"
        nam_str = self.dockwidget.txtNamdt.text().strip()
        ket_qua ="Biểu 08. " + ten_huyen_kq + ".xlsx"
        
        from datetime import datetime

        nam_hien_tai = datetime.now().year
        if not nam_str.isdigit():
            QMessageBox.warning(self.dockwidget, "Lỗi nhập liệu", "Vui lòng nhập một năm là số nguyên.")
            return

        namdt = int(nam_str)
        nam_hien_tai = datetime.now().year

        # Kiểm tra giới hạn năm
        if namdt < 2015 or namdt > nam_hien_tai:
            QMessageBox.warning(
                self.dockwidget,
                "Năm không hợp lệ",
                f"Năm phải nằm trong khoảng từ 2015 đến {nam_hien_tai}."
            )
            return        
        
        if not ten_lop:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn lớp bản đồ.")
            return

        layer = next((l for l in QgsProject.instance().mapLayers().values() if l.name() == ten_lop), None)
        if not layer:
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy lớp: {ten_lop}")
            return        

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu08.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return
        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        # Đọc dữ liệu từ file JSON đã tạo từ lớp bản đồ
        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file JSON dữ liệu.")
            return

        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            df_rung = pd.DataFrame(json.load(f))
        # Các trường bắt buộc cần có
        required_fields = {"matinh", "tinh", "mahuyen", "huyen","maxa", "xa", "maldlr", "sldlr", "mgolo", "mtnlo", "captuoi", "namtr"}

        # Kiểm tra xem bản ghi đầu tiên có đủ trường không
        if df_rung.empty or not required_fields.issubset(df_rung.columns):
            QMessageBox.critical(
                self.dockwidget,
                "Thiếu trường dữ liệu",
                f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}"
            )
            return

        # Bảng thông báo
        self.elapsed_seconds = 0
        progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        progress.setWindowTitle("Đang tổng hợp số liệu...")
        progress.setWindowModality(Qt.ApplicationModal)
        progress.setCancelButton(None)
        progress.show()

        QApplication.processEvents()

        ds_maldlr = [41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53]

        # Lọc dữ liệu hợp lệ
        df_rung = df_rung[
            (df_rung["sldlr"].notna()) &
            (df_rung["namtr"].notna()) &
            (df_rung["captuoi"].notna()) &
            (df_rung["dtich"].notna()) &
            (df_rung["maldlr"].isin(ds_maldlr)) &
            (df_rung["tinh"] == ten_tinh) &
            (df_rung["huyen"] == ten_huyen)
        ]

        # Ép kiểu số
        for col in ["namtr", "captuoi", "mgolo", "mtnlo"]:
            df_rung[col] = pd.to_numeric(df_rung[col], errors="coerce")

        # Tính cấp tuổi
        df_rung["so_nam"] = nam_hien_tai - df_rung["namtr"]
        df_rung["cap_tuoi"] = (df_rung["so_nam"] / df_rung["captuoi"]).apply(
            lambda x: int(x) if x <= int(x) else (int(x) + 1 if int(x) + 1 <= 5 else 5)
        )

        # Giới hạn cấp tuổi 1–5
        df_rung = df_rung[df_rung["cap_tuoi"].between(1, 5)]

        # Tính trữ lượng = mgolo + mtnlo
        df_rung["truluong"] = df_rung["mgolo"] + df_rung["mtnlo"]

        # Tổng hợp theo loài cây và cấp tuổi
        tonghop_truluong = df_rung.groupby(["sldlr", "cap_tuoi"])["truluong"].sum().reset_index()
        tonghop_truluong["truluong"] = tonghop_truluong["truluong"].round(2)

        # Pivot bảng
        pivot = tonghop_truluong.pivot(index="sldlr", columns="cap_tuoi", values="truluong").fillna(0)
        # BĐảm bảo luôn có đủ cột cấp tuổi từ 1 đến 5
        for tuoi in [1, 2, 3, 4, 5]:
            if tuoi not in pivot.columns:
                pivot[tuoi] = 0  # thêm cột thiếu và gán giá trị 0

        # Đưa lại thứ tự cột
        pivot = pivot[[1, 2, 3, 4, 5]]
        # Thêm cột STT
        pivot.reset_index(inplace=True)
        pivot.insert(0, "STT", range(1, len(pivot) + 1))

        # Thêm cột Tổng (tổng theo dòng)
        pivot.insert(2, "Tổng", pivot.loc[:, [1, 2, 3, 4, 5]].sum(axis=1).round(2))

        # Thêm dòng Tổng cộng cuối cùng
        tong_cac_cot = pivot.drop(columns=["STT", "sldlr"]).sum(numeric_only=True).round(2)
        dong_tong = pd.Series(
            [None, "Tổng cộng"] + tong_cac_cot.tolist(),
            index=pivot.columns
        )
        pivot = pd.concat([pivot, pd.DataFrame([dong_tong])], ignore_index=True)
        so_dong = len(pivot)
        print(pivot)

        
        # Chèn thêm dòng
        ndongchen = 0
        if so_dong > 1:
            ndongchen = so_dong - 1
   
        # Mở tệp Excel
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active

            # Chèn dòng bắt đầu từ dòng 8
            ws.insert_rows(idx=8, amount=ndongchen)
        else:
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active
            print("Không cần chèn thêm dòng vì chỉ có 1 trạng thái.")
        
        # Bỏ header: chuyển pivot sang list các dòng, không bao gồm tên cột
        du_lieu = pivot.values.tolist()

        # Ghi dữ liệu bắt đầu từ dòng 7, cột A (A7)
        start_row = 7
        for i, row_data in enumerate(du_lieu):
            for j, value in enumerate(row_data):
                # openpyxl dùng chỉ số bắt đầu từ 1 → cột = j+1
                ws.cell(row=start_row + i, column=j + 1, value=value)
        # Sao chép định dạng từ dòng mẫu 
        #mau_row = start_row + ndongchen  # dòng gốc đã bị đẩy xuống
        for row_offset in range(ndongchen):
            for col in range(1, 9):  # copy theo số cột đang có
                new_cell = ws.cell(row=start_row + row_offset + 1, column=col)
                template_cell = ws.cell(row=7, column=col)

                # Sao chép giá trị format
                if template_cell.has_style:
                    new_cell.font = copy(template_cell.font)
                    new_cell.border = copy(template_cell.border)
                    new_cell.fill = copy(template_cell.fill)
                    new_cell.number_format = copy(template_cell.number_format)
                    new_cell.protection = copy(template_cell.protection)
                    new_cell.alignment = copy(template_cell.alignment)

        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:H2")
        row_ngay = start_row + ndongchen + 3
        row_ky  = start_row + ndongchen + 4
        ngayky = self.tao_chuoi_ngay()
        ws[f"F{row_ngay}"] = ngayky
        ws.merge_cells(f"F{row_ngay}:H{row_ngay}")
        ws[f"A{row_ky}"] = 'Thủ trưởng đơn vị'
        ws.merge_cells(f"A{row_ky}:C{row_ky}")
        ws[f"F{row_ky}"] = 'Người tổng hợp'
        ws.merge_cells(f"F{row_ky}:H{row_ky}")
        
        from openpyxl.styles import Alignment
        from openpyxl.styles import Font
        
        ws["A2"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ngay}"].font = Font(name="Times New Roman", size = 12, italic = True)
        ws[f"F{row_ngay}"].alignment = Alignment(horizontal="center",vertical="center")
        #ws[f"A{row_ky}"] = "Thủ trưởng đơn vị"
        ws[f"A{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"A{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"F{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        for cell in ws[f"A{start_row + ndongchen}":f"H{start_row + ndongchen}"][0]:
            cell.font = Font(name="Times New Roman", size = 12, bold=True)       

        progress.close()
        
        try:
            wb.save(path_save)
            QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")        

#------------ BIỂU 09 HUYỆN ----------------------------------------------------------------------
    def tonghopbieu9huyen(self):
        ten_lop = self.dockwidget.cboLayer.currentText()
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ten_huyen_kq = f"{ten_huyen} - {ten_tinh}"
        nam_str = self.dockwidget.txtNamdt.text().strip()
        ket_qua ="Biểu 09. " + ten_huyen_kq + ".xlsx"
        
        from datetime import datetime

        nam_hien_tai = datetime.now().year
        if not nam_str.isdigit():
            QMessageBox.warning(self.dockwidget, "Lỗi nhập liệu", "Vui lòng nhập một năm là số nguyên.")
            return

        namdt = int(nam_str)
        nam_hien_tai = datetime.now().year

        # Kiểm tra giới hạn năm
        if namdt < 2015 or namdt > nam_hien_tai:
            QMessageBox.warning(
                self.dockwidget,
                "Năm không hợp lệ",
                f"Năm phải nằm trong khoảng từ 2015 đến {nam_hien_tai}."
            )
            return        
        
        if not ten_lop:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn lớp bản đồ.")
            return

        layer = next((l for l in QgsProject.instance().mapLayers().values() if l.name() == ten_lop), None)
        if not layer:
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy lớp: {ten_lop}")
            return        

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu09.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return
        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        # Đọc dữ liệu từ file JSON đã tạo từ lớp bản đồ
        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file JSON dữ liệu.")
            return

        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            df_rung = pd.DataFrame(json.load(f))
        # Các trường bắt buộc cần có
        required_fields = {"matinh", "tinh", "mahuyen", "huyen","maxa", "xa", "maldlr", "sldlr", "mcolo", "captuoi", "namtr"}

        # Kiểm tra xem bản ghi đầu tiên có đủ trường không
        if df_rung.empty or not required_fields.issubset(df_rung.columns):
            QMessageBox.critical(
                self.dockwidget,
                "Thiếu trường dữ liệu",
                f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}"
            )
            return

        # Bảng thông báo
        self.elapsed_seconds = 0
        progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        progress.setWindowTitle("Đang tổng hợp số liệu...")
        progress.setWindowModality(Qt.ApplicationModal)
        progress.setCancelButton(None)
        progress.show()

        QApplication.processEvents()

        ds_maldlr = [41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53]

        # Lọc dữ liệu đầu vào
        df_rung = df_rung[
            (df_rung["sldlr"].notna()) &
            (df_rung["namtr"].notna()) &
            (df_rung["captuoi"].notna()) &
            (df_rung["dtich"].notna()) &
            (df_rung["maldlr"].isin(ds_maldlr)) &
            (df_rung["tinh"] == ten_tinh) &
            (df_rung["huyen"] == ten_huyen)
        ]

        # Ép kiểu
        df_rung["namtr"] = pd.to_numeric(df_rung["namtr"], errors="coerce")
        df_rung["captuoi"] = pd.to_numeric(df_rung["captuoi"], errors="coerce")
        df_rung["mcolo"] = pd.to_numeric(df_rung["mcolo"], errors="coerce")

        # Tính cấp tuổi
        df_rung["so_nam"] = nam_hien_tai - df_rung["namtr"]
        df_rung["cap_tuoi"] = (df_rung["so_nam"] / df_rung["captuoi"]).apply(
            lambda x: int(x) if x <= int(x) else (int(x) + 1 if int(x) + 1 <= 5 else 5)
        )

        # Giới hạn cấp tuổi từ 1 đến 5
        df_rung = df_rung[df_rung["cap_tuoi"].between(1, 5)]

        # Tổng hợp theo loài cây và cấp tuổi
        tonghop = df_rung.groupby(["sldlr", "cap_tuoi"])["mcolo"].sum().reset_index()
        tonghop["mcolo"] = tonghop["mcolo"].round(2)

        # Tùy chọn pivot bảng
        # Bước 1: Pivot bảng
        pivot = tonghop.pivot(index="sldlr", columns="cap_tuoi", values="mcolo").fillna(0)
        # Bước 2: Đảm bảo luôn có đủ cột cấp tuổi từ 1 đến 5
        for tuoi in [1, 2, 3, 4, 5]:
            if tuoi not in pivot.columns:
                pivot[tuoi] = 0  # thêm cột thiếu và gán giá trị 0

        # Bước 3: Đưa lại thứ tự cột nếu cần
        pivot = pivot[[1, 2, 3, 4, 5]]
        # Bước 4: Đưa sldlr từ chỉ số về thành cột
        pivot.reset_index(inplace=True)

        # Bước 5: Thêm cột STT ở vị trí đầu
        pivot.insert(0, "STT", range(1, len(pivot) + 1))
        # Bước 6: Tính tổng và chèn cột "Tổng" vào sau "sldlr" (tức vị trí thứ 2)
        # Giả định các cột cấp tuổi là số nguyên 1–5
        pivot.insert(2, "Tổng", pivot.loc[:, [1, 2, 3, 4, 5]].sum(axis=1).round(2))
        # Tính tổng từng cột (bỏ cột STT và sldlr)
        tong_cac_cot = pivot.drop(columns=["STT", "sldlr"]).sum(numeric_only=True).round(2)

        # Tạo dòng mới là một Series
        dong_tong = pd.Series(
            [None, "Tổng cộng"] + tong_cac_cot.tolist(),
            index=pivot.columns
        )

        # Thêm dòng vào cuối bảng
        pivot = pd.concat([pivot, pd.DataFrame([dong_tong])], ignore_index=True)
        so_dong = len(pivot)
        print(pivot)

        
        # Chèn thêm dòng
        ndongchen = 0
        if so_dong > 1:
            ndongchen = so_dong - 1
   
        # Mở tệp Excel
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active

            # Chèn dòng bắt đầu từ dòng 8
            ws.insert_rows(idx=8, amount=ndongchen)
        else:
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active
            print("Không cần chèn thêm dòng vì chỉ có 1 trạng thái.")
        
        # Bỏ header: chuyển pivot sang list các dòng, không bao gồm tên cột
        du_lieu = pivot.values.tolist()

        # Ghi dữ liệu bắt đầu từ dòng 7, cột A (A7)
        start_row = 7
        for i, row_data in enumerate(du_lieu):
            for j, value in enumerate(row_data):
                # openpyxl dùng chỉ số bắt đầu từ 1 → cột = j+1
                ws.cell(row=start_row + i, column=j + 1, value=value)
        # Sao chép định dạng từ dòng mẫu 
        #mau_row = start_row + ndongchen  # dòng gốc đã bị đẩy xuống
        for row_offset in range(ndongchen):
            for col in range(1, 9):  # copy theo số cột đang có
                new_cell = ws.cell(row=start_row + row_offset + 1, column=col)
                template_cell = ws.cell(row=7, column=col)

                # Sao chép giá trị format
                if template_cell.has_style:
                    new_cell.font = copy(template_cell.font)
                    new_cell.border = copy(template_cell.border)
                    new_cell.fill = copy(template_cell.fill)
                    new_cell.number_format = copy(template_cell.number_format)
                    new_cell.protection = copy(template_cell.protection)
                    new_cell.alignment = copy(template_cell.alignment)

        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:H2")
        row_ngay = start_row + ndongchen + 3
        row_ky  = start_row + ndongchen + 4
        ngayky = self.tao_chuoi_ngay()
        ws[f"F{row_ngay}"] = ngayky
        ws.merge_cells(f"F{row_ngay}:H{row_ngay}")
        ws[f"A{row_ky}"] = 'Thủ trưởng đơn vị'
        ws.merge_cells(f"A{row_ky}:C{row_ky}")
        ws[f"F{row_ky}"] = 'Người tổng hợp'
        ws.merge_cells(f"F{row_ky}:H{row_ky}")
        
        from openpyxl.styles import Alignment
        from openpyxl.styles import Font
        
        ws["A2"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ngay}"].font = Font(name="Times New Roman", size = 12, italic = True)
        ws[f"F{row_ngay}"].alignment = Alignment(horizontal="center",vertical="center")
        #ws[f"A{row_ky}"] = "Thủ trưởng đơn vị"
        ws[f"A{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"A{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"F{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        for cell in ws[f"A{start_row + ndongchen}":f"H{start_row + ndongchen}"][0]:
            cell.font = Font(name="Times New Roman", size = 12, bold=True)       

        progress.close()
        
        try:
            wb.save(path_save)
            QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")                
#------------ BIỂU 10 HUYỆN ----------------------------------------------------------------------
    def tonghopbieu10huyen(self):
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ten_huyen_kq = f"{ten_huyen} - {ten_tinh}"
        ket_qua = f"Biểu 10. {ten_huyen_kq}.xlsx"

        if not ten_tinh:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn tỉnh.")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu10.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return

        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file dữ liệu JSON.")
            return

        # Mở file Excel
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active

        # Đọc dữ liệu từ file JSON
        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)

        required_fields = {"tinh", "maldlr", "mgolo", "mtnlo", "mcolo", "dtich", "malr3"}
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(self.dockwidget, "Thiếu trường", f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}")
            return
        
        # Bảng thông báo
        progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        progress.setWindowTitle("Đang tổng hợp số liệu...")
        progress.setWindowModality(Qt.ApplicationModal)
        progress.setCancelButton(None)
        progress.show()
        QApplication.processEvents()
        
        # Hàm tính tổng theo điều kiện
        def tong_tinh2(maldlr_vals, malr3_filter):
            return float(round(sum(
                Decimal(str(round(row["dtich"], 2)))
                for row in data
                if row.get("tinh") == ten_tinh
                and row.get("huyen") == ten_huyen
                and row.get("maldlr") in maldlr_vals
                and isinstance(row.get("dtich"), (int, float)) and (
                    (isinstance(malr3_filter, int) and row.get("malr3") == malr3_filter) or
                    (isinstance(malr3_filter, tuple) and row.get("malr3") not in malr3_filter)
                )
            ), 2))
        # ====== GHI KẾT QUẢ VÀO EXCEL ========
    # Rừng theo nguồn gốc
        # Rừng tự nhiên 
        maldlr_list = list(range(1, 41))
        n_row = 7
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng trồng 
        maldlr_list = list(range(41, 53))
        n_row = 8
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
    # Rừng theo điều kiện lập địa
        # Rừng trên núi đất
        maldlr_list = sorted(set(range(4, 24)) | {1, 33, 35, 37, 41, 47, 49})
        n_row = 10
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch           
        # Rừng trên núi đá
        maldlr_list = sorted(set(range(24, 29)) | {2, 34, 36, 38, 42, 48, 50})
        n_row = 11
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch  
        # Rừng trên đất ngập nước
        maldlr_list = [3, 29, 30, 31, 39, 43, 44, 45, 51]
        n_row = 12
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng trên cát
        maldlr_list = [32, 40, 46, 52]
        n_row = 13
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
    # Rừng tự nhiên phân theo loài cây
        # Rừng gỗ
        maldlr_list = list(range(1, 33))
        n_row = 15
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng tre nứa
        maldlr_list = [33, 34]
        n_row = 16
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng hỗn giao gỗ và tre nứa
        maldlr_list = [35, 36]
        n_row = 17
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng cau dừa
        maldlr_list = [37, 38, 39, 40]
        n_row = 18
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        
        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:G2") 
        ngayky = self.tao_chuoi_ngay()
        ws["E20"] = ngayky
        ws.merge_cells("E20:G20")
        progress.close()
        
        try:
            wb.save(path_save)
            QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")         
#------------ BIỂU 11 HUYỆN ----------------------------------------------------------------------
    def tonghopbieu11huyen(self):
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ten_huyen_kq = f"{ten_huyen} - {ten_tinh}"
        ket_qua = f"Biểu 11. {ten_huyen_kq}.xlsx"

        if not ten_tinh:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn tỉnh.")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu11.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return

        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file dữ liệu JSON.")
            return

        # Mở file Excel
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active

        # Đọc dữ liệu từ file JSON
        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)

        required_fields = {"tinh", "maldlr", "mgolo", "mtnlo", "mcolo", "dtich", "malr3"}
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(self.dockwidget, "Thiếu trường", f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}")
            return

        # Bảng thông báo
        progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        progress.setWindowTitle("Đang tổng hợp số liệu...")
        progress.setWindowModality(Qt.ApplicationModal)
        progress.setCancelButton(None)
        progress.show()
        QApplication.processEvents()
        
        # Hàm tính tổng theo điều kiện
        def tong_tinh2(maldlr_vals, malr3_filter):
            return float(round(sum(
                Decimal(str(round(row.get("mgolo", 0), 2) + round(row.get("mtnlo", 0), 3)))
                for row in data
                if row.get("tinh") == ten_tinh
                and row.get("huyen") == ten_huyen
                and row.get("maldlr") in maldlr_vals
                and isinstance(row.get("mgolo"), (int, float))
                and isinstance(row.get("mtnlo"), (int, float)) and (
                    (isinstance(malr3_filter, int) and row.get("malr3") == malr3_filter) or
                    (isinstance(malr3_filter, tuple) and row.get("malr3") not in malr3_filter)
                )
            ), 2))
        # ====== GHI KẾT QUẢ VÀO EXCEL ========
    # Rừng theo nguồn gốc
        # Rừng tự nhiên 
        maldlr_list = list(range(1, 41))
        n_row = 7
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng trồng 
        maldlr_list = list(range(41, 53))
        n_row = 8
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
    # Rừng theo điều kiện lập địa
        # Rừng trên núi đất
        maldlr_list = sorted(set(range(4, 24)) | {1, 33, 35, 37, 41, 47, 49})
        n_row = 10
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch           
        # Rừng trên núi đá
        maldlr_list = sorted(set(range(24, 29)) | {2, 34, 36, 38, 42, 48, 50})
        n_row = 11
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch  
        # Rừng trên đất ngập nước
        maldlr_list = [3, 29, 30, 31, 39, 43, 44, 45, 51]
        n_row = 12
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng trên cát
        maldlr_list = [32, 40, 46, 52]
        n_row = 13
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
    # Rừng tự nhiên phân theo loài cây
        # Rừng gỗ
        maldlr_list = list(range(1, 33))
        n_row = 15
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng tre nứa
        maldlr_list = [33, 34]
        n_row = 16
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng hỗn giao gỗ và tre nứa
        maldlr_list = [35, 36]
        n_row = 17
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng cau dừa
        maldlr_list = [37, 38, 39, 40]
        n_row = 18
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        
        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:G2")
        ngayky = self.tao_chuoi_ngay()
        ws["E20"] = ngayky
        ws.merge_cells("E20:G20")        
        progress.close()
        
        try:
            wb.save(path_save)
            QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")  
#------------ BIỂU 12 HUYỆN ----------------------------------------------------------------------
    def tonghopbieu12huyen(self):
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ten_huyen_kq = f"{ten_huyen} - {ten_tinh}"
        ket_qua = f"Biểu 12. {ten_huyen_kq}.xlsx"

        if not ten_tinh:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn tỉnh.")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu12.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return

        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file dữ liệu JSON.")
            return

        # Mở file Excel
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active

        # Đọc dữ liệu từ file JSON
        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)

        required_fields = {"tinh", "maldlr", "mgolo", "mtnlo", "mcolo", "dtich", "malr3"}
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(self.dockwidget, "Thiếu trường", f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}")
            return

        # Bảng thông báo
        progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        progress.setWindowTitle("Đang tổng hợp số liệu...")
        progress.setWindowModality(Qt.ApplicationModal)
        progress.setCancelButton(None)
        progress.show()
        QApplication.processEvents()
        
        # Hàm tính tổng theo điều kiện
        def tong_tinh2(maldlr_vals, malr3_filter):
            return float(round(sum(
                Decimal(str(round(row["mcolo"], 2)))
                for row in data
                if row.get("tinh") == ten_tinh
                and row.get("huyen") == ten_huyen
                and row.get("maldlr") in maldlr_vals
                and isinstance(row.get("mcolo"), (int, float)) and (
                    (isinstance(malr3_filter, int) and row.get("malr3") == malr3_filter) or
                    (isinstance(malr3_filter, tuple) and row.get("malr3") not in malr3_filter)
                )
            ), 2))
        # ====== GHI KẾT QUẢ VÀO EXCEL ========
    # Rừng theo nguồn gốc
        # Rừng tự nhiên 
        maldlr_list = list(range(1, 41))
        n_row = 7
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng trồng 
        maldlr_list = list(range(41, 53))
        n_row = 8
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
    # Rừng theo điều kiện lập địa
        # Rừng trên núi đất
        maldlr_list = sorted(set(range(4, 24)) | {1, 33, 35, 37, 41, 47, 49})
        n_row = 10
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch           
        # Rừng trên núi đá
        maldlr_list = sorted(set(range(24, 29)) | {2, 34, 36, 38, 42, 48, 50})
        n_row = 11
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch  
        # Rừng trên đất ngập nước
        maldlr_list = [3, 29, 30, 31, 39, 43, 44, 45, 51]
        n_row = 12
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng trên cát
        maldlr_list = [32, 40, 46, 52]
        n_row = 13
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
    # Rừng tự nhiên phân theo loài cây
        # Rừng gỗ
        maldlr_list = list(range(1, 33))
        n_row = 15
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng tre nứa
        maldlr_list = [33, 34]
        n_row = 16
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng hỗn giao gỗ và tre nứa
        maldlr_list = [35, 36]
        n_row = 17
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng cau dừa
        maldlr_list = [37, 38, 39, 40]
        n_row = 18
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        
        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:G2") 
        ngayky = self.tao_chuoi_ngay()
        ws["E20"] = ngayky
        ws.merge_cells("E20:G20")        
        progress.close()
        
        try:
            wb.save(path_save)
            QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")

####### CẤP XÃ ########
# ------------ BIỂU 01 XÃ ---------------------------------------------------------------------------        
    def tonghopbieu1xa(self):        
        ten_lop = self.dockwidget.cboLayer.currentText()
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()      
        ten_xa = self.dockwidget.cboXa.currentText()
        if self.dockwidget.ckbox.isChecked():
            ten_huyen_kq = f"{ten_xa} - {ten_tinh}"
        else:
            ten_huyen_kq = f"{ten_xa} - {ten_huyen} - {ten_tinh}"
        #ten_huyen_kq = f"{ten_xa} - {ten_huyen} - {ten_tinh}"
        ket_qua ="Biểu 01. " + ten_huyen_kq + ".xlsx"
        if not ten_lop:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn lớp bản đồ.")
            return

        layer = next((l for l in QgsProject.instance().mapLayers().values() if l.name() == ten_lop), None)
        if not layer:
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy lớp: {ten_lop}")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu01.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return
        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        # Đọc dữ liệu từ file JSON đã tạo từ lớp bản đồ
        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file JSON dữ liệu.")
            return

        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)
        # Các trường bắt buộc cần có
        required_fields = {"tinh", "ldlr", "mgo", "mtn", "nggocr"}

        # Kiểm tra xem bản ghi đầu tiên có đủ trường không
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(
                self.dockwidget,
                "Thiếu trường dữ liệu",
                f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}"
            )
            return
        # Bảng thông báo
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
        #progress.show()
        #QApplication.processEvents()        
        # Lọc dữ liệu theo tỉnh và điều kiện
        if self.dockwidget.ckbox.isChecked():
            filtered = [
                row for row in data
                if row.get("tinh") == ten_tinh
                and row.get("xa") == ten_xa
                and isinstance(row.get("nggocr"), (int, float))
                and 0 < row["nggocr"] < 3
                and row.get("ldlr")  # Trạng thái rừng không rỗng
            ]
        else:
           filtered = [
                row for row in data
                if row.get("tinh") == ten_tinh
                and row.get("huyen") == ten_huyen
                and row.get("xa") == ten_xa
                and isinstance(row.get("nggocr"), (int, float))
                and 0 < row["nggocr"] < 3
                and row.get("ldlr")  # Trạng thái rừng không rỗng
            ]            
        if not filtered:
            QMessageBox.warning(self.dockwidget, "Không có dữ liệu", "Không có dữ liệu phù hợp với điều kiện lọc.")
            progress.close()
            return

        df = pd.DataFrame(filtered)

        # Chỉ lấy các cột cần thiết nếu chưa có
        df = df[["ldlr", "mgo", "mtn"]]
        #df = df.dropna(subset=["mgo", "mtn"])
        # Nhân cột mtn với 1000 trước khi tính trung bình (Tính số cây)
        df["mtn"] = df["mtn"] * 1000
        # Tính toán giá trị trung bình mgo, mtn
        
        #summary = df.groupby("ldlr")[["mgo","mtn"]].mean(numeric_only=True).reset_index()
        #summary.columns = ["Trạng thái","Trữ lượng gỗ","Trữ lượng tre nứa"]
        summary = (
        df.groupby("ldlr", as_index=False)[["mgo", "mtn"]]
          .mean(numeric_only=True)
          .rename(columns={
              "ldlr": "Trạng thái",
              "mgo": "Trữ lượng gỗ",
              "mtn": "Trữ lượng tre nứa"
          })
        )
        ntrangthai = df["ldlr"].nunique()
        ndongchen = ntrangthai - 2
        print(summary)
        # Mở tệp mẫu    
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active
        
        # Chèn thêm dòng
        start_row = 5
        ws.insert_rows(idx=6, amount = ndongchen)
       
        # Ghi dữ liệu vào từng dòng
        
        for idx, row in summary.iterrows():
            ws[f"A{start_row + idx}"] = idx + 1
            ws[f"B{start_row + idx}"] = row["Trạng thái"]
            ws[f"C{start_row + idx}"] = round(row["Trữ lượng gỗ"], 2)
            ws[f"D{start_row + idx}"] = round(row["Trữ lượng tre nứa"], 2)
        
        # Bước 2: Sao chép định dạng từ dòng mẫu (dòng gốc trước khi chèn, ở đây là dòng 4 + so_dong_chen)
        mau_row = start_row + ndongchen  # dòng gốc đã bị đẩy xuống
        for row_offset in range(ndongchen):
            for col in range(1, 6):  # copy theo số cột đang có
                new_cell = ws.cell(row=start_row + row_offset + 1, column=col)
                template_cell = ws.cell(row=5, column=col)

                # Sao chép giá trị format
                if template_cell.has_style:
                    new_cell.font = copy(template_cell.font)
                    new_cell.border = copy(template_cell.border)
                    new_cell.fill = copy(template_cell.fill)
                    new_cell.number_format = copy(template_cell.number_format)
                    new_cell.protection = copy(template_cell.protection)
                    new_cell.alignment = copy(template_cell.alignment)
        
        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:E2")
        row_ngay = start_row + ndongchen + 3
        row_ky  = start_row + ndongchen + 4
        ngayky = self.tao_chuoi_ngay()
        ws[f"D{row_ngay}"] = ngayky
        ws.merge_cells(f"D{row_ngay}:E{row_ngay}")
        ws.merge_cells(f"A{row_ky}:B{row_ky}")
        ws.merge_cells(f"D{row_ky}:E{row_ky}")
        
        from openpyxl.styles import Alignment
        from openpyxl.styles import Font
        
        ws["A2"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"D{row_ngay}"].font = Font(name="Times New Roman", size = 12, italic = True)
        ws[f"D{row_ngay}"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"A{row_ky}"] = "Thủ trưởng đơn vị"
        ws[f"A{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"A{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"D{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"D{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        
        #progress.close()
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")

# ------------ BIỂU 2 XÃ --------------------------------------------------------------------------        
    def tonghopbieu2xa(self):
        
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ten_xa = self.dockwidget.cboXa.currentText()
        if self.dockwidget.ckbox.isChecked():
            ten_huyen_kq = f"{ten_xa} - {ten_tinh}"
        else:
            ten_huyen_kq = f"{ten_xa} - {ten_huyen} - {ten_tinh}"
        
        ket_qua = f"Biểu 02. {ten_huyen_kq}.xlsx"

        if not ten_tinh:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn tỉnh.")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu02.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return

        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file dữ liệu JSON.")
            return

        # Mở file Excel
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active

        # Đọc dữ liệu từ file JSON
        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)

        required_fields = {"tinh", "nggocr", "maldlr", "mamdsd", "dtich", "malr3"}
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(self.dockwidget, "Thiếu trường", f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}")
            return

        # Bảng thông báo
        self.elapsed_seconds = 0
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
        #progress.show()
        #timer = QTimer()
        #timer.timeout.connect(lambda: self._update_elapsed_time(progress))
        #timer.start(1000)
        #QApplication.processEvents()
        
        # Hàm tính tổng theo điều kiện
        def tong_tinh2(nggocr_val, maldlr_val, mamdsd_val, malr3_val):
            return float(round(sum(
                Decimal(str(round(row["dtich"], 2)))
                for row in data
                if row.get("tinh") == ten_tinh
                and row.get("xa") == ten_xa
                and row.get("nggocr") == nggocr_val
                and row.get("maldlr") == maldlr_val
                and (row.get("mamdsd") in mamdsd_val and row.get("malr3") == malr3_val)
                and isinstance(row.get("dtich"), (int, float))
            ), 2))
        # ====== GHI KẾT QUẢ VÀO EXCEL ========
        # Rừng tự nhiên - Nguyên Sinh
            # Rừng nguyên sinh núi đất
        n_row = 11
        ws[f"E{n_row}"] = tong_tinh2(1, 1, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, 1, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, 1, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, 1, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, 1, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, 1, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, 1, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, 1, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, 1, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, 1, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, 1, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, 1, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nguyên sinh núi đá
        n_row = 12
        ws[f"E{n_row}"] = tong_tinh2(1, 2, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, 2, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, 2, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, 2, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, 2, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, 2, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, 2, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, 2, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, 2, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, 2, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, 2, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, 2, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nguyên sinh ngập nước
        n_row = 13
        ws[f"E{n_row}"] = tong_tinh2(1, 3, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, 3, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, 3, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, 3, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, 3, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, 3, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, 3, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, 3, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, 3, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, 3, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, 3, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, 3, [0, 15], 0) # Ngoài quy hoạch
# Rừng tự nhiên - Thứ sinh
# ----- Rừng lá rộng thường xanh và nửa rụng lá ------
    # Rừng giàu - TXG
        n_row = 18
        ma_ldlr = 4
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - TXB
        n_row = 19
        ma_ldlr = 5
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng nghèo - TXN
        n_row = 20
        ma_ldlr = 6
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng nghèo kiệt - TXK
        n_row = 21
        ma_ldlr = 7
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - TXP
        n_row = 22
        ma_ldlr = 8
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
# ----- Rừng lá rộng rụng lá ------
    # Rừng giàu - RLG
        n_row = 24
        ma_ldlr = 9
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - RLB
        n_row = 25
        ma_ldlr = 10
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - RLN
        n_row = 26
        ma_ldlr = 11
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - RLK
        n_row = 27
        ma_ldlr = 12
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - RLP
        n_row = 28
        ma_ldlr = 13
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng lá kim ------
    # Rừng giàu - LKG
        n_row = 30
        ma_ldlr = 14
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - LKB
        n_row = 31
        ma_ldlr = 15
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - LKN
        n_row = 32
        ma_ldlr = 16
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - LKK
        n_row = 33
        ma_ldlr = 17
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - LKP
        n_row = 34
        ma_ldlr = 18
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng hỗn giao cây lá rộng và lá kim ------
    # Rừng giàu - RKG
        n_row = 36
        ma_ldlr = 19
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - RKB
        n_row = 37
        ma_ldlr = 20
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - RKN
        n_row = 38
        ma_ldlr = 21
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - RKK
        n_row = 39
        ma_ldlr = 22
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - RKP
        n_row = 40
        ma_ldlr = 23
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng núi đá ------
    # Rừng giàu - TXDG
        n_row = 42
        ma_ldlr = 24
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - TXDB
        n_row = 43
        ma_ldlr = 25
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - TXDN
        n_row = 44
        ma_ldlr = 26
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - TXDK
        n_row = 45
        ma_ldlr = 27
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - TXDP
        n_row = 46
        ma_ldlr = 28
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng ngập nước ------
    # Rừng ngập mặn - RNM
        n_row = 48
        ma_ldlr = 29
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng ngập phèn - RNP
        n_row = 49
        ma_ldlr = 30
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng ngập ngọt - RNN
        n_row = 50
        ma_ldlr = 31
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng trên cát ------
    # Rừng trên cát - RTNC
        n_row = 51
        ma_ldlr = 32
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch 
# ----- Rừng tre nứa ------
    # Rừng tre nứa núi đất - TN
        n_row = 53
        ma_ldlr = 33
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng tre nứa núi đá - TND
        n_row = 54
        ma_ldlr = 34
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng hỗn giao gỗ và tre nứa ------
    # Rừng hỗn giao gỗ và tre nứa núi đất - HG
        n_row = 56
        ma_ldlr = 35
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng hỗn giao gỗ và tre nứa núi đá - HGD
        n_row = 57
        ma_ldlr = 36
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng cau dừa ------
    # Rừng cau dừa núi đất - CD
        n_row = 59
        ma_ldlr = 37
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa núi đá - CDD
        n_row = 60
        ma_ldlr = 38
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa ngập nước- CDN
        n_row = 61
        ma_ldlr = 39
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trên cát - CDC
        n_row = 62
        ma_ldlr = 40
        ws[f"E{n_row}"] = tong_tinh2(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ====== RỪNG TRỒNG ===========
# Rừng gỗ (loài cây, cấp tuổi, nguồn gốc)
    # Rừng gỗ trồng núi đất - TG
        n_row = 65
        ma_ldlr = 41
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng núi đá - TGD
        n_row = 66
        ma_ldlr = 42
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập ngọt - TGNN
        n_row = 67
        ma_ldlr = 43
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập mặn - TGNM
        n_row = 68
        ma_ldlr = 44
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập phèn - TGNP
        n_row = 69
        ma_ldlr = 45
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng trên cát - TGC
        n_row = 70
        ma_ldlr = 46
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
# Rừng tre nứa
    # Rừng tre nứa trồng núi đất - TTN
        n_row = 72
        ma_ldlr = 47
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng tre nứa trồng núi đá - TTND
        n_row = 73
        ma_ldlr = 48
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# Rừng cau dừa
    # Rừng cau dừa trồng núi đất - TCD
        n_row = 75
        ma_ldlr = 49
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng núi đá - TCDD
        n_row = 76
        ma_ldlr = 50
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng ngập nước - TCDN
        n_row = 77
        ma_ldlr = 51
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng trên cát - TCDC
        n_row = 78
        ma_ldlr = 52
        ws[f"E{n_row}"] = tong_tinh2(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ==== DIỆN TÍCH CHƯA CÓ RỪNG =====
    # Diện tích đã trồng cây rừng nhưng chưa đạt các tiêu chí thành rừng - DTR
        n_row = 80
        ma_ldlr = 53
        ws[f"E{n_row}"] = tong_tinh2(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch    
    # Diện tích có cây tái sinh - DTS
        n_row = 81
        ma_ldlr = 54
        ws[f"E{n_row}"] = tong_tinh2(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Diện tích khác - DTK
        n_row = 82
        ma_ldlr = 55
        ws[f"E{n_row}"] = tong_tinh2(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_tinh2(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_tinh2(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_tinh2(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_tinh2(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_tinh2(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_tinh2(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_tinh2(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_tinh2(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_tinh2(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_tinh2(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_tinh2(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch

        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:Q2")
        ngayky = self.tao_chuoi_ngay()
        ws["M84"] = ngayky
        ws.merge_cells("M84:Q84")

        # Định dạng số liệu
        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                cell.number_format = '#,##0.00'  # 2 chữ số sau dấu phẩy + phân cách hàng nghìn
        custom_format = '#,##0.00;-#,##0.00;"-"'  # hai chữ số thập phân, 0 hiển thị là "-"

        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                if isinstance(cell.value, (int, float)):
                    cell.number_format = custom_format
                    
        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                if cell.data_type == 'f':  # là ô công thức
                    cell.number_format = '#,##0.00;-#,##0.00;"-"'
        #timer.stop()
        #progress.close()
        wb.properties.calcMode = 'auto'
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")

# ------------ BIỂU 3 XÃ --------------------------------------------------------------------------        
    def tonghopbieu3xa(self):
        
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ten_xa = self.dockwidget.cboXa.currentText()
        if self.dockwidget.ckbox.isChecked():
            ten_huyen_kq = f"{ten_xa} - {ten_tinh}"
        else:
            ten_huyen_kq = f"{ten_xa} - {ten_huyen} - {ten_tinh}"
        ket_qua = f"Biểu 03. {ten_huyen_kq}.xlsx"

        if not ten_tinh:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn tỉnh.")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu03.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return

        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file dữ liệu JSON.")
            return

        # Mở file Excel
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active

        # Đọc dữ liệu từ file JSON
        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)

        required_fields = {"tinh", "nggocr", "maldlr", "mamdsd", "mgo", "mtn", "malr3"}
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(self.dockwidget, "Thiếu trường", f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}")
            return

        # Bảng thông báo
        self.elapsed_seconds = 0
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
        #progress.show()
        #timer = QTimer()
        #timer.timeout.connect(lambda: self._update_elapsed_time(progress))
        #timer.start(1000)
        #QApplication.processEvents()
        
        # Hàm tính tổng theo điều kiện
        def tong_mgo_tinh3(nggocr_val, maldlr_val, mamdsd_val, malr3_val):
            return float(round(sum(
                Decimal(str(round(row["mgolo"], 2)))
                for row in data
                if row.get("tinh") == ten_tinh
                and row.get("xa") == ten_xa
                and row.get("nggocr") == nggocr_val
                and row.get("maldlr") == maldlr_val
                and (row.get("mamdsd") in mamdsd_val and row.get("malr3") == malr3_val)
                and isinstance(row.get("mgolo"), (int, float))
            ), 2))
        def tong_mtn_tinh3(nggocr_val, maldlr_val, mamdsd_val, malr3_val):
            return float(round(sum(
                Decimal(str(round(row["mtnlo"], 2)))
                for row in data
                if row.get("tinh") == ten_tinh
                and row.get("nggocr") == nggocr_val
                and row.get("maldlr") == maldlr_val
                and (row.get("mamdsd") in mamdsd_val and row.get("malr3") == malr3_val)
                and isinstance(row.get("mtnlo"), (int, float))
            ), 2))
        # ====== GHI KẾT QUẢ VÀO EXCEL ========
        # Rừng tự nhiên - Nguyên Sinh
            # Rừng nguyên sinh núi đất
        n_row = 11
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, 1, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, 1, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, 1, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, 1, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, 1, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, 1, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, 1, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, 1, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, 1, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, 1, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, 1, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, 1, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nguyên sinh núi đá
        n_row = 12
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, 2, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, 2, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, 2, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, 2, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, 2, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, 2, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, 2, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, 2, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, 2, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, 2, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, 2, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, 2, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nguyên sinh ngập nước
        n_row = 13
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, 3, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, 3, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, 3, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, 3, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, 3, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, 3, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, 3, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, 3, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, 3, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, 3, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, 3, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, 3, [0, 15], 0) # Ngoài quy hoạch
# Rừng tự nhiên - Thứ sinh
# ----- Rừng lá rộng thường xanh và nửa rụng lá ------
    # Rừng giàu - TXG
        n_row = 18
        ma_ldlr = 4
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - TXB
        n_row = 19
        ma_ldlr = 5
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng nghèo - TXN
        n_row = 20
        ma_ldlr = 6
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng nghèo kiệt - TXK
        n_row = 21
        ma_ldlr = 7
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - TXP
        n_row = 22
        ma_ldlr = 8
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
# ----- Rừng lá rộng rụng lá ------
    # Rừng giàu - RLG
        n_row = 24
        ma_ldlr = 9
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - RLB
        n_row = 25
        ma_ldlr = 10
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - RLN
        n_row = 26
        ma_ldlr = 11
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - RLK
        n_row = 27
        ma_ldlr = 12
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - RLP
        n_row = 28
        ma_ldlr = 13
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng lá kim ------
    # Rừng giàu - LKG
        n_row = 30
        ma_ldlr = 14
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - LKB
        n_row = 31
        ma_ldlr = 15
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - LKN
        n_row = 32
        ma_ldlr = 16
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - LKK
        n_row = 33
        ma_ldlr = 17
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - LKP
        n_row = 34
        ma_ldlr = 18
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng hỗn giao cây lá rộng và lá kim ------
    # Rừng giàu - RKG
        n_row = 36
        ma_ldlr = 19
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - RKB
        n_row = 37
        ma_ldlr = 20
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - RKN
        n_row = 38
        ma_ldlr = 21
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - RKK
        n_row = 39
        ma_ldlr = 22
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - RKP
        n_row = 40
        ma_ldlr = 23
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng núi đá ------
    # Rừng giàu - TXDG
        n_row = 42
        ma_ldlr = 24
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - TXDB
        n_row = 43
        ma_ldlr = 25
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - TXDN
        n_row = 44
        ma_ldlr = 26
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - TXDK
        n_row = 45
        ma_ldlr = 27
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - TXDP
        n_row = 46
        ma_ldlr = 28
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng ngập nước ------
    # Rừng ngập mặn - RNM
        n_row = 48
        ma_ldlr = 29
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng ngập phèn - RNP
        n_row = 49
        ma_ldlr = 30
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng ngập ngọt - RNN
        n_row = 50
        ma_ldlr = 31
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng trên cát ------
    # Rừng trên cát - RTNC
        n_row = 51
        ma_ldlr = 32
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch 
# ----- Rừng tre nứa ------
    # Rừng tre nứa núi đất - TN
        n_row = 53
        ma_ldlr = 33
        ws[f"E{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng tre nứa núi đá - TND
        n_row = 54
        ma_ldlr = 34
        ws[f"E{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng hỗn giao gỗ và tre nứa ------
    # Rừng hỗn giao gỗ và tre nứa núi đất - HG
        n_row = 56
        ma_ldlr = 35
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) + tong_mtn_tinh3(1, ma_ldlr, [1], 2)# Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) + tong_mtn_tinh3(1, ma_ldlr, [2], 2)# Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) + tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) + tong_mtn_tinh3(1, ma_ldlr, [4], 2)# Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) + tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2)# Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) + tong_mtn_tinh3(1, ma_ldlr, [8], 1)# Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) + tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) + tong_mtn_tinh3(1, ma_ldlr, [10], 1)# Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) + tong_mtn_tinh3(1, ma_ldlr, [11], 1)# Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) + tong_mtn_tinh3(1, ma_ldlr, [12], 1)# Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) + tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3)# Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) + tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0)# Ngoài quy hoạch
    # Rừng hỗn giao gỗ và tre nứa núi đá - HGD
        n_row = 57
        ma_ldlr = 36
        ws[f"E{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [1], 2) + tong_mtn_tinh3(1, ma_ldlr, [1], 2)# Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [2], 2) + tong_mtn_tinh3(1, ma_ldlr, [2], 2)# Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [3], 2) + tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [4], 2) + tong_mtn_tinh3(1, ma_ldlr, [4], 2)# Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [5, 6, 7], 2) + tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2)# Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [8], 1) + tong_mtn_tinh3(1, ma_ldlr, [8], 1)# Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [9], 1) + tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [10], 1) + tong_mtn_tinh3(1, ma_ldlr, [10], 1)# Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [11], 1) + tong_mtn_tinh3(1, ma_ldlr, [11], 1)# Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [12], 1) + tong_mtn_tinh3(1, ma_ldlr, [12], 1)# Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [13, 14, 15], 3) + tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3)# Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(1, ma_ldlr, [0, 15], 0) + tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0)# Ngoài quy hoạch
# ----- Rừng cau dừa ------
    # Rừng cau dừa núi đất - CD
        n_row = 59
        ma_ldlr = 37
        ws[f"E{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa núi đá - CDD
        n_row = 60
        ma_ldlr = 38
        ws[f"E{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa ngập nước- CDN
        n_row = 61
        ma_ldlr = 39
        ws[f"E{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trên cát - CDC
        n_row = 62
        ma_ldlr = 40
        ws[f"E{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ====== RỪNG TRỒNG ===========
# Rừng gỗ (loài cây, cấp tuổi, nguồn gốc)
    # Rừng gỗ trồng núi đất - TG
        n_row = 65
        ma_ldlr = 41
        ws[f"E{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng núi đá - TGD
        n_row = 66
        ma_ldlr = 42
        ws[f"E{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập ngọt - TGNN
        n_row = 67
        ma_ldlr = 43
        ws[f"E{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập mặn - TGNM
        n_row = 68
        ma_ldlr = 44
        ws[f"E{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập phèn - TGNP
        n_row = 69
        ma_ldlr = 45
        ws[f"E{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng trên cát - TGC
        n_row = 70
        ma_ldlr = 46
        ws[f"E{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
# Rừng tre nứa
    # Rừng tre nứa trồng núi đất - TTN
        n_row = 72
        ma_ldlr = 47
        ws[f"E{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng tre nứa trồng núi đá - TTND
        n_row = 73
        ma_ldlr = 48
        ws[f"E{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# Rừng cau dừa
    # Rừng cau dừa trồng núi đất - TCD
        n_row = 75
        ma_ldlr = 49
        ws[f"E{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng núi đá - TCDD
        n_row = 76
        ma_ldlr = 50
        ws[f"E{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng ngập nước - TCDN
        n_row = 77
        ma_ldlr = 51
        ws[f"E{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng trên cát - TCDC
        n_row = 78
        ma_ldlr = 52
        ws[f"E{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mtn_tinh3(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ==== DIỆN TÍCH CHƯA CÓ RỪNG =====
    # Diện tích đã trồng cây rừng nhưng chưa đạt các tiêu chí thành rừng - DTR
        n_row = 80
        ma_ldlr = 53
        ws[f"E{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch    
    # Diện tích có cây tái sinh - DTS
        n_row = 81
        ma_ldlr = 54
        ws[f"E{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Diện tích khác - DTK
        n_row = 82
        ma_ldlr = 55
        ws[f"E{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mgo_tinh3(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch

        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:Q2")
        ngayky = self.tao_chuoi_ngay()
        ws["M84"] = ngayky
        ws.merge_cells("M84:Q84")       
        
        # Định dạng số liệu
        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                cell.number_format = '#,##0.00'  # 2 chữ số sau dấu phẩy + phân cách hàng nghìn
        custom_format = '#,##0.00;-#,##0.00;"-"'  # hai chữ số thập phân, 0 hiển thị là "-"

        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                if isinstance(cell.value, (int, float)):
                    cell.number_format = custom_format
                    
        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                if cell.data_type == 'f':  # là ô công thức
                    cell.number_format = '#,##0.00;-#,##0.00;"-"'
        #timer.stop()
        #progress.close()
        wb.properties.calcMode = 'auto'
        
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")

# ----------- BIỂU 04 XÃ --------------------------------------------------------------------------
    def tonghopbieu4xa(self):
        
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ten_xa = self.dockwidget.cboXa.currentText()
        if self.dockwidget.ckbox.isChecked():
            ten_huyen_kq = f"{ten_xa} - {ten_tinh}"
        else:
            ten_huyen_kq = f"{ten_xa} - {ten_huyen} - {ten_tinh}"
        ket_qua = f"Biểu 04. {ten_huyen_kq}.xlsx"

        if not ten_tinh:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn tỉnh.")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu04.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return

        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file dữ liệu JSON.")
            return

        # Mở file Excel
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active

        # Đọc dữ liệu từ file JSON
        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)

        required_fields = {"tinh", "nggocr", "maldlr", "mamdsd", "dtich", "malr3"}
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(self.dockwidget, "Thiếu trường", f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}")
            return

        # Bảng thông báo
        self.elapsed_seconds = 0
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
        #progress.show()
        #timer = QTimer()
        #timer.timeout.connect(lambda: self._update_elapsed_time(progress))
        #timer.start(1000)
        QApplication.processEvents()
        
        # Hàm tính tổng theo điều kiện
        def tong_mcolo_tinh4(nggocr_val, maldlr_val, mamdsd_val, malr3_val):
            return float(round(sum(
                Decimal(str(round(row["mcolo"], 2)))
                for row in data
                if row.get("tinh") == ten_tinh
                and row.get("xa") == ten_xa
                and row.get("nggocr") == nggocr_val
                and row.get("maldlr") == maldlr_val
                and (row.get("mamdsd") in mamdsd_val and row.get("malr3") == malr3_val)
                and isinstance(row.get("mcolo"), (int, float))
            ), 2))
        # ====== GHI KẾT QUẢ VÀO EXCEL ========
        # Rừng tự nhiên - Nguyên Sinh
            # Rừng nguyên sinh núi đất
        n_row = 11
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, 1, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, 1, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, 1, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, 1, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, 1, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, 1, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, 1, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, 1, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, 1, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, 1, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, 1, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, 1, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nguyên sinh núi đá
        n_row = 12
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, 2, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, 2, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, 2, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, 2, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, 2, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, 2, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, 2, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, 2, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, 2, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, 2, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, 2, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, 2, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nguyên sinh ngập nước
        n_row = 13
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, 3, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, 3, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, 3, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, 3, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, 3, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, 3, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, 3, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, 3, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, 3, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, 3, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, 3, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, 3, [0, 15], 0) # Ngoài quy hoạch
# Rừng tự nhiên - Thứ sinh
# ----- Rừng lá rộng thường xanh và nửa rụng lá ------
    # Rừng giàu - TXG
        n_row = 18
        ma_ldlr = 4
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - TXB
        n_row = 19
        ma_ldlr = 5
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng nghèo - TXN
        n_row = 20
        ma_ldlr = 6
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng nghèo kiệt - TXK
        n_row = 21
        ma_ldlr = 7
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - TXP
        n_row = 22
        ma_ldlr = 8
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
# ----- Rừng lá rộng rụng lá ------
    # Rừng giàu - RLG
        n_row = 24
        ma_ldlr = 9
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - RLB
        n_row = 25
        ma_ldlr = 10
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - RLN
        n_row = 26
        ma_ldlr = 11
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - RLK
        n_row = 27
        ma_ldlr = 12
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - RLP
        n_row = 28
        ma_ldlr = 13
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng lá kim ------
    # Rừng giàu - LKG
        n_row = 30
        ma_ldlr = 14
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - LKB
        n_row = 31
        ma_ldlr = 15
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - LKN
        n_row = 32
        ma_ldlr = 16
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - LKK
        n_row = 33
        ma_ldlr = 17
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - LKP
        n_row = 34
        ma_ldlr = 18
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng hỗn giao cây lá rộng và lá kim ------
    # Rừng giàu - RKG
        n_row = 36
        ma_ldlr = 19
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - RKB
        n_row = 37
        ma_ldlr = 20
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - RKN
        n_row = 38
        ma_ldlr = 21
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - RKK
        n_row = 39
        ma_ldlr = 22
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - RKP
        n_row = 40
        ma_ldlr = 23
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng núi đá ------
    # Rừng giàu - TXDG
        n_row = 42
        ma_ldlr = 24
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng trung bình - TXDB
        n_row = 43
        ma_ldlr = 25
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo - TXDN
        n_row = 44
        ma_ldlr = 26
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng nghèo kiệt - TXDK
        n_row = 45
        ma_ldlr = 27
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng chưa có trữ lượng - TXDP
        n_row = 46
        ma_ldlr = 28
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng ngập nước ------
    # Rừng ngập mặn - RNM
        n_row = 48
        ma_ldlr = 29
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
    # Rừng ngập phèn - RNP
        n_row = 49
        ma_ldlr = 30
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng ngập ngọt - RNN
        n_row = 50
        ma_ldlr = 31
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng trên cát ------
    # Rừng trên cát - RTNC
        n_row = 51
        ma_ldlr = 32
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch 
# ----- Rừng tre nứa ------
    # Rừng tre nứa núi đất - TN
        n_row = 53
        ma_ldlr = 33
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng tre nứa núi đá - TND
        n_row = 54
        ma_ldlr = 34
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng hỗn giao gỗ và tre nứa ------
    # Rừng hỗn giao gỗ và tre nứa núi đất - HG
        n_row = 56
        ma_ldlr = 35
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng hỗn giao gỗ và tre nứa núi đá - HGD
        n_row = 57
        ma_ldlr = 36
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ----- Rừng cau dừa ------
    # Rừng cau dừa núi đất - CD
        n_row = 59
        ma_ldlr = 37
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa núi đá - CDD
        n_row = 60
        ma_ldlr = 38
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa ngập nước- CDN
        n_row = 61
        ma_ldlr = 39
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trên cát - CDC
        n_row = 62
        ma_ldlr = 40
        ws[f"E{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(1, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ====== RỪNG TRỒNG ===========
# Rừng gỗ (loài cây, cấp tuổi, nguồn gốc)
    # Rừng gỗ trồng núi đất - TG
        n_row = 65
        ma_ldlr = 41
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng núi đá - TGD
        n_row = 66
        ma_ldlr = 42
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập ngọt - TGNN
        n_row = 67
        ma_ldlr = 43
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập mặn - TGNM
        n_row = 68
        ma_ldlr = 44
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng ngập phèn - TGNP
        n_row = 69
        ma_ldlr = 45
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng gỗ trồng trên cát - TGC
        n_row = 70
        ma_ldlr = 46
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch        
# Rừng tre nứa
    # Rừng tre nứa trồng núi đất - TTN
        n_row = 72
        ma_ldlr = 47
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng tre nứa trồng núi đá - TTND
        n_row = 73
        ma_ldlr = 48
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# Rừng cau dừa
    # Rừng cau dừa trồng núi đất - TCD
        n_row = 75
        ma_ldlr = 49
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng núi đá - TCDD
        n_row = 76
        ma_ldlr = 50
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng ngập nước - TCDN
        n_row = 77
        ma_ldlr = 51
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Rừng cau dừa trồng trên cát - TCDC
        n_row = 78
        ma_ldlr = 52
        ws[f"E{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(2, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
# ==== DIỆN TÍCH CHƯA CÓ RỪNG =====
    # Diện tích đã trồng cây rừng nhưng chưa đạt các tiêu chí thành rừng - DTR
        n_row = 80
        ma_ldlr = 53
        ws[f"E{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch    
    # Diện tích có cây tái sinh - DTS
        n_row = 81
        ma_ldlr = 54
        ws[f"E{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch
    # Diện tích khác - DTK
        n_row = 82
        ma_ldlr = 55
        ws[f"E{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [1], 2) # Vườn quốc gia
        ws[f"F{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [2], 2) # Khu dự trữ thiên nhiên
        ws[f"G{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [3], 2) # Khu bảo tồn loài, sinh cảnh
        ws[f"H{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [4], 2) # Khu bảo vệ cảnh quan
        ws[f"I{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [5, 6, 7], 2) # Khu NC, TNKH, vườn TVQG, rừng giống QG
        ws[f"K{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [8], 1) # Phòng hộ đầu nguồn
        ws[f"L{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [9], 1) # Rừng bảo vệ nguồn nước
        ws[f"M{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [10], 1) # Rừng phòng hộ biên giới
        ws[f"N{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [11], 1) # Rừng chắn gió, chắn cát
        ws[f"O{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [12], 1) # Rừng chắn sóng, lấn biển
        ws[f"P{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [13, 14, 15], 3) # Rừng sản xuất
        ws[f"Q{n_row}"] = tong_mcolo_tinh4(3, ma_ldlr, [0, 15], 0) # Ngoài quy hoạch

        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:Q2")
        ngayky = self.tao_chuoi_ngay()
        ws["M84"] = ngayky
        ws.merge_cells("M84:Q84")        
        
        # Định dạng số liệu
        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                cell.number_format = '#,##0.00'  # 2 chữ số sau dấu phẩy + phân cách hàng nghìn
        custom_format = '#,##0.00;-#,##0.00;"-"'  # hai chữ số thập phân, 0 hiển thị là "-"

        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                if isinstance(cell.value, (int, float)):
                    cell.number_format = custom_format
                    
        for row in ws.iter_rows(min_row=7, max_row=82, min_col=3, max_col=17):
            for cell in row:
                if cell.data_type == 'f':  # là ô công thức
                    cell.number_format = '#,##0.00;-#,##0.00;"-"'
       # timer.stop()
        #progress.close()
        wb.properties.calcMode = 'auto'
        
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")
#------------ BIỂU 05 XÃ ----------------------------------------------------------------------
    def tonghopbieu5xa(self):
        
        ten_lop = self.dockwidget.cboLayer.currentText()
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ten_xa = self.dockwidget.cboXa.currentText()
        if self.dockwidget.ckbox.isChecked():
            ten_huyen_kq = f"{ten_xa} - {ten_tinh}"
        else:
            ten_huyen_kq = f"{ten_xa} - {ten_huyen} - {ten_tinh}"
        ket_qua = f"Biểu 05. {ten_huyen_kq}.xlsx"
        if not ten_lop:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn lớp bản đồ.")
            return

        layer = next((l for l in QgsProject.instance().mapLayers().values() if l.name() == ten_lop), None)
        if not layer:
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy lớp: {ten_lop}")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu05.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return
        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        # Đọc dữ liệu từ file JSON đã tạo từ lớp bản đồ
        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file JSON dữ liệu.")
            return

        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)
        # Các trường bắt buộc cần có
        required_fields = {"tinh", "maldlr","sldlr", "non", "vua", "gia", "hvn", "d13"}

        # Kiểm tra xem bản ghi đầu tiên có đủ trường không
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(
                self.dockwidget,
                "Thiếu trường dữ liệu",
                f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}"
            )
            return
        # Bảng thông báo
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
        #progress.show()
        QApplication.processEvents()
        # Lọc dữ liệu theo tỉnh và điều kiện
        filtered = [
            row for row in data
            if row.get("tinh") == ten_tinh
            and row.get("xa") == ten_xa
            and isinstance(row.get("maldlr"), (int, float))
            and row.get("maldlr") in [35, 36, 47, 48]
            and row.get("sldlr")  # Trạng thái rừng không rỗng
        ]

        if not filtered:
            QMessageBox.warning(self.dockwidget, "Thông báo", "Không có dữ liệu rừng tre nứa")
                    # Thêm tên tỉnh vào tiêu đề
            # Mở tệp Excel
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active

            # Chèn dòng bắt đầu từ dòng 9
            ws.insert_rows(idx=9, amount=0)
            ws["A2"] = f"{ten_huyen_kq}"
            ws.merge_cells("A2:H2")
            start_row = 7
            row_ngay = start_row + 3
            row_ky  = start_row + 4
            ngayky = self.tao_chuoi_ngay()
            ws[f"F{row_ngay}"] = ngayky
            ws.merge_cells(f"F{row_ngay}:H{row_ngay}")
            ws.merge_cells(f"A{row_ky}:C{row_ky}")
            ws.merge_cells(f"F{row_ky}:H{row_ky}")
            
            from openpyxl.styles import Alignment
            from openpyxl.styles import Font
            
            ws["A2"].alignment = Alignment(horizontal="center",vertical="center")
            ws[f"F{row_ngay}"].font = Font(name="Times New Roman", size = 12, italic = True)
            ws[f"F{row_ngay}"].alignment = Alignment(horizontal="center",vertical="center")
            ws[f"A{row_ky}"] = "Thủ trưởng đơn vị"
            ws[f"A{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
            ws[f"A{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
            ws[f"F{row_ky}"] = "Người tổng hợp"
            ws[f"F{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
            ws[f"F{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
            
            #progress.close()
            
            try:
                wb.save(path_save)
                #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
            except:
                QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")
            #progress.close()
            return

        df = pd.DataFrame(filtered)

        # Chỉ lấy các cột cần thiết nếu chưa có
        df = df[["sldlr", "non", "vua", "gia", "hvn", "d13"]]
        
        # Tính toán giá trị trung bình mgo, mtn
        # Gộp dữ liệu theo sldlr
        tong_hop = df.groupby("sldlr").agg({
            "non": "sum",
            "vua": "sum",
            "gia": "sum",
            "hvn": "mean",
            "d13": "mean"
        }).reset_index()
        tong_hop[["non", "vua", "gia"]] = tong_hop[["non", "vua", "gia"]] * 1000
        tong_hop["tongcay"] = tong_hop["non"] + tong_hop["vua"] + tong_hop["gia"]
        # Tùy chọn: Làm tròn
        tong_hop = tong_hop.round({
            "tongcay": 0,
            "non": 0,
            "vua": 0,
            "gia": 0,
            "hvn": 2,
            "d13": 2
        })
        
        print(tong_hop)
        
        # Tổng các cột cần cộng
        tong = tong_hop[["tongcay", "non", "vua", "gia"]].sum()

        # Trung bình các cột cần lấy trung bình
        trung_binh = tong_hop[["hvn", "d13"]].mean()

        # Dòng tổng cộng
        tong_cong = {
            "sldlr": "Tổng cộng",
            "tongcay": tong["tongcay"],
            "non": tong["non"],
            "vua": tong["vua"],
            "gia": tong["gia"],
            "hvn": trung_binh["hvn"],
            "d13": trung_binh["d13"]
        }
        print (tong_cong)
        ntrangthai = df["sldlr"].nunique()
        # Chỉ chèn dòng nếu có nhiều hơn 1 trạng thái
        ndongchen = 0
        if ntrangthai > 1:
            ndongchen = ntrangthai - 1
   
        # Mở tệp Excel
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active

            # Chèn dòng bắt đầu từ dòng 9
            ws.insert_rows(idx=9, amount=ndongchen)
        else:
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active
            print("Không cần chèn thêm dòng vì chỉ có 1 trạng thái.")
       
    # Ghi dữ liệu vào từng dòng
        # Ghi dòng tổng
        giatri_tongcay = tong_cong.get("tongcay", 0)
        giatri_non = tong_cong.get("non", 0)
        giatri_vua = tong_cong.get("vua", 0)
        giatri_gia = tong_cong.get("gia", 0)
        giatri_hvn = tong_cong.get("hvn", 0)
        giatri_d13 = tong_cong.get("d13", 0)
        ws["C7"] = giatri_tongcay
        ws["D7"] = giatri_non
        ws["E7"] = giatri_vua
        ws["F7"] = giatri_gia
        ws["G7"] = giatri_hvn
        ws["H7"] = giatri_d13
        start_row = 8
        for idx, row in tong_hop.iterrows():
            ws[f"A{start_row + idx}"] = idx + 1
            ws[f"B{start_row + idx}"] = row["sldlr"]
            ws[f"C{start_row + idx}"] = round(row["tongcay"], 0)
            ws[f"D{start_row + idx}"] = round(row["non"], 0)
            ws[f"E{start_row + idx}"] = round(row["vua"], 0)
            ws[f"F{start_row + idx}"] = round(row["gia"], 0)
            ws[f"G{start_row + idx}"] = round(row["hvn"], 0)
            ws[f"H{start_row + idx}"] = round(row["d13"], 0)
        
        # Sao chép định dạng từ dòng mẫu 
        mau_row = start_row + ndongchen  # dòng gốc đã bị đẩy xuống
        for row_offset in range(ndongchen):
            for col in range(1, 9):  # copy theo số cột đang có
                new_cell = ws.cell(row=start_row + row_offset + 1, column=col)
                template_cell = ws.cell(row=8, column=col)

                # Sao chép giá trị format
                if template_cell.has_style:
                    new_cell.font = copy(template_cell.font)
                    new_cell.border = copy(template_cell.border)
                    new_cell.fill = copy(template_cell.fill)
                    new_cell.number_format = copy(template_cell.number_format)
                    new_cell.protection = copy(template_cell.protection)
                    new_cell.alignment = copy(template_cell.alignment)
        
        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:H2")
        row_ngay = start_row + ndongchen + 3
        row_ky  = start_row + ndongchen + 4
        ngayky = self.tao_chuoi_ngay()
        ws[f"F{row_ngay}"] = ngayky
        ws.merge_cells(f"F{row_ngay}:H{row_ngay}")
        ws.merge_cells(f"A{row_ky}:C{row_ky}")
        ws.merge_cells(f"F{row_ky}:H{row_ky}")
        
        from openpyxl.styles import Alignment
        from openpyxl.styles import Font
        
        ws["A2"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ngay}"].font = Font(name="Times New Roman", size = 12, italic = True)
        ws[f"F{row_ngay}"].alignment = Alignment(horizontal="center",vertical="center")
        #ws[f"A{row_ky}"] = "Thủ trưởng đơn vị"
        ws[f"A{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"A{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"F{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
		
        #progress.close()
		
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")       
#------------ BIỂU 06 XÃ ----------------------------------------------------------------------
    def tonghopbieu6xa(self):
        ten_lop = self.dockwidget.cboLayer.currentText()
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ten_xa = self.dockwidget.cboXa.currentText()
        if self.dockwidget.ckbox.isChecked():
            ten_huyen_kq = f"{ten_xa} - {ten_tinh}"
        else:
            ten_huyen_kq = f"{ten_xa} - {ten_huyen} - {ten_tinh}"
        ket_qua = f"Biểu 06. {ten_huyen_kq}.xlsx"

        if not ten_lop:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn lớp bản đồ.")
            return

        layer = next((l for l in QgsProject.instance().mapLayers().values() if l.name() == ten_lop), None)
        if not layer:
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy lớp: {ten_lop}")
            return        

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu06.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return
        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        # Đọc dữ liệu từ file JSON đã tạo từ lớp bản đồ
        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file JSON dữ liệu.")
            return

        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            df_rung = pd.DataFrame(json.load(f))
        # Các trường bắt buộc cần có
        required_fields = {"matinh", "tinh", "mahuyen", "huyen","maxa", "xa", "tk", "maldlr", "malr3", "dtich"}

        # Kiểm tra xem bản ghi đầu tiên có đủ trường không
        if df_rung.empty or not required_fields.issubset(df_rung.columns):
            QMessageBox.critical(
                self.dockwidget,
                "Thiếu trường dữ liệu",
                f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}"
            )
            return
        self.path_to_dsxa = os.path.join(os.path.dirname(__file__), "data", "dsxa.json")

        if not os.path.exists(self.path_to_dsxa):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file JSON dữ liệu danh sách xã.")
            return
        
        with open(self.path_to_dsxa, "r", encoding="utf-8") as f:
            df_dtn = pd.DataFrame(json.load(f))
        # Bảng thông báo
        self.elapsed_seconds = 0
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
        #progress.show()
        #QApplication.processEvents()
        
        # 2. Danh sách xã trong huyện
        if self.dockwidget.ckbox.isChecked():
            ds_xa = sorted(
                df_rung[
                    (df_rung["tinh"] == ten_tinh) &
                    (df_rung["xa"] == ten_xa)
                ]["tk"].dropna().unique()
            )
        else:
            ds_xa = sorted(
                df_rung[
                    (df_rung["tinh"] == ten_tinh) &
                    (df_rung["huyen"] == ten_huyen) & 
                    (df_rung["xa"] == ten_xa)
                ]["tk"].dropna().unique()
            )
        print (f"Danh sách xã: {ds_xa}")
        # Mã huyện trung bình (nếu trùng nhau thì ra đúng mã)
        #mahuyen = df_rung[df_rung["huyen"] == ten_huyen]["mahuyen"].mean()
        #mahuyen = df_rung.loc[df_rung["huyen"] == ten_huyen, "mahuyen"].mode()[0]
        # Mã xã trung bình (nếu cần)
        if self.dockwidget.ckbox.isChecked():
            maxa = df_rung.loc[
                (df_rung["tinh"] == ten_tinh) &
                (df_rung["xa"] == ten_xa)
            ]["maxa"].mode() [0]
        else:
            maxa = df_rung.loc[
                (df_rung["tinh"] == ten_tinh) &
                (df_rung["huyen"] == ten_huyen) &
                (df_rung["xa"] == ten_xa)
            ]["maxa"].mode()[0]
        maxa = int(maxa)
        # Mở tệp mẫu    
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active       
        # Chèn thêm dòng
        ndongchen = 0
        if len(ds_xa) > 1:
            ndongchen = len(ds_xa) - 1
   
        # Mở tệp Excel
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active

            # Chèn dòng bắt đầu từ dòng 9
            ws.insert_rows(idx=8, amount=ndongchen)
        else:
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active
            print("Không cần chèn thêm dòng vì chỉ có 1 trạng thái.")
        
        start_row = 7

        # 3. Tổng hợp theo từng huyện
        ket_qua = []

        for idx, tk in enumerate(ds_xa):
            #maxa = df_rung[(df_rung["xa"] == xa)]["maxa"].mean()         
            #tong_dtn = round(df_dtn[(df_dtn["mahuyen"] == mahuyen) & (df_dtn["maxa"] == maxa)]["dtich"].sum(), 2)
            tong_dtn = 0
            row = start_row + idx
            ws[f"A{row}"] = idx + 1
            if self.dockwidget.ckbox.isChecked():
                d = df_rung[(df_rung["tinh"] == ten_tinh) & (df_rung["xa"] == ten_xa) & (df_rung["tk"] == tk)]
            else:
                d = df_rung[(df_rung["tinh"] == ten_tinh) & (df_rung["huyen"] == ten_huyen) & (df_rung["xa"] == ten_xa) & (df_rung["tk"] == tk)]

            ws[f"B{row}"] = f"Tiểu khu {tk}"
            ws[f"C{row}"] = 0
            co_rung = round(d[d["maldlr"].isin(list(range(1, 54)))]["dtich"].sum(), 2)
            ws[f"D{row}"] = co_rung
            rung_tn = round(d[d["maldlr"].isin(list(range(1, 41)))]["dtich"].sum(), 2)
            ws[f"E{row}"] = rung_tn
            rung_trong = round(d[d["maldlr"].isin(list(range(41, 53)))]["dtich"].sum(), 2)
            ws[f"F{row}"] = rung_trong
            rung_moi_trong = round(d[d["maldlr"] == 53]["dtich"].sum(), 2)
            ws[f"G{row}"] = rung_moi_trong
            trong_qh = round(d[d["maldlr"].isin(list(range(1, 54))) & d["malr3"].isin([1, 2, 3])]["dtich"].sum(), 2)
            ws[f"H{row}"] = trong_qh
            dac_dung = round(d[d["maldlr"].isin(list(range(1, 54))) & (d["malr3"] == 2)]["dtich"].sum(), 2)
            ws[f"I{row}"] = dac_dung
            phong_ho = round(d[d["maldlr"].isin(list(range(1, 54))) & (d["malr3"] == 1)]["dtich"].sum(), 2)
            ws[f"J{row}"] = phong_ho
            san_xuat = round(d[d["maldlr"].isin(list(range(1, 54))) & (d["malr3"] == 3)]["dtich"].sum(), 2)
            ws[f"K{row}"] = san_xuat
            ngoai_qh = round(d[d["maldlr"].isin(list(range(1, 54))) & (d["malr3"] == 0)]["dtich"].sum(), 2)
            ws[f"L{row}"] = ngoai_qh
            dien_tich_co_rung = d[d["maldlr"].isin(list(range(1, 53)))]["dtich"].sum()
            do_che_phu = round(dien_tich_co_rung * 100 / tong_dtn, 2) if tong_dtn > 0 else 0
            ws[f"M{row}"] = do_che_phu

        print (maxa)
        # Xử lý toàn xã
        tong_dtn_huyen = round(df_dtn[df_dtn["maxa"] == maxa]["dtich"].sum(), 2)
        d_tinh = df_rung[df_rung["xa"] == ten_xa]
        ws[f"B{start_row + ndongchen + 1}"] = 'Tổng toàn xã'
        ws[f"C{start_row + ndongchen + 1}"] = tong_dtn_huyen
        co_rung = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 54)))]['dtich'].sum(), 2)
        ws[f"D{start_row + ndongchen + 1}"] = co_rung
        rung_tn = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 41)))]['dtich'].sum(), 2)
        ws[f"E{start_row + ndongchen + 1}"] = rung_tn
        rung_trong = round(d_tinh[d_tinh["maldlr"].isin(list(range(41, 53)))]['dtich'].sum(), 2)
        ws[f"F{start_row + ndongchen + 1}"] = rung_trong
        rung_moi_trong = round(d_tinh[d_tinh["maldlr"] == 53]['dtich'].sum(), 2)
        ws[f"G{start_row + ndongchen + 1}"] = rung_moi_trong
        trong_qh = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 54))) & d_tinh["malr3"].isin([1, 2, 3])]['dtich'].sum(), 2)
        ws[f"H{start_row + ndongchen + 1}"] = trong_qh
        dac_dung = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 54))) & (d_tinh["malr3"] == 2)]['dtich'].sum(), 2)
        ws[f"I{start_row + ndongchen + 1}"] = dac_dung
        phong_ho = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 54))) & (d_tinh["malr3"] == 1)]['dtich'].sum(), 2)
        ws[f"J{start_row + ndongchen + 1}"] = phong_ho
        san_xuat = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 54))) & (d_tinh["malr3"] == 3)]['dtich'].sum(), 2)
        ws[f"K{start_row + ndongchen + 1}"] = san_xuat
        ngoai_qh = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 54))) & (d_tinh["malr3"] == 0)]['dtich'].sum(), 2)
        ws[f"L{start_row + ndongchen + 1}"] = ngoai_qh
        dien_tich_co_rung = round(d_tinh[d_tinh["maldlr"].isin(list(range(1, 53)))]['dtich'].sum(), 2)
        do_che_phu_tinh = round(dien_tich_co_rung * 100 / tong_dtn_huyen, 2) if tong_dtn_huyen > 0 else 0
        ws[f"M{start_row + ndongchen + 1}"] = do_che_phu_tinh

        # Sao chép định dạng từ dòng mẫu 
        #mau_row = start_row + ndongchen  # dòng gốc đã bị đẩy xuống
        for row_offset in range(ndongchen):
            for col in range(1, 14):  # copy theo số cột đang có
                new_cell = ws.cell(row=start_row + row_offset + 1, column=col)
                template_cell = ws.cell(row=7, column=col)

                # Sao chép giá trị format
                if template_cell.has_style:
                    new_cell.font = copy(template_cell.font)
                    new_cell.border = copy(template_cell.border)
                    new_cell.fill = copy(template_cell.fill)
                    new_cell.number_format = copy(template_cell.number_format)
                    new_cell.protection = copy(template_cell.protection)
                    new_cell.alignment = copy(template_cell.alignment)

        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:M2")
        row_ngay = start_row + ndongchen + 3
        row_ky  = start_row + ndongchen + 4
        ngayky = self.tao_chuoi_ngay()
        ws[f"J{row_ngay}"] = ngayky
        ws.merge_cells(f"J{row_ngay}:L{row_ngay}")
        ws[f"B{row_ky}"] = 'Thủ trưởng đơn vị'
        ws.merge_cells(f"B{row_ky}:D{row_ky}")
        ws[f"J{row_ky}"] = 'Người tổng hợp'
        ws.merge_cells(f"J{row_ky}:L{row_ky}")
        
        from openpyxl.styles import Alignment
        from openpyxl.styles import Font
        
        ws["A2"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"J{row_ngay}"].font = Font(name="Times New Roman", size = 12, italic = True)
        ws[f"J{row_ngay}"].alignment = Alignment(horizontal="center",vertical="center")
        #ws[f"A{row_ky}"] = "Thủ trưởng đơn vị"
        ws[f"B{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"B{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"J{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"J{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        for cell in ws[f"A{start_row + ndongchen + 1}":f"M{start_row + ndongchen + 1}"][0]:
            cell.font = Font(name="Times New Roman", size = 12, bold=True)
        #progress.close()
        
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")
        
#------------ BIỂU 07 XÃ ----------------------------------------------------------------------
    def tonghopbieu7xa(self):
        ten_lop = self.dockwidget.cboLayer.currentText()
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ten_xa = self.dockwidget.cboXa.currentText()
        if self.dockwidget.ckbox.isChecked():
            ten_huyen_kq = f"{ten_xa} - {ten_tinh}"
        else:
            ten_huyen_kq = f"{ten_xa} - {ten_huyen} - {ten_tinh}"
        ket_qua ="Biểu 07. " + ten_huyen_kq + ".xlsx"
        nam_str = self.dockwidget.txtNamdt.text().strip()        
        from datetime import datetime

        nam_hien_tai = datetime.now().year
        if not nam_str.isdigit():
            QMessageBox.warning(self.dockwidget, "Lỗi nhập liệu", "Vui lòng nhập một năm là số nguyên.")
            return

        namdt = int(nam_str)
        nam_hien_tai = datetime.now().year

        # Kiểm tra giới hạn năm
        if namdt < 2015 or namdt > nam_hien_tai:
            QMessageBox.warning(
                self.dockwidget,
                "Năm không hợp lệ",
                f"Năm phải nằm trong khoảng từ 2015 đến {nam_hien_tai}."
            )
            return        
        
        if not ten_lop:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn lớp bản đồ.")
            return

        layer = next((l for l in QgsProject.instance().mapLayers().values() if l.name() == ten_lop), None)
        if not layer:
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy lớp: {ten_lop}")
            return        

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu07.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return
        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        # Đọc dữ liệu từ file JSON đã tạo từ lớp bản đồ
        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file JSON dữ liệu.")
            return

        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            df_rung = pd.DataFrame(json.load(f))
        # Các trường bắt buộc cần có
        required_fields = {"matinh", "tinh", "mahuyen", "huyen","maxa", "xa", "maldlr", "sldlr", "dtich", "captuoi", "namtr"}

        # Kiểm tra xem bản ghi đầu tiên có đủ trường không
        if df_rung.empty or not required_fields.issubset(df_rung.columns):
            QMessageBox.critical(
                self.dockwidget,
                "Thiếu trường dữ liệu",
                f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}"
            )
            return

        # Bảng thông báo
        self.elapsed_seconds = 0
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
        #progress.show()
        #QApplication.processEvents()

        ds_maldlr = [41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53]

        # Lọc dữ liệu đầu vào
        df_rung = df_rung[
            (df_rung["sldlr"].notna()) &
            (df_rung["namtr"].notna()) &
            (df_rung["captuoi"].notna()) &
            (df_rung["dtich"].notna()) &
            (df_rung["maldlr"].isin(ds_maldlr)) &
            (df_rung["tinh"] == ten_tinh) &
            (df_rung["xa"] == ten_xa)
        ]

        # Ép kiểu
        df_rung["namtr"] = pd.to_numeric(df_rung["namtr"], errors="coerce")
        df_rung["captuoi"] = pd.to_numeric(df_rung["captuoi"], errors="coerce")
        df_rung["dtich"] = pd.to_numeric(df_rung["dtich"], errors="coerce")

        # Tính cấp tuổi
        df_rung["so_nam"] = nam_hien_tai - df_rung["namtr"]
        df_rung["cap_tuoi"] = (df_rung["so_nam"] / df_rung["captuoi"]).apply(
            lambda x: int(x) if x <= int(x) else (int(x) + 1 if int(x) + 1 <= 5 else 5)
        )

        # Giới hạn cấp tuổi từ 1 đến 5
        df_rung = df_rung[df_rung["cap_tuoi"].between(1, 5)]

        # Tổng hợp theo loài cây và cấp tuổi
        tonghop = df_rung.groupby(["sldlr", "cap_tuoi"])["dtich"].sum().reset_index()
        tonghop["dtich"] = tonghop["dtich"].round(2)

        # Tùy chọn pivot bảng
        # Bước 1: Pivot bảng
        pivot = tonghop.pivot(index="sldlr", columns="cap_tuoi", values="dtich").fillna(0)
        # Bước 2: Đảm bảo luôn có đủ cột cấp tuổi từ 1 đến 5
        for tuoi in [1, 2, 3, 4, 5]:
            if tuoi not in pivot.columns:
                pivot[tuoi] = 0  # thêm cột thiếu và gán giá trị 0

        # Bước 3: Đưa lại thứ tự cột nếu cần
        pivot = pivot[[1, 2, 3, 4, 5]]
        # Bước 4: Đưa sldlr từ chỉ số về thành cột
        pivot.reset_index(inplace=True)

        # Bước 5: Thêm cột STT ở vị trí đầu
        pivot.insert(0, "STT", range(1, len(pivot) + 1))

        # Bước 6: Tính tổng và chèn cột "Tổng" vào sau "sldlr" (tức vị trí thứ 2)
        # Giả định các cột cấp tuổi là số nguyên 1–5
        pivot.insert(2, "Tổng", pivot.loc[:, [1, 2, 3, 4, 5]].sum(axis=1).round(2))
        # Tính tổng từng cột (bỏ cột STT và sldlr)
        tong_cac_cot = pivot.drop(columns=["STT", "sldlr"]).sum(numeric_only=True).round(2)

        # Tạo dòng mới là một Series
        dong_tong = pd.Series(
            [None, "Tổng cộng"] + tong_cac_cot.tolist(),
            index=pivot.columns
        )

        # Thêm dòng vào cuối bảng
        pivot = pd.concat([pivot, pd.DataFrame([dong_tong])], ignore_index=True)
        so_dong = len(pivot)
        print(pivot)

        
        # Chèn thêm dòng
        ndongchen = 0
        if so_dong > 1:
            ndongchen = so_dong - 1
   
        # Mở tệp Excel
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active

            # Chèn dòng bắt đầu từ dòng 8
            ws.insert_rows(idx=8, amount=ndongchen)
        else:
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active
            print("Không cần chèn thêm dòng vì chỉ có 1 trạng thái.")
        
        # Bỏ header: chuyển pivot sang list các dòng, không bao gồm tên cột
        du_lieu = pivot.values.tolist()

        # Ghi dữ liệu bắt đầu từ dòng 7, cột A (A7)
        start_row = 7
        for i, row_data in enumerate(du_lieu):
            for j, value in enumerate(row_data):
                # openpyxl dùng chỉ số bắt đầu từ 1 → cột = j+1
                ws.cell(row=start_row + i, column=j + 1, value=value)
        # Sao chép định dạng từ dòng mẫu 
        #mau_row = start_row + ndongchen  # dòng gốc đã bị đẩy xuống
        for row_offset in range(ndongchen):
            for col in range(1, 9):  # copy theo số cột đang có
                new_cell = ws.cell(row=start_row + row_offset + 1, column=col)
                template_cell = ws.cell(row=7, column=col)

                # Sao chép giá trị format
                if template_cell.has_style:
                    new_cell.font = copy(template_cell.font)
                    new_cell.border = copy(template_cell.border)
                    new_cell.fill = copy(template_cell.fill)
                    new_cell.number_format = copy(template_cell.number_format)
                    new_cell.protection = copy(template_cell.protection)
                    new_cell.alignment = copy(template_cell.alignment)

        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:H2")
        row_ngay = start_row + ndongchen + 3
        row_ky  = start_row + ndongchen + 4
        ngayky = self.tao_chuoi_ngay()
        ws[f"F{row_ngay}"] =  ngayky
        ws.merge_cells(f"F{row_ngay}:H{row_ngay}")
        ws[f"A{row_ky}"] = 'Thủ trưởng đơn vị'
        ws.merge_cells(f"A{row_ky}:C{row_ky}")
        ws[f"F{row_ky}"] = 'Người tổng hợp'
        ws.merge_cells(f"F{row_ky}:H{row_ky}")
        
        from openpyxl.styles import Alignment
        from openpyxl.styles import Font
        
        ws["A2"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ngay}"].font = Font(name="Times New Roman", size = 12, italic = True)
        ws[f"F{row_ngay}"].alignment = Alignment(horizontal="center",vertical="center")
        #ws[f"A{row_ky}"] = "Thủ trưởng đơn vị"
        ws[f"A{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"A{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"F{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        for cell in ws[f"A{start_row + ndongchen}":f"H{start_row + ndongchen}"][0]:
            cell.font = Font(name="Times New Roman", size = 12, bold=True)       

        #progress.close()
        
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")        

#------------ BIỂU 08 XÃ ----------------------------------------------------------------------
    def tonghopbieu8xa(self):
        ten_lop = self.dockwidget.cboLayer.currentText()
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ten_xa = self.dockwidget.cboXa.currentText()
        if self.dockwidget.ckbox.isChecked():
            ten_huyen_kq = f"{ten_xa} - {ten_tinh}"
        else:
            ten_huyen_kq = f"{ten_xa} - {ten_huyen} - {ten_tinh}"
        nam_str = self.dockwidget.txtNamdt.text().strip()
        ket_qua ="Biểu 08. " + ten_huyen_kq + ".xlsx"
        
        from datetime import datetime

        nam_hien_tai = datetime.now().year
        if not nam_str.isdigit():
            QMessageBox.warning(self.dockwidget, "Lỗi nhập liệu", "Vui lòng nhập một năm là số nguyên.")
            return

        namdt = int(nam_str)
        nam_hien_tai = datetime.now().year

        # Kiểm tra giới hạn năm
        if namdt < 2015 or namdt > nam_hien_tai:
            QMessageBox.warning(
                self.dockwidget,
                "Năm không hợp lệ",
                f"Năm phải nằm trong khoảng từ 2015 đến {nam_hien_tai}."
            )
            return        
        
        if not ten_lop:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn lớp bản đồ.")
            return

        layer = next((l for l in QgsProject.instance().mapLayers().values() if l.name() == ten_lop), None)
        if not layer:
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy lớp: {ten_lop}")
            return        

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu08.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return
        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        # Đọc dữ liệu từ file JSON đã tạo từ lớp bản đồ
        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file JSON dữ liệu.")
            return

        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            df_rung = pd.DataFrame(json.load(f))
        # Các trường bắt buộc cần có
        required_fields = {"matinh", "tinh", "mahuyen", "huyen","maxa", "xa", "maldlr", "sldlr", "mgolo", "mtnlo", "captuoi", "namtr"}

        # Kiểm tra xem bản ghi đầu tiên có đủ trường không
        if df_rung.empty or not required_fields.issubset(df_rung.columns):
            QMessageBox.critical(
                self.dockwidget,
                "Thiếu trường dữ liệu",
                f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}"
            )
            return

        # Bảng thông báo
        self.elapsed_seconds = 0
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
        #progress.show()
        #QApplication.processEvents()

        ds_maldlr = [41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53]

        # Lọc dữ liệu hợp lệ
        df_rung = df_rung[
            (df_rung["sldlr"].notna()) &
            (df_rung["namtr"].notna()) &
            (df_rung["captuoi"].notna()) &
            (df_rung["dtich"].notna()) &
            (df_rung["maldlr"].isin(ds_maldlr)) &
            (df_rung["tinh"] == ten_tinh) &
            (df_rung["xa"] == ten_xa)
        ]

        # Ép kiểu số
        for col in ["namtr", "captuoi", "mgolo", "mtnlo"]:
            df_rung[col] = pd.to_numeric(df_rung[col], errors="coerce")

        # Tính cấp tuổi
        df_rung["so_nam"] = nam_hien_tai - df_rung["namtr"]
        df_rung["cap_tuoi"] = (df_rung["so_nam"] / df_rung["captuoi"]).apply(
            lambda x: int(x) if x <= int(x) else (int(x) + 1 if int(x) + 1 <= 5 else 5)
        )

        # Giới hạn cấp tuổi 1–5
        df_rung = df_rung[df_rung["cap_tuoi"].between(1, 5)]

        # Tính trữ lượng = mgolo + mtnlo
        df_rung["truluong"] = df_rung["mgolo"] + df_rung["mtnlo"]

        # Tổng hợp theo loài cây và cấp tuổi
        tonghop_truluong = df_rung.groupby(["sldlr", "cap_tuoi"])["truluong"].sum().reset_index()
        tonghop_truluong["truluong"] = tonghop_truluong["truluong"].round(2)

        # Pivot bảng
        pivot = tonghop_truluong.pivot(index="sldlr", columns="cap_tuoi", values="truluong").fillna(0)
        # Đảm bảo luôn có đủ cột cấp tuổi từ 1 đến 5
        for tuoi in [1, 2, 3, 4, 5]:
            if tuoi not in pivot.columns:
                pivot[tuoi] = 0  # thêm cột thiếu và gán giá trị 0

        # Đưa lại thứ tự cột nếu cần
        pivot = pivot[[1, 2, 3, 4, 5]]
        # Thêm cột STT
        pivot.reset_index(inplace=True)
        pivot.insert(0, "STT", range(1, len(pivot) + 1))

        # Thêm cột Tổng (tổng theo dòng)
        pivot.insert(2, "Tổng", pivot.loc[:, [1, 2, 3, 4, 5]].sum(axis=1).round(2))

        # Thêm dòng Tổng cộng cuối cùng
        tong_cac_cot = pivot.drop(columns=["STT", "sldlr"]).sum(numeric_only=True).round(2)
        dong_tong = pd.Series(
            [None, "Tổng cộng"] + tong_cac_cot.tolist(),
            index=pivot.columns
        )
        pivot = pd.concat([pivot, pd.DataFrame([dong_tong])], ignore_index=True)
        so_dong = len(pivot)
        print(pivot)

        
        # Chèn thêm dòng
        ndongchen = 0
        if so_dong > 1:
            ndongchen = so_dong - 1
   
        # Mở tệp Excel
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active

            # Chèn dòng bắt đầu từ dòng 8
            ws.insert_rows(idx=8, amount=ndongchen)
        else:
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active
            print("Không cần chèn thêm dòng vì chỉ có 1 trạng thái.")
        
        # Bỏ header: chuyển pivot sang list các dòng, không bao gồm tên cột
        du_lieu = pivot.values.tolist()

        # Ghi dữ liệu bắt đầu từ dòng 7, cột A (A7)
        start_row = 7
        for i, row_data in enumerate(du_lieu):
            for j, value in enumerate(row_data):
                # openpyxl dùng chỉ số bắt đầu từ 1 → cột = j+1
                ws.cell(row=start_row + i, column=j + 1, value=value)
        # Sao chép định dạng từ dòng mẫu 
        #mau_row = start_row + ndongchen  # dòng gốc đã bị đẩy xuống
        for row_offset in range(ndongchen):
            for col in range(1, 9):  # copy theo số cột đang có
                new_cell = ws.cell(row=start_row + row_offset + 1, column=col)
                template_cell = ws.cell(row=7, column=col)

                # Sao chép giá trị format
                if template_cell.has_style:
                    new_cell.font = copy(template_cell.font)
                    new_cell.border = copy(template_cell.border)
                    new_cell.fill = copy(template_cell.fill)
                    new_cell.number_format = copy(template_cell.number_format)
                    new_cell.protection = copy(template_cell.protection)
                    new_cell.alignment = copy(template_cell.alignment)

        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:H2")
        row_ngay = start_row + ndongchen + 3
        row_ky  = start_row + ndongchen + 4
        ngayky = self.tao_chuoi_ngay()
        ws[f"F{row_ngay}"] =  ngayky
        ws.merge_cells(f"F{row_ngay}:H{row_ngay}")
        ws[f"A{row_ky}"] = 'Thủ trưởng đơn vị'
        ws.merge_cells(f"A{row_ky}:C{row_ky}")
        ws[f"F{row_ky}"] = 'Người tổng hợp'
        ws.merge_cells(f"F{row_ky}:H{row_ky}")
        
        from openpyxl.styles import Alignment
        from openpyxl.styles import Font
        
        ws["A2"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ngay}"].font = Font(name="Times New Roman", size = 12, italic = True)
        ws[f"F{row_ngay}"].alignment = Alignment(horizontal="center",vertical="center")
        #ws[f"A{row_ky}"] = "Thủ trưởng đơn vị"
        ws[f"A{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"A{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"F{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        for cell in ws[f"A{start_row + ndongchen}":f"H{start_row + ndongchen}"][0]:
            cell.font = Font(name="Times New Roman", size = 12, bold=True)       

        #progress.close()
        
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")        

#------------ BIỂU 09 XÃ ----------------------------------------------------------------------
    def tonghopbieu9xa(self):
        ten_lop = self.dockwidget.cboLayer.currentText()
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ten_xa = self.dockwidget.cboXa.currentText()
        if self.dockwidget.ckbox.isChecked():
            ten_huyen_kq = f"{ten_xa} - {ten_tinh}"
        else:
            ten_huyen_kq = f"{ten_xa} - {ten_huyen} - {ten_tinh}"
        nam_str = self.dockwidget.txtNamdt.text().strip()
        ket_qua ="Biểu 09. " + ten_huyen_kq + ".xlsx"
        
        from datetime import datetime

        nam_hien_tai = datetime.now().year
        if not nam_str.isdigit():
            QMessageBox.warning(self.dockwidget, "Lỗi nhập liệu", "Vui lòng nhập một năm là số nguyên.")
            return

        namdt = int(nam_str)
        nam_hien_tai = datetime.now().year

        # Kiểm tra giới hạn năm
        if namdt < 2015 or namdt > nam_hien_tai:
            QMessageBox.warning(
                self.dockwidget,
                "Năm không hợp lệ",
                f"Năm phải nằm trong khoảng từ 2015 đến {nam_hien_tai}."
            )
            return        
        
        if not ten_lop:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn lớp bản đồ.")
            return

        layer = next((l for l in QgsProject.instance().mapLayers().values() if l.name() == ten_lop), None)
        if not layer:
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy lớp: {ten_lop}")
            return        

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu09.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return
        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        # Đọc dữ liệu từ file JSON đã tạo từ lớp bản đồ
        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file JSON dữ liệu.")
            return

        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            df_rung = pd.DataFrame(json.load(f))
        # Các trường bắt buộc cần có
        required_fields = {"matinh", "tinh", "mahuyen", "huyen","maxa", "xa", "maldlr", "sldlr", "mcolo", "captuoi", "namtr"}

        # Kiểm tra xem bản ghi đầu tiên có đủ trường không
        if df_rung.empty or not required_fields.issubset(df_rung.columns):
            QMessageBox.critical(
                self.dockwidget,
                "Thiếu trường dữ liệu",
                f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}"
            )
            return

        # Bảng thông báo
        self.elapsed_seconds = 0
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
        #progress.show()
        #QApplication.processEvents()

        ds_maldlr = [41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53]

        # Lọc dữ liệu đầu vào
        df_rung = df_rung[
            (df_rung["sldlr"].notna()) &
            (df_rung["namtr"].notna()) &
            (df_rung["captuoi"].notna()) &
            (df_rung["dtich"].notna()) &
            (df_rung["maldlr"].isin(ds_maldlr)) &
            (df_rung["tinh"] == ten_tinh) &
            (df_rung["xa"] == ten_xa)
        ]

        # Ép kiểu
        df_rung["namtr"] = pd.to_numeric(df_rung["namtr"], errors="coerce")
        df_rung["captuoi"] = pd.to_numeric(df_rung["captuoi"], errors="coerce")
        df_rung["mcolo"] = pd.to_numeric(df_rung["mcolo"], errors="coerce")

        # Tính cấp tuổi
        df_rung["so_nam"] = nam_hien_tai - df_rung["namtr"]
        df_rung["cap_tuoi"] = (df_rung["so_nam"] / df_rung["captuoi"]).apply(
            lambda x: int(x) if x <= int(x) else (int(x) + 1 if int(x) + 1 <= 5 else 5)
        )

        # Giới hạn cấp tuổi từ 1 đến 5
        df_rung = df_rung[df_rung["cap_tuoi"].between(1, 5)]

        # Tổng hợp theo loài cây và cấp tuổi
        tonghop = df_rung.groupby(["sldlr", "cap_tuoi"])["mcolo"].sum().reset_index()
        tonghop["mcolo"] = tonghop["mcolo"].round(2)

        # Tùy chọn pivot bảng
        # Bước 1: Pivot bảng
        pivot = tonghop.pivot(index="sldlr", columns="cap_tuoi", values="mcolo").fillna(0)
        # Bước 2: Đảm bảo luôn có đủ cột cấp tuổi từ 1 đến 5
        for tuoi in [1, 2, 3, 4, 5]:
            if tuoi not in pivot.columns:
                pivot[tuoi] = 0  # thêm cột thiếu và gán giá trị 0

        # Bước 3: Đưa lại thứ tự cột nếu cần
        pivot = pivot[[1, 2, 3, 4, 5]]
        # Bước 4: Đưa sldlr từ chỉ số về thành cột
        pivot.reset_index(inplace=True)

        # Bước 5: Thêm cột STT ở vị trí đầu
        pivot.insert(0, "STT", range(1, len(pivot) + 1))

        # Bước 6: Tính tổng và chèn cột "Tổng" vào sau "sldlr" (tức vị trí thứ 2)
        # Giả định các cột cấp tuổi là số nguyên 1–5
        pivot.insert(2, "Tổng", pivot.loc[:, [1, 2, 3, 4, 5]].sum(axis=1).round(2))
        # Tính tổng từng cột (bỏ cột STT và sldlr)
        tong_cac_cot = pivot.drop(columns=["STT", "sldlr"]).sum(numeric_only=True).round(2)

        # Tạo dòng mới là một Series
        dong_tong = pd.Series(
            [None, "Tổng cộng"] + tong_cac_cot.tolist(),
            index=pivot.columns
        )

        # Thêm dòng vào cuối bảng
        pivot = pd.concat([pivot, pd.DataFrame([dong_tong])], ignore_index=True)
        so_dong = len(pivot)
        print(pivot)

        
        # Chèn thêm dòng
        ndongchen = 0
        if so_dong > 1:
            ndongchen = so_dong - 1
   
        # Mở tệp Excel
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active

            # Chèn dòng bắt đầu từ dòng 8
            ws.insert_rows(idx=8, amount=ndongchen)
        else:
            wb = openpyxl.load_workbook(path_excel_mau)
            ws = wb.active
            print("Không cần chèn thêm dòng vì chỉ có 1 trạng thái.")
        
        # Bỏ header: chuyển pivot sang list các dòng, không bao gồm tên cột
        du_lieu = pivot.values.tolist()

        # Ghi dữ liệu bắt đầu từ dòng 7, cột A (A7)
        start_row = 7
        for i, row_data in enumerate(du_lieu):
            for j, value in enumerate(row_data):
                # openpyxl dùng chỉ số bắt đầu từ 1 → cột = j+1
                ws.cell(row=start_row + i, column=j + 1, value=value)
        # Sao chép định dạng từ dòng mẫu 
        #mau_row = start_row + ndongchen  # dòng gốc đã bị đẩy xuống
        for row_offset in range(ndongchen):
            for col in range(1, 9):  # copy theo số cột đang có
                new_cell = ws.cell(row=start_row + row_offset + 1, column=col)
                template_cell = ws.cell(row=7, column=col)

                # Sao chép giá trị format
                if template_cell.has_style:
                    new_cell.font = copy(template_cell.font)
                    new_cell.border = copy(template_cell.border)
                    new_cell.fill = copy(template_cell.fill)
                    new_cell.number_format = copy(template_cell.number_format)
                    new_cell.protection = copy(template_cell.protection)
                    new_cell.alignment = copy(template_cell.alignment)

        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:H2")
        row_ngay = start_row + ndongchen + 3
        row_ky  = start_row + ndongchen + 4
        ngayky = self.tao_chuoi_ngay()
        ws[f"F{row_ngay}"] = ngayky
        ws.merge_cells(f"F{row_ngay}:H{row_ngay}")
        ws[f"A{row_ky}"] = 'Thủ trưởng đơn vị'
        ws.merge_cells(f"A{row_ky}:C{row_ky}")
        ws[f"F{row_ky}"] = 'Người tổng hợp'
        ws.merge_cells(f"F{row_ky}:H{row_ky}")
        
        from openpyxl.styles import Alignment
        from openpyxl.styles import Font
        
        ws["A2"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ngay}"].font = Font(name="Times New Roman", size = 12, italic = True)
        ws[f"F{row_ngay}"].alignment = Alignment(horizontal="center",vertical="center")
        #ws[f"A{row_ky}"] = "Thủ trưởng đơn vị"
        ws[f"A{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"A{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        ws[f"F{row_ky}"].font = Font(name="Times New Roman", size = 12, bold = True)
        ws[f"F{row_ky}"].alignment = Alignment(horizontal="center",vertical="center")
        for cell in ws[f"A{start_row + ndongchen}":f"H{start_row + ndongchen}"][0]:
            cell.font = Font(name="Times New Roman", size = 12, bold=True)       

        #progress.close()
        
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")                
#------------ BIỂU 10 XÃ ----------------------------------------------------------------------
    def tonghopbieu10xa(self):
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ten_xa = self.dockwidget.cboXa.currentText()
        if self.dockwidget.ckbox.isChecked():
            ten_huyen_kq = f"{ten_xa} - {ten_tinh}"
        else:
            ten_huyen_kq = f"{ten_xa} - {ten_huyen} - {ten_tinh}"
        ket_qua = f"Biểu 10. {ten_huyen_kq}.xlsx"

        if not ten_tinh:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn tỉnh.")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu10.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return

        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file dữ liệu JSON.")
            return

        # Mở file Excel
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active

        # Đọc dữ liệu từ file JSON
        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)

        required_fields = {"tinh", "maldlr", "mgolo", "mtnlo", "mcolo", "dtich", "malr3"}
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(self.dockwidget, "Thiếu trường", f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}")
            return

        # Bảng thông báo
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
        #progress.show()
        #QApplication.processEvents()
        
        # Hàm tính tổng theo điều kiện
        def tong_tinh2(maldlr_vals, malr3_filter):
            return float(round(sum(
                Decimal(str(round(row["dtich"], 2)))
                for row in data
                if row.get("tinh") == ten_tinh
                and row.get("xa") == ten_xa
                and row.get("maldlr") in maldlr_vals
                and isinstance(row.get("dtich"), (int, float)) and (
                    (isinstance(malr3_filter, int) and row.get("malr3") == malr3_filter) or
                    (isinstance(malr3_filter, tuple) and row.get("malr3") not in malr3_filter)
                )
            ), 2))
        # ====== GHI KẾT QUẢ VÀO EXCEL ========
    # Rừng theo nguồn gốc
        # Rừng tự nhiên 
        maldlr_list = list(range(1, 41))
        n_row = 7
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng trồng 
        maldlr_list = list(range(41, 53))
        n_row = 8
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
    # Rừng theo điều kiện lập địa
        # Rừng trên núi đất
        maldlr_list = sorted(set(range(4, 24)) | {1, 33, 35, 37, 41, 47, 49})
        n_row = 10
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch           
        # Rừng trên núi đá
        maldlr_list = sorted(set(range(24, 29)) | {2, 34, 36, 38, 42, 48, 50})
        n_row = 11
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch  
        # Rừng trên đất ngập nước
        maldlr_list = [3, 29, 30, 31, 39, 43, 44, 45, 51]
        n_row = 12
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng trên cát
        maldlr_list = [32, 40, 46, 52]
        n_row = 13
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
    # Rừng tự nhiên phân theo loài cây
        # Rừng gỗ
        maldlr_list = list(range(1, 33))
        n_row = 15
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng tre nứa
        maldlr_list = [33, 34]
        n_row = 16
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng hỗn giao gỗ và tre nứa
        maldlr_list = [35, 36]
        n_row = 17
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng cau dừa
        maldlr_list = [37, 38, 39, 40]
        n_row = 18
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        
        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:G2")
        ngayky = self.tao_chuoi_ngay() 
        ws["E20"] = ngayky
        ws.merge_cells("E20:G20")        
        #progress.close()
        
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")         
#------------ BIỂU 11 XÃ ----------------------------------------------------------------------
    def tonghopbieu11xa(self):
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ten_xa = self.dockwidget.cboXa.currentText()
        if self.dockwidget.ckbox.isChecked():
            ten_huyen_kq = f"{ten_xa} - {ten_tinh}"
        else:
            ten_huyen_kq = f"{ten_xa} - {ten_huyen} - {ten_tinh}"
        ket_qua = f"Biểu 11. {ten_huyen_kq}.xlsx"

        if not ten_tinh:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn tỉnh.")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu11.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return

        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file dữ liệu JSON.")
            return

        # Mở file Excel
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active

        # Đọc dữ liệu từ file JSON
        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)

        required_fields = {"tinh", "maldlr", "mgolo", "mtnlo", "mcolo", "dtich", "malr3"}
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(self.dockwidget, "Thiếu trường", f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}")
            return

        # Bảng thông báo
       # progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
       # progress.setCancelButton(None)
        #progress.show()
        #QApplication.processEvents()
        
        # Hàm tính tổng theo điều kiện
        def tong_tinh2(maldlr_vals, malr3_filter):
            return float(round(sum(
                Decimal(str(round(row.get("mgolo", 0), 2) + round(row.get("mtnlo", 0), 3)))
                for row in data
                if row.get("tinh") == ten_tinh
                and row.get("xa") == ten_xa
                and row.get("maldlr") in maldlr_vals
                and isinstance(row.get("mgolo"), (int, float))
                and isinstance(row.get("mtnlo"), (int, float)) and (
                    (isinstance(malr3_filter, int) and row.get("malr3") == malr3_filter) or
                    (isinstance(malr3_filter, tuple) and row.get("malr3") not in malr3_filter)
                )
            ), 2))
        # ====== GHI KẾT QUẢ VÀO EXCEL ========
    # Rừng theo nguồn gốc
        # Rừng tự nhiên 
        maldlr_list = list(range(1, 41))
        n_row = 7
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng trồng 
        maldlr_list = list(range(41, 53))
        n_row = 8
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
    # Rừng theo điều kiện lập địa
        # Rừng trên núi đất
        maldlr_list = sorted(set(range(4, 24)) | {1, 33, 35, 37, 41, 47, 49})
        n_row = 10
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch           
        # Rừng trên núi đá
        maldlr_list = sorted(set(range(24, 29)) | {2, 34, 36, 38, 42, 48, 50})
        n_row = 11
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch  
        # Rừng trên đất ngập nước
        maldlr_list = [3, 29, 30, 31, 39, 43, 44, 45, 51]
        n_row = 12
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng trên cát
        maldlr_list = [32, 40, 46, 52]
        n_row = 13
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
    # Rừng tự nhiên phân theo loài cây
        # Rừng gỗ
        maldlr_list = list(range(1, 33))
        n_row = 15
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng tre nứa
        maldlr_list = [33, 34]
        n_row = 16
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng hỗn giao gỗ và tre nứa
        maldlr_list = [35, 36]
        n_row = 17
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng cau dừa
        maldlr_list = [37, 38, 39, 40]
        n_row = 18
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        
        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:G2") 
        ngayky = self.tao_chuoi_ngay() 
        ws["E20"] = ngayky
        ws.merge_cells("E20:G20")        
        #progress.close()
        
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")  
#------------ BIỂU 12 XÃ ----------------------------------------------------------------------
    def tonghopbieu12xa(self):
        ten_tinh = self.dockwidget.cboTinh.currentText()
        ten_huyen = self.dockwidget.cboHuyen.currentText()
        ten_xa = self.dockwidget.cboXa.currentText()
        if self.dockwidget.ckbox.isChecked():
            ten_huyen_kq = f"{ten_xa} - {ten_tinh}"
        else:
            ten_huyen_kq = f"{ten_xa} - {ten_huyen} - {ten_tinh}"
        ket_qua = f"Biểu 12. {ten_huyen_kq}.xlsx"

        if not ten_tinh:
            QMessageBox.warning(self.dockwidget, "Lỗi", "Vui lòng chọn tỉnh.")
            return

        path_excel_mau = os.path.join(os.path.dirname(__file__), "templates", "Bieu12.xlsx")
        if not os.path.exists(path_excel_mau):
            QMessageBox.critical(self.dockwidget, "Lỗi", f"Không tìm thấy file mẫu: {path_excel_mau}")
            return

        path_save, _ = QFileDialog.getSaveFileName(self.dockwidget, "Lưu file tổng hợp", ket_qua, "Excel Files (*.xlsx)")
        if not path_save:
            return

        if not hasattr(self, "duong_dan_json") or not os.path.exists(self.duong_dan_json):
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không tìm thấy file dữ liệu JSON.")
            return

        # Mở file Excel
        wb = openpyxl.load_workbook(path_excel_mau)
        ws = wb.active

        # Đọc dữ liệu từ file JSON
        with open(self.duong_dan_json, "r", encoding="utf-8") as f:
            data = json.load(f)

        required_fields = {"tinh", "maldlr", "mgolo", "mtnlo", "mcolo", "dtich", "malr3"}
        if not data or not required_fields.issubset(data[0].keys()):
            QMessageBox.critical(self.dockwidget, "Thiếu trường", f"Dữ liệu JSON thiếu một hoặc nhiều trường bắt buộc: {', '.join(required_fields)}")
            return

        # Bảng thông báo
        #progress = QProgressDialog("Việc này có thể mất nhiều thời gian, tùy thuộc vào dữ liệu của bạn. Hãy kiên nhẫn đợi!", None, 0, 0, self.dockwidget)
        #progress.setWindowTitle("Đang tổng hợp số liệu...")
        #progress.setWindowModality(Qt.ApplicationModal)
        #progress.setCancelButton(None)
        #progress.show()
        #QApplication.processEvents()
        
        # Hàm tính tổng theo điều kiện
        def tong_tinh2(maldlr_vals, malr3_filter):
            return float(round(sum(
                Decimal(str(round(row["mcolo"], 2)))
                for row in data
                if row.get("tinh") == ten_tinh
                and row.get("xa") == ten_xa
                and row.get("maldlr") in maldlr_vals
                and isinstance(row.get("mcolo"), (int, float)) and (
                    (isinstance(malr3_filter, int) and row.get("malr3") == malr3_filter) or
                    (isinstance(malr3_filter, tuple) and row.get("malr3") not in malr3_filter)
                )
            ), 2))
        # ====== GHI KẾT QUẢ VÀO EXCEL ========
    # Rừng theo nguồn gốc
        # Rừng tự nhiên 
        maldlr_list = list(range(1, 41))
        n_row = 7
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng trồng 
        maldlr_list = list(range(41, 53))
        n_row = 8
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
    # Rừng theo điều kiện lập địa
        # Rừng trên núi đất
        maldlr_list = sorted(set(range(4, 24)) | {1, 33, 35, 37, 41, 47, 49})
        n_row = 10
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch           
        # Rừng trên núi đá
        maldlr_list = sorted(set(range(24, 29)) | {2, 34, 36, 38, 42, 48, 50})
        n_row = 11
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch  
        # Rừng trên đất ngập nước
        maldlr_list = [3, 29, 30, 31, 39, 43, 44, 45, 51]
        n_row = 12
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng trên cát
        maldlr_list = [32, 40, 46, 52]
        n_row = 13
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
    # Rừng tự nhiên phân theo loài cây
        # Rừng gỗ
        maldlr_list = list(range(1, 33))
        n_row = 15
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng tre nứa
        maldlr_list = [33, 34]
        n_row = 16
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng hỗn giao gỗ và tre nứa
        maldlr_list = [35, 36]
        n_row = 17
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        # Rừng cau dừa
        maldlr_list = [37, 38, 39, 40]
        n_row = 18
        ws[f"D{n_row}"] = tong_tinh2(maldlr_list, 2) # Rừng đặc dụng
        ws[f"E{n_row}"] = tong_tinh2(maldlr_list, 1) # Rừng phòng hộ
        ws[f"F{n_row}"] = tong_tinh2(maldlr_list, 3) # Rừng sản xuất
        ws[f"G{n_row}"] = tong_tinh2(maldlr_list, (1, 2, 3)) # Rừng ngoài quy hoạch
        
        # Thêm tên tỉnh vào tiêu đề
        ws["A2"] = f"{ten_huyen_kq}"
        ws.merge_cells("A2:G2") 
        ngayky = self.tao_chuoi_ngay() 
        ws["E20"] = ngayky
        ws.merge_cells("E20:G20")        
        #progress.close()
        
        try:
            wb.save(path_save)
            #QMessageBox.information(self.dockwidget, "Thành công", f"Đã lưu kết quả vào:\n{path_save}")
        except:
            QMessageBox.critical(self.dockwidget, "Lỗi", "Không thể lưu file kết quả.")
                      