# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Tomofast_x
                                 A QGIS plugin
 Supprts Tomofast-x geophysical inversion code
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-04-03
        git sha              : $Format:%H$
        copyright            : (C) 2024 by uwa.edu.au
        email                : mark.jessell@uwa.edu.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.core import (
    Qgis,
    QgsCoordinateReferenceSystem,
    QgsCoordinateTransform,
    QgsVectorLayer,
    QgsProject,
    QgsRasterLayer,
    QgsFeature,
    QgsField,
    QgsVectorFileWriter,
    QgsPoint,
)
from qgis.PyQt.QtCore import (
    QSettings,
    QTranslator,
    QCoreApplication,
    QFileInfo,
    QVariant,
    Qt,
    QUrl,
)
from qgis.core import (
    QgsProject,
    QgsVectorLayer,
    QgsField,
    QgsPointXY,
    QgsGeometry,
    QgsFeature,
    QgsFields,
    QgsRasterLayer,
)
from qgis.core import (
    QgsRendererRangeLabelFormat,
    QgsStyle,
    QgsGraduatedSymbolRenderer,
    QgsClassificationEqualInterval,
    QgsSymbol,
)
from qgis.PyQt.QtWidgets import QDockWidget
from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtGui import QIcon, QDesktopServices
from qgis.PyQt.QtWidgets import QAction, QFileDialog
from qgis.PyQt.QtWidgets import QApplication
from qgis.PyQt.QtCore import Qt

# Qt5/Qt6 Compatibility Layer
try:
    # Try Qt6 style first
    _test = Qt.DockWidgetArea.RightDockWidgetArea
    # Qt6 detected
    QT6 = True

    # Qt6 style enums are already available
    RightDockWidgetArea = Qt.DockWidgetArea.RightDockWidgetArea


except AttributeError:
    # Qt5 detected
    QT6 = False

    # Qt5 style enums
    RightDockWidgetArea = Qt.RightDockWidgetArea


# import functions from scripts
from .Data2Tomofast import Data2Tomofast
from .viz import display_voxet_files_clipped_qgis

import numpy as np
import pandas as pd
from osgeo import gdal
import processing

import os
from pyproj import Transformer
from .ppigrf import igrf, get_inclination_declination
from datetime import datetime
import subprocess
import shlex
import platform
import sys
import shutil
import time
import re

# Initialize Qt resources from file resources.py
from .resources import *

# Import the code for the DockWidget
from .Tomofast_x_dockwidget import Tomofast_xDockWidget
import os.path


class Tomofast_x:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = str(QSettings().value("locale/userLocale"))[0:2]
        locale_path = os.path.join(
            self.plugin_dir, "i18n", "Tomofast_x_{}.qm".format(locale)
        )

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr("&Tomofast_x")
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar("Tomofast_x")
        self.toolbar.setObjectName("Tomofast_x")

        # print "** INITIALIZING Tomofast_x"

        self.pluginIsActive = False
        self.dlg = None

        self.initialise_variables()

    def define_parameters(self):

        #   set up dict with form
        #
        #   key=parfile variable name
        #   values=p[0] variable contents,
        #          p[1] associated widget(s),
        #          p[-2] data type,
        #          p[-1] widget type

        self.d_params = {
            # GLOBAL
            "global.outputFolderPath": [
                self.global_outputFolderPath,
                self.dlg.lineEdit_output_directory_path,
                str,
                "text",
            ],
            "global.description": [
                self.global_description,
                self.dlg.textEdit_experiment_description,
                str,
                "plainText",
            ],
            "global.experimentType": [
                self.global_experimentType,
                self.dlg.radioButton_grav_inv,
                self.dlg.radioButton_magn_inv,
                self.dlg.radioButton_joint_inv,
                int,
                "radio",
            ],
            """"global.elevType": [
                self.global_elevType,
                self.dlg.radioButton_elev_const,
                self.dlg.radioButton_elev_dtm,
                int,
                "radio",
            ],"""
            "global.elevFilename": [
                self.global_elevFilename,
                self.dlg.lineEdit_dtm_path,
                str,
                "text",
            ],
            # DATA Parameters
            "anomalies.grav.data.file": [
                self.filename_grav,
                self.dlg.lineEdit_grav_data_path,
                str,
                "text",
            ],
            "anomalies.magn.data.file": [
                self.filename_magn,
                self.dlg.lineEdit_magn_data_path,
                str,
                "text",
            ],
            "anomalies.grav.proj.in": [
                self.grav_proj_in,
                self.dlg.mQgsProjectionSelectionWidget_grav_in,
                str,
                "epsg",
            ],
            "anomalies.grav.proj.out": [
                self.grav_proj_out,
                self.dlg.mQgsProjectionSelectionWidget_grav_out,
                str,
                "epsg",
            ],
            "anomalies.magn.proj.in": [
                self.magn_proj_in,
                self.dlg.mQgsProjectionSelectionWidget_magn_in,
                str,
                "epsg",
            ],
            "anomalies.magn.proj.out": [
                self.magn_proj_out,
                self.dlg.mQgsProjectionSelectionWidget_magn_out,
                str,
                "epsg",
            ],
            "forward.data.grav.dataGridFile": [
                self.forward_data_grav_dataGridFile,
                "",
                str,
                "path",
            ],
            "forward.data.magn.dataGridFile": [
                self.forward_data_magn_dataGridFile,
                "",
                str,
                "path",
            ],
            """
            "forward.data.grav.dataValuesFile": [
                self.forward_data_grav_dataValuesFile,
                "",
                str,
                "path",
            ],
            "forward.data.magn.dataValuesFile": [
                self.forward_data_magn_dataValuesFile,
                "",
                str,
                "path",
            ],"""
            "modelGrid.size": [
                self.modelGrid_size,
                self.dlg.nx_label,
                self.dlg.ny_label,
                self.dlg.nz_label,
                str,
                "size",
            ],
            "forward.data.grav.nData": [self.forward_data_grav_nData, "", int, "ndata"],
            "forward.data.magn.nData": [self.forward_data_magn_nData, "", int, "ndata"],
            # MODEL GRID parameters
            "anomalies.grav.data_file": [
                self.modelGrid_grav_file,
                self.dlg.lineEdit_grav_data_path,
                str,
                "text",
            ],
            "anomalies.magn.data_file": [
                self.modelGrid_magn_file,
                self.dlg.lineEdit_magn_data_path,
                str,
                "text",
            ],
            # DEPTH WEIGHTING
            "forward.depthWeighting.grav.type": [
                self.forward_depthWeighting_grav_type,
                self.dlg.checkBox_grav_depth_weighting,
                int,
                "check",
            ],
            "forward.depthWeighting.magn.type": [
                self.forward_depthWeighting_magn_type,
                self.dlg.checkBox_magn_depth_weighting,
                int,
                "check",
            ],
            "forward.depthWeighting.grav.power": [
                self.forward_depthWeighting_grav_power,
                self.dlg.mQgsDoubleSpinBox_grav_depth_weight_power,
                float,
                "value",
            ],
            "forward.depthWeighting.magn.power": [
                self.forward_depthWeighting_magn_power,
                self.dlg.mQgsDoubleSpinBox_mag_depth_weighting,
                float,
                "value",
            ],
            # SENSITIVITY KERNEL
            "sensit.readFromFiles": [
                self.sensit_readFromFiles,
                self.dlg.checkBox_read_sens_matrix,
                int,
                "check",
            ],
            # MATRIX COMPRESSION
            "forward.matrixCompression.type": [
                self.forward_matrixCompression_type,
                self.dlg.checkBox_use_compression,
                int,
                "check",
            ],
            "forward.matrixCompression.rate": [
                self.forward_matrixCompression_rate,
                self.dlg.mQgsDoubleSpinBox_compression_ratio,
                float,
                "value",
            ],
            # INVERSION parameters
            "inversion.nMajorIterations": [
                self.inversion_nMajorIterations,
                self.dlg.mQgsSpinBox_major_iters,
                int,
                "value",
            ],
            "inversion.nMinorIterations": [
                self.inversion_nMinorIterations,
                self.dlg.mQgsSpinBox_minor_iters,
                int,
                "value",
            ],
            "inversion.writeModelEveryNiter": [
                self.inversion_writeModelEveryNiter,
                self.dlg.mQgsSpinBox_model_save_iters,
                int,
                "value",
            ],
            # "inversion.minResidual" : [self.inversion_minResidual,self.dlg.textEdit_min_residual,str,'plainText'],
            # MODEL DAMPING (m - m_prior)
            "inversion.modelDamping.grav.weight": [
                self.inversion_modelDamping_grav_weight,
                self.dlg.mQgsDoubleSpinBox_grav_mmodel_damping_weight,
                float,
                "value",
            ],
            "inversion.modelDamping.grav.normPower": [
                self.inversion_modelDamping_grav_normPower,
                self.dlg.mQgsDoubleSpinBox_grav_mmodel_norm_power,
                float,
                "value",
            ],
            "inversion.modelDamping.magn.weight": [
                self.inversion_modelDamping_magn_weight,
                self.dlg.mQgsDoubleSpinBox_grav_mmodel_damping_weight,
                float,
                "value",
            ],
            "inversion.modelDamping.magn.normPower": [
                self.inversion_modelDamping_magn_normPower,
                self.dlg.mQgsDoubleSpinBox_grav_mmodel_norm_power,
                float,
                "value",
            ],
            # JOINT INVERSION parameters
            "inversion.joint.grav.problemWeight": [
                self.inversion_joint_grav_problemWeight,
                self.dlg.mQgsDoubleSpinBox_grav_weight,
                float,
                "value",
            ],
            "inversion.joint.magn.problemWeight": [
                self.inversion_joint_magn_problemWeight,
                self.dlg.mQgsDoubleSpinBox_magn_weight,
                float,
                "value",
            ],
            # ADMM constraints
            "inversion.admm.grav.enableADMM": [
                self.inversion_admm_grav_enableADMM,
                self.dlg.radioButton_grav_depth_based_weighting,
                self.dlg.radioButton_grav_dist_based_weighting,
                int,
                "radio",
            ],
            "inversion.admm.grav.nLithologies": [
                self.inversion_admm_grav_nLithologies,
                self.dlg.spinBox_grav_number_ADMM_litho,
                int,
                "value",
            ],
            "inversion.admm.grav.bounds": [
                self.inversion_admm_grav_bounds,
                self.dlg.textEdit_grav_ADMM_bounds,
                str,
                "plainText",
            ],
            "inversion.admm.grav.weight": [
                self.inversion_admm_grav_weight,
                self.dlg.lineEdit_grav_ADMM_weight,
                str,
                "text",
            ],
            "inversion.admm.magn.enableADMM": [
                self.inversion_admm_magn_enableADMM,
                self.dlg.radioButton_magn_dist_based_weighting,
                self.dlg.radioButton_magn_depth_based_weighting,
                int,
                "radio",
            ],
            "inversion.admm.magn.nLithologies": [
                self.inversion_admm_magn_nLithologies,
                self.dlg.spinBox_magn_ADMM_number_litho,
                int,
                "value",
            ],
            "inversion.admm.magn.bounds": [
                self.inversion_admm_magn_bounds,
                self.dlg.textEdit_5_magn_ADMM_bounds,
                str,
                "plainText",
            ],
            "inversion.admm.magn.weight": [
                self.inversion_admm_magn_weight,
                self.dlg.lineEdit_magn_ADMM_weight,
                str,
                "text",
            ],
            # MULTIPLIERS
            "global.grav.dataUnitsMultiplier": [
                self.global_grav_dataUnitsMultiplier,
                self.dlg.lineEdit_grav_data_multiplier,
                str,
                "text",
            ],
            "global.grav.modelUnitsMultiplier": [
                self.global_grav_modelUnitsMultiplier,
                self.dlg.mQgsDoubleSpinBox_grav_model_multiplier,
                float,
                "value",
            ],
            "global.magn.dataUnitsMultiplier": [
                self.global_magn_dataUnitsMultiplier,
                self.dlg.lineEdit_magn_data_multiplier,
                str,
                "text",
            ],
            "global.grav.sensor_height": [
                self.global_grav_sensor_height,
                self.dlg.doubleSpinBox_grav_sensor_height,
                float,
                "value",
            ],
            "global.magn.sensor_height": [
                self.global_magn_sensor_height,
                self.dlg.doubleSpinBox_magn_sensor_height,
                float,
                "value",
            ],
            # MESH
            "mesh.cellx": [self.cell_x, self.dlg.mQgsSpinBox_mesh_size_x, int, "value"],
            "mesh.celly": [self.cell_y, self.dlg.mQgsSpinBox_mesh_size_y, int, "value"],
            "mesh.cellz": [self.dz, self.dlg.mQgsSpinBox_mesh_size_z, float, "value"],
            "mesh.z.coreDepth": [
                self.z_coreDepth,
                self.dlg.doubleSpinBox_coreDepth,
                float,
                "value",
            ],
            "mesh.z.fullDepth": [
                self.z_fullDepth,
                self.dlg.doubleSpinBox_fullDepth,
                float,
                "value",
            ],
            "mesh.padding": [
                self.padding,
                self.dlg.mQgsSpinBox_mesh_padding,
                int,
                "value",
            ],
            # Mag Field
            "forward.magneticField.declination": [
                self.forward_magneticField_declination,
                self.dlg.doubleSpinBox_mag_dec,
                float,
                "value",
            ],
            "forward.magneticField.inclination": [
                self.forward_magneticField_inclination,
                self.dlg.doubleSpinBox_mag_inc,
                float,
                "value",
            ],
            "forward.magneticField.intensity": [
                self.forward_magneticField_intensity,
                self.dlg.doubleSpinBox_mag_int,
                float,
                "value",
            ],
        }

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate("Tomofast_x", message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None,
    ):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(self.menu, action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ":/plugins/Tomofast_x/icon.png"
        self.add_action(
            icon_path,
            text=self.tr("Tomofast_x"),
            callback=self.run,
            parent=self.iface.mainWindow(),
        )

    # --------------------------------------------------------------------------

    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""

        # print "** CLOSING Tomofast_x"

        # disconnects
        self.dlg.closingPlugin.disconnect(self.onClosePlugin)

        # remove this statement if dockwidget is to remain
        # for reuse if plugin is reopened
        # Commented next statement since it causes QGIS crashe
        # when closing the docked window:
        # self.dlg = None

        self.pluginIsActive = False

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        # print "** UNLOAD Tomofast_x"

        for action in self.actions:
            self.iface.removePluginMenu(self.tr("&Tomofast_x"), action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    # --------------------------------------------------------------------------

    def run(self):
        """Run method that loads and starts the plugin"""

        if not self.pluginIsActive:
            self.pluginIsActive = True

            # print "** STARTING Tomofast_x"

            # dockwidget may not exist if:
            #    first run of plugin
            #    removed on close (see self.onClosePlugin method)
            if self.dlg == None:
                # Create the dockwidget (after translation) and keep reference
                self.dlg = Tomofast_xDockWidget()

            if platform.system() == "Darwin":
                self.dlg.lineEdit_2_mpirunPath_2.setEnabled(True)
                self.dlg.lineEdit_pre_command_2_WSL_Distro.setEnabled(False)
            elif platform.system() == "Windows":
                self.dlg.lineEdit_2_mpirunPath_2.setEnabled(True)
                self.dlg.lineEdit_pre_command_2_WSL_Distro.setEnabled(True)
            else:  # Linux
                self.dlg.lineEdit_2_mpirunPath_2.setEnabled(True)
                self.dlg.lineEdit_pre_command_2_WSL_Distro.setEnabled(False)

            # connect to provide cleanup on closing of dockwidget
            self.dlg.closingPlugin.connect(self.onClosePlugin)

            # show the dockwidget
            # TODO: fix to allow choice of dock location
            self.iface.addDockWidget(RightDockWidgetArea, self.dlg)
            # Find existing dock widgets in the right area
            right_docks = [
                d
                for d in self.iface.mainWindow().findChildren(QDockWidget)
                if self.iface.mainWindow().dockWidgetArea(d) == RightDockWidgetArea
            ]
            # If there are other dock widgets, tab this one with the first one found
            if right_docks:
                for dock in right_docks:
                    if dock != self.dlg:
                        self.iface.mainWindow().tabifyDockWidget(dock, self.dlg)
                        # Optionally, bring your plugin tab to the front
                        self.dlg.raise_()
                        break
            self.dlg.show()
            self.define_tips()
            self.dlg.mQgsProjectionSelectionWidget_grav_in.setCrs(
                QgsCoordinateReferenceSystem("EPSG:4326")
            )
            self.dlg.mQgsProjectionSelectionWidget_grav_out.setCrs(
                QgsCoordinateReferenceSystem("EPSG:4326")
            )
            self.dlg.mQgsProjectionSelectionWidget_magn_in.setCrs(
                QgsCoordinateReferenceSystem("EPSG:4326")
            )
            self.dlg.mQgsProjectionSelectionWidget_magn_out.setCrs(
                QgsCoordinateReferenceSystem("EPSG:4326")
            )

            self.dlg.doubleSpinBox_coreDepth.setEnabled(False)
            self.dlg.doubleSpinBox_fullDepth.setEnabled(False)

            self.dlg.radioButton_magn_inv.setChecked(False)
            self.dlg.pushButton_reset.setEnabled(True)

            self.dlg.pushButton_calc_IGRF.clicked.connect(self.update_mag_field)
            self.dlg.pushButton_load_grav_data.clicked.connect(
                lambda: self.confirm_data_file("grav")
            )
            self.dlg.pushButton_load_magn_data.clicked.connect(
                lambda: self.confirm_data_file("magn")
            )
            self.dlg.pushButton_grav_data_path.clicked.connect(
                lambda: self.select_data_file("grav")
            )
            self.dlg.pushButton_magn_data_path.clicked.connect(
                lambda: self.select_data_file("magn")
            )
            self.dlg.pushButton_assign_grav_fields.clicked.connect(
                self.process_data_fields_grav
            )
            self.dlg.pushButton_assign_magn_fields.clicked.connect(
                self.process_data_fields_magn
            )
            self.dlg.lineEdit_output_directory_path_select.clicked.connect(
                self.select_ouput_directory
            )
            self.dlg.pushButton_select_dtm_path.clicked.connect(self.select_dtm)
            self.dlg.pushButton_param_load_path.clicked.connect(
                self.process_parameter_file
            )
            self.dlg.lineEdit_ROI_path_select.clicked.connect(self.load_ROI)

            self.dlg.radioButton_grav_inv.toggled.connect(self.inversion_type_reset_gui)
            self.dlg.radioButton_magn_inv.toggled.connect(self.inversion_type_reset_gui)
            self.dlg.radioButton_joint_inv.toggled.connect(
                self.inversion_type_reset_gui
            )

            self.dlg.doubleSpinBox_coreDepth.valueChanged.connect(self.mesh_layers)
            self.dlg.doubleSpinBox_fullDepth.valueChanged.connect(self.mesh_layers)

            # updating model grid size
            self.dlg.mQgsSpinBox_mesh_south.valueChanged.connect(
                self.update_model_grid_size
            )
            self.dlg.mQgsSpinBox_mesh_north.valueChanged.connect(
                self.update_model_grid_size
            )
            self.dlg.mQgsSpinBox_mesh_east.valueChanged.connect(
                self.update_model_grid_size
            )
            self.dlg.mQgsSpinBox_mesh_west.valueChanged.connect(
                self.update_model_grid_size
            )
            self.dlg.mQgsSpinBox_mesh_size_x.valueChanged.connect(
                self.update_model_grid_size
            )
            self.dlg.mQgsSpinBox_mesh_size_y.valueChanged.connect(
                self.update_model_grid_size
            )
            self.dlg.mQgsSpinBox_mesh_size_z.valueChanged.connect(
                self.update_model_grid_size
            )
            self.dlg.mQgsSpinBox_mesh_padding.valueChanged.connect(
                self.update_model_grid_size
            )
            self.dlg.mQgsSpinBox_mesh_padding.valueChanged.connect(
                self.update_model_grid_size
            )
            self.dlg.doubleSpinBox_coreDepth.valueChanged.connect(
                self.update_model_grid_size
            )
            self.dlg.doubleSpinBox_fullDepth.valueChanged.connect(
                self.update_model_grid_size
            )

            self.dlg.mQgsDoubleSpinBox_compression_ratio.valueChanged.connect(
                self.update_memory_size
            )
            self.dlg.checkBox_use_compression.toggled.connect(self.update_memory_size)

            self.dlg.pushButton_reset.clicked.connect(self.reset_params)

            self.dlg.pushButton_select_tomoPath.clicked.connect(self.select_tomo_Path)

            self.dlg.pushButton_2_select_parfilePath.clicked.connect(
                self.select_paramfile_path
            )
            self.dlg.pushButton_select_mpirun_mipexec.clicked.connect(
                self.select_mpirunexec_path
            )
            self.dlg.pushButton_select_setvars.clicked.connect(self.select_setvars_path)

            self.dlg.pushButton_3_visualise.clicked.connect(self.visualise_output)
            self.dlg.pushButton_kernel_path_select.clicked.connect(
                self.select_kernel_path
            )

            self.dlg.pushButton_3_runInversion.clicked.connect(self.run_inversion)

            self.dlg.pushButton_3_Export.clicked.connect(self.export_model)
            self.define_parameters()
            self.reset_params()

            if os.path.exists(
                os.path.dirname(os.path.realpath(__file__)) + "/tomoconfig.txt"
            ):
                with open(
                    os.path.dirname(os.path.realpath(__file__)) + "/tomoconfig.txt", "r"
                ) as tpfile:
                    line = tpfile.readline()
                    self.tomo_Path = line.rstrip()
                    self.dlg.lineEdit_tomoPath.setText(self.tomo_Path)

                    line = tpfile.readline()
                    self.dlg.lineEdit_pre_command_2_WSL_Distro.setText(line.rstrip())

                    line = tpfile.readline()

                    line = tpfile.readline()
                    self.dlg.lineEdit_2_mpirunPath_2.setText(line.rstrip())

                    line = tpfile.readline()
                    self.dlg.lineEdit_setvarsPath.setText(line.rstrip())
                    self.setvars_Path = line.rstrip()

            self.dlg.version_label.setText("v " + self.show_version())

            self.dlg.pushButton_plugin_manual.clicked.connect(
                lambda: QDesktopServices.openUrl(
                    QUrl(
                        "https://tectonique.net/tomofast-x-q/Tomofast-x-q%20User%20Manual.pdf"
                    )
                )
            )
            self.dlg.pushButton_tomofast_manual.clicked.connect(
                lambda: QDesktopServices.openUrl(
                    QUrl(
                        "https://github.com/TOMOFAST/Tomofast-x/raw/refs/heads/master/docs/Tomofast-x%20User%20Manual.docx"
                    )
                )
            )

    def select_kernel_path(self):
        self.kernelfiledirectory = QFileDialog.getExistingDirectory(
            None, "Select kernel directory"
        )
        if self.kernelfiledirectory != "":
            self.dlg.lineEdit_kernel_path.setText(self.kernelfiledirectory)

    def visualise_output(self):
        paramPath = self.paramfile_Path
        path, filename = os.path.split(paramPath)
        if os.path.exists(paramPath) and paramPath != "":
            with open(paramPath, "r", encoding="utf-8") as file:
                contents = file.readlines()
                for line in contents:
                    if "global.experimentType" in line:
                        experimentType = line.split("=")[1].strip()
                        break
            if experimentType == "1":
                xfile = path + "/OUTPUT/Paraview/grav_final_model3D_half_x.vtk"
                yfile = path + "/OUTPUT/Paraview/grav_final_model3D_half_y.vtk"
                zfile = path + "/OUTPUT/Paraview/grav_final_model3D_half_z.vtk"
                xyzfiles = [xfile, yfile, zfile]
                display_voxet_files_clipped_qgis(
                    xyzfiles,
                    clip_percentile=95,
                    cmap="jet",
                    opacity=1.0,
                    show_edges=False,
                )
            elif experimentType == "2":
                xfile = path + "/OUTPUT/Paraview/mag_final_model3D_half_x.vtk"
                yfile = path + "/OUTPUT/Paraview/mag_final_model3D_half_y.vtk"
                zfile = path + "/OUTPUT/Paraview/mag_final_model3D_half_z.vtk"
                xyzfiles = [xfile, yfile, zfile]
                display_voxet_files_clipped_qgis(
                    xyzfiles,
                    clip_percentile=95,
                    cmap="jet",
                    opacity=1.0,
                    show_edges=False,
                )
            else:
                xfile = path + "/OUTPUT/Paraview/grav_final_model3D_half_x.vtk"
                yfile = path + "/OUTPUT/Paraview/grav_final_model3D_half_y.vtk"
                zfile = path + "/OUTPUT/Paraview/grav_final_model3D_half_z.vtk"
                xyzfiles = [xfile, yfile, zfile]
                display_voxet_files_clipped_qgis(
                    xyzfiles,
                    clip_percentile=95,
                    cmap="jet",
                    opacity=1.0,
                    show_edges=False,
                )

                xfile = path + "/OUTPUT/Paraview/mag_final_model3D_half_x.vtk"
                yfile = path + "/OUTPUT/Paraview/mag_final_model3D_half_y.vtk"
                zfile = path + "/OUTPUT/Paraview/mag_final_model3D_half_z.vtk"
                xyzfiles = [xfile, yfile, zfile]
                display_voxet_files_clipped_qgis(
                    xyzfiles,
                    clip_percentile=95,
                    cmap="jet",
                    opacity=1.0,
                    show_edges=False,
                )

    def replace_text_in_file(self, file_path, old_text, new_text):
        """
        Replace all occurrences of a specific text in a file with new text.
        """
        try:
            # Try UTF-8 first, fall back to latin-1 if that fails
            try:
                with open(file_path, "r", encoding="utf-8") as file:
                    content = file.read()
            except UnicodeDecodeError:
                with open(file_path, "r", encoding="latin-1") as file:
                    content = file.read()

            # Replace all occurrences of old_text with new_text
            updated_content = content.replace(old_text, new_text)

            # Write back with UTF-8
            with open(file_path, "w", encoding="utf-8") as file:
                file.write(updated_content)

        except FileNotFoundError:
            print(f"File not found: {file_path}")
        except Exception as e:
            print(f"An error occurred: {e}")

    def add_quotes_to_path(self, path):
        return '"' + path + '"'

    def convert_windows_wsl_path_to_linux(self, windows_path, distro):
        """
        Convert a Windows path pointing to WSL filesystem to a Linux path.
        Handles backslash and forward slash WSL path formats.
        Returns the Linux path like /home/user/file
        """
        # Normalize all backslashes to forward slashes
        normalized = windows_path.replace("\\", "/")

        # Build the WSL path prefixes to look for (with various slash combinations)
        prefixes_to_remove = [
            "//wsl.localhost/" + distro,
            "/wsl.localhost/" + distro,
            "//wsl$/" + distro,
            "/wsl$/" + distro,
            "wsl.localhost/" + distro,
            "wsl$/" + distro,
        ]

        # Try to match and remove each prefix
        normalized_lower = normalized.lower()
        for prefix in prefixes_to_remove:
            prefix_lower = prefix.lower()
            if normalized_lower.startswith(prefix_lower):
                # Remove the prefix, keep the rest (which should start with /)
                linux_path = normalized[len(prefix) :]
                # Ensure it starts with /
                if not linux_path.startswith("/"):
                    linux_path = "/" + linux_path
                print(f"Converted WSL path: {windows_path} -> {linux_path}")
                return linux_path

        # If it doesn't match the WSL pattern, return as-is
        print(f"Path not recognized as WSL, returning as-is: {normalized}")
        return normalized

    def run_inversion(self):
        if (
            os.path.exists(self.paramfile_Path)
            and self.paramfile_Path != ""
            and os.path.exists(self.tomo_Path)
            and self.tomo_Path != ""
        ):
            # Check if we're using native Windows mode
            use_native_windows = True
            if platform.system() == "Windows":
                use_native_windows = self.dlg.radioButton_windowsNative.isChecked()

            if platform.system() == "Windows" and use_native_windows:
                # Native Windows mode
                wsl_tomo_path = self.tomo_Path
                wsl_param_path = self.paramfile_Path
                mpiexec_path = (
                    self.dlg.lineEdit_2_mpirunPath_2.text().strip()
                    if hasattr(self.dlg, "lineEdit_2_mpirunPath_2")
                    else r"C:\Program Files (x86)\Intel\oneAPI\mpi\2021.17\bin\mpiexec.exe"
                )
                distro = " "

                # Get paths for VS and Intel oneAPI
                oneapi_path = self.dlg.lineEdit_setvarsPath.text().strip()

            elif platform.system() == "Windows":
                distro = self.dlg.lineEdit_pre_command_2_WSL_Distro.text()
                self.paramfile_Path_run = self.paramfile_Path + "_run"
                shutil.copyfile(self.paramfile_Path, self.paramfile_Path_run)
                drive = self.paramfile_Path_run[0:2]
                self.replace_text_in_file(
                    self.paramfile_Path_run,
                    "= {}:/".format(drive[0]),
                    "= /mnt/{}/".format(drive[0].lower()),
                )

                wsl_path = "//wsl.localhost/" + distro
                wsl_param_path = self.add_quotes_to_path(
                    self.paramfile_Path_run.replace(
                        "{}:/".format(drive[0]), "/mnt/{}/".format(drive[0].lower())
                    )
                )
                # if paramfile stored on linux path, remove wsl access info
                if wsl_path in wsl_param_path:
                    wsl_param_path = wsl_param_path.replace(wsl_path, "")
                    self.replace_text_in_file(
                        self.paramfile_Path_run,
                        wsl_path,
                        "",
                    )
                    print(
                        "Adjusted wsl_param_path for linux stored paramfile - ",
                        wsl_param_path,
                    )

                distro = self.dlg.lineEdit_pre_command_2_WSL_Distro.text()
                wsl_path = "//wsl.localhost/" + distro

                wsl_tomo_path = self.add_quotes_to_path(
                    self.tomo_Path.replace(wsl_path, "")
                )
                mpirun_path = " mpirun "

                # Replace spaces with escaped spaces for WSL
                wsl_param_path = wsl_param_path.replace('"', "")

            elif platform.system() == "Darwin":
                wsl_tomo_path = self.tomo_Path
                wsl_param_path = self.paramfile_Path
                mpirun_path = self.dlg.lineEdit_2_mpirunPath_2.text().strip()
                distro = " "

            else:
                wsl_tomo_path = self.tomo_Path
                wsl_param_path = self.paramfile_Path
                mpirun_path = self.dlg.lineEdit_2_mpirunPath_2.text().strip()
                distro = " "

            if os.path.exists(self.tomo_Path) and self.tomo_Path != "":
                self.dlg.lineEdit_tomoPath.setText(self.tomo_Path)
                with open(
                    os.path.dirname(os.path.realpath(__file__)) + "/tomoconfig.txt",
                    "w",
                ) as tpfile:
                    tpfile.write(self.tomo_Path + "\n")
                    tpfile.write(distro + "\n")
                    tpfile.write("\n")
                    if platform.system() == "Windows" and use_native_windows:
                        tpfile.write(mpiexec_path + "\n")
                    else:
                        tpfile.write(mpirun_path + "\n")
                    tpfile.write(self.dlg.lineEdit_setvarsPath.text().strip() + "\n")

            noProc = self.dlg.mQgsSpinBox_noProc.value()

            # set system/version dependent "start_new_session" analogs
            kwargs = {}
            if platform.system() == "Windows":
                CREATE_NEW_PROCESS_GROUP = 0x00000200
                DETACHED_PROCESS = 0x00000008
                kwargs.update(creationflags=DETACHED_PROCESS | CREATE_NEW_PROCESS_GROUP)
            elif sys.version_info < (3, 2):
                kwargs.update(preexec_fn=os.setsid)
            else:
                kwargs.update(start_new_session=True)

            try:
                debug_path = wsl_param_path.replace('"', "") + "_debug.txt"

                print("noProc - ", noProc)
                print("tomo_path - ", wsl_tomo_path)
                print("param_path - ", wsl_param_path)
                print("debug_path - ", debug_path)

                if platform.system() == "Windows" and use_native_windows:
                    # Native Windows mode - create a batch file to set up environment and run
                    print("mpiexec_path - ", mpiexec_path)
                    print("oneapi_path - ", oneapi_path)

                    # Escape any forward slashes to backslashes for Windows batch
                    oneapi_path_bat = oneapi_path.replace("/", "\\")
                    tomo_path_bat = wsl_tomo_path.replace("/", "\\")
                    param_path_bat = wsl_param_path.replace("/", "\\")
                    debug_path_bat = debug_path.replace("/", "\\")

                    batch_content = """@echo off
                setlocal

                """
                    # Build the command based on number of processors
                    if noProc == 1:
                        run_command = f'"{tomo_path_bat}" -p "{param_path_bat}"'
                    else:
                        run_command = f'"{mpiexec_path}" -n {noProc} "{tomo_path_bat}" -p "{param_path_bat}"'

                    batch_content += f"""


                call "{oneapi_path_bat}"
                if errorlevel 1 (
                    echo Failed to set up Intel oneAPI environment
                    pause
                    exit /b 1
                )

                echo Environment setup complete
                echo Running TomoFast-x...

                {run_command} > "{debug_path_bat}" 2>&1

                echo.
                echo Process completed. Press any key to close...
                pause >nul
                endlocal
                """
                    # Write the batch file
                    batch_file_path = os.path.join(
                        os.path.dirname(self.paramfile_Path), "run_tomofastx.bat"
                    )
                    with open(batch_file_path, "w") as batch_file:
                        batch_file.write(batch_content)

                    print(f"Created batch file: {batch_file_path}")

                    # Run the batch file in a new console window
                    command = f'start "TomoFast-x Process" cmd /c "{batch_file_path}"'
                    print("command: ", command)

                    process = subprocess.Popen(
                        command,
                        shell=True,
                        **kwargs,
                    )

                elif platform.system() == "Windows":
                    wsl_debug_path = wsl_param_path.replace('"', "") + "_debug.txt"

                    print("mpirun_path - ", mpirun_path)
                    print("noProc - ", noProc)
                    print("wsl_tomo_path - ", wsl_tomo_path)
                    print("wsl_param_path - ", wsl_param_path)
                    print("wsl_debug_path - ", wsl_debug_path)

                    # Build the actual command
                    if noProc == 1:
                        base_command = f"'{wsl_tomo_path}' -p '{wsl_param_path}' 2>&1 | tee '{wsl_debug_path}'"
                    else:
                        base_command = f"{mpirun_path} -np {str(noProc)} '{wsl_tomo_path}' -j '{wsl_param_path}' 2>&1 | tee '{wsl_debug_path}'"

                    # Use a simpler approach - let bash handle it
                    if platform.system() == "Windows":
                        command = f'start "TomoFast-x Process" wsl bash -c "{base_command}; echo; echo Press any key to close...; read -n1"'
                        print("command: ", command)
                        process = subprocess.Popen(
                            command,
                            shell=True,
                            **kwargs,
                        )
                else:
                    # Unix/macOS
                    print("mpirun_path - ", mpirun_path)

                    if noProc == 1:
                        command = f"'{wsl_tomo_path}' -p '{wsl_param_path}' 2>&1 | tee '{debug_path}'"
                    else:
                        command = f"{mpirun_path} -np {str(noProc)} '{wsl_tomo_path}' -j '{wsl_param_path}' 2>&1 | tee '{debug_path}'"

                    print("command: ", command)
                    env = os.environ.copy()

                    process = subprocess.Popen(
                        command,
                        shell=True,
                        env=env,
                        **kwargs,
                    )

                self.iface.messageBar().pushMessage(
                    f"Process started with PID: {process.pid}",
                    "Command is running in the background ",
                    level=Qgis.Success,
                    duration=45,
                )
            except Exception as e:
                print(f"An error occurred: {e}")
        else:
            self.iface.messageBar().pushMessage(
                f"Paths to tomofastx and paramfile must be defined",
                level=Qgis.Warning,
                duration=15,
            )

    # =================================================================================
    def add_elevation(self, elevation, elevType, df_elev):
        """
        Adds constant elevation to data.
        """
        if elevType == 1:
            # Line 1175 - FIXED:
            self.data2tomofast.df["POINT_Z"] = (
                np.zeros(self.data2tomofast.df["POINT_X"].values.shape) - elevation
            )
        else:
            # self.df["POINT_Z"] = -df_elev["POINT_Z"]
            # Function to safely extract numeric value from QVariant or a normal type
            def get_numeric_value(val):
                if isinstance(val, QVariant):
                    if val.isValid() and not val.isNull():
                        # Extracting the value as a double (returns a tuple, so we grab the first element)
                        return (
                            val.toDouble()[0]
                            if isinstance(val.toDouble()[0], (int, float))
                            else np.nan
                        )
                elif isinstance(val, (int, float)):
                    return val
                return np.nan

            # Apply the function to the column to convert all values to their negative
            self.data2tomofast.df["POINT_Z"] = (
                -df_elev["POINT_Z"].apply(get_numeric_value) - elevation
            )

    def run_inversion_old(self):
        if (
            os.path.exists(self.paramfile_Path)
            and self.paramfile_Path != ""
            and os.path.exists(self.tomo_Path)
            and self.tomo_Path != ""
        ):
            if platform.system() == "Windows":
                distro = self.dlg.lineEdit_pre_command_2_WSL_Distro.text()
                self.paramfile_Path_run = self.paramfile_Path + "_run"
                shutil.copyfile(self.paramfile_Path, self.paramfile_Path_run)
                drive = self.paramfile_Path_run[0:2]
                self.replace_text_in_file(
                    self.paramfile_Path_run,
                    self.wsl_path_backslash,
                    "= {}:/".format(drive[0]),
                    "= /mnt/{}/".format(drive[0].lower()),
                )

                wsl_path = "//wsl.localhost/" + distro
                wsl_param_path = self.add_quotes_to_path(
                    self.paramfile_Path_run.replace(
                        "{}:/".format(drive[0]), "/mnt/{}/".format(drive[0].lower())
                    )
                )
                # if paramfile stored on linux path, remove wsl access info
                if wsl_path in wsl_param_path:
                    wsl_param_path = wsl_param_path.replace(wsl_path, "")
                    self.replace_text_in_file(
                        self.paramfile_Path_run,
                        wsl_path,
                        "",
                    )
                    print(
                        "Adjusted wsl_param_path for linux stored paramfile - ",
                        wsl_param_path,
                    )

                distro = self.dlg.lineEdit_pre_command_2_WSL_Distro.text()
                wsl_path = "//wsl.localhost/" + distro

                wsl_tomo_path = self.add_quotes_to_path(
                    self.tomo_path_normalized.replace(wsl_path, "")
                )
                mpirun_path = " mpirun "

                # Replace spaces with escaped spaces for WSL
                wsl_param_path = wsl_param_path.replace('"', "")

            elif platform.system() == "Darwin":
                wsl_tomo_path = self.tomo_Path
                wsl_param_path = self.paramfile_Path
                mpirun_path = self.dlg.lineEdit_2_mpirunPath_2.text().strip()

                distro = " "

            else:
                wsl_tomo_path = self.tomo_Path
                wsl_param_path = self.paramfile_Path
                mpirun_path = self.dlg.lineEdit_2_mpirunPath_2.text().strip()
                distro = " "

            if os.path.exists(self.tomo_Path) and self.tomo_Path != "":
                self.dlg.lineEdit_tomoPath.setText(self.tomo_Path)
                with open(
                    os.path.dirname(os.path.realpath(__file__)) + "/tomoconfig.txt",
                    "w",
                ) as tpfile:
                    tpfile.write(self.tomo_Path + "\n")
                    tpfile.write(distro + "\n")
                    tpfile.write("\n")
                    tpfile.write(mpirun_path + "\n")

            noProc = self.dlg.mQgsSpinBox_noProc.value()

            # set system/version dependent "start_new_session" analogs
            kwargs = {}
            if platform.system() == "Windows":
                # from msdn [1]
                CREATE_NEW_PROCESS_GROUP = (
                    0x00000200  # note: could get it from subprocess
                )
                DETACHED_PROCESS = 0x00000008  # 0x8 | 0x200 == 0x208
                kwargs.update(creationflags=DETACHED_PROCESS | CREATE_NEW_PROCESS_GROUP)
            elif sys.version_info < (3, 2):  # assume posix
                kwargs.update(preexec_fn=os.setsid)
            else:  # Python 3.2+ and Unix
                kwargs.update(start_new_session=True)

            try:

                wsl_debug_path = wsl_param_path.replace('"', "") + "_debug.txt"

                print("mpirun_path - ", mpirun_path)
                print("noProc - ", noProc)
                print("wsl_tomo_path - ", wsl_tomo_path)
                print("wsl_param_path - ", wsl_param_path)
                print("wsl_debug_path - ", wsl_debug_path)

                # Build the actual command
                if noProc == 1:
                    base_command = f"'{wsl_tomo_path}' -p '{wsl_param_path}' 2>&1 | tee '{wsl_debug_path}'"
                else:
                    base_command = f"{mpirun_path} -np {str(noProc)} '{wsl_tomo_path}' -j '{wsl_param_path}' 2>&1 | tee '{wsl_debug_path}'"

                # Use a simpler approach - let bash handle it
                if platform.system() == "Windows":
                    command = f'start "TomoFast-x Process" wsl bash -c "{base_command}; echo; echo Press any key to close...; read -n1"'
                    print("command: ", command)
                    process = subprocess.Popen(
                        command,
                        shell=True,
                        **kwargs,
                    )
                else:  # Python 3.2+ and Unix
                    command = base_command

                    print("command: ", command)
                    env = os.environ.copy()  # Get the full environment

                    process = subprocess.Popen(
                        command,
                        shell=True,
                        env=env,  # Pass the full environment
                        **kwargs,
                    )

                # Print the process ID for tracking
                self.iface.messageBar().pushMessage(
                    f"Process started with PID: {process.pid}",
                    "Command is running in the background ",
                    level=Qgis.Success,
                    duration=45,
                )
            except Exception as e:
                print(f"An error occurred: {e}")
        else:
            self.iface.messageBar().pushMessage(
                f"Paths to tomofastx and paramfile must be defined",
                level=Qgis.Warning,
                duration=15,
            )

    def select_tomo_Path(self):

        self.tomo_Path, _filter = QFileDialog.getOpenFileName(
            None,
            "Select tomofast executable",
            ".",
            # "CSV (*.csv;*.CSV);;GRD (*.GRD;*.grd);;TIF (*.TIF;*.tif;*.TIFF;*.tiff)",
            "All (*)",
        )
        if os.path.exists(self.tomo_Path) and self.tomo_Path != "":
            self.dlg.lineEdit_tomoPath.setText(self.tomo_Path)

    def select_paramfile_path(self):

        self.paramfile_Path, _filter = QFileDialog.getOpenFileName(
            None,
            "Select tomofast paramfile",
            ".",
            # "CSV (*.csv;*.CSV);;GRD (*.GRD;*.grd);;TIF (*.TIF;*.tif;*.TIFF;*.tiff)",
            "All (*.*)",
        )
        if os.path.exists(self.paramfile_Path) and self.paramfile_Path != "":
            self.dlg.lineEdit_2_parfilePath.setText(self.paramfile_Path)

    def select_mpirunexec_path(self):

        self.mpi_runexec_path, _filter = QFileDialog.getOpenFileName(
            None,
            "Select mpirun or mpiexec.exe path",
            ".",
            "All (*.*)",
        )
        if os.path.exists(self.mpi_runexec_path) and self.mpi_runexec_path != "":
            self.dlg.lineEdit_2_mpirunPath_2.setText(self.mpi_runexec_path)

    def select_setvars_path(self):

        self.setvars_Path, _filter = QFileDialog.getOpenFileName(
            None,
            "Select tomofast paramfile",
            ".",
            "BAT (*.bat;*.BAT)",
        )
        if os.path.exists(self.setvars_Path) and self.setvars_Path != "":
            self.dlg.lineEdit_setvarsPath.setText(self.setvars_Path)

    # load and parse existing paramfiel and set gui widgets accordingly
    def process_parameter_file(self):

        self.select_parfile()
        if self.parfilename != "" and os.path.exists(self.parfilename):
            self.load_parfile()
            self.enable_boxes()
            self.parse_parameters()

            self.iface.messageBar().pushMessage(
                "Parfile loaded ", "OK ", level=Qgis.Success, duration=45
            )

    # select existing parfile
    def select_parfile(self):

        self.parfilename, _filter = QFileDialog.getOpenFileName(
            None, "Select Parameter File", ".", "TXT (*.txt)"
        )
        self.dlg.lineEdit_param_load_path.setText(self.parfilename)

    # select existing ROI shapefile
    def load_ROI(self):

        self.ROIFileName, _filter = QFileDialog.getOpenFileName(
            None, "Select ROI File", ".", "SHP (*.shp)"
        )
        self.dlg.lineEdit_ROI_path.setText(self.ROIFileName)
        layer = QgsVectorLayer(self.ROIFileName, "ROI", "ogr")
        if layer.isValid():
            if self.global_experimentType == 1 or self.global_experimentType == 3:
                proj = self.grav_proj_out
            else:
                proj = self.magn_proj_out

            parameter = {
                "INPUT": layer,
                "TARGET_CRS": proj,
                "OUTPUT": "memory:{}_Reprojected".format("ROI"),
            }
            result = processing.run("native:reprojectlayer", parameter)["OUTPUT"]

            QgsProject.instance().addMapLayer(result)

            # Use the coordinates of the bounding box as limits of mesh (without padding)
            self.data_extents(result)

    def select_data_file(self, dataType):

        filename, _filter = QFileDialog.getOpenFileName(
            None,
            "Select Data File",
            ".",
            # "CSV (*.csv;*.CSV);;GRD (*.GRD;*.grd);;TIF (*.TIF;*.tif;*.TIFF;*.tiff)",
            "Point/grid (*.csv *.CSV *.TIF *.tif *.TIFF *.tiff *.ERS *.ers)",
        )
        if os.path.exists(filename) and filename != "":
            if dataType == "grav":
                self.dlg.lineEdit_grav_data_path.setText(filename)
                self.dlg.pushButton_load_grav_data.setEnabled(True)
                self.filename_grav = filename

                if filename.split(".")[-1].lower() == "csv":
                    self.dlg.mQgsProjectionSelectionWidget_grav_in.setEnabled(True)
                    self.dlg.mQgsProjectionSelectionWidget_grav_out.setEnabled(True)

            else:
                self.dlg.lineEdit_magn_data_path.setText(filename)
                self.dlg.pushButton_load_magn_data.setEnabled(True)
                self.filename_magn = filename
                if filename.split(".")[-1].lower() == "csv":
                    self.dlg.mQgsProjectionSelectionWidget_magn_in.setEnabled(True)
                    self.dlg.mQgsProjectionSelectionWidget_magn_out.setEnabled(True)

    # select existing point or raster magn data
    def select_dtm(self):
        self.dtm_filename, _filter = QFileDialog.getOpenFileName(
            None, "Select DTM File", ".", "TIFF (*.tif)"
        )

        self.dlg.lineEdit_dtm_path.setText(self.dtm_filename)

        if self.dtm_filename != "" and os.path.exists(self.dtm_filename):
            self.load_dtm()
            self.global_elevFilename = self.dtm_filename
            self.global_elevType = 2

    # process input grav data and update gui to allow next stage of data to be defined
    def confirm_data_file(self, dataType):
        self.process_data_file()
        if dataType == "grav":
            suffix = self.dlg.lineEdit_grav_data_path.text().split(".")[-1]
        else:
            suffix = self.dlg.lineEdit_magn_data_path.text().split(".")[-1]

        if suffix.lower() == "csv":
            self.global_dataType = "points"
            if dataType == "grav":
                self.grav_proj_in = (
                    self.dlg.mQgsProjectionSelectionWidget_grav_in.crs().authid()
                )
                self.grav_proj_out = (
                    self.dlg.mQgsProjectionSelectionWidget_grav_out.crs().authid()
                )
                suffix = self.dlg.lineEdit_grav_data_path.text().split(".")[-1]
            else:
                self.magn_proj_in = (
                    self.dlg.mQgsProjectionSelectionWidget_magn_in.crs().authid()
                )
                self.magn_proj_out = (
                    self.dlg.mQgsProjectionSelectionWidget_magn_out.crs().authid()
                )
                suffix = self.dlg.lineEdit_magn_data_path.text().split(".")[-1]
        else:
            self.global_dataType = "raster"
            if dataType == "grav":
                suffix = self.dlg.lineEdit_grav_data_path.text().split(".")[-1]
            else:
                suffix = self.dlg.lineEdit_magn_data_path.text().split(".")[-1]

        # enable GroupBox 9
        if self.global_dataType == "points":
            self.dlg.groupBox_9.setEnabled(True)
            self.dlg.label_44.setEnabled(True)
            self.dlg.label_45.setEnabled(True)
            self.dlg.label_47.setEnabled(True)
            if dataType == "grav":
                self.dlg.comboBox_grav_field_x.setEnabled(True)
                self.dlg.comboBox_grav_field_y.setEnabled(True)
                self.dlg.comboBox_grav_field_data.setEnabled(True)
                self.dlg.pushButton_assign_grav_fields.setEnabled(True)
            else:
                self.dlg.comboBox_magn_field_x.setEnabled(True)
                self.dlg.comboBox_magn_field_y.setEnabled(True)
                self.dlg.comboBox_magn_field_data.setEnabled(True)
                self.dlg.pushButton_assign_magn_fields.setEnabled(True)

            self.dlg.pushButton_select_dtm_path.setEnabled(False)
        else:
            self.dlg.groupBox_2.setEnabled(True)
            self.dlg.groupBox_9.setEnabled(True)
            self.dlg.lineEdit_dtm_path.setEnabled(False)
            self.dlg.pushButton_select_dtm_path.setEnabled(False)

            self.update_widgets()

    def process_data_fields_grav(self):
        self.update_widgets()
        self.load_csv_vector_grav(
            self.filename_grav, self.xcol_grav, self.ycol_grav, self.datacol_grav
        )

    # process load magn data, update gui and display as layer
    def process_data_fields_magn(self):
        self.update_widgets()
        self.load_csv_vector_magn(
            self.filename_magn, self.xcol_magn, self.ycol_magn, self.datacol_magn
        )

    # estimate mag field from centroid of data, date and sensor height
    def update_mag_field(self):

        # retrieve parameters
        self.magn_SurveyHeight = self.dlg.doubleSpinBox_magn_sensor_height.value()
        date_text = str(self.dlg.dateEdit.date().toPyDate())

        date_split = date_text.split("-")
        self.magn_SurveyDay = date_split[2]
        self.magn_SurveyMonth = date_split[1]
        self.magn_SurveyYear = date_split[0]
        date = datetime(2021, 3, 28)

        # calculate midpoint of mesh
        midx = self.meshBox["west"] + (
            (self.meshBox["east"] - self.meshBox["west"]) / 2.0
        )
        midy = self.meshBox["south"] + (
            (self.meshBox["north"] - self.meshBox["south"]) / 2.0
        )

        # convert midpoint to lat/long
        magn_proj = int(self.magn_proj_out.split(":")[1])

        proj = Transformer.from_crs(magn_proj, 4326, always_xy=True)
        x, y = (midx, midy)
        long, lat = proj.transform(x, y)

        # calculate IGRF compnents and  convert to Inc, Dec, Int
        Be, Bn, Bu = igrf(
            long, lat, self.magn_SurveyHeight, date
        )  # returns east, north, up
        (
            self.forward_magneticField_inclination,
            self.forward_magneticField_declination,
        ) = get_inclination_declination(Be, Bn, Bu, degrees=True)
        self.forward_magneticField_intensity = np.sqrt(Be**2 + Bn**2 + Bu**2)

        # update widgets
        self.dlg.doubleSpinBox_mag_dec.setValue(
            self.forward_magneticField_declination.item()
        )
        self.dlg.doubleSpinBox_mag_inc.setValue(
            self.forward_magneticField_inclination.item()
        )
        self.dlg.doubleSpinBox_mag_int.setValue(
            self.forward_magneticField_intensity.item()
        )

    # enable gui widgets after data loaded
    def update_widgets(self):

        if self.global_experimentType == 1 or self.global_experimentType == 3:

            self.xcol_grav = self.dlg.comboBox_grav_field_x.currentText()
            self.ycol_grav = self.dlg.comboBox_grav_field_y.currentText()
            self.datacol_grav = self.dlg.comboBox_grav_field_data.currentText()

            # enable GroupBox 2
            self.dlg.groupBox_2.setEnabled(True)
            self.dlg.groupBox_9.setEnabled(True)
            self.dlg.lineEdit_dtm_path.setEnabled(False)
            self.dlg.pushButton_select_dtm_path.setEnabled(True)

            # enable GroupBox 3
            self.dlg.groupBox_3.setEnabled(True)
            self.dlg.lineEdit_output_directory_path.setEnabled(True)
            self.dlg.lineEdit_output_directory_path_select.setEnabled(True)
            self.dlg.lineEdit_ROI_path_select.setEnabled(True)
        if self.global_experimentType == 2 or self.global_experimentType == 3:
            self.xcol_magn = self.dlg.comboBox_magn_field_x.currentText()
            self.ycol_magn = self.dlg.comboBox_magn_field_y.currentText()
            self.datacol_magn = self.dlg.comboBox_magn_field_data.currentText()

            # enable GroupBox 2
            self.dlg.groupBox_2.setEnabled(True)
            self.dlg.groupBox_10.setEnabled(True)
            self.dlg.lineEdit_dtm_path.setEnabled(True)
            self.dlg.pushButton_select_dtm_path.setEnabled(True)

            # enable GroupBox 3
            self.dlg.groupBox_3.setEnabled(True)
            self.dlg.lineEdit_output_directory_path.setEnabled(True)
            self.dlg.lineEdit_output_directory_path_select.setEnabled(True)
            self.dlg.lineEdit_ROI_path_select.setEnabled(True)

        self.dlg.doubleSpinBox_coreDepth.setEnabled(True)
        self.dlg.doubleSpinBox_fullDepth.setEnabled(True)
        self.dlg.mQgsDoubleSpinBox_compression_ratio.setEnabled(True)

    # process load grav point data and display as layer
    def load_csv_vector_grav(self, data_file_path, xcol_grav, ycol_grav, datacol_grav):

        fileInfo = QFileInfo(data_file_path)
        baseName = fileInfo.baseName()

        layer = QgsVectorLayer(
            "file:///"
            + data_file_path
            + "?crs={}&xField={}&yField={}".format(
                self.grav_proj_in, xcol_grav, ycol_grav
            ),
            baseName,
            "delimitedtext",
        )
        suffix = "_grav"
        target_crs = self.grav_proj_out
        if layer.isValid():
            parameter = {
                "INPUT": layer,
                "TARGET_CRS": target_crs,
                "OUTPUT": "memory:{}_Reprojected".format(baseName + suffix),
            }
            result = processing.run("native:reprojectlayer", parameter)["OUTPUT"]
            crs = layer.crs()
            crs.createFromId(int(target_crs.split(":")[1]))
            QgsProject.instance().addMapLayer(result)
            result.setCrs(crs)
            result.renderer().symbol().setSize(0.25)
            self.colour_points(result, datacol_grav, "Spectral", True)
            result.triggerRepaint()
            self.nData = result.featureCount()
            # Use the coordinates of the bounding box as limits of mesh (without padding)
            self.data_extents(result)

        else:
            self.iface.messageBar().pushMessage(
                "Invalid grav layer", level=Qgis.Warning, duration=15
            )

    # process load magn point data and display as layer
    def load_csv_vector_magn(self, data_file_path, xcol, ycol, datacol_magn):

        fileInfo = QFileInfo(self.filename_magn)
        baseName = fileInfo.baseName()
        layer = QgsVectorLayer(
            "file:///"
            + data_file_path
            + "?crs={}&xField={}&yField={}".format(self.magn_proj_in, xcol, ycol),
            baseName,
            "delimitedtext",
        )
        suffix = "_magn"
        target_crs = self.magn_proj_out
        if layer.isValid():
            parameter = {
                "INPUT": layer,
                "TARGET_CRS": target_crs,
                "OUTPUT": "memory:{}_Reprojected".format(baseName + suffix),
            }
            result = processing.run("native:reprojectlayer", parameter)["OUTPUT"]
            crs = layer.crs()
            crs.createFromId(int(target_crs.split(":")[1]))
            result.setCrs(crs)
            result.renderer().symbol().setSize(0.25)
            QgsProject.instance().addMapLayer(result)
            self.colour_points(result, datacol_magn, "Spectral", True)
            result.triggerRepaint()
            self.nData = result.featureCount()

            # Use the coordinates of the bounding box as limits of mesh (without padding)
            self.data_extents(result)

        else:
            self.iface.messageBar().pushMessage(
                "Invalid magn layer", level=Qgis.Warning, duration=15
            )

    # calc data extends and update widget
    def data_extents(self, layer):
        extent = layer.extent()  # Get the extent (bounding box) of the layer

        # Use the coordinates of the bounding box as limits of mesh (without padding)

        self.dlg.mQgsSpinBox_mesh_south.setValue(int(extent.yMinimum()))
        self.dlg.mQgsSpinBox_mesh_north.setValue(int(extent.yMaximum()))
        self.dlg.mQgsSpinBox_mesh_west.setValue(int(extent.xMinimum()))
        self.dlg.mQgsSpinBox_mesh_east.setValue(int(extent.xMaximum()))

        self.meshBox = {
            "south": int(extent.yMinimum()),
            "west": int(extent.xMinimum()),
            "north": int(extent.yMaximum()),
            "east": int(extent.xMaximum()),
        }

    # rearrange layers so points ontop of rasters
    def rearrange(self):
        from collections import OrderedDict

        root = QgsProject.instance().layerTreeRoot()
        LayerNamesEnumDict = lambda listCh: {
            listCh[q[0]].name() + str(q[0]): q[1] for q in enumerate(listCh)
        }

        mLNED = LayerNamesEnumDict(root.children())
        mLNEDkeys = OrderedDict(
            sorted(LayerNamesEnumDict(root.children()).items())
        ).keys()

        mLNEDsorted = [mLNED[k].clone() for k in mLNEDkeys]
        root.insertChildNodes(0, mLNEDsorted)
        for n in mLNED.values():
            root.removeChildNode(n)

    # load top layer of mesh and display as points layer
    def load_mesh_vector(self):
        df = pd.read_csv(
            self.global_outputFolderPath + "/model_grid.txt",
            sep=" ",
            skiprows=1,
            header=None,
            nrows=self.data2tomofast.nx * self.data2tomofast.ny,
        )
        df[0] = (df[0] + df[1]) / 2.0
        df[2] = (df[2] + df[3]) / 2.0
        df = df.drop(axis=1, columns=[1, 3, 4, 5, 6, 7, 8])  # removed data column

        temp = QgsVectorLayer("Point", "model_grid", "memory")
        temp_data = temp.dataProvider()
        # Start of the edition
        temp.startEditing()

        # Creation of my fields
        for head in df:
            myField = QgsField(str(head), QVariant.Double)
            temp.addAttribute(myField)
        # Update
        temp.updateFields()

        # Addition of features
        # [1] because i don't want the indexes
        for row in df.itertuples():
            f = QgsFeature()
            f.setAttributes([row[1], row[2]])
            f.setGeometry(QgsPoint(row[1], row[2]))
            temp.addFeature(f)

        # saving changes and adding the layer
        temp.commitChanges()
        if self.global_experimentType == 1 or self.global_experimentType == 3:
            crs = QgsCoordinateReferenceSystem(self.grav_proj_out)
        else:
            crs = QgsCoordinateReferenceSystem(self.magn_proj_out)

        temp.setCrs(crs)
        temp.renderer().symbol().setSize(0.25)

        temp.commitChanges()

        QgsProject.instance().addMapLayer(temp)
        if self.global_elevType == 2:
            self.sample_elevation()

    # extract dtm values based on mesh locaitons
    def sample_elevation(self):
        mesh = QgsProject.instance().mapLayersByName("model_grid")[0]
        dtm = QgsProject.instance().mapLayersByName("Reprojected DTM")[0]

        parameter = {
            "INPUT": mesh,
            "RASTERCOPY": dtm,
            "COLUMN_PREFIX": "elevation",
            "OUTPUT": "TEMPORARY_OUTPUT",
        }
        processing.runAndLoadResults("native:rastersampling", parameter)

        elev = QgsProject.instance().mapLayersByName("Sampled")[0]
        elev.setName("elevation_grid")
        elev.renderer().symbol().setSize(0.25)

        self.rename_dp_field(elev, "0", "x")
        self.rename_dp_field(elev, "2", "y")
        self.rename_dp_field(elev, "elevation1", "elevation")

        self.colour_points(elev, "elevation", "Greys", True)

        # Start an edit session
        elev.startEditing()

        # Get the index of the field to be modified (e.g., 'Log MS')
        field_index = elev.fields().indexOf("elevation")
        noneFlag = False
        # Iterate over the features and set the negative values
        for feature in elev.getFeatures():
            original_value = feature[field_index]

            if original_value is not None:
                negative_value = -original_value
            else:
                negative_value = 0
                noneFlag = True
            # Update the field with the negative value
            elev.changeAttributeValue(feature.id(), field_index, negative_value)

        elev.commitChanges()

        QgsVectorFileWriter.writeAsVectorFormat(
            elev,
            self.global_outputFolderPath + "/elevation_grid.csv",
            "utf-8",
            driverName="CSV",
        )

        self.iface.messageBar().pushMessage(
            "The DTM does not cover the full extent of the mesh includiing padding.",
            "Outside elevations set to zero",
            level=Qgis.Warning,
            duration=45,
        )

    # rename layer field name
    def rename_dp_field(self, rlayer, oldname, newname):
        findex = rlayer.dataProvider().fieldNameIndex(oldname)
        if findex != -1:
            rlayer.dataProvider().renameAttributes({findex: newname})
            rlayer.updateFields()

    # load raster dtm and siplay
    def load_dtm(self):
        if self.global_experimentType == 1 or self.global_experimentType == 3:
            proj_in = self.grav_proj_in
            proj_out = self.grav_proj_out
        else:
            proj_in = self.magn_proj_in
            proj_out = self.magn_proj_out

        fileInfo = QFileInfo(self.dtm_filename)
        baseName = fileInfo.baseName()
        layer = QgsRasterLayer(self.dtm_filename, baseName)

        if layer.isValid():

            parameter = {
                "INPUT": self.dtm_filename,
                "SOURCE_CRS": QgsCoordinateReferenceSystem(proj_in),
                "TARGET_CRS": QgsCoordinateReferenceSystem(proj_out),
                "RESAMPLING": 0,
                "NODATA": None,
                "TARGET_RESOLUTION": None,
                "OPTIONS": "",
                "DATA_TYPE": 0,
                "TARGET_EXTENT": None,
                "TARGET_EXTENT_CRS": None,
                "MULTITHREADING": False,
                "EXTRA": "",
                "OUTPUT": "TEMPORARY_OUTPUT",
            }

            result = processing.runAndLoadResults("gdal:warpreproject", parameter)

            temppath = result["OUTPUT"]
            gd = gdal.Open(temppath)
            self.dtm_array = gd.ReadAsArray()
            layers = QgsProject.instance().mapLayersByName("Reprojected")
            layers[0].setName("Reprojected DTM")
            self.rearrange()
        else:
            self.iface.messageBar().pushMessage(
                "invalid layer",
                "file:///" + self.dtm_filename,
                level=Qgis.Warning,
                duration=45,
            )

    # load data
    def process_data_file(self):
        if self.global_experimentType == 1:
            filename = self.dlg.lineEdit_grav_data_path.text()
            paths = os.path.split(filename)
            self.global_dataNameGrav = "".join(paths[1].split(".")[:-1])
        elif self.global_experimentType == 2:
            filename = self.dlg.lineEdit_magn_data_path.text()
            paths = os.path.split(filename)
            self.global_dataNameMagn = "".join(paths[1].split(".")[:-1])
        else:
            filename = self.dlg.lineEdit_grav_data_path.text()
            paths = os.path.split(filename)
            self.global_dataNameGrav = "".join(paths[1].split(".")[:-1])

            filename = self.dlg.lineEdit_magn_data_path.text()
            paths = os.path.split(filename)
            self.global_dataNameMagn = "".join(paths[1].split(".")[:-1])

        suffix = paths[1].split(".")[-1]

        if suffix.lower() == "csv":
            self.data = pd.read_csv(filename)

            if self.global_experimentType == 1 or self.global_experimentType == 3:
                self.dlg.comboBox_grav_field_x.addItems(self.data.columns)
                self.dlg.comboBox_grav_field_y.addItems(self.data.columns)
                self.dlg.comboBox_grav_field_y.setCurrentIndex(1)

                self.dlg.comboBox_grav_field_data.addItems(self.data.columns)
                self.dlg.comboBox_grav_field_data.setCurrentIndex(2)
                self.input_data_grav = filename

            if self.global_experimentType == 2 or self.global_experimentType == 3:
                self.dlg.comboBox_magn_field_x.addItems(self.data.columns)
                self.dlg.comboBox_magn_field_y.addItems(self.data.columns)
                self.dlg.comboBox_magn_field_y.setCurrentIndex(1)

                self.dlg.comboBox_magn_field_data.addItems(self.data.columns)
                self.dlg.comboBox_magn_field_data.setCurrentIndex(2)
                self.input_data_magn = filename

            self.global_dataType = "points"

        elif (
            suffix.lower() == "tif"
            or suffix.lower() == "tiff"
            or suffix.lower() == "ers"
        ):
            # Load the TIFF file as a QgsRasterLayer
            self.data_raster_layer = QgsRasterLayer(filename, "data")
            extent = self.data_raster_layer.extent()

            proj = self.data_raster_layer.crs().authid()

            if self.global_experimentType == 1 or self.global_experimentType == 3:
                self.grav_proj_in = proj
                self.grav_proj_out = proj
            elif self.global_experimentType == 2:
                self.magn_proj_in = proj
                self.magn_proj_out = proj
            else:
                self.grav_proj_in = proj
                self.grav_proj_out = proj
                self.magn_proj_in = proj
                self.magn_proj_out = proj

            minx = extent.xMinimum()
            miny = extent.yMinimum()
            maxx = extent.xMaximum()
            maxy = extent.yMaximum()

            self.dlg.mQgsSpinBox_mesh_south.setValue(int(miny))
            self.dlg.mQgsSpinBox_mesh_north.setValue(int(maxy))
            self.dlg.mQgsSpinBox_mesh_west.setValue(int(minx))
            self.dlg.mQgsSpinBox_mesh_east.setValue(int(maxx))

            self.meshBox = {
                "south": int(miny),
                "west": int(minx),
                "north": int(maxy),
                "east": int(maxx),
            }

            # Check if the layer was loaded successfully
            if not self.data_raster_layer.isValid():
                print("Failed to load the raster layer!")
            else:
                # Add the raster layer to the QGIS project
                QgsProject.instance().addMapLayer(self.data_raster_layer)
                self.update_model_grid_size()

            self.global_dataType = "raster"

    # select directory to store intermediate and final products
    def select_ouput_directory(self):
        self.global_outputFolderPath = QFileDialog.getExistingDirectory(
            None, "Select output path for your Tomofast-x input files"
        )

        self.dlg.lineEdit_output_directory_path.setText(self.global_outputFolderPath)
        if self.global_outputFolderPath:
            if os.path.exists(self.global_outputFolderPath):
                self.output_directory = os.path.split(
                    self.dlg.lineEdit_output_directory_path.text()
                )[-1]

                # try:
                result = self.save_outputs()
                if result:

                    self.iface.messageBar().pushMessage(
                        "Files saved to ",
                        self.dlg.lineEdit_output_directory_path.text(),
                        "Directory",
                        level=Qgis.Success,
                        duration=15,
                    )
                    self.update_memory_size()
                    self.save_parameter_file()
                """except:
                    self.iface.messageBar().pushMessage(
                        "Error saving files",
                        "Please check your input data and try again.",
                        level=Qgis.Warning,
                        duration=45,
                    )"""

    # calculate mesh and add topographic info before saveing out again
    def save_outputs(self):
        if (
            (self.global_experimentType == 2 or self.global_experimentType == 3)
            and self.forward_magneticField_declination == 0.0
            and self.forward_magneticField_inclination == -45.0
            and self.forward_magneticField_intensity == 65000.0
        ):
            self.iface.messageBar().pushMessage(
                f"Please define Magnetic Field Parameters",
                level=Qgis.Warning,
                duration=30,
            )
            return False

        self.setupMesh()

        if self.global_experimentType == 1:
            self.dlg.mQgsDoubleSpinBox_grav_weight.setValue(1.0)
            self.dlg.mQgsDoubleSpinBox_magn_weight.setValue(0.0)
        elif self.global_experimentType == 2:
            self.dlg.mQgsDoubleSpinBox_grav_weight.setValue(0.0)
            self.dlg.mQgsDoubleSpinBox_magn_weight.setValue(1.0)

        if self.global_dataType == "points":
            self.convert_point_data(self.global_dataType)
        else:
            if self.global_experimentType == 1:
                self.convert_raster_data(
                    self.dlg.lineEdit_grav_data_path.text(), self.grav_proj_out, 1
                )
                self.convert_point_data(self.global_dataType)

            elif self.global_experimentType == 2:
                self.convert_raster_data(
                    self.dlg.lineEdit_magn_data_path.text(), self.magn_proj_out, 2
                )
                self.convert_point_data(self.global_dataType)

            else:
                self.convert_raster_data(
                    self.dlg.lineEdit_grav_data_path.text(), self.grav_proj_out, 1
                )
                self.convert_point_data(self.global_dataType)
                self.convert_raster_data(
                    self.dlg.lineEdit_magn_data_path.text(), self.magn_proj_out, 2
                )
                self.convert_point_data(self.global_dataType)

        self.load_mesh_vector()
        if self.global_elevType == 2:
            mean_elevation = self.data2tomofast.add_topography(
                self.global_outputFolderPath + "/model_grid.txt",
                self.global_outputFolderPath + "/elevation_grid.csv",
            )
        else:
            mean_elevation = 0

        self.tidy_layers()

        return True

    def tidy_data(self, temp_file_path1, fileName1, dataName1):
        # Read the file manually, skipping the first line, and saving it as temporary CSV

        with open(fileName1, "r") as f:
            lines = f.readlines()[1:]  # Skip the first line

        with open(temp_file_path1, "w") as temp_file:

            temp_file.writelines(f"x y height {dataName1}\n")
            temp_file.writelines(lines)
            temp_file.flush()
            temp_file.close()

        temp_data = pd.read_csv(
            temp_file_path1,
            na_values=["", " "],
            delim_whitespace=True,  # Handles whitespace-separated data
        )
        temp_data = temp_data.dropna()
        data_len = len(temp_data)
        if self.global_experimentType == 1:
            self.forward_data_grav_nData = data_len
        else:
            self.forward_data_magn_nData = data_len

        time.sleep(5)
        temp_data.to_csv(temp_file_path1, sep=" ", index=False)

        with open(fileName1, "w") as temp_file:

            temp_file.writelines(f"{data_len}\n")
            temp_file.flush()
            temp_file.close()

        temp_data.to_csv(f"{fileName1}", sep=" ", header=False, index=False, mode="a")

    # close temp layers, load reprojected layers and update project crs
    def tidy_layers(self):
        # reset project CRS
        """if self.global_experimentType == 1 or self.global_experimentType == 3:
            QgsProject.instance().setCrs(
                QgsCoordinateReferenceSystem(self.grav_proj_out)
            )
        else:
            QgsProject.instance().setCrs(
                QgsCoordinateReferenceSystem(self.magn_proj_out)
            )

        # close temp layers
        if self.global_dataType == "points":
            if self.global_elevType == 1:
                layers = []
            else:
                layers = ["elevation_grid"]

        else:
            if self.global_elevType == 1:
                layers = ["Extracted Data"]
            else:
                layers = ["Extracted Data", "elevation_grid"]

        for layer in layers:
            layer = QgsProject.instance().mapLayersByName(layer)[0]
            if layer.isValid():
                QgsProject.instance().removeMapLayer(layer)"""

        if self.global_dataType != "points":
            # open reprojected data layers
            xcol = "POINT_X"
            ycol = "POINT_Y"

            if self.global_experimentType == 1:
                fileName1 = self.global_outputFolderPath + "/data_grav.csv"
                proj1 = self.grav_proj_out
                dataName1 = "grav_data"
            elif self.global_experimentType == 2:
                fileName1 = self.global_outputFolderPath + "/data_magn.csv"
                proj1 = self.magn_proj_out
                dataName1 = "magn_data"
            elif (
                self.global_experimentType == 3
            ):  # need to add NaN removable for this case
                fileName1 = self.global_outputFolderPath + "/data_grav.csv"
                proj1 = self.grav_proj_out
                dataName1 = "grav_data"
                fileName2 = self.global_outputFolderPath + "/data_magn.csv"
                dataName2 = "magn_data"

            temp_file_path1 = self.global_outputFolderPath + "/data_temp.csv"

            self.tidy_data(temp_file_path1, fileName1, dataName1)

            # Define the URI to load the CSV with specified geometry fields and no header
            # uri = f"file://{temp_file_path1}?type=csv&xField=x&yField=y&detectTypes=no&geomType=Point&spatialIndex=no&crs={proj1}"
            uri = f"file:///{temp_file_path1}?type=csv&delimiter=,%20&quote=&escape=&maxFields=10000&detectTypes=yes&xField=x&yField=y&spatialIndex=no&subsetIndex=no&watchFile=no&crs={proj1}"

            # Load the layer as a point layer
            layer = QgsVectorLayer(uri, dataName1, "delimitedtext")

            if layer.isValid():
                QgsProject.instance().addMapLayer(layer)

                # Check if renderer and symbol exist before modifying
                renderer = layer.renderer()
                if renderer is not None:
                    symbol = renderer.symbol()
                    if symbol is not None:
                        symbol.setSize(0.125)
                self.colour_points(layer, dataName1, "Rocket", False)
                layer.triggerRepaint()

            else:
                print("Failed to load layer.")

            if self.global_experimentType == 3:
                self.tidy_data(temp_file_path1, fileName2, dataName2)

                uri = f"file:///{temp_file_path1}?type=csv&delimiter=,%20&quote=&xField=x&yField=y&detectTypes=no&geomType=Point&spatialIndex=no&crs={proj1}"

                layer = QgsVectorLayer(uri, dataName2, "delimitedtext")

                if layer.isValid():
                    QgsProject.instance().addMapLayer(layer)

                    # Check if the renderer exists and is of correct type before modifying
                    renderer = layer.renderer()
                    if (
                        renderer
                        and hasattr(renderer, "symbol")
                        and callable(getattr(renderer, "symbol", None))
                    ):
                        # For single symbol renderer
                        symbol = renderer.symbol()
                        if symbol:
                            symbol.setSize(0.125)
                    else:
                        # Either create a new renderer or handle different renderer types
                        # For example, creating a new single symbol renderer:
                        symbol = QgsMarkerSymbol.createSimple(
                            {"name": "circle", "size": "0.125"}
                        )
                        layer.setRenderer(QgsSingleSymbolRenderer(symbol))

                    self.colour_points(layer, dataName2, "Mako", False)
                    layer.triggerRepaint()

                else:
                    print("Failed to load layer.")

        self.iface.mapCanvas().refresh()

    # get mesh parameters from gui
    def setupMesh(self):
        self.cell_x = self.dlg.mQgsSpinBox_mesh_size_x.value()
        self.cell_y = self.dlg.mQgsSpinBox_mesh_size_y.value()
        self.padding = self.dlg.mQgsSpinBox_mesh_padding.value()

        self.dz = self.dlg.mQgsSpinBox_mesh_size_z.value()

        self.data2tomofast = Data2Tomofast(None)
        """self.grav_proj_in = (
            self.dlg.mQgsProjectionSelectionWidget_grav_in.crs().authid()
        )
        self.grav_proj_out = (
            self.dlg.mQgsProjectionSelectionWidget_grav_out.crs().authid()
        )
        self.magn_proj_in = (
            self.dlg.mQgsProjectionSelectionWidget_magn_in.crs().authid()
        )
        self.magn_proj_out = (
            self.dlg.mQgsProjectionSelectionWidget_magn_out.crs().authid()
        )"""
        self.meshBox = {
            "south": self.dlg.mQgsSpinBox_mesh_south.value(),
            "west": self.dlg.mQgsSpinBox_mesh_west.value(),
            "north": self.dlg.mQgsSpinBox_mesh_north.value(),
            "east": self.dlg.mQgsSpinBox_mesh_east.value(),
            "core_depth": self.dlg.doubleSpinBox_coreDepth.value(),
            "full_depth": self.dlg.doubleSpinBox_fullDepth.value(),
        }

        self.global_grav_sensor_height = (
            self.dlg.doubleSpinBox_grav_sensor_height.value()
        )
        self.global_magn_sensor_height = (
            self.dlg.doubleSpinBox_magn_sensor_height.value()
        )

    def in_ROI(self, x, y, meshBox):
        """
        Check if the point (x, y) is within the defined mesh box.
        """
        return (
            meshBox["west"] <= x <= meshBox["east"]
            and meshBox["south"] <= y <= meshBox["north"]
        )

    # convert raster data into points based on mesh locations
    def convert_raster_data(self, filename, proj_out, dataType):

        # define  and update raster parameters
        if dataType == 1:
            self.datacol_grav = "data"
            self.filename_grav = self.global_outputFolderPath + "/data_grav.csv"
            reprojDataName = "/reproj_data_grav.tif"
            reprojPoints = "/reproj_data_grav.csv"
        else:
            self.datacol_magn = "data"
            self.filename_magn = self.global_outputFolderPath + "/data_magn.csv"
            reprojDataName = "/reproj_data_magn.tif"
            reprojPoints = "/reproj_data_magn.csv"

        self.setupMesh()

        meshBoxOffset = {
            "south": int(self.meshBox["south"]),
            "west": int(self.meshBox["west"]),
            "north": int(self.meshBox["north"]),
            "east": int(self.meshBox["east"]),
            "core_depth": self.dlg.doubleSpinBox_coreDepth.value(),
            "full_depth": self.dlg.doubleSpinBox_fullDepth.value(),
        }

        # write out mesh
        self.data2tomofast.write_model_grid(
            self.padding,
            self.cell_x,
            self.cell_y,
            self.dz,
            meshBoxOffset,
            self.global_outputFolderPath,
        )

        # read in top layer of mesh
        df = pd.read_csv(
            self.global_outputFolderPath + "/model_grid.txt",
            sep=" ",
            skiprows=1,
            header=None,
            nrows=self.data2tomofast.nx * self.data2tomofast.ny,
            names=["x1", "x2", "y1", "y2", "z1", "z2,", "value", "i", "j", "k"],
        )

        # Create an empty memory layer (point geometry type, with a CRS, e.g., EPSG:4326)

        mesh_layer = QgsVectorLayer(f"Point", "Extracted Data", "memory")

        new_crs = QgsCoordinateReferenceSystem(proj_out)
        mesh_layer.setCrs(new_crs)

        # Get the data provider for the layer
        provider = mesh_layer.dataProvider()

        # Define the fields (attributes) for the layer
        fields = QgsFields()
        fields.append(QgsField("id", QVariant.Int))

        # Add the fields to the provider
        provider.addAttributes(fields)
        mesh_layer.updateFields()

        # Loop over the DataFrame rows to create features and add them to the layer
        for idx, row in df.iterrows():
            # Create a new feature
            feature = QgsFeature()

            # Set the geometry (Point) for the feature
            x = row["x1"] - ((row["x1"] - row["x2"]) / 2.0)
            y = row["y1"] - ((row["y1"] - row["y2"]) / 2.0)
            if self.in_ROI(x, y, self.meshBox):
                point = QgsPointXY(x, y)

                feature.setGeometry(QgsGeometry.fromPointXY(point))

                # Add the feature to the layer
                provider.addFeature(feature)

        # Update the layer's extent
        mesh_layer.updateExtents()

        # Add the layer to the QGIS project
        QgsProject.instance().addMapLayer(mesh_layer)

        data_layer = QgsProject.instance().mapLayersByName("data")[0]

        # reproject raster data
        parameter = {
            "INPUT": filename,
            "SOURCE_CRS": data_layer.crs(),
            "TARGET_CRS": QgsCoordinateReferenceSystem(proj_out),
            "RESAMPLING": 0,
            "NODATA": None,
            "TARGET_RESOLUTION": None,
            "OPTIONS": "",
            "DATA_TYPE": 0,
            "TARGET_EXTENT": None,
            "TARGET_EXTENT_CRS": None,
            "MULTITHREADING": False,
            "EXTRA": "",
            "OUTPUT": self.global_outputFolderPath + reprojDataName,
        }
        # Run the processing algorithm
        processing.run("gdal:warpreproject", parameter)

        # sample raster data based on mesh locations
        parameter = {
            "INPUT": mesh_layer,
            "RASTERCOPY": self.global_outputFolderPath + reprojDataName,
            "COLUMN_PREFIX": "data",
            "OUTPUT": "memory:",
        }
        # Get the layer ID from runAndLoadResults
        layer_id = processing.runAndLoadResults("native:rastersampling", parameter)[
            "OUTPUT"
        ]

        # Get the actual layer object from the ID
        new_data_layer = QgsProject.instance().mapLayer(layer_id)

        # convert layer to dataframe
        data = []
        # Extract the fields (attributes) names
        fields = [field.name() for field in new_data_layer.fields()]
        fields.append("POINT_X")
        fields.append("POINT_Y")
        # Loop through features in the layer
        for feature in new_data_layer.getFeatures():
            # Extract attribute values
            attributes = feature.attributes()
            geometry = feature.geometry()
            point = geometry.asPoint()
            attributes.append(point.x())
            attributes.append(point.y())
            # Add attributes and geometry to the data list
            data.append(attributes)

        # Create a pandas DataFrame
        data_df = pd.DataFrame(data, columns=fields)

        # Only drop columns if they exist in the dataframe
        if "fid" in data_df.columns:
            data_df = data_df.drop(columns=["fid"])
        if "id" in data_df.columns:
            data_df = data_df.drop(columns=["id"])

        new_column_order = ["POINT_X", "POINT_Y", "data1"]
        data_df = data_df[new_column_order]
        QgsProject.instance().removeMapLayer(new_data_layer)

        # save out extracted data as same format as points data
        data_df.to_csv(self.global_outputFolderPath + reprojPoints, index=False)

    # convert point data to tomofast format
    def convert_point_data(self, dataFormat):
        # add elevation to data
        if self.global_experimentType == 1:  # grav
            if dataFormat == "points":
                self.data2tomofast.read_data(
                    self.filename_grav,
                    self.ycol_grav,
                    self.xcol_grav,
                    self.datacol_grav,
                    self.grav_proj_in,
                    self.grav_proj_out,
                )
            else:
                self.data2tomofast.read_data(
                    self.global_outputFolderPath + "/reproj_data_grav.csv",
                    "POINT_Y",
                    "POINT_X",
                    "data1",
                    self.grav_proj_out,
                    self.grav_proj_out,
                )
                self.datacol_grav = "data1"
            if self.global_elevType == 1:  # const elev

                self.add_elevation(
                    self.global_grav_sensor_height, self.global_elevType, 0
                )
            else:  # dtm
                self.add_dtm(1)
                self.add_elevation(
                    self.global_grav_sensor_height, self.global_elevType, self.data_df
                )
            self.data2tomofast.write_data_tomofast(
                self.datacol_grav, self.global_outputFolderPath, 1
            )

        elif self.global_experimentType == 2:  # mag
            if dataFormat == "points":
                self.data2tomofast.read_data(
                    self.filename_magn,
                    self.ycol_magn,
                    self.xcol_magn,
                    self.datacol_magn,
                    self.magn_proj_in,
                    self.magn_proj_out,
                )
            else:
                self.data2tomofast.read_data(
                    self.global_outputFolderPath + "/reproj_data_magn.csv",
                    "POINT_Y",
                    "POINT_X",
                    "data1",
                    self.magn_proj_out,
                    self.magn_proj_out,
                )
                self.datacol_magn = "data1"
            if self.global_elevType == 1:
                self.add_elevation(
                    self.global_magn_sensor_height, self.global_elevType, 0
                )
            else:
                self.add_dtm(2)
                self.add_elevation(
                    self.global_magn_sensor_height, self.global_elevType, self.data_df
                )
            self.data2tomofast.write_data_tomofast(
                self.datacol_magn, self.global_outputFolderPath, 2
            )
        else:  # grav and mag
            if dataFormat == "points":
                self.data2tomofast.read_data(
                    self.filename_grav,
                    self.ycol_grav,
                    self.xcol_grav,
                    self.datacol_grav,
                    self.grav_proj_in,
                    self.grav_proj_out,
                )
            else:
                self.data2tomofast.read_data(
                    self.global_outputFolderPath + "/reproj_data_grav.csv",
                    "POINT_Y",
                    "POINT_X",
                    "data1",
                    self.grav_proj_out,
                    self.grav_proj_out,
                )
                self.datacol_grav = "data1"
            if self.global_elevType == 1:  # const elev
                self.add_elevation(
                    self.global_grav_sensor_height, self.global_elevType, 0
                )
            else:  # dtm
                self.add_dtm(1)
                self.add_elevation(
                    self.global_grav_sensor_height, self.global_elevType, self.data_df
                )
            self.data2tomofast.write_data_tomofast(
                self.datacol_grav, self.global_outputFolderPath, 1
            )

            if dataFormat == "points":
                self.data2tomofast.read_data(
                    self.filename_magn,
                    self.ycol_magn,
                    self.xcol_magn,
                    self.datacol_magn,
                    self.magn_proj_in,
                    self.magn_proj_out,
                )
            else:
                self.data2tomofast.read_data(
                    self.global_outputFolderPath + "/reproj_data_magn.csv",
                    "POINT_Y",
                    "POINT_X",
                    "data1",
                    self.magn_proj_out,
                    self.magn_proj_out,
                )
                self.datacol_magn = "data1"
            if self.global_elevType == 1:
                self.add_elevation(
                    self.global_magn_sensor_height, self.global_elevType, 0
                )
            else:
                self.add_dtm(1)
                self.add_elevation(
                    self.global_magn_sensor_height, self.global_elevType, self.data_df
                )
            self.data2tomofast.write_data_tomofast(
                self.datacol_magn, self.global_outputFolderPath, 2
            )

        if dataFormat == "points":
            self.data2tomofast.write_model_grid(
                self.padding,
                self.cell_x,
                self.cell_y,
                self.dz,
                self.meshBox,
                self.global_outputFolderPath,
            )

        self.dlg.nx_label.setText(str(self.data2tomofast.nx))
        self.dlg.ny_label.setText(str(self.data2tomofast.ny))
        self.dlg.nz_label.setText(str(self.data2tomofast.nz))

        if self.global_experimentType == 1 or self.global_experimentType == 3:
            self.forward_data_grav_nData = self.data2tomofast.nData
        if self.global_experimentType == 2 or self.global_experimentType == 3:
            self.forward_data_magn_nData = self.data2tomofast.nData

    def update_model_grid_size(self):
        self.setupMesh()
        if (
            self.cell_x == 0
            or self.cell_y == 0
            or int(self.dlg.mQgsSpinBox_mesh_size_z.value()) == 0
        ):
            return
        nx = int(
            (self.meshBox["east"] - self.meshBox["west"] + (2 * self.padding))
            / self.cell_x
        )
        ny = int(
            (self.meshBox["north"] - self.meshBox["south"] + (2 * self.padding))
            / self.cell_y
        )

        ncore = int(
            float(self.dlg.doubleSpinBox_coreDepth.value())
            / float(self.dlg.mQgsSpinBox_mesh_size_z.value())
        )

        try:
            npad = int(
                np.log(
                    float(
                        self.dlg.doubleSpinBox_fullDepth.value()
                        - float(self.dlg.doubleSpinBox_coreDepth.value())
                    )
                    / (float(self.dlg.mQgsSpinBox_mesh_size_z.value()))
                )
                / np.log(1.15)
            )
        except:
            npad = 0
        nz = ncore + npad

        self.dlg.nx_label.setText(str(nx))
        self.dlg.ny_label.setText(str(ny))
        self.dlg.nz_label.setText(str(nz))

        data_nx = int((self.meshBox["east"] - self.meshBox["west"]) / self.cell_x)
        data_ny = int((self.meshBox["north"] - self.meshBox["south"]) / self.cell_y)
        self.update_ideal_compression_ratio(data_nx, data_ny, nz)
        self.update_memory_size()

    def update_ideal_compression_ratio(self, nx, ny, nz):
        # Assumes Haar wavelet
        # From Bruce et al. 2025 in prep.
        if nx * ny * nz > 0:
            ideal_cr = 35.07 * (0.01**-0.872) * ((nx * ny * nz) ** -0.884)
            self.dlg.mQgsDoubleSpinBox_compression_ratio.setValue(ideal_cr * 2)
            self.forward_matrixCompression_rate = ideal_cr * 2  # (just to be sure)

    def update_memory_size(self):
        self.setupMesh()
        if self.dlg.checkBox_use_compression.isChecked():
            compression = self.dlg.mQgsDoubleSpinBox_compression_ratio.value()
        else:
            compression = 1.0

        nx = int(
            (self.meshBox["east"] - self.meshBox["west"] + (2 * self.padding))
            / self.cell_x
        )
        ny = int(
            (self.meshBox["north"] - self.meshBox["south"] + (2 * self.padding))
            / self.cell_y
        )
        ncore = int(
            float(self.dlg.doubleSpinBox_coreDepth.value())
            / float(self.dlg.mQgsSpinBox_mesh_size_z.value())
        )
        data_nx = int((self.meshBox["east"] - self.meshBox["west"]) / self.cell_x)
        data_ny = int((self.meshBox["north"] - self.meshBox["south"]) / self.cell_y)

        try:
            npad = int(
                np.log(
                    float(
                        self.dlg.doubleSpinBox_fullDepth.value()
                        - float(self.dlg.doubleSpinBox_coreDepth.value())
                    )
                    / (float(self.dlg.mQgsSpinBox_mesh_size_z.value()))
                )
                / np.log(1.15)
            )
        except:
            npad = 0
        nz = ncore + npad

        # if not self.suffix_known:
        # Determine which input path to use based on experiment type
        if self.global_experimentType in {1, 3}:
            data_path = self.dlg.lineEdit_grav_data_path.text()
        else:
            data_path = self.dlg.lineEdit_magn_data_path.text()

        # Extract suffix and store it
        suffix = data_path.split(".")[-1].lower()
        self.suffix_known = suffix

        if self.suffix_known != "csv":
            local_nData = data_nx * data_ny
        else:
            local_nData = self.nData
        if self.global_experimentType == 1 or self.global_experimentType == 2:
            memory = 8 * compression * nx * ny * nz * local_nData
        else:
            memory = 8 * compression * nx * ny * nz * local_nData * 2
        print(
            "compression * nx * ny * nz * local_nData",
            compression,
            nx,
            ny,
            nz,
            local_nData,
        )
        print("data_nx * data_ny", data_nx, data_ny)
        print("ncore * npad", ncore, npad)
        print("memory", memory)

        memory = round(memory / (1024 * 1024 * 1024), 3)
        self.dlg.memory_label.setText(str(memory))

    def reproj_raster(self, rasterInPath, targetCrs, dataType):
        parameter = {
            "INPUT": rasterInPath,
            "TARGET_CRS": targetCrs,
            "OUTPUT": "memory:{}_Reprojected".format(dataType),
        }
        result = processing.run("native:reprojectlayer", parameter)["OUTPUT"]

    # add raster dtm or gridded flight height to data file
    def add_dtm(self, dataType):
        # get dtm layer
        reprojDTM = QgsProject.instance().mapLayersByName("Reprojected DTM")[0]

        if dataType == 1:
            dataFileName = "/data_grav.csv"
            proj_out = self.grav_proj_out
            proj_in = self.grav_proj_in
            data_column = self.datacol_grav
            reprojDataLayerName = "reproj_grav_data"
            if self.global_dataType == "points":
                reprojFileName = self.global_dataNameGrav + "_grav_Reprojected"
            else:
                reprojFileName = "/reproj_data_grav.csv"

        else:
            dataFileName = "/data_magn.csv"
            proj_out = self.magn_proj_out
            proj_in = self.magn_proj_in
            data_column = self.datacol_magn
            reprojDataLayerName = "reproj_magn_data"
            if self.global_dataType == "points":
                reprojFileName = self.global_dataNameMagn + "_magn_Reprojected"
            else:
                reprojFileName = "/reproj_data_magn.csv"

        if self.global_dataType == "points":
            df = pd.DataFrame(self.data2tomofast.df)
            column_list = {
                df.columns[0]: "x",
                df.columns[1]: "y",
                # df.columns[2]: "z",
                # df.columns[2]: data_column,
            }
            df = df.rename(columns=column_list)
            layer = QgsVectorLayer("Point?crs=" + proj_in, "My Points Layer", "memory")

            # Get the data provider for the layer
            provider = layer.dataProvider()

            # Define the fields (attributes) for the layer
            fields = QgsFields()
            fields.append(QgsField("id", QVariant.Int))
            fields.append(QgsField("POINT_X", QVariant.Double))
            fields.append(QgsField("POINT_Y", QVariant.Double))
            fields.append(QgsField(data_column, QVariant.Double))

            # Add the fields to the provider
            provider.addAttributes(fields)
            layer.updateFields()

            # Loop over the DataFrame rows to create features
            for idx, row in df.iterrows():
                # Create a new feature
                feature = QgsFeature()
                # Set the geometry (Point) for the feature
                point = QgsPointXY(row["x"], row["y"])
                feature.setGeometry(QgsGeometry.fromPointXY(point))

                # Set the attributes (fields) for the feature
                feature.setAttributes([idx, row["x"], row["y"], row[data_column]])

                # Add the feature to the layer
                provider.addFeature(feature)

                # Update layer's extent
                layer.updateExtents()

            layer.commitChanges()
        else:
            # load data layer
            layer = QgsVectorLayer(
                "file:///"
                + self.global_outputFolderPath
                + reprojFileName
                + "?crs={}&xField={}&yField={}".format(proj_out, "POINT_X", "POINT_Y"),
                reprojDataLayerName,
                "delimitedtext",
            )

        # sample dtm layer using grav points
        parameter = {
            "INPUT": layer,
            "RASTERCOPY": reprojDTM,
            "COLUMN_PREFIX": "elevation",
            "OUTPUT": "memory",
        }
        processing.runAndLoadResults("native:rastersampling", parameter)["OUTPUT"]

        new_data_layer = QgsProject.instance().mapLayersByName("memory")[0]

        # convert to pandas
        data = []
        # Extract the fields (attributes) names
        fields = [field.name() for field in new_data_layer.fields()]
        # Loop through features in the layer
        for feature in new_data_layer.getFeatures():
            # Extract attribute values
            attributes = feature.attributes()

            # Add attributes and geometry to the data list
            data.append(attributes)

        # Create a pandas DataFrame
        data_df = pd.DataFrame(data, columns=fields)
        # data_df.to_csv(self.global_outputFolderPath + "/data_elev.csv", index=False)

        if self.global_dataType == "points":
            column_list = {
                data_df.columns[4]: "data1",
                "elevation1": "POINT_Z",
            }
        else:
            column_list = {
                "elevation1": "POINT_Z",
            }

        data_df = data_df.rename(columns=column_list)
        data_df = data_df.drop(columns=["fid"])

        new_column_order = ["POINT_X", "POINT_Y", "POINT_Z", "data1"]
        data_df = data_df[new_column_order]

        data_df.to_csv(self.global_outputFolderPath + dataFileName, index=False)

        self.data_df = data_df.copy(deep=True)
        QgsProject.instance().removeMapLayer(new_data_layer)

    # write out section titles
    def spacer(self, title):
        self.f_params.write("\n")
        self.f_params.write(
            "===================================================================================\n"
        )
        self.f_params.write(title + "\n")
        self.f_params.write(
            "===================================================================================\n"
        )

    # write out parameter file
    def save_parameter_file(self):
        self.parse_parameters()

        self.dlg.lineEdit_2_parfilePath.setText(
            self.global_outputFolderPath + "/paramfile.txt"
        )
        self.paramfile_Path = self.global_outputFolderPath + "/paramfile.txt"
        self.f_params = open(self.global_outputFolderPath + "/paramfile.txt", "w")

        self.spacer("GLOBAL")
        self.f_params.write(
            "global.outputFolderPath             = {}\n".format(
                self.global_outputFolderPath + "/OUTPUT"
            )
        )
        if not self.global_description:
            self.global_description = "Inversion Experiment"
        self.f_params.write(
            "global.description                  = {}\n".format(self.global_description)
        )
        self.f_params.write(
            "#global.experimentType               = {}\n".format(
                self.global_experimentType
            )
        )

        if self.global_experimentType == 1 or self.global_experimentType == 3:
            self.f_params.write(
                "global.grav.dataUnitsMultiplier     = {}\n".format(
                    str(self.global_grav_dataUnitsMultiplier)
                )
            )
            self.f_params.write(
                "global.grav.modelUnitsMultiplier    = {}\n".format(
                    self.global_grav_modelUnitsMultiplier
                )
            )

        if self.global_experimentType == 2 or self.global_experimentType == 3:
            self.f_params.write(
                "global.magn.dataUnitsMultiplier     = {}\n".format(
                    str(self.global_magn_dataUnitsMultiplier)
                )
            )
            self.f_params.write(
                "global.magn.modelUnitsMultiplier    = {}\n".format(
                    self.global_magn_modelUnitsMultiplier
                )
            )

        self.spacer("ELEVATION parameters")
        self.f_params.write(
            "#global.elevType                     = {}\n".format(self.global_elevType)
        )

        if self.global_experimentType == 1 or self.global_experimentType == 3:

            self.f_params.write(
                "#global.grav.sensor_height                 = {}\n".format(
                    self.global_grav_sensor_height  # .item()
                )
            )
        if self.global_experimentType == 2 or self.global_experimentType == 3:

            self.f_params.write(
                "#global.magn.sensor_height                 = {}\n".format(
                    self.global_magn_sensor_height  # .item()
                )
            )

        self.spacer("MODEL GRID parameters")

        # nx ny nz
        self.f_params.write(
            "modelGrid.size                      = {} {} {}\n".format(
                self.modelGrid_size[0], self.modelGrid_size[1], self.modelGrid_size[2]
            )
        )
        if self.global_experimentType == 1 or self.global_experimentType == 3:
            self.f_params.write(
                "modelGrid.grav.file                 = {}\n".format(
                    self.global_outputFolderPath + "/model_grid.txt"
                )
            )
        if self.global_experimentType == 2 or self.global_experimentType == 3:
            self.f_params.write(
                "modelGrid.magn.file                 = {}\n".format(
                    self.global_outputFolderPath + "/model_grid.txt"
                )
            )

        if self.global_experimentType == 2 or self.global_experimentType == 3:
            self.spacer("MAGNETIC FIELD constants")

            self.f_params.write(
                "forward.magneticField.inclination                 = {}\n".format(
                    self.forward_magneticField_inclination  # .item()
                )
            )
            self.f_params.write(
                "forward.magneticField.declination                 = {}\n".format(
                    self.forward_magneticField_declination  # .item()
                )
            )
            self.f_params.write(
                "forward.magneticField.intensity_nT                = {}\n".format(
                    self.forward_magneticField_intensity  # .item()
                )
            )

        # if(self.global_experimentType==2 or self.global_experimentType==3):
        #    self.f_params.write("modelGrid.magn.file                 = {}\n".format(self.output_directory+"/model_magn_grid.txt"))

        self.spacer("DATA parameters")

        if self.global_experimentType == 1 or self.global_experimentType == 3:
            self.f_params.write(
                "forward.data.grav.nData             = {}\n".format(
                    self.forward_data_grav_nData
                )
            )
            self.f_params.write(
                "forward.data.grav.dataGridFile      = {}\n".format(
                    self.global_outputFolderPath + "/data_grav.csv"
                )
            )
            """self.f_params.write(
                "forward.data.grav.dataValuesFile    = {}\n".format(
                    self.global_outputFolderPath + "/data_grav.csv"
                )
            )"""

        if self.global_experimentType == 2 or self.global_experimentType == 3:
            self.f_params.write(
                "forward.data.magn.nData             = {}\n".format(
                    self.forward_data_magn_nData
                )
            )
            """if self.global_elevType == 1:"""
            self.f_params.write(
                "forward.data.magn.dataGridFile      = {}\n".format(
                    self.global_outputFolderPath + "/data_magn.csv"
                )
            )
            """self.f_params.write(
                "forward.data.magn.dataValuesFile    = {}\n".format(
                    self.global_outputFolderPath + "/data_magn.csv"
                )
            )"""
        else:
            self.f_params.write(
                "forward.data.magn.dataGridFile      = {}\n".format(
                    self.global_outputFolderPath + "/data_magn_topo.csv"
                )
            )
            """self.f_params.write(
                "forward.data.magn.dataValuesFile    = {}\n".format(
                    self.global_outputFolderPath + "/data_magn_topo.csv"
                )
            )"""

        self.spacer("DEPTH WEIGHTING")

        self.f_params.write(
            "forward.depthWeighting.type         = {}\n".format(
                self.forward_depthWeighting_type
            )
        )
        if self.global_experimentType == 1 or self.global_experimentType == 3:
            self.f_params.write(
                "forward.depthWeighting.grav.power   = {}\n".format(
                    self.forward_depthWeighting_grav_power
                )
            )

        if self.global_experimentType == 2 or self.global_experimentType == 3:
            self.f_params.write(
                "forward.depthWeighting.magn.power   = {}\n".format(
                    self.forward_depthWeighting_magn_power
                )
            )

        self.spacer("SENSITIVITY KERNEL")

        self.f_params.write(
            "sensit.readFromFiles                = {}\n".format(
                self.sensit_readFromFiles
            )
        )
        if self.sensit_readFromFiles == 0:
            self.f_params.write(
                "sensit.folderPath                   = {}\n".format(
                    self.global_outputFolderPath + "/OUTPUT/SENSIT/"
                )
            )
        else:
            self.f_params.write(
                "sensit.folderPath                   = {}\n".format(
                    self.kernelfiledirectory + "/"
                )
            )

        self.spacer("MATRIX COMPRESSION")

        # 0-none, 1-wavelet compression.
        self.f_params.write(
            "forward.matrixCompression.type      = {}\n".format(
                self.forward_matrixCompression_type
            )
        )
        self.f_params.write(
            "forward.matrixCompression.rate      = {}\n".format(
                self.forward_matrixCompression_rate
            )
        )

        self.spacer("INVERSION parameters")

        if (
            self.inversion_admm_grav_nLithologies > 0
            or self.inversion_admm_magn_nLithologies > 0
        ):
            self.f_params.write(
                "inversion.nMajorIterations          = {}\n".format("50")
            )
        else:
            self.f_params.write(
                "inversion.nMajorIterations          = {}\n".format(
                    self.inversion_nMajorIterations
                )
            )
        self.f_params.write(
            "inversion.nMinorIterations          = {}\n".format(
                self.inversion_nMinorIterations
            )
        )
        self.f_params.write(
            "inversion.writeModelEveryNiter      = {}\n".format(
                self.inversion_writeModelEveryNiter
            )
        )

        self.spacer("MODEL DAMPING (m - m_prior)")
        if self.global_experimentType == 1 or self.global_experimentType == 3:
            self.f_params.write(
                "inversion.modelDamping.grav.weight  = {}\n".format(
                    self.inversion_modelDamping_grav_weight
                )
            )
            self.f_params.write(
                "inversion.modelDamping.normPower    = {}\n".format(
                    self.inversion_modelDamping_grav_normPower
                )
            )

        if self.global_experimentType == 2 or self.global_experimentType == 3:
            self.f_params.write(
                "inversion.modelDamping.magn.weight  = {}\n".format(
                    self.inversion_modelDamping_magn_weight
                )
            )
            self.f_params.write(
                "inversion.modelDamping.normPower    = {}\n".format(
                    self.inversion_modelDamping_magn_normPower
                )
            )

        self.spacer("JOINT INVERSION parameters")

        self.f_params.write(
            "inversion.joint.grav.problemWeight  = {}\n".format(
                self.inversion_joint_grav_problemWeight
            )
        )
        self.f_params.write(
            "inversion.joint.magn.problemWeight  = {}\n".format(
                self.inversion_joint_magn_problemWeight
            )
        )

        self.spacer("ADMM constraints")

        if self.global_experimentType == 1 or self.global_experimentType == 3:
            self.f_params.write(
                "inversion.admm.enableADMM           = {}\n".format(
                    self.inversion_admm_grav_enableADMM
                )
            )
            self.f_params.write(
                "inversion.admm.nLithologies         = {}\n".format(
                    self.inversion_admm_grav_nLithologies
                )
            )
            if self.inversion_admm_grav_nLithologies > 0:
                self.f_params.write(
                    "inversion.admm.dataCostThreshold      = {}\n".format("0.1e-3")
                )
            if self.inversion_admm_grav_nLithologies > 0:
                self.f_params.write(
                    "inversion.admm.weightMultiplier      = {}\n".format("2.0")
                )
            if self.inversion_admm_grav_bounds == "":
                self.f_params.write(
                    "inversion.admm.grav.bounds          = {}\n".format("-1d-10 1d10")
                )
            else:
                self.f_params.write(
                    "inversion.admm.grav.bounds          = {}\n".format(
                        self.inversion_admm_grav_bounds
                    )
                )
            if self.inversion_admm_grav_nLithologies > 0:
                self.f_params.write(
                    "inversion.admm.grav.weight      = {}\n".format("1000.0")
                )
            else:
                self.f_params.write(
                    "inversion.admm.grav.weight          = {}\n".format(
                        self.inversion_admm_grav_weight
                    )
                )

            if self.inversion_admm_grav_nLithologies > 0:
                self.f_params.write(
                    "inversion.admm.grav.weight      = {}\n".format("1000.0")
                )
                self.f_params.write("inversion.admm.maxWeight      =   0.1000000E+11\n")
            else:
                self.f_params.write(
                    "inversion.admm.grav.weight          = {}\n".format(
                        self.inversion_admm_grav_weight
                    )
                )

        if self.global_experimentType == 2 or self.global_experimentType == 3:
            self.f_params.write(
                "inversion.admm.enableADMM           = {}\n".format(
                    self.inversion_admm_magn_enableADMM
                )
            )
            self.f_params.write(
                "inversion.admm.nLithologies         = {}\n".format(
                    self.inversion_admm_magn_nLithologies
                )
            )
            if self.inversion_admm_magn_nLithologies > 0:
                self.f_params.write(
                    "inversion.admm.dataCostThreshold      = {}\n".format("0.1e-3")
                )
            if self.inversion_admm_magn_nLithologies > 0:
                self.f_params.write(
                    "inversion.admm.weightMultiplier      = {}\n".format("2.0")
                )
            if self.inversion_admm_magn_bounds == "":
                self.f_params.write(
                    "inversion.admm.magn.bounds          = {}\n".format("-1d-10 1d10")
                )
            else:
                self.f_params.write(
                    "inversion.admm.magn.bounds          = {}\n".format(
                        self.inversion_admm_magn_bounds
                    )
                )

            if self.inversion_admm_magn_nLithologies > 0:
                self.f_params.write(
                    "inversion.admm.magn.weight      = {}\n".format("1000.0")
                )
                self.f_params.write("inversion.admm.maxWeight      =   0.1000000E+11\n")
            else:
                self.f_params.write(
                    "inversion.admm.magn.weight          = {}\n".format(
                        self.inversion_admm_magn_weight
                    )
                )

        self.spacer("MESH")

        self.f_params.write(
            "#mesh.cellx                          = {}\n".format(self.cell_x)
        )
        self.f_params.write(
            "#mesh.celly                          = {}\n".format(self.cell_y)
        )
        self.f_params.write(
            "#mesh.cellz                          = {}\n".format(self.dz)
        )
        self.f_params.write(
            "#mesh.padding                        = {}\n".format(self.padding)
        )
        self.f_params.write(
            "#mesh.z.coreDepth                       = {}\n".format(self.z_coreDepth)
        )
        self.f_params.write(
            "#mesh.z.fullDepth                  = {}\n".format(self.z_fullDepth)
        )

        self.spacer("ANOMALIES")

        if self.global_experimentType == 1 or self.global_experimentType == 3:
            self.f_params.write(
                "#anomalies.grav.data.file            = {}\n".format(self.filename_grav)
            )
            self.f_params.write(
                "#anomalies.grav.proj.in              = {}\n".format(self.grav_proj_in)
            )
            self.f_params.write(
                "#anomalies.grav.proj.out             = {}\n".format(self.grav_proj_out)
            )

        if self.global_experimentType == 2 or self.global_experimentType == 3:
            self.f_params.write(
                "#anomalies.magn.data_file            = {}\n".format(self.filename_magn)
            )
            self.f_params.write(
                "#anomalies.magn.proj.in              = {}\n".format(self.magn_proj_in)
            )
            self.f_params.write(
                "#anomalies.magn.proj.out             = {}\n".format(self.magn_proj_out)
            )

        self.f_params.close()
        self.iface.messageBar().pushMessage(
            "parfile.txt saved to  {}".format(self.global_outputFolderPath),
            "OK ",
            level=Qgis.Success,
            duration=45,
        )

    def export_model(self):

        code = "grav"

        paramfile_Dir = os.path.dirname(self.paramfile_Path)

        # Path to input model grid (modelGrid.XXXX.file parameter in the Parfile).
        filename_model_grid = os.path.join(paramfile_Dir, "model_grid.txt")
        print("Reading model from: ", filename_model_grid)

        # Path to the output model after inversion.
        filename_model_final = os.path.join(
            paramfile_Dir, "OUTPUT/model/" + code + "_final_model_full.txt"
        )
        if os.path.exists(filename_model_final) == False:
            code = "mag"
            filename_model_final = os.path.join(
                paramfile_Dir, "OUTPUT/model/" + code + "_final_model_full.txt"
            )

        print("Reading grid from: ", filename_model_final)

        # Path to exported model in csv format
        filename_model_csv = os.path.join(
            paramfile_Dir, "OUTPUT/" + code + "_final_model3D_full.csv"
        )

        # Reading the model grid.
        model_grid = np.loadtxt(
            filename_model_grid, dtype=float, usecols=(0, 1, 2, 3, 4, 5), skiprows=1
        )

        # Reading the final model.
        model_values = np.loadtxt(filename_model_final, dtype=float, skiprows=1)

        assert (
            model_grid.shape[0] == model_values.shape[0]
        ), "Inconsistent model dimensions!"

        Ncells = model_grid.shape[0]
        print("Ncells =", Ncells)

        print(model_grid.shape)
        print(model_values.shape)

        # Positions of the model cell centers.
        positions = np.ndarray((Ncells, 3), dtype=float)

        # Calculate the cell centers.
        positions[:, 0] = (model_grid[:, 0] + model_grid[:, 1]) / 2.0
        positions[:, 1] = (model_grid[:, 2] + model_grid[:, 3]) / 2.0
        positions[:, 2] = (model_grid[:, 4] + model_grid[:, 5]) / 2.0

        # Revert Z-axis.
        positions[:, 2] = -positions[:, 2]

        # Combine the arrays
        combined = np.column_stack((positions, model_values))
        np.savetxt(
            filename_model_csv,
            combined,
            delimiter=",",
            header="x,y,z,data",
            comments="",
            fmt="%.6f",
        )
        self.iface.messageBar().pushMessage(
            f"Model saved as "
            + code
            + "_final_model3D_full.csv in the OUTPUT directory",
            "",
            level=Qgis.Success,
            duration=45,
        )

    # display pints layer with colours
    def colour_points(self, layer, value_field, ramp_name, invert):
        # layer_name = 'Your_layer_name'
        # ramp_name = 'Spectral'
        # value_field = 'Your_field_name'
        num_classes = 20
        classification_method = QgsClassificationEqualInterval()

        # You can use any of these classification method classes:
        # QgsClassificationQuantile()
        # QgsClassificationEqualInterval()
        # QgsClassificationJenks()
        # QgsClassificationPrettyBreaks()
        # QgsClassificationLogarithmic()
        # QgsClassificationStandardDeviation()

        # layer = QgsProject().instance().mapLayersByName(layer_name)[0]

        # change format settings as necessary
        format = QgsRendererRangeLabelFormat()
        format.setFormat("%1 - %2")
        format.setPrecision(2)
        format.setTrimTrailingZeroes(True)

        default_style = QgsStyle().defaultStyle()
        color_ramp = default_style.colorRamp(ramp_name)
        if invert:
            color_ramp.invert()
        renderer = QgsGraduatedSymbolRenderer()
        renderer.setClassAttribute(value_field)
        renderer.setClassificationMethod(classification_method)
        renderer.setLabelFormat(format)
        renderer.updateClasses(layer, num_classes)
        renderer.updateColorRamp(color_ramp)

        layer.setRenderer(renderer)
        layer.triggerRepaint()

    # load data from GUI widgets to variables
    def parse_parameters(self):

        if self.dlg.checkBox_grav_depth_weighting.isChecked():
            self.forward_depthWeighting_type = 2
        else:
            self.forward_depthWeighting_type = 1
        self.global_outputFolderPath = self.dlg.lineEdit_output_directory_path.text()
        self.global_description = self.dlg.textEdit_experiment_description.toPlainText()

        self.modelGrid_size = [
            int(self.dlg.nx_label.text()),
            int(self.dlg.ny_label.text()),
            int(self.dlg.nz_label.text()),
        ]
        self.modelGrid_grav_file = self.global_outputFolderPath + "/model_grav_grid.txt"
        self.modelGrid_magn_file = self.global_outputFolderPath + "/model_magn_grid.txt"

        self.forward_data_grav_dataGridFile = (
            self.global_outputFolderPath + "/data_grav.csv"
        )
        """self.forward_data_grav_dataValuesFile = (
            self.global_outputFolderPath + "/grav_calc_read_data.txt"
        )"""
        self.forward_data_magn_dataGridFile = (
            self.global_outputFolderPath + "/data_magn.csv"
        )
        """self.forward_data_magn_dataValuesFile = (
            self.global_outputFolderPath + "/magn_calc_read_data.txt"
        )"""

        if self.dlg.checkBox_grav_depth_weighting.isChecked():
            self.forward_depthWeighting_type = 2
        else:
            self.forward_depthWeighting_type = 1

        self.forward_depthWeighting_grav_power = (
            self.dlg.mQgsDoubleSpinBox_grav_depth_weight_power.value()
        )
        self.forward_depthWeighting_magn_power = (
            self.dlg.mQgsDoubleSpinBox_mag_depth_weighting.value()
        )
        if self.dlg.checkBox_read_sens_matrix.isChecked():
            self.sensit_readFromFiles = 1
        else:
            self.sensit_readFromFiles = 0

        if self.dlg.checkBox_use_compression.isChecked():
            self.forward_matrixCompression_type = 1
        else:
            self.forward_matrixCompression_type = 2

        self.forward_matrixCompression_rate = (
            self.dlg.mQgsDoubleSpinBox_compression_ratio.value()
        )

        self.inversion_nMajorIterations = self.dlg.mQgsSpinBox_major_iters.value()
        self.inversion_nMinorIterations = self.dlg.mQgsSpinBox_minor_iters.value()
        self.inversion_writeModelEveryNiter = (
            self.dlg.mQgsSpinBox_model_save_iters.value()
        )
        self.inversion_minResidual = self.dlg.textEdit_min_residual.toPlainText()

        self.inversion_modelDamping_grav_weight = (
            self.dlg.mQgsDoubleSpinBox_grav_mmodel_damping_weight.value()
        )
        self.inversion_modelDamping_grav_normPower = (
            self.dlg.mQgsDoubleSpinBox_grav_mmodel_norm_power.value()
        )

        self.inversion_modelDamping_magn_weight = (
            self.dlg.mQgsDoubleSpinBox_magn_model_weight.value()
        )
        self.inversion_modelDamping_magn_normPower = (
            self.dlg.mQgsDoubleSpinBox_magn_model_norm_power.value()
        )

        self.inversion_joint_grav_problemWeight = (
            self.dlg.mQgsDoubleSpinBox_grav_weight.value()
        )
        self.inversion_joint_magn_problemWeight = (
            self.dlg.mQgsDoubleSpinBox_magn_weight.value()
        )

        if self.dlg.radioButton_grav_depth_based_weighting.isChecked():
            self.inversion_grav_depthWeighting = 1
        else:
            self.inversion_grav_depthWeighting = 2
        if self.dlg.radioButton_magn_dist_based_weighting.isChecked():
            self.inversion_mag_depthWeighting = 1
        else:
            self.inversion_mag_depthWeighting = 2

        self.inversion_admm_grav_nLithologies = int(
            self.dlg.spinBox_grav_number_ADMM_litho.value()
        )
        if self.inversion_admm_grav_nLithologies > 0:
            self.inversion_admm_grav_enableADMM = 1
        else:
            self.inversion_admm_grav_enableADMM = 0

        self.inversion_admm_magn_nLithologies = int(
            self.dlg.spinBox_magn_ADMM_number_litho.value()
        )
        if self.inversion_admm_magn_nLithologies > 0:
            self.inversion_admm_magn_enableADMM = 1
        else:
            self.inversion_admm_magn_enableADMM = 0

        if self.dlg.textEdit_grav_ADMM_bounds.toPlainText():
            self.inversion_admm_grav_bounds = (
                self.dlg.textEdit_grav_ADMM_bounds.toPlainText()
            )
        if self.dlg.lineEdit_grav_ADMM_weight.text():
            self.inversion_admm_grav_weight = self.dlg.lineEdit_grav_ADMM_weight.text()
        if self.dlg.textEdit_5_magn_ADMM_bounds.toPlainText():
            self.inversion_admm_magn_bounds = (
                self.dlg.textEdit_5_magn_ADMM_bounds.toPlainText()
            )
        if self.dlg.lineEdit_magn_ADMM_weight.text():
            self.inversion_admm_magn_weight = self.dlg.lineEdit_magn_ADMM_weight.text()

        self.global_grav_dataUnitsMultiplier = float(
            self.dlg.lineEdit_grav_data_multiplier.text()
        )
        self.global_grav_modelUnitsMultiplier = (
            self.dlg.mQgsDoubleSpinBox_grav_model_multiplier.value()
        )
        self.global_magn_dataUnitsMultiplier = float(
            self.dlg.lineEdit_magn_data_multiplier.text()
        )
        self.global_magn_modelUnitsMultiplier = (
            self.dlg.mQgsDoubleSpinBox_magn_model_multiplier.value()
        )

        if self.dlg.radioButton_grav_inv.isChecked():  # grav
            self.inversion_type = 1
        elif self.dlg.radioButton_magn_inv.isChecked():  # mag
            self.inversion_type = 2
        else:  # mag_grav
            self.inversion_type = 3

        self.filename_grav = self.dlg.lineEdit_grav_data_path.text()
        self.filename_magn = self.dlg.lineEdit_magn_data_path.text()

        self.global_elevFilename = self.dlg.lineEdit_dtm_path.text()

        self.meshBox = {
            "south": self.dlg.mQgsSpinBox_mesh_south.value(),
            "west": self.dlg.mQgsSpinBox_mesh_west.value(),
            "north": self.dlg.mQgsSpinBox_mesh_north.value(),
            "east": self.dlg.mQgsSpinBox_mesh_east.value(),
        }

        self.forward_magneticField_declination = self.dlg.doubleSpinBox_mag_dec.value()
        self.forward_magneticField_inclination = self.dlg.doubleSpinBox_mag_inc.value()
        self.forward_magneticField_intensity = self.dlg.doubleSpinBox_mag_int.value()

        self.global_grav_sensor_height = (
            self.dlg.doubleSpinBox_grav_sensor_height.value()
        )
        self.global_magn_sensor_height = (
            self.dlg.doubleSpinBox_magn_sensor_height.value()
        )
        self.z_coreDepth = self.dlg.doubleSpinBox_coreDepth.value()
        self.z_fullDepth = self.dlg.doubleSpinBox_fullDepth.value()

    # load and parse existing parfile updating gui and storing parameters
    def load_parfile(self):

        #   set up dict with form
        #
        #   key=parfile variable name
        #   values=p[0] variable contents,
        #          p[1] associated widget(s),
        #          p[-2] data type,
        #          p[-1] widget type

        # parse parfile file and copy valid parameters to associated variables
        if os.path.exists(self.parfilename) and self.parfilename:
            parfile = open(self.parfilename, "r")

            for pl in parfile.readlines():
                pls = pl.split("=")
                pkey = (
                    pls[0].strip().replace("#", "")
                )  # replace() removes leading # to signify qgis parameter only

                if pkey in self.d_params.keys():  # if parameter found in dict

                    if len(pls) == 2:
                        pval = pls[1].strip()

                        if (
                            self.d_params[pkey][-2] == float
                        ):  # check for fortran 2d5.0 format floats
                            if "d" in pval:
                                pval = pval.replace("d", "e")

                        # assign value to parameter
                        if self.d_params[pkey][-1] == "size":
                            self.d_params[pkey][0][0] = self.d_params[pkey][-2](
                                pval.split(" ")[0]
                            )
                            self.d_params[pkey][0][1] = self.d_params[pkey][-2](
                                pval.split(" ")[1]
                            )
                            self.d_params[pkey][0][2] = self.d_params[pkey][-2](
                                pval.split(" ")[2]
                            )

                        else:
                            self.d_params[pkey][0] = self.d_params[pkey][-2](pval)

                        p = self.d_params[pkey]
                        if p[0] != "":
                            if p[-1] == "value":

                                p[1].setValue(p[-2](p[0]))
                            elif p[-1] == "plainText":
                                p[1].setText(p[-2](p[0]))
                            elif p[-1] == "text":
                                p[1].setText(p[-2](p[0]))
                            elif p[-1] == "epsg":
                                p[1].setCrs(QgsCoordinateReferenceSystem(p[-2](p[0])))
                            elif p[-1] == "check":
                                if p[0] == True:
                                    p[1].setChecked(True)
                                else:
                                    p[1].setChecked(False)
                            elif p[-1] == "radio":
                                for button in range(1, len(p) - 2):
                                    p[button].setChecked(False)
                                    if int(p[0]) == button:
                                        p[button].setChecked(True)

                            elif p[-1] == "path":
                                p[1] = p[0]
                            elif p[-1] == "size":
                                p[1].setText(p[-2](p[0][0]))
                                p[2].setText(p[-2](p[0][1]))
                                p[3].setText(p[-2](p[0][2]))

                        else:
                            print("blank", pkey)

            parfile.close()

    # reset params to deafults and update gui
    def reset_params(self):

        #   set up dict with form
        #
        #   key=parfile variable name
        #   values=p[0] variable contents,
        #          p[1] associated widget(s),
        #          p[-2] data type,
        #          p[-1] widget type

        # parse parfile file and copy valid parameters to associated variables

        self.initialise_variables()

        for pkey in self.d_params:

            p = self.d_params[pkey]

            if p[-1] == "value":
                p[1].setValue(p[-2](p[0]))
            elif p[-1] == "plainText":
                p[1].setText(p[-2](p[0]))
            elif p[-1] == "text":
                p[1].setText(p[-2](p[0]))
            elif p[-1] == "epsg":
                p[1].setCrs(QgsCoordinateReferenceSystem(p[-2](p[0])))
            elif p[-1] == "check":
                if p[0] == True:
                    p[1].setChecked(True)
                else:
                    p[1].setChecked(False)
            elif p[-1] == "radio":
                for button in range(1, len(p) - 2):
                    p[button].setChecked(False)
                    if int(p[0]) == button:
                        p[button].setChecked(True)

            elif p[-1] == "path":
                p[1] = p[0]
            elif p[-1] == "size":
                p[1].setText(p[-2](p[0][0]))
                p[2].setText(p[-2](p[0][1]))
                p[3].setText(p[-2](p[0][2]))
        self.inversion_type_reset_gui()
        self.dlg.lineEdit_param_load_path.clear()
        self.dlg.groupBox_2.setEnabled(False)
        self.dlg.groupBox_3.setEnabled(False)
        self.dlg.groupBox_9.setEnabled(False)

    # update gui
    def enable_boxes(self):
        """if self.dataType == "raster":
        self.dlg.mQgsSpinBox_mesh_south.setEnabled(False)
        self.dlg.mQgsspinBox_grav_number_ADMM_litho.setEnabled(False)
        self.dlg.mQgsSpinBox_13.setEnabled(False)"""

        self.inversion_type_reset_gui()

    # update elevation type based on gui
    def dtm_type(self):

        self.dlg.lineEdit_grav_data_path.setEnabled(True)
        self.dlg.pushButton_select_dtm_path.setEnabled(True)
        self.global_elevType = 2

    # update inversion type based on gui
    def inversion_type_reset_gui(self):
        # enable GroupBoxes

        if self.dlg.radioButton_grav_inv.isChecked():  # grav
            self.dlg.groupBox.setEnabled(True)
            self.dlg.mQgsProjectionSelectionWidget_grav_in.setEnabled(False)
            self.dlg.mQgsProjectionSelectionWidget_grav_out.setEnabled(False)
            self.dlg.groupBox_6.setEnabled(True)
            self.dlg.groupBox_9.setEnabled(True)
            self.dlg.groupBox_16.setEnabled(True)
            self.dlg.groupBox_22.setEnabled(True)
            self.dlg.groupBox_26.setEnabled(True)
            self.dlg.label_7.setEnabled(True)
            self.dlg.pushButton_load_grav_data.setEnabled(True)

            self.dlg.label_9.setEnabled(False)

            self.dlg.groupBox_7.setEnabled(False)
            self.dlg.groupBox_10.setEnabled(False)
            self.dlg.groupBox_12.setEnabled(False)
            self.dlg.groupBox_23.setEnabled(False)
            self.dlg.groupBox_29.setEnabled(False)
            self.dlg.groupBox_30.setEnabled(False)
            self.dlg.groupBox_35.setEnabled(False)
            self.global_experimentType = 1

        elif self.dlg.radioButton_magn_inv.isChecked():  # mag
            self.dlg.groupBox.setEnabled(False)

            self.dlg.mQgsProjectionSelectionWidget_magn_in.setEnabled(False)
            self.dlg.mQgsProjectionSelectionWidget_magn_out.setEnabled(False)
            self.dlg.groupBox_6.setEnabled(False)
            self.dlg.groupBox_9.setEnabled(False)
            self.dlg.groupBox_16.setEnabled(False)
            self.dlg.groupBox_22.setEnabled(False)
            self.dlg.groupBox_26.setEnabled(False)
            self.dlg.label_7.setEnabled(False)

            self.dlg.label_9.setEnabled(True)
            self.dlg.groupBox_7.setEnabled(True)
            self.dlg.groupBox_10.setEnabled(True)
            self.dlg.groupBox_12.setEnabled(True)
            self.dlg.groupBox_23.setEnabled(True)
            self.dlg.groupBox_29.setEnabled(True)
            self.dlg.groupBox_30.setEnabled(True)
            self.dlg.groupBox_35.setEnabled(True)
            self.dlg.pushButton_load_magn_data.setEnabled(True)
            self.global_experimentType = 2

        elif self.dlg.radioButton_joint_inv.isChecked():  # grav/mag
            self.dlg.pushButton_load_magn_data.setEnabled(True)
            self.dlg.groupBox.setEnabled(True)
            self.dlg.mQgsProjectionSelectionWidget_grav_in.setEnabled(False)
            self.dlg.mQgsProjectionSelectionWidget_grav_out.setEnabled(False)
            self.dlg.mQgsProjectionSelectionWidget_magn_in.setEnabled(False)
            self.dlg.mQgsProjectionSelectionWidget_magn_out.setEnabled(False)
            self.dlg.groupBox_6.setEnabled(True)
            self.dlg.groupBox_9.setEnabled(True)
            self.dlg.groupBox_16.setEnabled(True)
            self.dlg.groupBox_22.setEnabled(True)
            self.dlg.groupBox_26.setEnabled(True)
            self.dlg.label_7.setEnabled(True)
            self.dlg.pushButton_load_grav_data.setEnabled(True)

            self.dlg.label_9.setEnabled(True)
            self.dlg.groupBox_7.setEnabled(True)
            self.dlg.groupBox_10.setEnabled(True)
            self.dlg.groupBox_12.setEnabled(True)
            self.dlg.groupBox_23.setEnabled(True)
            self.dlg.groupBox_29.setEnabled(True)
            self.dlg.groupBox_30.setEnabled(True)
            self.dlg.groupBox_35.setEnabled(True)
            self.global_experimentType = 3

    # update mesh parameters to allow multiple layer thicknesses
    def mesh_layers(self):

        self.dlg.doubleSpinBox_coreDepth.setEnabled(True)
        self.dlg.doubleSpinBox_fullDepth.setEnabled(True)

    def define_tips(self):
        self.dlg.checkBox_read_sens_matrix.setToolTip(
            "Load previously calculated sensistivity matrix\n\n[forward.sensit.readFromFiles]"
        )
        self.dlg.checkBox_use_compression.setToolTip(
            "Use wavelet compression to speed calculations and reduce memory demands of inversion\n\n[forward.matrixCompression.type]"
        )
        self.dlg.checkBox_grav_depth_weighting.setToolTip(
            "Enable depth weighting for gravity inversion\n\n[forward.depthWeighting.type]"
        )
        self.dlg.checkBox_magn_depth_weighting.setToolTip(
            "Enable depth weighting for magnetic inversion\n\n[forward.depthWeighting.type]"
        )
        self.dlg.comboBox_grav_field_x.setToolTip(
            "Define column in csv file that contains Longitude/Easting information"
        )
        self.dlg.comboBox_grav_field_y.setToolTip(
            "Define column in csv file that contains Latitude/Northing information"
        )
        self.dlg.comboBox_grav_field_data.setToolTip(
            "Define column in csv file that contains Gravity information"
        )
        self.dlg.comboBox_magn_field_x.setToolTip(
            "Define column in csv file that contains Longitude/Easting information"
        )
        self.dlg.comboBox_magn_field_y.setToolTip(
            "Define column in csv file that contains Latitude/Northing information"
        )
        self.dlg.groupBox_10.setToolTip(
            "Define column in csv file that contains Magnetic information"
        )
        self.dlg.lineEdit_grav_ADMM_weight.setToolTip(
            "Define weighting of ADMM constraint\n\n[inversion.admm.grav.weight]"
        )
        self.dlg.lineEdit_magn_ADMM_weight.setToolTip(
            "Define weighting of ADMM constraint\n\n[inversion.admm.magn.weight]"
        )
        self.dlg.mQgsDoubleSpinBox_grav_mmodel_damping_weight.setToolTip(
            "Index of power term for depth weighting [3 for magnetics]\n\n[inversion.modelDamping.grav.weight]"
        )
        self.dlg.mQgsDoubleSpinBox_grav_depth_weight_power.setToolTip(
            "Index of power term for depth weighting [2 for gravity]\n\n[inversion.depthWeighting.grav.power]"
        )
        self.dlg.mQgsDoubleSpinBox_compression_ratio.setToolTip(
            "Amount of wavelet compression [smaller value means more compression]\nAutomatically set to provide 1% error but value can be manually overidden\n\n[forward.matrixCompression.rate]"
        )
        self.dlg.mQgsDoubleSpinBox_grav_model_multiplier.setToolTip(
            "Multiplier for scaling of output models\n\n[global.grav_modelUnitsMultiplier]"
        )
        self.dlg.lineEdit_grav_data_multiplier.setToolTip(
            "Multiplier for input gravity data to convert it to SI units\n\n[global.grav_dataUnitsMultiplier]"
        )
        self.dlg.mQgsDoubleSpinBox_grav_mmodel_norm_power.setToolTip(
            "Define power exponent of gravity model damping term\n\n[inversion.modelDamping.normPower]"
        )
        self.dlg.mQgsDoubleSpinBox_grav_mmodel_damping_weight.setToolTip(
            "Define weight of gravity model damping term (m - m_prior)\n\n[inversion.modelDamping.grav.weight]"
        )
        self.dlg.mQgsDoubleSpinBox_magn_model_multiplier.setToolTip(
            "Multiplier for scaling of output models\n\n[global.magn_modelUnitsMultiplier]"
        )
        self.dlg.lineEdit_magn_data_multiplier.setToolTip(
            "Multiplier for input magnetic data to convert it to SI units\n\n[global.magn_dataUnitsMultiplier]"
        )
        self.dlg.mQgsDoubleSpinBox_grav_weight.setToolTip(
            "Relative weighting of gravity data for joint inversion\n\n[inversion.joint.grav.problemWeight]"
        )
        self.dlg.mQgsDoubleSpinBox_magn_weight.setToolTip(
            "Relative weighting of magnetic data for joint inversion\n\n[inversion.joint.magn.problemWeight]"
        )
        self.dlg.mQgsDoubleSpinBox_magn_model_norm_power.setToolTip(
            "Define power exponent of magnetic model damping term\n\n[inversion.modelDamping.normPower]"
        )
        self.dlg.mQgsDoubleSpinBox_magn_model_weight.setToolTip(
            "Define weight of magnetic model damping term (m - m_prior)\n\n[inversion.modelDamping.magn.weight]"
        )
        self.dlg.label_61.setToolTip(
            "Define input gravity data projection system [EPSG:4326]\n\n[anomalies.grav.proj.in]"
        )
        self.dlg.label_62.setToolTip(
            "Define processed gravity data projection system [EPSG:4326]\n\n[anomalies.grav.proj.out]"
        )
        self.dlg.label_68.setToolTip(
            "Define input magnetic data projection system [EPSG:4326]\n\n[anomalies.magn.proj.in]"
        )
        self.dlg.label_71.setToolTip(
            "Define processed magnetic data projection system [EPSG:4326]\n\n[anomalies.magn.proj.out]"
        )
        self.dlg.mQgsSpinBox_mesh_south.setToolTip(
            "Define minimum Northing value for model grid (not taking into account the padding)\n\n[#mesh.south]"
        )
        self.dlg.mQgsSpinBox_mesh_east.setToolTip(
            "Define minimum Easting value for model grid (not taking into account the padding)\n\n[#mesh.east]"
        )
        self.dlg.mQgsSpinBox_mesh_west.setToolTip(
            "Define maximum Easting value for model grid (not taking into account the padding)\n\n[#mesh.west]"
        )
        self.dlg.mQgsSpinBox_mesh_north.setToolTip(
            "Define maximum Northing value for model grid (not taking into account the padding)\n\n[#mesh.north]"
        )
        self.dlg.mQgsSpinBox_mesh_size_x.setToolTip(
            "Define model grid x cell dimension\n\n[#mesh.cellx]"
        )
        self.dlg.mQgsSpinBox_mesh_size_y.setToolTip(
            "Define model grid x cell dimension\n\n[#mesh.celly]"
        )
        self.dlg.mQgsSpinBox_mesh_padding.setToolTip(
            "Define uniform padding distance around model\n\n[#mesh.padding]"
        )
        self.dlg.nx_label.setToolTip(
            "Number of model grid cells in the x direction (this will be calculated from the cell dimensions and model extents)\n\n[modelGrid.size]"
        )
        self.dlg.ny_label.setToolTip(
            "Number of model grid cells in the y direction (this will be calculated from the cell dimensions and model extents)\n\n[modelGrid.size]"
        )
        self.dlg.nz_label.setToolTip(
            "Number of model grid cells in the z direction (this will be calculated from the cell dimensions and model extents)\n\n[modelGrid.size]"
        )
        self.dlg.memory_label.setToolTip(
            "Estimate of the memory required in GB to run the inversion, based on: 8 * nx * ny * nz * ndata * compression"
        )
        self.dlg.mQgsSpinBox_major_iters.setToolTip(
            "Number of major iterations of inversion to run, unless minimum residual value if data error is reached\n\n[inversion.nMajorIterations]"
        )
        self.dlg.mQgsSpinBox_minor_iters.setToolTip(
            "Number of minor iterations of inversion to run per major iteration\n\n[inversion.nMinorIterations]"
        )
        self.dlg.mQgsSpinBox_model_save_iters.setToolTip(
            "spacing between major iterations to save model outputs (0 means only save final model)\n\n[inversion.writeModelEveryNiter]"
        )
        self.dlg.lineEdit_output_directory_path_select.setToolTip(
            "Select or create directory that will store all data, model grid and parfiles, then process data, dtm and model grid files\n\n[global.outputFolderPath]"
        )
        self.dlg.pushButton_select_dtm_path.setToolTip(
            "Load TIF format Digital Terrane Model\n\n[global.elevFilename]"
        )
        self.dlg.pushButton_param_load_path.setToolTip(
            "Optional: Load existing parfile as the basis for updating an experiment"
        )
        self.dlg.pushButton_assign_magn_fields.setToolTip(
            "Assign x,y,data fields defined above"
        )
        self.dlg.pushButton_load_grav_data.setToolTip(
            "Load gravity data as QGIS Layer\n\n[anomalies.grav.data.file]"
        )

        self.dlg.pushButton_load_magn_data.setToolTip(
            "Load magnetic data as QGIS Layer\n\n[anomalies.magn.data_file]"
        )
        self.dlg.pushButton_grav_data_path.setToolTip(
            "Select a gravity dataset in csv, tif or ers format\n\n[anomalies.grav.data.file]"
        )
        self.dlg.pushButton_magn_data_path.setToolTip(
            "Select a magnetic dataset in csv, tif or ers format\n\n[anomalies.magn.data_file]"
        )
        self.dlg.pushButton_assign_grav_fields.setToolTip(
            "Assign x,y,data fields defined above"
        )
        self.dlg.radioButton_grav_inv.setToolTip(
            "Define parameters for gravity inversion experiemnt"
        )
        """self.dlg.radioButton_elev_const.setToolTip(
            "Assume constant elevaiton for ground surface"
        )"""
        """self.dlg.radioButton_elev_dtm.setToolTip(
            "Define ground topography by loading a TIF format Digital Terrane Model"
        )"""
        self.dlg.radioButton_magn_inv.setToolTip(
            "Define parameters for magnetic inversion experiemnt"
        )
        self.dlg.radioButton_joint_inv.setToolTip(
            "Define parameters for joint gravity-magnetic inversion experiemnt"
        )
        self.dlg.radioButton_magn_depth_based_weighting.setToolTip(
            "Select depth-based ADMM constraints\n\n[inversion.admm.magn.enableADMM]"
        )
        self.dlg.radioButton_magn_dist_based_weighting.setToolTip(
            "Select distance-based ADMM constraints"
        )
        self.dlg.radioButton_grav_depth_based_weighting.setToolTip(
            "Select depth-based ADMM constraints\n\n[inversion.admm.grav.enableADMM]"
        )
        self.dlg.radioButton_grav_dist_based_weighting.setToolTip(
            "Select distance-based ADMM constraints"
        )
        self.dlg.spinBox_grav_number_ADMM_litho.setToolTip(
            "Number of distinct pairs of ADMM density upper and lower bounds\n\n[inversion.admm.grav.nLithologies]"
        )
        self.dlg.spinBox_magn_ADMM_number_litho.setToolTip(
            "Number of distinct pairs of ADMM magnetic susceptibility upper and lower bounds\n\n[inversion.admm.magn.nLithologies]"
        )
        self.dlg.textEdit_experiment_description.setToolTip(
            "Provide free-form metadata for experiment\n\n[global.description]"
        )
        self.dlg.textEdit_grav_ADMM_bounds.setToolTip(
            "Space separated pairs of upper and lower ADMM density bounds\n\n[inversion.admm.grav.bounds]"
        )
        self.dlg.textEdit_min_residual.setToolTip(
            "Residual data error threshold before inversion stops\n\n[inversion.minResidual]"
        )
        self.dlg.textEdit_5_magn_ADMM_bounds.setToolTip(
            "Space separated pairs of upper and lower ADMM magnetic susceptibility bounds\n\n[inversion.admm.magn.bounds]"
        )

        # ------------------------new tootips--------------------------------------------------
        self.dlg.doubleSpinBox_magn_sensor_height.setToolTip(
            "Height of mag sensor above DTM, assumes draped survey at const height\n\n[global.magn_sensor_height]"
        )
        self.dlg.doubleSpinBox_grav_sensor_height.setToolTip(
            "Height of grav sensor above DTM, assumes draped survey at const height\n\n[global.grav_sensor_height]"
        )
        self.dlg.dateEdit.setToolTip(
            "Date of Mag Survey, used for auto IGRF calculation"
        )
        self.dlg.lineEdit_ROI_path_select.setToolTip(
            "Load a shapefile to define x,y limts of Mesh (converts max/min extents of shape into a rectangle)"
        )
        self.dlg.pushButton_calc_IGRF.setToolTip(
            "Generates estimated Magnetic Field parameters based on height of sensor, date of survey and centroid of Mesh\n\n[]"
        )
        self.dlg.doubleSpinBox_mag_dec.setToolTip(
            "Manual overide of Magnetic Declination\n\n[forward.magneticField.declination]"
        )
        self.dlg.doubleSpinBox_mag_inc.setToolTip(
            "Manual overide of Magnetic Inclination\n\n[forward.magneticField.inclination]"
        )
        self.dlg.doubleSpinBox_mag_int.setToolTip(
            "Manual overide of Magnetic Intensity\n\n[forward.magneticField.intensity]"
        )

        self.dlg.pushButton_select_tomoPath.setToolTip(
            "Select path to tomofast executable, e.g. '/opt/homebrew/bin/tomofastx'"
        )
        self.dlg.pushButton_2_select_parfilePath.setToolTip(
            "Select a parfile to run the inversion (prefilled with the parfile created by this plugin)"
        )
        self.dlg.pushButton_select_setvars.setToolTip(
            "Select setvars.bat file \n(usually at C:\Program Files (x86)\Intel\oneAPI\setvars.bat)"
        )
        self.dlg.lineEdit_2_mpirunPath_2.setToolTip(
            "Path to mpirun or mpiexec.exe executable, if not in PATH, \n e.g. for MacOS'/opt/homebrew/bin/mpirun' or \n Windows C:\\Program Files (x86)\\Intel\\oneAPI\\mpi\\2021.17\\bin\\mpiexec.exe"
        )

        self.dlg.lineEdit_pre_command_2_WSL_Distro.setToolTip(
            "Name of WSL Distro to run the inversion in, e.g. 'Ubuntu-20.04' (Windows WSL only)\nIt will be the element after \\wsl.localhost\ in a windows path to the WSL disk"
        )
        self.dlg.mQgsSpinBox_noProc.setToolTip(
            "Number of processors to use for inversion (If more than 1 requires openmpi to be installed)"
        )
        self.dlg.pushButton_3_runInversion.setToolTip(
            "Run the inversion using the parameters defined in the parfile"
        )
        self.dlg.pushButton_3_visualise.setToolTip(
            "Visualise X-Y-Z slices of output model\nRequires pyvtk to be installed in QGIS"
        )

        self.dlg.pushButton_kernel_path_select.setToolTip(
            "Select path to directory containing prior sensitivity kernel to reuse\n\n[sensit.folderPath]"
        )
        self.dlg.pushButton_3_Export.setToolTip("Export 3D model as csv file")

    def show_version(self):
        metadata_path = os.path.dirname(os.path.realpath(__file__)) + "/metadata.txt"

        with open(metadata_path) as plugin_version_file:
            metadata = plugin_version_file.readlines()
            for line in metadata:
                parts = line.split("=")
                if len(parts) == 2 and parts[0] == "version":
                    plugin_version = parts[1]

            return plugin_version

    def initialise_variables(self):
        self.global_experimentType = 1
        self.modelGrid_grav_file = ""
        self.global_outputFolderPath = ""
        self.global_description = ""
        self.forward_data_grav_nData = 0
        self.forward_data_grav_dataGridFile = ""
        # self.forward_data_grav_dataValuesFile = ""
        self.modelGrid_magn_file = ""
        self.forward_data_magn_nData = 0
        self.forward_data_magn_dataGridFile = ""
        # self.forward_data_magn_dataValuesFile = ""
        self.forward_depthWeighting_grav_type = 1
        self.forward_depthWeighting_magn_type = 1
        self.forward_depthWeighting_grav_power = 2
        self.forward_depthWeighting_magn_power = 3
        self.sensit_readFromFiles = 0
        self.forward_matrixCompression_type = 1
        self.forward_matrixCompression_rate = 0.1
        self.inversion_priorModel_type = 0
        self.inversion_priorModel_grav_value = 0
        self.inversion_startingModel_type = 0
        self.inversion_startingModel_grav_value = 0
        self.inversion_nMajorIterations = 3
        self.inversion_nMinorIterations = 100
        self.inversion_writeModelEveryNiter = 0
        self.inversion_minResidual = 1e-13
        self.inversion_modelDamping_grav_weight = 0
        self.inversion_modelDamping_grav_normPower = 2
        self.inversion_modelDamping_magn_weight = 0
        self.inversion_modelDamping_magn_normPower = 2
        self.inversion_joint_grav_problemWeight = 1
        self.inversion_joint_magn_problemWeight = 0
        self.inversion_admm_grav_enableADMM = 0
        self.inversion_admm_grav_nLithologies = 0
        self.inversion_admm_grav_bounds = ""
        self.inversion_admm_grav_weight = 0
        self.inversion_admm_magn_enableADMM = 0
        self.inversion_admm_magn_nLithologies = 0
        self.inversion_admm_magn_bounds = ""
        self.inversion_admm_magn_weight = 0
        self.cell_x = 2000
        self.cell_y = 2000
        self.dz = 100
        self.padding = 10000
        self.z_coreDepth = 10000
        self.z_fullDepth = 20000
        self.filename_grav = ""
        self.filename_magn = ""
        self.grav_proj_in = "EPSG:4326"
        self.grav_proj_out = "EPSG:4326"
        self.magn_proj_in = "EPSG:4326"
        self.magn_proj_out = "EPSG:4326"
        self.global_elevType = 1
        self.global_elevFilename = ""
        self.modelGrid_size = [0, 0, 0]
        self.global_grav_dataUnitsMultiplier = 0.00001
        self.global_magn_dataUnitsMultiplier = 1
        self.global_grav_modelUnitsMultiplier = 1
        self.global_magn_modelUnitsMultiplier = 1
        self.meshBox = {
            "south": 6730000,
            "west": 430000,
            "north": 6790000,
            "east": 482000,
        }

        self.magn_SurveyDay = 1
        self.magn_SurveyMonth = 1
        self.magn_SurveyYear = 2000
        self.forward_magneticField_declination = 0
        self.forward_magneticField_inclination = -45
        self.forward_magneticField_intensity = 65000
        self.dataType = "points"
        self.global_grav_sensor_height = 0
        self.global_magn_sensor_height = 0
        self.paramfile_Path = ""
        self.suffix_known = False
        self.setvars_Path = ""
