# -*- coding: utf-8 -*-
"""
/***************************************************************************
Layer to labeled layer
                                 A QGIS plugin
Make it possible to use data-defined labeling on existing layer.
The plug-in creates new attributes in the existing shapefile.
                             -------------------
        begin                : 2012-11-01
        copyright            : (C) 2012 by Victor Axbom
        email                : -
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         * 
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
# Initialize Qt resources from file resources.py
import resources
import shutil
import os
# Import the code for the dialog
from toLabeledLayerdialog import ToLabeledLayerdialog

class ToLabeledLayer:

	def __init__(self, iface):
		# Save reference to the QGIS interface
		self.iface = iface
		
		self.plugin_path = os.path.abspath(__file__)
		self.plugin_dir = os.path.dirname(self.plugin_path)

	def initGui(self):
		# Create action that will start plugin configuration
		self.action = QAction(QIcon(self.plugin_dir+"/icon.svg"), \
			"Layer to labeled layer", self.iface.mainWindow())
		# connect the action to the run method
		QObject.connect(self.action, SIGNAL("triggered()"), self.run)

		# Add toolbar button and menu item
		self.iface.addToolBarIcon(self.action)
		self.iface.addPluginToMenu("Layer to labeled layer", self.action)

	def unload(self):
		# Remove the plugin menu item and icon
		self.iface.removePluginMenu("Layer to labeled layer",self.action)
		self.iface.removeToolBarIcon(self.action)

	def run(self):
	
		#Get and check selected layer
		self.layer = self.iface.activeLayer()
		if self.layer == None or self.layer.type() != QgsMapLayer.VectorLayer or self.layer.hasGeometryType() == False:
			self.iface.messageBar().pushMessage("Could not proceed", "There is no vector layer selected.", level=2, duration=4)
			return
		
		#Check the editing cababilities
		self.ldp = self.layer.dataProvider()
			#bitwise and
		if not ((self.ldp.capabilities() & self.ldp.AddAttributes) and (self.ldp.capabilities() & self.ldp.ChangeAttributeValues)):
			QMessageBox.warning(None, "Could not proceed...", "The selected layer doesn't have the capability to add new attributes or attribute values.\n\n"
								"Possible reasons:\n"
								"- The data type (%s) provider doesn't support this cababilities. Save to a new format and try again. \n"
								"- A query might have restricted the cababilities, remove the query and try again.\n"
								"- No write access to the layer." % self.layer.storageType())
			return
		
		
		# create the dialog
		self.dlg = ToLabeledLayerdialog(self.ldp)
	
		# show the dialog
		if self.dlg.exec_():
			self.createAttributes()
			self.layer.updateFields()
			self.setTextSettings()
			self.iface.mapCanvas().refresh()
			
			
	
	def createAttributes(self):

		def_fields = [
							QgsField("LblSize",QVariant.Int,"integer",3),
							QgsField("LblColor",QVariant.String,"varchar",7),
							QgsField("LblBold",QVariant.Int,"integer",1),
							QgsField("LblItalic",QVariant.Int,"integer",1),
							QgsField("LblUnderl",QVariant.Int,"integer",1),
							QgsField("LblStrike",QVariant.Int,"integer",1),
							QgsField("LblFont",QVariant.String,"varchar",100),
							QgsField("LblX",QVariant.Double,"numeric",20,5),
							QgsField("LblY",QVariant.Double,"numeric",20,5),
							QgsField("LblSclMin",QVariant.Int,"integer",10),
							QgsField("LblSclMax",QVariant.Int,"integer",10),
							QgsField("LblAlignH",QVariant.String,"varchar",15),
							QgsField("LblAlignV",QVariant.String,"varchar",15),
							QgsField("LblRot",QVariant.Double,"numeric",20,5)
						]
							
		field_list = []

		for fld in def_fields:
			if self.ldp.fieldNameIndex(fld.name()) == -1:
				field_list.append(fld)
				
		if len(field_list) > 0:
			self.ldp.addAttributes(field_list)
		
	def setTextSettings(self):
		
		self.layer.setCustomProperty("labeling", "pal")
		self.layer.setCustomProperty("labeling/enabled", "true")
		self.layer.setCustomProperty("labeling/fontFamily", "Arial")
		self.layer.setCustomProperty("labeling/fontSize", "10")
		self.layer.setCustomProperty("labeling/scaleVisibility", "true")
		self.layer.setCustomProperty("labeling/fieldName", self.dlg.labelfield.currentText())
		#To make line labels visible
		if self.layer.geometryType() == QGis.Line:
			self.layer.setCustomProperty("labeling/placement", "2")
		
		self.layer.setCustomProperty("labeling/dataDefined/Size", "LblSize")
		self.layer.setCustomProperty("labeling/dataDefined/Bold", "LblBold")
		self.layer.setCustomProperty("labeling/dataDefined/Italic", "LblItalic")
		self.layer.setCustomProperty("labeling/dataDefined/Underline", "LblUnderl")
		self.layer.setCustomProperty("labeling/dataDefined/Color", "LblColor")
		self.layer.setCustomProperty("labeling/dataDefined/Strikeout", "LblStrike")
		self.layer.setCustomProperty("labeling/dataDefined/Family", "LblFont")
		self.layer.setCustomProperty("labeling/dataDefined/PositionX", "LblX")
		self.layer.setCustomProperty("labeling/dataDefined/PositionY", "LblY")
		self.layer.setCustomProperty("labeling/dataDefined/MinScale", "LblSclMin")
		self.layer.setCustomProperty("labeling/dataDefined/MaxScale", "LblSclMax")
		self.layer.setCustomProperty("labeling/dataDefined/Hali", "LblAlignH")
		self.layer.setCustomProperty("labeling/dataDefined/Vali", "LblAlignV")
		self.layer.setCustomProperty("labeling/dataDefined/Rotation", "LblRot")
