# -*- coding: utf-8 -*-

"""
/***************************************************************************
 CarbonCalculator
                                 A QGIS plugin
 The Carbon Calculator plugin takes point cloud and chm files, and returns an estimate of the carbon density based on different biomes
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-12-15
        copyright            : (C) 2025 by Vitor Di Lorenzzi Nunes da Cunha
        email                : vitordilorenzzi1@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Vitor Di Lorenzzi Nunes da Cunha'
__date__ = '2025-12-15'
__copyright__ = '(C) 2025 by Vitor Di Lorenzzi Nunes da Cunha'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect

from qgis.core import QgsProcessingAlgorithm, QgsApplication #type:ignore
from .processing_provider.tnc_carbon_calculator_provider import CarbonCalculatorProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0] #type:ignore

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class CarbonCalculatorPlugin(object):

    def __init__(self):
        self.provider = None

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = CarbonCalculatorProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
