# -*- coding: utf-8 -*-

"""
/***************************************************************************
 CarbonCalculator
                                 A QGIS plugin
 The Carbon Calculator plugin takes point cloud and chm files, and returns an estimate of the carbon density based on different biomes
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-12-22
        copyright            : (C) 2025 by Vitor Di Lorenzzi Nunes da Cunha
        email                : vitordilorenzzi1@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Vitor Di Lorenzzi Nunes da Cunha'
__date__ = '2025-12-22'
__copyright__ = '(C) 2025 by Vitor Di Lorenzzi Nunes da Cunha'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessingProvider #type:ignore
from .tnc_carbon_amazonia_chm import TNC_Carbon_Amazonia_CHM
from .tnc_carbon_amazonia_point_cloud import TNC_Carbon_Amazonia_Point_Cloud
from .tnc_carbon_amazonia_dtm_dsm import TNC_Carbon_Amazonia_DTM_DSM

from .tnc_carbon_cerrado_chm import TNC_Carbon_Cerrado_CHM
from .tnc_carbon_cerrado_dtm_dsm import TNC_Carbon_Cerrado_DTM_DSM

from .tnc_carbon_atlantic_chm import TNC_Carbon_Atlantic_CHM
from .tnc_carbon_atlantic_dtm_dsm import TNC_Carbon_Atlantic_DTM_DSM

from .tnc_carbon_global_chm import TNC_Carbon_Global_CHM
from .tnc_carbon_global_dtm_dsm import TNC_Carbon_Global_DTM_DSM


class CarbonCalculatorProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        self.addAlgorithm(TNC_Carbon_Amazonia_CHM())
        #self.addAlgorithm(TNC_Carbon_Amazonia_Point_Cloud())
        self.addAlgorithm(TNC_Carbon_Amazonia_DTM_DSM())
        self.addAlgorithm(TNC_Carbon_Cerrado_CHM())
        self.addAlgorithm(TNC_Carbon_Cerrado_DTM_DSM())
        self.addAlgorithm(TNC_Carbon_Atlantic_CHM())
        self.addAlgorithm(TNC_Carbon_Atlantic_DTM_DSM())
        self.addAlgorithm(TNC_Carbon_Global_CHM())
        self.addAlgorithm(TNC_Carbon_Global_DTM_DSM())
        


    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'tnccc'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('TNC Carbon Calculator')

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        return QgsProcessingProvider.icon(self)

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name() + " (version 0.1.1)"
