# -*- coding: utf-8 -*-
"""
/***************************************************************************
 TitlePlotter-PhilippineLandTitles
                                 A QGIS plugin
 Title Plotter - Philippine Land Titles a custom QGIS plugin designed to automate the plotting of land parcels using the official Philippine land title format. Built specifically for geodetic engineers, GIS analysts, and real estate professionals, this tool allows users to input technical descriptions (bearing-distance or metes-and-bounds format) and instantly generate accurate parcel geometries.

The plugin intelligently interprets common Philippine survey notations—such as those from TCTs and OCTs—and supports both PRS92 and WGS84 coordinate systems. It simplifies boundary plotting by automating bearing parsing, distance conversion, and closing error checks.

Whether you're working with Cadastral maps, mother lots, or subdivisions, PH Land Title Plotter provides a reliable and streamlined solution—right inside QGIS.

Key Features:
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-05-31
        copyright            : (C) 2025 by isaacenage
        email                : isaacenagework@gmail.com
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""


# noinspection PyPep8Naming
def classFactory(iface):  # pylint: disable=invalid-name
    """Load TitlePlotterPhilippineLandTitles class from file title_plotter.

    :param iface: A QGIS interface instance.
    :type iface: QgsInterface
    """
    #
    from .title_plotter import TitlePlotterPhilippineLandTitles
    return TitlePlotterPhilippineLandTitles(iface)
