# About

The EO Time Series Viewer (EOTSV) is a QGIS Plugin to visualize and label Earth Observation (EO) time series data.

## Highlights

* Interactive visualization of Earth observation time series raster data
* Spatially synchronized maps for each observation date
* Multiple band combinations in parallel, e.g., True Color _and_ SWIR bands
* Multi-sensor support: separate render settings for separate image products
* Visualization of Spectral and Temporal Profiles
* Quick labeling of vector files

## Resources

* Documentation:
  [https://eo-time-series-viewer.readthedocs.io/en/latest](https://eo-time-series-viewer.readthedocs.io/en/latest)
* Repository:
  [https://github.com/jakimowb/eo-time-series-viewer](https://github.com/jakimowb/eo-time-series-viewer.git)

## How to cite?

**Publication**:

_Jakimow, B., van der Linden, S., Thiel, F., Frantz, D., & Hostert, P. (2020).
Visualizing and labeling dense multi-sensor earth observation time series: The EO Time Series Viewer.
Environmental Modelling & Software,
125._ [10.1016/j.envsoft.2020.104631](https://doi.org/10.1016/j.envsoft.2020.104631)

**QGIS Plugin**:

_Jakimow, B. (\<year\>). EO Time Series Viewer, version
\<version\>, [https://plugins.qgis.org/plugins/timeseriesviewerplugin](https://plugins.qgis.org/plugins/timeseriesviewerplugin)_

## Acknowledgements

The EO Time Series Viewer (EOTSV) is developed at Humboldt-Universität zu Berlin (Germany),
[Earth Observation Lab](https://hu-berlin.de/eo-lab).

As of 2024, the development of the EOTSV is being funded by the Earth Observation for Ecosystem Management
Group at Technical University Munich (TUM).

Earlier versions of the EOTSV were partly developed in the SenseCarbon project,
funded by the German Aerospace Centre (DLR) and granted by the Federal Ministry of Education and Research
(BMBF, grant no. 50EE1254). Between 2017 - 2019 the development of the EOTSV was supported by the
German Research Centre for Geosciences (GFZ) as part of the EnMAP Core Science Team activities,
funded by DLR and granted by the Federal Ministry of Economic Affairs and Energy (BMWi, grant no. 50EE1529),
and the Land Use Monitoring System (LUMOS) project, funded by the Belgian Science Policy
Office (BELSPO) as part of the Stereo-III research program (grant no. SR/01/349).
