# -*- coding: utf-8 -*-
"""
/***************************************************************************
 TimeEditorDialog
                                 A QGIS plugin
 Used to facilitate the editing of features with lifespan information
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-06-05
        git sha              : $Format:%H$
        copyright            : (C) GPL 3.0 2020 by Niklas Alt
        email                : niklas.alt [at] uni-marburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import csv
import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtCore import QThread, QCoreApplication
from qgis.core import Qgis

# Import worker for threading
from .time_editor_inspection_worker import TimeEditorInspectionWorker

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'time_editor_dialog_inspect.ui'))


class TimeEditorInspectDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, iface, parent=None):
        """Constructor."""
        super(TimeEditorInspectDialog, self).__init__(parent)
        self.iface = iface
        self.thread = None
        self.worker = None

        self.BOX_COL_INFO = [
            {
                "headers": ["fid", "fid2", "shared_id", "reason"],
                "types": ["Integer", "integer", "string", "string"]
            },
            {
                "headers": ["fid", "attribute", "reason"],
                "types": ["Integer", "string", "string"]
            },
            {
                "headers": ["fid", "fid2", "date", "reason", "area", "wkt_geometry"],
                "types": ["Integer", "Integer", "String", "String", "Real", "WKT"]
            },
            {
                "headers": ["fid", "reason"],
                "types": ["Integer", "String"]
            }
        ]

        self.csv_export_path = None
        self.current_errors = []
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.mFieldExpressionWidget.setLayer(self.iface.activeLayer())
        self.startButton.clicked.connect(self.run_worker)
        self.abortButton.clicked.connect(self.stop_worker)
        self.exportButton.clicked.connect(self.export_errors_to_csv)
        self.mQgsFileWidget.fileChanged.connect(self.set_csv_export_path)
        self.checkTypeComboBox.currentIndexChanged.connect(self.on_check_type_change)
        self.setup_ui_for_check_type()

    # Taken from plugin builder generated main file
    # noinspection PyMethodMayBeStatic

    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('TimeEditor', message)

    def run_worker(self):
        self.setup_ui_for_check_type()
        # Reduce logged errors to the header
        if len(self.current_errors) > 1:
            self.current_errors = [self.current_errors[0]]
        self.tableWidget.setSortingEnabled(False)
        layer = self.iface.activeLayer()
        self.abortButton.setEnabled(True)
        self.exportButton.setEnabled(False)
        self.reportTextEdit.setPlainText("")
        filter_expression = None
        if (self.mFieldExpressionWidget.isValidExpression()):
            filter_expression = self.mFieldExpressionWidget.expression()

        # TODO: Should all run in dialog code
        # TODO: Initialize from the ui selection
        worker = TimeEditorInspectionWorker(
            # self.iface,
            layer, 
            self.checkTypeComboBox.currentIndex(),
            filter_expression,
            self.doubleSpinBox.value())
        thread = QThread()
        worker.moveToThread(thread)
        worker.finished.connect(self._inspectionWorkerFinished)
        worker.error.connect(self._inspectionWorkerError)
        worker.progress.connect(self.progressBar.setValue)
        worker.progressFeature.connect(self.progressBarFeature.setValue)
        worker.message.connect(self.reportTextEdit.insertPlainText)
        worker.validationIssue.connect(self._add_validation_issue)
        worker.refreshMap.connect(self.refreshCanvas)
        worker.selectIds.connect(self.reselectIds)
        thread.started.connect(worker.run)
        thread.start()
        self.thread = thread
        self.worker = worker

    def stop_worker(self):
        self.abortButton.setEnabled(False)
        # TODO: Reset the previous state (resetting layer filter to '' and original selection)
        if self.worker:
            self.worker.kill()
            try:
                self.worker.deleteLater()
            except:
                pass
        if self.thread:
            try:
                self.thread.quit()
                self.thread.wait()
                self.thread.deleteLater()
            except:
                pass
        self.tableWidget.setSortingEnabled(True)


    def on_check_type_change(self):
        self.stop_worker()
        self.setup_ui_for_check_type()

    def reselectIds(self, ids):
        self.iface.activeLayer().select(ids)

    def setup_ui_for_check_type(self):
        # self.stop_worker()
        self.tableWidget.clear()
        self.reportTextEdit.clear()
        self.progressBar.setValue(0)
        self.tableWidget.setRowCount(0)
        box_index = self.checkTypeComboBox.currentIndex()
        # reset the actual errors (for csv export) with header
        self.current_errors = [
            self.BOX_COL_INFO[box_index]["headers"]
        ]
        self.tableWidget.setColumnCount(
            len(self.BOX_COL_INFO[box_index]["headers"]))
        self.tableWidget.setHorizontalHeaderLabels(
            self.BOX_COL_INFO[box_index]["headers"])
        # self.tableWidget.horizontalHeader.
        if box_index == 2:
            self.progressBarFeature.show()
            self.labelMinIntersection.show()
            self.doubleSpinBox.show()
        else:
            self.progressBarFeature.hide()
            self.labelMinIntersection.hide()
            self.doubleSpinBox.hide()

    def refreshCanvas(self):
        self.iface.mapCanvas().refresh()

    def _add_validation_issue(self, validation_errors):
        self.current_errors.append(validation_errors)
        rowPosition = self.tableWidget.rowCount()
        self.tableWidget.insertRow(rowPosition)
        for index, value in enumerate(validation_errors):
            self.tableWidget.setItem(
                rowPosition, index,
                # TODO: Allow for different types than string
                QtWidgets.QTableWidgetItem(str(value))
            )

    def export_errors_to_csv(self):
        box_index = self.checkTypeComboBox.currentIndex()
        with open(self.csv_export_path, "w+") as fh:
            writer = csv.writer(fh)
            # writer.writerow(["Error", "feature_id", "common_id"])
            for _err in self.current_errors:
                writer.writerow(_err)
        # Create a sidecar
        with open(self.csv_export_path + "t", "w+") as fh:
            fh.write(",".join(self.BOX_COL_INFO[box_index]["types"]))

        self.iface.messageBar().pushMessage(
            self.tr("Exported errors to {path}").format(path=self.csv_export_path), level=Qgis.Success)

    def set_csv_export_path(self, path):
        self.csv_export_path = path
        if len(self.current_errors) > 0:
            self.exportButton.setEnabled(True)

    def _inspectionWorkerFinished(self):
        self.worker.deleteLater()
        self.thread.quit()
        self.thread.wait()
        self.thread.deleteLater()
        self.tableWidget.setSortingEnabled(True)
        if self.csv_export_path is not None and len(self.current_errors) > 0:
            self.exportButton.setEnabled(True)

    def _inspectionWorkerError(self, err):
        self.iface.messageBar().pushMessage(
            self.tr("WORKER ERROR: {err}").format(err=err), level=Qgis.Critical)
