# -*- coding: utf-8 -*-
"""
/***************************************************************************
 TimeEditorDialog
                                 A QGIS plugin
 Used to facilitate the editing of features with lifespan information
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-06-05
        git sha              : $Format:%H$
        copyright            : (C) GPL 3.0 2020 by Niklas Alt
        email                : niklas.alt [at] uni-marburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

# import QtGui

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtCore import QCoreApplication
# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'time_editor_dialog_base.ui'))


class TimeEditorBaseDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, iface, parent=None):
        """Constructor."""
        super(TimeEditorBaseDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.errorMessage.setStyleSheet("QLabel { color : red; }")
        self.iface = iface
        self.layer = iface.activeLayer()
        if self.layer is None:
            self.headingLabel.setText(
                "")
            self.errorMessage.setText(
                "Error: Please open and select a vector layer to configure."
            )
            self.button_box.button(
                QtWidgets.QDialogButtonBox.Ok).setEnabled(False)
            return None
        self.boxes = [self.primaryKeyComboBox, self.timeStartComboBox, self.timeEndComboBox, self.
                      documentationComboBox, self.commonIdComboBox]
        # self.attributeVals = iface.activeLayer().
        self.headingLabel.setText(
            self.headingLabel.text() + self.layer.sourceName())
        self.attributes = self._getAttributes()
        for box in self.boxes:
            self._applyAttributeNames(box, self.attributes)
        # self._applyAttributeNames(self.timeEndComboBox, self.attributes)
        # self._applyAttributeNames(self.documentationComboBox, self.attributes)
        # self._applyAttributeNames(self.commonIdComboBox, self.attributes)
        # TODO: move to sub-function
        self._setValueFromCustomProperty(self.primaryKeyComboBox, "te_pkey")
        self._setValueFromCustomProperty(
            self.timeStartComboBox, "te_time_start")
        self._setValueFromCustomProperty(self.timeEndComboBox, "te_time_end")
        self._setValueFromCustomProperty(
            self.documentationComboBox, "te_documentation")
        self._setValueFromCustomProperty(self.commonIdComboBox, "te_common_id")
        self._setFileFromCustomProperty(self.mQgsFileWidget, 'te_exception_csv_file')

        for box in self.boxes:
            box.currentTextChanged.connect(self._check_duplicates)

        # self.mQgsFileWidget.fileChanged.connect()

    # Taken from plugin builder generated main file
    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('TimeEditor', message)
        
    def _setFileFromCustomProperty(self, fileChooser, layer_property):
        if self.layer.customProperty(layer_property):
            fileChooser.setFilePath(self.layer.customProperty(layer_property))

    def _setValueFromCustomProperty(self, box, layer_property):
        if self.layer.customProperty(layer_property):
            box.setCurrentIndex(self.attributes.index(
                self.layer.customProperty(layer_property)))

    def _applyAttributeNames(self, box, attributes):
        for idx, attr in enumerate(attributes):
            box.insertItem(idx, attr)

    def _getAttributes(self):
        field_vals = [field.name() for field in self.layer.fields()]
        return field_vals

    def _check_duplicates(self):
        values = [box.currentText() for box in self.boxes]
        singles = []
        duplicates = []
        for val in values:
            if val not in singles:
                singles.append(val)
            else:
                if val not in duplicates:
                    duplicates.append(val)
        if len(list(set(values))) != len(self.boxes):
            self.errorMessage.setText(self.tr("FEHLER: Sie haben Attribute mehrfach ausgewählt:\n{attributes}").format(
                attributes=", ".join(duplicates)))
            return True
        self.errorMessage.setText("")
        return False

    def accept(self):
        if not self._check_duplicates():
            self.layer.setCustomProperty(
                "te_pkey", self.primaryKeyComboBox.currentText())
            self.layer.setCustomProperty(
                "te_time_start", self.timeStartComboBox.currentText())
            self.layer.setCustomProperty(
                "te_time_end", self.timeEndComboBox.currentText())
            self.layer.setCustomProperty(
                "te_documentation", self.documentationComboBox.currentText())
            self.layer.setCustomProperty(
                "te_common_id", self.commonIdComboBox.currentText())
            csv_path = self.mQgsFileWidget.filePath()
            self.layer.setCustomProperty(
                "te_exception_csv_file", csv_path)
            # create the CSV exception file if not present yet
            if not os.path.exists(csv_path) and csv_path.strip() != "":
                with open(csv_path, "w+") as fh:
                    fh.write("fid1,fid2,comment\n")
                    fh.close()

            # TODO: this does not look like best practice: how to
            # intercept QDialog on OK?
            self.done(1)
            return True
        else:
            return False
