# Tile Boundary Layer Plugin

QGIS用のタイル境界表示プラグインです。地図のパンやズームに応じて、リアルタイムでWebメルカトルタイル境界を表示します。

## 機能

- **リアルタイム更新**: 地図を移動・拡大縮小すると自動的にタイル境界が更新されます
- **自動ズーム検出**: 現在の地図スケールから適切なタイルズームレベルを自動計算
- **タイル座標表示**: 各タイルに z/x/y 形式の座標ラベルを表示
- **簡単操作**: ツールバーボタンまたはメニューから簡単にオン/オフ切り替え

## インストール方法

1. 本リポジトリのCode → Download ZIPで`tile-boundary-layer-plugin-main.zip`をダウンロード
2. QGISを起動
3. **プラグイン** → **プラグインの管理とインストール**
4. **ZIPファイルからインストール** タブを選択
5. `tile-boundary-layer-plugin-main.zip` ファイルを選択してインストール
6. **インストール済み** タブで「Tile Boundary Layer」を有効化

## 使用方法

1. プラグインを有効化すると、ツールバーにタイルグリッドアイコンが表示されます
2. アイコンをクリックするか、**プラグイン** → **Tile Boundary Layer** → **タイル境界レイヤ表示切り替え** を選択
3. タイル境界が赤い線で表示され、各タイルの中央に座標ラベルが表示されます
4. 地図をパンまたはズームすると、タイル境界が自動的に更新されます
5. 再度アイコンをクリックするか、**プラグイン** → **Tile Boundary Layer** → **タイル境界レイヤ表示切り替え** を選択すると、表示を停止できます

## 技術仕様

- **対応QGIS**: 3.0以上
- **座標系**: EPSG:3857 (Web Mercator)
- **タイルサイズ**: 256 x 256 ピクセル

## 開発者向け情報

プラグインの構成：
- `__init__.py`: プラグインエントリーポイント
- `tile_boundary_layer_plugin.py`: メインプラグインクラス
- `tile_boundary_layer_manager.py`: タイルレイヤ管理ロジック
- `metadata.txt`: プラグインメタデータ
- `icon.png`: プラグインアイコン

## ライセンス

MIT License
