# -*- coding: utf-8 -*-
"""
/***************************************************************************
 TiffSliderDialog
                                 A QGIS plugin
 It slides Tiffs.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-12-04
        git sha              : $Format:%H$
        copyright            : (C) 2024 by RKIW
        email                : idgaf@dimanet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from PyQt5.QtWidgets import QDialog, QSlider, QVBoxLayout, QLabel, QComboBox, QPushButton
from PyQt5.QtCore import Qt
from qgis.core import QgsProject, QgsRasterLayer, QgsLayerTreeGroup

class TiffSliderDialog(QDialog):
    def __init__(self, iface):
        """Initialisiert den Dialog."""
        super().__init__()
        self.iface = iface
        self.tiff_layers = []
        self.setup_ui()
        self.populate_layer_groups()

    def setup_ui(self):
        """Setzt die Benutzeroberfläche auf."""
        self.setWindowTitle("Tiff Slider")
        self.resize(300, 150)
        
        # Widgets erstellen
        self.label_info = QLabel("Wähle eine Layergruppe:")
        self.combo_group = QComboBox()
        self.slider = QSlider(Qt.Horizontal)
        self.label_layer_index = QLabel("Aktueller Layer: ---")
        self.label_layer_name = QLabel("Layer-Name: ---")
        
        # Slider initialisieren
        self.slider.setMinimum(0)
        self.slider.valueChanged.connect(self.update_layers)

        # Layout setzen
        layout = QVBoxLayout()
        layout.addWidget(self.label_info)
        layout.addWidget(self.combo_group)
        layout.addWidget(self.label_layer_index)
        layout.addWidget(self.label_layer_name)
        layout.addWidget(self.slider)
        self.setLayout(layout)

        # Verbindung herstellen
        self.combo_group.currentIndexChanged.connect(self.on_group_selection)

    def populate_layer_groups(self):
        """Füllt die ComboBox mit allen Layergruppen."""
        self.combo_group.clear()  # Vorherige Auswahlmöglichkeiten löschen
        root = QgsProject.instance().layerTreeRoot()
        
        # Alle Gruppen aus dem Layer-Tree hinzufügen
        for group in root.children():
            if isinstance(group, QgsLayerTreeGroup):
                self.combo_group.addItem(group.name(), group)

    def on_group_selection(self, index):
        """Wird aufgerufen, wenn eine Gruppe in der ComboBox ausgewählt wird."""
        group = self.combo_group.itemData(index)
        if group:
            self.tiff_layers = [
                layer.layer()
                for layer in group.children()
                if isinstance(layer.layer(), QgsRasterLayer)
            ]
            
            if not self.tiff_layers:
                self.label_layer_index.setText("Keine Raster-Layer gefunden.")
                self.slider.setMaximum(0)
                return

            # Slider konfigurieren
            self.slider.setMaximum(len(self.tiff_layers) - 1)
            self.slider.setValue(0)
            self.update_layers(0)

    def update_layers(self, value):
        """Aktualisiert die Anzeige und Sichtbarkeit der Layer basierend auf dem Sliderwert."""
        if not self.tiff_layers:
            return

        current_layer = self.tiff_layers[value]
        self.label_layer_index.setText(f"Aktueller Layer: {value + 1} von {len(self.tiff_layers)}")
        self.label_layer_name.setText(f"Layer-Name: {current_layer.name()}")

        for i, layer in enumerate(self.tiff_layers):
            if i == value:
                layer.renderer().setOpacity(1.0)  # Aktueller Layer vollständig sichtbar
            else:
                layer.renderer().setOpacity(0.0)  # Andere Layer unsichtbar
            
            # Änderungen anwenden
            layer.triggerRepaint()
