"""
Time step widget
"""

import os

from PyQt5.QtCore import *
from PyQt5.QtGui import *
from PyQt5.QtWidgets import *
from qgis.PyQt import uic

from ..utilities import durationCheck


class StepWidget(QWidget):
    """Step widget in the crisis dialog"""

    def __init__(self, attr=None, parent=None):
        """Constructor

        :param attr: dictionnary of injection attributes
        :type attr: dict
        :param parent: widget parent
        :type parent: QWidget
        """
        super(StepWidget, self).__init__(parent)
        uic.loadUi(os.path.join(os.path.dirname(__file__), "step.ui"), self)
        self.patterns = [self.tr("year"), self.tr("month"), self.tr("day")]
        if isinstance(attr, dict):
            self.durationEdit.setText(
                attr["duree"]
                .replace("year", self.tr("year"))
                .replace("month", self.tr("month"))
                .replace("day", self.tr("day"))
            )
            self.stepEdit.setText(
                attr["pas_de_temps"]
                .replace("year", self.tr("year"))
                .replace("month", self.tr("month"))
                .replace("day", self.tr("day"))
            )
        else:
            self.durationEdit.setText("10 year".replace("year", self.tr("year")))
            self.stepEdit.setText("1 year".replace("year", self.tr("year")))

        self.deleteButton.clicked.connect(self.deleteLater)

    def attributes(self):
        """return a dict of attributes

        :return: dict of step attributes
        :rtype: dict
        """
        duree = durationCheck(
            self.durationEdit.text(), self.patterns, self.durationEdit
        )
        duree = (
            duree.replace(self.tr("year"), "year")
            .replace(self.tr("month"), "month")
            .replace(self.tr("day"), "day")
        )
        step = durationCheck(self.stepEdit.text(), self.patterns, self.stepEdit)
        step = (
            step.replace(self.tr("year"), "year")
            .replace(self.tr("month"), "month")
            .replace(self.tr("day"), "day")
        )
        if not duree or not step:
            raise ValueError(
                self.tr(
                    "Duration must contain unit like 'year', 'month' or 'day' (2 'day', '3.5 year' or '0.1 month')"
                )
            )

        return {"duree": duree, "pas_de_temps": step}
