"""Converts Thyrsis projects to spatialite databases

USAGE

    python -m thyrsis.sites_param path_to_Thyrsis_install

    lit le fichier sites_param.txt dans le répertoire d'installation de Thyrsis
"""
import codecs
import os
from builtins import str

from .database import sqlite
from .log import logger
from .settings import Settings


def sites_param(install_dir, meshdir):
    """Update sites param

    :param install_dir: install directory
    :type install_dir: string
    :param meshdir: mesh directory
    :type meshdir: string"""
    with codecs.open(
        os.path.join(install_dir, "sites_param.txt"), encoding="utf-8"
    ) as fil:
        next(fil)
        for line in fil:
            spl = line.split()
            mesh_conn = sqlite.connect(os.path.join(meshdir, spl[0] + ".mesh.sqlite"))
            mesh_cur = mesh_conn.cursor()
            logger.notice(os.path.join(meshdir, spl[0] + ".mesh.sqlite"), spl[1:])
            for i, p in enumerate(
                ["WC", "VGA", "VGN", "VGR", "VGS", "WT", "VM", "DLZNS", "DLZS", "WM"]
            ):
                logger.debug(i, spl[i + 1], p)
                mesh_cur.execute(
                    "UPDATE parametres SET valeur=? WHERE nom=?", (str(spl[i + 1]), p)
                )
            mesh_conn.commit()


if __name__ == "__main__":
    import sys

    from PyQt5.QtCore import *

    if len(sys.argv) == 2 and sys.argv[1] in ["-h", "--help"]:
        help(sys.modules[__name__])
        exit(0)

    logger.enable_console(True)
    logger.set_level("debug")

    QCoreApplication.setOrganizationName("QGIS")
    QCoreApplication.setOrganizationDomain("qgis.org")
    QCoreApplication.setApplicationName("QGIS2")

    if len(sys.argv) == 2:
        install_dir = sys.argv[1]

        meshdir = str(Settings().value("General", "defaultMeshDir"))

        sites_param(install_dir, meshdir)

    else:
        logger.error(
            "wrong number of arguments (try python -m thyrsis.sites_param --help)"
        )
        exit(1)
